/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.ExperimentalVelocityTrackerApi;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a!\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\f\u001a1\u0010\r\u001a\u00020\u0005*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0018H\u0000\u001a(\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0082\b\u001a\u0014\u0010%\u001a\u00020\u0014*\u00020\u00182\u0006\u0010&\u001a\u00020\u0018H\u0002\u001a\r\u0010'\u001a\u00020\u0014*\u00020\u0018H\u0082\b\u001a(\u0010(\u001a\f\u0012\b\u0012\u00060\u0018j\u0002`)0\u000e2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010,\u001a,\u0010-\u001a\u00020\u0014*\f\u0012\u0004\u0012\u00020\u00180\u000ej\u0002`.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00101\u001a4\u0010\r\u001a\u00020\u0005*\f\u0012\u0004\u0012\u00020\u00180\u000ej\u0002`.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0014H\u0082\n\u00a2\u0006\u0002\u00103\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"$\u00104\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\"$\u0010;\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b<\u00106\u001a\u0004\b=\u00108\"\u0004\b>\u0010:*\f\b\u0002\u0010$\"\u00020\u00182\u00020\u0018*\u0018\b\u0002\u0010(\"\b\u0012\u0004\u0012\u00020\u00180\u000e2\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a8\u0006?"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "HistorySize", "HorizonMilliseconds", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "offset", "Landroidx/compose/ui/geometry/Offset;", "addPointerInputChange-0AR0LA0", "(Landroidx/compose/ui/input/pointer/util/VelocityTracker;Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "set", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "time", "", "dataPoint", "", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "DefaultWeight", "polyFitLeastSquares", "", "x", "y", "sampleCount", "degree", "coefficients", "calculateImpulseVelocity", "dataPoints", "isDataDifferential", "", "kineticEnergyToVelocity", "kineticEnergy", "Vector", "dot", "a", "norm", "Matrix", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "value", "([[FIIF)V", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse$annotations", "getVelocityTrackerStrategyUseImpulse", "setVelocityTrackerStrategyUseImpulse", "ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,631:1\n593#1:632\n600#1,2:633\n596#1,6:635\n593#1:641\n593#1:642\n588#1:643\n575#1:645\n575#1:646\n69#2:644\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n412#1:632\n414#1:633,2\n416#1:635,6\n423#1:641\n425#1:642\n438#1:643\n560#1:645\n566#1:646\n438#1:644\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HistorySize = 20;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VelocityTrackerKt.addPointerInputChange-0AR0LA0($this$addPointerInputChange, event, Offset.Companion.getZero-F1C5BW0());
    }

    public static final void addPointerInputChange-0AR0LA0(@NotNull VelocityTracker $this$addPointerInputChange_u2d0AR0LA0, @NotNull PointerInputChange event, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange_u2d0AR0LA0, (String)"$this$addPointerInputChange");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        $this$addPointerInputChange_u2d0AR0LA0.getPlatformVelocityTracker$ui().addPointerInputChange-Uv8p0NA(event, offset);
    }

    private static final void set(DataPointAtTime[] $this$set, int index2, long time, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index2];
        if (currentEntry == null) {
            $this$set[index2] = new DataPointAtTime(time, dataPoint);
        } else {
            currentEntry.setTime(time);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] polyFitLeastSquares(@NotNull float[] x, @NotNull float[] y, int sampleCount, int degree, @NotNull float[] coefficients) {
        void rows$iv;
        void rows$iv2;
        int $i$f$set3;
        int col$iv;
        int i;
        void rows$iv3;
        int n;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (degree < 1) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= sampleCount ? sampleCount - 1 : degree;
        int m = sampleCount;
        int n2 = n = truncatedDegree + 1;
        int cols$iv2 = m;
        boolean $i$f$Matrix = false;
        int n3 = 0;
        float[][] fArrayArray = new float[rows$iv3][];
        while (n3 < rows$iv3) {
            int n4 = n3++;
            fArrayArray[n4] = new float[cols$iv2];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] cols$iv2 = a;
            $i$f$Matrix = false;
            n3 = h;
            float value$iv2 = 1.0f;
            boolean $i$f$set22 = false;
            $this$set$iv[row$iv2][col$iv2] = value$iv2;
            for (i = 1; i < n; ++i) {
                void row$iv;
                void $this$get$iv;
                float[][] row$iv2 = a;
                int col$iv2 = i;
                int value$iv2 = h;
                float[][] $i$f$set22 = a;
                int n5 = i - 1;
                col$iv = h;
                boolean $i$f$get = false;
                void value$iv222 = $this$get$iv[row$iv][col$iv] * x[h];
                $i$f$set3 = 0;
                $this$set$iv[row$iv][col$iv3] = value$iv222;
            }
        }
        i = n;
        int cols$iv3 = m;
        boolean $i$f$Matrix2 = false;
        int col$iv3 = 0;
        float[][] value$iv222 = new float[rows$iv2][];
        while (col$iv3 < rows$iv2) {
            $i$f$set3 = col$iv3++;
            value$iv222[$i$f$set3] = new float[cols$iv3];
        }
        float[][] q = value$iv222;
        cols$iv3 = n;
        int cols$iv4 = n;
        boolean $i$f$Matrix3 = false;
        int value$iv222 = 0;
        float[][] $i$f$set3 = new float[rows$iv][];
        while (value$iv222 < rows$iv) {
            col$iv = value$iv222++;
            $i$f$set3[col$iv] = new float[cols$iv4];
        }
        float[][] r = $i$f$set3;
        for (int j = 0; j < n; ++j) {
            void $this$fastCoerceAtLeast$iv;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i2 = 0; i2 < j; ++i2) {
                float[] z = q[i2];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n6 = h;
                    w[n6] = w[n6] - dot * z[h];
                }
            }
            float[] $this$norm$iv22 = w;
            boolean $i$f$norm = false;
            float $this$norm$iv22 = (float)Math.sqrt(VelocityTrackerKt.dot($this$norm$iv22, $this$norm$iv22));
            float minimumValue$iv2 = 1.0E-6f;
            boolean $i$f$fastCoerceAtLeast = false;
            float inverseNorm = 1.0f / ($this$fastCoerceAtLeast$iv < minimumValue$iv2 ? minimumValue$iv2 : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int minimumValue$iv2 = h++;
                w[minimumValue$iv2] = w[minimumValue$iv2] * inverseNorm;
            }
            float[] v = r[j];
            for (int i3 = 0; i3 < n; ++i3) {
                v[i3] = i3 < j ? 0.0f : VelocityTrackerKt.dot(w, a[i3]);
            }
        }
        float[] wy = y;
        for (int i4 = n - 1; -1 < i4; --i4) {
            float c = VelocityTrackerKt.dot(q[i4], wy);
            float[] ri = r[i4];
            int n7 = i4 + 1;
            int j = n - 1;
            if (n7 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == n7) break;
                    --j;
                }
            }
            coefficients[i4] = c / ri[i4];
        }
        return coefficients;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast((int)(n2 + 1), (int)0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start = sampleCount - 1;
        float nextTime = time[start];
        for (int i = start; 0 < i; --i) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time[i - 1])) continue;
            float dataPointsDelta = isDataDifferential ? -dataPoints[i - 1] : dataPoints[i] - dataPoints[i - 1];
            float vCurr = dataPointsDelta / (currentTime - nextTime);
            float kineticEnergy$iv = work;
            boolean $i$f$kineticEnergyToVelocity = false;
            float vPrev = Math.signum(kineticEnergy$iv) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy$iv));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != start) continue;
            work *= 0.5f;
        }
        float kineticEnergy$iv = work;
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(kineticEnergy$iv) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy$iv));
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(kineticEnergy) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy));
    }

    private static final float dot(float[] $this$dot, float[] a) {
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result2 += $this$dot[i] * a[i];
        }
        return result2;
    }

    private static final float norm(float[] $this$norm) {
        boolean $i$f$norm = false;
        return (float)Math.sqrt(VelocityTrackerKt.dot($this$norm, $this$norm));
    }

    private static final float[][] Matrix(int rows, int cols) {
        boolean $i$f$Matrix = false;
        int n = 0;
        float[][] fArrayArray = new float[rows][];
        while (n < rows) {
            int n2 = n++;
            fArrayArray[n2] = new float[cols];
        }
        return fArrayArray;
    }

    private static final float get(float[][] $this$get, int row, int col) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        boolean $i$f$get = false;
        return $this$get[row][col];
    }

    private static final void set(float[][] $this$set, int row, int col, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        boolean $i$f$set = false;
        $this$set[row][col] = value;
    }

    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        VelocityTrackerAddPointsFix = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    public static final void setVelocityTrackerStrategyUseImpulse(boolean bl) {
        VelocityTrackerStrategyUseImpulse = bl;
    }

    @ExperimentalVelocityTrackerApi
    public static /* synthetic */ void getVelocityTrackerStrategyUseImpulse$annotations() {
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index2, long time, float dataPoint) {
        VelocityTrackerKt.set($receiver, index2, time, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time, sampleCount, isDataDifferential);
    }
}

