/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.query.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.polySymbols.PolySymbolQualifiedKind;
import com.intellij.polySymbols.PolySymbolQualifiedName;
import com.intellij.polySymbols.framework.PolySymbolFramework;
import com.intellij.polySymbols.query.PolySymbolNameConversionRules;
import com.intellij.polySymbols.query.PolySymbolNameConverter;
import com.intellij.polySymbols.query.PolySymbolNamesProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/intellij/polySymbols/query/impl/PolySymbolNamesProviderImpl;", "Lcom/intellij/polySymbols/query/PolySymbolNamesProvider;", "framework", "", "Lcom/intellij/polySymbols/FrameworkId;", "configuration", "", "Lcom/intellij/polySymbols/query/PolySymbolNameConversionRules;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/util/ModificationTracker;)V", "canonicalNamesProviders", "", "Lcom/intellij/polySymbols/PolySymbolQualifiedKind;", "Lcom/intellij/polySymbols/query/PolySymbolNameConverter;", "matchNamesProviders", "completionVariantsProviders", "renameProviders", "polySymbolFramework", "Lcom/intellij/polySymbols/framework/PolySymbolFramework;", "getPolySymbolFramework", "()Lcom/intellij/polySymbols/framework/PolySymbolFramework;", "createPointer", "Lcom/intellij/model/Pointer;", "hashCode", "", "equals", "", "other", "", "getModificationCount", "", "withRules", "rules", "getNames", "qualifiedName", "Lcom/intellij/polySymbols/PolySymbolQualifiedName;", "target", "Lcom/intellij/polySymbols/query/PolySymbolNamesProvider$Target;", "adjustRename", "newName", "occurence", "intellij.platform.polySymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPolySymbolNamesProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolySymbolNamesProviderImpl.kt\ncom/intellij/polySymbols/query/impl/PolySymbolNamesProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1869#2:111\n1870#2:120\n216#3,2:112\n216#3,2:114\n216#3,2:116\n216#3,2:118\n1#4:121\n*S KotlinDebug\n*F\n+ 1 PolySymbolNamesProviderImpl.kt\ncom/intellij/polySymbols/query/impl/PolySymbolNamesProviderImpl\n*L\n41#1:111\n41#1:120\n42#1:112,2\n43#1:114,2\n44#1:116,2\n45#1:118,2\n*E\n"})
public final class PolySymbolNamesProviderImpl
implements PolySymbolNamesProvider {
    @Nullable
    private final String framework;
    @NotNull
    private final List<PolySymbolNameConversionRules> configuration;
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final Map<PolySymbolQualifiedKind, PolySymbolNameConverter> canonicalNamesProviders;
    @NotNull
    private final Map<PolySymbolQualifiedKind, PolySymbolNameConverter> matchNamesProviders;
    @NotNull
    private final Map<PolySymbolQualifiedKind, PolySymbolNameConverter> completionVariantsProviders;
    @NotNull
    private final Map<PolySymbolQualifiedKind, PolySymbolNameConverter> renameProviders;

    public PolySymbolNamesProviderImpl(@Nullable String framework, @NotNull List<? extends PolySymbolNameConversionRules> configuration, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        this.framework = framework;
        this.configuration = configuration;
        this.modificationTracker = modificationTracker;
        Map canonicalNamesProviders = new LinkedHashMap();
        Map matchNamesProviders = new LinkedHashMap();
        Map completionVariantsProviders = new LinkedHashMap();
        Map renameProviders = new LinkedHashMap();
        Iterable $this$forEach$iv = this.configuration;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry<PolySymbolQualifiedKind, PolySymbolNameConverter> it;
            Map.Entry<PolySymbolQualifiedKind, PolySymbolNameConverter> element$iv2;
            PolySymbolNameConversionRules config = (PolySymbolNameConversionRules)element$iv;
            boolean bl = false;
            Map<PolySymbolQualifiedKind, PolySymbolNameConverter> $this$forEach$iv2 = config.getCanonicalNames();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<PolySymbolQualifiedKind, PolySymbolNameConverter>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl2 = false;
                canonicalNamesProviders.putIfAbsent(it.getKey(), it.getValue());
            }
            $this$forEach$iv2 = config.getMatchNames();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl3 = false;
                matchNamesProviders.putIfAbsent(it.getKey(), it.getValue());
            }
            $this$forEach$iv2 = config.getCompletionVariants();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl4 = false;
                completionVariantsProviders.putIfAbsent(it.getKey(), it.getValue());
            }
            $this$forEach$iv2 = config.getRenames();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl5 = false;
                renameProviders.putIfAbsent(it.getKey(), it.getValue());
            }
        }
        this.canonicalNamesProviders = canonicalNamesProviders;
        this.matchNamesProviders = matchNamesProviders;
        this.completionVariantsProviders = completionVariantsProviders;
        this.renameProviders = renameProviders;
    }

    private final PolySymbolFramework getPolySymbolFramework() {
        PolySymbolFramework polySymbolFramework;
        String string = this.framework;
        if (string != null) {
            String it = string;
            boolean bl = false;
            polySymbolFramework = PolySymbolFramework.Companion.get(it);
        } else {
            polySymbolFramework = null;
        }
        return polySymbolFramework;
    }

    @Override
    @NotNull
    public Pointer<PolySymbolNamesProvider> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    public int hashCode() {
        String string = this.framework;
        return (string != null ? string.hashCode() : 0) * 31 + ((Object)this.configuration).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PolySymbolNamesProviderImpl && Intrinsics.areEqual((Object)((PolySymbolNamesProviderImpl)other).framework, (Object)this.framework) && Intrinsics.areEqual(((PolySymbolNamesProviderImpl)other).configuration, this.configuration);
    }

    public long getModificationCount() {
        return this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public PolySymbolNamesProvider withRules(@NotNull List<? extends PolySymbolNameConversionRules> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        return new PolySymbolNamesProviderImpl(this.framework, CollectionsKt.plus((Collection)rules, (Iterable)this.configuration), this.modificationTracker);
    }

    @Override
    @NotNull
    public List<String> getNames(@NotNull PolySymbolQualifiedName qualifiedName, @NotNull PolySymbolNamesProvider.Target target) {
        List list2;
        List list3;
        PolySymbolNameConverter polySymbolNameConverter;
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                polySymbolNameConverter = this.completionVariantsProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            case 2: {
                polySymbolNameConverter = this.canonicalNamesProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            case 3: {
                polySymbolNameConverter = this.matchNamesProviders.get(qualifiedName.getQualifiedKind());
                if (polySymbolNameConverter != null) break;
                polySymbolNameConverter = this.canonicalNamesProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            case 4: {
                polySymbolNameConverter = this.renameProviders.get(qualifiedName.getQualifiedKind());
                if (polySymbolNameConverter != null || (polySymbolNameConverter = this.matchNamesProviders.get(qualifiedName.getQualifiedKind())) != null) break;
                polySymbolNameConverter = this.canonicalNamesProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PolySymbolNameConverter polySymbolNameConverter2 = polySymbolNameConverter;
        if (polySymbolNameConverter2 != null && (list3 = polySymbolNameConverter2.getNames(qualifiedName.getName())) != null) {
            list2 = list3;
        } else {
            List list4;
            List list5;
            Object object = this.getPolySymbolFramework();
            if (object != null && (list5 = ((PolySymbolFramework)object).getNames(qualifiedName, target)) != null) {
                List list6;
                List it = list6 = list5;
                boolean bl = false;
                list4 = !((Collection)it).isEmpty() ? list6 : null;
            } else {
                list4 = list2 = null;
            }
            if (list4 == null) {
                if (target != PolySymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS && (Intrinsics.areEqual((Object)qualifiedName.getNamespace(), (Object)"css") || Intrinsics.areEqual((Object)qualifiedName.getNamespace(), (Object)"html"))) {
                    object = qualifiedName.getName();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string = ((String)object).toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    list2 = CollectionsKt.listOf((Object)string);
                } else {
                    list2 = CollectionsKt.listOf((Object)qualifiedName.getName());
                }
            }
        }
        return list2;
    }

    @Override
    @NotNull
    public String adjustRename(@NotNull PolySymbolQualifiedName qualifiedName, @NotNull String newName, @NotNull String occurence) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)occurence, (String)"occurence");
        if (Intrinsics.areEqual((Object)qualifiedName.getName(), (Object)occurence)) {
            return newName;
        }
        List<String> oldVariants = this.getNames(qualifiedName, PolySymbolNamesProvider.Target.RENAME_QUERY);
        int index = oldVariants.indexOf(occurence);
        if (index < 0) {
            return newName;
        }
        List<String> newVariants = this.getNames(qualifiedName.withName(newName), PolySymbolNamesProvider.Target.RENAME_QUERY);
        if (oldVariants.size() == newVariants.size()) {
            return newVariants.get(index);
        }
        return newName;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PolySymbolNamesProvider.Target.values().length];
            try {
                nArray[PolySymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PolySymbolNamesProvider.Target.NAMES_MAP_STORAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PolySymbolNamesProvider.Target.NAMES_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PolySymbolNamesProvider.Target.RENAME_QUERY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

