/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class AbstractComponent
implements Component {
    private final Style style;
    private final ISkinParam skinParam;

    @Override
    public final Style[] getUsedStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StyleSignatureBasic getStyleSignature() {
        throw new UnsupportedOperationException();
    }

    public AbstractComponent(Style style, ISkinParam skinParam) {
        this.style = style;
        this.skinParam = skinParam;
    }

    protected final Style getStyle() {
        return this.style;
    }

    protected final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    protected HColorSet getIHtmlColorSet() {
        return this.skinParam.getIHtmlColorSet();
    }

    protected final Fashion getSymbolContext() {
        return this.style.getSymbolContext(this.getIHtmlColorSet());
    }

    protected final Fashion getSymbolContext(Colors colors) {
        return this.style.getSymbolContext(this.getIHtmlColorSet(), colors);
    }

    private final HColor getColor(PName name) {
        return this.style.value(name).asColor(this.getIHtmlColorSet());
    }

    protected final HColor getColorFont() {
        return this.getColor(PName.FontColor);
    }

    protected final HColor getColorLine() {
        return this.getColor(PName.LineColor);
    }

    protected final HColor getColorBackGround() {
        return this.getColor(PName.BackGroundColor);
    }

    protected final double getRoundCorner() {
        return this.style.value(PName.RoundCorner).asInt(false);
    }

    protected final double getDiagonalCorner() {
        return this.style.value(PName.DiagonalCorner).asInt(false);
    }

    protected final UStroke getStroke() {
        return this.style.getStroke();
    }

    protected final double getShadowing() {
        return this.style.getShadowing();
    }

    protected final UFont getUFont() {
        return this.style.getUFont();
    }

    protected final FontConfiguration getFontConfiguration() {
        return this.style.getFontConfiguration(this.getIHtmlColorSet());
    }

    protected final HorizontalAlignment getHorizontalAlignment() {
        return this.style.getHorizontalAlignment();
    }

    protected abstract void drawInternalU(UGraphic var1, Area var2);

    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
    }

    @Override
    public final void drawU(UGraphic ug, Area area, Context2D context) {
        ug = ug.apply(new UTranslate(this.getPaddingX(), this.getPaddingY()));
        if (context.isBackground()) {
            this.drawBackgroundInternalU(ug, area);
        } else {
            this.drawInternalU(ug, area);
        }
    }

    public double getPaddingX() {
        return 0.0;
    }

    public double getPaddingY() {
        return 0.0;
    }

    @Override
    public abstract double getPreferredWidth(StringBounder var1);

    @Override
    public abstract double getPreferredHeight(StringBounder var1);

    @Override
    public final XDimension2D getPreferredDimension(StringBounder stringBounder) {
        double w = this.getPreferredWidth(stringBounder);
        double h = this.getPreferredHeight(stringBounder);
        return new XDimension2D(w, h);
    }
}

