---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: XSLT Injection
---

## Description

It is possible to supply an XSL template to a server-side XSLT processor. XSLT processors can
be abused to read or write files, initiate outbound connections, and in some cases execute
arbitrary code.

## Remediation

Applications should never accept user-supplied style sheets. XSLT processors are not built to
handle potentially malicious stylesheet files. However, some processors do implement or offer
security features which may be available. Consult the documentation for the XSLT processor
used by the target application for security guidelines and hardening steps. It is recommended
that all XML parsers and processors at the very least disable external entity resolution.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 74.1 | false | 74 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/74.html)
