/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ColorParser {
    COMMA_DELIMITED_RGBA,
    HEX_RGBA,
    COMMA_DELIMITED_RGB,
    HEX_RGB,
    HEX_RGB_TRUNC;

    static final Pattern COMMA_DELIMITED_RGB_WITH_ALPHA_PATTERN;
    static final Pattern HEX_RGBA_PATTERN;
    static final Pattern COMMA_DELIMITED_RGB_PATTERN;
    static final Pattern HEX_RGB_PATTERN;
    static final Pattern HEX_RGB_TRUNC_PATTERN;

    private String toHexString(int val) {
        String result = Integer.toHexString(val);
        if (this.isShorthand()) {
            result = result.substring(0, 1);
        } else if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public String toString(Color color) {
        switch (this) {
            case COMMA_DELIMITED_RGB: {
                return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            }
            case COMMA_DELIMITED_RGBA: {
                return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha();
            }
            case HEX_RGB: 
            case HEX_RGB_TRUNC: {
                return '#' + this.toHexString(color.getRed()) + this.toHexString(color.getGreen()) + this.toHexString(color.getBlue());
            }
            case HEX_RGBA: {
                return '#' + this.toHexString(color.getRed()) + this.toHexString(color.getGreen()) + this.toHexString(color.getBlue()) + this.toHexString(color.getAlpha());
            }
        }
        throw new AssertionError((Object)this);
    }

    static Color parse(String s) {
        for (ColorParser cp : ColorParser.values()) {
            Color result;
            Pattern p = cp.pattern();
            Matcher m = p.matcher(s);
            if (!m.find() || (result = cp.doParse(s, m)) == null) continue;
            return result;
        }
        return null;
    }

    public boolean isHex() {
        switch (this) {
            case HEX_RGB: 
            case HEX_RGB_TRUNC: 
            case HEX_RGBA: {
                return true;
            }
        }
        return false;
    }

    public boolean containsAlpha() {
        switch (this) {
            case COMMA_DELIMITED_RGBA: 
            case HEX_RGBA: {
                return true;
            }
        }
        return false;
    }

    public boolean isShorthand() {
        return this == HEX_RGB_TRUNC;
    }

    private int parseHex(String s) {
        if (this.isShorthand() && s.length() == 1) {
            s = s + "0";
        }
        return Integer.parseInt(s, 16);
    }

    Color doParse(String s) {
        Matcher m = this.pattern().matcher(s);
        if (m.find()) {
            return this.doParse(s, m);
        }
        return null;
    }

    Color doParse(String s, Matcher m) {
        int a = 255;
        try {
            int b;
            int g;
            int r;
            if (this.isHex()) {
                r = this.parseHex(m.group(1));
                g = this.parseHex(m.group(2));
                b = this.parseHex(m.group(3));
                if (this.containsAlpha()) {
                    a = this.parseHex(m.group(4));
                }
            } else {
                r = Integer.parseInt(m.group(1));
                g = Integer.parseInt(m.group(2));
                b = Integer.parseInt(m.group(3));
                if (this.containsAlpha()) {
                    a = Integer.parseInt(m.group(4));
                }
            }
            return new Color(r, g, b, a);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean canParse(String s) {
        for (ColorParser cp : ColorParser.values()) {
            Pattern p = cp.pattern();
            Matcher m = p.matcher(s);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static String toMinimalString(Color c) {
        if (ColorParser.isShorthandFriendly(c)) {
            return HEX_RGB_TRUNC.toString(c);
        }
        if (c.getAlpha() != 255) {
            return HEX_RGBA.toString(c);
        }
        return HEX_RGB.toString(c);
    }

    private static boolean isShorthandFriendly(Color c) {
        if (c.getAlpha() != 255) {
            return false;
        }
        return ColorParser.isShorthandFriendly(c.getRed()) && ColorParser.isShorthandFriendly(c.getGreen()) && ColorParser.isShorthandFriendly(c.getBlue());
    }

    private static boolean isShorthandFriendly(int val) {
        return (val & 0xF0) == val;
    }

    Pattern pattern() {
        switch (this) {
            case COMMA_DELIMITED_RGB: {
                return COMMA_DELIMITED_RGB_PATTERN;
            }
            case COMMA_DELIMITED_RGBA: {
                return COMMA_DELIMITED_RGB_WITH_ALPHA_PATTERN;
            }
            case HEX_RGB: {
                return HEX_RGB_PATTERN;
            }
            case HEX_RGBA: {
                return HEX_RGBA_PATTERN;
            }
            case HEX_RGB_TRUNC: {
                return HEX_RGB_TRUNC_PATTERN;
            }
        }
        throw new AssertionError((Object)this);
    }

    static {
        COMMA_DELIMITED_RGB_WITH_ALPHA_PATTERN = Pattern.compile("^(\\d{1,3})\\s*?,\\s*?(\\d{1,3})\\s*?,\\s*?(\\d{1,3})\\s*?,\\s*?(\\d{1,3})\\s*$");
        HEX_RGBA_PATTERN = Pattern.compile("^#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$");
        COMMA_DELIMITED_RGB_PATTERN = Pattern.compile("^(\\d{1,3})\\s*?,\\s*?(\\d{1,3})\\s*?,\\s*?(\\d{1,3})\\s*$");
        HEX_RGB_PATTERN = Pattern.compile("^#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$");
        HEX_RGB_TRUNC_PATTERN = Pattern.compile("^#?([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])$");
    }
}

