<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>arg_parser_demo.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/demo/</path>
    <filename>a00442</filename>
    <includes id="a00457" name="arg_parser.h" local="no" imported="no">lemon/arg_parser.h</includes>
  </compound>
  <compound kind="file">
    <name>graph_to_eps_demo.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/demo/</path>
    <filename>a00443</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00520" name="graph_to_eps.h" local="no" imported="no">lemon/graph_to_eps.h</includes>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
  </compound>
  <compound kind="file">
    <name>lgf_demo.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/demo/</path>
    <filename>a00444</filename>
    <includes id="a00560" name="smart_graph.h" local="no" imported="no">lemon/smart_graph.h</includes>
    <includes id="a00531" name="lgf_reader.h" local="no" imported="no">lemon/lgf_reader.h</includes>
    <includes id="a00532" name="lgf_writer.h" local="no" imported="no">lemon/lgf_writer.h</includes>
  </compound>
  <compound kind="file">
    <name>adaptors.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00455</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <class kind="class">lemon::ReverseDigraph</class>
    <class kind="class">lemon::SubDigraph</class>
    <class kind="class">lemon::SubGraph</class>
    <class kind="class">lemon::FilterNodes</class>
    <class kind="class">lemon::FilterArcs</class>
    <class kind="class">lemon::FilterEdges</class>
    <class kind="class">lemon::Undirector</class>
    <class kind="class">lemon::Undirector::CombinedArcMap</class>
    <class kind="class">lemon::Orienter</class>
    <class kind="class">lemon::ResidualDigraph</class>
    <class kind="class">lemon::ResidualDigraph::ResidualCapacity</class>
    <class kind="class">lemon::SplitNodes</class>
    <class kind="class">lemon::SplitNodes::CombinedNodeMap</class>
    <class kind="class">lemon::SplitNodes::CombinedArcMap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>arg_parser.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00457</filename>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <class kind="class">lemon::ArgParserException</class>
    <class kind="class">lemon::ArgParser</class>
    <class kind="class">lemon::ArgParser::RefType</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>assert.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00458</filename>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <namespace>lemon</namespace>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_ASSERT</name>
      <anchorfile>a00627.html</anchorfile>
      <anchor>gaf78cf5572d91896ceecdd970f55601bc</anchor>
      <arglist>(exp, msg)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEBUG</name>
      <anchorfile>a00627.html</anchorfile>
      <anchor>gacbefc04b0335938603649e96af183843</anchor>
      <arglist>(exp, msg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>base.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00459</filename>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00565" name="time_measure.h" local="no" imported="no">lemon/time_measure.h</includes>
    <namespace>lemon</namespace>
    <member kind="variable">
      <type>const Invalid</type>
      <name>INVALID</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>a0f04de8e6be7bc21ed685c651571d9fe</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bellman_ford.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00460</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <class kind="struct">lemon::BellmanFordDefaultOperationTraits</class>
    <class kind="struct">lemon::BellmanFordDefaultTraits</class>
    <class kind="class">lemon::BellmanFord</class>
    <class kind="struct">lemon::BellmanFord::SetPredMap</class>
    <class kind="struct">lemon::BellmanFord::SetDistMap</class>
    <class kind="struct">lemon::BellmanFord::SetOperationTraits</class>
    <class kind="class">lemon::BellmanFord::ActiveIt</class>
    <class kind="struct">lemon::BellmanFordWizardDefaultTraits</class>
    <class kind="class">lemon::BellmanFordWizardBase</class>
    <class kind="class">lemon::BellmanFordWizard</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>BellmanFordWizard&lt; BellmanFordWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>bellmanFord</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>ga359aa931ac3c9550d5b5b5f3ec2e9e56</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bfs.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00461</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <class kind="struct">lemon::BfsDefaultTraits</class>
    <class kind="class">lemon::Bfs</class>
    <class kind="struct">lemon::Bfs::SetPredMap</class>
    <class kind="struct">lemon::Bfs::SetDistMap</class>
    <class kind="struct">lemon::Bfs::SetReachedMap</class>
    <class kind="struct">lemon::Bfs::SetProcessedMap</class>
    <class kind="struct">lemon::Bfs::SetStandardProcessedMap</class>
    <class kind="struct">lemon::BfsWizardDefaultTraits</class>
    <class kind="class">lemon::BfsWizardBase</class>
    <class kind="class">lemon::BfsWizard</class>
    <class kind="struct">lemon::BfsVisitor</class>
    <class kind="struct">lemon::BfsVisitDefaultTraits</class>
    <class kind="class">lemon::BfsVisit</class>
    <class kind="struct">lemon::BfsVisit::SetReachedMap</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>BfsWizard&lt; BfsWizardBase&lt; GR &gt; &gt;</type>
      <name>bfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>ga99817221896aba2eb403691a0a230a0b</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bin_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00462</filename>
    <class kind="class">lemon::BinHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>binomial_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00463</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00500" name="counter.h" local="no" imported="no">lemon/counter.h</includes>
    <class kind="class">lemon::BinomialHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>windows.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/bits/</path>
    <filename>a00479</filename>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>bucket_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00481</filename>
    <class kind="class">lemon::BucketHeap</class>
    <class kind="class">lemon::SimpleBucketHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>capacity_scaling.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00482</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <class kind="struct">lemon::CapacityScalingDefaultTraits</class>
    <class kind="class">lemon::CapacityScaling</class>
    <class kind="struct">lemon::CapacityScaling::SetHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>cbc.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00483</filename>
    <includes id="a00484" name="cbc.h" local="yes" imported="no">cbc.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>cbc.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00484</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::CbcMip</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>christofides_tsp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00485</filename>
    <includes id="a00516" name="full_graph.h" local="no" imported="no">lemon/full_graph.h</includes>
    <includes id="a00560" name="smart_graph.h" local="no" imported="no">lemon/smart_graph.h</includes>
    <includes id="a00530" name="kruskal.h" local="no" imported="no">lemon/kruskal.h</includes>
    <includes id="a00541" name="matching.h" local="no" imported="no">lemon/matching.h</includes>
    <includes id="a00513" name="euler.h" local="no" imported="no">lemon/euler.h</includes>
    <class kind="class">lemon::ChristofidesTsp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>circulation.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00486</filename>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00511" name="elevator.h" local="no" imported="no">lemon/elevator.h</includes>
    <class kind="struct">lemon::CirculationDefaultTraits</class>
    <class kind="class">lemon::Circulation</class>
    <class kind="struct">lemon::Circulation::SetFlowMap</class>
    <class kind="struct">lemon::Circulation::SetElevator</class>
    <class kind="struct">lemon::Circulation::SetStandardElevator</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>clp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00488</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::ClpLp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>color.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00489</filename>
    <includes id="a00490" name="color.h" local="no" imported="no">lemon/color.h</includes>
    <namespace>lemon</namespace>
    <member kind="variable">
      <type>const Color</type>
      <name>WHITE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa574c6748d637031ff114ee5396f371d</anchor>
      <arglist>(1, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLACK</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga887e77777b0cdd4bd98cd8582eab747d</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga3aab05ed4f1fa1188cb5cec4a951da36</anchor>
      <arglist>(1, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9d50a7cbc8c947f88556291754b964df</anchor>
      <arglist>(0, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d1bd8aebf1ea19b34a359b95afb2271</anchor>
      <arglist>(0, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga7b3b82796993ff082f39aeaca4f74be9</anchor>
      <arglist>(1, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gad9c523e1fcd76b6e97a7e8f6c89a6d09</anchor>
      <arglist>(1, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga6b139d00115defc76ec508dff90c91fd</anchor>
      <arglist>(0, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREY</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaccc4c0904a38839f9554cde971bb4963</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1c9259e9d2ec9a44ea6bf855d3dd3917</anchor>
      <arglist>(.5, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gabc9fc012aa002dd8e311065b3115969c</anchor>
      <arglist>(0,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac56cc8c77b9fcb56e308652d922d08f0</anchor>
      <arglist>(0, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5dbe8dbe7b513bc66228981dcad165f7</anchor>
      <arglist>(.5,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa3457b13dd61099a849816a02ba55efc</anchor>
      <arglist>(.5, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1814dea6aea83b28d9137adaa4d8b937</anchor>
      <arglist>(0,.5,.5)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>color.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00490</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <class kind="class">lemon::Color</class>
    <class kind="class">lemon::Palette</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>Color</type>
      <name>distantColor</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaafbc768b20325e1e5048dcd2b10bc4e7</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>distantBW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga22a184708d82339466dd08286e01a756</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>concept_check.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00491</filename>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>void</type>
      <name>function_requires</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>a3b4bbb2e8a649d05287b65fdf29b6930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>checkConcept</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>ac202d55258d62489acf256b88b87e470</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bpgraph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00492</filename>
    <includes id="a00495" name="graph_components.h" local="no" imported="no">lemon/concepts/graph_components.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::concepts::BpGraph</class>
    <class kind="class">lemon::concepts::BpGraph::Node</class>
    <class kind="class">lemon::concepts::BpGraph::RedNode</class>
    <class kind="class">lemon::concepts::BpGraph::BlueNode</class>
    <class kind="class">lemon::concepts::BpGraph::RedNodeIt</class>
    <class kind="class">lemon::concepts::BpGraph::BlueNodeIt</class>
    <class kind="class">lemon::concepts::BpGraph::NodeIt</class>
    <class kind="class">lemon::concepts::BpGraph::Edge</class>
    <class kind="class">lemon::concepts::BpGraph::EdgeIt</class>
    <class kind="class">lemon::concepts::BpGraph::IncEdgeIt</class>
    <class kind="class">lemon::concepts::BpGraph::Arc</class>
    <class kind="class">lemon::concepts::BpGraph::ArcIt</class>
    <class kind="class">lemon::concepts::BpGraph::OutArcIt</class>
    <class kind="class">lemon::concepts::BpGraph::InArcIt</class>
    <class kind="class">lemon::concepts::BpGraph::NodeMap</class>
    <class kind="class">lemon::concepts::BpGraph::RedNodeMap</class>
    <class kind="class">lemon::concepts::BpGraph::BlueNodeMap</class>
    <class kind="class">lemon::concepts::BpGraph::ArcMap</class>
    <class kind="class">lemon::concepts::BpGraph::EdgeMap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>digraph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00493</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00495" name="graph_components.h" local="no" imported="no">lemon/concepts/graph_components.h</includes>
    <class kind="class">lemon::concepts::Digraph</class>
    <class kind="class">lemon::concepts::Digraph::Node</class>
    <class kind="class">lemon::concepts::Digraph::NodeIt</class>
    <class kind="class">lemon::concepts::Digraph::Arc</class>
    <class kind="class">lemon::concepts::Digraph::OutArcIt</class>
    <class kind="class">lemon::concepts::Digraph::InArcIt</class>
    <class kind="class">lemon::concepts::Digraph::ArcIt</class>
    <class kind="class">lemon::concepts::Digraph::NodeMap</class>
    <class kind="class">lemon::concepts::Digraph::ArcMap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00494</filename>
    <includes id="a00495" name="graph_components.h" local="no" imported="no">lemon/concepts/graph_components.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::concepts::Graph</class>
    <class kind="class">lemon::concepts::Graph::Node</class>
    <class kind="class">lemon::concepts::Graph::NodeIt</class>
    <class kind="class">lemon::concepts::Graph::Edge</class>
    <class kind="class">lemon::concepts::Graph::EdgeIt</class>
    <class kind="class">lemon::concepts::Graph::IncEdgeIt</class>
    <class kind="class">lemon::concepts::Graph::Arc</class>
    <class kind="class">lemon::concepts::Graph::ArcIt</class>
    <class kind="class">lemon::concepts::Graph::OutArcIt</class>
    <class kind="class">lemon::concepts::Graph::InArcIt</class>
    <class kind="class">lemon::concepts::Graph::NodeMap</class>
    <class kind="class">lemon::concepts::Graph::ArcMap</class>
    <class kind="class">lemon::concepts::Graph::EdgeMap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>graph_components.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00495</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <class kind="class">lemon::concepts::GraphItem</class>
    <class kind="class">lemon::concepts::BaseDigraphComponent</class>
    <class kind="class">lemon::concepts::BaseGraphComponent</class>
    <class kind="class">lemon::concepts::BaseGraphComponent::Edge</class>
    <class kind="class">lemon::concepts::BaseBpGraphComponent</class>
    <class kind="class">lemon::concepts::BaseBpGraphComponent::RedNode</class>
    <class kind="class">lemon::concepts::BaseBpGraphComponent::BlueNode</class>
    <class kind="class">lemon::concepts::IDableDigraphComponent</class>
    <class kind="class">lemon::concepts::IDableGraphComponent</class>
    <class kind="class">lemon::concepts::IDableBpGraphComponent</class>
    <class kind="class">lemon::concepts::GraphItemIt</class>
    <class kind="class">lemon::concepts::GraphIncIt</class>
    <class kind="class">lemon::concepts::IterableDigraphComponent</class>
    <class kind="class">lemon::concepts::IterableGraphComponent</class>
    <class kind="class">lemon::concepts::IterableBpGraphComponent</class>
    <class kind="class">lemon::concepts::AlterableDigraphComponent</class>
    <class kind="class">lemon::concepts::AlterableGraphComponent</class>
    <class kind="class">lemon::concepts::AlterableBpGraphComponent</class>
    <class kind="class">lemon::concepts::GraphMap</class>
    <class kind="class">lemon::concepts::MappableDigraphComponent</class>
    <class kind="class">lemon::concepts::MappableDigraphComponent::NodeMap</class>
    <class kind="class">lemon::concepts::MappableDigraphComponent::ArcMap</class>
    <class kind="class">lemon::concepts::MappableGraphComponent</class>
    <class kind="class">lemon::concepts::MappableGraphComponent::EdgeMap</class>
    <class kind="class">lemon::concepts::MappableBpGraphComponent</class>
    <class kind="class">lemon::concepts::MappableBpGraphComponent::RedNodeMap</class>
    <class kind="class">lemon::concepts::MappableBpGraphComponent::BlueNodeMap</class>
    <class kind="class">lemon::concepts::ExtendableDigraphComponent</class>
    <class kind="class">lemon::concepts::ExtendableGraphComponent</class>
    <class kind="class">lemon::concepts::ExtendableBpGraphComponent</class>
    <class kind="class">lemon::concepts::ErasableDigraphComponent</class>
    <class kind="class">lemon::concepts::ErasableGraphComponent</class>
    <class kind="class">lemon::concepts::ErasableBpGraphComponent</class>
    <class kind="class">lemon::concepts::ClearableDigraphComponent</class>
    <class kind="class">lemon::concepts::ClearableGraphComponent</class>
    <class kind="class">lemon::concepts::ClearableBpGraphComponent</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00496</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <class kind="class">lemon::concepts::Heap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>connectivity.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00497</filename>
    <includes id="a00504" name="dfs.h" local="no" imported="no">lemon/dfs.h</includes>
    <includes id="a00461" name="bfs.h" local="no" imported="no">lemon/bfs.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00455" name="adaptors.h" local="no" imported="no">lemon/adaptors.h</includes>
    <includes id="a00493" name="digraph.h" local="no" imported="no">lemon/concepts/digraph.h</includes>
    <includes id="a00494" name="graph.h" local="no" imported="no">lemon/concepts/graph.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>bool</type>
      <name>connected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad5c8d1b650f6b614a852f8430d90e184</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga33a9d9d4803cb15e83568b2526e978a5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa467a3e0a8c2e9e762650fd01fadff89</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stronglyConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gacd21b34d7b42b9835a204a57fcf15964</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countStronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad30bc47dfffb78234eeee903cb3766f4</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga46f8c22f3e2989c4689faa4c46ec9436</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedCutArcs</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad7af5c3a97453e37f251f0e86dbb83db</anchor>
      <arglist>(const Digraph &amp;digraph, ArcMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf7c5744b2175210b8ea67897aaa27885</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biNodeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gac9257323ead7cbe64b7b4a628c4876b3</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga9d70526ab54e10b4b6fe3762af8675dd</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedCutNodes</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga31461f33a748327ea3ef2a3199ffb6c7</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga4d5db78dc21099d075c3967484990954</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biEdgeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga37d22a2ddd5a064a9203720f2b93518e</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga76c1fdd1881d21677507100b7e96c983</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedCutEdges</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58d444eba448c5f1a53539bd1b69636e</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dag</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaef2b43c8cd1d74e15fa5c7607bc5e396</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>topologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafc2cb20cf3859f157c0e12da7f310bb3</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedTopologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf10c5e1630e5720c20d83cfb77dbf024</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acyclic</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga14c191b2133a1dd23e1527f074c821c0</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>tree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad1e4de234e926958647905478415bd54</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartite</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga577db110d33bd487aaad5bfffb31c6f5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartitePartitions</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58ba1d00c569f0eb0deb42afca9f80bb</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;partMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loopFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga127f3963003cd532c79c226885fe1c8c</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parallelFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa05e0683f90b69f31eb29fe7d09afde4</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>simpleGraph</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gae4c7ae734e2509ab78dc747d602c9236</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>core.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00498</filename>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <class kind="struct">lemon::Invalid</class>
    <class kind="class">lemon::DigraphCopy</class>
    <class kind="class">lemon::GraphCopy</class>
    <class kind="class">lemon::BpGraphCopy</class>
    <class kind="class">lemon::ConArcIt</class>
    <class kind="class">lemon::ConEdgeIt</class>
    <class kind="class">lemon::DynArcLookUp</class>
    <class kind="class">lemon::ArcLookUp</class>
    <class kind="class">lemon::AllArcLookUp</class>
    <namespace>lemon</namespace>
    <member kind="define">
      <type>#define</type>
      <name>DIGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac618f30ace596c69836144bfdcc9112c</anchor>
      <arglist>(Digraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_DIGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga14ef90d8fd45b56f1cc2c5023c76c4b1</anchor>
      <arglist>(Digraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gab8c497e4257836f4669b8922237d830b</anchor>
      <arglist>(Graph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_GRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gab0e6cf49071e60eda3e15e2b0e0d8310</anchor>
      <arglist>(Graph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>BPGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac8d6365af7bc18ed8d55d0d4e752399f</anchor>
      <arglist>(BpGraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_BPGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga1442da4c0ddce15a9a5f651693d7ab57</anchor>
      <arglist>(BpGraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countItems</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga65f512e54ae6256fcd098592fc582e50</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga9156d36059e59ebc8dc14bad0112633d</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countRedNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac1a04fa8a9e0460accf28c5337b2c5eb</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBlueNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga40c1bf81c7096481ca39f286eeb74163</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga1b3307d4e63c19d4ebadf133ebb43683</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaede53fc1ef848a03b7f844a5ec7eeca6</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countOutArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaf199da654058dd16da1702f38b60f30c</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countInArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga03d0d2f770d7f7faac66438139ae9b18</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countIncEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gae93681c4e849f6fd3a102fcb2756e317</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>undirected</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaa7a3075a14f2acde20f1d999675a8040</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy&lt; From, To &gt;</type>
      <name>digraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga47e4bf893a80e68971c511735117c707</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy&lt; From, To &gt;</type>
      <name>graphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga6d9c65013887bb0710df0d58985d67dc</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy&lt; From, To &gt;</type>
      <name>bpGraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga58f5d796ccf095d19f507f47bf92d38f</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Arc</type>
      <name>findArc</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga8f2c525c18d4b29476db308e49066334</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Arc prev=INVALID)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Edge</type>
      <name>findEdge</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga50b131b15b6c98823c4dc308f7e884e8</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Edge p=INVALID)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cost_scaling.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00499</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00563" name="static_graph.h" local="no" imported="no">lemon/static_graph.h</includes>
    <includes id="a00486" name="circulation.h" local="no" imported="no">lemon/circulation.h</includes>
    <includes id="a00460" name="bellman_ford.h" local="no" imported="no">lemon/bellman_ford.h</includes>
    <class kind="struct">lemon::CostScalingDefaultTraits</class>
    <class kind="class">lemon::CostScaling</class>
    <class kind="struct">lemon::CostScaling::SetLargeCost</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>counter.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00500</filename>
    <class kind="class">lemon::Counter</class>
    <class kind="class">lemon::NoCounter</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>cplex.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00501</filename>
    <includes id="a00502" name="cplex.h" local="no" imported="no">lemon/cplex.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>cplex.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00502</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::CplexEnv</class>
    <class kind="class">lemon::CplexEnv::LicenseError</class>
    <class kind="class">lemon::CplexBase</class>
    <class kind="class">lemon::CplexLp</class>
    <class kind="class">lemon::CplexMip</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>cycle_canceling.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00503</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00563" name="static_graph.h" local="no" imported="no">lemon/static_graph.h</includes>
    <includes id="a00455" name="adaptors.h" local="no" imported="no">lemon/adaptors.h</includes>
    <includes id="a00486" name="circulation.h" local="no" imported="no">lemon/circulation.h</includes>
    <includes id="a00460" name="bellman_ford.h" local="no" imported="no">lemon/bellman_ford.h</includes>
    <includes id="a00526" name="howard_mmc.h" local="no" imported="no">lemon/howard_mmc.h</includes>
    <includes id="a00525" name="hartmann_orlin_mmc.h" local="no" imported="no">lemon/hartmann_orlin_mmc.h</includes>
    <class kind="class">lemon::CycleCanceling</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>dfs.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00504</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <class kind="struct">lemon::DfsDefaultTraits</class>
    <class kind="class">lemon::Dfs</class>
    <class kind="struct">lemon::Dfs::SetPredMap</class>
    <class kind="struct">lemon::Dfs::SetDistMap</class>
    <class kind="struct">lemon::Dfs::SetReachedMap</class>
    <class kind="struct">lemon::Dfs::SetProcessedMap</class>
    <class kind="struct">lemon::Dfs::SetStandardProcessedMap</class>
    <class kind="struct">lemon::DfsWizardDefaultTraits</class>
    <class kind="class">lemon::DfsWizardBase</class>
    <class kind="class">lemon::DfsWizard</class>
    <class kind="struct">lemon::DfsVisitor</class>
    <class kind="struct">lemon::DfsVisitDefaultTraits</class>
    <class kind="class">lemon::DfsVisit</class>
    <class kind="struct">lemon::DfsVisit::SetReachedMap</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>DfsWizard&lt; DfsWizardBase&lt; GR &gt; &gt;</type>
      <name>dfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>gaa6a12c70b10ad9693117ec2b3774b0d8</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>dheap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00505</filename>
    <class kind="class">lemon::DHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>dijkstra.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00506</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <class kind="struct">lemon::DijkstraDefaultOperationTraits</class>
    <class kind="struct">lemon::DijkstraDefaultTraits</class>
    <class kind="class">lemon::Dijkstra</class>
    <class kind="struct">lemon::Dijkstra::SetPredMap</class>
    <class kind="struct">lemon::Dijkstra::SetDistMap</class>
    <class kind="struct">lemon::Dijkstra::SetProcessedMap</class>
    <class kind="struct">lemon::Dijkstra::SetStandardProcessedMap</class>
    <class kind="struct">lemon::Dijkstra::SetHeap</class>
    <class kind="struct">lemon::Dijkstra::SetStandardHeap</class>
    <class kind="struct">lemon::Dijkstra::SetOperationTraits</class>
    <class kind="struct">lemon::DijkstraWizardDefaultTraits</class>
    <class kind="class">lemon::DijkstraWizardBase</class>
    <class kind="class">lemon::DijkstraWizard</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>DijkstraWizard&lt; DijkstraWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>dijkstra</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>gaa781be76e5adb6a9df7592457a5c3857</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>dim2.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00507</filename>
    <class kind="class">lemon::dim2::Point</class>
    <class kind="class">lemon::dim2::Box</class>
    <class kind="class">lemon::dim2::XMap</class>
    <class kind="class">lemon::dim2::ConstXMap</class>
    <class kind="class">lemon::dim2::YMap</class>
    <class kind="class">lemon::dim2::ConstYMap</class>
    <class kind="class">lemon::dim2::NormSquareMap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::dim2</namespace>
  </compound>
  <compound kind="file">
    <name>dimacs.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00508</filename>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <class kind="struct">lemon::DimacsDescriptor</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>DimacsDescriptor</type>
      <name>dimacsType</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gad16c7910d72fa073be372881e1b3b087</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMin</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga309d99eda5d1f5f3df2b2ca2d57ec024</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LowerMap &amp;lower, CapacityMap &amp;capacity, CostMap &amp;cost, SupplyMap &amp;supply, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMax</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga44cf335757161623864f8b1ef4446601</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename Digraph::Node &amp;s, typename Digraph::Node &amp;t, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsSp</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gae8f5ba3e3f9ce3281f83c152d193625b</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LengthMap &amp;length, typename Digraph::Node &amp;s, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsCap</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2ec47d238c02a465037377e65875793d</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2f4cd9537b1e6da13b64220bed687ad2</anchor>
      <arglist>(std::istream &amp;is, Graph &amp;g, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gada363b719022ba1fe1c03978ba6cece9</anchor>
      <arglist>(std::ostream &amp;os, const Digraph &amp;g, std::string comment=&quot;&quot;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>edge_set.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00509</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::ListArcSet</class>
    <class kind="class">lemon::ListEdgeSet</class>
    <class kind="class">lemon::SmartArcSet</class>
    <class kind="class">lemon::SmartEdgeSet</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>edmonds_karp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00510</filename>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <class kind="struct">lemon::EdmondsKarpDefaultTraits</class>
    <class kind="class">lemon::EdmondsKarp</class>
    <class kind="struct">lemon::EdmondsKarp::SetFlowMap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>elevator.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00511</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::Elevator</class>
    <class kind="class">lemon::LinkedElevator</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>error.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00512</filename>
    <class kind="class">lemon::Exception</class>
    <class kind="class">lemon::IoError</class>
    <class kind="class">lemon::FormatError</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>euler.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00513</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00455" name="adaptors.h" local="no" imported="no">lemon/adaptors.h</includes>
    <includes id="a00497" name="connectivity.h" local="no" imported="no">lemon/connectivity.h</includes>
    <class kind="class">lemon::DiEulerIt</class>
    <class kind="class">lemon::EulerIt</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>bool</type>
      <name>eulerian</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafb5a4961cac4d877006869fc4cb6ea1d</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fib_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00514</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <class kind="class">lemon::FibHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>fractional_matching.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00515</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00567" name="unionfind.h" local="no" imported="no">lemon/unionfind.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <includes id="a00511" name="elevator.h" local="no" imported="no">lemon/elevator.h</includes>
    <class kind="struct">lemon::MaxFractionalMatchingDefaultTraits</class>
    <class kind="class">lemon::MaxFractionalMatching</class>
    <class kind="struct">lemon::MaxFractionalMatching::SetMatchingMap</class>
    <class kind="struct">lemon::MaxFractionalMatching::SetElevator</class>
    <class kind="struct">lemon::MaxFractionalMatching::SetStandardElevator</class>
    <class kind="class">lemon::MaxWeightedFractionalMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectFractionalMatching</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>full_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00516</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::FullDigraph</class>
    <class kind="class">lemon::FullGraph</class>
    <class kind="class">lemon::FullBpGraph</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>glpk.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00517</filename>
    <includes id="a00518" name="glpk.h" local="no" imported="no">lemon/glpk.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>glpk.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00518</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::GlpkBase</class>
    <class kind="class">lemon::GlpkLp</class>
    <class kind="class">lemon::GlpkMip</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>gomory_hu.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00519</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00554" name="preflow.h" local="no" imported="no">lemon/preflow.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <class kind="class">lemon::GomoryHu</class>
    <class kind="class">lemon::GomoryHu::MinCutNodeIt</class>
    <class kind="class">lemon::GomoryHu::MinCutEdgeIt</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>graph_to_eps.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00520</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00507" name="dim2.h" local="no" imported="no">lemon/dim2.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00490" name="color.h" local="no" imported="no">lemon/color.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <class kind="struct">lemon::DefaultGraphToEpsTraits</class>
    <class kind="class">lemon::GraphToEps</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>gacdf8d8f513b3e79f89b19c20f7755564</anchor>
      <arglist>(GR &amp;g, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga48002fdee116559a9948d1bf540475f1</anchor>
      <arglist>(GR &amp;g, const char *file_name)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga919340e78dd663a7b77c7aa9c3658170</anchor>
      <arglist>(GR &amp;g, const std::string &amp;file_name)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>greedy_tsp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00521</filename>
    <includes id="a00516" name="full_graph.h" local="no" imported="no">lemon/full_graph.h</includes>
    <includes id="a00567" name="unionfind.h" local="no" imported="no">lemon/unionfind.h</includes>
    <class kind="class">lemon::GreedyTsp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>grid_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00522</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00507" name="dim2.h" local="no" imported="no">lemon/dim2.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <class kind="class">lemon::GridGraph</class>
    <class kind="class">lemon::GridGraph::IndexMap</class>
    <class kind="class">lemon::GridGraph::ColMap</class>
    <class kind="class">lemon::GridGraph::RowMap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>grosso_locatelli_pullan_mc.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00523</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00559" name="random.h" local="no" imported="no">lemon/random.h</includes>
    <class kind="class">lemon::GrossoLocatelliPullanMc</class>
    <class kind="class">lemon::GrossoLocatelliPullanMc::CliqueNodeIt</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>hao_orlin.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00524</filename>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <class kind="class">lemon::HaoOrlin</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>hartmann_orlin_mmc.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00525</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00497" name="connectivity.h" local="no" imported="no">lemon/connectivity.h</includes>
    <class kind="struct">lemon::HartmannOrlinMmcDefaultTraits</class>
    <class kind="class">lemon::HartmannOrlinMmc</class>
    <class kind="struct">lemon::HartmannOrlinMmc::SetLargeCost</class>
    <class kind="struct">lemon::HartmannOrlinMmc::SetPath</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>howard_mmc.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00526</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00497" name="connectivity.h" local="no" imported="no">lemon/connectivity.h</includes>
    <class kind="struct">lemon::HowardMmcDefaultTraits</class>
    <class kind="class">lemon::HowardMmc</class>
    <class kind="struct">lemon::HowardMmc::SetLargeCost</class>
    <class kind="struct">lemon::HowardMmc::SetPath</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>hypercube_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00527</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <class kind="class">lemon::HypercubeGraph</class>
    <class kind="class">lemon::HypercubeGraph::HyperMap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>insertion_tsp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00528</filename>
    <includes id="a00516" name="full_graph.h" local="no" imported="no">lemon/full_graph.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00559" name="random.h" local="no" imported="no">lemon/random.h</includes>
    <class kind="class">lemon::InsertionTsp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>karp_mmc.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00529</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00497" name="connectivity.h" local="no" imported="no">lemon/connectivity.h</includes>
    <class kind="struct">lemon::KarpMmcDefaultTraits</class>
    <class kind="class">lemon::KarpMmc</class>
    <class kind="struct">lemon::KarpMmc::SetLargeCost</class>
    <class kind="struct">lemon::KarpMmc::SetPath</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>kruskal.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00530</filename>
    <includes id="a00567" name="unionfind.h" local="no" imported="no">lemon/unionfind.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>Value</type>
      <name>kruskal</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga233792b2c44a3581b85a775703e045af</anchor>
      <arglist>(const Graph &amp;g, const In &amp;in, Out &amp;out)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>lgf_reader.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00531</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00532" name="lgf_writer.h" local="no" imported="no">lemon/lgf_writer.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <class kind="class">lemon::DigraphReader</class>
    <class kind="class">lemon::DigraphReader</class>
    <class kind="class">lemon::GraphReader</class>
    <class kind="class">lemon::GraphReader</class>
    <class kind="class">lemon::BpGraphReader</class>
    <class kind="class">lemon::BpGraphReader</class>
    <class kind="class">lemon::SectionReader</class>
    <class kind="class">lemon::LgfContents</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>lgf_writer.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00532</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <includes id="a00540" name="maps.h" local="no" imported="no">lemon/concepts/maps.h</includes>
    <class kind="class">lemon::DigraphWriter</class>
    <class kind="class">lemon::DigraphWriter</class>
    <class kind="class">lemon::GraphWriter</class>
    <class kind="class">lemon::GraphWriter</class>
    <class kind="class">lemon::BpGraphWriter</class>
    <class kind="class">lemon::BpGraphWriter</class>
    <class kind="class">lemon::SectionWriter</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>list_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00533</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <class kind="class">lemon::ListDigraph</class>
    <class kind="class">lemon::ListDigraph::Snapshot</class>
    <class kind="class">lemon::ListGraph</class>
    <class kind="class">lemon::ListGraph::Snapshot</class>
    <class kind="class">lemon::ListBpGraph</class>
    <class kind="class">lemon::ListBpGraph::Snapshot</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>lp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00534</filename>
    <namespace>lemon</namespace>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEFAULT_LP</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>ga459ae538832b3817b7692a81de79d744</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEFAULT_MIP</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>gae4ce37e43b0032f13b3efa0e0b0af640</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlpkLp</type>
      <name>Lp</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>ga8c6461f78849b26ae8be11062410d043</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlpkMip</type>
      <name>Mip</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>gad4ee17c56e133b01b9d75eb2cefd4d7f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>lp_base.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00535</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>lp_base.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00536</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::LpBase</class>
    <class kind="class">lemon::LpBase::Col</class>
    <class kind="class">lemon::LpBase::ColIt</class>
    <class kind="class">lemon::LpBase::Row</class>
    <class kind="class">lemon::LpBase::RowIt</class>
    <class kind="class">lemon::LpBase::Expr</class>
    <class kind="class">lemon::LpBase::Expr::CoeffIt</class>
    <class kind="class">lemon::LpBase::Expr::ConstCoeffIt</class>
    <class kind="class">lemon::LpBase::Constr</class>
    <class kind="class">lemon::LpBase::DualExpr</class>
    <class kind="class">lemon::LpBase::DualExpr::CoeffIt</class>
    <class kind="class">lemon::LpBase::DualExpr::ConstCoeffIt</class>
    <class kind="class">lemon::LpBase::UnsupportedFormatError</class>
    <class kind="class">lemon::LpSolver</class>
    <class kind="class">lemon::MipSolver</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>lp_skeleton.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00537</filename>
    <includes id="a00538" name="lp_skeleton.h" local="no" imported="no">lemon/lp_skeleton.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>lp_skeleton.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00538</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::SkeletonSolverBase</class>
    <class kind="class">lemon::LpSkeleton</class>
    <class kind="class">lemon::MipSkeleton</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>maps.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00539</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::MapBase</class>
    <class kind="class">lemon::NullMap</class>
    <class kind="class">lemon::ConstMap</class>
    <class kind="class">lemon::ConstMap&lt; K, Const&lt; V, v &gt; &gt;</class>
    <class kind="class">lemon::IdentityMap</class>
    <class kind="class">lemon::RangeMap</class>
    <class kind="class">lemon::SparseMap</class>
    <class kind="class">lemon::ComposeMap</class>
    <class kind="class">lemon::CombineMap</class>
    <class kind="class">lemon::FunctorToMap</class>
    <class kind="class">lemon::MapToFunctor</class>
    <class kind="class">lemon::ConvertMap</class>
    <class kind="class">lemon::ForkMap</class>
    <class kind="class">lemon::AddMap</class>
    <class kind="class">lemon::SubMap</class>
    <class kind="class">lemon::MulMap</class>
    <class kind="class">lemon::DivMap</class>
    <class kind="class">lemon::ShiftMap</class>
    <class kind="class">lemon::ShiftWriteMap</class>
    <class kind="class">lemon::ScaleMap</class>
    <class kind="class">lemon::ScaleWriteMap</class>
    <class kind="class">lemon::NegMap</class>
    <class kind="class">lemon::NegWriteMap</class>
    <class kind="class">lemon::AbsMap</class>
    <class kind="class">lemon::TrueMap</class>
    <class kind="class">lemon::FalseMap</class>
    <class kind="class">lemon::AndMap</class>
    <class kind="class">lemon::OrMap</class>
    <class kind="class">lemon::NotMap</class>
    <class kind="class">lemon::NotWriteMap</class>
    <class kind="class">lemon::EqualMap</class>
    <class kind="class">lemon::LessMap</class>
    <class kind="class">lemon::LoggerBoolMap</class>
    <class kind="class">lemon::IdMap</class>
    <class kind="class">lemon::IdMap::InverseMap</class>
    <class kind="class">lemon::CrossRefMap</class>
    <class kind="class">lemon::CrossRefMap::ValueIt</class>
    <class kind="class">lemon::CrossRefMap::InverseMap</class>
    <class kind="class">lemon::RangeIdMap</class>
    <class kind="class">lemon::RangeIdMap::InverseMap</class>
    <class kind="class">lemon::IterableBoolMap</class>
    <class kind="class">lemon::IterableBoolMap::Reference</class>
    <class kind="class">lemon::IterableBoolMap::TrueIt</class>
    <class kind="class">lemon::IterableBoolMap::FalseIt</class>
    <class kind="class">lemon::IterableBoolMap::ItemIt</class>
    <class kind="class">lemon::IterableIntMap</class>
    <class kind="class">lemon::IterableIntMap::Reference</class>
    <class kind="class">lemon::IterableIntMap::ItemIt</class>
    <class kind="class">lemon::IterableValueMap</class>
    <class kind="class">lemon::IterableValueMap::ValueIt</class>
    <class kind="class">lemon::IterableValueMap::ItemIt</class>
    <class kind="class">lemon::SourceMap</class>
    <class kind="class">lemon::TargetMap</class>
    <class kind="class">lemon::ForwardMap</class>
    <class kind="class">lemon::BackwardMap</class>
    <class kind="class">lemon::InDegMap</class>
    <class kind="class">lemon::OutDegMap</class>
    <class kind="class">lemon::PotentialDifferenceMap</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>void</type>
      <name>mapCopy</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gacd3b1378e8d938e2f4f831cda62d7196</anchor>
      <arglist>(const GR &amp;gr, const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mapCompare</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad05d27a9d1f23407ab2960b48a9b7582</anchor>
      <arglist>(const GR &amp;gr, const Map1 &amp;map1, const Map2 &amp;map2)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga6119b9344a9c76eb7fca2f57f67732e4</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8c1dd57a1af8310ca04d57a70f3f659c</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga87e0df0934bba2996ec5c9b6907de88d</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga262a78bd1f36223d520ffde235730cb9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga3be91b854e7788d89047f161378fce58</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga712ba7c8df94bd02f28d6e08d11176f7</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga72688c2e41aa36efa56431b5b585a1c1</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga7b5174f049f1fd63844d2c914832cbcc</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFind</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8469265a9d93f69c9402756ffe86bcab</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFindIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad5e8addbccd1e43a3add48108020ffbd</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCount</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gafe30fc86a55d33ad6811f3cc835b4cf9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCountIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga33891e575e55c0f9ec0dac31923119b8</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mapFill</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gabbcca4c1a7f23a9f39e97e24dc8c54fc</anchor>
      <arglist>(const GR &amp;gr, Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>maps.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00540</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <class kind="class">lemon::concepts::ReadMap</class>
    <class kind="class">lemon::concepts::WriteMap</class>
    <class kind="class">lemon::concepts::ReadWriteMap</class>
    <class kind="class">lemon::concepts::ReferenceMap</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>matching.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00541</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00567" name="unionfind.h" local="no" imported="no">lemon/unionfind.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00515" name="fractional_matching.h" local="no" imported="no">lemon/fractional_matching.h</includes>
    <class kind="class">lemon::MaxMatching</class>
    <class kind="class">lemon::MaxWeightedMatching</class>
    <class kind="class">lemon::MaxWeightedMatching::BlossomIt</class>
    <class kind="class">lemon::MaxWeightedPerfectMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectMatching::BlossomIt</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>math.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00542</filename>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>bool</type>
      <name>isNaN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga78d99e4135230ce52d67f269ed1d464f</anchor>
      <arglist>(double v)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>round</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaac8681108dfd2b0deee2dca59dff26bb</anchor>
      <arglist>(double r)</arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga72bb95cfe3f4109af43a989e478a2d61</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG2E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9cef1ca3f697ed0afa15e6ce2658b9cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG10E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga044b3cac2493404bbd6bb04cf61dc38d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga64f768a3649a214be5a8b9d13acc30fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN10</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gab62596f975434ae5b1dde456a64c455a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gacf20630e5d2a9696928fe77b0726013c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d3eb5ff33b365b02e3d7065f2ecba48</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_4</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5a75e78cd42171bf864e2bad56639318</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac6586fa2865c0cc54dd89b93a0da1d17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT1_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1794f2ffbd3e762771a25847b905918c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>max_cardinality_search.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00543</filename>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00481" name="bucket_heap.h" local="no" imported="no">lemon/bucket_heap.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <class kind="struct">lemon::MaxCardinalitySearchDefaultTraits</class>
    <class kind="class">lemon::MaxCardinalitySearch</class>
    <class kind="struct">lemon::MaxCardinalitySearch::SetCapacityMap</class>
    <class kind="struct">lemon::MaxCardinalitySearch::SetCardinalityMap</class>
    <class kind="struct">lemon::MaxCardinalitySearch::SetProcessedMap</class>
    <class kind="struct">lemon::MaxCardinalitySearch::SetHeap</class>
    <class kind="struct">lemon::MaxCardinalitySearch::SetStandardHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>min_cost_arborescence.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00544</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00458" name="assert.h" local="no" imported="no">lemon/assert.h</includes>
    <class kind="struct">lemon::MinCostArborescenceDefaultTraits</class>
    <class kind="class">lemon::MinCostArborescence</class>
    <class kind="struct">lemon::MinCostArborescence::SetArborescenceMap</class>
    <class kind="struct">lemon::MinCostArborescence::SetPredMap</class>
    <class kind="class">lemon::MinCostArborescence::DualIt</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>CostMap::Value</type>
      <name>minCostArborescence</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga0faeb92308e21beeb093ee6c967a2cb5</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost, typename Digraph::Node source, ArborescenceMap &amp;arborescence)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>nagamochi_ibaraki.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00545</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00481" name="bucket_heap.h" local="no" imported="no">lemon/bucket_heap.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00557" name="radix_sort.h" local="no" imported="no">lemon/radix_sort.h</includes>
    <includes id="a00567" name="unionfind.h" local="no" imported="no">lemon/unionfind.h</includes>
    <class kind="struct">lemon::NagamochiIbarakiDefaultTraits</class>
    <class kind="class">lemon::NagamochiIbaraki</class>
    <class kind="struct">lemon::NagamochiIbaraki::SetUnitCapacity</class>
    <class kind="struct">lemon::NagamochiIbaraki::SetHeap</class>
    <class kind="struct">lemon::NagamochiIbaraki::SetStandardHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>nauty_reader.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00546</filename>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>std::istream &amp;</type>
      <name>readNautyGraph</name>
      <anchorfile>a00632.html</anchorfile>
      <anchor>gab98a634e56974e5266e04dd0a1a63a83</anchor>
      <arglist>(Graph &amp;graph, std::istream &amp;is=std::cin)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>nearest_neighbor_tsp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00547</filename>
    <includes id="a00516" name="full_graph.h" local="no" imported="no">lemon/full_graph.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <class kind="class">lemon::NearestNeighborTsp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>network_simplex.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00548</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <class kind="class">lemon::NetworkSimplex</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>opt2_tsp.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00549</filename>
    <includes id="a00516" name="full_graph.h" local="no" imported="no">lemon/full_graph.h</includes>
    <class kind="class">lemon::Opt2Tsp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>pairing_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00550</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <class kind="class">lemon::PairingHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>path.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00551</filename>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00552" name="path.h" local="no" imported="no">lemon/concepts/path.h</includes>
    <class kind="class">lemon::Path</class>
    <class kind="class">lemon::Path::ArcIt</class>
    <class kind="class">lemon::SimplePath</class>
    <class kind="class">lemon::SimplePath::ArcIt</class>
    <class kind="class">lemon::ListPath</class>
    <class kind="class">lemon::ListPath::ArcIt</class>
    <class kind="class">lemon::StaticPath</class>
    <class kind="class">lemon::StaticPath::ArcIt</class>
    <class kind="class">lemon::PathNodeIt</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>void</type>
      <name>pathCopy</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga1c0da351dc554629ec44013576637e7d</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copyPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga437e79537f340c99bb743bc928cb0a10</anchor>
      <arglist>(To &amp;to, const From &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga72529b1d8158a18d4a428dc3eab15a69</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathSource</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga8cd2b147cef7e0a4fa05145908d95c15</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathTarget</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga885afd9d4ba099bf2d8104e6e0408b66</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>path.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/concepts/</path>
    <filename>a00552</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00491" name="concept_check.h" local="no" imported="no">lemon/concept_check.h</includes>
    <class kind="class">lemon::concepts::Path</class>
    <class kind="class">lemon::concepts::Path::ArcIt</class>
    <class kind="class">lemon::concepts::PathDumper</class>
    <class kind="class">lemon::concepts::PathDumper::ArcIt</class>
    <class kind="class">lemon::concepts::PathDumper::RevArcIt</class>
    <namespace>lemon</namespace>
    <namespace>lemon::concepts</namespace>
  </compound>
  <compound kind="file">
    <name>planarity.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00553</filename>
    <includes id="a00504" name="dfs.h" local="no" imported="no">lemon/dfs.h</includes>
    <includes id="a00461" name="bfs.h" local="no" imported="no">lemon/bfs.h</includes>
    <includes id="a00557" name="radix_sort.h" local="no" imported="no">lemon/radix_sort.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00481" name="bucket_heap.h" local="no" imported="no">lemon/bucket_heap.h</includes>
    <includes id="a00455" name="adaptors.h" local="no" imported="no">lemon/adaptors.h</includes>
    <includes id="a00509" name="edge_set.h" local="no" imported="no">lemon/edge_set.h</includes>
    <includes id="a00490" name="color.h" local="no" imported="no">lemon/color.h</includes>
    <includes id="a00507" name="dim2.h" local="no" imported="no">lemon/dim2.h</includes>
    <class kind="class">lemon::PlanarEmbedding</class>
    <class kind="class">lemon::PlanarDrawing</class>
    <class kind="class">lemon::PlanarColoring</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>bool</type>
      <name>checkPlanarity</name>
      <anchorfile>a00617.html</anchorfile>
      <anchor>ga230242aa2ee36f9b1b5a58f2c53016eb</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>preflow.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00554</filename>
    <includes id="a00566" name="tolerance.h" local="no" imported="no">lemon/tolerance.h</includes>
    <includes id="a00511" name="elevator.h" local="no" imported="no">lemon/elevator.h</includes>
    <class kind="struct">lemon::PreflowDefaultTraits</class>
    <class kind="class">lemon::Preflow</class>
    <class kind="struct">lemon::Preflow::SetFlowMap</class>
    <class kind="struct">lemon::Preflow::SetElevator</class>
    <class kind="struct">lemon::Preflow::SetStandardElevator</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>quad_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00555</filename>
    <class kind="class">lemon::QuadHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>radix_heap.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00556</filename>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <class kind="class">lemon::RadixHeap</class>
    <class kind="class">lemon::RadixHeap::PriorityUnderflowError</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>radix_sort.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00557</filename>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>void</type>
      <name>radixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga9a59ac695f0882ca6c606f4f9091ff97</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stableRadixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga85077aa44152133d90fd5aff65856b47</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00558</filename>
    <includes id="a00559" name="random.h" local="no" imported="no">lemon/random.h</includes>
    <namespace>lemon</namespace>
    <member kind="variable">
      <type>Random</type>
      <name>rnd</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>af55e529932608e88737901e3404d1d0e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00559</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00507" name="dim2.h" local="no" imported="no">lemon/dim2.h</includes>
    <class kind="class">lemon::Random</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>smart_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00560</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <class kind="class">lemon::SmartDigraph</class>
    <class kind="class">lemon::SmartDigraph::Snapshot</class>
    <class kind="class">lemon::SmartGraph</class>
    <class kind="class">lemon::SmartGraph::Snapshot</class>
    <class kind="class">lemon::SmartBpGraph</class>
    <class kind="class">lemon::SmartBpGraph::Snapshot</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>soplex.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00561</filename>
    <includes id="a00562" name="soplex.h" local="no" imported="no">lemon/soplex.h</includes>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>soplex.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00562</filename>
    <includes id="a00536" name="lp_base.h" local="no" imported="no">lemon/lp_base.h</includes>
    <class kind="class">lemon::SoplexLp</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>static_graph.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00563</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::StaticDigraph</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>suurballe.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00564</filename>
    <includes id="a00462" name="bin_heap.h" local="no" imported="no">lemon/bin_heap.h</includes>
    <includes id="a00551" name="path.h" local="no" imported="no">lemon/path.h</includes>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00506" name="dijkstra.h" local="no" imported="no">lemon/dijkstra.h</includes>
    <includes id="a00539" name="maps.h" local="no" imported="no">lemon/maps.h</includes>
    <class kind="struct">lemon::SuurballeDefaultTraits</class>
    <class kind="class">lemon::Suurballe</class>
    <class kind="struct">lemon::Suurballe::SetFlowMap</class>
    <class kind="struct">lemon::Suurballe::SetPotentialMap</class>
    <class kind="struct">lemon::Suurballe::SetPath</class>
    <class kind="struct">lemon::Suurballe::SetHeap</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>time_measure.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00565</filename>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <class kind="class">lemon::TimeStamp</class>
    <class kind="class">lemon::Timer</class>
    <class kind="class">lemon::TimeReport</class>
    <class kind="class">lemon::NoTimeReport</class>
    <namespace>lemon</namespace>
    <member kind="function">
      <type>TimeStamp</type>
      <name>runningTimeTest</name>
      <anchorfile>a00626.html</anchorfile>
      <anchor>ga5a016a4d710b59abefedf870d8b71bb8</anchor>
      <arglist>(F f, double min_time=10, unsigned int *num=NULL, TimeStamp *full_time=NULL)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tolerance.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00566</filename>
    <class kind="class">lemon::Tolerance</class>
    <class kind="class">lemon::Tolerance&lt; float &gt;</class>
    <class kind="class">lemon::Tolerance&lt; double &gt;</class>
    <class kind="class">lemon::Tolerance&lt; long double &gt;</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>unionfind.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/lemon/</path>
    <filename>a00567</filename>
    <includes id="a00498" name="core.h" local="no" imported="no">lemon/core.h</includes>
    <class kind="class">lemon::UnionFind</class>
    <class kind="class">lemon::UnionFindEnum</class>
    <class kind="class">lemon::UnionFindEnum::ClassIt</class>
    <class kind="class">lemon::UnionFindEnum::ItemIt</class>
    <class kind="class">lemon::ExtendFindEnum</class>
    <class kind="class">lemon::ExtendFindEnum::ClassIt</class>
    <class kind="class">lemon::ExtendFindEnum::ItemIt</class>
    <class kind="class">lemon::HeapUnionFind</class>
    <class kind="class">lemon::HeapUnionFind::ItemIt</class>
    <class kind="class">lemon::HeapUnionFind::ClassIt</class>
    <namespace>lemon</namespace>
  </compound>
  <compound kind="file">
    <name>test_tools.h</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/test/</path>
    <filename>a00568</filename>
    <member kind="define">
      <type>#define</type>
      <name>check</name>
      <anchorfile>a00568.html</anchorfile>
      <anchor>a1acdc408ee02ffd13dfbc7457fa01383</anchor>
      <arglist>(rc, msg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>dimacs-solver.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/tools/</path>
    <filename>a00569</filename>
    <includes id="a00560" name="smart_graph.h" local="no" imported="no">lemon/smart_graph.h</includes>
    <includes id="a00508" name="dimacs.h" local="no" imported="no">lemon/dimacs.h</includes>
    <includes id="a00532" name="lgf_writer.h" local="no" imported="no">lemon/lgf_writer.h</includes>
    <includes id="a00565" name="time_measure.h" local="no" imported="no">lemon/time_measure.h</includes>
    <includes id="a00457" name="arg_parser.h" local="no" imported="no">lemon/arg_parser.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
    <includes id="a00506" name="dijkstra.h" local="no" imported="no">lemon/dijkstra.h</includes>
    <includes id="a00554" name="preflow.h" local="no" imported="no">lemon/preflow.h</includes>
    <includes id="a00541" name="matching.h" local="no" imported="no">lemon/matching.h</includes>
    <includes id="a00548" name="network_simplex.h" local="no" imported="no">lemon/network_simplex.h</includes>
  </compound>
  <compound kind="file">
    <name>dimacs-to-lgf.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/tools/</path>
    <filename>a00570</filename>
    <includes id="a00560" name="smart_graph.h" local="no" imported="no">lemon/smart_graph.h</includes>
    <includes id="a00508" name="dimacs.h" local="no" imported="no">lemon/dimacs.h</includes>
    <includes id="a00532" name="lgf_writer.h" local="no" imported="no">lemon/lgf_writer.h</includes>
    <includes id="a00457" name="arg_parser.h" local="no" imported="no">lemon/arg_parser.h</includes>
    <includes id="a00512" name="error.h" local="no" imported="no">lemon/error.h</includes>
  </compound>
  <compound kind="file">
    <name>lgf-gen.cc</name>
    <path>/home/alpar/projects/LEMON/hg/lemon-1.3/tools/</path>
    <filename>a00571</filename>
    <includes id="a00533" name="list_graph.h" local="no" imported="no">lemon/list_graph.h</includes>
    <includes id="a00559" name="random.h" local="no" imported="no">lemon/random.h</includes>
    <includes id="a00507" name="dim2.h" local="no" imported="no">lemon/dim2.h</includes>
    <includes id="a00461" name="bfs.h" local="no" imported="no">lemon/bfs.h</includes>
    <includes id="a00500" name="counter.h" local="no" imported="no">lemon/counter.h</includes>
    <includes id="a00564" name="suurballe.h" local="no" imported="no">lemon/suurballe.h</includes>
    <includes id="a00520" name="graph_to_eps.h" local="no" imported="no">lemon/graph_to_eps.h</includes>
    <includes id="a00532" name="lgf_writer.h" local="no" imported="no">lemon/lgf_writer.h</includes>
    <includes id="a00457" name="arg_parser.h" local="no" imported="no">lemon/arg_parser.h</includes>
    <includes id="a00513" name="euler.h" local="no" imported="no">lemon/euler.h</includes>
    <includes id="a00542" name="math.h" local="no" imported="no">lemon/math.h</includes>
    <includes id="a00530" name="kruskal.h" local="no" imported="no">lemon/kruskal.h</includes>
    <includes id="a00565" name="time_measure.h" local="no" imported="no">lemon/time_measure.h</includes>
  </compound>
  <compound kind="page">
    <name>coding_style</name>
    <title>LEMON Coding Style</title>
    <filename>a00002</filename>
    <docanchor file="a00002" title="Naming Conventions">naming_conv</docanchor>
    <docanchor file="a00002" title="File Names">cs-files</docanchor>
    <docanchor file="a00002" title="Classes and other types">cs-class</docanchor>
    <docanchor file="a00002" title="Methods and other functions">cs-func</docanchor>
    <docanchor file="a00002" title="Constants, Macros">cs-funcs</docanchor>
    <docanchor file="a00002" title="Class and instance member variables, auto variables">cs-loc-var</docanchor>
    <docanchor file="a00002" title="Private member variables">pri-loc-var</docanchor>
    <docanchor file="a00002" title="Exceptions">cs-excep</docanchor>
    <docanchor file="a00002" title="Template Header File">header-template</docanchor>
  </compound>
  <compound kind="page">
    <name>lgf-format</name>
    <title>LEMON Graph Format (LGF)</title>
    <filename>a00004</filename>
  </compound>
  <compound kind="page">
    <name>license</name>
    <title>License Terms</title>
    <filename>a00006</filename>
  </compound>
  <compound kind="page">
    <name>migration</name>
    <title>Migration from the 0.x Series</title>
    <filename>a00008</filename>
    <docanchor file="a00008" title="Graph Related Name Changes">migration-graph</docanchor>
    <docanchor file="a00008" title="LGF tools">migration-lgf</docanchor>
    <docanchor file="a00008" title="BFS, DFS and Dijkstra">migration-search</docanchor>
    <docanchor file="a00008" title="Exceptions and Debug tools">migration-error</docanchor>
    <docanchor file="a00008" title="Others">migration-other</docanchor>
  </compound>
  <compound kind="page">
    <name>min_cost_flow</name>
    <title>Minimum Cost Flow Problem</title>
    <filename>a00010</filename>
    <docanchor file="a00010" title="Definition (GEQ form)">mcf_def</docanchor>
    <docanchor file="a00010" title="Algorithms">mcf_algs</docanchor>
    <docanchor file="a00010" title="Dual Solution">mcf_dual</docanchor>
    <docanchor file="a00010" title="Equality Form">mcf_eq</docanchor>
    <docanchor file="a00010" title="Opposite Inequalites (LEQ Form)">mcf_leq</docanchor>
  </compound>
  <compound kind="page">
    <name>named-param</name>
    <title>Named Parameters</title>
    <filename>a00012</filename>
    <docanchor file="a00012" title="Named Function Parameters">named-func-param</docanchor>
    <docanchor file="a00012" title="Named Function Template Parameters">named-templ-func-param</docanchor>
    <docanchor file="a00012" title="Traits Classes">traits-classes</docanchor>
    <docanchor file="a00012" title="Named Class Template Parameters">named-templ-param</docanchor>
  </compound>
  <compound kind="group">
    <name>datas</name>
    <title>Data Structures</title>
    <filename>a00597.html</filename>
    <subgroup>graphs</subgroup>
    <subgroup>maps</subgroup>
    <subgroup>paths</subgroup>
    <subgroup>heaps</subgroup>
    <subgroup>auxdat</subgroup>
  </compound>
  <compound kind="group">
    <name>graphs</name>
    <title>Graph Structures</title>
    <filename>a00598.html</filename>
    <class kind="class">lemon::ListArcSet</class>
    <class kind="class">lemon::ListEdgeSet</class>
    <class kind="class">lemon::SmartArcSet</class>
    <class kind="class">lemon::SmartEdgeSet</class>
    <class kind="class">lemon::FullDigraph</class>
    <class kind="class">lemon::FullGraph</class>
    <class kind="class">lemon::FullBpGraph</class>
    <class kind="class">lemon::GridGraph</class>
    <class kind="class">lemon::HypercubeGraph</class>
    <class kind="class">lemon::ListDigraph</class>
    <class kind="class">lemon::ListGraph</class>
    <class kind="class">lemon::ListBpGraph</class>
    <class kind="class">lemon::SmartDigraph</class>
    <class kind="class">lemon::SmartGraph</class>
    <class kind="class">lemon::SmartBpGraph</class>
    <class kind="class">lemon::StaticDigraph</class>
    <subgroup>graph_adaptors</subgroup>
    <file>edge_set.h</file>
    <file>full_graph.h</file>
    <file>grid_graph.h</file>
    <file>hypercube_graph.h</file>
    <file>list_graph.h</file>
    <file>smart_graph.h</file>
    <file>static_graph.h</file>
  </compound>
  <compound kind="group">
    <name>graph_adaptors</name>
    <title>Adaptor Classes for Graphs</title>
    <filename>a00599.html</filename>
    <class kind="class">lemon::ReverseDigraph</class>
    <class kind="class">lemon::SubDigraph</class>
    <class kind="class">lemon::SubGraph</class>
    <class kind="class">lemon::FilterNodes</class>
    <class kind="class">lemon::FilterArcs</class>
    <class kind="class">lemon::FilterEdges</class>
    <class kind="class">lemon::Undirector</class>
    <class kind="class">lemon::Orienter</class>
    <class kind="class">lemon::ResidualDigraph</class>
    <class kind="class">lemon::SplitNodes</class>
    <file>adaptors.h</file>
    <member kind="function">
      <type>ReverseDigraph&lt; const DGR &gt;</type>
      <name>reverseDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga79c1b665b375986e20577c316a2abd64</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>SubDigraph&lt; const DGR, NF, AF &gt;</type>
      <name>subDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga4ecbcee43f13c2eaf1bedc4b2c8467ad</anchor>
      <arglist>(const DGR &amp;digraph, NF &amp;node_filter, AF &amp;arc_filter)</arglist>
    </member>
    <member kind="function">
      <type>SubGraph&lt; const GR, NF, EF &gt;</type>
      <name>subGraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gad30bffcd2a193a2366b54593a98bf7a3</anchor>
      <arglist>(const GR &amp;graph, NF &amp;node_filter, EF &amp;edge_filter)</arglist>
    </member>
    <member kind="function">
      <type>FilterNodes&lt; const GR, NF &gt;</type>
      <name>filterNodes</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaa682c0f382bd7ea7227e29c5d45fd33d</anchor>
      <arglist>(const GR &amp;graph, NF &amp;node_filter)</arglist>
    </member>
    <member kind="function">
      <type>FilterArcs&lt; const DGR, AF &gt;</type>
      <name>filterArcs</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gad6a800aaf8aa5c85de6ab3ff3b828905</anchor>
      <arglist>(const DGR &amp;digraph, AF &amp;arc_filter)</arglist>
    </member>
    <member kind="function">
      <type>FilterEdges&lt; const GR, EF &gt;</type>
      <name>filterEdges</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaddd9874f4d5ad214e8f0d4f252c989ee</anchor>
      <arglist>(const GR &amp;graph, EF &amp;edge_filter)</arglist>
    </member>
    <member kind="function">
      <type>Undirector&lt; const DGR &gt;</type>
      <name>undirector</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaebf4f5d421ecb3a11161a2efca58bbd9</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>Orienter&lt; const GR, DM &gt;</type>
      <name>orienter</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaf0baa7971373781e810c9b8855cb63c6</anchor>
      <arglist>(const GR &amp;graph, DM &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>ResidualDigraph&lt; DGR, CM, FM &gt;</type>
      <name>residualDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga16137e105dd234d7e29ff30aebb01a21</anchor>
      <arglist>(const DGR &amp;digraph, const CM &amp;capacity_map, FM &amp;flow_map)</arglist>
    </member>
    <member kind="function">
      <type>SplitNodes&lt; DGR &gt;</type>
      <name>splitNodes</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gabf58921acaca2eb95d042e2d7440ac20</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>maps</name>
    <title>Maps</title>
    <filename>a00600.html</filename>
    <class kind="class">lemon::MapBase</class>
    <class kind="class">lemon::NullMap</class>
    <class kind="class">lemon::ConstMap</class>
    <class kind="class">lemon::ConstMap&lt; K, Const&lt; V, v &gt; &gt;</class>
    <class kind="class">lemon::IdentityMap</class>
    <class kind="class">lemon::RangeMap</class>
    <class kind="class">lemon::SparseMap</class>
    <class kind="class">lemon::TrueMap</class>
    <class kind="class">lemon::FalseMap</class>
    <class kind="class">lemon::LoggerBoolMap</class>
    <subgroup>graph_maps</subgroup>
    <subgroup>map_adaptors</subgroup>
    <file>maps.h</file>
    <member kind="function">
      <type>NullMap&lt; K, V &gt;</type>
      <name>nullMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>gacabbe73018c55fcda9e77e4450a2742f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstMap&lt; K, V &gt;</type>
      <name>constMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>gae8767f0b0e20d31ee7af27a0e057bee2</anchor>
      <arglist>(const V &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>ConstMap&lt; K, Const&lt; V, v &gt; &gt;</type>
      <name>constMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga16ec5e6f4258e1da61b9c297f97cebbc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>IdentityMap&lt; T &gt;</type>
      <name>identityMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>gaa15ca3c8150c620c3b368c55068801a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RangeMap&lt; V &gt;</type>
      <name>rangeMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga16158762fc81f259cf1daf81d0471569</anchor>
      <arglist>(int size=0, const V &amp;value=V())</arglist>
    </member>
    <member kind="function">
      <type>RangeMap&lt; V &gt;</type>
      <name>rangeMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>gab25738127ed9049a5205af0b2fdc9909</anchor>
      <arglist>(const std::vector&lt; V &gt; &amp;vector)</arglist>
    </member>
    <member kind="function">
      <type>SparseMap&lt; K, V, Compare &gt;</type>
      <name>sparseMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga2bced372308b364deaa17683861a4e05</anchor>
      <arglist>(const V &amp;value=V())</arglist>
    </member>
    <member kind="function">
      <type>SparseMap&lt; K, V, Compare &gt; return</type>
      <name>SparseMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga918e4ab62caab6fe621fac3db0ec2979</anchor>
      <arglist>(map, value)</arglist>
    </member>
    <member kind="function">
      <type>TrueMap&lt; K &gt;</type>
      <name>trueMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga58e5052d50110f3f5cb312b38c31b805</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FalseMap&lt; K &gt;</type>
      <name>falseMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>gac84b9c1328d8cd93e401782f1c3f70a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LoggerBoolMap&lt; Iterator &gt;</type>
      <name>loggerBoolMap</name>
      <anchorfile>a00600.html</anchorfile>
      <anchor>ga9911949acec69b07b642c082c65d810c</anchor>
      <arglist>(Iterator it)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>graph_maps</name>
    <title>Graph Maps</title>
    <filename>a00601.html</filename>
    <class kind="class">lemon::IdMap</class>
    <class kind="class">lemon::CrossRefMap</class>
    <class kind="class">lemon::RangeIdMap</class>
    <class kind="class">lemon::IterableBoolMap</class>
    <class kind="class">lemon::IterableIntMap</class>
    <class kind="class">lemon::IterableValueMap</class>
    <class kind="class">lemon::SourceMap</class>
    <class kind="class">lemon::TargetMap</class>
    <class kind="class">lemon::ForwardMap</class>
    <class kind="class">lemon::BackwardMap</class>
    <class kind="class">lemon::InDegMap</class>
    <class kind="class">lemon::OutDegMap</class>
    <class kind="class">lemon::PotentialDifferenceMap</class>
    <member kind="function">
      <type>void</type>
      <name>mapCopy</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gacd3b1378e8d938e2f4f831cda62d7196</anchor>
      <arglist>(const GR &amp;gr, const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mapCompare</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad05d27a9d1f23407ab2960b48a9b7582</anchor>
      <arglist>(const GR &amp;gr, const Map1 &amp;map1, const Map2 &amp;map2)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga6119b9344a9c76eb7fca2f57f67732e4</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8c1dd57a1af8310ca04d57a70f3f659c</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga87e0df0934bba2996ec5c9b6907de88d</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga262a78bd1f36223d520ffde235730cb9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga3be91b854e7788d89047f161378fce58</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga712ba7c8df94bd02f28d6e08d11176f7</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga72688c2e41aa36efa56431b5b585a1c1</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga7b5174f049f1fd63844d2c914832cbcc</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFind</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8469265a9d93f69c9402756ffe86bcab</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFindIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad5e8addbccd1e43a3add48108020ffbd</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCount</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gafe30fc86a55d33ad6811f3cc835b4cf9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCountIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga33891e575e55c0f9ec0dac31923119b8</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mapFill</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gabbcca4c1a7f23a9f39e97e24dc8c54fc</anchor>
      <arglist>(const GR &amp;gr, Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>IdMap&lt; GR, K &gt;</type>
      <name>idMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga816a286bed06ff2b19089dbf5ebac20a</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>RangeIdMap&lt; GR, K &gt;</type>
      <name>rangeIdMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gac058be03cd677659864d5ff0a240d8ca</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>SourceMap&lt; GR &gt;</type>
      <name>sourceMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga7e40f56fb58a47cf11acf45a53319196</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>TargetMap&lt; GR &gt;</type>
      <name>targetMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga76cedc40d120db6feb12f5ae6ea878ba</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>ForwardMap&lt; GR &gt;</type>
      <name>forwardMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga658f2b3a54c7e6e15b47b38bbc588e46</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>BackwardMap&lt; GR &gt;</type>
      <name>backwardMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga76a84fc9fdb56bcd00cf437cd1d31cdb</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>PotentialDifferenceMap&lt; GR, POT &gt;</type>
      <name>potentialDifferenceMap</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga1817fbea6492f6effbb2f97f1f063349</anchor>
      <arglist>(const GR &amp;gr, const POT &amp;potential)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>map_adaptors</name>
    <title>Map Adaptors</title>
    <filename>a00602.html</filename>
    <class kind="class">lemon::ComposeMap</class>
    <class kind="class">lemon::CombineMap</class>
    <class kind="class">lemon::FunctorToMap</class>
    <class kind="class">lemon::MapToFunctor</class>
    <class kind="class">lemon::ConvertMap</class>
    <class kind="class">lemon::ForkMap</class>
    <class kind="class">lemon::AddMap</class>
    <class kind="class">lemon::SubMap</class>
    <class kind="class">lemon::MulMap</class>
    <class kind="class">lemon::DivMap</class>
    <class kind="class">lemon::ShiftMap</class>
    <class kind="class">lemon::ShiftWriteMap</class>
    <class kind="class">lemon::ScaleMap</class>
    <class kind="class">lemon::ScaleWriteMap</class>
    <class kind="class">lemon::NegMap</class>
    <class kind="class">lemon::NegWriteMap</class>
    <class kind="class">lemon::AbsMap</class>
    <class kind="class">lemon::AndMap</class>
    <class kind="class">lemon::OrMap</class>
    <class kind="class">lemon::NotMap</class>
    <class kind="class">lemon::NotWriteMap</class>
    <class kind="class">lemon::EqualMap</class>
    <class kind="class">lemon::LessMap</class>
    <member kind="function">
      <type>ComposeMap&lt; M1, M2 &gt;</type>
      <name>composeMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gac36b354e8e808fba48e18cf15db5100f</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>CombineMap&lt; M1, M2, F, V &gt;</type>
      <name>combineMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gafa8530beb88cb34532f35a6e121e0007</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2, const F &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>FunctorToMap&lt; F, K, V &gt;</type>
      <name>functorToMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gab0aac0bb0604df94df88ad5fef5f391c</anchor>
      <arglist>(const F &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>MapToFunctor&lt; M &gt;</type>
      <name>mapToFunctor</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga0a68bad2e29c1486f3cc8d7a0cf056e1</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>ConvertMap&lt; M, V &gt;</type>
      <name>convertMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga4abd9551cd490eec5bec69576d4a6dbb</anchor>
      <arglist>(const M &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>ForkMap&lt; M1, M2 &gt;</type>
      <name>forkMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga7b7cf375700909175bae19eee48a9962</anchor>
      <arglist>(M1 &amp;m1, M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>AddMap&lt; M1, M2 &gt;</type>
      <name>addMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga198bc5656b8dd90ac511504536a9965a</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>SubMap&lt; M1, M2 &gt;</type>
      <name>subMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga6101bbe8a787e7bf7998d529632edcdd</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>MulMap&lt; M1, M2 &gt;</type>
      <name>mulMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gaf61fff11e845e77cbd7530b10b75aa17</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>DivMap&lt; M1, M2 &gt;</type>
      <name>divMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga166e4520ea24f6a0ef094898df89f180</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>ShiftMap&lt; M, C &gt;</type>
      <name>shiftMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga840b730cb65a418b9d890c27dfa63a27</anchor>
      <arglist>(const M &amp;m, const C &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>ShiftWriteMap&lt; M, C &gt;</type>
      <name>shiftWriteMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga9c1611cd915bd96577b7f5e9607c834b</anchor>
      <arglist>(M &amp;m, const C &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>ScaleMap&lt; M, C &gt;</type>
      <name>scaleMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga7ce03f4c101f1297901c5ce840543006</anchor>
      <arglist>(const M &amp;m, const C &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>ScaleWriteMap&lt; M, C &gt;</type>
      <name>scaleWriteMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga7e7cd505ab3725fdf5785746544eea66</anchor>
      <arglist>(M &amp;m, const C &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>NegMap&lt; M &gt;</type>
      <name>negMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gac47c5a97a29055bfc88314591fdfdf42</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>NegWriteMap&lt; M &gt;</type>
      <name>negWriteMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gaacce5676587f1d1e7c7d810cfd2e7ff1</anchor>
      <arglist>(M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>AbsMap&lt; M &gt;</type>
      <name>absMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gabb163469d214f85023ebb74c2801a0a1</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>AndMap&lt; M1, M2 &gt;</type>
      <name>andMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga2e998d08fcf3ef385717fdd4e0d983d8</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>OrMap&lt; M1, M2 &gt;</type>
      <name>orMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga06463d7799cefda558eaec8392160529</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>NotMap&lt; M &gt;</type>
      <name>notMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gac32d5dbe669fc9a75c4ab8ee12db0c12</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>NotWriteMap&lt; M &gt;</type>
      <name>notWriteMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gac156aa2d3b004c46cd1189aa5459f6e4</anchor>
      <arglist>(M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>EqualMap&lt; M1, M2 &gt;</type>
      <name>equalMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>gaabcc26e4e6ddc3ff6b98801c115b26bc</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
    <member kind="function">
      <type>LessMap&lt; M1, M2 &gt;</type>
      <name>lessMap</name>
      <anchorfile>a00602.html</anchorfile>
      <anchor>ga4c49f5cdfa8c2484f4fd1a8ce476ba14</anchor>
      <arglist>(const M1 &amp;m1, const M2 &amp;m2)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>paths</name>
    <title>Path Structures</title>
    <filename>a00603.html</filename>
    <class kind="class">lemon::Path</class>
    <class kind="class">lemon::SimplePath</class>
    <class kind="class">lemon::ListPath</class>
    <class kind="class">lemon::StaticPath</class>
    <class kind="class">lemon::PathNodeIt</class>
    <file>path.h</file>
    <member kind="function">
      <type>void</type>
      <name>pathCopy</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga1c0da351dc554629ec44013576637e7d</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copyPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga437e79537f340c99bb743bc928cb0a10</anchor>
      <arglist>(To &amp;to, const From &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga72529b1d8158a18d4a428dc3eab15a69</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathSource</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga8cd2b147cef7e0a4fa05145908d95c15</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathTarget</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga885afd9d4ba099bf2d8104e6e0408b66</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>heaps</name>
    <title>Heap Structures</title>
    <filename>a00604.html</filename>
    <class kind="class">lemon::BinHeap</class>
    <class kind="class">lemon::BinomialHeap</class>
    <class kind="class">lemon::BucketHeap</class>
    <class kind="class">lemon::SimpleBucketHeap</class>
    <class kind="class">lemon::DHeap</class>
    <class kind="class">lemon::FibHeap</class>
    <class kind="class">lemon::PairingHeap</class>
    <class kind="class">lemon::QuadHeap</class>
    <class kind="class">lemon::RadixHeap</class>
    <file>bin_heap.h</file>
    <file>binomial_heap.h</file>
    <file>bucket_heap.h</file>
    <file>dheap.h</file>
    <file>fib_heap.h</file>
    <file>pairing_heap.h</file>
    <file>quad_heap.h</file>
    <file>radix_heap.h</file>
  </compound>
  <compound kind="group">
    <name>auxdat</name>
    <title>Auxiliary Data Structures</title>
    <filename>a00605.html</filename>
    <class kind="class">lemon::Elevator</class>
    <class kind="class">lemon::LinkedElevator</class>
    <class kind="class">lemon::UnionFind</class>
    <class kind="class">lemon::UnionFindEnum</class>
    <class kind="class">lemon::ExtendFindEnum</class>
    <class kind="class">lemon::HeapUnionFind</class>
    <subgroup>geomdat</subgroup>
    <file>elevator.h</file>
    <file>unionfind.h</file>
  </compound>
  <compound kind="group">
    <name>geomdat</name>
    <title>Geometric Data Structures</title>
    <filename>a00606.html</filename>
    <class kind="class">lemon::dim2::Point</class>
    <class kind="class">lemon::dim2::Box</class>
    <class kind="class">lemon::dim2::XMap</class>
    <class kind="class">lemon::dim2::ConstXMap</class>
    <class kind="class">lemon::dim2::YMap</class>
    <class kind="class">lemon::dim2::ConstYMap</class>
    <class kind="class">lemon::dim2::NormSquareMap</class>
    <file>dim2.h</file>
    <member kind="function">
      <type>Point&lt; T &gt;</type>
      <name>makePoint</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>gaecc91205bbef122826613af7d8ef7c10</anchor>
      <arglist>(const T &amp;x, const T &amp;y)</arglist>
    </member>
    <member kind="function">
      <type>Point&lt; T &gt;</type>
      <name>operator*</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga762dc161f1356814820d95a6c3ebb394</anchor>
      <arglist>(const T &amp;u, const Point&lt; T &gt; &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>std::istream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga22e95035881a7964352c5eb9b46a3ca5</anchor>
      <arglist>(std::istream &amp;is, Point&lt; T &gt; &amp;z)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga70027f9df22e7e13aa89877de52d1064</anchor>
      <arglist>(std::ostream &amp;os, const Point&lt; T &gt; &amp;z)</arglist>
    </member>
    <member kind="function">
      <type>Point&lt; T &gt;</type>
      <name>rot90</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>gaf827f37672f98e93c11ea37f3fc078e3</anchor>
      <arglist>(const Point&lt; T &gt; &amp;z)</arglist>
    </member>
    <member kind="function">
      <type>Point&lt; T &gt;</type>
      <name>rot180</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga1837137f4a27eeda082094710fbb3201</anchor>
      <arglist>(const Point&lt; T &gt; &amp;z)</arglist>
    </member>
    <member kind="function">
      <type>Point&lt; T &gt;</type>
      <name>rot270</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga98212a9b188bc640993e7fdb274cd7a3</anchor>
      <arglist>(const Point&lt; T &gt; &amp;z)</arglist>
    </member>
    <member kind="function">
      <type>std::istream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga19c3bfbad77c6e998e017eadf75c2782</anchor>
      <arglist>(std::istream &amp;is, Box&lt; T &gt; &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>gac52c35829fbea8c6f4f42e15ae3a16c1</anchor>
      <arglist>(std::ostream &amp;os, const Box&lt; T &gt; &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>XMap&lt; M &gt;</type>
      <name>xMap</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>gae41a8ab860bdbb63080b0e509c487c57</anchor>
      <arglist>(M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>ConstXMap&lt; M &gt;</type>
      <name>xMap</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga089526b0c8613c8167ee758056c79672</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>YMap&lt; M &gt;</type>
      <name>yMap</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga4b8a44ffc54cb9a2db2517d2a17f18af</anchor>
      <arglist>(M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>ConstYMap&lt; M &gt;</type>
      <name>yMap</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>gacd6c062290503f0e72b7ff1e3ac82bcd</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>NormSquareMap&lt; M &gt;</type>
      <name>normSquareMap</name>
      <anchorfile>a00606.html</anchorfile>
      <anchor>ga55234f3b00cf61ed7bf2a74cfd88fbfd</anchor>
      <arglist>(const M &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>algs</name>
    <title>Algorithms</title>
    <filename>a00607.html</filename>
    <subgroup>search</subgroup>
    <subgroup>shortest_path</subgroup>
    <subgroup>spantree</subgroup>
    <subgroup>max_flow</subgroup>
    <subgroup>min_cost_flow_algs</subgroup>
    <subgroup>min_cut</subgroup>
    <subgroup>min_mean_cycle</subgroup>
    <subgroup>matching</subgroup>
    <subgroup>graph_properties</subgroup>
    <subgroup>planar</subgroup>
    <subgroup>tsp</subgroup>
    <subgroup>approx_algs</subgroup>
    <subgroup>auxalg</subgroup>
  </compound>
  <compound kind="group">
    <name>search</name>
    <title>Graph Search</title>
    <filename>a00608.html</filename>
    <class kind="class">lemon::Bfs</class>
    <class kind="class">lemon::BfsVisit</class>
    <class kind="class">lemon::Dfs</class>
    <class kind="class">lemon::DfsVisit</class>
    <class kind="class">lemon::MaxCardinalitySearch</class>
    <file>bfs.h</file>
    <file>dfs.h</file>
    <file>max_cardinality_search.h</file>
    <member kind="function">
      <type>BfsWizard&lt; BfsWizardBase&lt; GR &gt; &gt;</type>
      <name>bfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>ga99817221896aba2eb403691a0a230a0b</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; DfsWizardBase&lt; GR &gt; &gt;</type>
      <name>dfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>gaa6a12c70b10ad9693117ec2b3774b0d8</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>shortest_path</name>
    <title>Shortest Path Algorithms</title>
    <filename>a00609.html</filename>
    <class kind="class">lemon::BellmanFord</class>
    <class kind="class">lemon::Dijkstra</class>
    <class kind="class">lemon::Suurballe</class>
    <file>bellman_ford.h</file>
    <file>dijkstra.h</file>
    <file>suurballe.h</file>
    <member kind="function">
      <type>BellmanFordWizard&lt; BellmanFordWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>bellmanFord</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>ga359aa931ac3c9550d5b5b5f3ec2e9e56</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; DijkstraWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>dijkstra</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>gaa781be76e5adb6a9df7592457a5c3857</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>spantree</name>
    <title>Minimum Spanning Tree Algorithms</title>
    <filename>a00610.html</filename>
    <class kind="class">lemon::MinCostArborescence</class>
    <file>kruskal.h</file>
    <file>min_cost_arborescence.h</file>
    <member kind="function">
      <type>Value</type>
      <name>kruskal</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga233792b2c44a3581b85a775703e045af</anchor>
      <arglist>(const Graph &amp;g, const In &amp;in, Out &amp;out)</arglist>
    </member>
    <member kind="function">
      <type>CostMap::Value</type>
      <name>minCostArborescence</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga0faeb92308e21beeb093ee6c967a2cb5</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost, typename Digraph::Node source, ArborescenceMap &amp;arborescence)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>max_flow</name>
    <title>Maximum Flow Algorithms</title>
    <filename>a00611.html</filename>
    <class kind="class">lemon::Circulation</class>
    <class kind="class">lemon::EdmondsKarp</class>
    <class kind="class">lemon::Preflow</class>
    <file>circulation.h</file>
    <file>edmonds_karp.h</file>
    <file>preflow.h</file>
  </compound>
  <compound kind="group">
    <name>min_cost_flow_algs</name>
    <title>Minimum Cost Flow Algorithms</title>
    <filename>a00612.html</filename>
    <class kind="class">lemon::CapacityScaling</class>
    <class kind="class">lemon::CostScaling</class>
    <class kind="class">lemon::CycleCanceling</class>
    <class kind="class">lemon::NetworkSimplex</class>
    <file>capacity_scaling.h</file>
    <file>cost_scaling.h</file>
    <file>cycle_canceling.h</file>
    <file>network_simplex.h</file>
  </compound>
  <compound kind="group">
    <name>min_cut</name>
    <title>Minimum Cut Algorithms</title>
    <filename>a00613.html</filename>
    <class kind="class">lemon::GomoryHu</class>
    <class kind="class">lemon::HaoOrlin</class>
    <class kind="class">lemon::NagamochiIbaraki</class>
    <file>gomory_hu.h</file>
    <file>hao_orlin.h</file>
    <file>nagamochi_ibaraki.h</file>
  </compound>
  <compound kind="group">
    <name>min_mean_cycle</name>
    <title>Minimum Mean Cycle Algorithms</title>
    <filename>a00614.html</filename>
    <class kind="class">lemon::HartmannOrlinMmc</class>
    <class kind="class">lemon::HowardMmc</class>
    <class kind="class">lemon::KarpMmc</class>
    <file>hartmann_orlin_mmc.h</file>
    <file>howard_mmc.h</file>
    <file>karp_mmc.h</file>
  </compound>
  <compound kind="group">
    <name>matching</name>
    <title>Matching Algorithms</title>
    <filename>a00615.html</filename>
    <class kind="class">lemon::MaxFractionalMatching</class>
    <class kind="class">lemon::MaxWeightedFractionalMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectFractionalMatching</class>
    <class kind="class">lemon::MaxMatching</class>
    <class kind="class">lemon::MaxWeightedMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectMatching</class>
    <file>fractional_matching.h</file>
    <file>matching.h</file>
  </compound>
  <compound kind="group">
    <name>graph_properties</name>
    <title>Connectivity and Other Graph Properties</title>
    <filename>a00616.html</filename>
    <class kind="class">lemon::DiEulerIt</class>
    <class kind="class">lemon::EulerIt</class>
    <file>connectivity.h</file>
    <file>euler.h</file>
    <member kind="function">
      <type>bool</type>
      <name>connected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad5c8d1b650f6b614a852f8430d90e184</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga33a9d9d4803cb15e83568b2526e978a5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa467a3e0a8c2e9e762650fd01fadff89</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stronglyConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gacd21b34d7b42b9835a204a57fcf15964</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countStronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad30bc47dfffb78234eeee903cb3766f4</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga46f8c22f3e2989c4689faa4c46ec9436</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedCutArcs</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad7af5c3a97453e37f251f0e86dbb83db</anchor>
      <arglist>(const Digraph &amp;digraph, ArcMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biNodeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gac9257323ead7cbe64b7b4a628c4876b3</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf7c5744b2175210b8ea67897aaa27885</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga9d70526ab54e10b4b6fe3762af8675dd</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedCutNodes</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga31461f33a748327ea3ef2a3199ffb6c7</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biEdgeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga37d22a2ddd5a064a9203720f2b93518e</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga4d5db78dc21099d075c3967484990954</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga76c1fdd1881d21677507100b7e96c983</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedCutEdges</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58d444eba448c5f1a53539bd1b69636e</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dag</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaef2b43c8cd1d74e15fa5c7607bc5e396</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>topologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafc2cb20cf3859f157c0e12da7f310bb3</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedTopologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf10c5e1630e5720c20d83cfb77dbf024</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acyclic</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga14c191b2133a1dd23e1527f074c821c0</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>tree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad1e4de234e926958647905478415bd54</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartite</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga577db110d33bd487aaad5bfffb31c6f5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartitePartitions</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58ba1d00c569f0eb0deb42afca9f80bb</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;partMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loopFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga127f3963003cd532c79c226885fe1c8c</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parallelFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa05e0683f90b69f31eb29fe7d09afde4</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>simpleGraph</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gae4c7ae734e2509ab78dc747d602c9236</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eulerian</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafb5a4961cac4d877006869fc4cb6ea1d</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>planar</name>
    <title>Planar Embedding and Drawing</title>
    <filename>a00617.html</filename>
    <class kind="class">lemon::PlanarEmbedding</class>
    <class kind="class">lemon::PlanarDrawing</class>
    <class kind="class">lemon::PlanarColoring</class>
    <file>planarity.h</file>
    <member kind="function">
      <type>bool</type>
      <name>checkPlanarity</name>
      <anchorfile>a00617.html</anchorfile>
      <anchor>ga230242aa2ee36f9b1b5a58f2c53016eb</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>tsp</name>
    <title>Traveling Salesman Problem</title>
    <filename>a00618.html</filename>
    <class kind="class">lemon::ChristofidesTsp</class>
    <class kind="class">lemon::GreedyTsp</class>
    <class kind="class">lemon::InsertionTsp</class>
    <class kind="class">lemon::NearestNeighborTsp</class>
    <class kind="class">lemon::Opt2Tsp</class>
    <file>christofides_tsp.h</file>
    <file>greedy_tsp.h</file>
    <file>insertion_tsp.h</file>
    <file>nearest_neighbor_tsp.h</file>
    <file>opt2_tsp.h</file>
  </compound>
  <compound kind="group">
    <name>approx_algs</name>
    <title>Approximation Algorithms</title>
    <filename>a00619.html</filename>
    <class kind="class">lemon::GrossoLocatelliPullanMc</class>
    <file>grosso_locatelli_pullan_mc.h</file>
  </compound>
  <compound kind="group">
    <name>auxalg</name>
    <title>Auxiliary Algorithms</title>
    <filename>a00620.html</filename>
    <file>radix_sort.h</file>
    <member kind="function">
      <type>void</type>
      <name>radixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga9a59ac695f0882ca6c606f4f9091ff97</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stableRadixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga85077aa44152133d90fd5aff65856b47</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>gen_opt_group</name>
    <title>General Optimization Tools</title>
    <filename>a00621.html</filename>
    <subgroup>lp_group</subgroup>
  </compound>
  <compound kind="group">
    <name>lp_group</name>
    <title>LP and MIP Solvers</title>
    <filename>a00622.html</filename>
    <class kind="class">lemon::CbcMip</class>
    <class kind="class">lemon::ClpLp</class>
    <class kind="class">lemon::CplexBase</class>
    <class kind="class">lemon::CplexLp</class>
    <class kind="class">lemon::CplexMip</class>
    <class kind="class">lemon::GlpkBase</class>
    <class kind="class">lemon::GlpkLp</class>
    <class kind="class">lemon::GlpkMip</class>
    <class kind="class">lemon::LpBase</class>
    <class kind="class">lemon::LpSolver</class>
    <class kind="class">lemon::MipSolver</class>
    <class kind="class">lemon::LpSkeleton</class>
    <class kind="class">lemon::MipSkeleton</class>
    <class kind="class">lemon::SoplexLp</class>
    <file>cbc.h</file>
    <file>glpk.h</file>
    <file>lp.h</file>
    <file>lp_base.h</file>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEFAULT_LP</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>ga459ae538832b3817b7692a81de79d744</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEFAULT_MIP</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>gae4ce37e43b0032f13b3efa0e0b0af640</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlpkLp</type>
      <name>Lp</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>ga8c6461f78849b26ae8be11062410d043</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlpkMip</type>
      <name>Mip</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>gad4ee17c56e133b01b9d75eb2cefd4d7f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>utils</name>
    <title>Tools and Utilities</title>
    <filename>a00623.html</filename>
    <subgroup>gutils</subgroup>
    <subgroup>misc</subgroup>
    <subgroup>exceptions</subgroup>
  </compound>
  <compound kind="group">
    <name>gutils</name>
    <title>Basic Graph Utilities</title>
    <filename>a00624.html</filename>
    <class kind="class">lemon::DigraphCopy</class>
    <class kind="class">lemon::GraphCopy</class>
    <class kind="class">lemon::BpGraphCopy</class>
    <class kind="class">lemon::ConArcIt</class>
    <class kind="class">lemon::ConEdgeIt</class>
    <class kind="class">lemon::DynArcLookUp</class>
    <class kind="class">lemon::ArcLookUp</class>
    <class kind="class">lemon::AllArcLookUp</class>
    <member kind="define">
      <type>#define</type>
      <name>DIGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac618f30ace596c69836144bfdcc9112c</anchor>
      <arglist>(Digraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_DIGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga14ef90d8fd45b56f1cc2c5023c76c4b1</anchor>
      <arglist>(Digraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gab8c497e4257836f4669b8922237d830b</anchor>
      <arglist>(Graph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_GRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gab0e6cf49071e60eda3e15e2b0e0d8310</anchor>
      <arglist>(Graph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>BPGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac8d6365af7bc18ed8d55d0d4e752399f</anchor>
      <arglist>(BpGraph)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TEMPLATE_BPGRAPH_TYPEDEFS</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga1442da4c0ddce15a9a5f651693d7ab57</anchor>
      <arglist>(BpGraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countItems</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga65f512e54ae6256fcd098592fc582e50</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga9156d36059e59ebc8dc14bad0112633d</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countRedNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac1a04fa8a9e0460accf28c5337b2c5eb</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBlueNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga40c1bf81c7096481ca39f286eeb74163</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga1b3307d4e63c19d4ebadf133ebb43683</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaede53fc1ef848a03b7f844a5ec7eeca6</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countOutArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaf199da654058dd16da1702f38b60f30c</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countInArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga03d0d2f770d7f7faac66438139ae9b18</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countIncEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gae93681c4e849f6fd3a102fcb2756e317</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>undirected</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaa7a3075a14f2acde20f1d999675a8040</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy&lt; From, To &gt;</type>
      <name>digraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga47e4bf893a80e68971c511735117c707</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy&lt; From, To &gt;</type>
      <name>graphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga6d9c65013887bb0710df0d58985d67dc</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy&lt; From, To &gt;</type>
      <name>bpGraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga58f5d796ccf095d19f507f47bf92d38f</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Arc</type>
      <name>findArc</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga8f2c525c18d4b29476db308e49066334</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Arc prev=INVALID)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Edge</type>
      <name>findEdge</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga50b131b15b6c98823c4dc308f7e884e8</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Edge p=INVALID)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>misc</name>
    <title>Miscellaneous Tools</title>
    <filename>a00625.html</filename>
    <class kind="class">lemon::ArgParser</class>
    <class kind="class">lemon::Color</class>
    <class kind="class">lemon::Palette</class>
    <class kind="class">lemon::Random</class>
    <class kind="class">lemon::Tolerance</class>
    <class kind="class">lemon::Tolerance&lt; float &gt;</class>
    <class kind="class">lemon::Tolerance&lt; double &gt;</class>
    <class kind="class">lemon::Tolerance&lt; long double &gt;</class>
    <subgroup>timecount</subgroup>
    <file>arg_parser.h</file>
    <file>color.h</file>
    <file>math.h</file>
    <file>random.h</file>
    <file>tolerance.h</file>
    <file>test_tools.h</file>
    <member kind="function">
      <type>Color</type>
      <name>distantColor</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaafbc768b20325e1e5048dcd2b10bc4e7</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>distantBW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga22a184708d82339466dd08286e01a756</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNaN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga78d99e4135230ce52d67f269ed1d464f</anchor>
      <arglist>(double v)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>round</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaac8681108dfd2b0deee2dca59dff26bb</anchor>
      <arglist>(double r)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>WHITE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa574c6748d637031ff114ee5396f371d</anchor>
      <arglist>(1, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLACK</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga887e77777b0cdd4bd98cd8582eab747d</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga3aab05ed4f1fa1188cb5cec4a951da36</anchor>
      <arglist>(1, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9d50a7cbc8c947f88556291754b964df</anchor>
      <arglist>(0, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d1bd8aebf1ea19b34a359b95afb2271</anchor>
      <arglist>(0, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga7b3b82796993ff082f39aeaca4f74be9</anchor>
      <arglist>(1, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gad9c523e1fcd76b6e97a7e8f6c89a6d09</anchor>
      <arglist>(1, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga6b139d00115defc76ec508dff90c91fd</anchor>
      <arglist>(0, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREY</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaccc4c0904a38839f9554cde971bb4963</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1c9259e9d2ec9a44ea6bf855d3dd3917</anchor>
      <arglist>(.5, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gabc9fc012aa002dd8e311065b3115969c</anchor>
      <arglist>(0,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac56cc8c77b9fcb56e308652d922d08f0</anchor>
      <arglist>(0, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5dbe8dbe7b513bc66228981dcad165f7</anchor>
      <arglist>(.5,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa3457b13dd61099a849816a02ba55efc</anchor>
      <arglist>(.5, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1814dea6aea83b28d9137adaa4d8b937</anchor>
      <arglist>(0,.5,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga72bb95cfe3f4109af43a989e478a2d61</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG2E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9cef1ca3f697ed0afa15e6ce2658b9cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG10E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga044b3cac2493404bbd6bb04cf61dc38d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga64f768a3649a214be5a8b9d13acc30fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN10</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gab62596f975434ae5b1dde456a64c455a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gacf20630e5d2a9696928fe77b0726013c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d3eb5ff33b365b02e3d7065f2ecba48</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_4</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5a75e78cd42171bf864e2bad56639318</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac6586fa2865c0cc54dd89b93a0da1d17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT1_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1794f2ffbd3e762771a25847b905918c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>timecount</name>
    <title>Time Measuring and Counting</title>
    <filename>a00626.html</filename>
    <class kind="class">lemon::Counter</class>
    <class kind="class">lemon::NoCounter</class>
    <class kind="class">lemon::TimeStamp</class>
    <class kind="class">lemon::Timer</class>
    <class kind="class">lemon::TimeReport</class>
    <class kind="class">lemon::NoTimeReport</class>
    <file>counter.h</file>
    <file>time_measure.h</file>
    <member kind="function">
      <type>TimeStamp</type>
      <name>runningTimeTest</name>
      <anchorfile>a00626.html</anchorfile>
      <anchor>ga5a016a4d710b59abefedf870d8b71bb8</anchor>
      <arglist>(F f, double min_time=10, unsigned int *num=NULL, TimeStamp *full_time=NULL)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a00626.html</anchorfile>
      <anchor>ga7a8fc6a89c07865a42b13d6a2bbcbbcb</anchor>
      <arglist>(std::ostream &amp;os, const TimeStamp &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>exceptions</name>
    <title>Exceptions</title>
    <filename>a00627.html</filename>
    <class kind="class">lemon::Exception</class>
    <class kind="class">lemon::IoError</class>
    <class kind="class">lemon::FormatError</class>
    <file>assert.h</file>
    <file>error.h</file>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_ASSERT</name>
      <anchorfile>a00627.html</anchorfile>
      <anchor>gaf78cf5572d91896ceecdd970f55601bc</anchor>
      <arglist>(exp, msg)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LEMON_DEBUG</name>
      <anchorfile>a00627.html</anchorfile>
      <anchor>gacbefc04b0335938603649e96af183843</anchor>
      <arglist>(exp, msg)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>io_group</name>
    <title>Input-Output</title>
    <filename>a00628.html</filename>
    <subgroup>lemon_io</subgroup>
    <subgroup>eps_io</subgroup>
    <subgroup>dimacs_group</subgroup>
    <subgroup>nauty_group</subgroup>
  </compound>
  <compound kind="group">
    <name>lemon_io</name>
    <title>LEMON Graph Format</title>
    <filename>a00629.html</filename>
    <class kind="class">lemon::DigraphReader</class>
    <class kind="class">lemon::GraphReader</class>
    <class kind="class">lemon::BpGraphReader</class>
    <class kind="class">lemon::SectionReader</class>
    <class kind="class">lemon::LgfContents</class>
    <class kind="class">lemon::DigraphWriter</class>
    <class kind="class">lemon::GraphWriter</class>
    <class kind="class">lemon::BpGraphWriter</class>
    <class kind="class">lemon::SectionWriter</class>
    <file>lgf_reader.h</file>
    <file>lgf_writer.h</file>
    <member kind="function">
      <type>DigraphReader&lt; TDGR &gt;</type>
      <name>digraphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga48193af2c3b59a015d51b20f071a1514</anchor>
      <arglist>(TDGR &amp;digraph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader&lt; TGR &gt;</type>
      <name>graphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gafdffb110416b03a63e3486f8736b2c6c</anchor>
      <arglist>(TGR &amp;graph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader&lt; TBGR &gt;</type>
      <name>bpGraphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gac4c1c8a87aed10ee29c691b70267927d</anchor>
      <arglist>(TBGR &amp;graph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>SectionReader</type>
      <name>sectionReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga919ce27a20ac3228c90a85310a64fa4c</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter&lt; TDGR &gt;</type>
      <name>digraphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga69cc9c420f57bb132a8d2fc079b83494</anchor>
      <arglist>(const TDGR &amp;digraph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter&lt; TGR &gt;</type>
      <name>graphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gae03a34e019c92c5383b4d4a188a3bae0</anchor>
      <arglist>(const TGR &amp;graph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter&lt; TBGR &gt;</type>
      <name>bpGraphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga501cff32bd7af38690224e42bf85bea8</anchor>
      <arglist>(const TBGR &amp;graph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter</type>
      <name>sectionWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga6bc4578acf71f56b06729191b8463779</anchor>
      <arglist>(std::ostream &amp;os)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>eps_io</name>
    <title>Postscript Exporting</title>
    <filename>a00630.html</filename>
    <file>graph_to_eps.h</file>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>gacdf8d8f513b3e79f89b19c20f7755564</anchor>
      <arglist>(GR &amp;g, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga48002fdee116559a9948d1bf540475f1</anchor>
      <arglist>(GR &amp;g, const char *file_name)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga919340e78dd663a7b77c7aa9c3658170</anchor>
      <arglist>(GR &amp;g, const std::string &amp;file_name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>dimacs_group</name>
    <title>DIMACS Format</title>
    <filename>a00631.html</filename>
    <class kind="struct">lemon::DimacsDescriptor</class>
    <file>dimacs.h</file>
    <member kind="function">
      <type>DimacsDescriptor</type>
      <name>dimacsType</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gad16c7910d72fa073be372881e1b3b087</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMin</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga309d99eda5d1f5f3df2b2ca2d57ec024</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LowerMap &amp;lower, CapacityMap &amp;capacity, CostMap &amp;cost, SupplyMap &amp;supply, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMax</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga44cf335757161623864f8b1ef4446601</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename Digraph::Node &amp;s, typename Digraph::Node &amp;t, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsSp</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gae8f5ba3e3f9ce3281f83c152d193625b</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LengthMap &amp;length, typename Digraph::Node &amp;s, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsCap</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2ec47d238c02a465037377e65875793d</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2f4cd9537b1e6da13b64220bed687ad2</anchor>
      <arglist>(std::istream &amp;is, Graph &amp;g, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gada363b719022ba1fe1c03978ba6cece9</anchor>
      <arglist>(std::ostream &amp;os, const Digraph &amp;g, std::string comment=&quot;&quot;)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>nauty_group</name>
    <title>NAUTY Format</title>
    <filename>a00632.html</filename>
    <file>nauty_reader.h</file>
    <member kind="function">
      <type>std::istream &amp;</type>
      <name>readNautyGraph</name>
      <anchorfile>a00632.html</anchorfile>
      <anchor>gab98a634e56974e5266e04dd0a1a63a83</anchor>
      <arglist>(Graph &amp;graph, std::istream &amp;is=std::cin)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>concept</name>
    <title>Concepts</title>
    <filename>a00633.html</filename>
    <class kind="class">lemon::concepts::Heap</class>
    <class kind="class">lemon::concepts::Path</class>
    <class kind="class">lemon::concepts::PathDumper</class>
    <subgroup>graph_concepts</subgroup>
    <subgroup>map_concepts</subgroup>
    <file>heap.h</file>
    <file>path.h</file>
  </compound>
  <compound kind="group">
    <name>graph_concepts</name>
    <title>Graph Structure Concepts</title>
    <filename>a00634.html</filename>
    <class kind="class">lemon::concepts::BpGraph</class>
    <class kind="class">lemon::concepts::Digraph</class>
    <class kind="class">lemon::concepts::Graph</class>
    <file>bpgraph.h</file>
    <file>digraph.h</file>
    <file>graph.h</file>
    <file>graph_components.h</file>
  </compound>
  <compound kind="group">
    <name>map_concepts</name>
    <title>Map Concepts</title>
    <filename>a00635.html</filename>
    <class kind="class">lemon::concepts::ReadMap</class>
    <class kind="class">lemon::concepts::WriteMap</class>
    <class kind="class">lemon::concepts::ReadWriteMap</class>
    <class kind="class">lemon::concepts::ReferenceMap</class>
    <file>maps.h</file>
  </compound>
  <compound kind="group">
    <name>tools</name>
    <title>Standalone Utility Applications</title>
    <filename>a00636.html</filename>
    <file>dimacs-solver.cc</file>
    <file>dimacs-to-lgf.cc</file>
    <file>lgf-gen.cc</file>
  </compound>
  <compound kind="group">
    <name>demos</name>
    <title>Demo Programs</title>
    <filename>a00637.html</filename>
    <file>arg_parser_demo.cc</file>
    <file>graph_to_eps_demo.cc</file>
    <file>lgf_demo.cc</file>
    <docanchor file="a00637">demoprograms</docanchor>
  </compound>
  <compound kind="namespace">
    <name>lemon</name>
    <filename>a00573.html</filename>
    <namespace>lemon::concepts</namespace>
    <namespace>lemon::dim2</namespace>
    <class kind="class">lemon::ReverseDigraph</class>
    <class kind="class">lemon::SubDigraph</class>
    <class kind="class">lemon::SubGraph</class>
    <class kind="class">lemon::FilterNodes</class>
    <class kind="class">lemon::FilterArcs</class>
    <class kind="class">lemon::FilterEdges</class>
    <class kind="class">lemon::Undirector</class>
    <class kind="class">lemon::Orienter</class>
    <class kind="class">lemon::ResidualDigraph</class>
    <class kind="class">lemon::SplitNodes</class>
    <class kind="class">lemon::ArgParserException</class>
    <class kind="class">lemon::ArgParser</class>
    <class kind="struct">lemon::BellmanFordDefaultOperationTraits</class>
    <class kind="struct">lemon::BellmanFordDefaultTraits</class>
    <class kind="class">lemon::BellmanFord</class>
    <class kind="struct">lemon::BellmanFordWizardDefaultTraits</class>
    <class kind="class">lemon::BellmanFordWizardBase</class>
    <class kind="class">lemon::BellmanFordWizard</class>
    <class kind="struct">lemon::BfsDefaultTraits</class>
    <class kind="class">lemon::Bfs</class>
    <class kind="struct">lemon::BfsWizardDefaultTraits</class>
    <class kind="class">lemon::BfsWizardBase</class>
    <class kind="class">lemon::BfsWizard</class>
    <class kind="struct">lemon::BfsVisitor</class>
    <class kind="struct">lemon::BfsVisitDefaultTraits</class>
    <class kind="class">lemon::BfsVisit</class>
    <class kind="class">lemon::BinHeap</class>
    <class kind="class">lemon::BinomialHeap</class>
    <class kind="class">lemon::BucketHeap</class>
    <class kind="class">lemon::SimpleBucketHeap</class>
    <class kind="struct">lemon::CapacityScalingDefaultTraits</class>
    <class kind="class">lemon::CapacityScaling</class>
    <class kind="class">lemon::CbcMip</class>
    <class kind="class">lemon::ChristofidesTsp</class>
    <class kind="struct">lemon::CirculationDefaultTraits</class>
    <class kind="class">lemon::Circulation</class>
    <class kind="class">lemon::ClpLp</class>
    <class kind="class">lemon::Color</class>
    <class kind="class">lemon::Palette</class>
    <class kind="struct">lemon::Invalid</class>
    <class kind="class">lemon::DigraphCopy</class>
    <class kind="class">lemon::GraphCopy</class>
    <class kind="class">lemon::BpGraphCopy</class>
    <class kind="class">lemon::ConArcIt</class>
    <class kind="class">lemon::ConEdgeIt</class>
    <class kind="class">lemon::DynArcLookUp</class>
    <class kind="class">lemon::ArcLookUp</class>
    <class kind="class">lemon::AllArcLookUp</class>
    <class kind="struct">lemon::CostScalingDefaultTraits</class>
    <class kind="class">lemon::CostScaling</class>
    <class kind="class">lemon::Counter</class>
    <class kind="class">lemon::NoCounter</class>
    <class kind="class">lemon::CplexEnv</class>
    <class kind="class">lemon::CplexBase</class>
    <class kind="class">lemon::CplexLp</class>
    <class kind="class">lemon::CplexMip</class>
    <class kind="class">lemon::CycleCanceling</class>
    <class kind="struct">lemon::DfsDefaultTraits</class>
    <class kind="class">lemon::Dfs</class>
    <class kind="struct">lemon::DfsWizardDefaultTraits</class>
    <class kind="class">lemon::DfsWizardBase</class>
    <class kind="class">lemon::DfsWizard</class>
    <class kind="struct">lemon::DfsVisitor</class>
    <class kind="struct">lemon::DfsVisitDefaultTraits</class>
    <class kind="class">lemon::DfsVisit</class>
    <class kind="class">lemon::DHeap</class>
    <class kind="struct">lemon::DijkstraDefaultOperationTraits</class>
    <class kind="struct">lemon::DijkstraDefaultTraits</class>
    <class kind="class">lemon::Dijkstra</class>
    <class kind="struct">lemon::DijkstraWizardDefaultTraits</class>
    <class kind="class">lemon::DijkstraWizardBase</class>
    <class kind="class">lemon::DijkstraWizard</class>
    <class kind="struct">lemon::DimacsDescriptor</class>
    <class kind="class">lemon::ListArcSet</class>
    <class kind="class">lemon::ListEdgeSet</class>
    <class kind="class">lemon::SmartArcSet</class>
    <class kind="class">lemon::SmartEdgeSet</class>
    <class kind="struct">lemon::EdmondsKarpDefaultTraits</class>
    <class kind="class">lemon::EdmondsKarp</class>
    <class kind="class">lemon::Elevator</class>
    <class kind="class">lemon::LinkedElevator</class>
    <class kind="class">lemon::Exception</class>
    <class kind="class">lemon::IoError</class>
    <class kind="class">lemon::FormatError</class>
    <class kind="class">lemon::DiEulerIt</class>
    <class kind="class">lemon::EulerIt</class>
    <class kind="class">lemon::FibHeap</class>
    <class kind="struct">lemon::MaxFractionalMatchingDefaultTraits</class>
    <class kind="class">lemon::MaxFractionalMatching</class>
    <class kind="class">lemon::MaxWeightedFractionalMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectFractionalMatching</class>
    <class kind="class">lemon::FullDigraph</class>
    <class kind="class">lemon::FullGraph</class>
    <class kind="class">lemon::FullBpGraph</class>
    <class kind="class">lemon::GlpkBase</class>
    <class kind="class">lemon::GlpkLp</class>
    <class kind="class">lemon::GlpkMip</class>
    <class kind="class">lemon::GomoryHu</class>
    <class kind="struct">lemon::DefaultGraphToEpsTraits</class>
    <class kind="class">lemon::GraphToEps</class>
    <class kind="class">lemon::GreedyTsp</class>
    <class kind="class">lemon::GridGraph</class>
    <class kind="class">lemon::GrossoLocatelliPullanMc</class>
    <class kind="class">lemon::HaoOrlin</class>
    <class kind="struct">lemon::HartmannOrlinMmcDefaultTraits</class>
    <class kind="class">lemon::HartmannOrlinMmc</class>
    <class kind="struct">lemon::HowardMmcDefaultTraits</class>
    <class kind="class">lemon::HowardMmc</class>
    <class kind="class">lemon::HypercubeGraph</class>
    <class kind="class">lemon::InsertionTsp</class>
    <class kind="struct">lemon::KarpMmcDefaultTraits</class>
    <class kind="class">lemon::KarpMmc</class>
    <class kind="class">lemon::DigraphReader</class>
    <class kind="class">lemon::GraphReader</class>
    <class kind="class">lemon::BpGraphReader</class>
    <class kind="class">lemon::SectionReader</class>
    <class kind="class">lemon::LgfContents</class>
    <class kind="class">lemon::DigraphWriter</class>
    <class kind="class">lemon::GraphWriter</class>
    <class kind="class">lemon::BpGraphWriter</class>
    <class kind="class">lemon::SectionWriter</class>
    <class kind="class">lemon::ListDigraph</class>
    <class kind="class">lemon::ListGraph</class>
    <class kind="class">lemon::ListBpGraph</class>
    <class kind="class">lemon::LpBase</class>
    <class kind="class">lemon::LpSolver</class>
    <class kind="class">lemon::MipSolver</class>
    <class kind="class">lemon::SkeletonSolverBase</class>
    <class kind="class">lemon::LpSkeleton</class>
    <class kind="class">lemon::MipSkeleton</class>
    <class kind="class">lemon::MapBase</class>
    <class kind="class">lemon::NullMap</class>
    <class kind="class">lemon::ConstMap</class>
    <class kind="class">lemon::ConstMap&lt; K, Const&lt; V, v &gt; &gt;</class>
    <class kind="class">lemon::IdentityMap</class>
    <class kind="class">lemon::RangeMap</class>
    <class kind="class">lemon::SparseMap</class>
    <class kind="class">lemon::ComposeMap</class>
    <class kind="class">lemon::CombineMap</class>
    <class kind="class">lemon::FunctorToMap</class>
    <class kind="class">lemon::MapToFunctor</class>
    <class kind="class">lemon::ConvertMap</class>
    <class kind="class">lemon::ForkMap</class>
    <class kind="class">lemon::AddMap</class>
    <class kind="class">lemon::SubMap</class>
    <class kind="class">lemon::MulMap</class>
    <class kind="class">lemon::DivMap</class>
    <class kind="class">lemon::ShiftMap</class>
    <class kind="class">lemon::ShiftWriteMap</class>
    <class kind="class">lemon::ScaleMap</class>
    <class kind="class">lemon::ScaleWriteMap</class>
    <class kind="class">lemon::NegMap</class>
    <class kind="class">lemon::NegWriteMap</class>
    <class kind="class">lemon::AbsMap</class>
    <class kind="class">lemon::TrueMap</class>
    <class kind="class">lemon::FalseMap</class>
    <class kind="class">lemon::AndMap</class>
    <class kind="class">lemon::OrMap</class>
    <class kind="class">lemon::NotMap</class>
    <class kind="class">lemon::NotWriteMap</class>
    <class kind="class">lemon::EqualMap</class>
    <class kind="class">lemon::LessMap</class>
    <class kind="class">lemon::LoggerBoolMap</class>
    <class kind="class">lemon::IdMap</class>
    <class kind="class">lemon::CrossRefMap</class>
    <class kind="class">lemon::RangeIdMap</class>
    <class kind="class">lemon::IterableBoolMap</class>
    <class kind="class">lemon::IterableIntMap</class>
    <class kind="class">lemon::IterableValueMap</class>
    <class kind="class">lemon::SourceMap</class>
    <class kind="class">lemon::TargetMap</class>
    <class kind="class">lemon::ForwardMap</class>
    <class kind="class">lemon::BackwardMap</class>
    <class kind="class">lemon::InDegMap</class>
    <class kind="class">lemon::OutDegMap</class>
    <class kind="class">lemon::PotentialDifferenceMap</class>
    <class kind="class">lemon::MaxMatching</class>
    <class kind="class">lemon::MaxWeightedMatching</class>
    <class kind="class">lemon::MaxWeightedPerfectMatching</class>
    <class kind="struct">lemon::MaxCardinalitySearchDefaultTraits</class>
    <class kind="class">lemon::MaxCardinalitySearch</class>
    <class kind="struct">lemon::MinCostArborescenceDefaultTraits</class>
    <class kind="class">lemon::MinCostArborescence</class>
    <class kind="struct">lemon::NagamochiIbarakiDefaultTraits</class>
    <class kind="class">lemon::NagamochiIbaraki</class>
    <class kind="class">lemon::NearestNeighborTsp</class>
    <class kind="class">lemon::NetworkSimplex</class>
    <class kind="class">lemon::Opt2Tsp</class>
    <class kind="class">lemon::PairingHeap</class>
    <class kind="class">lemon::Path</class>
    <class kind="class">lemon::SimplePath</class>
    <class kind="class">lemon::ListPath</class>
    <class kind="class">lemon::StaticPath</class>
    <class kind="class">lemon::PathNodeIt</class>
    <class kind="class">lemon::PlanarEmbedding</class>
    <class kind="class">lemon::PlanarDrawing</class>
    <class kind="class">lemon::PlanarColoring</class>
    <class kind="struct">lemon::PreflowDefaultTraits</class>
    <class kind="class">lemon::Preflow</class>
    <class kind="class">lemon::QuadHeap</class>
    <class kind="class">lemon::RadixHeap</class>
    <class kind="class">lemon::Random</class>
    <class kind="class">lemon::SmartDigraph</class>
    <class kind="class">lemon::SmartGraph</class>
    <class kind="class">lemon::SmartBpGraph</class>
    <class kind="class">lemon::SoplexLp</class>
    <class kind="class">lemon::StaticDigraph</class>
    <class kind="struct">lemon::SuurballeDefaultTraits</class>
    <class kind="class">lemon::Suurballe</class>
    <class kind="class">lemon::TimeStamp</class>
    <class kind="class">lemon::Timer</class>
    <class kind="class">lemon::TimeReport</class>
    <class kind="class">lemon::NoTimeReport</class>
    <class kind="class">lemon::Tolerance</class>
    <class kind="class">lemon::Tolerance&lt; float &gt;</class>
    <class kind="class">lemon::Tolerance&lt; double &gt;</class>
    <class kind="class">lemon::Tolerance&lt; long double &gt;</class>
    <class kind="class">lemon::UnionFind</class>
    <class kind="class">lemon::UnionFindEnum</class>
    <class kind="class">lemon::ExtendFindEnum</class>
    <class kind="class">lemon::HeapUnionFind</class>
    <member kind="typedef">
      <type>GlpkLp</type>
      <name>Lp</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>ga8c6461f78849b26ae8be11062410d043</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlpkMip</type>
      <name>Mip</name>
      <anchorfile>a00622.html</anchorfile>
      <anchor>gad4ee17c56e133b01b9d75eb2cefd4d7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>BellmanFordWizard&lt; BellmanFordWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>bellmanFord</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>ga359aa931ac3c9550d5b5b5f3ec2e9e56</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; BfsWizardBase&lt; GR &gt; &gt;</type>
      <name>bfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>ga99817221896aba2eb403691a0a230a0b</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>distantColor</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaafbc768b20325e1e5048dcd2b10bc4e7</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>distantBW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga22a184708d82339466dd08286e01a756</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>function_requires</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>a3b4bbb2e8a649d05287b65fdf29b6930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>checkConcept</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>ac202d55258d62489acf256b88b87e470</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>connected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad5c8d1b650f6b614a852f8430d90e184</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga33a9d9d4803cb15e83568b2526e978a5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa467a3e0a8c2e9e762650fd01fadff89</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stronglyConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gacd21b34d7b42b9835a204a57fcf15964</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countStronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad30bc47dfffb78234eeee903cb3766f4</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga46f8c22f3e2989c4689faa4c46ec9436</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stronglyConnectedCutArcs</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad7af5c3a97453e37f251f0e86dbb83db</anchor>
      <arglist>(const Digraph &amp;digraph, ArcMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf7c5744b2175210b8ea67897aaa27885</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biNodeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gac9257323ead7cbe64b7b4a628c4876b3</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga9d70526ab54e10b4b6fe3762af8675dd</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biNodeConnectedCutNodes</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga31461f33a748327ea3ef2a3199ffb6c7</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBiEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga4d5db78dc21099d075c3967484990954</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>biEdgeConnected</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga37d22a2ddd5a064a9203720f2b93518e</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedComponents</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga76c1fdd1881d21677507100b7e96c983</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;compMap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>biEdgeConnectedCutEdges</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58d444eba448c5f1a53539bd1b69636e</anchor>
      <arglist>(const Graph &amp;graph, EdgeMap &amp;cutMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dag</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaef2b43c8cd1d74e15fa5c7607bc5e396</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>topologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafc2cb20cf3859f157c0e12da7f310bb3</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedTopologicalSort</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaf10c5e1630e5720c20d83cfb77dbf024</anchor>
      <arglist>(const Digraph &amp;digraph, NodeMap &amp;order)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acyclic</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga14c191b2133a1dd23e1527f074c821c0</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>tree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gad1e4de234e926958647905478415bd54</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartite</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga577db110d33bd487aaad5bfffb31c6f5</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bipartitePartitions</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga58ba1d00c569f0eb0deb42afca9f80bb</anchor>
      <arglist>(const Graph &amp;graph, NodeMap &amp;partMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loopFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>ga127f3963003cd532c79c226885fe1c8c</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parallelFree</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gaa05e0683f90b69f31eb29fe7d09afde4</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>simpleGraph</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gae4c7ae734e2509ab78dc747d602c9236</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countItems</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga65f512e54ae6256fcd098592fc582e50</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga9156d36059e59ebc8dc14bad0112633d</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countRedNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gac1a04fa8a9e0460accf28c5337b2c5eb</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countBlueNodes</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga40c1bf81c7096481ca39f286eeb74163</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga1b3307d4e63c19d4ebadf133ebb43683</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaede53fc1ef848a03b7f844a5ec7eeca6</anchor>
      <arglist>(const Graph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countOutArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaf199da654058dd16da1702f38b60f30c</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countInArcs</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga03d0d2f770d7f7faac66438139ae9b18</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countIncEdges</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gae93681c4e849f6fd3a102fcb2756e317</anchor>
      <arglist>(const Graph &amp;g, const typename Graph::Node &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>undirected</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>gaa7a3075a14f2acde20f1d999675a8040</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy&lt; From, To &gt;</type>
      <name>digraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga47e4bf893a80e68971c511735117c707</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy&lt; From, To &gt;</type>
      <name>graphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga6d9c65013887bb0710df0d58985d67dc</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy&lt; From, To &gt;</type>
      <name>bpGraphCopy</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga58f5d796ccf095d19f507f47bf92d38f</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Arc</type>
      <name>findArc</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga8f2c525c18d4b29476db308e49066334</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Arc prev=INVALID)</arglist>
    </member>
    <member kind="function">
      <type>Graph::Edge</type>
      <name>findEdge</name>
      <anchorfile>a00624.html</anchorfile>
      <anchor>ga50b131b15b6c98823c4dc308f7e884e8</anchor>
      <arglist>(const Graph &amp;g, typename Graph::Node u, typename Graph::Node v, typename Graph::Edge p=INVALID)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; DfsWizardBase&lt; GR &gt; &gt;</type>
      <name>dfs</name>
      <anchorfile>a00608.html</anchorfile>
      <anchor>gaa6a12c70b10ad9693117ec2b3774b0d8</anchor>
      <arglist>(const GR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; DijkstraWizardBase&lt; GR, LEN &gt; &gt;</type>
      <name>dijkstra</name>
      <anchorfile>a00609.html</anchorfile>
      <anchor>gaa781be76e5adb6a9df7592457a5c3857</anchor>
      <arglist>(const GR &amp;digraph, const LEN &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>DimacsDescriptor</type>
      <name>dimacsType</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gad16c7910d72fa073be372881e1b3b087</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMin</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga309d99eda5d1f5f3df2b2ca2d57ec024</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LowerMap &amp;lower, CapacityMap &amp;capacity, CostMap &amp;cost, SupplyMap &amp;supply, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMax</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga44cf335757161623864f8b1ef4446601</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename Digraph::Node &amp;s, typename Digraph::Node &amp;t, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsSp</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gae8f5ba3e3f9ce3281f83c152d193625b</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, LengthMap &amp;length, typename Digraph::Node &amp;s, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsCap</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2ec47d238c02a465037377e65875793d</anchor>
      <arglist>(std::istream &amp;is, Digraph &amp;g, CapacityMap &amp;capacity, typename CapacityMap::Value infty=0, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>ga2f4cd9537b1e6da13b64220bed687ad2</anchor>
      <arglist>(std::istream &amp;is, Graph &amp;g, DimacsDescriptor desc=DimacsDescriptor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDimacsMat</name>
      <anchorfile>a00631.html</anchorfile>
      <anchor>gada363b719022ba1fe1c03978ba6cece9</anchor>
      <arglist>(std::ostream &amp;os, const Digraph &amp;g, std::string comment=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eulerian</name>
      <anchorfile>a00616.html</anchorfile>
      <anchor>gafb5a4961cac4d877006869fc4cb6ea1d</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>gacdf8d8f513b3e79f89b19c20f7755564</anchor>
      <arglist>(GR &amp;g, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga48002fdee116559a9948d1bf540475f1</anchor>
      <arglist>(GR &amp;g, const char *file_name)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; DefaultGraphToEpsTraits&lt; GR &gt; &gt;</type>
      <name>graphToEps</name>
      <anchorfile>a00630.html</anchorfile>
      <anchor>ga919340e78dd663a7b77c7aa9c3658170</anchor>
      <arglist>(GR &amp;g, const std::string &amp;file_name)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>kruskal</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga233792b2c44a3581b85a775703e045af</anchor>
      <arglist>(const Graph &amp;g, const In &amp;in, Out &amp;out)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mapCopy</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gacd3b1378e8d938e2f4f831cda62d7196</anchor>
      <arglist>(const GR &amp;gr, const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mapCompare</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad05d27a9d1f23407ab2960b48a9b7582</anchor>
      <arglist>(const GR &amp;gr, const Map1 &amp;map1, const Map2 &amp;map2)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga6119b9344a9c76eb7fca2f57f67732e4</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMin</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8c1dd57a1af8310ca04d57a70f3f659c</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga87e0df0934bba2996ec5c9b6907de88d</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapMax</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga262a78bd1f36223d520ffde235730cb9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga3be91b854e7788d89047f161378fce58</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMinValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga712ba7c8df94bd02f28d6e08d11176f7</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga72688c2e41aa36efa56431b5b585a1c1</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Map::Value</type>
      <name>mapMaxValue</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga7b5174f049f1fd63844d2c914832cbcc</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Comp &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFind</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga8469265a9d93f69c9402756ffe86bcab</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>Map::Key</type>
      <name>mapFindIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gad5e8addbccd1e43a3add48108020ffbd</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCount</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gafe30fc86a55d33ad6811f3cc835b4cf9</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapCountIf</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>ga33891e575e55c0f9ec0dac31923119b8</anchor>
      <arglist>(const GR &amp;gr, const Map &amp;map, const Pred &amp;pred)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mapFill</name>
      <anchorfile>a00601.html</anchorfile>
      <anchor>gabbcca4c1a7f23a9f39e97e24dc8c54fc</anchor>
      <arglist>(const GR &amp;gr, Map &amp;map, const typename Map::Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNaN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga78d99e4135230ce52d67f269ed1d464f</anchor>
      <arglist>(double v)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>round</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaac8681108dfd2b0deee2dca59dff26bb</anchor>
      <arglist>(double r)</arglist>
    </member>
    <member kind="function">
      <type>CostMap::Value</type>
      <name>minCostArborescence</name>
      <anchorfile>a00610.html</anchorfile>
      <anchor>ga0faeb92308e21beeb093ee6c967a2cb5</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost, typename Digraph::Node source, ArborescenceMap &amp;arborescence)</arglist>
    </member>
    <member kind="function">
      <type>std::istream &amp;</type>
      <name>readNautyGraph</name>
      <anchorfile>a00632.html</anchorfile>
      <anchor>gab98a634e56974e5266e04dd0a1a63a83</anchor>
      <arglist>(Graph &amp;graph, std::istream &amp;is=std::cin)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pathCopy</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga1c0da351dc554629ec44013576637e7d</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copyPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga437e79537f340c99bb743bc928cb0a10</anchor>
      <arglist>(To &amp;to, const From &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkPath</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga72529b1d8158a18d4a428dc3eab15a69</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathSource</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga8cd2b147cef7e0a4fa05145908d95c15</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Digraph::Node</type>
      <name>pathTarget</name>
      <anchorfile>a00603.html</anchorfile>
      <anchor>ga885afd9d4ba099bf2d8104e6e0408b66</anchor>
      <arglist>(const Digraph &amp;digraph, const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkPlanarity</name>
      <anchorfile>a00617.html</anchorfile>
      <anchor>ga230242aa2ee36f9b1b5a58f2c53016eb</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>radixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga9a59ac695f0882ca6c606f4f9091ff97</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stableRadixSort</name>
      <anchorfile>a00620.html</anchorfile>
      <anchor>ga85077aa44152133d90fd5aff65856b47</anchor>
      <arglist>(Iterator first, Iterator last, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>TimeStamp</type>
      <name>runningTimeTest</name>
      <anchorfile>a00626.html</anchorfile>
      <anchor>ga5a016a4d710b59abefedf870d8b71bb8</anchor>
      <arglist>(F f, double min_time=10, unsigned int *num=NULL, TimeStamp *full_time=NULL)</arglist>
    </member>
    <member kind="variable">
      <type>const Invalid</type>
      <name>INVALID</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>a0f04de8e6be7bc21ed685c651571d9fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>WHITE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa574c6748d637031ff114ee5396f371d</anchor>
      <arglist>(1, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLACK</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga887e77777b0cdd4bd98cd8582eab747d</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga3aab05ed4f1fa1188cb5cec4a951da36</anchor>
      <arglist>(1, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9d50a7cbc8c947f88556291754b964df</anchor>
      <arglist>(0, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d1bd8aebf1ea19b34a359b95afb2271</anchor>
      <arglist>(0, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga7b3b82796993ff082f39aeaca4f74be9</anchor>
      <arglist>(1, 1, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gad9c523e1fcd76b6e97a7e8f6c89a6d09</anchor>
      <arglist>(1, 0, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga6b139d00115defc76ec508dff90c91fd</anchor>
      <arglist>(0, 1, 1)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>GREY</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaccc4c0904a38839f9554cde971bb4963</anchor>
      <arglist>(0, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_RED</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1c9259e9d2ec9a44ea6bf855d3dd3917</anchor>
      <arglist>(.5, 0, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_GREEN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gabc9fc012aa002dd8e311065b3115969c</anchor>
      <arglist>(0,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_BLUE</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac56cc8c77b9fcb56e308652d922d08f0</anchor>
      <arglist>(0, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_YELLOW</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5dbe8dbe7b513bc66228981dcad165f7</anchor>
      <arglist>(.5,.5, 0)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_MAGENTA</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gaa3457b13dd61099a849816a02ba55efc</anchor>
      <arglist>(.5, 0,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const Color</type>
      <name>DARK_CYAN</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1814dea6aea83b28d9137adaa4d8b937</anchor>
      <arglist>(0,.5,.5)</arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga72bb95cfe3f4109af43a989e478a2d61</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG2E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga9cef1ca3f697ed0afa15e6ce2658b9cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LOG10E</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga044b3cac2493404bbd6bb04cf61dc38d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga64f768a3649a214be5a8b9d13acc30fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>LN10</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gab62596f975434ae5b1dde456a64c455a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gacf20630e5d2a9696928fe77b0726013c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga8d3eb5ff33b365b02e3d7065f2ecba48</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>PI_4</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga5a75e78cd42171bf864e2bad56639318</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>gac6586fa2865c0cc54dd89b93a0da1d17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const long double</type>
      <name>SQRT1_2</name>
      <anchorfile>a00625.html</anchorfile>
      <anchor>ga1794f2ffbd3e762771a25847b905918c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Random</type>
      <name>rnd</name>
      <anchorfile>a00573.html</anchorfile>
      <anchor>af55e529932608e88737901e3404d1d0e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ReverseDigraph</name>
    <filename>a00333.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>DGR</type>
      <name>Digraph</name>
      <anchorfile>a00333.html</anchorfile>
      <anchor>a6435ad6a242e3d323a0dfffd053d9584</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ReverseDigraph</name>
      <anchorfile>a00333.html</anchorfile>
      <anchor>a1c19d8f05c205125bfc52b57d9115483</anchor>
      <arglist>(DGR &amp;digraph)</arglist>
    </member>
    <member kind="function">
      <type>ReverseDigraph&lt; const DGR &gt;</type>
      <name>reverseDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga79c1b665b375986e20577c316a2abd64</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SubDigraph</name>
    <filename>a00417.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>DGR</type>
      <name>Digraph</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a6435ad6a242e3d323a0dfffd053d9584</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NF</type>
      <name>NodeFilterMap</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a4eb9c95d5fc082e8c24367f6534fdc33</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AF</type>
      <name>ArcFilterMap</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a059cdfd6d771a5bc57e8aaee120c3407</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubDigraph</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>aa586b064493ed16cd99bf22e5f6bcdd5</anchor>
      <arglist>(DGR &amp;digraph, NF &amp;node_filter, AF &amp;arc_filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a711dc8f20e5cc54beb6b593b477e39da</anchor>
      <arglist>(const Node &amp;n, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a7ede39359354abf6eb518f569ff527cc</anchor>
      <arglist>(const Arc &amp;a, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a88f03c67cb6b5cae80863297d6af6ad7</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a68a0220715672c9fb921375db6ea1f6c</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a399546f119b51777efca621d172ce72b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>ac03cc82fca9d6d0bd1afa0189c249189</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a6908dd7a97e89feaebd42f28b79cbda5</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00417.html</anchorfile>
      <anchor>a2f8dabdc2a72b3ca71d4aedd8c82dd7b</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>SubDigraph&lt; const DGR, NF, AF &gt;</type>
      <name>subDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga4ecbcee43f13c2eaf1bedc4b2c8467ad</anchor>
      <arglist>(const DGR &amp;digraph, NF &amp;node_filter, AF &amp;arc_filter)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SubGraph</name>
    <filename>a00418.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NF</type>
      <name>NodeFilterMap</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a4eb9c95d5fc082e8c24367f6534fdc33</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>EF</type>
      <name>EdgeFilterMap</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>ac2f0212f10cc7aa26b76d2a113e963c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubGraph</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>acafef764806c2916e10afb85630bedb5</anchor>
      <arglist>(GR &amp;graph, NF &amp;node_filter, EF &amp;edge_filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a711dc8f20e5cc54beb6b593b477e39da</anchor>
      <arglist>(const Node &amp;n, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a459d5d31aca26a7ae65e12e67206bbea</anchor>
      <arglist>(const Edge &amp;e, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a88f03c67cb6b5cae80863297d6af6ad7</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a1d0451e1488401c6b1e557abd13e6f58</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a399546f119b51777efca621d172ce72b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>adbed4d766b7574f13f51d572cc3a2312</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a6908dd7a97e89feaebd42f28b79cbda5</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00418.html</anchorfile>
      <anchor>a7e856a820c2c09a70f940d7e237b5c37</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>SubGraph&lt; const GR, NF, EF &gt;</type>
      <name>subGraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gad30bffcd2a193a2366b54593a98bf7a3</anchor>
      <arglist>(const GR &amp;graph, NF &amp;node_filter, EF &amp;edge_filter)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FilterNodes</name>
    <filename>a00171.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>FilterNodes</name>
      <anchorfile>a00171.html</anchorfile>
      <anchor>a3acbedd2d3b60c3e7c8c1913ba47d8cd</anchor>
      <arglist>(GR &amp;graph, NF &amp;node_filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00171.html</anchorfile>
      <anchor>a711dc8f20e5cc54beb6b593b477e39da</anchor>
      <arglist>(const Node &amp;n, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00171.html</anchorfile>
      <anchor>a88f03c67cb6b5cae80863297d6af6ad7</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00171.html</anchorfile>
      <anchor>a399546f119b51777efca621d172ce72b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00171.html</anchorfile>
      <anchor>a6908dd7a97e89feaebd42f28b79cbda5</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>FilterNodes&lt; const GR, NF &gt;</type>
      <name>filterNodes</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaa682c0f382bd7ea7227e29c5d45fd33d</anchor>
      <arglist>(const GR &amp;graph, NF &amp;node_filter)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FilterArcs</name>
    <filename>a00169.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>DGR</type>
      <name>Digraph</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a6435ad6a242e3d323a0dfffd053d9584</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AF</type>
      <name>ArcFilterMap</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a059cdfd6d771a5bc57e8aaee120c3407</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FilterArcs</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a9273e96f98a5aa99ea93fb0e770e8e4e</anchor>
      <arglist>(DGR &amp;digraph, ArcFilterMap &amp;arc_filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a7ede39359354abf6eb518f569ff527cc</anchor>
      <arglist>(const Arc &amp;a, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a68a0220715672c9fb921375db6ea1f6c</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>ac03cc82fca9d6d0bd1afa0189c249189</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00169.html</anchorfile>
      <anchor>a2f8dabdc2a72b3ca71d4aedd8c82dd7b</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>FilterArcs&lt; const DGR, AF &gt;</type>
      <name>filterArcs</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gad6a800aaf8aa5c85de6ab3ff3b828905</anchor>
      <arglist>(const DGR &amp;digraph, AF &amp;arc_filter)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FilterEdges</name>
    <filename>a00170.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>EF</type>
      <name>EdgeFilterMap</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>ac2f0212f10cc7aa26b76d2a113e963c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FilterEdges</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>a857bb05088a80cbe464ce993c9744037</anchor>
      <arglist>(GR &amp;graph, EF &amp;edge_filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>status</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>a459d5d31aca26a7ae65e12e67206bbea</anchor>
      <arglist>(const Edge &amp;e, bool v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>a1d0451e1488401c6b1e557abd13e6f58</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>adbed4d766b7574f13f51d572cc3a2312</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enable</name>
      <anchorfile>a00170.html</anchorfile>
      <anchor>a7e856a820c2c09a70f940d7e237b5c37</anchor>
      <arglist>(const Edge &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>FilterEdges&lt; const GR, EF &gt;</type>
      <name>filterEdges</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaddd9874f4d5ad214e8f0d4f252c989ee</anchor>
      <arglist>(const GR &amp;graph, EF &amp;edge_filter)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Undirector</name>
    <filename>a00432.html</filename>
    <templarg>DGR</templarg>
    <class kind="class">lemon::Undirector::CombinedArcMap</class>
    <member kind="typedef">
      <type>DGR</type>
      <name>Digraph</name>
      <anchorfile>a00432.html</anchorfile>
      <anchor>a6435ad6a242e3d323a0dfffd053d9584</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Undirector</name>
      <anchorfile>a00432.html</anchorfile>
      <anchor>ab3b1215366b82b7585ffe3950ba8cb3f</anchor>
      <arglist>(DGR &amp;digraph)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static CombinedArcMap&lt; FW, BK &gt;</type>
      <name>combinedArcMap</name>
      <anchorfile>a00432.html</anchorfile>
      <anchor>a679350be01d46c3627e6ce2185a54247</anchor>
      <arglist>(FW &amp;forward, BK &amp;backward)</arglist>
    </member>
    <member kind="function">
      <type>Undirector&lt; const DGR &gt;</type>
      <name>undirector</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaebf4f5d421ecb3a11161a2efca58bbd9</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Undirector::CombinedArcMap</name>
    <filename>a00094.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Parent::Arc</type>
      <name>Key</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>a13e85d8e9431f7a6a51c1e2e15807dcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>FW::Value</type>
      <name>Value</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>a7f806cb53c6fe517966417f73431ac65</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CombinedArcMap</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>afc72a99a501025589a75334d5099653e</anchor>
      <arglist>(FW &amp;forward, BK &amp;backward)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>a8b4f088ec51d022ac424e2ad03345528</anchor>
      <arglist>(const Key &amp;e, const Value &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>ConstReturnValue</type>
      <name>operator[]</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>ab5916e41ffc89ab269fc0e850d5cff04</anchor>
      <arglist>(const Key &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>ReturnValue</type>
      <name>operator[]</name>
      <anchorfile>a00094.html</anchorfile>
      <anchor>a6c15088cce9ae56b72a0e3e53c206c38</anchor>
      <arglist>(const Key &amp;e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Orienter</name>
    <filename>a00294.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00294.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>DM</type>
      <name>DirectionMap</name>
      <anchorfile>a00294.html</anchorfile>
      <anchor>a039bf501bb852a36dd281ca096295e4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Orienter</name>
      <anchorfile>a00294.html</anchorfile>
      <anchor>ab2c793dd60c1389f60cb7ac1751395ac</anchor>
      <arglist>(GR &amp;graph, DM &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reverseArc</name>
      <anchorfile>a00294.html</anchorfile>
      <anchor>a6ac584128e0ad8f56eb1e98dc6e25988</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>Orienter&lt; const GR, DM &gt;</type>
      <name>orienter</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gaf0baa7971373781e810c9b8855cb63c6</anchor>
      <arglist>(const GR &amp;graph, DM &amp;direction)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ResidualDigraph</name>
    <filename>a00331.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <class kind="class">lemon::ResidualDigraph::ResidualCapacity</class>
    <member kind="typedef">
      <type>DGR</type>
      <name>Digraph</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a6435ad6a242e3d323a0dfffd053d9584</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM</type>
      <name>CapacityMap</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>aa445690c7204e6db4ddd20f5e865098b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>FM</type>
      <name>FlowMap</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a2939a0a237c77039e7d80faa9eec9ccd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TL</type>
      <name>Tolerance</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a5baae3db2e79c32027a17896b1204403</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResidualDigraph</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>aa70d15d1d33bf517fd1181d5320b2ec8</anchor>
      <arglist>(const DGR &amp;digraph, const CM &amp;capacity, FM &amp;flow, const TL &amp;tolerance=Tolerance())</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>residualCapacity</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a33766028cc266e37ad553aaebd09d351</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>augment</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a9cba43ffb906a3c3677bbf7317d30549</anchor>
      <arglist>(const Arc &amp;a, const Value &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>ResidualCapacity</type>
      <name>residualCapacity</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a7bc9d9321c8c66b1e4e0f33eda33f707</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>forward</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a7e6872f27247ac469eca9bbec6faa4b9</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>backward</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>afd7c3914c21d626a6bcb348ca1d158ef</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Arc</type>
      <name>forward</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a05a82dec247b71ac0a5b42b9f8581f39</anchor>
      <arglist>(const typename Digraph::Arc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Arc</type>
      <name>backward</name>
      <anchorfile>a00331.html</anchorfile>
      <anchor>a434f8ac6881d17f56a29ae0053466bd9</anchor>
      <arglist>(const typename Digraph::Arc &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>ResidualDigraph&lt; DGR, CM, FM &gt;</type>
      <name>residualDigraph</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>ga16137e105dd234d7e29ff30aebb01a21</anchor>
      <arglist>(const DGR &amp;digraph, const CM &amp;capacity_map, FM &amp;flow_map)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ResidualDigraph::ResidualCapacity</name>
    <filename>a00330.html</filename>
    <member kind="typedef">
      <type>Arc</type>
      <name>Key</name>
      <anchorfile>a00330.html</anchorfile>
      <anchor>a49324d309ab1fbcdfd1e07ecc5f48b39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CapacityMap::Value</type>
      <name>Value</name>
      <anchorfile>a00330.html</anchorfile>
      <anchor>af751c878eda966b90fa4fdf5f1915eff</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResidualCapacity</name>
      <anchorfile>a00330.html</anchorfile>
      <anchor>aa18fb5b24fd7da1fa4f38406019f16ca</anchor>
      <arglist>(const ResidualDigraph&lt; DGR, CM, FM, TL &gt; &amp;adaptor)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00330.html</anchorfile>
      <anchor>ad1162507b5caa110bbdebdf9f732f842</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SplitNodes</name>
    <filename>a00414.html</filename>
    <templarg></templarg>
    <class kind="class">lemon::SplitNodes::CombinedArcMap</class>
    <class kind="class">lemon::SplitNodes::CombinedNodeMap</class>
    <member kind="function">
      <type></type>
      <name>SplitNodes</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>a56f3680d312f11bc9ab3d92e707076a6</anchor>
      <arglist>(const DGR &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>inNode</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>a77de114f3028c8969526fd4b4e7ccb6d</anchor>
      <arglist>(const Node &amp;n)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>outNode</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>ac153d4477370e4ccd4a85fe68d448c1d</anchor>
      <arglist>(const Node &amp;n)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>origArc</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>ab8fc5ac8e1d333a751a2a4fceb94208b</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>bindArc</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>afa9ff5bc582ba23c4d1ee971c622c1c1</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Node</type>
      <name>inNode</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>aa75e68bdea87e2f7a9e0127fc038a138</anchor>
      <arglist>(const DigraphNode &amp;n)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Node</type>
      <name>outNode</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>a5b34aa374711534d2c56a2253e21c71b</anchor>
      <arglist>(const DigraphNode &amp;n)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Arc</type>
      <name>arc</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>a2e84b05c0825d772b21ededdfb7a83e1</anchor>
      <arglist>(const DigraphNode &amp;n)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Arc</type>
      <name>arc</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>adeda0d2dde8caca551ceb4279023b291</anchor>
      <arglist>(const DigraphArc &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static CombinedNodeMap&lt; IN, OUT &gt;</type>
      <name>combinedNodeMap</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>abd28849688d294002542a09b8f532f42</anchor>
      <arglist>(IN &amp;in_map, OUT &amp;out_map)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static CombinedArcMap&lt; ArcMap, NodeMap &gt;</type>
      <name>combinedArcMap</name>
      <anchorfile>a00414.html</anchorfile>
      <anchor>a7d0412a1028cfe284f40763a343698dd</anchor>
      <arglist>(ArcMap &amp;arc_map, NodeMap &amp;node_map)</arglist>
    </member>
    <member kind="function">
      <type>SplitNodes&lt; DGR &gt;</type>
      <name>splitNodes</name>
      <anchorfile>a00599.html</anchorfile>
      <anchor>gabf58921acaca2eb95d042e2d7440ac20</anchor>
      <arglist>(const DGR &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SplitNodes::CombinedArcMap</name>
    <filename>a00095.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Arc</type>
      <name>Key</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>a49324d309ab1fbcdfd1e07ecc5f48b39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AM::Value</type>
      <name>Value</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>a9451425a7d8c5c2fb3079bd0a3483297</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CombinedArcMap</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>a7c4c19566ea6648fab99a6788307c42b</anchor>
      <arglist>(AM &amp;arc_map, NM &amp;node_map)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>ae8346d86811106ea17363c754b7d1f8c</anchor>
      <arglist>(const Key &amp;arc) const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>ae04f0399db80fbb09db6e916e08cb53a</anchor>
      <arglist>(const Key &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00095.html</anchorfile>
      <anchor>a4298356c4811426ffa189423d8165413</anchor>
      <arglist>(const Arc &amp;arc, const Value &amp;val)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SplitNodes::CombinedNodeMap</name>
    <filename>a00096.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Node</type>
      <name>Key</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>ae05d965da541abbbd35cc532b534496d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IN::Value</type>
      <name>Value</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>ab01dedd73125983bb1ea31cc9e77b149</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CombinedNodeMap</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>a91d4277520d815686fee8fe613eab57c</anchor>
      <arglist>(IN &amp;in_map, OUT &amp;out_map)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>adad303dedbe162e83d5c454f631ab5d7</anchor>
      <arglist>(const Key &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>afc48ad56cf63a3484c36594a3057a007</anchor>
      <arglist>(const Key &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00096.html</anchorfile>
      <anchor>a603dc3052fdde5db5980a0846177e561</anchor>
      <arglist>(const Key &amp;key, const Value &amp;value)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ArgParserException</name>
    <filename>a00040.html</filename>
    <base>lemon::Exception</base>
    <member kind="enumeration">
      <type></type>
      <name>Reason</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>af38960e2d1da2c992b2232eb3f285c4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>HELP</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>af38960e2d1da2c992b2232eb3f285c4ea9f5cb747b2e1f0ea781d2b1f2a5b4824</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNKNOWN_OPT</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>af38960e2d1da2c992b2232eb3f285c4eabfd8812b728977aa16448b7751ef9508</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVALID_OPT</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>af38960e2d1da2c992b2232eb3f285c4ead53c24d6a74a9e0e024703198b877d83</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArgParserException</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>a143c5e00789073bb68ef6139fa3de431</anchor>
      <arglist>(Reason r)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ArgParserException</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>a1c939d24b50b26afad675f36ca7ed544</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>aff06f49065b54a8a86e02e9a2441a8ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Reason</type>
      <name>reason</name>
      <anchorfile>a00040.html</anchorfile>
      <anchor>a7f8c4ee0585c29a4b25fb85a8801c442</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Exception</name>
      <anchorfile>a00160.html</anchorfile>
      <anchor>abfbc23b99b2e78b609d50ac688611236</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Exception</name>
      <anchorfile>a00160.html</anchorfile>
      <anchor>ae55b5e05d3195ae27204e3a2395e54e7</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ArgParser</name>
    <filename>a00039.html</filename>
    <class kind="class">lemon::ArgParser::RefType</class>
    <member kind="function">
      <type></type>
      <name>ArgParser</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>ac53646f9d7508088703ae971557756da</anchor>
      <arglist>(int argc, const char *const *argv)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>parse</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a2b68b45bae933b58b66b151f191720bf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>run</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>aff25e191acdc1f1e9bac4af25910bd35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>commandName</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a7bf048cb0732b56d6b2c063b1a169665</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>given</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>aa417e252cac80107c8cfb24f4b53a8ef</anchor>
      <arglist>(std::string op) const </arglist>
    </member>
    <member kind="function">
      <type>RefType</type>
      <name>operator[]</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>aa996493529b42f509b8a48bf44c8eaf6</anchor>
      <arglist>(const std::string &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; std::string &gt; &amp;</type>
      <name>files</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>ae4ff6b28809bdf1bbff6f2bad5ee41fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>throwOnProblems</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a4f78fd6d3de2bbcab981ec4df3826842</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>intOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a85d559c4b20d2f3fce8fd8e75338d9f5</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, int value=0, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>doubleOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a0c5536fa3fbccef684622c7c3f77388f</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, double value=0, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>boolOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>ae4fcf9d73bc7e527ac0db7c9d6a3f4a9</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, bool value=false, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>stringOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a2cb1ffd505413d02cd363cbd7f7e6fed</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, std::string value=&quot;&quot;, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>other</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>aa8519a140b285cbefa1fa47af0e9a9a6</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>refOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>af72e3b37d1b0d8c06a35ced1e19945da</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, int &amp;ref, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>refOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a9551cb0275da0c50091fef78e1fb5a86</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, double &amp;ref, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>refOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a154ab534f7b4040ab84c261aebfd33a5</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, bool &amp;ref, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>refOption</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a3e587e44687ddcc3310006f27cbbb0fe</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;help, std::string &amp;ref, bool obl=false)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>optionGroup</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>aad20f888d2bc5c590777b753b8b63e90</anchor>
      <arglist>(const std::string &amp;group, const std::string &amp;opt)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>onlyOneGroup</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a1da70c717947a87bcaf0ba40b8cbe411</anchor>
      <arglist>(const std::string &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>mandatoryGroup</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>abac885c55c4c5acefd2726d61c89d832</anchor>
      <arglist>(const std::string &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>ArgParser &amp;</type>
      <name>synonym</name>
      <anchorfile>a00039.html</anchorfile>
      <anchor>a84fdd5f9ed184b3ef96a142590d9c7b3</anchor>
      <arglist>(const std::string &amp;syn, const std::string &amp;opt)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ArgParser::RefType</name>
    <filename>a00329.html</filename>
    <member kind="function">
      <type></type>
      <name>RefType</name>
      <anchorfile>a00329.html</anchorfile>
      <anchor>a6cda207aa9b4110a1469a62e2e50b88b</anchor>
      <arglist>(const ArgParser &amp;p, const std::string &amp;n)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>a00329.html</anchorfile>
      <anchor>a9b3baad8c612d81b96e46f84d7e97580</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::string</name>
      <anchorfile>a00329.html</anchorfile>
      <anchor>aec21c2daaac19676aa46134f63b471c1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator double</name>
      <anchorfile>a00329.html</anchorfile>
      <anchor>aabab268504345fcb036094bc7b5c4438</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator int</name>
      <anchorfile>a00329.html</anchorfile>
      <anchor>a4f4ea421e40bda08a2deca657f640fea</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFordDefaultOperationTraits</name>
    <filename>a00046.html</filename>
    <templarg></templarg>
    <templarg>has_inf</templarg>
    <member kind="typedef">
      <type>V</type>
      <name>Value</name>
      <anchorfile>a00046.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Value</type>
      <name>zero</name>
      <anchorfile>a00046.html</anchorfile>
      <anchor>af24efe5c6b0edcb586538222fb5b1024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Value</type>
      <name>infinity</name>
      <anchorfile>a00046.html</anchorfile>
      <anchor>a487765dbdbd563fc3caa194604d15ff3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Value</type>
      <name>plus</name>
      <anchorfile>a00046.html</anchorfile>
      <anchor>acce469a9728bdb4c09c015dc31a3eb3c</anchor>
      <arglist>(const Value &amp;left, const Value &amp;right)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>less</name>
      <anchorfile>a00046.html</anchorfile>
      <anchor>ac142bbf30883f244af50aefbf661bd6a</anchor>
      <arglist>(const Value &amp;left, const Value &amp;right)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFordDefaultTraits</name>
    <filename>a00047.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN</type>
      <name>LengthMap</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>a7398ca1da160bb30ee090866bbfc12ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN::Value</type>
      <name>Value</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>ac2ac7ac2928b4cfeafdc493dd44f61c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BellmanFordDefaultOperationTraits&lt; Value &gt;</type>
      <name>OperationTraits</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>a09df2d7b4ed4cfbbc6431921d8f6a88d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::template NodeMap&lt; typename GR::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>a8176d7b91f93809e5b43676eecb9d0f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::template NodeMap&lt; typename LEN::Value &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>a4f599bfd20251ee3839115448bec4f8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>a4cbffce5c2582d9f80a3c53852cc8c1e</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00047.html</anchorfile>
      <anchor>af897611d52b68e40c140c4838dc14362</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BellmanFord</name>
    <filename>a00045.html</filename>
    <templarg>GR</templarg>
    <templarg>LEN</templarg>
    <templarg>TR</templarg>
    <class kind="class">lemon::BellmanFord::ActiveIt</class>
    <class kind="struct">lemon::BellmanFord::SetDistMap</class>
    <class kind="struct">lemon::BellmanFord::SetOperationTraits</class>
    <class kind="struct">lemon::BellmanFord::SetPredMap</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LengthMap::Value</type>
      <name>Value</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6f677ff45d75aa12b23a873c02b37256</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3c6b227a4a6d76c8c5960ab4d713c1d7</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa08834fed4ff14ac7d8a10391f0f82f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a01e0b5327109e861429c3c9971b3ba3e</anchor>
      <arglist>(const LengthMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa5db6c51d541df4b4b20f43f501ac11b</anchor>
      <arglist>(PredMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a7d28eb0ac8edbafbad854997781038a3</anchor>
      <arglist>(DistMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a1908307057e2129bc3ac13f30beab5ec</anchor>
      <arglist>(const Value value=OperationTraits::infinity())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af16b57c30311aa0ad8595c05149ccd36</anchor>
      <arglist>(Node source, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>acbe7e43e0e9317a5a7a915be97e2b71a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextWeakRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a40e71e9190752153cf04bd48835dd50c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3bc557223ef2af001c022580f9c8e18c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>limitedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab2a0b7b42728a941e49dde2b22051910</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae880685084df985ac030788c8d4537ae</anchor>
      <arglist>(Node s, int num)</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>negativeCycle</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a49502ea10223eea0931c80fbf9846a93</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BellmanFord::ActiveIt</name>
    <filename>a00015.html</filename>
    <member kind="function">
      <type></type>
      <name>ActiveIt</name>
      <anchorfile>a00015.html</anchorfile>
      <anchor>aa77bdb8f7f227458f6db20ce38b743af</anchor>
      <arglist>(const BellmanFord &amp;algorithm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ActiveIt</name>
      <anchorfile>a00015.html</anchorfile>
      <anchor>ad96db31e04f57f809ce31e01591169e9</anchor>
      <arglist>(Invalid)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Node</name>
      <anchorfile>a00015.html</anchorfile>
      <anchor>a842a9fc933bc21c81d8d2790744a19b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ActiveIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00015.html</anchorfile>
      <anchor>a20702848d6889fbbc4e2ab2e393164f1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFord::SetDistMap</name>
    <filename>a00344.html</filename>
    <templarg></templarg>
    <base>BellmanFord&lt; Digraph, LengthMap, SetDistMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::LengthMap::Value</type>
      <name>Value</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6f677ff45d75aa12b23a873c02b37256</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3c6b227a4a6d76c8c5960ab4d713c1d7</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa08834fed4ff14ac7d8a10391f0f82f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a01e0b5327109e861429c3c9971b3ba3e</anchor>
      <arglist>(const LengthMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa5db6c51d541df4b4b20f43f501ac11b</anchor>
      <arglist>(PredMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a7d28eb0ac8edbafbad854997781038a3</anchor>
      <arglist>(DistMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>negativeCycle</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a49502ea10223eea0931c80fbf9846a93</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a1908307057e2129bc3ac13f30beab5ec</anchor>
      <arglist>(const Value value=OperationTraits::infinity())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af16b57c30311aa0ad8595c05149ccd36</anchor>
      <arglist>(Node source, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>acbe7e43e0e9317a5a7a915be97e2b71a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextWeakRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a40e71e9190752153cf04bd48835dd50c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3bc557223ef2af001c022580f9c8e18c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>limitedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab2a0b7b42728a941e49dde2b22051910</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae880685084df985ac030788c8d4537ae</anchor>
      <arglist>(Node s, int num)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFord::SetOperationTraits</name>
    <filename>a00366.html</filename>
    <templarg></templarg>
    <base>BellmanFord&lt; Digraph, LengthMap, SetOperationTraitsTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::LengthMap::Value</type>
      <name>Value</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6f677ff45d75aa12b23a873c02b37256</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3c6b227a4a6d76c8c5960ab4d713c1d7</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa08834fed4ff14ac7d8a10391f0f82f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a01e0b5327109e861429c3c9971b3ba3e</anchor>
      <arglist>(const LengthMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa5db6c51d541df4b4b20f43f501ac11b</anchor>
      <arglist>(PredMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a7d28eb0ac8edbafbad854997781038a3</anchor>
      <arglist>(DistMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>negativeCycle</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a49502ea10223eea0931c80fbf9846a93</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a1908307057e2129bc3ac13f30beab5ec</anchor>
      <arglist>(const Value value=OperationTraits::infinity())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af16b57c30311aa0ad8595c05149ccd36</anchor>
      <arglist>(Node source, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>acbe7e43e0e9317a5a7a915be97e2b71a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextWeakRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a40e71e9190752153cf04bd48835dd50c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3bc557223ef2af001c022580f9c8e18c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>limitedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab2a0b7b42728a941e49dde2b22051910</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae880685084df985ac030788c8d4537ae</anchor>
      <arglist>(Node s, int num)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFord::SetPredMap</name>
    <filename>a00375.html</filename>
    <templarg></templarg>
    <base>BellmanFord&lt; Digraph, LengthMap, SetPredMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::LengthMap::Value</type>
      <name>Value</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6f677ff45d75aa12b23a873c02b37256</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3c6b227a4a6d76c8c5960ab4d713c1d7</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BellmanFord</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa08834fed4ff14ac7d8a10391f0f82f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a01e0b5327109e861429c3c9971b3ba3e</anchor>
      <arglist>(const LengthMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aa5db6c51d541df4b4b20f43f501ac11b</anchor>
      <arglist>(PredMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFord &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a7d28eb0ac8edbafbad854997781038a3</anchor>
      <arglist>(DistMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>negativeCycle</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a49502ea10223eea0931c80fbf9846a93</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a1908307057e2129bc3ac13f30beab5ec</anchor>
      <arglist>(const Value value=OperationTraits::infinity())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>af16b57c30311aa0ad8595c05149ccd36</anchor>
      <arglist>(Node source, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>acbe7e43e0e9317a5a7a915be97e2b71a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processNextWeakRound</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a40e71e9190752153cf04bd48835dd50c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>a3bc557223ef2af001c022580f9c8e18c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>limitedStart</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ab2a0b7b42728a941e49dde2b22051910</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00045.html</anchorfile>
      <anchor>ae880685084df985ac030788c8d4537ae</anchor>
      <arglist>(Node s, int num)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BellmanFordWizardDefaultTraits</name>
    <filename>a00050.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN</type>
      <name>LengthMap</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>a7398ca1da160bb30ee090866bbfc12ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN::Value</type>
      <name>Value</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>ac2ac7ac2928b4cfeafdc493dd44f61c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BellmanFordDefaultOperationTraits&lt; Value &gt;</type>
      <name>OperationTraits</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>a09df2d7b4ed4cfbbc6431921d8f6a88d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::template NodeMap&lt; typename GR::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>a8176d7b91f93809e5b43676eecb9d0f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::template NodeMap&lt; Value &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>af31fa1b50fa8782aafbc4da100c12f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>a4cbffce5c2582d9f80a3c53852cc8c1e</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00050.html</anchorfile>
      <anchor>af897611d52b68e40c140c4838dc14362</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BellmanFordWizardBase</name>
    <filename>a00049.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>lemon::BellmanFordWizardDefaultTraits</base>
    <member kind="function">
      <type></type>
      <name>BellmanFordWizardBase</name>
      <anchorfile>a00049.html</anchorfile>
      <anchor>a39492ea142c97439267800754c6fbc27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFordWizardBase</name>
      <anchorfile>a00049.html</anchorfile>
      <anchor>a88ae24e2d767a1d91bba0d4a48351590</anchor>
      <arglist>(const GR &amp;gr, const LEN &amp;len)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BellmanFordWizard</name>
    <filename>a00048.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>BellmanFordWizard</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>abc75367ac6b5ff701f2ae9d71893719a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFordWizard</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>a1c8b789af80f3b7934889b99238a8989</anchor>
      <arglist>(const Digraph &amp;gr, const LengthMap &amp;len)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BellmanFordWizard</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>ab489713251eaf86202f47b0ece0dc544</anchor>
      <arglist>(const TR &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFordWizard&lt; SetPredMapBase&lt; T &gt; &gt;</type>
      <name>predMap</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>a229d34ab5a905141ba90af0034d952fa</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFordWizard&lt; SetDistMapBase&lt; T &gt; &gt;</type>
      <name>distMap</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>a3c1017941d8af18faaa186c3224ba43a</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFordWizard&lt; SetPathBase&lt; T &gt; &gt;</type>
      <name>path</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>a580048172bf19d73192833e6dc5008b8</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BellmanFordWizard</type>
      <name>dist</name>
      <anchorfile>a00048.html</anchorfile>
      <anchor>a35e5917e19460b86655a904e61980a01</anchor>
      <arglist>(const Value &amp;d)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BfsDefaultTraits</name>
    <filename>a00052.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>ae1b02f76f4c6728d9c92da415fe15f7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>a1c6c24dc0cfde917210decb6f31be54c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00052.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Bfs</name>
    <filename>a00051.html</filename>
    <templarg>GR</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::Bfs::SetDistMap</class>
    <class kind="struct">lemon::Bfs::SetPredMap</class>
    <class kind="struct">lemon::Bfs::SetProcessedMap</class>
    <class kind="struct">lemon::Bfs::SetReachedMap</class>
    <class kind="struct">lemon::Bfs::SetStandardProcessedMap</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Bfs::SetDistMap</name>
    <filename>a00346.html</filename>
    <templarg></templarg>
    <base>Bfs&lt; Digraph, SetDistMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Bfs::SetPredMap</name>
    <filename>a00376.html</filename>
    <templarg></templarg>
    <base>Bfs&lt; Digraph, SetPredMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Bfs::SetProcessedMap</name>
    <filename>a00377.html</filename>
    <templarg></templarg>
    <base>Bfs&lt; Digraph, SetProcessedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Bfs::SetReachedMap</name>
    <filename>a00384.html</filename>
    <templarg></templarg>
    <base>Bfs&lt; Digraph, SetReachedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Bfs::SetStandardProcessedMap</name>
    <filename>a00393.html</filename>
    <base>Bfs&lt; Digraph, SetStandardProcessedMapTraits &gt;</base>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits</type>
      <name>Traits</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a55f525c9a3cc7a3ecb17c51873ba1d14</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Bfs</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a067322e85a116d7670a30085cbff7b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac22804dedcadfd64208f659d6bd89545</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad1dce733ba42cd5b68c9713af742d0a6</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a5d0c6be2ef05e6121193b38146492956</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Bfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a3051385a839729dc0c5418be2fa1f085</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00051.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BfsWizardDefaultTraits</name>
    <filename>a00058.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>ae1b02f76f4c6728d9c92da415fe15f7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>a1c6c24dc0cfde917210decb6f31be54c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00058.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BfsWizardBase</name>
    <filename>a00057.html</filename>
    <templarg></templarg>
    <base>lemon::BfsWizardDefaultTraits</base>
    <member kind="function">
      <type></type>
      <name>BfsWizardBase</name>
      <anchorfile>a00057.html</anchorfile>
      <anchor>aad43a7eb3f6d54e0d1cb37f29b8eb08b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BfsWizardBase</name>
      <anchorfile>a00057.html</anchorfile>
      <anchor>ad2360a2aeec62c51672a4dcd6615e7fb</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BfsWizard</name>
    <filename>a00056.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>BfsWizard</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>ae8923bde3788f91e3b2bf9191c73bd39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BfsWizard</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a59efab63f61b1c5e17b0c5b3b30c0afb</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BfsWizard</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a759468eb61ca1b166698056c8a36f5fe</anchor>
      <arglist>(const TR &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; SetPredMapBase&lt; T &gt; &gt;</type>
      <name>predMap</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a12355865a83748eeb2b79906e5e5c885</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; SetReachedMapBase&lt; T &gt; &gt;</type>
      <name>reachedMap</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>ae0e8a3a6c9e36e78bdf7cdecaf316c69</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; SetDistMapBase&lt; T &gt; &gt;</type>
      <name>distMap</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a8865be0ff557952805945f4dfc639c17</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; SetProcessedMapBase&lt; T &gt; &gt;</type>
      <name>processedMap</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a0dd01920ffe44efe6ab0fefdf392688d</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard&lt; SetPathBase&lt; T &gt; &gt;</type>
      <name>path</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a0bdd8c0d423d4048b8574d2e0430cbcc</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>BfsWizard</type>
      <name>dist</name>
      <anchorfile>a00056.html</anchorfile>
      <anchor>a1c2895f9c7861ca965fc4ec37c4b36e2</anchor>
      <arglist>(const int &amp;d)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BfsVisitor</name>
    <filename>a00055.html</filename>
    <templarg>GR</templarg>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00055.html</anchorfile>
      <anchor>af763d0c0856194421ebd6ccc73b921c3</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reach</name>
      <anchorfile>a00055.html</anchorfile>
      <anchor>a4f6dc7007e25f1c20b4fbb8912a83817</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchorfile>a00055.html</anchorfile>
      <anchor>aa2d367c34d01e4e014e461f40b2f7203</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>discover</name>
      <anchorfile>a00055.html</anchorfile>
      <anchor>abe70d6cbc4419667e6aa533fc0fa262f</anchor>
      <arglist>(const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>examine</name>
      <anchorfile>a00055.html</anchorfile>
      <anchor>a3656d1f80036aee1dcaa927450b70c2a</anchor>
      <arglist>(const Arc &amp;arc)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BfsVisitDefaultTraits</name>
    <filename>a00054.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00054.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00054.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00054.html</anchorfile>
      <anchor>a1491e8ada6a6d5fdd321e3fee43844e1</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BfsVisit</name>
    <filename>a00053.html</filename>
    <templarg>GR</templarg>
    <templarg>VS</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::BfsVisit::SetReachedMap</class>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VS</type>
      <name>Visitor</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a3bece3b7c0b0189b735a408e533f3d73</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a90221be1b9274785db2188548354d2aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BfsVisit</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ae27c446704010b785a05379a1e02811e</anchor>
      <arglist>(const Digraph &amp;digraph, Visitor &amp;visitor)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BfsVisit</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8bf7b105577e2894778cc63cbec43a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BfsVisit &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a51540af2212fa8760166385adbaa9f34</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a88d45ba85d8c33207fa0654c17ab2006</anchor>
      <arglist>(const NM &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::BfsVisit::SetReachedMap</name>
    <filename>a00381.html</filename>
    <templarg></templarg>
    <base>BfsVisit&lt; Digraph, Visitor, SetReachedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Visitor</type>
      <name>Visitor</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a3bece3b7c0b0189b735a408e533f3d73</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a90221be1b9274785db2188548354d2aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BfsVisit</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ae27c446704010b785a05379a1e02811e</anchor>
      <arglist>(const Digraph &amp;digraph, Visitor &amp;visitor)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BfsVisit</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8bf7b105577e2894778cc63cbec43a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BfsVisit &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a51540af2212fa8760166385adbaa9f34</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8f85441d2cf615f40794ac052db5cb18</anchor>
      <arglist>(Node target, bool &amp;reach)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aaa1f6562157e06f1807253d8e8fa08c2</anchor>
      <arglist>(const NM &amp;nm, Node &amp;rnode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a88d45ba85d8c33207fa0654c17ab2006</anchor>
      <arglist>(const NM &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00053.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BinHeap</name>
    <filename>a00059.html</filename>
    <templarg>PR</templarg>
    <templarg>IM</templarg>
    <templarg>CMP</templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PR</type>
      <name>Prio</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a644810a55913c9e8b24511758574d6d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; Item, Prio &gt;</type>
      <name>Pair</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a616fe456bc4c8eddf813c4f5665e1180</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CMP</type>
      <name>Compare</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a937d59343e7b08b620805162c2e52ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BinHeap</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>acf056081005598d56af81013dc122e3f</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BinHeap</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ad37464eb1f70d05e41d8b2f99c3b7b54</anchor>
      <arglist>(ItemIntMap &amp;map, const Compare &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5b654214309b6f25fceeec04e2b1a016</anchor>
      <arglist>(const Pair &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>ad34f576dafc84f8969e2fecd67cd3a15</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a5fe7eab02681c7735ba173c879de1681</anchor>
      <arglist>(const Item &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>operator[]</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a74ccb13d905bf8b608f3426131977cc0</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a35c06441ccfac0ed04762113a102e6b3</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decrease</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a301fdc87288afdebf379ae043cf66cd4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increase</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a958836bae38b188956bcf1345c63eac4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a613888b340ee362e2f4da6f2e2b97428</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>state</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>a7d0ca230d438efaad53833701d9cb262</anchor>
      <arglist>(const Item &amp;i, State st)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a00059.html</anchorfile>
      <anchor>aa3d169f66b376619ebb1825f6c027482</anchor>
      <arglist>(const Item &amp;i, const Item &amp;j)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BinomialHeap</name>
    <filename>a00060.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PR</type>
      <name>Prio</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a644810a55913c9e8b24511758574d6d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CMP</type>
      <name>Compare</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a937d59343e7b08b620805162c2e52ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BinomialHeap</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a6c476fe3ee11480a57545c069b0c912d</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BinomialHeap</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a081f9542eed0eb80c980f95e850e4d43</anchor>
      <arglist>(ItemIntMap &amp;map, const Compare &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a2afbafcc371d28f515a05b42d1c76ac2</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ab2a94f4be01dadf3bd9248a3749f1c78</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Prio &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>aeba07a9a00504f6800bc2895b44b2df1</anchor>
      <arglist>(const Item &amp;item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ab71f9a526f9dfa9ded1fdd78189c3e37</anchor>
      <arglist>(const Item &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decrease</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a86c83bf851da9aa34fa47659abd2820b</anchor>
      <arglist>(Item item, const Prio &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increase</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>ac905557ff91bf880f50d6fff29ac9634</anchor>
      <arglist>(Item item, const Prio &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a583b683cf66fe46dd394837f8751a90b</anchor>
      <arglist>(const Item &amp;item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>state</name>
      <anchorfile>a00060.html</anchorfile>
      <anchor>a7d0ca230d438efaad53833701d9cb262</anchor>
      <arglist>(const Item &amp;i, State st)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BucketHeap</name>
    <filename>a00073.html</filename>
    <templarg></templarg>
    <templarg>MIN</templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>Prio</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a828e2232d3e40c141ccc0aa4eb6a960e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; Item, Prio &gt;</type>
      <name>Pair</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a616fe456bc4c8eddf813c4f5665e1180</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BucketHeap</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>abcf7763ddd0d43afde396f855310ca16</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5b654214309b6f25fceeec04e2b1a016</anchor>
      <arglist>(const Pair &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>ad34f576dafc84f8969e2fecd67cd3a15</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a5fe7eab02681c7735ba173c879de1681</anchor>
      <arglist>(const Item &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>operator[]</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a74ccb13d905bf8b608f3426131977cc0</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a35c06441ccfac0ed04762113a102e6b3</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decrease</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a301fdc87288afdebf379ae043cf66cd4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increase</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a958836bae38b188956bcf1345c63eac4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a613888b340ee362e2f4da6f2e2b97428</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>state</name>
      <anchorfile>a00073.html</anchorfile>
      <anchor>a7d0ca230d438efaad53833701d9cb262</anchor>
      <arglist>(const Item &amp;i, State st)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SimpleBucketHeap</name>
    <filename>a00397.html</filename>
    <templarg></templarg>
    <templarg>MIN</templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>Prio</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a828e2232d3e40c141ccc0aa4eb6a960e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; Item, Prio &gt;</type>
      <name>Pair</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a616fe456bc4c8eddf813c4f5665e1180</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SimpleBucketHeap</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a9aaa89a3a16c544fc046e41ea0faf46b</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a5b654214309b6f25fceeec04e2b1a016</anchor>
      <arglist>(const Pair &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>ad34f576dafc84f8969e2fecd67cd3a15</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>operator[]</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a74ccb13d905bf8b608f3426131977cc0</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00397.html</anchorfile>
      <anchor>a613888b340ee362e2f4da6f2e2b97428</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::CapacityScalingDefaultTraits</name>
    <filename>a00075.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00075.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>V</type>
      <name>Value</name>
      <anchorfile>a00075.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>C</type>
      <name>Cost</name>
      <anchorfile>a00075.html</anchorfile>
      <anchor>adeb81a88e6bbaf933ca20ea3bbba7a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BinHeap&lt; Cost, RangeMap&lt; int &gt; &gt;</type>
      <name>Heap</name>
      <anchorfile>a00075.html</anchorfile>
      <anchor>a5212fa22a215a30621620615986ac5ca</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CapacityScaling</name>
    <filename>a00074.html</filename>
    <templarg>GR</templarg>
    <templarg>V</templarg>
    <templarg>C</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::CapacityScaling::SetHeap</class>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INFEASIBLE</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2884fa43446c0cbc9c7a9b74d41d7483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNBOUNDED</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea6c65123d1b5b01632a477661055b01ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Value</type>
      <name>Value</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Cost</type>
      <name>Cost</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Heap</type>
      <name>Heap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CapacityScaling</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac44b4786c702ac531e5c6bb86273c60e</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a004cab88a9f9b9dfa2329e0342dd5e49</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a5f903f6f906e0a48905ebcbbd5f2ed3d</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>costMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>aadad4c18e48999fd43322f88507eaa54</anchor>
      <arglist>(const CostMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a04ae401d36ae3ca4d5ba730d4f2bb885</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>stSupply</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a412fea5aa104e9826ddeec1fa54d528d</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, Value k)</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>run</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a9f51b418026d5480f76426f974567c5d</anchor>
      <arglist>(int factor=4)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>resetParams</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac33087a2f4ddc981c4a977a291f8973a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>reset</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>af24760b2df0ab9357ce068be8a4f47c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Number</type>
      <name>totalCost</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4e1efd04a6b234645d1ca18d2635d57e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a7fc53c0667fdfb95dadd6a302f045941</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flowMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac7fb0010590a95a23fda72ce45474a2a</anchor>
      <arglist>(FlowMap &amp;map) const </arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>potential</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac97efaa2b500bb002f116bf4ba7c9b0b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>potentialMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>afeeff1d0249ffae4db8cc516b77d2cc9</anchor>
      <arglist>(PotentialMap &amp;map) const </arglist>
    </member>
    <member kind="variable">
      <type>const Value</type>
      <name>INF</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a601ffd79f13610daacadd46f973507c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::CapacityScaling::SetHeap</name>
    <filename>a00358.html</filename>
    <templarg></templarg>
    <base>CapacityScaling&lt; GR, V, C, SetHeapTraits&lt; T &gt; &gt;</base>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; T &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CapacityScaling</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac44b4786c702ac531e5c6bb86273c60e</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a004cab88a9f9b9dfa2329e0342dd5e49</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a5f903f6f906e0a48905ebcbbd5f2ed3d</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>costMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>aadad4c18e48999fd43322f88507eaa54</anchor>
      <arglist>(const CostMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a04ae401d36ae3ca4d5ba730d4f2bb885</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>stSupply</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a412fea5aa104e9826ddeec1fa54d528d</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, Value k)</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>run</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a9f51b418026d5480f76426f974567c5d</anchor>
      <arglist>(int factor=4)</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>resetParams</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac33087a2f4ddc981c4a977a291f8973a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CapacityScaling &amp;</type>
      <name>reset</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>af24760b2df0ab9357ce068be8a4f47c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Number</type>
      <name>totalCost</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a4e1efd04a6b234645d1ca18d2635d57e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a7fc53c0667fdfb95dadd6a302f045941</anchor>
      <arglist>(const Arc &amp;a) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flowMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac7fb0010590a95a23fda72ce45474a2a</anchor>
      <arglist>(FlowMap &amp;map) const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>potential</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>ac97efaa2b500bb002f116bf4ba7c9b0b</anchor>
      <arglist>(const Node &amp;n) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>potentialMap</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>afeeff1d0249ffae4db8cc516b77d2cc9</anchor>
      <arglist>(PotentialMap &amp;map) const</arglist>
    </member>
    <member kind="variable">
      <type>const Value</type>
      <name>INF</name>
      <anchorfile>a00074.html</anchorfile>
      <anchor>a601ffd79f13610daacadd46f973507c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CbcMip</name>
    <filename>a00076.html</filename>
    <base>lemon::MipSolver</base>
    <member kind="function">
      <type></type>
      <name>CbcMip</name>
      <anchorfile>a00076.html</anchorfile>
      <anchor>ab1ff7c7f55a6ae5f87eeebe0d5a1421c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CbcMip</name>
      <anchorfile>a00076.html</anchorfile>
      <anchor>a04420c67edf64119f3df6b79cc7e705d</anchor>
      <arglist>(const CbcMip &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~CbcMip</name>
      <anchorfile>a00076.html</anchorfile>
      <anchor>accd7e3de4fc06851977426ea9f34e83b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CbcMip *</type>
      <name>newSolver</name>
      <anchorfile>a00076.html</anchorfile>
      <anchor>a14a0f509c697e8a1ff38d542911a7b0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CbcMip *</type>
      <name>cloneSolver</name>
      <anchorfile>a00076.html</anchorfile>
      <anchor>a1538f13f85436ace01b42de014783a7f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solve</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a1963be740c5f32bb76dfc9df4c2de376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>type</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a085c0dfe4f0aa0442c9a31b99e396b90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>sol</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a13b82b692292e7d694033d89451a0199</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>sol</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>ab805549c7229890a9557278d06e85d42</anchor>
      <arglist>(const Expr &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>solValue</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a39b170fcdf246f7e8bc0dea2423a8647</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colType</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>aa7e3fcdb8e8840d5a4ce7a74a143de8c</anchor>
      <arglist>(Col c, ColTypes col_type)</arglist>
    </member>
    <member kind="function">
      <type>ColTypes</type>
      <name>colType</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a976be9b0ed7194fa58e57c847b2a3508</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LpBase</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a26ecf0974cd1cab0ed58ae67ff295429</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>solverName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aa36ad09b49f4281a3b3ce71f2c241289</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Col</type>
      <name>addCol</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ace2f580cd6308e948d9691a01845c8ec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addColSet</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a90ad8883f2bc8f96fa265be4ee9f9eaf</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>col</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a41f5b9e3a8f92ce2560a62f3e8b0250f</anchor>
      <arglist>(Col c, const DualExpr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>DualExpr</type>
      <name>col</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a61bc603824e086c53440c385ebc42e53</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>Col</type>
      <name>addCol</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a7ddfc3691600833b1bd53da9dc71799a</anchor>
      <arglist>(const DualExpr &amp;e, Value o=0)</arglist>
    </member>
    <member kind="function">
      <type>Row</type>
      <name>addRow</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a82ce0d31c840a4b11ad5462c0a5a3fc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addRowSet</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ab872a5aad82a45c9ba3a7d5ae7c75ce1</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>row</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ae099f58d682ae7ddebae4a80975af7ab</anchor>
      <arglist>(Row r, Value l, const Expr &amp;e, Value u)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>row</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a6ae967113c39dad59bc508701671b537</anchor>
      <arglist>(Row r, const Constr &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>Expr</type>
      <name>row</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a74c7bb111b543663d3040c40210b1046</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>Row</type>
      <name>addRow</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac979aa7dc6bb67dd2784ed61d469e122</anchor>
      <arglist>(Value l, const Expr &amp;e, Value u)</arglist>
    </member>
    <member kind="function">
      <type>Row</type>
      <name>addRow</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a551823fd575a523630b53488d840325b</anchor>
      <arglist>(const Constr &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ab50b2fcd86d231d5aed7228e4b732572</anchor>
      <arglist>(Col c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a8a5daa2d397c5c1b585711641871971c</anchor>
      <arglist>(Row r)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>colName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a40cd087446f1edb23bcf21c0cbbddb1e</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a926a85f6e1fc4ef4dc9d82dfdf41a954</anchor>
      <arglist>(Col c, const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Col</type>
      <name>colByName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>af8d39077bf7fb6fcc066e1266f6a1ccf</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>rowName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a2796339e099cf560d43433261d108cf4</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rowName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ae0c806c54bb198a105afec8557ccc41b</anchor>
      <arglist>(Row r, const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Row</type>
      <name>rowByName</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ad011ab6444770df9383c447e60aa550c</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>coeff</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a14e7239a59a1d17bf01f53fe3b89e6f8</anchor>
      <arglist>(Row r, Col c, Value val)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>coeff</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a930c625c649c5047d402478aac891e8c</anchor>
      <arglist>(Row r, Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colLowerBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>acbea661131fafe99de521c22af326c39</anchor>
      <arglist>(Col c, Value value)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>colLowerBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aa4d6e3b8659cfd373449359e0c1803b0</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colLowerBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ab3ff2ff3a2adca6d32223d6c1e261995</anchor>
      <arglist>(T &amp;t, Value value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colUpperBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a92dc2b50e43b8238917b037b687e66fe</anchor>
      <arglist>(Col c, Value value)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>colUpperBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a6f94ed1b3b1fbf8ed64bdad5cb2d5df4</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colUpperBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac9d106d2a1abf6ecf29142cbfe9d89e5</anchor>
      <arglist>(T &amp;t, Value value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colBounds</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a6d4a12e3ebf7ac7bcb4d35a3f18b5422</anchor>
      <arglist>(Col c, Value lower, Value upper)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>colBounds</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac8e452cab21de73fc1a0e51e614e5783</anchor>
      <arglist>(T &amp;t, Value lower, Value upper)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rowLowerBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a5e454afcea273dccc19a793e9a95aecc</anchor>
      <arglist>(Row r, Value value)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>rowLowerBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a0f9508b028d6692acdaa022036a84b15</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rowUpperBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a41e9d2136a9983180a57390d56f449f5</anchor>
      <arglist>(Row r, Value value)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>rowUpperBound</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a89bfc5c8e24a596a2e2b794a2695f92e</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>objCoeff</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ae7188a8596024077d2a6e37968c49686</anchor>
      <arglist>(Col c, Value v)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>objCoeff</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a9f8768e82121a924c232d1f5b287eb27</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>obj</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>af2ad43b3dd09721bff1f5bdc40cf7146</anchor>
      <arglist>(const Expr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>Expr</type>
      <name>obj</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a5017a0af45f30e38575720ae146a95b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sense</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ae3674508394adc61d4f307fcecae2d70</anchor>
      <arglist>(Sense sense)</arglist>
    </member>
    <member kind="function">
      <type>Sense</type>
      <name>sense</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a236973a073493935ccb5ffc69247fdbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>max</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a6a360455761dfb54fa2567a5c2e46b70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>min</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a0ea60e842310906e02cac7ba70cfb591</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>messageLevel</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>abcb84b14cad394ce094af144f3508d89</anchor>
      <arglist>(MessageLevel level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a6f987737d989d046dd4c24150442ff14</anchor>
      <arglist>(std::string file, std::string format=&quot;MPS&quot;) const </arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNDEFINED</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea605159e8a4c32319fd69b5d151369d93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INFEASIBLE</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2884fa43446c0cbc9c7a9b74d41d7483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FEASIBLE</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea03f919221217f95d21a593a7120165e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNBOUNDED</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea6c65123d1b5b01632a477661055b01ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ColTypes</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a2abb63446fb6107f8e2f4dbe9de2e082</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REAL</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a2abb63446fb6107f8e2f4dbe9de2e082a053cb139f4b2333482449705c529b1e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INTEGER</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a2abb63446fb6107f8e2f4dbe9de2e082a5a063e265d2ac903b6808e9f6e73ec46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SolveExitStatus</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a4a5e4b34b14952c4c826e3a859028e31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOLVED</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a4a5e4b34b14952c4c826e3a859028e31a0a5e81bed8da1cf85236aa6eb7569818</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNSOLVED</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a4a5e4b34b14952c4c826e3a859028e31a38e4b0838cfb137a637dcf0f5217b694</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Sense</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac56a6b1edba1f6deaff6fae135e6fd9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MIN</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac56a6b1edba1f6deaff6fae135e6fd9ea957e8250f68e7b5677b22397c2c1b51e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MAX</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>ac56a6b1edba1f6deaff6fae135e6fd9ead7e097bda6d981de2520f49fe74c25b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MessageLevel</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_NOTHING</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dcae7a3f9c19e1a769bc42013b29b931336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_ERROR</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dcaeed68e2821e40e5751af74e449ba1fa7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_WARNING</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dcaa0da5a01a18f78c0f248941ad32cc816</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_NORMAL</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dca3b0309750c8c5bf0ad071cf382f10c67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_VERBOSE</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaf5eea9687ad679dc3e504d373e959dca0c984e9c0f0f8aeb2ff46a546ce18d56</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>Value</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a566a00621638570a4186414035153a2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>id</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>af34daa7955b659dc2ab4ee97db331c41</anchor>
      <arglist>(const Col &amp;col)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Col</type>
      <name>colFromId</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aaccb11eb6305e70717547653560fc7bd</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>id</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a9d1b0b46568a37601e77e137e281b526</anchor>
      <arglist>(const Row &amp;row)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Row</type>
      <name>rowFromId</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a77816a8220e3071b1c6f633ec2d528e5</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Value</type>
      <name>INF</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>aae6d881c548a17a1a9e6aa13e3f2c397</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Value</type>
      <name>NaN</name>
      <anchorfile>a00247.html</anchorfile>
      <anchor>a7c8e1716b1e4ce72db4eb41902a0cf2d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ChristofidesTsp</name>
    <filename>a00077.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM::Value</type>
      <name>Cost</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a1a1dfba092aeec4656ebceaf99ca8b22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ChristofidesTsp</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>af589c2ff4400edf3892b073908b01f19</anchor>
      <arglist>(const FullGraph &amp;gr, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>run</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>af294138cc991668caa699c9255c8f136</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>tourCost</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a2b50553673232826084189a99f3ed9ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; Node &gt; &amp;</type>
      <name>tourNodes</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a81073828a7db97f717d815d40b7d129f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tourNodes</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a010a65e00187b4a154800b5e0b113cd3</anchor>
      <arglist>(Iterator out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tour</name>
      <anchorfile>a00077.html</anchorfile>
      <anchor>a15eae02ecc81a0f40b2ee2f76b478a6c</anchor>
      <arglist>(Path &amp;path) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::CirculationDefaultTraits</name>
    <filename>a00079.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LM</type>
      <name>LowerMap</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>ae46c3221b25227a3b78e9f9a1b3f42ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>UM</type>
      <name>UpperMap</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>a96f0ba1f755808fb6478bad8c221187d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SM</type>
      <name>SupplyMap</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>abddcbdf598a9a95ef03684914e7e9991</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SupplyMap::Value</type>
      <name>Value</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>a87bda177e2c2c008e4662ba93e88a32f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::ArcMap&lt; Value &gt;</type>
      <name>FlowMap</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>a96d8e23f3aa7e1f5c97c91eae139de3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Elevator&lt; GR, GR::Node &gt;</type>
      <name>Elevator</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>af3390aa8ccdc072ceee447dcb2f33145</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Tolerance&lt; Value &gt;</type>
      <name>Tolerance</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>ac8d81c6484d646b8881c72707f2527d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static FlowMap *</type>
      <name>createFlowMap</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>afd79e520abbe90ea86b8013071afb57b</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Elevator *</type>
      <name>createElevator</name>
      <anchorfile>a00079.html</anchorfile>
      <anchor>a899dadca634616cbf6500efbc71610e5</anchor>
      <arglist>(const Digraph &amp;digraph, int max_level)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Circulation</name>
    <filename>a00078.html</filename>
    <templarg>GR</templarg>
    <templarg>LM</templarg>
    <templarg>UM</templarg>
    <templarg>SM</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::Circulation::SetElevator</class>
    <class kind="struct">lemon::Circulation::SetFlowMap</class>
    <class kind="struct">lemon::Circulation::SetStandardElevator</class>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::LowerMap</type>
      <name>LowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abe92e2b425d46397f1add6fdd6db6b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::UpperMap</type>
      <name>UpperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a83be4d86b37c7a43dab64a4b1b5ccb79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::SupplyMap</type>
      <name>SupplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a040d59dc3d4879cc8f00ac310308772c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a078a395cce67cc7938d85be25aa74718</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a766fcc516e43681f77caad90d5e73913</anchor>
      <arglist>(const Digraph &amp;graph, const LowerMap &amp;lower, const UpperMap &amp;upper, const SupplyMap &amp;supply)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a602bddf53e2f8737ac8333233ee6e96d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab6c73f90f08dc7da19a258c7e05674a5</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a453a1901f76865172e8f1a677d6fece8</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aab294b65a3aa5747c71fd9ead4a71b50</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3dc1b264f452142f2dc77157b86f5155</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abc8e9abf45d71ce9d03f3a559e8edf8e</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a19773192cea016ada50d3b9470bf36cd</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>greedyInit</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a275cfb5a0d9eeb69e56ec2366e0a4f81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aad5997aaaa2d622f0ca57f8b24a51a7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const </arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>barrierMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1b82e7270d6c6742dda23353878ed33a</anchor>
      <arglist>(BarrierMap &amp;bar) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFlow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3e4c7e285fd08438ba5d265d9daeb094</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkBarrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a7d893a9a4bd20dff09b5d09d05bb7f26</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Circulation::SetElevator</name>
    <filename>a00348.html</filename>
    <templarg></templarg>
    <base>Circulation&lt; Digraph, LowerMap, UpperMap, SupplyMap, SetElevatorTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetElevatorTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::LowerMap</type>
      <name>LowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abe92e2b425d46397f1add6fdd6db6b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::UpperMap</type>
      <name>UpperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a83be4d86b37c7a43dab64a4b1b5ccb79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::SupplyMap</type>
      <name>SupplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a040d59dc3d4879cc8f00ac310308772c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a078a395cce67cc7938d85be25aa74718</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a766fcc516e43681f77caad90d5e73913</anchor>
      <arglist>(const Digraph &amp;graph, const LowerMap &amp;lower, const UpperMap &amp;upper, const SupplyMap &amp;supply)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a602bddf53e2f8737ac8333233ee6e96d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab6c73f90f08dc7da19a258c7e05674a5</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a453a1901f76865172e8f1a677d6fece8</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aab294b65a3aa5747c71fd9ead4a71b50</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3dc1b264f452142f2dc77157b86f5155</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abc8e9abf45d71ce9d03f3a559e8edf8e</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a19773192cea016ada50d3b9470bf36cd</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>barrierMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1b82e7270d6c6742dda23353878ed33a</anchor>
      <arglist>(BarrierMap &amp;bar) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>greedyInit</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a275cfb5a0d9eeb69e56ec2366e0a4f81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aad5997aaaa2d622f0ca57f8b24a51a7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFlow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3e4c7e285fd08438ba5d265d9daeb094</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkBarrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a7d893a9a4bd20dff09b5d09d05bb7f26</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Circulation::SetFlowMap</name>
    <filename>a00351.html</filename>
    <templarg></templarg>
    <base>Circulation&lt; Digraph, LowerMap, UpperMap, SupplyMap, SetFlowMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetFlowMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::LowerMap</type>
      <name>LowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abe92e2b425d46397f1add6fdd6db6b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::UpperMap</type>
      <name>UpperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a83be4d86b37c7a43dab64a4b1b5ccb79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::SupplyMap</type>
      <name>SupplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a040d59dc3d4879cc8f00ac310308772c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a078a395cce67cc7938d85be25aa74718</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a766fcc516e43681f77caad90d5e73913</anchor>
      <arglist>(const Digraph &amp;graph, const LowerMap &amp;lower, const UpperMap &amp;upper, const SupplyMap &amp;supply)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a602bddf53e2f8737ac8333233ee6e96d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab6c73f90f08dc7da19a258c7e05674a5</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a453a1901f76865172e8f1a677d6fece8</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aab294b65a3aa5747c71fd9ead4a71b50</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3dc1b264f452142f2dc77157b86f5155</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abc8e9abf45d71ce9d03f3a559e8edf8e</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a19773192cea016ada50d3b9470bf36cd</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>barrierMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1b82e7270d6c6742dda23353878ed33a</anchor>
      <arglist>(BarrierMap &amp;bar) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>greedyInit</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a275cfb5a0d9eeb69e56ec2366e0a4f81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aad5997aaaa2d622f0ca57f8b24a51a7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFlow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3e4c7e285fd08438ba5d265d9daeb094</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkBarrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a7d893a9a4bd20dff09b5d09d05bb7f26</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Circulation::SetStandardElevator</name>
    <filename>a00385.html</filename>
    <templarg></templarg>
    <base>Circulation&lt; Digraph, LowerMap, UpperMap, SupplyMap, SetStandardElevatorTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetStandardElevatorTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::LowerMap</type>
      <name>LowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abe92e2b425d46397f1add6fdd6db6b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::UpperMap</type>
      <name>UpperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a83be4d86b37c7a43dab64a4b1b5ccb79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::SupplyMap</type>
      <name>SupplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a040d59dc3d4879cc8f00ac310308772c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a078a395cce67cc7938d85be25aa74718</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a766fcc516e43681f77caad90d5e73913</anchor>
      <arglist>(const Digraph &amp;graph, const LowerMap &amp;lower, const UpperMap &amp;upper, const SupplyMap &amp;supply)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Circulation</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a602bddf53e2f8737ac8333233ee6e96d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ab6c73f90f08dc7da19a258c7e05674a5</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a453a1901f76865172e8f1a677d6fece8</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aab294b65a3aa5747c71fd9ead4a71b50</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3dc1b264f452142f2dc77157b86f5155</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>abc8e9abf45d71ce9d03f3a559e8edf8e</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Circulation &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a19773192cea016ada50d3b9470bf36cd</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>barrierMap</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a1b82e7270d6c6742dda23353878ed33a</anchor>
      <arglist>(BarrierMap &amp;bar) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>greedyInit</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a275cfb5a0d9eeb69e56ec2366e0a4f81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>aad5997aaaa2d622f0ca57f8b24a51a7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFlow</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a3e4c7e285fd08438ba5d265d9daeb094</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkBarrier</name>
      <anchorfile>a00078.html</anchorfile>
      <anchor>a7d893a9a4bd20dff09b5d09d05bb7f26</anchor>
      <arglist>() const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ClpLp</name>
    <filename>a00087.html</filename>
    <base>lemon::LpSolver</base>
    <member kind="function">
      <type></type>
      <name>ClpLp</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>af9667a2a88853c4be96b0c2e19416ad2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ClpLp</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>a89f91b42af43524791c4c73c6f377a79</anchor>
      <arglist>(const ClpLp &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ClpLp</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>aa8060bf28e96f9deb5a0da4d7105230f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ClpLp *</type>
      <name>newSolver</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>a0d71f4262cbd2c662935050a0bd3630e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ClpLp *</type>
      <name>cloneSolver</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>a8a2291ac904191f07080b67c59126fcd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solvePrimal</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>a0c104ef72fd5fc98036e0a83305bdcb1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solveDual</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>af9e12f11f876ed7feccba1fbd68a0f5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solveBarrier</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>a86f7f5085ed05208610310476906a675</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>clpRow</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>aeb1bfd5600af88c2b22d40800887db78</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>clpCol</name>
      <anchorfile>a00087.html</anchorfile>
      <anchor>afad7dd3a127354e229ad38226081453f</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solve</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a1963be740c5f32bb76dfc9df4c2de376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>primalType</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a2b4368f93440f5b674a509841415e554</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>dualType</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a8da27523270c3cab58202dde93e4f7b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>primal</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a37740a7c4bc53157fe6a1135f30ac24f</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>primal</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a6c2cdad752fe07e91e06b7a421befe58</anchor>
      <arglist>(const Expr &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>primalRay</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a900d1bf30c187c50d4e1a982c41505db</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dual</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a22e9480f94d2224f1a0080e227028e9d</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dual</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>aa65b30070f24573eb53f13dd7b7b8cb4</anchor>
      <arglist>(const DualExpr &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dualRay</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>ae8c931c73226d2f3cb5afb18d3b9550b</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>VarStatus</type>
      <name>colStatus</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a773b4758545a7cae47ac1c5ab51fa5ff</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>VarStatus</type>
      <name>rowStatus</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a1f4b3adb0e49c66d163d92b010d3b29c</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>primal</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a3a2e2a739c1350d23ca0b7edb2cad814</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNDEFINED</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea605159e8a4c32319fd69b5d151369d93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INFEASIBLE</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2884fa43446c0cbc9c7a9b74d41d7483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FEASIBLE</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea03f919221217f95d21a593a7120165e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNBOUNDED</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea6c65123d1b5b01632a477661055b01ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>VarStatus</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BASIC</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5a13c45196813cb44e6e81e9c48a5ec1b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FREE</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5acc62d1576546f3245237e1b232d838b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>LOWER</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5aa1017e9b343135a54a98b6f479354d16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UPPER</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5ae704d5d328a8522a6193aa3efb28c724</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FIXED</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a86b9012e22aaac73c64bb7247dcb44c5a9b5eccb7f8f027c46f2018d07c74f384</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Color</name>
    <filename>a00093.html</filename>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>a1589b83974b42a2f3315624f14c3c92c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>ac975f1207e7e7caacde357dfea1369c8</anchor>
      <arglist>(double r, double g, double b)</arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>red</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>a76ca6d975a3988ef9d12b7ea867b38ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>red</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>ade4017c9b1d7602d5c2f1b91f5a9cee1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>green</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>a53e0b92699d4680948e29928fa663897</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>green</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>a2f5e018d8875fac006cc540edcf76147</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>blue</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>a22038a8dc2199101ab5d3826e23a747b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>blue</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>acdff982f34c853ff22e638429a003ac4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00093.html</anchorfile>
      <anchor>aad8a1573c2ef17613aef9a536ba7f51d</anchor>
      <arglist>(double r, double g, double b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Palette</name>
    <filename>a00301.html</filename>
    <base>MapBase&lt; int, Color &gt;</base>
    <member kind="function">
      <type></type>
      <name>Palette</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>a0e6feeba9d414592568f3e816b62f280</anchor>
      <arglist>(bool have_white=false, int num=-1)</arglist>
    </member>
    <member kind="function">
      <type>Color &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>adabf831f19d4e9576fb5484afc4a2b4d</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const Color &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>a7b375006c489605f87c6dc997fb59006</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>ad4e5772fa6874dde74565b5f84a07e98</anchor>
      <arglist>(int i, const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>a77e076addeb00430edb72da3f9b134b0</anchor>
      <arglist>(const Color &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>a4deacfe482590ac13be466b2ff5f347d</anchor>
      <arglist>(int s)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00301.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>Key</name>
      <anchorfile>a00250.html</anchorfile>
      <anchor>a2cfe904ef7579cf511b9fcb14420539b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Color</type>
      <name>Value</name>
      <anchorfile>a00250.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Invalid</name>
    <filename>a00217.html</filename>
  </compound>
  <compound kind="class">
    <name>lemon::DigraphCopy</name>
    <filename>a00130.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DigraphCopy</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a446ab15561f3b8ed021eb010e9e53ef6</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DigraphCopy</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>afb01541dd7332dde976064680adb7d27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>nodeRef</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>ac310fd2b496f0a0dff30fc7433bbeecf</anchor>
      <arglist>(NodeRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>nodeCrossRef</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a180cf189d2c60ee602bc5e78b4ff5a7f</anchor>
      <arglist>(NodeCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a814bb136928b01aa717e3b87eca3336d</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>node</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>af0223e0ec4c277528508092be91e6a17</anchor>
      <arglist>(const Node &amp;node, TNode &amp;tnode)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>arcRef</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a93c7d718dccd021f664d08facec74d3c</anchor>
      <arglist>(ArcRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>arcCrossRef</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a03c799c69b86387ccc5e358ad8964b48</anchor>
      <arglist>(ArcCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>acc7f8abcb20c6997c9ac8ee22ded8d9a</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>DigraphCopy &amp;</type>
      <name>arc</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a7ad45d42947a22cc7c47b2c530a6f654</anchor>
      <arglist>(const Arc &amp;arc, TArc &amp;tarc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00130.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GraphCopy</name>
    <filename>a00184.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>GraphCopy</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a2279b087a65e31ed8414893fc247dd29</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GraphCopy</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a10f931e6776ec70ec988c4fc02bef370</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>nodeRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>abe33ade893c171fbca1e42250040a846</anchor>
      <arglist>(NodeRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>nodeCrossRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a4f1a6179bd93461b05a763353d5cc713</anchor>
      <arglist>(NodeCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>aa8a325d792933931a2420ffe82f1611f</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>node</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>ab9178da29ca4df86abb9c729c6f3e354</anchor>
      <arglist>(const Node &amp;node, TNode &amp;tnode)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>arcRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>ae9754377f4dc67779a30055ad6745885</anchor>
      <arglist>(ArcRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>arcCrossRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>af789998bb2f9adfeaef7cfd040e991ca</anchor>
      <arglist>(ArcCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>afeafda374d4cad185755811326398576</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>arc</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a1a0c870e83efb89541ab51bf35944366</anchor>
      <arglist>(const Arc &amp;arc, TArc &amp;tarc)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>edgeRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>af91de782b50a44a7da07984c5f1d1c8e</anchor>
      <arglist>(EdgeRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>edgeCrossRef</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a49664d231463c080f54ebd3299cd1121</anchor>
      <arglist>(EdgeCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a38765d68158b090273579d5296ab8d36</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>GraphCopy &amp;</type>
      <name>edge</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>afe6d74446b39b082adc66f14fc01f206</anchor>
      <arglist>(const Edge &amp;edge, TEdge &amp;tedge)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00184.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BpGraphCopy</name>
    <filename>a00070.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>BpGraphCopy</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a7675a18a618014ce6cb91608d11683fe</anchor>
      <arglist>(const From &amp;from, To &amp;to)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BpGraphCopy</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a6f8569d75a8424a693de845d3080e9d8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>nodeRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a7ecff9dfd8669be40c75a41cc6c80570</anchor>
      <arglist>(NodeRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>nodeCrossRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a999f8a95ae35248b363b01757362fcf4</anchor>
      <arglist>(NodeCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a5efb7c48b3833d0efb216e54a32f39ff</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>node</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>ab3a53fd9387c2c31a9f139f9f3256129</anchor>
      <arglist>(const Node &amp;node, TNode &amp;tnode)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>redRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a866d638c91fd9c9d018d43ebba0257f9</anchor>
      <arglist>(RedRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>redCrossRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a04550c1a75c356b1f6ad93486653e3d9</anchor>
      <arglist>(RedCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>redNodeMap</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a0e45d838c7d1c738a4bb63df2d1661d3</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>redNode</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>ae762129614413707cad02394e7135ee0</anchor>
      <arglist>(const RedNode &amp;node, TRedNode &amp;tnode)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>blueRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a4eaa3d83b9a16d10f10e3a812e23d057</anchor>
      <arglist>(BlueRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>blueCrossRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>aae6354e981510f6fcebc27693830734f</anchor>
      <arglist>(BlueCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>blueNodeMap</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a7f9d56093e143814538d08a5eefe0900</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>blueNode</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>afacb9248edf9673e5c76cbdcb210c0d7</anchor>
      <arglist>(const BlueNode &amp;node, TBlueNode &amp;tnode)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>arcRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>af4d2fe50579a6d2e06601ff85960fa3c</anchor>
      <arglist>(ArcRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>arcCrossRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a25eb431949624e5115826edae4757819</anchor>
      <arglist>(ArcCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a74217feaad78666e113e655a4037ca92</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>arc</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a7343db8a681e962b2f56bda50b005b96</anchor>
      <arglist>(const Arc &amp;arc, TArc &amp;tarc)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>edgeRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a6ae05716ebb9f5c1a53368fa4c4b36e0</anchor>
      <arglist>(EdgeRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>edgeCrossRef</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a1d4266a66ef0487573930f7b60cdac05</anchor>
      <arglist>(EdgeCrossRef &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a804762c1421896cd29ebb2122ad3b898</anchor>
      <arglist>(const FromMap &amp;map, ToMap &amp;tmap)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphCopy &amp;</type>
      <name>edge</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>af3798e2763cb2c7fdd624cc2fba587e6</anchor>
      <arglist>(const Edge &amp;edge, TEdge &amp;tedge)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00070.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ConArcIt</name>
    <filename>a00099.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>ConArcIt</name>
      <anchorfile>a00099.html</anchorfile>
      <anchor>a77d03dd52dcaad7b393c1efbbab63602</anchor>
      <arglist>(const GR &amp;g, Node u, Node v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConArcIt</name>
      <anchorfile>a00099.html</anchorfile>
      <anchor>a0a41f45a3e529803047fbd033522a2aa</anchor>
      <arglist>(const GR &amp;g, Arc a)</arglist>
    </member>
    <member kind="function">
      <type>ConArcIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00099.html</anchorfile>
      <anchor>acd427be549d9ab071d71eed9cd02d6ec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ConEdgeIt</name>
    <filename>a00100.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>ConEdgeIt</name>
      <anchorfile>a00100.html</anchorfile>
      <anchor>a09282f7895a4ec3cd5211ece130c8762</anchor>
      <arglist>(const GR &amp;g, Node u, Node v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConEdgeIt</name>
      <anchorfile>a00100.html</anchorfile>
      <anchor>a66878cccb947904847f417dfdc9de3f5</anchor>
      <arglist>(const GR &amp;g, Edge e)</arglist>
    </member>
    <member kind="function">
      <type>ConEdgeIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00100.html</anchorfile>
      <anchor>adb97684eca2bef5f92d3bb6e3f3b083e</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DynArcLookUp</name>
    <filename>a00143.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00143.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DynArcLookUp</name>
      <anchorfile>a00143.html</anchorfile>
      <anchor>af350d80d0f535f2e22d2759b520b44b7</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>operator()</name>
      <anchorfile>a00143.html</anchorfile>
      <anchor>a1305a076cbf538584befb7cd4b2b4e99</anchor>
      <arglist>(Node s, Node t, Arc p=INVALID) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ArcLookUp</name>
    <filename>a00034.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00034.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArcLookUp</name>
      <anchorfile>a00034.html</anchorfile>
      <anchor>ac8d5a1b8fa9f0a94a40144de9083bc80</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>refresh</name>
      <anchorfile>a00034.html</anchorfile>
      <anchor>ad03e249e4f6d22977dfae5910314ee4e</anchor>
      <arglist>(Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>refresh</name>
      <anchorfile>a00034.html</anchorfile>
      <anchor>a5f2e190b8261a98c97c2ea4e86670d54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>operator()</name>
      <anchorfile>a00034.html</anchorfile>
      <anchor>ae268c23cfa76e860ab056c6d5ec5e727</anchor>
      <arglist>(Node s, Node t) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::AllArcLookUp</name>
    <filename>a00017.html</filename>
    <templarg></templarg>
    <base>lemon::ArcLookUp</base>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00017.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AllArcLookUp</name>
      <anchorfile>a00017.html</anchorfile>
      <anchor>ada3bb86d0e7763d7fc69c1d179d1d123</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>refresh</name>
      <anchorfile>a00017.html</anchorfile>
      <anchor>ad03e249e4f6d22977dfae5910314ee4e</anchor>
      <arglist>(Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>refresh</name>
      <anchorfile>a00017.html</anchorfile>
      <anchor>a5f2e190b8261a98c97c2ea4e86670d54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>operator()</name>
      <anchorfile>a00017.html</anchorfile>
      <anchor>a48edf5eb52c96e5692395b9239d1e29e</anchor>
      <arglist>(Node s, Node t, Arc prev=INVALID) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::CostScalingDefaultTraits</name>
    <filename>a00110.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00110.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>V</type>
      <name>Value</name>
      <anchorfile>a00110.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>C</type>
      <name>Cost</name>
      <anchorfile>a00110.html</anchorfile>
      <anchor>adeb81a88e6bbaf933ca20ea3bbba7a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>LargeCost</name>
      <anchorfile>a00110.html</anchorfile>
      <anchor>abb5b2df15a07785723c3202702c06a65</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CostScaling</name>
    <filename>a00109.html</filename>
    <templarg>GR</templarg>
    <templarg>V</templarg>
    <templarg>C</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::CostScaling::SetLargeCost</class>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INFEASIBLE</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2884fa43446c0cbc9c7a9b74d41d7483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNBOUNDED</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea6c65123d1b5b01632a477661055b01ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Method</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PUSH</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0fad263caec619c4d99e4684ba0fabd9493</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>AUGMENT</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0facd2e1aa2398886ced14024f626167b10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PARTIAL_AUGMENT</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0fad4476e3f57a85ac799fa83de6730c665</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Value</type>
      <name>Value</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Cost</type>
      <name>Cost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CostScaling</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aef36da2d5f6a91d3c945078c91a00f29</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a73716786403308acf826049db4fcae5a</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2ba20715de6a3fe3a93086f59bd41b1f</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>costMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a3289d8da25c7c41bf2019e219a207c57</anchor>
      <arglist>(const CostMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aaed44b74b82792e31be304ec0b84dfad</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>stSupply</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a606e5cc8a41acd2f6f0998c096e79a0d</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, Value k)</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>run</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a1f864136a21e6ad70a82f14d6560ee7e</anchor>
      <arglist>(Method method=PARTIAL_AUGMENT, int factor=16)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>resetParams</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a3da4b33bee24846e97c4fad32696d7b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>reset</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aec24c3696fc3c1818effd0523dffa452</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Number</type>
      <name>totalCost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4e1efd04a6b234645d1ca18d2635d57e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a7fc53c0667fdfb95dadd6a302f045941</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flowMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ac7fb0010590a95a23fda72ce45474a2a</anchor>
      <arglist>(FlowMap &amp;map) const </arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>potential</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ac97efaa2b500bb002f116bf4ba7c9b0b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>potentialMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>afeeff1d0249ffae4db8cc516b77d2cc9</anchor>
      <arglist>(PotentialMap &amp;map) const </arglist>
    </member>
    <member kind="variable">
      <type>const Value</type>
      <name>INF</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a601ffd79f13610daacadd46f973507c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="private">
      <type>void</type>
      <name>startAugment</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a5f0ba940293922c1175f599af9b5490e</anchor>
      <arglist>(int max_length)</arglist>
    </member>
    <member kind="function" protection="private">
      <type>void</type>
      <name>startPush</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a0d8a4c20a6226e471b185f33b68eadb1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::CostScaling::SetLargeCost</name>
    <filename>a00361.html</filename>
    <templarg></templarg>
    <base>CostScaling&lt; GR, V, C, SetLargeCostTraits&lt; T &gt; &gt;</base>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Method</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CostScaling</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aef36da2d5f6a91d3c945078c91a00f29</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a73716786403308acf826049db4fcae5a</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a2ba20715de6a3fe3a93086f59bd41b1f</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>costMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a3289d8da25c7c41bf2019e219a207c57</anchor>
      <arglist>(const CostMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aaed44b74b82792e31be304ec0b84dfad</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>stSupply</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a606e5cc8a41acd2f6f0998c096e79a0d</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, Value k)</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>run</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a1f864136a21e6ad70a82f14d6560ee7e</anchor>
      <arglist>(Method method=PARTIAL_AUGMENT, int factor=16)</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>resetParams</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a3da4b33bee24846e97c4fad32696d7b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CostScaling &amp;</type>
      <name>reset</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>aec24c3696fc3c1818effd0523dffa452</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Number</type>
      <name>totalCost</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a4e1efd04a6b234645d1ca18d2635d57e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a7fc53c0667fdfb95dadd6a302f045941</anchor>
      <arglist>(const Arc &amp;a) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flowMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ac7fb0010590a95a23fda72ce45474a2a</anchor>
      <arglist>(FlowMap &amp;map) const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>potential</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>ac97efaa2b500bb002f116bf4ba7c9b0b</anchor>
      <arglist>(const Node &amp;n) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>potentialMap</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>afeeff1d0249ffae4db8cc516b77d2cc9</anchor>
      <arglist>(PotentialMap &amp;map) const</arglist>
    </member>
    <member kind="variable">
      <type>const Value</type>
      <name>INF</name>
      <anchorfile>a00109.html</anchorfile>
      <anchor>a601ffd79f13610daacadd46f973507c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Counter</name>
    <filename>a00111.html</filename>
    <member kind="typedef">
      <type>_SubCounter&lt; Counter &gt;</type>
      <name>SubCounter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a85506a22a53d73d9d211f6a97912b6f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_NoSubCounter&lt; Counter &gt;</type>
      <name>NoSubCounter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a1a0261ef4a0c51f79191ad4597e2cd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Counter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ae1666ee5f8d8cf588500c65a9935c4fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Counter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a837a4f6c542af203bc3b5d49d0288220</anchor>
      <arglist>(std::string title, std::ostream &amp;os=std::cerr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Counter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ab3194596a4d3b2fa5630e036feff4897</anchor>
      <arglist>(const char *title, std::ostream &amp;os=std::cerr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Counter</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ad5261fa114af1e8c70c21862d857eaec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Counter &amp;</type>
      <name>operator++</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ab1598a2acb1c3be3b168855648235e73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator++</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a5526c2c4b0fa541a50ffcaaf25e149a6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>Counter &amp;</type>
      <name>operator--</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ae495b9da2d2ad8a4b3b6c6479a5a61b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator--</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a5496187b3dcf6064c5c0b158ab6b7264</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>Counter &amp;</type>
      <name>operator+=</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>af8fc68a7c8df80c8abec43da22138159</anchor>
      <arglist>(int c)</arglist>
    </member>
    <member kind="function">
      <type>Counter &amp;</type>
      <name>operator-=</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>ac48a256851ae1729e19b1b3c409fc9ce</anchor>
      <arglist>(int c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a2cd75ed371f4cdabb3cff3d4b77bee84</anchor>
      <arglist>(int c=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator int</name>
      <anchorfile>a00111.html</anchorfile>
      <anchor>a4f4ea421e40bda08a2deca657f640fea</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::NoCounter</name>
    <filename>a00277.html</filename>
  </compound>
  <compound kind="class">
    <name>lemon::CplexEnv</name>
    <filename>a00113.html</filename>
    <class kind="class">lemon::CplexEnv::LicenseError</class>
    <member kind="function">
      <type></type>
      <name>CplexEnv</name>
      <anchorfile>a00113.html</anchorfile>
      <anchor>a02bd581bb5b04ed7f68844e497d8c5f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CplexEnv</name>
      <anchorfile>a00113.html</anchorfile>
      <anchor>a55676c8bcdd5d6168efe436cc8cdc47e</anchor>
      <arglist>(const CplexEnv &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CplexEnv &amp;</type>
      <name>operator=</name>
      <anchorfile>a00113.html</anchorfile>
      <anchor>a7523f60d35e342e9a1f70daf83e0ac5c</anchor>
      <arglist>(const CplexEnv &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CplexEnv</name>
      <anchorfile>a00113.html</anchorfile>
      <anchor>a3c964016341dd3a4fce8ed1e22f84b4c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CplexEnv::LicenseError</name>
    <filename>a00238.html</filename>
    <base>lemon::Exception</base>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>a00238.html</anchorfile>
      <anchor>aff06f49065b54a8a86e02e9a2441a8ba</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CplexBase</name>
    <filename>a00112.html</filename>
    <base virtualness="virtual">lemon::LpBase</base>
    <member kind="function">
      <type>const CplexEnv &amp;</type>
      <name>env</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>a1df4c6fdcec9714c3fe0984374a1e879</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const cpxenv *</type>
      <name>cplexEnv</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>ac9821c402b14564694c84aad34d68201</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>cpxenv *</type>
      <name>cplexEnv</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>a6898c265c956dea4cd1c62850b4940da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>cpxlp *</type>
      <name>cplexLp</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>ae1d851f69016621c992d1f01c98b9a4a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cpxlp *</type>
      <name>cplexLp</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>a2abeeaa0d636b4705c3487301115f3ef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write</name>
      <anchorfile>a00112.html</anchorfile>
      <anchor>a6f987737d989d046dd4c24150442ff14</anchor>
      <arglist>(std::string file, std::string format=&quot;MPS&quot;) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CplexLp</name>
    <filename>a00114.html</filename>
    <base>lemon::LpSolver</base>
    <base>lemon::CplexBase</base>
    <member kind="function">
      <type></type>
      <name>CplexLp</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>af8d078878fc450c02ac2149b2a0f13f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CplexLp</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>afedf81e8d97a554db5a53f0a3eef3f17</anchor>
      <arglist>(const CplexEnv &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CplexLp</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a69ef0bf0bdc30a3e48cc64a05e13d08a</anchor>
      <arglist>(const CplexLp &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CplexLp</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a5dbdb17742d0a0ffe65d037888f8f684</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CplexLp *</type>
      <name>cloneSolver</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>ab902f14b7d737a92da179b33897a09ed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CplexLp *</type>
      <name>newSolver</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a35f7af63f61c52bb55dfc690e436f99c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solvePrimal</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a3316441c156eb3cc78bcb835f3e86c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solveDual</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a76f2afae9c0dcb0df8d677346129bdfd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solveBarrier</name>
      <anchorfile>a00114.html</anchorfile>
      <anchor>a1e69e9be293c6f7a5433e93d70065a89</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CplexMip</name>
    <filename>a00115.html</filename>
    <base>lemon::MipSolver</base>
    <base>lemon::CplexBase</base>
    <member kind="function">
      <type></type>
      <name>CplexMip</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>a6e68387a4541321452be5b423f00cf4f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CplexMip</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>ac5a31290f5306ad26aaabc99ca88e254</anchor>
      <arglist>(const CplexEnv &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CplexMip</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>aeb31411f879211d796d5d9dc8a5d8f26</anchor>
      <arglist>(const CplexMip &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CplexMip</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>a766aee9d3de7a22a549dd43b4b974224</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CplexMip *</type>
      <name>cloneSolver</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>aa0e206ab36331bf7d30c3f2907f70b51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual CplexMip *</type>
      <name>newSolver</name>
      <anchorfile>a00115.html</anchorfile>
      <anchor>a747a58e5bf7f1b282ec7cd8f372d4a38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::CycleCanceling</name>
    <filename>a00117.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>ProblemType</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INFEASIBLE</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2884fa43446c0cbc9c7a9b74d41d7483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNBOUNDED</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a4c669cb1cb4d98dfea944e9ceec7d33ea6c65123d1b5b01632a477661055b01ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Method</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIMPLE_CYCLE_CANCELING</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0fa0ebf9c5c0bd3e01f5a9060478d2a7baa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MINIMUM_MEAN_CYCLE_CANCELING</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0fad8e15d52edef3c0ff3d27acefd621818</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CANCEL_AND_TIGHTEN</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a2a3c0067e44c5ef3210a256d06c16b0fae5674d98ba6203a143cc02984415c242</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>V</type>
      <name>Value</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>C</type>
      <name>Cost</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>adeb81a88e6bbaf933ca20ea3bbba7a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CycleCanceling</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a9781d9ac0d763defc63815da06b4b2b2</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>lowerMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a980391a01f804f1cd14ac58f365a07af</anchor>
      <arglist>(const LowerMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>upperMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a0ab69fe04cb7b7ad1bd77acec2c94d46</anchor>
      <arglist>(const UpperMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>costMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>ac890c26d5ecc26854000d2c1e61b8f9b</anchor>
      <arglist>(const CostMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>supplyMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a29931e78b92a8e36cf376da50c3d8abb</anchor>
      <arglist>(const SupplyMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>stSupply</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>ad267c7b64da13dfafef5efb8cf9e1671</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, Value k)</arglist>
    </member>
    <member kind="function">
      <type>ProblemType</type>
      <name>run</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>ad63980373b4e743a2827d0a6a0316205</anchor>
      <arglist>(Method method=CANCEL_AND_TIGHTEN)</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>resetParams</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a1b5551dde2821381f3828bfd342cede8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CycleCanceling &amp;</type>
      <name>reset</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a9a9b71f0934567a8887a6e8c213e759b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Number</type>
      <name>totalCost</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a4e1efd04a6b234645d1ca18d2635d57e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a7fc53c0667fdfb95dadd6a302f045941</anchor>
      <arglist>(const Arc &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flowMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>ac7fb0010590a95a23fda72ce45474a2a</anchor>
      <arglist>(FlowMap &amp;map) const </arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>potential</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>ac97efaa2b500bb002f116bf4ba7c9b0b</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>potentialMap</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>afeeff1d0249ffae4db8cc516b77d2cc9</anchor>
      <arglist>(PotentialMap &amp;map) const </arglist>
    </member>
    <member kind="variable">
      <type>const Value</type>
      <name>INF</name>
      <anchorfile>a00117.html</anchorfile>
      <anchor>a601ffd79f13610daacadd46f973507c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DfsDefaultTraits</name>
    <filename>a00120.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>ae1b02f76f4c6728d9c92da415fe15f7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>a1c6c24dc0cfde917210decb6f31be54c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00120.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Dfs</name>
    <filename>a00119.html</filename>
    <templarg>GR</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::Dfs::SetDistMap</class>
    <class kind="struct">lemon::Dfs::SetPredMap</class>
    <class kind="struct">lemon::Dfs::SetProcessedMap</class>
    <class kind="struct">lemon::Dfs::SetReachedMap</class>
    <class kind="struct">lemon::Dfs::SetStandardProcessedMap</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dfs::SetDistMap</name>
    <filename>a00347.html</filename>
    <templarg></templarg>
    <base>Dfs&lt; Digraph, SetDistMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dfs::SetPredMap</name>
    <filename>a00373.html</filename>
    <templarg></templarg>
    <base>Dfs&lt; Digraph, SetPredMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dfs::SetProcessedMap</name>
    <filename>a00379.html</filename>
    <templarg></templarg>
    <base>Dfs&lt; Digraph, SetProcessedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dfs::SetReachedMap</name>
    <filename>a00382.html</filename>
    <templarg></templarg>
    <base>Dfs&lt; Digraph, SetReachedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dfs::SetStandardProcessedMap</name>
    <filename>a00392.html</filename>
    <base>Dfs&lt; Digraph, SetStandardProcessedMapTraits &gt;</base>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af23453a839e62b3dcc311e0a839e31ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits</type>
      <name>Traits</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77e8d05a88fdbd6eadbc7b562e642c22</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dfs</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0853bb5f644e1434ff68eac70b1dd63c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a0ed6678f822688fc2d17e625400819b0</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a48fac08b556d545572afe15b39af820c</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a3e278058f34be77a47e2a7ba4f9c12dc</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dfs &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a67d147d1e125d3a56e49ddd920c1bc98</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dist</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a2e23ddd204b1b00807853d2620a3c1b1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OutArcIt</type>
      <name>nextArc</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a4136c3eb28cb12e937c165cb8bb5bf3c</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>aee7c286bcbfe5a9ed8c5c2a6eb73673a</anchor>
      <arglist>(const ArcBoolMap &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00119.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DfsWizardDefaultTraits</name>
    <filename>a00126.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>ae1b02f76f4c6728d9c92da415fe15f7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>a1c6c24dc0cfde917210decb6f31be54c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00126.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DfsWizardBase</name>
    <filename>a00125.html</filename>
    <templarg></templarg>
    <base>lemon::DfsWizardDefaultTraits</base>
    <member kind="function">
      <type></type>
      <name>DfsWizardBase</name>
      <anchorfile>a00125.html</anchorfile>
      <anchor>ac6751e3747d9999ff22806a701b0f48b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DfsWizardBase</name>
      <anchorfile>a00125.html</anchorfile>
      <anchor>ab58600d263349752f489d95593ca3bc4</anchor>
      <arglist>(const GR &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DfsWizard</name>
    <filename>a00124.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DfsWizard</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a8496841a286bdc5e6b7804a1c8b7bed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DfsWizard</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>af2e4b792dede58b8d7f827878dee9a10</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DfsWizard</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a2bf35f5b0270f76877c701f3b87a4fba</anchor>
      <arglist>(const TR &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; SetPredMapBase&lt; T &gt; &gt;</type>
      <name>predMap</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a2a45596a8e8a9b1f621e94a2de460b6c</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; SetReachedMapBase&lt; T &gt; &gt;</type>
      <name>reachedMap</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>ada4bf9b21f16cd70b9416ddacda0925a</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; SetDistMapBase&lt; T &gt; &gt;</type>
      <name>distMap</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a51afc7f3283f1fd014ddbc97ab878ea4</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; SetProcessedMapBase&lt; T &gt; &gt;</type>
      <name>processedMap</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a83e5765bb819f3070d1d5f84844ef775</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard&lt; SetPathBase&lt; T &gt; &gt;</type>
      <name>path</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>a1be4db5f62b3025c31c981faf74bc3bc</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DfsWizard</type>
      <name>dist</name>
      <anchorfile>a00124.html</anchorfile>
      <anchor>aef118068d087c63cd0111751ccffa56e</anchor>
      <arglist>(const int &amp;d)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DfsVisitor</name>
    <filename>a00123.html</filename>
    <templarg>GR</templarg>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>af763d0c0856194421ebd6ccc73b921c3</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>a61325cf6c47c78fe2f978694f9e7bda6</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reach</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>a4f6dc7007e25f1c20b4fbb8912a83817</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>discover</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>abe70d6cbc4419667e6aa533fc0fa262f</anchor>
      <arglist>(const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>examine</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>a3656d1f80036aee1dcaa927450b70c2a</anchor>
      <arglist>(const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>leave</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>a37622f5403978798170fd218cdb55647</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>backtrack</name>
      <anchorfile>a00123.html</anchorfile>
      <anchor>a05430d1c630288c497a019594350e94e</anchor>
      <arglist>(const Arc &amp;arc)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DfsVisitDefaultTraits</name>
    <filename>a00122.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00122.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; bool &gt;</type>
      <name>ReachedMap</name>
      <anchorfile>a00122.html</anchorfile>
      <anchor>affb032b5578e24579000f9899512ae60</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ReachedMap *</type>
      <name>createReachedMap</name>
      <anchorfile>a00122.html</anchorfile>
      <anchor>a1491e8ada6a6d5fdd321e3fee43844e1</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DfsVisit</name>
    <filename>a00121.html</filename>
    <templarg>GR</templarg>
    <templarg>VS</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::DfsVisit::SetReachedMap</class>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VS</type>
      <name>Visitor</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a3bece3b7c0b0189b735a408e533f3d73</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a90221be1b9274785db2188548354d2aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DfsVisit</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab2606d461569b07df9a904f66aadfa82</anchor>
      <arglist>(const Digraph &amp;digraph, Visitor &amp;visitor)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DfsVisit</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a1b3719df6ef9a6c93579c6b48309fb9a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DfsVisit &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a534f6847b03afac5b47af994d4f6666b</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>nextArc</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a22c9301865dd8c7dffe8e48cae77823f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a0306ffe17dfaf127245ad33dbd9c7c63</anchor>
      <arglist>(const AM &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DfsVisit::SetReachedMap</name>
    <filename>a00383.html</filename>
    <templarg></templarg>
    <base>DfsVisit&lt; Digraph, Visitor, SetReachedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetReachedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Visitor</type>
      <name>Visitor</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a3bece3b7c0b0189b735a408e533f3d73</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::ReachedMap</type>
      <name>ReachedMap</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a90221be1b9274785db2188548354d2aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DfsVisit</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab2606d461569b07df9a904f66aadfa82</anchor>
      <arglist>(const Digraph &amp;digraph, Visitor &amp;visitor)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DfsVisit</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a1b3719df6ef9a6c93579c6b48309fb9a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DfsVisit &amp;</type>
      <name>reachedMap</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a534f6847b03afac5b47af994d4f6666b</anchor>
      <arglist>(ReachedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ac785b6504b67a963b4c20bae90441a77</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>processNextArc</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a773a0c2fc82672c4dd7af546908b8a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>nextArc</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a22c9301865dd8c7dffe8e48cae77823f</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>start</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a0306ffe17dfaf127245ad33dbd9c7c63</anchor>
      <arglist>(const AM &amp;am)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00121.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DHeap</name>
    <filename>a00127.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>D</templarg>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PR</type>
      <name>Prio</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a644810a55913c9e8b24511758574d6d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; Item, Prio &gt;</type>
      <name>Pair</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a616fe456bc4c8eddf813c4f5665e1180</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CMP</type>
      <name>Compare</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a937d59343e7b08b620805162c2e52ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DHeap</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>abbb33a0ea233dc441aedd789fb1efd6e</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DHeap</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a6618ea81351d87286749d5c00ecba04a</anchor>
      <arglist>(ItemIntMap &amp;map, const Compare &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5b654214309b6f25fceeec04e2b1a016</anchor>
      <arglist>(const Pair &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>ad34f576dafc84f8969e2fecd67cd3a15</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a5fe7eab02681c7735ba173c879de1681</anchor>
      <arglist>(const Item &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>operator[]</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a74ccb13d905bf8b608f3426131977cc0</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a35c06441ccfac0ed04762113a102e6b3</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decrease</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a301fdc87288afdebf379ae043cf66cd4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increase</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a958836bae38b188956bcf1345c63eac4</anchor>
      <arglist>(const Item &amp;i, const Prio &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a613888b340ee362e2f4da6f2e2b97428</anchor>
      <arglist>(const Item &amp;i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>state</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>a7d0ca230d438efaad53833701d9cb262</anchor>
      <arglist>(const Item &amp;i, State st)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a00127.html</anchorfile>
      <anchor>aa3d169f66b376619ebb1825f6c027482</anchor>
      <arglist>(const Item &amp;i, const Item &amp;j)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DijkstraDefaultOperationTraits</name>
    <filename>a00134.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>V</type>
      <name>Value</name>
      <anchorfile>a00134.html</anchorfile>
      <anchor>a6c1768456283cc436140a9ffae849dd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Value</type>
      <name>zero</name>
      <anchorfile>a00134.html</anchorfile>
      <anchor>af24efe5c6b0edcb586538222fb5b1024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Value</type>
      <name>plus</name>
      <anchorfile>a00134.html</anchorfile>
      <anchor>acce469a9728bdb4c09c015dc31a3eb3c</anchor>
      <arglist>(const Value &amp;left, const Value &amp;right)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>less</name>
      <anchorfile>a00134.html</anchorfile>
      <anchor>ac142bbf30883f244af50aefbf661bd6a</anchor>
      <arglist>(const Value &amp;left, const Value &amp;right)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DijkstraDefaultTraits</name>
    <filename>a00135.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN</type>
      <name>LengthMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a7398ca1da160bb30ee090866bbfc12ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN::Value</type>
      <name>Value</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>ac2ac7ac2928b4cfeafdc493dd44f61c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>DijkstraDefaultOperationTraits&lt; Value &gt;</type>
      <name>OperationTraits</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a44e2d7b3991904d43e2dc64bc7b3994b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>abe21d3edcb6bd235d862becfd84c6d92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BinHeap&lt; typename LEN::Value, HeapCrossRef, std::less&lt; Value &gt; &gt;</type>
      <name>Heap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>ae9674759c9994950c85735775791c79d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename LEN::Value &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a9735fe3ebb1835f94ac433863be10527</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static HeapCrossRef *</type>
      <name>createHeapCrossRef</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>ae1638f8612c39f3d981d57056aca2c37</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Heap *</type>
      <name>createHeap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a01816b6b724aa6d7f99d7ac19d549125</anchor>
      <arglist>(HeapCrossRef &amp;r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00135.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Dijkstra</name>
    <filename>a00133.html</filename>
    <templarg>GR</templarg>
    <templarg>LEN</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::Dijkstra::SetDistMap</class>
    <class kind="struct">lemon::Dijkstra::SetHeap</class>
    <class kind="struct">lemon::Dijkstra::SetOperationTraits</class>
    <class kind="struct">lemon::Dijkstra::SetPredMap</class>
    <class kind="struct">lemon::Dijkstra::SetProcessedMap</class>
    <class kind="struct">lemon::Dijkstra::SetStandardHeap</class>
    <class kind="struct">lemon::Dijkstra::SetStandardProcessedMap</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetDistMap</name>
    <filename>a00345.html</filename>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetDistMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetDistMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetHeap</name>
    <filename>a00356.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetHeapTraits&lt; H, CR &gt; &gt;</base>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetHeapTraits&lt; H, CR &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetOperationTraits</name>
    <filename>a00365.html</filename>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetOperationTraitsTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetOperationTraitsTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetPredMap</name>
    <filename>a00372.html</filename>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetPredMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPredMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetProcessedMap</name>
    <filename>a00378.html</filename>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetProcessedMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetProcessedMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetStandardHeap</name>
    <filename>a00388.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Dijkstra&lt; Digraph, LengthMap, SetStandardHeapTraits&lt; H, CR &gt; &gt;</base>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardHeapTraits&lt; H, CR &gt;</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::Dijkstra::SetStandardProcessedMap</name>
    <filename>a00391.html</filename>
    <base>Dijkstra&lt; Digraph, LengthMap, SetStandardProcessedMapTraits &gt;</base>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::Value</type>
      <name>Value</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aa2042899ede28a8f6f0fdceb92a7d3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::LengthMap</type>
      <name>LengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ac1094a242a4e9be216f0623b0a7381c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::PredMap</type>
      <name>PredMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adc9638061e7acac70160feb0ea49c29c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::DistMap</type>
      <name>DistMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad6d9c2819f215994ded26fbe42e2fd26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::ProcessedMap</type>
      <name>ProcessedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a43e332c55acc2c5cb99d35ff40accab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PredMapPath&lt; Digraph, PredMap &gt;</type>
      <name>Path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a4d7ae5a0651af9c9cfadd1462718979d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::HeapCrossRef</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a0dc498f33875179555a71ba9441c400a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::Heap</type>
      <name>Heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab1e3f1c47cd4bffb15e3bbc452585f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits::OperationTraits</type>
      <name>OperationTraits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>afda95bfb086e37f03cb0be4ba8725f47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardProcessedMapTraits</type>
      <name>Traits</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a58fc0895a271a1aa712f66aaf3425b12</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dijkstra</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a9f2cad16e6cb57cad22fe766c9e809ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>lengthMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acca1fc5a2484f8284b37ac8b98a6de89</anchor>
      <arglist>(const LengthMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a553990801b3f933961ad14abfee00c0e</anchor>
      <arglist>(PredMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>processedMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6f543d7d3c4b2ab9ecdef5d14f90269d</anchor>
      <arglist>(ProcessedMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a344715cda707dac050bf32c85923f651</anchor>
      <arglist>(DistMap &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Dijkstra &amp;</type>
      <name>heap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a7a0403be9c030237c46a9ab320f5bfbe</anchor>
      <arglist>(Heap &amp;hp, HeapCrossRef &amp;cr)</arglist>
    </member>
    <member kind="function">
      <type>const PredMap &amp;</type>
      <name>predMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aeec5920cc073b88c4c5f6c46a8f4aa4b</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const DistMap &amp;</type>
      <name>distMap</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a77feee7321863f24b67813c0ef8dc5c0</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Path</type>
      <name>path</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a6a33507c667ac2bddd240d0baff1a573</anchor>
      <arglist>(Node t) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a70a41051a602b0a9134d128cf1f409f6</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>predArc</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>af9fdbb84b58bd3f5daedde027070e056</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a89bd1c535e3d4fcb9c58afbb54ac47e1</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reached</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>abb98c427556a2afe917e41fe8d3e75bf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processed</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a376f9f86c0b6bf5fbcf5ee8d76f4cc7a</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>currentDist</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a514b1faa39e460ebc8e00c90d839f3cf</anchor>
      <arglist>(Node v) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSource</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf3cbe74733e4534c1cebb8383974bae</anchor>
      <arglist>(Node s, Value dst=OperationTraits::zero())</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>processNextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>adba758047d7378b8a06320d29ce170d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>aca98e3b1fef1a4508df143a24b73b046</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyQueue</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ab6dcd2be02feaff0a95c21824e805445</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>queueSize</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a942d30059e28f60ba6dd1944ab8e416e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>a8b8de9dfc16e4b3cb6b38733e82f6449</anchor>
      <arglist>(Node t)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>start</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>acf9ccb55c64065301a4e11f13e4d05fb</anchor>
      <arglist>(const NodeBoolMap &amp;nm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00133.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DijkstraWizardDefaultTraits</name>
    <filename>a00138.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN</type>
      <name>LengthMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a7398ca1da160bb30ee090866bbfc12ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LEN::Value</type>
      <name>Value</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>ac2ac7ac2928b4cfeafdc493dd44f61c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>DijkstraDefaultOperationTraits&lt; Value &gt;</type>
      <name>OperationTraits</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a44e2d7b3991904d43e2dc64bc7b3994b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; int &gt;</type>
      <name>HeapCrossRef</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>abe21d3edcb6bd235d862becfd84c6d92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BinHeap&lt; Value, typename Digraph::template NodeMap&lt; int &gt;, std::less&lt; Value &gt; &gt;</type>
      <name>Heap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a7ef292c7753186b672855ef6a2290cff</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename Digraph::Arc &gt;</type>
      <name>PredMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a2f311e3024ce1a50c00ffc291bce8e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NullMap&lt; typename Digraph::Node, bool &gt;</type>
      <name>ProcessedMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>ab4c841b7d3ecb344be7b85370b908920</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Digraph::template NodeMap&lt; typename LEN::Value &gt;</type>
      <name>DistMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a9735fe3ebb1835f94ac433863be10527</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static HeapCrossRef *</type>
      <name>createHeapCrossRef</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>ae1638f8612c39f3d981d57056aca2c37</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Heap *</type>
      <name>createHeap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a01816b6b724aa6d7f99d7ac19d549125</anchor>
      <arglist>(HeapCrossRef &amp;r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static PredMap *</type>
      <name>createPredMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>a1d05c10ba44d3b5104c17e8181912d2c</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ProcessedMap *</type>
      <name>createProcessedMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>aef8f11ee548ae3b61e7c2a0018455569</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static DistMap *</type>
      <name>createDistMap</name>
      <anchorfile>a00138.html</anchorfile>
      <anchor>ac24cfd641a704fa02ebd5d2403125c66</anchor>
      <arglist>(const Digraph &amp;g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DijkstraWizardBase</name>
    <filename>a00137.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>lemon::DijkstraWizardDefaultTraits</base>
    <member kind="function">
      <type></type>
      <name>DijkstraWizardBase</name>
      <anchorfile>a00137.html</anchorfile>
      <anchor>a33295db5ac017fd3f4aabbabb356973f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DijkstraWizardBase</name>
      <anchorfile>a00137.html</anchorfile>
      <anchor>afb8afa8f01b04960d3177cbd0568713e</anchor>
      <arglist>(const GR &amp;g, const LEN &amp;l)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DijkstraWizard</name>
    <filename>a00136.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DijkstraWizard</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>a9f26d04d4cbf48a326f1997016e9d413</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DijkstraWizard</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>af5dd28cdef6fc5915eb674832737ee85</anchor>
      <arglist>(const Digraph &amp;g, const LengthMap &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DijkstraWizard</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>af83a6b7a96934b5c0efe73294f5d9412</anchor>
      <arglist>(const TR &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>ae3f0682c90a4e8a23c259943e899402e</anchor>
      <arglist>(Node s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>ad2c3c4217c98b58a8618397d65d400c8</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; SetPredMapBase&lt; T &gt; &gt;</type>
      <name>predMap</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>aca41f52e954600bd52f54a144df7f240</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; SetDistMapBase&lt; T &gt; &gt;</type>
      <name>distMap</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>aa60473d7110f682b02c4cc2d70efc9ae</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; SetProcessedMapBase&lt; T &gt; &gt;</type>
      <name>processedMap</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>a3fcf99acc15cf322ae4bd390cf4d6421</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard&lt; SetPathBase&lt; T &gt; &gt;</type>
      <name>path</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>a4a1fc26b49d7a74ec53247a5ed514c71</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>DijkstraWizard</type>
      <name>dist</name>
      <anchorfile>a00136.html</anchorfile>
      <anchor>afd921c8909e9b920668ff2f9aa6c2208</anchor>
      <arglist>(const Value &amp;d)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DimacsDescriptor</name>
    <filename>a00139.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>Type</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NONE</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7ac157bdf0b85a40d2619cbc8bc1ae5fe2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MIN</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7a957e8250f68e7b5677b22397c2c1b51e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MAX</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7ad7e097bda6d981de2520f49fe74c25b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SP</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7a77c32937cb56776e7d96ed4b5e43e06b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MAT</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a1d1cfd8ffb84e947f82999c682b666a7abeed243a6ffb8f4f203ba3fb934ab3b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DimacsDescriptor</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>abb1aab8d4a78dbac2c1c69fccf3b337e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>Type</type>
      <name>type</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>ab6f4e6d3fde00ce906e46494f60dfe7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>nodeNum</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>a787bebfa4c764244b11726a4024576a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>edgeNum</name>
      <anchorfile>a00139.html</anchorfile>
      <anchor>ad6c4c67355fbdfa9035a24b8a3c76dee</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListArcSet</name>
    <filename>a00240.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>ListArcSet</name>
      <anchorfile>a00240.html</anchorfile>
      <anchor>aa282329c1d82b1cb36430d5905c0ae41</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>addArc</name>
      <anchorfile>a00240.html</anchorfile>
      <anchor>ab947ea03356504c5c4b3c8ebfed1516a</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00240.html</anchorfile>
      <anchor>a3a2143bdbfc896efc87ea1a34bbcf824</anchor>
      <arglist>(const Arc &amp;a)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListEdgeSet</name>
    <filename>a00243.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>ListEdgeSet</name>
      <anchorfile>a00243.html</anchorfile>
      <anchor>adda52643f52a89c07675d8f223574921</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>addEdge</name>
      <anchorfile>a00243.html</anchorfile>
      <anchor>a6192e97afb39b9e2ec4babc88a8aca5f</anchor>
      <arglist>(const Node &amp;u, const Node &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00243.html</anchorfile>
      <anchor>accff03c7f445a919e57d4ca8e1b2199f</anchor>
      <arglist>(const Edge &amp;e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SmartArcSet</name>
    <filename>a00400.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>SmartArcSet</name>
      <anchorfile>a00400.html</anchorfile>
      <anchor>a695e3ed4a0721ca1e24704aa26ebfff1</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>addArc</name>
      <anchorfile>a00400.html</anchorfile>
      <anchor>ab947ea03356504c5c4b3c8ebfed1516a</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00400.html</anchorfile>
      <anchor>a8d985300b138b6c5556ab17ed4df3b38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SmartEdgeSet</name>
    <filename>a00403.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>SmartEdgeSet</name>
      <anchorfile>a00403.html</anchorfile>
      <anchor>aea25784c832ec83e58bb3e0019c507b3</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>addEdge</name>
      <anchorfile>a00403.html</anchorfile>
      <anchor>a6192e97afb39b9e2ec4babc88a8aca5f</anchor>
      <arglist>(const Node &amp;u, const Node &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00403.html</anchorfile>
      <anchor>a8d985300b138b6c5556ab17ed4df3b38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::EdmondsKarpDefaultTraits</name>
    <filename>a00153.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CAP</type>
      <name>CapacityMap</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>a10f68c1f869f7e1be967acfbd9750290</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CapacityMap::Value</type>
      <name>Value</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>af751c878eda966b90fa4fdf5f1915eff</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GR::ArcMap&lt; Value &gt;</type>
      <name>FlowMap</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>a96d8e23f3aa7e1f5c97c91eae139de3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Tolerance&lt; Value &gt;</type>
      <name>Tolerance</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>ac8d81c6484d646b8881c72707f2527d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static FlowMap *</type>
      <name>createFlowMap</name>
      <anchorfile>a00153.html</anchorfile>
      <anchor>afd79e520abbe90ea86b8013071afb57b</anchor>
      <arglist>(const Digraph &amp;digraph)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::EdmondsKarp</name>
    <filename>a00152.html</filename>
    <templarg>GR</templarg>
    <templarg>CAP</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::EdmondsKarp::SetFlowMap</class>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::CapacityMap</type>
      <name>CapacityMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a9eeec06f304c4b0e7ec59d26ea8698a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EdmondsKarp</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a23b3345b69d5205b7813bc411f36d2ae</anchor>
      <arglist>(const Digraph &amp;digraph, const CapacityMap &amp;capacity, Node source, Node target)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~EdmondsKarp</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a3892aa590576b0c5dd545bd6778988c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>capacityMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a1e9e748cada16e30fa0256765256f648</anchor>
      <arglist>(const CapacityMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>adc573e8da9e80a6978c18f29094b53ca</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>source</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a928c9a37a5664d61043b7851b845f5a6</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>target</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aa72e7a5670c6a99ffd8028abac44fec6</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a51d8b037a057e71c5d3216997cfc904e</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a92ec4a47dbfc2c305415f69d2c9897e4</anchor>
      <arglist>(const FlowMap &amp;flowMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedInit</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aaecaa382881804e00b0eac86601f6323</anchor>
      <arglist>(const FlowMap &amp;flowMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>augment</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aac7f521b61097eae729916c2ce419246</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flowValue</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a8213f5ab8f2d11b368bd26833c570d55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const </arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>minCut</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a7069e6ac25c7ac3cc4f0b79bf7166ff2</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>minCutMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ad7eece05e8d3496ee396d81ca2198927</anchor>
      <arglist>(CutMap &amp;cutMap) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::EdmondsKarp::SetFlowMap</name>
    <filename>a00353.html</filename>
    <templarg></templarg>
    <base>EdmondsKarp&lt; Digraph, CapacityMap, SetFlowMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetFlowMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aa6928feef02be4f2a184775d19dc6373</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::CapacityMap</type>
      <name>CapacityMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a9eeec06f304c4b0e7ec59d26ea8698a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Value</type>
      <name>Value</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a1c7478783a00413767196fd8d82ad8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::FlowMap</type>
      <name>FlowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>acbaaf29d0c8168790ab0da45dad92c62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Traits::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a926a96c583959d256c1316a2aca3ce22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EdmondsKarp</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a23b3345b69d5205b7813bc411f36d2ae</anchor>
      <arglist>(const Digraph &amp;digraph, const CapacityMap &amp;capacity, Node source, Node target)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~EdmondsKarp</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a3892aa590576b0c5dd545bd6778988c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>capacityMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a1e9e748cada16e30fa0256765256f648</anchor>
      <arglist>(const CapacityMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>adc573e8da9e80a6978c18f29094b53ca</anchor>
      <arglist>(FlowMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>source</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a928c9a37a5664d61043b7851b845f5a6</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>target</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aa72e7a5670c6a99ffd8028abac44fec6</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>EdmondsKarp &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a51d8b037a057e71c5d3216997cfc904e</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const FlowMap &amp;</type>
      <name>flowMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a592e6bf75b178e6e189eedf322abcc27</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flowValue</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a8213f5ab8f2d11b368bd26833c570d55</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>flow</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ae5735fb5fda2b9e5d130a7628a32737a</anchor>
      <arglist>(const Arc &amp;arc) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>minCut</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a7069e6ac25c7ac3cc4f0b79bf7166ff2</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>minCutMap</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>ad7eece05e8d3496ee396d81ca2198927</anchor>
      <arglist>(CutMap &amp;cutMap) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a92ec4a47dbfc2c305415f69d2c9897e4</anchor>
      <arglist>(const FlowMap &amp;flowMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkedInit</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aaecaa382881804e00b0eac86601f6323</anchor>
      <arglist>(const FlowMap &amp;flowMap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>augment</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>aac7f521b61097eae729916c2ce419246</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00152.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Elevator</name>
    <filename>a00154.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>Elevator</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>ac5d91754365aee61cba08bc0706fda0f</anchor>
      <arglist>(const GR &amp;graph, int max_level)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Elevator</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>aedd805b73161ff74106bb1cbb18ae976</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a4db11bfc0b64725808f2cedf6efe85bc</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deactivate</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a6399621b031eeef6b06bf4f25d0922c7</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>active</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a16d8e320d25a950a7ccd3f42fc12d699</anchor>
      <arglist>(Item i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator[]</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a21db8d22216b643992538b26efd49553</anchor>
      <arglist>(Item i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>onLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a4f42d083c6e02d3bb636f4a9865e17ea</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a7222462ad836aa926e3dc04fc982e329</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>aboveLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>aa57b36ed3da61ecce558c68cd214b3b3</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>activesOnLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a7e843e422235ed011d3218242d028cc6</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>activeFree</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a91603b89ccd4b7b3f806a24bdcedcb30</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a128a4da1b7623c68670a387fa148c65f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lift</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a9e8cac16792c7bdac1584828690059a5</anchor>
      <arglist>(Item i, int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dirtyTopButOne</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a45c945d67da38b2225cf6c34504cdb08</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftToTop</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>af2c6a1f548364b1447a377c311eb948e</anchor>
      <arglist>(int l)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>highestActive</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a47eff0f8503f5d8038b31a4b36874c21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>highestActiveLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>ad57dbb9976fbf0bfa412b0dc88776ffc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActive</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>ad448db204a4dc8bcb628933f31a113d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActive</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a744a06f7232fcac254c31fe9b2b879b0</anchor>
      <arglist>(int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActiveToTop</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>afa70a583d65837a24a1c86bf52a6fdc9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>activeOn</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a9963ab165df3118927670e795da8fc57</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>liftActiveOn</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a4e2a5214802d2fac206445d347757251</anchor>
      <arglist>(int level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftActiveOn</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a2a5c7fcaf906c207748cbc6a2993ceb3</anchor>
      <arglist>(int level, int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftActiveToTop</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>ae396f5ceb651cfc812eee9737a5fbd79</anchor>
      <arglist>(int level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initStart</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a92a97cb68d6dbaf545fa72b36dfa3cd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initAddItem</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>a64a9da3e23ab4c7248a6efcde26b1064</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initNewLevel</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>aa8880e6363f8b0c2e012a03cb8bc0d77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initFinish</name>
      <anchorfile>a00154.html</anchorfile>
      <anchor>afaee4c060888616a45d071530326ea8b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LinkedElevator</name>
    <filename>a00239.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>LinkedElevator</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a7c6dec431b72da2e9f1ea0296d104f0e</anchor>
      <arglist>(const GR &amp;graph, int max_level)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LinkedElevator</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>aa58ae777b13e13505d79f6d58be15e37</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a4db11bfc0b64725808f2cedf6efe85bc</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deactivate</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a6399621b031eeef6b06bf4f25d0922c7</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>active</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a16d8e320d25a950a7ccd3f42fc12d699</anchor>
      <arglist>(Item i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator[]</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a21db8d22216b643992538b26efd49553</anchor>
      <arglist>(Item i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>onLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a4f42d083c6e02d3bb636f4a9865e17ea</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emptyLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a7222462ad836aa926e3dc04fc982e329</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>aboveLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>aa57b36ed3da61ecce558c68cd214b3b3</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>activesOnLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a7e843e422235ed011d3218242d028cc6</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>activeFree</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a91603b89ccd4b7b3f806a24bdcedcb30</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a128a4da1b7623c68670a387fa148c65f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lift</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a9e8cac16792c7bdac1584828690059a5</anchor>
      <arglist>(Item i, int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dirtyTopButOne</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a45c945d67da38b2225cf6c34504cdb08</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftToTop</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>af2c6a1f548364b1447a377c311eb948e</anchor>
      <arglist>(int l)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>highestActive</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a47eff0f8503f5d8038b31a4b36874c21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>highestActiveLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>ad57dbb9976fbf0bfa412b0dc88776ffc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActive</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>ad448db204a4dc8bcb628933f31a113d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActive</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a744a06f7232fcac254c31fe9b2b879b0</anchor>
      <arglist>(int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftHighestActiveToTop</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>afa70a583d65837a24a1c86bf52a6fdc9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>activeOn</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a9963ab165df3118927670e795da8fc57</anchor>
      <arglist>(int l) const </arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>liftActiveOn</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a1275752b5d49412c4cc0dc9cb4d72323</anchor>
      <arglist>(int l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftActiveOn</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a29269ad15861c513fe6297d4aad41d83</anchor>
      <arglist>(int l, int new_level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>liftActiveToTop</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a404be93d69dc02dec4b6572745a70921</anchor>
      <arglist>(int l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initStart</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a92a97cb68d6dbaf545fa72b36dfa3cd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initAddItem</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>a64a9da3e23ab4c7248a6efcde26b1064</anchor>
      <arglist>(Item i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initNewLevel</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>aa8880e6363f8b0c2e012a03cb8bc0d77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initFinish</name>
      <anchorfile>a00239.html</anchorfile>
      <anchor>afaee4c060888616a45d071530326ea8b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::Exception</name>
    <filename>a00160.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>a00160.html</anchorfile>
      <anchor>aff06f49065b54a8a86e02e9a2441a8ba</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::IoError</name>
    <filename>a00221.html</filename>
    <base>lemon::Exception</base>
    <member kind="function">
      <type></type>
      <name>IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>ad86a4dc85ccd17792866cea1da986403</anchor>
      <arglist>(const IoError &amp;error)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a01fb1ee8d1d16ccfa24cffa29389d964</anchor>
      <arglist>(const char *message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>af29d4cb0e06420d3609f98509e78166b</anchor>
      <arglist>(const std::string &amp;message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>abdc691521b8e780595d1a491a6bcc3be</anchor>
      <arglist>(const char *message, const std::string &amp;file)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a000186bf062781204af3940899f1f3ba</anchor>
      <arglist>(const std::string &amp;message, const std::string &amp;file)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IoError</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>aaad9306ace6181b2e8a38ba2eedf88d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>message</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a7a46a349ff3098534da81350a6fec061</anchor>
      <arglist>(const char *message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>message</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a6db7001e8987fe0bed56f41e53dd4fee</anchor>
      <arglist>(const std::string &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a51d6a4ade7b21409a4070f3d27c954bf</anchor>
      <arglist>(const std::string &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>message</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a4752bb1bf3e6f79dc5f9a77069a27332</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>file</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>a87681515d569e7e8d650e6b54888dd81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>a00221.html</anchorfile>
      <anchor>aff06f49065b54a8a86e02e9a2441a8ba</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FormatError</name>
    <filename>a00173.html</filename>
    <base>lemon::Exception</base>
    <member kind="function">
      <type></type>
      <name>FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>aa42ee28488e2b7bd6183b748bef48e67</anchor>
      <arglist>(const FormatError &amp;error)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a6d87564747176f0f8a357ccc2ea5f24b</anchor>
      <arglist>(const char *message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>ae14f2a9e1d948374ef4aef96cd37029d</anchor>
      <arglist>(const std::string &amp;message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a0e80334858898227937fec2734861b95</anchor>
      <arglist>(const char *message, const std::string &amp;file, int line=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a82f37328bb116765af91c298a15e62b4</anchor>
      <arglist>(const std::string &amp;message, const std::string &amp;file, int line=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FormatError</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a1f920f082438639877ff7f2959715a74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>line</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a51e985445b7c0be388784e41241e0a96</anchor>
      <arglist>(int line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>message</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a7a46a349ff3098534da81350a6fec061</anchor>
      <arglist>(const char *message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>message</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a6db7001e8987fe0bed56f41e53dd4fee</anchor>
      <arglist>(const std::string &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a51d6a4ade7b21409a4070f3d27c954bf</anchor>
      <arglist>(const std::string &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>line</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>aa6e2444d9f9eb15566a2c8cb42e45788</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>message</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a4752bb1bf3e6f79dc5f9a77069a27332</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>file</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>a87681515d569e7e8d650e6b54888dd81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>a00173.html</anchorfile>
      <anchor>aff06f49065b54a8a86e02e9a2441a8ba</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DiEulerIt</name>
    <filename>a00128.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DiEulerIt</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>a10a5924de31338bf99468ca7b1ea9156</anchor>
      <arglist>(const GR &amp;gr, typename GR::Node start=INVALID)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Arc</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>a9d50d429980c0c2b97fd33e526652023</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>afbd1dc99d3bb91299bdeac8966b4fbc1</anchor>
      <arglist>(Invalid)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>aa20cdc6e6b325e231a505a4eb85e3989</anchor>
      <arglist>(Invalid)</arglist>
    </member>
    <member kind="function">
      <type>DiEulerIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>aa0177ba9ae3d9d831ac7bef57c3e5ed8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>operator++</name>
      <anchorfile>a00128.html</anchorfile>
      <anchor>a5bdbff064cd6005e3b154c18d3b21df7</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::EulerIt</name>
    <filename>a00159.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>EulerIt</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>adeeac6d3cfe48af7b2452144c3fbf6e7</anchor>
      <arglist>(const GR &amp;gr, typename GR::Node start=INVALID)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Arc</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>afee0d9c078f8e4cf4c3197a0341f864f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Edge</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>a5a25824a51ad86bdf1651c5f988aa81f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>a9569625b6759eac56d4b4294aba9e5b2</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>aab38b74c42b0f2581ed4917fca608efc</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>EulerIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>ae0ec7d0bf98e60f122625acb3450928f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>operator++</name>
      <anchorfile>a00159.html</anchorfile>
      <anchor>a5bdbff064cd6005e3b154c18d3b21df7</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FibHeap</name>
    <filename>a00168.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IN_HEAP</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a213759402d071be3f66f8cf86641bb11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRE_HEAP</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8a12f201f9d13d106e81658dad7e7c9c2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>POST_HEAP</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a5d74787dedbc4e11c1ab15bf487e61f8acd215e97251c1085a8b299c068e7172d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>IM</type>
      <name>ItemIntMap</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ac00a2d6f039b6e8ffc0641530bdf5304</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PR</type>
      <name>Prio</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a644810a55913c9e8b24511758574d6d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ItemIntMap::Key</type>
      <name>Item</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a70025b32b600038ee2981a3deab1a783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; Item, Prio &gt;</type>
      <name>Pair</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a616fe456bc4c8eddf813c4f5665e1180</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CMP</type>
      <name>Compare</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a937d59343e7b08b620805162c2e52ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FibHeap</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ab3f82678fc257f80edb84d5d9b9383ee</anchor>
      <arglist>(ItemIntMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FibHeap</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a0e30d9a6f76348e7060c856f45183cfb</anchor>
      <arglist>(ItemIntMap &amp;map, const Compare &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ac6e61de369e994009e36f344f99c15ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a91ce50223ca87ce2bea7ff34b356bf05</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;prio)</arglist>
    </member>
    <member kind="function">
      <type>Item</type>
      <name>top</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a84adc89415588c3ce11ce526a00070d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>prio</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>aeea060d345482a9732a96e9021f0c495</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a312e7f6c761a199c1369fbe651e084f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>ab71f9a526f9dfa9ded1fdd78189c3e37</anchor>
      <arglist>(const Item &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>Prio</type>
      <name>operator[]</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a7fbc33f0b51e63188691ad1696283a8a</anchor>
      <arglist>(const Item &amp;item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a772cfdb561758bb4ea2fc22d9877acef</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;prio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decrease</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a784fd9312710aecd837d1b1e65319f07</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;prio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increase</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>acd8d4d49c8b6ad29d35fa0a90969ef48</anchor>
      <arglist>(const Item &amp;item, const Prio &amp;prio)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a583b683cf66fe46dd394837f8751a90b</anchor>
      <arglist>(const Item &amp;item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>state</name>
      <anchorfile>a00168.html</anchorfile>
      <anchor>a7d0ca230d438efaad53833701d9cb262</anchor>
      <arglist>(const Item &amp;i, State st)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::MaxFractionalMatchingDefaultTraits</name>
    <filename>a00258.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00258.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Graph::template NodeMap&lt; typename GR::Arc &gt;</type>
      <name>MatchingMap</name>
      <anchorfile>a00258.html</anchorfile>
      <anchor>a033d9deccd1a06be1a62f8e9bc74c0d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LinkedElevator&lt; Graph, typename Graph::Node &gt;</type>
      <name>Elevator</name>
      <anchorfile>a00258.html</anchorfile>
      <anchor>a8cfd34209fea564ef4e1d207bc0d2deb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static MatchingMap *</type>
      <name>createMatchingMap</name>
      <anchorfile>a00258.html</anchorfile>
      <anchor>a19316af04ed3d8ef49ed690942061dd6</anchor>
      <arglist>(const Graph &amp;graph)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Elevator *</type>
      <name>createElevator</name>
      <anchorfile>a00258.html</anchorfile>
      <anchor>a4550493b10baf925369431b30b63200a</anchor>
      <arglist>(const Graph &amp;graph, int max_level)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::MaxFractionalMatching</name>
    <filename>a00257.html</filename>
    <templarg>GR</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::MaxFractionalMatching::SetElevator</class>
    <class kind="struct">lemon::MaxFractionalMatching::SetMatchingMap</class>
    <class kind="struct">lemon::MaxFractionalMatching::SetStandardElevator</class>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Graph</type>
      <name>Graph</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a81a6597ab6f942d117d2f32b1481e0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::MatchingMap</type>
      <name>MatchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a9360c49ae8d8700a20e116842c238946</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a6f28aefb0101865304e425890c6c4c68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxFractionalMatching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5fcc721fb672aa45f70b0a208bd0feeb</anchor>
      <arglist>(const Graph &amp;graph, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a265db4699c294741b3fac13fd87683f9</anchor>
      <arglist>(MatchingMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aac65595b7a96924fb1f3136005686def</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a2b87bbc0b9cbd0fd9f193bee71984810</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ad384211fb3b06fea3a15bfc56454539b</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a035e9e0f46f74123960b677fc4950fc6</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a26b5bcdd4b8017748eeef0d258c7264c</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::MaxFractionalMatching::SetElevator</name>
    <filename>a00350.html</filename>
    <templarg></templarg>
    <base>MaxFractionalMatching&lt; Graph, SetElevatorTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetElevatorTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetElevatorTraits&lt; T &gt;::Graph</type>
      <name>Graph</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a81a6597ab6f942d117d2f32b1481e0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetElevatorTraits&lt; T &gt;::MatchingMap</type>
      <name>MatchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a9360c49ae8d8700a20e116842c238946</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetElevatorTraits&lt; T &gt;::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a6f28aefb0101865304e425890c6c4c68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxFractionalMatching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5fcc721fb672aa45f70b0a208bd0feeb</anchor>
      <arglist>(const Graph &amp;graph, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a265db4699c294741b3fac13fd87683f9</anchor>
      <arglist>(MatchingMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aac65595b7a96924fb1f3136005686def</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a2b87bbc0b9cbd0fd9f193bee71984810</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ad384211fb3b06fea3a15bfc56454539b</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a035e9e0f46f74123960b677fc4950fc6</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a26b5bcdd4b8017748eeef0d258c7264c</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::MaxFractionalMatching::SetMatchingMap</name>
    <filename>a00364.html</filename>
    <templarg></templarg>
    <base>MaxFractionalMatching&lt; Graph, SetMatchingMapTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetMatchingMapTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetMatchingMapTraits&lt; T &gt;::Graph</type>
      <name>Graph</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a81a6597ab6f942d117d2f32b1481e0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetMatchingMapTraits&lt; T &gt;::MatchingMap</type>
      <name>MatchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a9360c49ae8d8700a20e116842c238946</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetMatchingMapTraits&lt; T &gt;::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a6f28aefb0101865304e425890c6c4c68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxFractionalMatching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5fcc721fb672aa45f70b0a208bd0feeb</anchor>
      <arglist>(const Graph &amp;graph, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a265db4699c294741b3fac13fd87683f9</anchor>
      <arglist>(MatchingMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aac65595b7a96924fb1f3136005686def</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a2b87bbc0b9cbd0fd9f193bee71984810</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ad384211fb3b06fea3a15bfc56454539b</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a035e9e0f46f74123960b677fc4950fc6</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a26b5bcdd4b8017748eeef0d258c7264c</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::MaxFractionalMatching::SetStandardElevator</name>
    <filename>a00387.html</filename>
    <templarg></templarg>
    <base>MaxFractionalMatching&lt; Graph, SetStandardElevatorTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetStandardElevatorTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardElevatorTraits&lt; T &gt;::Graph</type>
      <name>Graph</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a81a6597ab6f942d117d2f32b1481e0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardElevatorTraits&lt; T &gt;::MatchingMap</type>
      <name>MatchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a9360c49ae8d8700a20e116842c238946</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetStandardElevatorTraits&lt; T &gt;::Elevator</type>
      <name>Elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a6f28aefb0101865304e425890c6c4c68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxFractionalMatching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5fcc721fb672aa45f70b0a208bd0feeb</anchor>
      <arglist>(const Graph &amp;graph, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a265db4699c294741b3fac13fd87683f9</anchor>
      <arglist>(MatchingMap &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>MaxFractionalMatching &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aac65595b7a96924fb1f3136005686def</anchor>
      <arglist>(Elevator &amp;elevator)</arglist>
    </member>
    <member kind="function">
      <type>const Elevator &amp;</type>
      <name>elevator</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a5dc9bfc4e3f3def6bd3daee725ac9d9a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>barrier</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aaa0fa8205fb370cdc9ee3b33b1cd54a9</anchor>
      <arglist>(const Node &amp;node) const</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a2b87bbc0b9cbd0fd9f193bee71984810</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>ad384211fb3b06fea3a15bfc56454539b</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a035e9e0f46f74123960b677fc4950fc6</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPerfect</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>a26b5bcdd4b8017748eeef0d258c7264c</anchor>
      <arglist>(bool postprocess=true)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00257.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::MaxWeightedFractionalMatching</name>
    <filename>a00260.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>WM</type>
      <name>WeightMap</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a8cc0487bc8ca8ef9b236b960bc0b9b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>WeightMap::Value</type>
      <name>Value</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>adb23f34f07ad6e93c0e6fba266a31c0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Graph::template NodeMap&lt; typename Graph::Arc &gt;</type>
      <name>MatchingMap</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a5e14c7d4f5b49a6771fef21bece0139c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxWeightedFractionalMatching</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>ace9cc6010d186dd13183a003067210c5</anchor>
      <arglist>(const Graph &amp;graph, const WeightMap &amp;weight, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a60de64d75454385b23995437f1d72669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>matchingWeight</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a12587b4fe2da66ed88589d45c935f2fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dualValue</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>af25ac7031ef96fbd26792f44d764fcb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>nodeValue</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>ac8e57fc9bc7adf2aaabf3cc01c1cad3d</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>dualScale</name>
      <anchorfile>a00260.html</anchorfile>
      <anchor>aeb1562496ec67b935620a87b899897bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::MaxWeightedPerfectFractionalMatching</name>
    <filename>a00262.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>WM</type>
      <name>WeightMap</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a8cc0487bc8ca8ef9b236b960bc0b9b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>WeightMap::Value</type>
      <name>Value</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>adb23f34f07ad6e93c0e6fba266a31c0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Graph::template NodeMap&lt; typename Graph::Arc &gt;</type>
      <name>MatchingMap</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a5e14c7d4f5b49a6771fef21bece0139c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MaxWeightedPerfectFractionalMatching</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a095ae90f2c8db1d9c4d709d348b93092</anchor>
      <arglist>(const Graph &amp;graph, const WeightMap &amp;weight, bool allow_loops=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>aad5997aaaa2d622f0ca57f8b24a51a7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>matchingWeight</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a12587b4fe2da66ed88589d45c935f2fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matchingSize</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a8be6dc29de917e74b2fcf7d452ec033d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>matching</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a50c6e553126fcd65c0f177f6f9ea23de</anchor>
      <arglist>(const Edge &amp;edge) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>matching</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>a20e6a43cb0c6c60ec37d39c627b8b662</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>const MatchingMap &amp;</type>
      <name>matchingMap</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>ae64828409d8b38c61c9d134d3f139390</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dualValue</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>af25ac7031ef96fbd26792f44d764fcb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>nodeValue</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>ac8e57fc9bc7adf2aaabf3cc01c1cad3d</anchor>
      <arglist>(const Node &amp;n) const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>primalScale</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>aa437420dd0d9ef796d732dc5df70c008</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>dualScale</name>
      <anchorfile>a00262.html</anchorfile>
      <anchor>aeb1562496ec67b935620a87b899897bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FullDigraph</name>
    <filename>a00176.html</filename>
    <member kind="function">
      <type></type>
      <name>FullDigraph</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>a8efcbbf06d26f743ebb266ceb4ca1a2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FullDigraph</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>a79330852030897096b3c56124e78c91b</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>a578be9c59132b8633a67a98c39318777</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>operator()</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>acbd2e4abdacde884248a2cd28de06aa7</anchor>
      <arglist>(int ix) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>arc</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>a7991a8877d6d966ce0bc5bdf6c943310</anchor>
      <arglist>(Node u, Node v) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nodeNum</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>af9239a81c840ea4b094b196b6f164fcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>arcNum</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>a9cda7016f5de299b88f32cf63edee345</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>index</name>
      <anchorfile>a00176.html</anchorfile>
      <anchor>aa2c4526a503bb0dbebd87c4fba5e3a7b</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FullGraph</name>
    <filename>a00177.html</filename>
    <member kind="function">
      <type></type>
      <name>FullGraph</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a9064d1ac89eab29b8f2951ce080d4e87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FullGraph</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a01cb8bb8e0b8f898ffeb33348c48fad2</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a578be9c59132b8633a67a98c39318777</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>operator()</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>acbd2e4abdacde884248a2cd28de06aa7</anchor>
      <arglist>(int ix) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>arc</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>ac5d51116adc07c75766c89a3769f05ea</anchor>
      <arglist>(Node s, Node t) const </arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>edge</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a13e2933cb087a684a72df13ed8bf6bf2</anchor>
      <arglist>(Node u, Node v) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nodeNum</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>af9239a81c840ea4b094b196b6f164fcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>arcNum</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a9cda7016f5de299b88f32cf63edee345</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>edgeNum</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>a484eca76dda3fe1ceaff8073db17e38e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>index</name>
      <anchorfile>a00177.html</anchorfile>
      <anchor>aa2c4526a503bb0dbebd87c4fba5e3a7b</anchor>
      <arglist>(const Node &amp;node)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::FullBpGraph</name>
    <filename>a00175.html</filename>
    <member kind="function">
      <type></type>
      <name>FullBpGraph</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>abc7c05e9365c30bf769e3e97a5032335</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FullBpGraph</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>aab84448cec3ded27de38f2bb335835fa</anchor>
      <arglist>(int redNum, int blueNum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>ab93c5ab92bb59fcab06c4dfee228f216</anchor>
      <arglist>(int redNum, int blueNum)</arglist>
    </member>
    <member kind="function">
      <type>RedNode</type>
      <name>redNode</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a2cc1f3d4aa8ed4239252c36676674c1c</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>index</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a40ec454ed4948640de295c75e64fdcb9</anchor>
      <arglist>(RedNode node) const </arglist>
    </member>
    <member kind="function">
      <type>BlueNode</type>
      <name>blueNode</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a2125ee149020b66b98ffb64f7e667915</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>index</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a04cc31f34529ccaf8dd1fb97a2ddc646</anchor>
      <arglist>(BlueNode node) const </arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>edge</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a6967f1e83266adfc9bc34ddbedcfb153</anchor>
      <arglist>(const Node &amp;u, const Node &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>arc</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>ad69cdebb233f0a9db9e20432c3944777</anchor>
      <arglist>(const Node &amp;u, const Node &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nodeNum</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>af9239a81c840ea4b094b196b6f164fcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>redNum</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>aaeb6172fbb9272dac19c2e1cf49438ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>blueNum</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a69c0b236688e5af8c4a7108b0189d7db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>arcNum</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a9cda7016f5de299b88f32cf63edee345</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>edgeNum</name>
      <anchorfile>a00175.html</anchorfile>
      <anchor>a484eca76dda3fe1ceaff8073db17e38e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GlpkBase</name>
    <filename>a00179.html</filename>
    <base virtualness="virtual">lemon::LpBase</base>
    <member kind="function">
      <type>_solver_bits::VoidPtr</type>
      <name>lpx</name>
      <anchorfile>a00179.html</anchorfile>
      <anchor>adf0d2711307da6c7cb6acee24458f699</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>_solver_bits::VoidPtr</type>
      <name>lpx</name>
      <anchorfile>a00179.html</anchorfile>
      <anchor>a7deae91370056673f00d768ff2cacd0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lpxRow</name>
      <anchorfile>a00179.html</anchorfile>
      <anchor>a529c22d2782c36e88390066375fd18ea</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lpxCol</name>
      <anchorfile>a00179.html</anchorfile>
      <anchor>a978fd544ddf16fe723c4d90184366670</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write</name>
      <anchorfile>a00179.html</anchorfile>
      <anchor>a6f987737d989d046dd4c24150442ff14</anchor>
      <arglist>(std::string file, std::string format=&quot;MPS&quot;) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GlpkLp</name>
    <filename>a00180.html</filename>
    <base>lemon::LpSolver</base>
    <base>lemon::GlpkBase</base>
    <member kind="function">
      <type></type>
      <name>GlpkLp</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>a8fd9ded5caa626fdf9b1b67e0d4342f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GlpkLp</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>abed5d680cd663d1ebf51276c5d40a3c4</anchor>
      <arglist>(const GlpkLp &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual GlpkLp *</type>
      <name>cloneSolver</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>a2f2c4126d10df2126723dab73be4b3fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual GlpkLp *</type>
      <name>newSolver</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>aff89c0081b70f9f731386769b6f980fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solvePrimal</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>a48d56f0dbe8b60dadfb9aa6f6e7a458a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SolveExitStatus</type>
      <name>solveDual</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>a2f2e89d8a3d14f3f86b38a67967df930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>presolver</name>
      <anchorfile>a00180.html</anchorfile>
      <anchor>ab03beab5ff5c12c7160c325c0b6995d6</anchor>
      <arglist>(bool presolve)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GlpkMip</name>
    <filename>a00181.html</filename>
    <base>lemon::MipSolver</base>
    <base>lemon::GlpkBase</base>
    <member kind="function">
      <type></type>
      <name>GlpkMip</name>
      <anchorfile>a00181.html</anchorfile>
      <anchor>ad1601aa1469b52a8fef9e52050a3bc1a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GlpkMip</name>
      <anchorfile>a00181.html</anchorfile>
      <anchor>ab1c1ec0ee2201677230ce93a1c815c90</anchor>
      <arglist>(const GlpkMip &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GomoryHu</name>
    <filename>a00182.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <class kind="class">lemon::GomoryHu::MinCutEdgeIt</class>
    <class kind="class">lemon::GomoryHu::MinCutNodeIt</class>
    <member kind="typedef">
      <type>GR</type>
      <name>Graph</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a2a51ae337b207f01f1c904f5eb2aa98a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CAP</type>
      <name>Capacity</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a772fe38595302c3bf6c4e79765a37a28</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Capacity::Value</type>
      <name>Value</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a316b6a8145c12ea1dbb1e1e36005a500</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GomoryHu</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a31ffa12460cb7ae041f29f09fcd9b8f4</anchor>
      <arglist>(const Graph &amp;graph, const Capacity &amp;capacity)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GomoryHu</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>abb081203500b7357f28747e675cfd341</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>predNode</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a8a047e2d12d7f33ced19c7f71b39278e</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>predValue</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a67bb03ba4623543e6b08a2f339c1080e</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rootDist</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a1723a3299a8a799b1b038ffc6a7a0d4b</anchor>
      <arglist>(const Node &amp;node) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>minCutValue</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>ab6912debf06e1db6c9c267a93368af51</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>minCutMap</name>
      <anchorfile>a00182.html</anchorfile>
      <anchor>a8fd9a551129afe8068e2dc820be68fc9</anchor>
      <arglist>(const Node &amp;s, const Node &amp;t, CutMap &amp;cutMap) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GomoryHu::MinCutEdgeIt</name>
    <filename>a00266.html</filename>
    <member kind="function">
      <type></type>
      <name>MinCutEdgeIt</name>
      <anchorfile>a00266.html</anchorfile>
      <anchor>a7462ab82ac3c02f3b6e73b37ebc9eeed</anchor>
      <arglist>(GomoryHu const &amp;gomory, const Node &amp;s, const Node &amp;t, bool side=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator typename Graph::Arc</name>
      <anchorfile>a00266.html</anchorfile>
      <anchor>a3bf276f89f021425e167c77f6f16dd90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator typename Graph::Edge</name>
      <anchorfile>a00266.html</anchorfile>
      <anchor>a17b705ba5f1f32fd950a7a8154898053</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MinCutEdgeIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00266.html</anchorfile>
      <anchor>ad55c346699bf86b8b24c89b03c9ad43d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Graph::Arc</type>
      <name>operator++</name>
      <anchorfile>a00266.html</anchorfile>
      <anchor>ad262fcc0a3a1a4759f00f42ac0260646</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GomoryHu::MinCutNodeIt</name>
    <filename>a00267.html</filename>
    <member kind="function">
      <type></type>
      <name>MinCutNodeIt</name>
      <anchorfile>a00267.html</anchorfile>
      <anchor>aaea2c4b8a4f9d05eeaf5e11cc26e81e7</anchor>
      <arglist>(GomoryHu const &amp;gomory, const Node &amp;s, const Node &amp;t, bool side=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator typename Graph::Node</name>
      <anchorfile>a00267.html</anchorfile>
      <anchor>a70612da66bb330d0b98094ac8e34372c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MinCutNodeIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00267.html</anchorfile>
      <anchor>af7c6603223a0d6426a548bf4529fa7a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Graph::Node</type>
      <name>operator++</name>
      <anchorfile>a00267.html</anchorfile>
      <anchor>ad839066a44bc207d648e5f0623601565</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::DefaultGraphToEpsTraits</name>
    <filename>a00118.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DefaultGraphToEpsTraits</name>
      <anchorfile>a00118.html</anchorfile>
      <anchor>a5120c56fa09e7484ecd90f9d237ddebd</anchor>
      <arglist>(const GR &amp;gr, std::ostream &amp;ost=std::cout, bool pros=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GraphToEps</name>
    <filename>a00190.html</filename>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>NodeShapes</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CIRCLE</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7aa79c827759ea48f0735386c4b1188911</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SQUARE</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7a4233fbf0cafb86abcee94b38d769fc59</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DIAMOND</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7a714f2cc5c292a305e2da3c03bd63916a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MALE</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7a6e81fe1ef694726dd6f7246cfb42369f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FEMALE</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a30c21e7556892045cb4f5553dcc47ef7adebb817413857eea6331734b76793159</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; CoordsTraits&lt; X &gt; &gt;</type>
      <name>coords</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a0d11c25d82382b8ab09f034c94c65832</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodeSizesTraits&lt; X &gt; &gt;</type>
      <name>nodeSizes</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>aff72b2c51861ee462ad023c7d319dd52</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodeShapesTraits&lt; X &gt; &gt;</type>
      <name>nodeShapes</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a58737078462e7e34c66169ac0b874554</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodeTextsTraits&lt; X &gt; &gt;</type>
      <name>nodeTexts</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a9c1d158b073ab950de692a53b0895776</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodePsTextsTraits&lt; X &gt; &gt;</type>
      <name>nodePsTexts</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a3d0804bbd36f62d17532ccea1728575f</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; ArcWidthsTraits&lt; X &gt; &gt;</type>
      <name>arcWidths</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>ac1d3d9be1a04faa0ed290ddc9d8e33c9</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodeColorsTraits&lt; X &gt; &gt;</type>
      <name>nodeColors</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a16fabdc1e8a211b48023ee58629aefd9</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; NodeTextColorsTraits&lt; X &gt; &gt;</type>
      <name>nodeTextColors</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a289b0bcc85f0e414e3a1b71291841145</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; ArcColorsTraits&lt; X &gt; &gt;</type>
      <name>arcColors</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a7c1157145713ecfa18f55e7e38d1bd3b</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>nodeScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>aeac1e05eca87ec3eb33567e31ef1a91c</anchor>
      <arglist>(double d=.01)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>autoNodeScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a8d190137dbe4aacfa7d5cfce809d9f75</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>absoluteNodeSizes</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>aa370a1dd4b34a5b82ff4c9d79790edd7</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>negateY</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a3104ccdec88f257754d817e4050530ae</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>preScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a728bce841b714ae589c110181e8f37f3</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>arcWidthScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>abf807dd381deda708eaceac647ddabf5</anchor>
      <arglist>(double d=.003)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>autoArcWidthScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>abd98d77a768da5b90d54f2503c43aea9</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>absoluteArcWidths</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a194970341303abd037ff052bf243f241</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>scale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>ae974ab0876d042da85db8a365a2c7fad</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>border</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a6ee956315db169869d5e8b25d322855f</anchor>
      <arglist>(double b=10)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>border</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a3e60b386fd2382cfa00029b1c04ff125</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>drawArrows</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a5927ce2b5f72a0e077efed38c0a95064</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>arrowLength</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a134f596814e662f477366f2c777d8f65</anchor>
      <arglist>(double d=1.0)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>arrowWidth</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>adc664049d0ea2a763e742bc39f9e9b73</anchor>
      <arglist>(double d=.3)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>scaleToA4</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a85b25a0508ef21583dbda20251e675d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>enableParallel</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>abcdb13d61119d0484bd5e96f9e844c31</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>parArcDist</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a1b00550e4019644f4057d3aaf57726b2</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>hideArcs</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a5ef8417b40049c9d6411a68bd0682262</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>hideNodes</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a0b3ec217b0c0686b46980f812dfdd9ba</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>nodeTextSize</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a38eac3772663e5509aa45322ccd42bbc</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>distantColorNodeTexts</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a01072429fe9bae7a4766665e4c64bfb2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>distantBWNodeTexts</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>afb1df0f6b681202ac8e74a2c9912ebe5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>nodePsTextsPreamble</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a43c32c975a0d66650b56999e739bc7cd</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>undirected</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a57f03f8f903d351350e0fd939cf97eb3</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>directed</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a5df7407bacfc9447bb237376cead4218</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>title</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a98feec1651e0184b26c2fb56aef2d18b</anchor>
      <arglist>(const std::string &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>copyright</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a7d899188733cc29477191a0ecd04619a</anchor>
      <arglist>(const std::string &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; ArcWidthsTraits&lt; X &gt; &gt;</type>
      <name>edgeWidths</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>abbd39a2b17070d9eb06596602d2c1645</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; ArcColorsTraits&lt; X &gt; &gt;</type>
      <name>edgeColors</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a554741a027cbf9de815c578db6346b1f</anchor>
      <arglist>(const X &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>edgeWidthScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a1aa0ca617588f0922679ec9a34b42e8c</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>autoEdgeWidthScale</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>abe5b9b9b28139e1eb38d2a67268897ff</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>absoluteEdgeWidths</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a26373d9622dd9292313b81e78381e852</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>parEdgeDist</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a7a58d26082b1c28cb83d7e79e993d21c</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>GraphToEps&lt; T &gt; &amp;</type>
      <name>hideEdges</name>
      <anchorfile>a00190.html</anchorfile>
      <anchor>a9afe60ce30d0481d04268dd0fc4674d2</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GreedyTsp</name>
    <filename>a00192.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM::Value</type>
      <name>Cost</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a1a1dfba092aeec4656ebceaf99ca8b22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GreedyTsp</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a02b07ecd025ae827ff29e6eb6e9271c4</anchor>
      <arglist>(const FullGraph &amp;gr, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>run</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>af294138cc991668caa699c9255c8f136</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>tourCost</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a2b50553673232826084189a99f3ed9ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; Node &gt; &amp;</type>
      <name>tourNodes</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a81073828a7db97f717d815d40b7d129f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tourNodes</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a010a65e00187b4a154800b5e0b113cd3</anchor>
      <arglist>(Iterator out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tour</name>
      <anchorfile>a00192.html</anchorfile>
      <anchor>a15eae02ecc81a0f40b2ee2f76b478a6c</anchor>
      <arglist>(Path &amp;path) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GridGraph</name>
    <filename>a00193.html</filename>
    <class kind="class">lemon::GridGraph::ColMap</class>
    <class kind="class">lemon::GridGraph::IndexMap</class>
    <class kind="class">lemon::GridGraph::RowMap</class>
    <member kind="function">
      <type></type>
      <name>GridGraph</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a9592df3bc5a41604bcc6c08b17e6ccce</anchor>
      <arglist>(int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a56bfa8fae91947eb5802d2e208405904</anchor>
      <arglist>(int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>operator()</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>afdd1ab1ea88ed5eac1ae78f52b2c1369</anchor>
      <arglist>(int i, int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>col</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>ac2be310f16fedfdff4a593e50cfe3728</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>row</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>af590748876d1cdb76d35a89ecc098c27</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>dim2::Point&lt; int &gt;</type>
      <name>pos</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a8f32b26ac5800115467f86ba31aca963</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>width</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a369399896761e31ae71db57fdd0ba431</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>height</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>ae26bcfe2f33f5873dbdfb6948cf1f59f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>right</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a516efb9fb0a2f315d691dd19c130bd63</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>left</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>af81fa44653a5566024651571fc915bd4</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>up</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>adde1f2065416cbaaf17563ef322694fa</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>down</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>ade5fc8f1246792a247f5760a869e1d96</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>IndexMap</type>
      <name>indexMap</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a5f999c4f26c4306119a5be087ad88c3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RowMap</type>
      <name>rowMap</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a52865a6bd4c2548dbd1ced85b2a1f36f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ColMap</type>
      <name>colMap</name>
      <anchorfile>a00193.html</anchorfile>
      <anchor>a4100e090fe6634a5dc491944bafab99a</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GridGraph::ColMap</name>
    <filename>a00092.html</filename>
    <member kind="typedef">
      <type>GridGraph::Node</type>
      <name>Key</name>
      <anchorfile>a00092.html</anchorfile>
      <anchor>a89610f8cffa34a4715c0730e05cb8751</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>Value</name>
      <anchorfile>a00092.html</anchorfile>
      <anchor>a8940a046b717a18878ab9de4ba32a0b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ColMap</name>
      <anchorfile>a00092.html</anchorfile>
      <anchor>acc4976242d536051e8c575c83d17cf72</anchor>
      <arglist>(const GridGraph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00092.html</anchorfile>
      <anchor>adec40b5924be9b2ac620ace6c4cd8db8</anchor>
      <arglist>(Key key) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GridGraph::IndexMap</name>
    <filename>a00215.html</filename>
    <member kind="typedef">
      <type>GridGraph::Node</type>
      <name>Key</name>
      <anchorfile>a00215.html</anchorfile>
      <anchor>a89610f8cffa34a4715c0730e05cb8751</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>dim2::Point&lt; int &gt;</type>
      <name>Value</name>
      <anchorfile>a00215.html</anchorfile>
      <anchor>a9b682dd11c28cb3e98421ffb2c4a2240</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IndexMap</name>
      <anchorfile>a00215.html</anchorfile>
      <anchor>a7963a1ca4bc817546073da2398d29778</anchor>
      <arglist>(const GridGraph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00215.html</anchorfile>
      <anchor>adec40b5924be9b2ac620ace6c4cd8db8</anchor>
      <arglist>(Key key) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GridGraph::RowMap</name>
    <filename>a00336.html</filename>
    <member kind="typedef">
      <type>GridGraph::Node</type>
      <name>Key</name>
      <anchorfile>a00336.html</anchorfile>
      <anchor>a89610f8cffa34a4715c0730e05cb8751</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>Value</name>
      <anchorfile>a00336.html</anchorfile>
      <anchor>a8940a046b717a18878ab9de4ba32a0b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RowMap</name>
      <anchorfile>a00336.html</anchorfile>
      <anchor>a065a8779432e06c7faa1e2524fed51e1</anchor>
      <arglist>(const GridGraph &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00336.html</anchorfile>
      <anchor>adec40b5924be9b2ac620ace6c4cd8db8</anchor>
      <arglist>(Key key) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GrossoLocatelliPullanMc</name>
    <filename>a00194.html</filename>
    <templarg></templarg>
    <class kind="class">lemon::GrossoLocatelliPullanMc::CliqueNodeIt</class>
    <member kind="enumeration">
      <type></type>
      <name>SelectionRule</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RANDOM</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708eaa2b65445a3a16f164c5e811064d75726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DEGREE_BASED</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708ea52018f7611e838b47b98efd925e7b7a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PENALTY_BASED</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708ea41cf48432fc2603d02aad347ce48a7c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TerminationCause</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ITERATION_LIMIT</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa2ae51471aa8024ea15450efeae10bf37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>STEP_LIMIT</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa15de6de02eba8ace6e49fcb713fa7164</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIZE_LIMIT</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa9d932f1317a69d22804b2ea30fb00a81</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GrossoLocatelliPullanMc</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a9ab95afa7e1a9c4fd8619f98aaaa63a0</anchor>
      <arglist>(const GR &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GrossoLocatelliPullanMc</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a94157b6d74ac0f56a9ed6ad1dd1c8f02</anchor>
      <arglist>(const GR &amp;graph, int seed)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GrossoLocatelliPullanMc</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a127cbd3f9c20ce1bcbd934860d3b2ad9</anchor>
      <arglist>(const GR &amp;graph, const Random &amp;random)</arglist>
    </member>
    <member kind="function">
      <type>GrossoLocatelliPullanMc &amp;</type>
      <name>iterationLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a3f36bb3202fc23244af7acb817629231</anchor>
      <arglist>(int limit)</arglist>
    </member>
    <member kind="function">
      <type>GrossoLocatelliPullanMc &amp;</type>
      <name>stepLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a571fc10bce39a08b13b6f0d7323c9d28</anchor>
      <arglist>(int limit)</arglist>
    </member>
    <member kind="function">
      <type>GrossoLocatelliPullanMc &amp;</type>
      <name>sizeLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a25aefa84b83606d8210d0550c2a0f903</anchor>
      <arglist>(int limit)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>iterationLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a6feadd1a7dfa1bfd1cc6501ab754a9af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stepLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a3c8cd9a4f1cb319aef1d961408aff169</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>sizeLimit</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a1b18b4db71c587f4d3b821c8611b3e36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>TerminationCause</type>
      <name>run</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a27021ed4b4a03d839c250df3695e2048</anchor>
      <arglist>(SelectionRule rule=PENALTY_BASED)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cliqueSize</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a196e6be497b614287ff145b39a763f7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cliqueMap</name>
      <anchorfile>a00194.html</anchorfile>
      <anchor>a3f551122c9a80062d1b0e778357e9912</anchor>
      <arglist>(CliqueMap &amp;map) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GrossoLocatelliPullanMc::CliqueNodeIt</name>
    <filename>a00086.html</filename>
    <member kind="function">
      <type></type>
      <name>CliqueNodeIt</name>
      <anchorfile>a00086.html</anchorfile>
      <anchor>a6b7bfeed3a46cfebb3ff4468e39e4568</anchor>
      <arglist>(const GrossoLocatelliPullanMc &amp;mc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Node</name>
      <anchorfile>a00086.html</anchorfile>
      <anchor>a842a9fc933bc21c81d8d2790744a19b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CliqueNodeIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00086.html</anchorfile>
      <anchor>aeb4af587bf5088b1a4cef0c5a9884189</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GR::Node</type>
      <name>operator++</name>
      <anchorfile>a00086.html</anchorfile>
      <anchor>ac3fe98923f5eb6ef04f1354340d42eb5</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::HaoOrlin</name>
    <filename>a00195.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CAP</type>
      <name>CapacityMap</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a10f68c1f869f7e1be967acfbd9750290</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TOL</type>
      <name>Tolerance</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a88c54a1e77557bd8734f1729e39b2602</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HaoOrlin</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>ab03a48e815fb5a8af4274cccd705a33c</anchor>
      <arglist>(const Digraph &amp;graph, const CapacityMap &amp;capacity, const Tolerance &amp;tolerance=Tolerance())</arglist>
    </member>
    <member kind="function">
      <type>HaoOrlin &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>ab801f9b363cf5bc1c949500098ffea71</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a02fd73d861ef2e4aabb38c0c9ff82947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a7cb8fc3003223031b35f3ba5fcfb2762</anchor>
      <arglist>(const Node &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>calculateOut</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>ae495b2edefc81e20b797ee5b125d3955</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>calculateIn</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a3b2a8b9cda4a87593c4fdfc44afa15d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a429ed28d5b8fc2fd63dde71155213753</anchor>
      <arglist>(const Node &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>minCutValue</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a6c236438cfb06210690188638d87b164</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>minCutMap</name>
      <anchorfile>a00195.html</anchorfile>
      <anchor>a1efe701f7c90a1ccb15181f5257e5841</anchor>
      <arglist>(CutMap &amp;cutMap) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HartmannOrlinMmcDefaultTraits</name>
    <filename>a00197.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CostMap::Value</type>
      <name>Cost</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>ac9e9deaccf259b5931d867b0790c1e01</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>LargeCost</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>abb5b2df15a07785723c3202702c06a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Tolerance&lt; LargeCost &gt;</type>
      <name>Tolerance</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>a1a087d7bb62d1a766aa6809f2fe4a336</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00197.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::HartmannOrlinMmc</name>
    <filename>a00196.html</filename>
    <templarg>GR</templarg>
    <templarg>CM</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::HartmannOrlinMmc::SetLargeCost</class>
    <class kind="struct">lemon::HartmannOrlinMmc::SetPath</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Cost</type>
      <name>Cost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Path</type>
      <name>Path</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a2bf16fe287f8f8c6a0c95230c37874fb</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a450cbf24c0df4789fa74034e022a6a07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a11bb3e453480141f93ec001a9d99e4f4</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6a7cd185bc451dbc77a95cbf7a6fbae</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HartmannOrlinMmc::SetLargeCost</name>
    <filename>a00363.html</filename>
    <templarg></templarg>
    <base>HartmannOrlinMmc&lt; GR, CM, SetLargeCostTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a2bf16fe287f8f8c6a0c95230c37874fb</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a450cbf24c0df4789fa74034e022a6a07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a11bb3e453480141f93ec001a9d99e4f4</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6a7cd185bc451dbc77a95cbf7a6fbae</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HartmannOrlinMmc::SetPath</name>
    <filename>a00367.html</filename>
    <templarg></templarg>
    <base>HartmannOrlinMmc&lt; GR, CM, SetPathTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a2bf16fe287f8f8c6a0c95230c37874fb</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HartmannOrlinMmc</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a450cbf24c0df4789fa74034e022a6a07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a11bb3e453480141f93ec001a9d99e4f4</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HartmannOrlinMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad6a7cd185bc451dbc77a95cbf7a6fbae</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00196.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HowardMmcDefaultTraits</name>
    <filename>a00201.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CostMap::Value</type>
      <name>Cost</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>ac9e9deaccf259b5931d867b0790c1e01</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>LargeCost</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>abb5b2df15a07785723c3202702c06a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Tolerance&lt; LargeCost &gt;</type>
      <name>Tolerance</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>a1a087d7bb62d1a766aa6809f2fe4a336</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00201.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::HowardMmc</name>
    <filename>a00200.html</filename>
    <templarg>GR</templarg>
    <templarg>CM</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::HowardMmc::SetLargeCost</class>
    <class kind="struct">lemon::HowardMmc::SetPath</class>
    <member kind="enumeration">
      <type></type>
      <name>TerminationCause</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NO_CYCLE</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa6c4be8160712c6eb310fc38fc076def4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTIMAL</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa2579881e7c83261bc21bafb5a5c92cad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ITERATION_LIMIT</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79fa2ae51471aa8024ea15450efeae10bf37</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Cost</type>
      <name>Cost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Path</type>
      <name>Path</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a77813a4da215372de0ce94332beeb464</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ac811653debf31cbb1f3e011b4d20f8ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3d7c8670b6ad06a7a59cd1b8bf7a93af</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad70e6702783c845ea10741eb16c25309</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TerminationCause</type>
      <name>findCycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a40baec0badd97cf8024aab2332e630b1</anchor>
      <arglist>(int limit=std::numeric_limits&lt; int &gt;::max())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HowardMmc::SetLargeCost</name>
    <filename>a00362.html</filename>
    <templarg></templarg>
    <base>HowardMmc&lt; GR, CM, SetLargeCostTraits&lt; T &gt; &gt;</base>
    <member kind="enumeration">
      <type></type>
      <name>TerminationCause</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a77813a4da215372de0ce94332beeb464</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ac811653debf31cbb1f3e011b4d20f8ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3d7c8670b6ad06a7a59cd1b8bf7a93af</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad70e6702783c845ea10741eb16c25309</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TerminationCause</type>
      <name>findCycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a40baec0badd97cf8024aab2332e630b1</anchor>
      <arglist>(int limit=std::numeric_limits&lt; int &gt;::max())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::HowardMmc::SetPath</name>
    <filename>a00370.html</filename>
    <templarg></templarg>
    <base>HowardMmc&lt; GR, CM, SetPathTraits&lt; T &gt; &gt;</base>
    <member kind="enumeration">
      <type></type>
      <name>TerminationCause</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a70e8fb7e2e48605883db4d1109a5f79f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a77813a4da215372de0ce94332beeb464</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~HowardMmc</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ac811653debf31cbb1f3e011b4d20f8ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a3d7c8670b6ad06a7a59cd1b8bf7a93af</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>HowardMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad70e6702783c845ea10741eb16c25309</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TerminationCause</type>
      <name>findCycleMean</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a40baec0badd97cf8024aab2332e630b1</anchor>
      <arglist>(int limit=std::numeric_limits&lt; int &gt;::max())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00200.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::HypercubeGraph</name>
    <filename>a00202.html</filename>
    <class kind="class">lemon::HypercubeGraph::HyperMap</class>
    <member kind="function">
      <type></type>
      <name>HypercubeGraph</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>ad1e0bae8743a52a5f67cd18ece720412</anchor>
      <arglist>(int dim)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>aa11cd627b0f18c3a1655de9c102baab4</anchor>
      <arglist>(int dim)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimension</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>ae5acbe47d704ceb866e3717e2ac9422f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>projection</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>aa4f046f67ab074dd0e845f6db83e28fe</anchor>
      <arglist>(Node node, int n) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimension</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>a1db28f13c190465563114f211fab6b87</anchor>
      <arglist>(Edge edge) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimension</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>a968b113f3f1be8e6b7279963ba699c26</anchor>
      <arglist>(Arc arc) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>operator()</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>acbd2e4abdacde884248a2cd28de06aa7</anchor>
      <arglist>(int ix) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nodeNum</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>af9239a81c840ea4b094b196b6f164fcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>edgeNum</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>a484eca76dda3fe1ceaff8073db17e38e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>arcNum</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>a9cda7016f5de299b88f32cf63edee345</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>index</name>
      <anchorfile>a00202.html</anchorfile>
      <anchor>a0822a1cdb568cfae93bfe5856555e302</anchor>
      <arglist>(Node node)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::HypercubeGraph::HyperMap</name>
    <filename>a00203.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Node</type>
      <name>Key</name>
      <anchorfile>a00203.html</anchorfile>
      <anchor>ae05d965da541abbbd35cc532b534496d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>Value</name>
      <anchorfile>a00203.html</anchorfile>
      <anchor>a34b57a974fe67a997b7693e6e71cd904</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HyperMap</name>
      <anchorfile>a00203.html</anchorfile>
      <anchor>af3bfe46c9fac0e4f8ebd92acc2488a4d</anchor>
      <arglist>(const Graph &amp;graph, It begin, It end, T fv=0, const BF &amp;bf=BF())</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00203.html</anchorfile>
      <anchor>ab9c10eb597919bcf35b4c1d1a1e23ddc</anchor>
      <arglist>(const Key &amp;k) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::InsertionTsp</name>
    <filename>a00216.html</filename>
    <templarg></templarg>
    <member kind="enumeration">
      <type></type>
      <name>SelectionRule</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NEAREST</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708ea32bf899c26ebe34101c3c9d15e41b77e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FARTHEST</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708ead73e1b65eca2da53f94a949e05a87024</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CHEAPEST</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708eada1238009cd01c6b46222cb976f757be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RANDOM</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a434cb6429f314a1e6ea1c4f2d262708eaa2b65445a3a16f164c5e811064d75726</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM::Value</type>
      <name>Cost</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a1a1dfba092aeec4656ebceaf99ca8b22</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InsertionTsp</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a8316232e57bedff6d679489e98bb46a7</anchor>
      <arglist>(const FullGraph &amp;gr, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>run</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a2411da8896788ee2307b9d283f9519da</anchor>
      <arglist>(SelectionRule rule=FARTHEST)</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>tourCost</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a2b50553673232826084189a99f3ed9ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; Node &gt; &amp;</type>
      <name>tourNodes</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a81073828a7db97f717d815d40b7d129f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tourNodes</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a010a65e00187b4a154800b5e0b113cd3</anchor>
      <arglist>(Iterator out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tour</name>
      <anchorfile>a00216.html</anchorfile>
      <anchor>a15eae02ecc81a0f40b2ee2f76b478a6c</anchor>
      <arglist>(Path &amp;path) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::KarpMmcDefaultTraits</name>
    <filename>a00235.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>GR</type>
      <name>Digraph</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>af108349b07bd3b361cfa1387c19395ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CM</type>
      <name>CostMap</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>a0e4fe3b3bd126f464294f661c36a61d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CostMap::Value</type>
      <name>Cost</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>ac9e9deaccf259b5931d867b0790c1e01</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>LargeCost</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>abb5b2df15a07785723c3202702c06a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Tolerance&lt; LargeCost &gt;</type>
      <name>Tolerance</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>a1a087d7bb62d1a766aa6809f2fe4a336</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lemon::Path&lt; Digraph &gt;</type>
      <name>Path</name>
      <anchorfile>a00235.html</anchorfile>
      <anchor>a6989b0a22a99c251a2e7c99cf36605ea</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::KarpMmc</name>
    <filename>a00234.html</filename>
    <templarg>GR</templarg>
    <templarg>CM</templarg>
    <templarg>TR</templarg>
    <class kind="struct">lemon::KarpMmc::SetLargeCost</class>
    <class kind="struct">lemon::KarpMmc::SetPath</class>
    <member kind="typedef">
      <type>TR::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Cost</type>
      <name>Cost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR::Path</type>
      <name>Path</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TR</type>
      <name>Traits</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a1faa7ea10aa24f717f26008b7c789bc7</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acb28cdc9fb89b896526a729aaa21a0cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>aa22fa56570a94c95f01c82c60b2f225b</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a8dcc55d4659a07db06264d61d4f65d43</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::KarpMmc::SetLargeCost</name>
    <filename>a00360.html</filename>
    <templarg></templarg>
    <base>KarpMmc&lt; GR, CM, SetLargeCostTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetLargeCostTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a1faa7ea10aa24f717f26008b7c789bc7</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acb28cdc9fb89b896526a729aaa21a0cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>aa22fa56570a94c95f01c82c60b2f225b</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a8dcc55d4659a07db06264d61d4f65d43</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>lemon::KarpMmc::SetPath</name>
    <filename>a00369.html</filename>
    <templarg></templarg>
    <base>KarpMmc&lt; GR, CM, SetPathTraits&lt; T &gt; &gt;</base>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Digraph</type>
      <name>Digraph</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a750f38b47fd56ef715849c3bd77fbe77</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::CostMap</type>
      <name>CostMap</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a3a2252844f4d7748442eb48a6907f379</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Cost</type>
      <name>Cost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a9142822eba184f2778b6aac70b0900b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::LargeCost</type>
      <name>LargeCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a7f34159326618acfb683317c3df26662</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Tolerance</type>
      <name>Tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a35e771685a474e678b13c4de43711c7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;::Path</type>
      <name>Path</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad6d7757da799220a95281fbee4d3fb8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SetPathTraits&lt; T &gt;</type>
      <name>Traits</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab157e5452122f7a7f73dfda5ed931d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a1faa7ea10aa24f717f26008b7c789bc7</anchor>
      <arglist>(const Digraph &amp;digraph, const CostMap &amp;cost)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KarpMmc</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acb28cdc9fb89b896526a729aaa21a0cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>aa22fa56570a94c95f01c82c60b2f225b</anchor>
      <arglist>(Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>KarpMmc &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a8dcc55d4659a07db06264d61d4f65d43</anchor>
      <arglist>(const Tolerance &amp;tolerance)</arglist>
    </member>
    <member kind="function">
      <type>const Tolerance &amp;</type>
      <name>tolerance</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a0fe880b3588576694de2dbfb22a4e6fc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>const Path &amp;</type>
      <name>cycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ab9a6410150597b4b340766223c85235e</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>Cost</type>
      <name>cycleCost</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>ad74b8529d86bb2a0bd05aef7c522e2bc</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cycleSize</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a85e022e3cc354809e5b5b3e51ef9c2a3</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>cycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>acbba39e9062d9b96150a918513b69b0a</anchor>
      <arglist>() const</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>run</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a149ad6701e3e2414cb566bb414029841</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycleMean</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a6f2b5b662ec988c85c00724b45b3d303</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findCycle</name>
      <anchorfile>a00234.html</anchorfile>
      <anchor>a073361e707d4e223b592a796a7c691a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DigraphReader</name>
    <filename>a00131.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DigraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>aa4f1971218572095cd881516767c8cf3</anchor>
      <arglist>(DGR &amp;digraph, std::istream &amp;is=std::cin)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DigraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>ae8b85afb216acee67f9648314e5bb8ed</anchor>
      <arglist>(DGR &amp;digraph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DigraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>ab60d1946d7d28dc4bf847726c6b68b1a</anchor>
      <arglist>(DGR &amp;digraph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DigraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a5d63771eeca810885446a254547d2864</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a6a0b6a80a9f5bd2a976762d3463e9cad</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a91589f7d20cfdc9bfc69e8726de0a962</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>af6ab23304f9807e851f2d07f0c7d9203</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a276a22804e7ebc619a227f69d6f6e119</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a4b9275dfecf669021ae6a989c76b47fa</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a25e0aebad2077e56971e41799bf860b5</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>node</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a985b127665d31db2820cbd9fde869a7a</anchor>
      <arglist>(const std::string &amp;caption, Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>arc</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>aaf97021ab62753411ca5bdd11c8b6891</anchor>
      <arglist>(const std::string &amp;caption, Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>nodes</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a4c23dbc9b67a31251da30029d32d3a3d</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>arcs</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a62c9846f3883712c703c58389a8c24f7</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>attributes</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>af774f0641b0e24afa95f176c518ceb78</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a13ac753d5243bef695cdeca82baeb582</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a39a6f84d9c1aa69f03f2de116dd00dd8</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>useArcs</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a1d828d2e6e4d76887da0a3904a100519</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>useArcs</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a0067eb498e5ab91f25cd292929a999f5</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a2c1a0a6fc8364af63b4f446f66e3c675</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader &amp;</type>
      <name>skipArcs</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>adb2dec97e14950c802945264144bf7b7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader&lt; TDGR &gt;</type>
      <name>digraphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga48193af2c3b59a015d51b20f071a1514</anchor>
      <arglist>(TDGR &amp;digraph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader&lt; TDGR &gt;</type>
      <name>digraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>ab8831c8cea0389934dc66d41f27bd734</anchor>
      <arglist>(TDGR &amp;digraph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>DigraphReader&lt; TDGR &gt;</type>
      <name>digraphReader</name>
      <anchorfile>a00131.html</anchorfile>
      <anchor>a4b31ee93558806ecdd13525b05047859</anchor>
      <arglist>(TDGR &amp;digraph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GraphReader</name>
    <filename>a00189.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>GraphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>ad0d38d468b2bab5026101734a162702b</anchor>
      <arglist>(GR &amp;graph, std::istream &amp;is=std::cin)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a4b7d9443c22683c2efa9edfd85326da1</anchor>
      <arglist>(GR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a4a91fbd433d48e5553bf2f8532eedc2a</anchor>
      <arglist>(GR &amp;graph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GraphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a602ecd8550acd9a47d3e845046dedc46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a720aac417a10a30f0af145afb314e873</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>aa16cd6d00901a250114e69a2e0f51faa</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a7ec9b3ce7eb6402614c5c1a14e068392</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a31efbf80b253438bcba78b8252eacd73</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a2d368171cae20ef6a88dd67d516c9920</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>aa77414eba08f7a41e7919c56cea655b1</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>aefc73e66afc1dc6f7f5d1f14398bca5e</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a38640ad634f71244eb49e544d7180ee8</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>node</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a935bba5e66fdd35b12fcdbef9a6d9d19</anchor>
      <arglist>(const std::string &amp;caption, Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>edge</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a2a2aa1c80b27367bd2dcf27ded51780e</anchor>
      <arglist>(const std::string &amp;caption, Edge &amp;edge)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>arc</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a57595f8f77dcd876743db6735d98d6a1</anchor>
      <arglist>(const std::string &amp;caption, Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>nodes</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a1d460fd7a3dda23c377cc030273e7a4e</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>edges</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a2325d91e1fffd75860a83e76a0d9dd32</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>attributes</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>af685594e06cd5d28ea88d79f9a9dcb8c</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a687f5f5f4a691e00b306535a9bb488f9</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>ae7abcf0bf8a1c65e6bfad2b4d3a31780</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>useEdges</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a96d4e7917de064f3be15c82716de81cb</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>useEdges</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a94e655491e76d4eb9adeb2d2ec517d3f</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a136054a5ccb371c0fcc1a45294d2a5e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphReader &amp;</type>
      <name>skipEdges</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>aa655ba72248a83e55b0f6f5cf1ffb78d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphReader&lt; TGR &gt;</type>
      <name>graphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gafdffb110416b03a63e3486f8736b2c6c</anchor>
      <arglist>(TGR &amp;graph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader&lt; TGR &gt;</type>
      <name>graphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>a18af167a68f1b4eb2ce2d9f74389f864</anchor>
      <arglist>(TGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>GraphReader&lt; TGR &gt;</type>
      <name>graphReader</name>
      <anchorfile>a00189.html</anchorfile>
      <anchor>adced1af678fe6ed1c716518ffe4ba0bd</anchor>
      <arglist>(TGR &amp;graph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BpGraphReader</name>
    <filename>a00071.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>BpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a88745f51d8ac816a26371e0f66cea862</anchor>
      <arglist>(BGR &amp;graph, std::istream &amp;is=std::cin)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>af783d24ca61f07a4aae11767d72e8bda</anchor>
      <arglist>(BGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ad71be94c948a99479a553903209358eb</anchor>
      <arglist>(BGR &amp;graph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>aa4883c163e7c2c79c4c86118e4da3d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ac8b6efcd20b4090d169868042458257d</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>aa2e920f458447f84e720a59f62934db7</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>redNodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ab7c7c8e74fe080fb83b2cf4ede194663</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>redNodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>aba8e3bb72d27935f52337f5174770b6b</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>blueNodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a8fbad5d4ce89865ea0e0159e4895c202</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>blueNodeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a16706724fd689868db19b5be9695d237</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>abf5fa4dd00d952592231c59861fdf7f2</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ad744b551856b197b6ccc02656430c8f5</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>af48f1a6862ad679d9b99a943aca56cfe</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a78736e343f3469ba3782aa8c625a6ba0</anchor>
      <arglist>(const std::string &amp;caption, Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a317e273f96de56862e8d4d82b70d35d5</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>attribute</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ac5a51274b36be8db737138a3c7608e10</anchor>
      <arglist>(const std::string &amp;caption, Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>node</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a991a52022567ed4721c4d8100b81c241</anchor>
      <arglist>(const std::string &amp;caption, Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>redNode</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a1a0327ebbf1e65a31ed0d813d2b067fc</anchor>
      <arglist>(const std::string &amp;caption, RedNode &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>blueNode</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a0ce7b775895f96195a77b36583e99043</anchor>
      <arglist>(const std::string &amp;caption, BlueNode &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>edge</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a8375c556f9ddcad15fdc6c594482ef29</anchor>
      <arglist>(const std::string &amp;caption, Edge &amp;edge)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>arc</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>af58c7933140c4af65f339798183f9151</anchor>
      <arglist>(const std::string &amp;caption, Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>nodes</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ac45d9122e97af4cea8ee2fc087c7be35</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>edges</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ac931051eab846fe73858b72dc9c55b29</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>attributes</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a64a6aec8ff7a6491ea07159b5a64e7dd</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a967ff6fe896537268eda5001bfa824be</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>useNodes</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a8e7c71c0db9f74ade1c54a4443b619ca</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>useEdges</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a7a622802539d93b3a7859ecc342b306e</anchor>
      <arglist>(const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>useEdges</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>ae3bf4e666878b4044077b1c8377bc7d5</anchor>
      <arglist>(const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a1af12c3d8c6cc46b6c91b64aa9986ebf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader &amp;</type>
      <name>skipEdges</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a588194147a931ac5b5654ef3562d6e0a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader&lt; TBGR &gt;</type>
      <name>bpGraphReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gac4c1c8a87aed10ee29c691b70267927d</anchor>
      <arglist>(TBGR &amp;graph, std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader&lt; TBGR &gt;</type>
      <name>bpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>aa48627599fd66b358bf4d3e584218cc8</anchor>
      <arglist>(TBGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphReader&lt; TBGR &gt;</type>
      <name>bpGraphReader</name>
      <anchorfile>a00071.html</anchorfile>
      <anchor>a10e90a74ce40baac631766fec038462d</anchor>
      <arglist>(TBGR &amp;graph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SectionReader</name>
    <filename>a00339.html</filename>
    <member kind="function">
      <type></type>
      <name>SectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>ad2864b0251911b45ddb7198c16480b5b</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a010d719af4f7dee3d1fb4b94189fec28</anchor>
      <arglist>(const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a497d304493c028916e5e0c2439d5aadf</anchor>
      <arglist>(const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a06ff4579ab6965f6e6bc29ad7ed3fb8b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SectionReader &amp;</type>
      <name>sectionLines</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a75de482c5db00c94c7ced5cbfb5fa4da</anchor>
      <arglist>(const std::string &amp;type, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>SectionReader &amp;</type>
      <name>sectionStream</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a00ba764e5d7b9d62e4db6c96ec43684a</anchor>
      <arglist>(const std::string &amp;type, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SectionReader</type>
      <name>sectionReader</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga919ce27a20ac3228c90a85310a64fa4c</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>SectionReader</type>
      <name>sectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>adeb72981c0553e45dd6b5bc63e9c23e8</anchor>
      <arglist>(const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>SectionReader</type>
      <name>sectionReader</name>
      <anchorfile>a00339.html</anchorfile>
      <anchor>a1375da7ad660a4fc871bd6ffab94a5d9</anchor>
      <arglist>(const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LgfContents</name>
    <filename>a00237.html</filename>
    <member kind="function">
      <type></type>
      <name>LgfContents</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a354d20288c783068888642817d4201fb</anchor>
      <arglist>(std::istream &amp;is)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LgfContents</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a8504ecb1b857fd19df24823e811d3140</anchor>
      <arglist>(const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LgfContents</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>adf863a29229b03c84b76d174dfc355cb</anchor>
      <arglist>(const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~LgfContents</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>aeafd3f08b75c187e55c1c89ec0962248</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nodeSectionNum</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a0f0562a9333abeba58c88845b159de7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>nodeSection</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a78e7a2d329efcc77ca146b885820c75b</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; std::string &gt; &amp;</type>
      <name>nodeMapNames</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a92307f04de9d1b9e5dae316db3f5b4d4</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>arcSectionNum</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a5a0b06032f70759300fb4930e01b0cff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>arcSection</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a496e861ccb7814a611e011a46318bce5</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; std::string &gt; &amp;</type>
      <name>arcMapNames</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a5a1d1325c20b0e302280fd34a9e4da54</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>edgeSectionNum</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a311228579d1d35898483877a3249d1ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>edgeSection</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a830fe61608acc498369987ba092d0efa</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; std::string &gt; &amp;</type>
      <name>edgeMapNames</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a83f56d761582fe384e0201db89c03f34</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>attributeSectionNum</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>afc01b23cca378311e7e64cf1cb0e4eb2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>attributeSectionNames</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a7b8bf07432f2190469a78c9a517879c7</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; std::string &gt; &amp;</type>
      <name>attributes</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a2ad5b2157e7a47659c89840ed7ac0554</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>extraSectionNum</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a38b8fdd565b6b2c66d96377a4dbf6999</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>extraSection</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>aa290e43b6bf815f418e90c08ac473b3e</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00237.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::DigraphWriter</name>
    <filename>a00132.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>DigraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a74ad76e5a2254925c5adabd4088819b6</anchor>
      <arglist>(const DGR &amp;digraph, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DigraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a3ee5445ac5f1f877cc947ae7acc609fb</anchor>
      <arglist>(const DGR &amp;digraph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DigraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a1e5c1f2228d2fc8940d99e9cd6d1e582</anchor>
      <arglist>(const DGR &amp;digraph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DigraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a2135241b28f87dccd8933a761ea27c6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a9ca0acd70b65c8c2df07c3194c758a04</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a0bb989bfb3ed851fb7c8448d13883e61</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a1b1215b1368d57c7315b065c2ff7f8f8</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a93f4485d66ccf09df7aa2a7a12222ef3</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a019585d8f993ce64033f1566c26020a1</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>af71c16576177fbbac037b918c4bd22ac</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>node</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a9994c9b8fa00a16560ab6c24c299c93f</anchor>
      <arglist>(const std::string &amp;caption, const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>arc</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a90fc30773d46a50471993f554e21a4bc</anchor>
      <arglist>(const std::string &amp;caption, const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>nodes</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>ad45ae417635ab38e9f11926e033ce84d</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>arcs</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a30c9c7bebf1120893029cf8016625d5d</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>attributes</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>ae7f4dfd9c6254bdb19963abf87676d33</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>abaa48d206e2c370290d6de539400f885</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter &amp;</type>
      <name>skipArcs</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a96343892ef6a0d31a1398b739db13ed5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>ostream</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a0df4c16f48d0e3c9c5c0cd8a55d5b183</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter&lt; TDGR &gt;</type>
      <name>digraphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga69cc9c420f57bb132a8d2fc079b83494</anchor>
      <arglist>(const TDGR &amp;digraph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter&lt; TDGR &gt;</type>
      <name>digraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>a988760df01bdd20ca0e4635d830fd3af</anchor>
      <arglist>(const TDGR &amp;digraph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>DigraphWriter&lt; TDGR &gt;</type>
      <name>digraphWriter</name>
      <anchorfile>a00132.html</anchorfile>
      <anchor>aa0d23c1be57ca609a422add4096ef5b9</anchor>
      <arglist>(const TDGR &amp;digraph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::GraphWriter</name>
    <filename>a00191.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>GraphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a048dd7d5e27e1c30f96e979f92f4ea3d</anchor>
      <arglist>(const GR &amp;graph, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a6a03481bb09c2fdfe5371fc1cd6e90ea</anchor>
      <arglist>(const GR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>af23c37b427913cc3a001edb841e4ca85</anchor>
      <arglist>(const GR &amp;graph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GraphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a6da7b22b11b0cf823181f0e9847e3826</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>abaf355404ffb320000b96bd2b57bb7c1</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a7f64b489d5f69fabc7cc15df058ab6a5</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>aa4a8bcebd59cabe0328fcdaab8d67dca</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>ae695b86045e4d3606775ab9f551959e6</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>adf98b39abb41cdaaa4ce972b1902b92b</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>ac211b62945a3e517a42676d5a330570e</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>ad81e5f81a810749cdd93638970ac793a</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a4adb919d0bea4ae00b2c6477720711a8</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>node</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a210e737325b8a2d0990a66ff75639bec</anchor>
      <arglist>(const std::string &amp;caption, const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>edge</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a0a9ebc6f70e74576359e08de9eeafd38</anchor>
      <arglist>(const std::string &amp;caption, const Edge &amp;edge)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>arc</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a7e6b1f036ccc517c53c26ab6151dadad</anchor>
      <arglist>(const std::string &amp;caption, const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>nodes</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>ad6e3b29651b774389d42facc4a718822</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>edges</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a9f4d25e108365bcc0c8d8df345a4ea32</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>attributes</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>ae5ca855de0e76c596f49e8a728af5841</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a7cac69b6df6f805859aa6382f72a9024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter &amp;</type>
      <name>skipEdges</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a55b1bc7b7d913f1a0a1e05134cede4db</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>ostream</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a0df4c16f48d0e3c9c5c0cd8a55d5b183</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter&lt; TGR &gt;</type>
      <name>graphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>gae03a34e019c92c5383b4d4a188a3bae0</anchor>
      <arglist>(const TGR &amp;graph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter&lt; TGR &gt;</type>
      <name>graphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a0253738e23b139b13b4dd59226975a14</anchor>
      <arglist>(const TGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>GraphWriter&lt; TGR &gt;</type>
      <name>graphWriter</name>
      <anchorfile>a00191.html</anchorfile>
      <anchor>a62d67c675daa12f93ea7f37f616f61de</anchor>
      <arglist>(const TGR &amp;graph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::BpGraphWriter</name>
    <filename>a00072.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>BpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a82dea74da2ecb88894b83fd8ba401840</anchor>
      <arglist>(const BGR &amp;graph, std::ostream &amp;os=std::cout)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a9bcb6ded882fda6a0bd45483c3146fef</anchor>
      <arglist>(const BGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a0b9168912b6506f044df3dc6b68a0d2c</anchor>
      <arglist>(const BGR &amp;graph, const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a89f7705d18856862401c708092224016</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>af1b97489f216f1c806eb4096575a0500</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>nodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a5bbb38ef7863155448912144ce92b77a</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>redNodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>abddd51f300f16897006fd9e0761e5755</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>redNodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a94ad1dcdd00bf196970b1a12df69b7e8</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>blueNodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ab1ce984489e5347ce767c9ee8beb62c2</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>blueNodeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ac069048f2e60a1ee2121afda1cf9199e</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a02fd7509dcc4f1038515108296030d69</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>edgeMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a076b87abf2df1e3b2df1bd268cdfb377</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ae5a624bd0bb5dc02f749ed1f6a80aceb</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>arcMap</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a75c9ffced54391ca382a411823e7df4d</anchor>
      <arglist>(const std::string &amp;caption, const Map &amp;map, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>adf3f89ad459134ea9aee788a06a69214</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>attribute</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ac92ed83d119e8bd09bc528cfbb163eeb</anchor>
      <arglist>(const std::string &amp;caption, const Value &amp;value, const Converter &amp;converter=Converter())</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>node</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ab0dc7dbf20525cac41f12b7d2b7b1574</anchor>
      <arglist>(const std::string &amp;caption, const Node &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>redNode</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>ae79b56d2a4841e756c020b5de10e1731</anchor>
      <arglist>(const std::string &amp;caption, const RedNode &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>blueNode</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>aadf06ab58aa955969de68c3fe68c85bd</anchor>
      <arglist>(const std::string &amp;caption, const BlueNode &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>edge</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>aa52de308f1e125dbb0e24b8d9f66b090</anchor>
      <arglist>(const std::string &amp;caption, const Edge &amp;edge)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>arc</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a909cbe357276ffd84277fb1346ed8a49</anchor>
      <arglist>(const std::string &amp;caption, const Arc &amp;arc)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>nodes</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>adaf3b737b38de1004d2baa6adc63849f</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>edges</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a165ffc263d449781bbbda0181d655835</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>attributes</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a5ab23294bba5467cf50d8882cfa2d3d1</anchor>
      <arglist>(const std::string &amp;caption)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>skipNodes</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a5c5a7a83d285d6d885c25699ffb04b45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter &amp;</type>
      <name>skipEdges</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a5995feb7da40100bfe36d8ae892c817c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>ostream</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a0df4c16f48d0e3c9c5c0cd8a55d5b183</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter&lt; TBGR &gt;</type>
      <name>bpGraphWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga501cff32bd7af38690224e42bf85bea8</anchor>
      <arglist>(const TBGR &amp;graph, std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter&lt; TBGR &gt;</type>
      <name>bpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a9e35f031f911615b2f6fb6d60ba3d992</anchor>
      <arglist>(const TBGR &amp;graph, const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>BpGraphWriter&lt; TBGR &gt;</type>
      <name>bpGraphWriter</name>
      <anchorfile>a00072.html</anchorfile>
      <anchor>a39f67270f684dfcadd499b32111caa04</anchor>
      <arglist>(const TBGR &amp;graph, const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SectionWriter</name>
    <filename>a00340.html</filename>
    <member kind="function">
      <type></type>
      <name>SectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a50c0a7f10e3cb6d13b6fc2623b276c68</anchor>
      <arglist>(std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>adf73bee6769d11d70550d9ed4e7cd024</anchor>
      <arglist>(const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a428bbe8f1ff7af0ea09509cb4e37d05d</anchor>
      <arglist>(const char *fn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a2a9c8674573054e789efd12de05635e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter &amp;</type>
      <name>sectionLines</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>af6bef4811cb128a4f62077d0fabe5f85</anchor>
      <arglist>(const std::string &amp;type, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter &amp;</type>
      <name>sectionStream</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>af70c667d00b83869f00b28cd84668708</anchor>
      <arglist>(const std::string &amp;type, Functor functor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a13a43e6d814de94978c515cb084873b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>ostream</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a0df4c16f48d0e3c9c5c0cd8a55d5b183</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter</type>
      <name>sectionWriter</name>
      <anchorfile>a00629.html</anchorfile>
      <anchor>ga6bc4578acf71f56b06729191b8463779</anchor>
      <arglist>(std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter</type>
      <name>sectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>af7c98afec48ac900d4af8e89c418ee17</anchor>
      <arglist>(const std::string &amp;fn)</arglist>
    </member>
    <member kind="function">
      <type>SectionWriter</type>
      <name>sectionWriter</name>
      <anchorfile>a00340.html</anchorfile>
      <anchor>a1b3a56982483d38ab84cd05073a37c0e</anchor>
      <arglist>(const char *fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListDigraph</name>
    <filename>a00242.html</filename>
    <class kind="class">lemon::ListDigraph::Snapshot</class>
    <member kind="function">
      <type></type>
      <name>ListDigraph</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>abff6c0f71f9067a36468f2919edcac51</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>addNode</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a96838566b12a6b04795db38688bad1a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Arc</type>
      <name>addArc</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>af90c0ea6fc0a0e7454657e710e8f4d0b</anchor>
      <arglist>(Node s, Node t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a74e3b0d27f7587faa2d169a0856ff817</anchor>
      <arglist>(Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a2a4c77c93b4d1a5a924eef37bd92a051</anchor>
      <arglist>(Arc a)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>aa088e41ac5858620d94572f4af0b821f</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>ac31ad29081023b5df42a7b08e3b44cb4</anchor>
      <arglist>(Arc a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeTarget</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>abfb074c8c3ead2adee735878dd221ed3</anchor>
      <arglist>(Arc a, Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeSource</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a20b4f4bf5bad96ec675f077f4b87f349</anchor>
      <arglist>(Arc a, Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reverseArc</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>ae6cde4a094668807fd07c7971c82a674</anchor>
      <arglist>(Arc a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>contract</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a78af55bb4a485dbbddd7f3fdfd4f0394</anchor>
      <arglist>(Node u, Node v, bool r=true)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>split</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a09a307979f5ac51cc21195285d485bbe</anchor>
      <arglist>(Node n, bool connect=true)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>split</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a0d05a19404323aea84d5d692f9b6fa21</anchor>
      <arglist>(Arc a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveNode</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a28bb4df827e678ae549849be81d88def</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveArc</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a2489cbecb9d7ff5c9a0b2b5ee46818b5</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function" protection="private">
      <type></type>
      <name>ListDigraph</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>ad28967a7a041da94e00e954c4e6861e6</anchor>
      <arglist>(const ListDigraph &amp;)</arglist>
    </member>
    <member kind="function" protection="private">
      <type>void</type>
      <name>operator=</name>
      <anchorfile>a00242.html</anchorfile>
      <anchor>a85a3026571948df8a0247aa2ce972411</anchor>
      <arglist>(const ListDigraph &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListDigraph::Snapshot</name>
    <filename>a00407.html</filename>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00407.html</anchorfile>
      <anchor>a8d35bcf9a5efab747b3b3603ac2861de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00407.html</anchorfile>
      <anchor>a365be677d5eca587e41118d2574830db</anchor>
      <arglist>(ListDigraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>a00407.html</anchorfile>
      <anchor>a28b169a59c705ee32e71a74ceaa2586a</anchor>
      <arglist>(ListDigraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restore</name>
      <anchorfile>a00407.html</anchorfile>
      <anchor>afd3595051be2709847c2de4352f27cf5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00407.html</anchorfile>
      <anchor>a8d985300b138b6c5556ab17ed4df3b38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListGraph</name>
    <filename>a00244.html</filename>
    <class kind="class">lemon::ListGraph::Snapshot</class>
    <member kind="function">
      <type></type>
      <name>ListGraph</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>abdab59515ed6ddd23a01d8e20f6d916c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>addNode</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a96838566b12a6b04795db38688bad1a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>addEdge</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a1aa949747a3805ff966fd9adda94c380</anchor>
      <arglist>(Node u, Node v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a74e3b0d27f7587faa2d169a0856ff817</anchor>
      <arglist>(Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>af311a569a7d86c03db49c5e1fe62e7a4</anchor>
      <arglist>(Edge e)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>aa088e41ac5858620d94572f4af0b821f</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a55582c50a716d15504b5680d810bd5dd</anchor>
      <arglist>(Edge e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>ac31ad29081023b5df42a7b08e3b44cb4</anchor>
      <arglist>(Arc a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeU</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a38960b4669bd9a87af8f846c21806c00</anchor>
      <arglist>(Edge e, Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeV</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a9d5b624a9147ffc63eb9da04fd1a9175</anchor>
      <arglist>(Edge e, Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>contract</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a0eafaa9830d42f199765879062d495da</anchor>
      <arglist>(Node a, Node b, bool r=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveNode</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a28bb4df827e678ae549849be81d88def</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveEdge</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a0337d8e0a11c8d4d22de6265b526df1e</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function" protection="private">
      <type></type>
      <name>ListGraph</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a62812b9a8c8bedabc1aeec208cf20d46</anchor>
      <arglist>(const ListGraph &amp;)</arglist>
    </member>
    <member kind="function" protection="private">
      <type>void</type>
      <name>operator=</name>
      <anchorfile>a00244.html</anchorfile>
      <anchor>a43d393a97d113d3aa0322292047674bc</anchor>
      <arglist>(const ListGraph &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListGraph::Snapshot</name>
    <filename>a00410.html</filename>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00410.html</anchorfile>
      <anchor>a8d35bcf9a5efab747b3b3603ac2861de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00410.html</anchorfile>
      <anchor>a5eda43082bb872005149e9710bed560f</anchor>
      <arglist>(ListGraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>a00410.html</anchorfile>
      <anchor>a0a6eeea938e9dfc299f95cdd90ea40ec</anchor>
      <arglist>(ListGraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restore</name>
      <anchorfile>a00410.html</anchorfile>
      <anchor>afd3595051be2709847c2de4352f27cf5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00410.html</anchorfile>
      <anchor>a8d985300b138b6c5556ab17ed4df3b38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListBpGraph</name>
    <filename>a00241.html</filename>
    <class kind="class">lemon::ListBpGraph::Snapshot</class>
    <member kind="function">
      <type></type>
      <name>ListBpGraph</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a02bf78d75220d990389ca54107103d03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RedNode</type>
      <name>addRedNode</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a3a95276b83b5a39135c100a32e2be340</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BlueNode</type>
      <name>addBlueNode</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>aad169db9a3cf4752c8405f83099f6d47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Edge</type>
      <name>addEdge</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a440cb16e73dafeae5a3dfdc984a8f8f3</anchor>
      <arglist>(RedNode u, BlueNode v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a74e3b0d27f7587faa2d169a0856ff817</anchor>
      <arglist>(Node n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>af311a569a7d86c03db49c5e1fe62e7a4</anchor>
      <arglist>(Edge e)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>aa088e41ac5858620d94572f4af0b821f</anchor>
      <arglist>(Node n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a55582c50a716d15504b5680d810bd5dd</anchor>
      <arglist>(Edge e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>ac31ad29081023b5df42a7b08e3b44cb4</anchor>
      <arglist>(Arc a) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeRed</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a58b745cb55d320050af95b578fb4c2d5</anchor>
      <arglist>(Edge e, RedNode n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeBlue</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a7bdc15f10072d20f21bda91a1904c4f5</anchor>
      <arglist>(Edge e, BlueNode n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveNode</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a28bb4df827e678ae549849be81d88def</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserveEdge</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a0337d8e0a11c8d4d22de6265b526df1e</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function" protection="private">
      <type></type>
      <name>ListBpGraph</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>a1128d56e162dcf7ae3f7b66e240a2738</anchor>
      <arglist>(const ListBpGraph &amp;)</arglist>
    </member>
    <member kind="function" protection="private">
      <type>void</type>
      <name>operator=</name>
      <anchorfile>a00241.html</anchorfile>
      <anchor>abea6a9e7f420e76886ead048bb123002</anchor>
      <arglist>(const ListBpGraph &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::ListBpGraph::Snapshot</name>
    <filename>a00408.html</filename>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00408.html</anchorfile>
      <anchor>a8d35bcf9a5efab747b3b3603ac2861de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Snapshot</name>
      <anchorfile>a00408.html</anchorfile>
      <anchor>aabe3eb54cddf05f08935f57416adbedf</anchor>
      <arglist>(ListBpGraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>a00408.html</anchorfile>
      <anchor>a9d3f5d4232f0c7f3d7cffa4f4f82756f</anchor>
      <arglist>(ListBpGraph &amp;gr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restore</name>
      <anchorfile>a00408.html</anchorfile>
      <anchor>afd3595051be2709847c2de4352f27cf5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>a00408.html</anchorfile>
      <anchor>a8d985300b138b6c5556ab17ed4df3b38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase</name>
    <filename>a00247.html</filename>
    <class kind="class">lemon::LpBase::Col</class>
    <class kind="class">lemon::LpBase::ColIt</class>
    <class kind="class">lemon::LpBase::Constr</class>
    <class kind="class">lemon::LpBase::DualExpr</class>
    <class kind="class">lemon::LpBase::Expr</class>
    <class kind="class">lemon::LpBase::Row</class>
    <class kind="class">lemon::LpBase::RowIt</class>
    <class kind="class">lemon::LpBase::UnsupportedFormatError</class>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Col</name>
    <filename>a00090.html</filename>
    <member kind="function">
      <type></type>
      <name>Col</name>
      <anchorfile>a00090.html</anchorfile>
      <anchor>af7991549589751a29539570df31ed273</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Col</name>
      <anchorfile>a00090.html</anchorfile>
      <anchor>a5d790ffa8fab4ba0924ab12b5d5dc0ed</anchor>
      <arglist>(const Invalid &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00090.html</anchorfile>
      <anchor>a1fcdaaeb461dc659e8ec6d8511d7e6e6</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00090.html</anchorfile>
      <anchor>afa478aab745002daba63fd6deef517bb</anchor>
      <arglist>(Col c) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a00090.html</anchorfile>
      <anchor>a473d9d668be4211f0be2755393942fd5</anchor>
      <arglist>(Col c) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::ColIt</name>
    <filename>a00091.html</filename>
    <base>lemon::LpBase::Col</base>
    <member kind="function">
      <type></type>
      <name>ColIt</name>
      <anchorfile>a00091.html</anchorfile>
      <anchor>a4ff1d0672e84973c2d1160b1aed6390a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ColIt</name>
      <anchorfile>a00091.html</anchorfile>
      <anchor>a71391a941fd206fd2a29dceefaf6a3ca</anchor>
      <arglist>(const LpBase &amp;solver)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ColIt</name>
      <anchorfile>a00091.html</anchorfile>
      <anchor>a0ba710f476749e1b36032d4792eb9cb6</anchor>
      <arglist>(const Invalid &amp;)</arglist>
    </member>
    <member kind="function">
      <type>ColIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00091.html</anchorfile>
      <anchor>a5c5e13776a43ec2dfb4c2996c3af45c1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Constr</name>
    <filename>a00105.html</filename>
    <member kind="function">
      <type></type>
      <name>Constr</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a576a596598827f586a2ab82ae3e07d31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Constr</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a623d3a439f88505872161d283b760eee</anchor>
      <arglist>(Value lb, const Expr &amp;e, Value ub)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Expr &amp;</type>
      <name>expr</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>ae58c18a4a08116d6ae44604605066507</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Expr &amp;</type>
      <name>expr</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a9e29ddcd48250335b21498997ed26871</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>lowerBound</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>acd1259eac31191e948eeb2c7d988107f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>lowerBound</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>abf6c2abb7aa0b77b909acd3326858dac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>upperBound</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>af89ee4ef9d1857a45cb0189a98550b7d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>upperBound</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a8e5e406d491fe7d35590090771fff576</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lowerBounded</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>ab6159688ba275670d12037875693005a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>upperBounded</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a0b5ad3def717983fbf60c5ca5566d1b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&lt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>aba05c19e3728edb9820af4891bd9e514</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Expr &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&lt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a3a6d494d96bd77cd35d2aefbf0d817d6</anchor>
      <arglist>(const LpBase::Value &amp;e, const LpBase::Expr &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&lt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>acb01b31e7969cba02f0bdb9e510630c1</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Value &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&gt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a78444c6379b70fe3160f65a7df0b0db8</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Expr &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&gt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>ad1a4be06877b77f023219ea329646f70</anchor>
      <arglist>(const LpBase::Value &amp;e, const LpBase::Expr &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&gt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a5c753591c58902ddfffac5926b3312f2</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Value &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator==</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a33cd989df3b6f11babefd0aa1f0e116a</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Value &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator==</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>abb6f822ab9e2703ee89d33560c4a31e8</anchor>
      <arglist>(const LpBase::Expr &amp;e, const LpBase::Expr &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&lt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>af2a4b8210c5e3ffaea64c34723c25ad2</anchor>
      <arglist>(const LpBase::Value &amp;n, const LpBase::Constr &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&lt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a9632e192a5e7ea45bf320dfdb41a6a46</anchor>
      <arglist>(const LpBase::Constr &amp;c, const LpBase::Value &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&gt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>abcef5c1c71de61abbdfd7948a38dae9e</anchor>
      <arglist>(const LpBase::Value &amp;n, const LpBase::Constr &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Constr</type>
      <name>operator&gt;=</name>
      <anchorfile>a00105.html</anchorfile>
      <anchor>a1c2da2fff256f10cdeec8cd0967433c1</anchor>
      <arglist>(const LpBase::Constr &amp;c, const LpBase::Value &amp;n)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::DualExpr</name>
    <filename>a00141.html</filename>
    <class kind="class">lemon::LpBase::DualExpr::CoeffIt</class>
    <class kind="class">lemon::LpBase::DualExpr::ConstCoeffIt</class>
    <member kind="typedef">
      <type>LpBase::Row</type>
      <name>Key</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a1d3263d18e745e004485ffd0c52769ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LpBase::Value</type>
      <name>Value</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a032494d683f041c4f7747c474a044c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DualExpr</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ab17c2c35bd5ff5f16f10a42bb5a8871e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DualExpr</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a81ae7566dd55a7fa596dce65e2108807</anchor>
      <arglist>(const Row &amp;r)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a6095e9431f15568c02f142a25e0b6573</anchor>
      <arglist>(const Row &amp;r) const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>accddbed99b053afecd40ea92867c54b8</anchor>
      <arglist>(const Row &amp;r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a6435de676808f8a7c88ea1e1c3950796</anchor>
      <arglist>(const Row &amp;r, const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simplify</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>aa0a8cc3641e02a96fa39d303b0f88b3d</anchor>
      <arglist>(Value epsilon=0.0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DualExpr &amp;</type>
      <name>operator+=</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a88004d09920b531f523044e88c0b88f1</anchor>
      <arglist>(const DualExpr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>DualExpr &amp;</type>
      <name>operator-=</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ad60ab715a7a90eb935f81966f120671a</anchor>
      <arglist>(const DualExpr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>DualExpr &amp;</type>
      <name>operator*=</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ae9262dea3610bff7f0aa5482430eee09</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>DualExpr &amp;</type>
      <name>operator/=</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a2f0e09da752f2eafb4f8071ecfadea0e</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::DualExpr</type>
      <name>operator+</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ac0e09c29a447377931b706ebf8714d58</anchor>
      <arglist>(const LpBase::DualExpr &amp;a, const LpBase::DualExpr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::DualExpr</type>
      <name>operator-</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>a0276c63464b89f00e8c32688837f49a6</anchor>
      <arglist>(const LpBase::DualExpr &amp;a, const LpBase::DualExpr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::DualExpr</type>
      <name>operator*</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ae3b285a79edb32b9c8f9561e9bd20889</anchor>
      <arglist>(const LpBase::DualExpr &amp;a, const LpBase::Value &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::DualExpr</type>
      <name>operator*</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ade4dde11224713e0fe6bd57b4370b57e</anchor>
      <arglist>(const LpBase::Value &amp;a, const LpBase::DualExpr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::DualExpr</type>
      <name>operator/</name>
      <anchorfile>a00141.html</anchorfile>
      <anchor>ade6fa4ea6e3d09bfb1845dd304556969</anchor>
      <arglist>(const LpBase::DualExpr &amp;a, const LpBase::Value &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::DualExpr::CoeffIt</name>
    <filename>a00089.html</filename>
    <member kind="function">
      <type></type>
      <name>CoeffIt</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>af1d4bd086fbc47d2f405b90977ea211c</anchor>
      <arglist>(DualExpr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Row</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>ac29d373219762ca5ef8ff030149d316e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>a153207f2745305ea9d834e3ad5ad99ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>a6e19374418db2abf9484578d9718c383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CoeffIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>a039a874d8a262be17f9ce7ac3d169081</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>a9569625b6759eac56d4b4294aba9e5b2</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00089.html</anchorfile>
      <anchor>aab38b74c42b0f2581ed4917fca608efc</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::DualExpr::ConstCoeffIt</name>
    <filename>a00102.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstCoeffIt</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>a906f76a122f4e52776d7f108a8bfabed</anchor>
      <arglist>(const DualExpr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Row</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>ac29d373219762ca5ef8ff030149d316e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>a6e19374418db2abf9484578d9718c383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ConstCoeffIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>a7b10f56647ec34e697101749cae7fa92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>a9569625b6759eac56d4b4294aba9e5b2</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00102.html</anchorfile>
      <anchor>aab38b74c42b0f2581ed4917fca608efc</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Expr</name>
    <filename>a00161.html</filename>
    <class kind="class">lemon::LpBase::Expr::CoeffIt</class>
    <class kind="class">lemon::LpBase::Expr::ConstCoeffIt</class>
    <member kind="typedef">
      <type>LpBase::Col</type>
      <name>Key</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>abfaaaa30fd6c82b0a45041e2f5ba58b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>LpBase::Value</type>
      <name>Value</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a032494d683f041c4f7747c474a044c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Expr</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>abc3c54e9ecf73d4054d8ef45fdbb6a54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Expr</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a0c91aa73ea30ab88abdac335b18de1f8</anchor>
      <arglist>(const Col &amp;c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Expr</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a692099ab161f0bae46c205b7fff4ec32</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>aa29eb47420c060a4488e3d5f99884e5b</anchor>
      <arglist>(const Col &amp;c) const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator[]</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>acde22c2fa83e22b68b4062954a94c4d3</anchor>
      <arglist>(const Col &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a45f0a1a4ccd25f30c350e03c025c99d4</anchor>
      <arglist>(const Col &amp;c, const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a153207f2745305ea9d834e3ad5ad99ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a6e19374418db2abf9484578d9718c383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simplify</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>aa0a8cc3641e02a96fa39d303b0f88b3d</anchor>
      <arglist>(Value epsilon=0.0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Expr &amp;</type>
      <name>operator+=</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a7da807a52dd8199a4b6f0e095c5e3466</anchor>
      <arglist>(const Expr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>Expr &amp;</type>
      <name>operator-=</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>aea5575e382c1eb0514af4a7b6b371af7</anchor>
      <arglist>(const Expr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>Expr &amp;</type>
      <name>operator*=</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a450a32ebed0e3d97cf73a3fd2d3f5228</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Expr &amp;</type>
      <name>operator/=</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a41962013d47d284a5785143ff306ac8a</anchor>
      <arglist>(const Value &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Expr</type>
      <name>operator+</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a96cb600aab6d3a1cd79355e5e7ef7615</anchor>
      <arglist>(const LpBase::Expr &amp;a, const LpBase::Expr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Expr</type>
      <name>operator-</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>ac2b4b41c4a456533dfcf1d00150ada41</anchor>
      <arglist>(const LpBase::Expr &amp;a, const LpBase::Expr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Expr</type>
      <name>operator*</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a6994c853574fe469fa348cd5ac359363</anchor>
      <arglist>(const LpBase::Expr &amp;a, const LpBase::Value &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Expr</type>
      <name>operator*</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a5b279048337eb708f35fda03684bd20d</anchor>
      <arglist>(const LpBase::Value &amp;a, const LpBase::Expr &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>LpBase::Expr</type>
      <name>operator/</name>
      <anchorfile>a00161.html</anchorfile>
      <anchor>a91e1c295db53e190588c1b5e8e1be009</anchor>
      <arglist>(const LpBase::Expr &amp;a, const LpBase::Value &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Expr::CoeffIt</name>
    <filename>a00088.html</filename>
    <member kind="function">
      <type></type>
      <name>CoeffIt</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a86138e097d2ae2c09acd7c2f2e595574</anchor>
      <arglist>(Expr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Col</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a400973c92863296a1f0f627b85da2b17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a153207f2745305ea9d834e3ad5ad99ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a6e19374418db2abf9484578d9718c383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CoeffIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a039a874d8a262be17f9ce7ac3d169081</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>a9569625b6759eac56d4b4294aba9e5b2</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00088.html</anchorfile>
      <anchor>aab38b74c42b0f2581ed4917fca608efc</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Expr::ConstCoeffIt</name>
    <filename>a00101.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstCoeffIt</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>ad50df4e747412a8515c4ed98e63d6f95</anchor>
      <arglist>(const Expr &amp;e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Col</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>a400973c92863296a1f0f627b85da2b17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Value &amp;</type>
      <name>operator*</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>a6e19374418db2abf9484578d9718c383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ConstCoeffIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>a7b10f56647ec34e697101749cae7fa92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>a9569625b6759eac56d4b4294aba9e5b2</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00101.html</anchorfile>
      <anchor>aab38b74c42b0f2581ed4917fca608efc</anchor>
      <arglist>(Invalid) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::Row</name>
    <filename>a00334.html</filename>
    <member kind="function">
      <type></type>
      <name>Row</name>
      <anchorfile>a00334.html</anchorfile>
      <anchor>abe1b058f05829f61c8f6615f83e2b7ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Row</name>
      <anchorfile>a00334.html</anchorfile>
      <anchor>aafee000c5e8b9efb815aded749b2ed28</anchor>
      <arglist>(const Invalid &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a00334.html</anchorfile>
      <anchor>af54ae35ab90085c0bd6c8e5f77dd81e3</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a00334.html</anchorfile>
      <anchor>acaddfe4b03925d3f0383192aeb62ed8f</anchor>
      <arglist>(Row r) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a00334.html</anchorfile>
      <anchor>a36bf7f6869ae44a643a13974ff345b5f</anchor>
      <arglist>(Row r) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::RowIt</name>
    <filename>a00335.html</filename>
    <base>lemon::LpBase::Row</base>
    <member kind="function">
      <type></type>
      <name>RowIt</name>
      <anchorfile>a00335.html</anchorfile>
      <anchor>aa63559ada5687aa42b7db278d5c9bc36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RowIt</name>
      <anchorfile>a00335.html</anchorfile>
      <anchor>a764ebc325a013cf3a42b5633990c1f69</anchor>
      <arglist>(const LpBase &amp;solver)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RowIt</name>
      <anchorfile>a00335.html</anchorfile>
      <anchor>a3e23648dfcbb187c8609760fff95075c</anchor>
      <arglist>(const Invalid &amp;)</arglist>
    </member>
    <member kind="function">
      <type>RowIt &amp;</type>
      <name>operator++</name>
      <anchorfile>a00335.html</anchorfile>
      <anchor>ad30aa1e690e8ca3e0dfcb0c0273e0b39</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpBase::UnsupportedFormatError</name>
    <filename>a00435.html</filename>
    <base>lemon::Exception</base>
  </compound>
  <compound kind="class">
    <name>lemon::LpSolver</name>
    <filename>a00249.html</filename>
    <base virtualness="virtual">lemon::LpBase</base>
    <member kind="function" virtualness="pure">
      <type>virtual LpSolver *</type>
      <name>newSolver</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a96ce83198455cdbef6be4e5b4b16eaca</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual LpSolver *</type>
      <name>cloneSolver</name>
      <anchorfile>a00249.html</anchorfile>
      <anchor>a7bd26c359e95549b3ab91a4abde8973e</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::MipSolver</name>
    <filename>a00269.html</filename>
    <base virtualness="virtual">lemon::LpBase</base>
    <member kind="function" virtualness="pure">
      <type>virtual MipSolver *</type>
      <name>newSolver</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>ad14b234174aeb1168ee9169136b66367</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual MipSolver *</type>
      <name>cloneSolver</name>
      <anchorfile>a00269.html</anchorfile>
      <anchor>a36358eade1031f6be344751a8fd16437</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::SkeletonSolverBase</name>
    <filename>a00399.html</filename>
    <base virtualness="virtual">lemon::LpBase</base>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>_addCol</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a3e4122bd62080a37ffabaa0f7ee71a3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>_addRow</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a63fe2e2764e33f96cff12ef717850bf5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>_addRow</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>acb137e8347eb15d6eb3cac129cb1460e</anchor>
      <arglist>(Value l, ExprIterator b, ExprIterator e, Value u)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_eraseCol</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a8d9ae2ab8f081f2675ac1861d7b92539</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_eraseRow</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a7a88deb35973e379fe613b64fefd9df3</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_getColName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a63f7bce5e007a36f3a233536fdff26c0</anchor>
      <arglist>(int col, std::string &amp;name) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setColName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>ae9742b34c4c4f8421d24ae35b40165c8</anchor>
      <arglist>(int col, const std::string &amp;name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>_colByName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a17bb426f44e7c688f246c131ecdaf4a0</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_getRowName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a9af6ac589bdbb728d958a6b818f4646f</anchor>
      <arglist>(int row, std::string &amp;name) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setRowName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a32c0b5b3985527308084f26565a23375</anchor>
      <arglist>(int row, const std::string &amp;name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>_rowByName</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>adeb6051ec6fdce28df4bbf8c33a4ec10</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setRowCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a86bcc074e1232efc1633cf70e595da73</anchor>
      <arglist>(int i, ExprIterator b, ExprIterator e)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_getRowCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>aa3cc8250dff7bcaa6860cd992c69ad0a</anchor>
      <arglist>(int i, InsertIterator b) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setColCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>aeafde598054ed90d572089322454f5a6</anchor>
      <arglist>(int i, ExprIterator b, ExprIterator e)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_getColCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a498d597aea8e87dae9379353f884cfce</anchor>
      <arglist>(int i, InsertIterator b) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setCoeff</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a0f76d7b2ec4142034cb71d94a1f87dab</anchor>
      <arglist>(int row, int col, Value value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getCoeff</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a776ef1e45d36050e9c02b91bb48189c7</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setColLowerBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a6271da636bd2c7034f8502506532809e</anchor>
      <arglist>(int i, Value value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getColLowerBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a2a225402c718cd88bfcec3ed0805e1f2</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setColUpperBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>acca7a1a24c08d2e4386a767bdabdeb08</anchor>
      <arglist>(int i, Value value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getColUpperBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a5914ea33ddc2ff8ee5a0ec2499993351</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setRowLowerBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a826ed7e1b4ed98483dc828237007bbbf</anchor>
      <arglist>(int i, Value value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getRowLowerBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a4acfbc8622c1ee4c89d55bd95b93f11e</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setRowUpperBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a854b5e280e4d6bd253f67dd1dfe69644</anchor>
      <arglist>(int i, Value value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getRowUpperBound</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>ad9acc2e19b0b9eb76bc50bd3e7dee486</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setObjCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a290835cf8024c4138a97edc3df5ce1b1</anchor>
      <arglist>(ExprIterator b, ExprIterator e)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_getObjCoeffs</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a1ddd17c0d2c1d2e53fe426198689b559</anchor>
      <arglist>(InsertIterator b) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setObjCoeff</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a454737987b57b0808888de1f89ec1f60</anchor>
      <arglist>(int i, Value obj_coef)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getObjCoeff</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a1223311f7cd9caba18c3c23f06a0e832</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_setSense</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a452e8c0672accb14f50a95d3247681d1</anchor>
      <arglist>(Sense)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Sense</type>
      <name>_getSense</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a3280d7cae82147d475f5d2aef30b24c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_clear</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>ada6768be8b067492c3f7e6e7861091e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_messageLevel</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>abf7ba538e76b92c679544a92fa538ba0</anchor>
      <arglist>(MessageLevel)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_write</name>
      <anchorfile>a00399.html</anchorfile>
      <anchor>a08241b54a10c26d16da0930c45cd3802</anchor>
      <arglist>(std::string file, std::string format) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::LpSkeleton</name>
    <filename>a00248.html</filename>
    <base>lemon::LpSolver</base>
    <base>lemon::SkeletonSolverBase</base>
    <member kind="function">
      <type></type>
      <name>LpSkeleton</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>aac6b7af1622599f20a58aaa053c7b6b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LpSkeleton *</type>
      <name>newSolver</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a171f2a55ab80dccf76871df17d295e80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LpSkeleton *</type>
      <name>cloneSolver</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a477a3f86cb9586d3fe2e86696fbc1057</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SolveExitStatus</type>
      <name>_solve</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>afb62ef2dec9579d5a2b4ebb5e482e3bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getPrimal</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>ab7cf4b16ee827a1242c2bf4dffd567b1</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getDual</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a79d7bc323f4cd04d281db30aa9f4cc86</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getPrimalValue</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a62395345f6e54d83c8d5893d3eeb62b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getPrimalRay</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a2967d2e7c0d0042f06dbdb14f04db3a6</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getDualRay</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>aba482fdb5d1505edaf5d64ee96e45516</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ProblemType</type>
      <name>_getPrimalType</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>aadd94f7c5114597072bc0fd5ade8e6b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ProblemType</type>
      <name>_getDualType</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a0a8d2cb6a0d932a0add661d71c79fb74</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual VarStatus</type>
      <name>_getColStatus</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a55507e823e01466e2378cf6fd5ff7054</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual VarStatus</type>
      <name>_getRowStatus</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>a2218b837cfab857010050d16e55ba5c8</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const char *</type>
      <name>_solverName</name>
      <anchorfile>a00248.html</anchorfile>
      <anchor>ad7a89ea622e84d4605d402e33f3361ee</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>lemon::MipSkeleton</name>
    <filename>a00268.html</filename>
    <base>lemon::MipSolver</base>
    <base>lemon::SkeletonSolverBase</base>
    <member kind="function">
      <type></type>
      <name>MipSkeleton</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>a4e33e7af142273f190acd7dfcb5ad77b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual MipSkeleton *</type>
      <name>newSolver</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>ae38cc0909b8588d7d846b7ea9ee1cbd3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual MipSkeleton *</type>
      <name>cloneSolver</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>ae912ff8ff000b017a3de2d17379b19d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SolveExitStatus</type>
      <name>_solve</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>a05bc99cbe46a5d442c2039f21ab5ac00</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getSol</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>a2b7149d1e248123feadfdc471a6af6a2</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Value</type>
      <name>_getSolValue</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>a6c54141d3e417b7afea31b9917c52c30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ProblemType</type>
      <name>_getType</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>a866f80ce66ff5b0b0657d9434dd366a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const char *</type>
      <name>_solverName</name>
      <anchorfile>a00268.html</anchorfile>
      <anchor>ad7a89ea622e84d4605d402e33f3361ee</anchor>
      <arglist>() const </arglist>
    </memb