/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie<Boolean>();
    private static final boolean[] __unreservedPctEncodedSubDelims;
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Violation> _violations = EnumSet.noneOf(Violation.class);
    private boolean _emptySegment;

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private static boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }

    private static boolean isSubDelim(char c) {
        return c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=';
    }

    static boolean isUnreservedPctEncodedOrSubDelim(char c) {
        return c < __unreservedPctEncodedSubDelims.length && __unreservedPctEncodedSubDelims[c];
    }

    public static HttpURI createHttpURI(String scheme, String host, int port, String path2, String param, String query, String fragment) {
        if (port == 80 && HttpScheme.HTTP.is(scheme)) {
            port = 0;
        }
        if (port == 443 && HttpScheme.HTTPS.is(scheme)) {
            port = 0;
        }
        return new HttpURI(scheme, host, port, path2, param, query, fragment);
    }

    public HttpURI() {
    }

    public HttpURI(String scheme, String host, int port, String path2, String param, String query, String fragment) {
        this._scheme = scheme;
        this._host = host;
        this._port = port;
        if (path2 != null) {
            this.parse(State.PATH, path2, 0, path2.length());
        }
        if (param != null) {
            this._param = param;
        }
        if (query != null) {
            this._query = query;
        }
        if (fragment != null) {
            this._fragment = fragment;
        }
    }

    public HttpURI(HttpURI uri) {
        this._scheme = uri._scheme;
        this._user = uri._user;
        this._host = uri._host;
        this._port = uri._port;
        this._path = uri._path;
        this._param = uri._param;
        this._query = uri._query;
        this._fragment = uri._fragment;
        this._uri = uri._uri;
        this._decodedPath = uri._decodedPath;
        this._violations.addAll(uri._violations);
        this._emptySegment = false;
    }

    public HttpURI(HttpURI schemeHostPort, HttpURI uri) {
        this._scheme = schemeHostPort._scheme;
        this._user = schemeHostPort._user;
        this._host = schemeHostPort._host;
        this._port = schemeHostPort._port;
        this._path = uri._path;
        this._param = uri._param;
        this._query = uri._query;
        this._fragment = uri._fragment;
        this._uri = uri._uri;
        this._decodedPath = uri._decodedPath;
        this._violations.addAll(uri._violations);
        this._emptySegment = false;
    }

    public HttpURI(String uri) {
        this._port = -1;
        this.parse(State.START, uri, 0, uri.length());
    }

    public HttpURI(URI uri) {
        this._uri = null;
        this._scheme = uri.getScheme();
        this._host = uri.getHost();
        if (this._host == null && uri.getRawSchemeSpecificPart().startsWith("//")) {
            this._host = "";
        }
        this._port = uri.getPort();
        this._user = uri.getUserInfo();
        String path2 = uri.getRawPath();
        if (path2 != null) {
            this.parse(State.PATH, path2, 0, path2.length());
        }
        this._query = uri.getRawQuery();
        this._fragment = uri.getFragment();
    }

    public HttpURI(String scheme, String host, int port, String pathQuery) {
        this._uri = null;
        this._scheme = scheme;
        this._host = host;
        this._port = port;
        if (pathQuery != null) {
            this.parse(State.PATH, pathQuery, 0, pathQuery.length());
        }
    }

    public void clear() {
        this._uri = null;
        this._scheme = null;
        this._user = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._param = null;
        this._query = null;
        this._fragment = null;
        this._decodedPath = null;
        this._emptySegment = false;
        this._violations.clear();
    }

    public void parse(String uri) {
        this.clear();
        this._uri = uri;
        this.parse(State.START, uri, 0, uri.length());
    }

    public void parseRequestTarget(String method, String uri) {
        this.clear();
        this._uri = uri;
        if (HttpMethod.CONNECT.is(method)) {
            this.parse(State.HOST, uri, 0, uri.length());
        } else {
            this.parse(uri.startsWith("/") ? State.PATH : State.START, uri, 0, uri.length());
        }
    }

    @Deprecated
    public void parseConnect(String uri) {
        this.clear();
        this._uri = uri;
        this._path = uri;
    }

    public void parse(String uri, int offset, int length) {
        this.clear();
        int end = offset + length;
        this._uri = uri.substring(offset, end);
        this.parse(State.START, uri, offset, end);
    }

    private void parse(State state, String uri, int offset, int end) {
        int mark = offset;
        int pathMark = 0;
        int segment = 0;
        boolean encoded = false;
        boolean encodedUtf16 = false;
        int encodedCharacters = 0;
        int encodedValue = 0;
        boolean dot = false;
        block78: for (int i = offset; i < end; ++i) {
            char c = uri.charAt(i);
            switch (state) {
                case START: {
                    switch (c) {
                        case '/': {
                            mark = i;
                            state = State.HOST_OR_PATH;
                            continue block78;
                        }
                        case ';': {
                            this.checkSegment(uri, segment, i, true);
                            mark = i + 1;
                            state = State.PARAM;
                            continue block78;
                        }
                        case '?': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = "";
                            mark = i + 1;
                            state = State.QUERY;
                            continue block78;
                        }
                        case '#': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = "";
                            mark = i + 1;
                            state = State.FRAGMENT;
                            continue block78;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block78;
                        }
                        case '%': {
                            encoded = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            pathMark = segment = i;
                            mark = segment;
                            state = State.PATH;
                            continue block78;
                        }
                        case '.': {
                            dot = true;
                            pathMark = segment = i;
                            state = State.PATH;
                            continue block78;
                        }
                    }
                    mark = i;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block78;
                    }
                    pathMark = segment = i;
                    state = State.PATH;
                    continue block78;
                }
                case SCHEME_OR_PATH: {
                    switch (c) {
                        case ':': {
                            this._scheme = uri.substring(mark, i);
                            state = State.START;
                            continue block78;
                        }
                        case '/': {
                            segment = i + 1;
                            state = State.PATH;
                            continue block78;
                        }
                        case ';': {
                            mark = i + 1;
                            state = State.PARAM;
                            continue block78;
                        }
                        case '?': {
                            this._path = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            continue block78;
                        }
                        case '%': {
                            encoded = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            state = State.PATH;
                            continue block78;
                        }
                        case '#': {
                            this._path = uri.substring(mark, i);
                            state = State.FRAGMENT;
                            continue block78;
                        }
                    }
                    continue block78;
                }
                case HOST_OR_PATH: {
                    switch (c) {
                        case '/': {
                            this._host = "";
                            mark = i + 1;
                            state = State.HOST;
                            continue block78;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i;
                            pathMark = mark;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block78;
                        }
                    }
                    pathMark = mark;
                    segment = mark + 1;
                    state = State.PATH;
                    continue block78;
                }
                case HOST: {
                    switch (c) {
                        case '/': {
                            if (encodedCharacters > 0) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._host = uri.substring(mark, i);
                            encoded = false;
                            pathMark = mark = i;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block78;
                        }
                        case ':': {
                            if (i > mark) {
                                this._host = uri.substring(mark, i);
                            }
                            mark = i + 1;
                            state = State.PORT;
                            continue block78;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = uri.substring(mark, i);
                            this._violations.add(Violation.USER_INFO);
                            mark = i + 1;
                            continue block78;
                        }
                        case '[': {
                            if (i != mark) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            state = State.IPV6;
                            continue block78;
                        }
                        case '%': {
                            if (encodedCharacters > 0) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            encodedCharacters = 2;
                            encoded = true;
                            continue block78;
                        }
                        case '#': 
                        case ';': {
                            throw new IllegalArgumentException("Bad authority");
                        }
                    }
                    if (encodedCharacters > 0) {
                        if (!HttpURI.isHexDigit(c)) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        --encodedCharacters;
                        continue block78;
                    }
                    if (HttpURI.isUnreservedPctEncodedOrSubDelim(c)) continue block78;
                    throw new IllegalArgumentException("Bad authority");
                }
                case IPV6: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                        }
                        case ']': {
                            c = uri.charAt(++i);
                            this._host = uri.substring(mark, i);
                            if (c == ':') {
                                mark = i + 1;
                                state = State.PORT;
                                continue block78;
                            }
                            pathMark = mark = i;
                            state = State.PATH;
                            continue block78;
                        }
                        case ':': {
                            continue block78;
                        }
                    }
                    if (HttpURI.isHexDigit(c)) continue block78;
                    throw new IllegalArgumentException("Bad authority");
                }
                case PORT: {
                    if (c == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + uri.substring(mark, i);
                        this._violations.add(Violation.USER_INFO);
                        mark = i + 1;
                        state = State.HOST;
                        continue block78;
                    }
                    if (c != '/') continue block78;
                    this._port = TypeUtil.parseInt(uri, mark, i - mark, 10);
                    pathMark = mark = i;
                    segment = i + 1;
                    state = State.PATH;
                    continue block78;
                }
                case PATH: {
                    if (encodedCharacters > 0) {
                        if (encodedCharacters == 2 && c == 'u' && !encodedUtf16) {
                            this._violations.add(Violation.UTF16);
                            encodedUtf16 = true;
                            encodedCharacters = 4;
                            continue block78;
                        }
                        encodedValue = (encodedValue << 4) + TypeUtil.convertHexDigit(c);
                        if (--encodedCharacters != 0) continue block78;
                        switch (encodedValue) {
                            case 0: {
                                throw new IllegalArgumentException("Illegal character in path");
                            }
                            case 47: {
                                this._violations.add(Violation.SEPARATOR);
                                continue block78;
                            }
                            case 37: {
                                this._violations.add(Violation.ENCODING);
                                continue block78;
                            }
                        }
                        continue block78;
                    }
                    switch (c) {
                        case ';': {
                            this.checkSegment(uri, segment, i, true);
                            mark = i + 1;
                            state = State.PARAM;
                            continue block78;
                        }
                        case '?': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = uri.substring(pathMark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            continue block78;
                        }
                        case '#': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = uri.substring(pathMark, i);
                            mark = i + 1;
                            state = State.FRAGMENT;
                            continue block78;
                        }
                        case '/': {
                            if (i != 0) {
                                this.checkSegment(uri, segment, i, false);
                            }
                            segment = i + 1;
                            continue block78;
                        }
                        case '.': {
                            dot |= segment == i;
                            continue block78;
                        }
                        case '%': {
                            encoded = true;
                            encodedUtf16 = false;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            continue block78;
                        }
                    }
                    continue block78;
                }
                case PARAM: {
                    switch (c) {
                        case '?': {
                            this._path = uri.substring(pathMark, i);
                            this._param = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            continue block78;
                        }
                        case '#': {
                            this._path = uri.substring(pathMark, i);
                            this._param = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.FRAGMENT;
                            continue block78;
                        }
                        case '/': {
                            encoded = true;
                            segment = i + 1;
                            state = State.PATH;
                            continue block78;
                        }
                        case ';': {
                            mark = i + 1;
                            continue block78;
                        }
                    }
                    continue block78;
                }
                case QUERY: {
                    if (c != '#') continue block78;
                    this._query = uri.substring(mark, i);
                    mark = i + 1;
                    state = State.FRAGMENT;
                    continue block78;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = uri.substring(mark, end);
                    i = end;
                    continue block78;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
        }
        switch (state) {
            case START: {
                this._path = "";
                this.checkSegment(uri, segment, end, false);
                break;
            }
            case ASTERISK: {
                break;
            }
            case SCHEME_OR_PATH: 
            case HOST_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST: {
                if (end <= mark) break;
                this._host = uri.substring(mark, end);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(uri, mark, end - mark, 10);
                break;
            }
            case PARAM: {
                this._path = uri.substring(pathMark, end);
                this._param = uri.substring(mark, end);
                break;
            }
            case PATH: {
                this.checkSegment(uri, segment, end, false);
                this._path = uri.substring(pathMark, end);
                break;
            }
            case QUERY: {
                this._query = uri.substring(mark, end);
                break;
            }
            case FRAGMENT: {
                this._fragment = uri.substring(mark, end);
                break;
            }
            default: {
                throw new IllegalStateException(state.toString());
            }
        }
        if (!encoded && !dot) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        } else if (this._path != null) {
            String decodedNonCanonical = URIUtil.decodePath(this._path);
            this._decodedPath = URIUtil.canonicalPath(decodedNonCanonical);
            if (this._decodedPath == null) {
                throw new IllegalArgumentException("Bad URI");
            }
        }
    }

    private void checkSegment(String uri, int segment, int end, boolean param) {
        Boolean ambiguous;
        if (this._emptySegment) {
            this._violations.add(Violation.EMPTY);
        }
        if (end == segment) {
            if (end >= uri.length() || "#?".indexOf(uri.charAt(end)) >= 0) {
                return;
            }
            if (segment == 0) {
                this._violations.add(Violation.EMPTY);
                return;
            }
            if (!this._emptySegment) {
                this._emptySegment = true;
                return;
            }
        }
        if ((ambiguous = __ambiguousSegments.get(uri, segment, end - segment)) != null) {
            if (Boolean.TRUE.equals(ambiguous)) {
                this._violations.add(Violation.SEGMENT);
            }
            if (param) {
                this._violations.add(Violation.PARAM);
            }
        }
    }

    public boolean hasAmbiguousSegment() {
        return this._violations.contains((Object)Violation.SEGMENT);
    }

    public boolean hasAmbiguousEmptySegment() {
        return this._violations.contains((Object)Violation.EMPTY);
    }

    public boolean hasAmbiguousSeparator() {
        return this._violations.contains((Object)Violation.SEPARATOR);
    }

    public boolean hasAmbiguousParameter() {
        return this._violations.contains((Object)Violation.PARAM);
    }

    public boolean hasAmbiguousEncoding() {
        return this._violations.contains((Object)Violation.ENCODING);
    }

    public boolean isAmbiguous() {
        return !this._violations.isEmpty() && (this._violations.size() != 1 || !this._violations.contains((Object)Violation.UTF16));
    }

    public boolean hasViolations() {
        return !this._violations.isEmpty();
    }

    boolean hasViolation(Violation violation) {
        return this._violations.contains((Object)violation);
    }

    public boolean hasUtf16Encoding() {
        return this._violations.contains((Object)Violation.UTF16);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        if (this._host != null && this._host.isEmpty()) {
            return null;
        }
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getDecodedPath() {
        return this._decodedPath;
    }

    public String getParam() {
        return this._param;
    }

    public void setParam(String param) {
        if (!Objects.equals(this._param, param)) {
            if (this._param != null && this._path.endsWith(";" + this._param)) {
                this._path = this._path.substring(0, this._path.length() - 1 - this._param.length());
            }
            this._param = param;
            if (this._param != null) {
                this._path = (this._path == null ? "" : this._path) + ";" + this._param;
            }
            this._uri = null;
        }
    }

    public String getQuery() {
        return this._query;
    }

    public boolean hasQuery() {
        return this._query != null && !this._query.isEmpty();
    }

    public String getFragment() {
        return this._fragment;
    }

    public void decodeQueryTo(MultiMap<String> parameters) {
        if (this._query == null) {
            return;
        }
        UrlEncoded.decodeUtf8To(this._query, parameters);
    }

    public void decodeQueryTo(MultiMap<String> parameters, String encoding2) throws UnsupportedEncodingException {
        this.decodeQueryTo(parameters, Charset.forName(encoding2));
    }

    public void decodeQueryTo(MultiMap<String> parameters, Charset encoding2) throws UnsupportedEncodingException {
        if (this._query == null) {
            return;
        }
        if (encoding2 == null || StandardCharsets.UTF_8.equals(encoding2)) {
            UrlEncoded.decodeUtf8To(this._query, parameters);
        } else {
            UrlEncoded.decodeTo(this._query, parameters, encoding2);
        }
    }

    public boolean isAbsolute() {
        return this._scheme != null && !this._scheme.isEmpty();
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder out = new StringBuilder();
            if (this._scheme != null) {
                out.append(this._scheme).append(':');
            }
            if (this._host != null) {
                out.append("//");
                if (this._user != null) {
                    out.append(this._user).append('@');
                }
                out.append(this._host);
            }
            if (this._port > 0) {
                out.append(':').append(this._port);
            }
            if (this._path != null) {
                out.append(this._path);
            }
            if (this._query != null) {
                out.append('?').append(this._query);
            }
            if (this._fragment != null) {
                out.append('#').append(this._fragment);
            }
            this._uri = out.length() > 0 ? out.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
        this._uri = null;
    }

    public void setAuthority(String host, int port) {
        if (host != null && !this.isPathValidForAuthority(this._path)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._host = host;
        this._port = port;
        this._uri = null;
    }

    private boolean isPathValidForAuthority(String path2) {
        if (path2 == null) {
            return true;
        }
        if (path2.isEmpty() || "*".equals(path2)) {
            return true;
        }
        return path2.startsWith("/");
    }

    public void setPath(String path2) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(path2)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        if (path2 != null) {
            this.parse(State.PATH, path2, 0, path2.length());
        }
    }

    public void setPathQuery(String pathQuery) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(pathQuery)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        this._decodedPath = null;
        this._param = null;
        this._fragment = null;
        if (pathQuery != null) {
            this.parse(State.PATH, pathQuery, 0, pathQuery.length());
        }
    }

    private boolean hasAuthority() {
        return this._host != null;
    }

    public void setQuery(String query) {
        this._query = query;
        this._uri = null;
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString(this._query), this._fragment);
    }

    public String getPathQuery() {
        if (this._query == null) {
            return this._path;
        }
        return this._path + "?" + this._query;
    }

    public String getAuthority() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public String getUser() {
        return this._user;
    }

    static {
        __ambiguousSegments.put(".", Boolean.FALSE);
        __ambiguousSegments.put("%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e", Boolean.TRUE);
        __ambiguousSegments.put("..", Boolean.FALSE);
        __ambiguousSegments.put(".%2e", Boolean.TRUE);
        __ambiguousSegments.put(".%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%2e.", Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e.", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%u002e", Boolean.TRUE);
        __unreservedPctEncodedSubDelims = new boolean[128];
        for (int i = 0; i < __unreservedPctEncodedSubDelims.length; ++i) {
            char c = (char)i;
            HttpURI.__unreservedPctEncodedSubDelims[i] = HttpURI.isUnreserved(c) || c == '%' || HttpURI.isSubDelim(c);
        }
    }

    static enum Violation {
        SEGMENT("Ambiguous path segments"),
        SEPARATOR("Ambiguous path separator"),
        PARAM("Ambiguous path parameters"),
        ENCODING("Ambiguous double encoding"),
        EMPTY("Ambiguous empty segments"),
        UTF16("Non standard UTF-16 encoding"),
        USER_INFO("User info in Authority");

        private final String _message;

        private Violation(String message) {
            this._message = message;
        }

        String getMessage() {
            return this._message;
        }
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

