// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC11E6x_v0.8.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc11e6x

/*
// LPC11E6x ARM cortex-m0+
*/

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC11E6x"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT0 = 0

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT1 = 1

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT2 = 2

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT3 = 3

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT4 = 4

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT5 = 5

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT6 = 6

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT7 = 7

	// GPIO group interrupt 0
	IRQ_GINT0 = 8

	// GINT1
	IRQ_GINT1 = 9

	// I2C1
	IRQ_I2C1 = 10

	// USART4
	IRQ_USART1_4 = 11

	// USART2
	IRQ_USART2_3 = 12

	// State Configurable Timers (SCTimer/PWM)
	IRQ_SCT0_1 = 13

	// SSP1
	IRQ_SSP1 = 14

	// I2C-bus controller
	IRQ_I2C0 = 15

	// 16-bit counter/timers CT16B0
	IRQ_CT16B0 = 16

	// 16-bit counter/timers CT16B1
	IRQ_CT16B1 = 17

	// 32-bit counter/timers CT32B0
	IRQ_CT32B0 = 18

	// 32-bit counter/timers CT32B1
	IRQ_CT32B1 = 19

	// SSP/SPI
	IRQ_SSP0 = 20

	// USART0
	IRQ_USART = 21

	// 12-bit Analog-to-Digital Converter (ADC)
	IRQ_ADC_A = 24

	// Real-Time Clock (RTC)
	IRQ_RTC = 25

	// System configuration (SYSCON)
	IRQ_BOD_WDT = 26

	// Flash controller
	IRQ_FLASH = 27

	// DMA controller
	IRQ_DMA = 28

	// Highest interrupt number on this device.
	IRQ_max = 28
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export USART1_4_IRQHandler
func interruptUSART1_4() {
	callHandlers(IRQ_USART1_4)
}

//export USART2_3_IRQHandler
func interruptUSART2_3() {
	callHandlers(IRQ_USART2_3)
}

//export SCT0_1_IRQHandler
func interruptSCT0_1() {
	callHandlers(IRQ_SCT0_1)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export CT16B0_IRQHandler
func interruptCT16B0() {
	callHandlers(IRQ_CT16B0)
}

//export CT16B1_IRQHandler
func interruptCT16B1() {
	callHandlers(IRQ_CT16B1)
}

//export CT32B0_IRQHandler
func interruptCT32B0() {
	callHandlers(IRQ_CT32B0)
}

//export CT32B1_IRQHandler
func interruptCT32B1() {
	callHandlers(IRQ_CT32B1)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export USART_IRQHandler
func interruptUSART() {
	callHandlers(IRQ_USART)
}

//export ADC_A_IRQHandler
func interruptADC_A() {
	callHandlers(IRQ_ADC_A)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export BOD_WDT_IRQHandler
func interruptBOD_WDT() {
	callHandlers(IRQ_BOD_WDT)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

// Peripherals.
var (
	// I2C-bus controller
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// USART0
	USART0 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// 16-bit counter/timers CT16B0
	CT16B0 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// 16-bit counter/timers CT16B1
	CT16B1 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// 32-bit counter/timers CT32B0
	CT32B0 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// 32-bit counter/timers CT32B1
	CT32B1 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// 12-bit Analog-to-Digital Converter (ADC)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// I2C1
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Real-Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// DMA controller
	DMATRIGMUX = (*DMATRIGMUX_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// SSP/SPI
	SSP0 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// I/O control (IOCON)
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System configuration (SYSCON)
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// USART4
	USART4 = (*USART4_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// SSP1
	SSP1 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// GPIO group interrupt 0
	GINT0 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// GINT1
	GINT1 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// USART1
	USART1 = (*USART4_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// USART2
	USART2 = (*USART4_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// USART3
	USART3 = (*USART4_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Cyclic Redundancy Check (CRC) engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// State Configurable Timers (SCTimer/PWM)
	SCT0 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// SCT1
	SCT1 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x5000e000)))

	// General Purpose I/O (GPIO)
	GPIO_PORT = (*GPIO_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Pin interrupt and pattern match (PINT)
	PINT = (*PINT_Type)(unsafe.Pointer(uintptr(0xa0004000)))
)

// I2C-bus controller
type I2C0_Type struct {
	CONSET      volatile.Register32 // 0x0
	STAT        volatile.Register32 // 0x4
	DAT         volatile.Register32 // 0x8
	ADR0        volatile.Register32 // 0xC
	SCLH        volatile.Register32 // 0x10
	SCLL        volatile.Register32 // 0x14
	CONCLR      volatile.Register32 // 0x18
	MMCTRL      volatile.Register32 // 0x1C
	ADR1        volatile.Register32 // 0x20
	ADR2        volatile.Register32 // 0x24
	ADR3        volatile.Register32 // 0x28
	DATA_BUFFER volatile.Register32 // 0x2C
	MASK0       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	MASK2       volatile.Register32 // 0x38
	MASK3       volatile.Register32 // 0x3C
}

// I2C0.CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C0_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x3)|value)
}
func (o *I2C0_Type) GetCONSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONSET.Reg) & 0x3
}
func (o *I2C0_Type) SetCONSET_AA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetCONSET_AA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetCONSET_SI(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetCONSET_SI() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetCONSET_STO(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetCONSET_STO() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetCONSET_STA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetCONSET_STA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetCONSET_I2EN(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetCONSET_I2EN() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C0_Type) GetCONSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0xffffff80) >> 7
}

// I2C0.STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x7)|value)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x7
}
func (o *I2C0_Type) SetSTAT_Status(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf8)|value<<3)
}
func (o *I2C0_Type) GetSTAT_Status() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf8) >> 3
}
func (o *I2C0_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffff00) >> 8
}

// I2C0.DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
func (o *I2C0_Type) SetDAT_Data(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetDAT_Data() uint32 {
	return volatile.LoadUint32(&o.DAT.Reg) & 0xff
}
func (o *I2C0_Type) SetDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAT.Reg) & 0xffffff00) >> 8
}

// I2C0.ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C0_Type) SetADR0_GC(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetADR0_GC() uint32 {
	return volatile.LoadUint32(&o.ADR0.Reg) & 0x1
}
func (o *I2C0_Type) SetADR0_Address(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetADR0_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xffffff00) >> 8
}

// I2C0.SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
func (o *I2C0_Type) SetSCLH(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetSCLH() uint32 {
	return volatile.LoadUint32(&o.SCLH.Reg) & 0xffff
}
func (o *I2C0_Type) SetSCLH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C0_Type) GetSCLH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLH.Reg) & 0xffff0000) >> 16
}

// I2C0.SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
func (o *I2C0_Type) SetSCLL(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetSCLL() uint32 {
	return volatile.LoadUint32(&o.SCLL.Reg) & 0xffff
}
func (o *I2C0_Type) SetSCLL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C0_Type) GetSCLL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLL.Reg) & 0xffff0000) >> 16
}

// I2C0.CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C0_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x3)|value)
}
func (o *I2C0_Type) GetCONCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONCLR.Reg) & 0x3
}
func (o *I2C0_Type) SetCONCLR_AAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetCONCLR_AAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetCONCLR_SIC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetCONCLR_SIC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetCONCLR_STAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetCONCLR_STAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetCONCLR_I2ENC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetCONCLR_I2ENC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0xffffff00) >> 8
}

// I2C0.MMCTRL: Monitor mode control register.
func (o *I2C0_Type) SetMMCTRL_MM_ENA(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMMCTRL_MM_ENA() uint32 {
	return volatile.LoadUint32(&o.MMCTRL.Reg) & 0x1
}
func (o *I2C0_Type) SetMMCTRL_ENA_SCL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetMMCTRL_ENA_SCL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetMMCTRL_MATCH_ALL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetMMCTRL_MATCH_ALL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetMMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *I2C0_Type) GetMMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0xfffffff8) >> 3
}

// I2C0.ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C0_Type) SetADR1_GC(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetADR1_GC() uint32 {
	return volatile.LoadUint32(&o.ADR1.Reg) & 0x1
}
func (o *I2C0_Type) SetADR1_Address(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetADR1_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xffffff00) >> 8
}

// I2C0.ADR2: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C0_Type) SetADR2_GC(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetADR2_GC() uint32 {
	return volatile.LoadUint32(&o.ADR2.Reg) & 0x1
}
func (o *I2C0_Type) SetADR2_Address(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetADR2_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xffffff00) >> 8
}

// I2C0.ADR3: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C0_Type) SetADR3_GC(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetADR3_GC() uint32 {
	return volatile.LoadUint32(&o.ADR3.Reg) & 0x1
}
func (o *I2C0_Type) SetADR3_Address(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetADR3_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xffffff00) >> 8
}

// I2C0.DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
func (o *I2C0_Type) SetDATA_BUFFER_Data(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetDATA_BUFFER_Data() uint32 {
	return volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xff
}
func (o *I2C0_Type) SetDATA_BUFFER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetDATA_BUFFER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xffffff00) >> 8
}

// I2C0.MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C0_Type) SetMASK0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMASK0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1
}
func (o *I2C0_Type) SetMASK0_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetMASK0_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetMASK0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetMASK0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0xffffff00) >> 8
}

// I2C0.MASK1: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C0_Type) SetMASK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMASK1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1
}
func (o *I2C0_Type) SetMASK1_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetMASK1_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetMASK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetMASK1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0xffffff00) >> 8
}

// I2C0.MASK2: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C0_Type) SetMASK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMASK2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK2.Reg) & 0x1
}
func (o *I2C0_Type) SetMASK2_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetMASK2_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetMASK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetMASK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0xffffff00) >> 8
}

// I2C0.MASK3: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C0_Type) SetMASK3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetMASK3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK3.Reg) & 0x1
}
func (o *I2C0_Type) SetMASK3_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C0_Type) GetMASK3_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0xfe) >> 1
}
func (o *I2C0_Type) SetMASK3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C0_Type) GetMASK3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0xffffff00) >> 8
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	CLKSEL  volatile.Register32 // 0x10
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// WWDT.MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
func (o *WWDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WWDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WWDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WWDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WWDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WWDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WWDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WWDT_Type) SetMOD_WDPROTECT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *WWDT_Type) GetMOD_WDPROTECT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *WWDT_Type) SetMOD_LOCK(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x20)|value<<5)
}
func (o *WWDT_Type) GetMOD_LOCK() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x20) >> 5
}
func (o *WWDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffffffc0)|value<<6)
}
func (o *WWDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xffffffc0) >> 6
}

// WWDT.TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
func (o *WWDT_Type) SetTC_COUNT(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTC_COUNT() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xff000000) >> 24
}

// WWDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WWDT_Type) SetFEED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WWDT_Type) GetFEED() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}
func (o *WWDT_Type) SetFEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *WWDT_Type) GetFEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FEED.Reg) & 0xffffff00) >> 8
}

// WWDT.TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
func (o *WWDT_Type) SetTV_COUNT(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTV_COUNT() uint32 {
	return volatile.LoadUint32(&o.TV.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TV.Reg) & 0xff000000) >> 24
}

// WWDT.CLKSEL: Watchdog clock select register.
func (o *WWDT_Type) SetCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetCLKSEL() uint32 {
	return volatile.LoadUint32(&o.CLKSEL.Reg) & 0x1
}
func (o *WWDT_Type) SetCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x7ffffffe)|value<<1)
}
func (o *WWDT_Type) GetCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x7ffffffe) >> 1
}
func (o *WWDT_Type) SetCLKSEL_LOCK(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x80000000)|value<<31)
}
func (o *WWDT_Type) GetCLKSEL_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x80000000) >> 31
}

// WWDT.WARNINT: Watchdog Warning Interrupt compare value.
func (o *WWDT_Type) SetWARNINT(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0x3ff)|value)
}
func (o *WWDT_Type) GetWARNINT() uint32 {
	return volatile.LoadUint32(&o.WARNINT.Reg) & 0x3ff
}
func (o *WWDT_Type) SetWARNINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *WWDT_Type) GetWARNINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WARNINT.Reg) & 0xfffffc00) >> 10
}

// WWDT.WINDOW: Watchdog Window compare value.
func (o *WWDT_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg) & 0xffffff
}
func (o *WWDT_Type) SetWINDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetWINDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WINDOW.Reg) & 0xff000000) >> 24
}

// USART0
type USART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	TER           volatile.Register32 // 0x30
	_             [12]byte
	HDEN          volatile.Register32 // 0x40
	_             [4]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
}

// USART0.RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
func (o *USART0_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *USART0_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// USART0.DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
func (o *USART0_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *USART0_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// USART0.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *USART0_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *USART0_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *USART0_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *USART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *USART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *USART0_Type) SetIIR_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *USART0_Type) GetIIR_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *USART0_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *USART0_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *USART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// USART0.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *USART0_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *USART0_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *USART0_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *USART0_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *USART0_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// USART0.MCR: Modem Control Register.
func (o *USART0_Type) SetMCR_DTRCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetMCR_DTRCTRL() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *USART0_Type) SetMCR_RTSCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetMCR_RTSCTRL() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xc)|value<<2)
}
func (o *USART0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xc) >> 2
}
func (o *USART0_Type) SetMCR_LMS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetMCR_LMS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetMCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetMCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetMCR_CTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetMCR_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffffff00) >> 8
}

// USART0.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *USART0_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *USART0_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetLSR_TXERR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetLSR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART0_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xfffffe00) >> 9
}

// USART0.MSR: Modem Status Register.
func (o *USART0_Type) SetMSR_DCTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetMSR_DCTS() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}
func (o *USART0_Type) SetMSR_DDSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetMSR_DDSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetMSR_TERI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetMSR_TERI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetMSR_DDCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetMSR_DDCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetMSR_CTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetMSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetMSR_DSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetMSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetMSR_RI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetMSR_RI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetMSR_DCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetMSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xffffff00) >> 8
}

// USART0.SCR: Scratch Pad Register. Eight-bit temporary storage for software.
func (o *USART0_Type) SetSCR_PAD(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetSCR_PAD() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *USART0_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// USART0.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *USART0_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *USART0_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *USART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *USART0_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *USART0_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *USART0_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *USART0_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *USART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// USART0.ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
func (o *USART0_Type) SetICR_IRDAEN(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetICR_IRDAEN() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *USART0_Type) SetICR_IRDAINV(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetICR_IRDAINV() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetICR_FIXPULSEEN(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetICR_FIXPULSEEN() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetICR_PULSEDIV(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x38)|value<<3)
}
func (o *USART0_Type) GetICR_PULSEDIV() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x38) >> 3
}
func (o *USART0_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USART0_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xffffffc0) >> 6
}

// USART0.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *USART0_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *USART0_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *USART0_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *USART0_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *USART0_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// USART0.OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
func (o *USART0_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetOSR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *USART0_Type) SetOSR_OSFRAC(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xe)|value<<1)
}
func (o *USART0_Type) GetOSR_OSFRAC() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xe) >> 1
}
func (o *USART0_Type) SetOSR_OSINT(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xf0)|value<<4)
}
func (o *USART0_Type) GetOSR_OSINT() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xf0) >> 4
}
func (o *USART0_Type) SetOSR_FDINT(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x7f00)|value<<8)
}
func (o *USART0_Type) GetOSR_FDINT() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x7f00) >> 8
}
func (o *USART0_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xffff8000)|value<<15)
}
func (o *USART0_Type) GetOSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xffff8000) >> 15
}

// USART0.TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
func (o *USART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *USART0_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *USART0_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *USART0_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *USART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// USART0.HDEN: Half duplex enable register.
func (o *USART0_Type) SetHDEN(value uint32) {
	volatile.StoreUint32(&o.HDEN.Reg, volatile.LoadUint32(&o.HDEN.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetHDEN() uint32 {
	return volatile.LoadUint32(&o.HDEN.Reg) & 0x1
}
func (o *USART0_Type) SetHDEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HDEN.Reg, volatile.LoadUint32(&o.HDEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *USART0_Type) GetHDEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HDEN.Reg) & 0xfffffffe) >> 1
}

// USART0.SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
func (o *USART0_Type) SetSCICTRL_SCIEN(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetSCICTRL_SCIEN() uint32 {
	return volatile.LoadUint32(&o.SCICTRL.Reg) & 0x1
}
func (o *USART0_Type) SetSCICTRL_NACKDIS(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetSCICTRL_NACKDIS() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetSCICTRL_PROTSEL(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetSCICTRL_PROTSEL() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetSCICTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x18)|value<<3)
}
func (o *USART0_Type) GetSCICTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x18) >> 3
}
func (o *USART0_Type) SetSCICTRL_TXRETRY(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xe0)|value<<5)
}
func (o *USART0_Type) GetSCICTRL_TXRETRY() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xe0) >> 5
}
func (o *USART0_Type) SetSCICTRL_XTRAGUARD(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xff00)|value<<8)
}
func (o *USART0_Type) GetSCICTRL_XTRAGUARD() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xff00) >> 8
}
func (o *USART0_Type) SetSCICTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART0_Type) GetSCICTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xffff0000) >> 16
}

// USART0.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *USART0_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *USART0_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetRS485CTRL_SEL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetRS485CTRL_SEL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USART0_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// USART0.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *USART0_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *USART0_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// USART0.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *USART0_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *USART0_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *USART0_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART0_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// USART0.SYNCCTRL: Synchronous mode control register.
func (o *USART0_Type) SetSYNCCTRL_SYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x1)|value)
}
func (o *USART0_Type) GetSYNCCTRL_SYNC() uint32 {
	return volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x1
}
func (o *USART0_Type) SetSYNCCTRL_CSRC(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART0_Type) GetSYNCCTRL_CSRC() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x2) >> 1
}
func (o *USART0_Type) SetSYNCCTRL_FES(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART0_Type) GetSYNCCTRL_FES() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x4) >> 2
}
func (o *USART0_Type) SetSYNCCTRL_TSBYPASS(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x8)|value<<3)
}
func (o *USART0_Type) GetSYNCCTRL_TSBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x8) >> 3
}
func (o *USART0_Type) SetSYNCCTRL_CSCEN(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x10)|value<<4)
}
func (o *USART0_Type) GetSYNCCTRL_CSCEN() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x10) >> 4
}
func (o *USART0_Type) SetSYNCCTRL_SSDIS(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x20)|value<<5)
}
func (o *USART0_Type) GetSYNCCTRL_SSDIS() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x20) >> 5
}
func (o *USART0_Type) SetSYNCCTRL_CCCLR(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x40)|value<<6)
}
func (o *USART0_Type) GetSYNCCTRL_CCCLR() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x40) >> 6
}
func (o *USART0_Type) SetSYNCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0xffffff80)|value<<7)
}
func (o *USART0_Type) GetSYNCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0xffffff80) >> 7
}

// 16-bit counter/timers CT16B0
type CT16B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// CT16B0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *CT16B0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *CT16B0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *CT16B0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *CT16B0_Type) SetIR_CR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *CT16B0_Type) GetIR_CR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *CT16B0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffff80)|value<<7)
}
func (o *CT16B0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffff80) >> 7
}

// CT16B0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *CT16B0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *CT16B0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// CT16B0.TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *CT16B0_Type) SetTC_TCVAL(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetTC_TCVAL() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffff
}
func (o *CT16B0_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xffff0000) >> 16
}

// CT16B0.PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
func (o *CT16B0_Type) SetPR_PCVAL(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetPR_PCVAL() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0xffff
}
func (o *CT16B0_Type) SetPR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetPR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0xffff0000) >> 16
}

// CT16B0.PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *CT16B0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, volatile.LoadUint32(&o.PC.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg) & 0xffff
}
func (o *CT16B0_Type) SetPC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, volatile.LoadUint32(&o.PC.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetPC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PC.Reg) & 0xffff0000) >> 16
}

// CT16B0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *CT16B0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CT16B0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CT16B0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CT16B0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CT16B0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CT16B0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CT16B0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *CT16B0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *CT16B0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *CT16B0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *CT16B0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *CT16B0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *CT16B0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *CT16B0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *CT16B0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT16B0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// CT16B0.MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT16B0_Type) SetMR0_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, volatile.LoadUint32(&o.MR0.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR0_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, volatile.LoadUint32(&o.MR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR0.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR1: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT16B0_Type) SetMR1_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, volatile.LoadUint32(&o.MR1.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR1_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, volatile.LoadUint32(&o.MR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR1.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR2: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT16B0_Type) SetMR2_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, volatile.LoadUint32(&o.MR2.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR2_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, volatile.LoadUint32(&o.MR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR2.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR3: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT16B0_Type) SetMR3_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, volatile.LoadUint32(&o.MR3.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR3_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, volatile.LoadUint32(&o.MR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR3.Reg) & 0xffff0000) >> 16
}

// CT16B0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *CT16B0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetCCR_CAP1RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetCCR_CAP1RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetCCR_CAP1FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetCCR_CAP1FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetCCR_CAP1I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *CT16B0_Type) GetCCR_CAP1I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *CT16B0_Type) SetCCR_CAP2RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40)|value<<6)
}
func (o *CT16B0_Type) GetCCR_CAP2RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40) >> 6
}
func (o *CT16B0_Type) SetCCR_CAP2FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80)|value<<7)
}
func (o *CT16B0_Type) GetCCR_CAP2FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80) >> 7
}
func (o *CT16B0_Type) SetCCR_CAP2I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *CT16B0_Type) GetCCR_CAP2I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *CT16B0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *CT16B0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xfffffe00) >> 9
}

// CT16B0.CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT16B0_Type) SetCR0_CAP(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR0_CAP() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xffff0000) >> 16
}

// CT16B0.CR1: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT16B0_Type) SetCR1_CAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR1_CAP() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xffff0000) >> 16
}

// CT16B0.CR2: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT16B0_Type) SetCR2_CAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR2_CAP() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xffff0000) >> 16
}

// CT16B0.EMR: External Match Register. The EMR controls the match function and the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
func (o *CT16B0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *CT16B0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *CT16B0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *CT16B0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *CT16B0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *CT16B0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *CT16B0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *CT16B0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *CT16B0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *CT16B0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT16B0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// CT16B0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *CT16B0_Type) SetCTCR_CTM(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *CT16B0_Type) GetCTCR_CTM() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *CT16B0_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *CT16B0_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *CT16B0_Type) SetCTCR_ENCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetCTCR_ENCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetCTCR_SELCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xe0)|value<<5)
}
func (o *CT16B0_Type) GetCTCR_SELCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xe0) >> 5
}
func (o *CT16B0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT16B0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xffffff00) >> 8
}

// CT16B0.PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
func (o *CT16B0_Type) SetPWMC_PWMEN0(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetPWMC_PWMEN0() uint32 {
	return volatile.LoadUint32(&o.PWMC.Reg) & 0x1
}
func (o *CT16B0_Type) SetPWMC_PWMEN1(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetPWMC_PWMEN1() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetPWMC_PWMEN2(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetPWMC_PWMEN2() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetPWMC_PWMEN3(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetPWMC_PWMEN3() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetPWMC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *CT16B0_Type) GetPWMC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0xfffffff0) >> 4
}

// 32-bit counter/timers CT32B0
type CT32B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// CT32B0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *CT32B0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *CT32B0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetIR_CR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *CT32B0_Type) GetIR_CR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *CT32B0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffff80)|value<<7)
}
func (o *CT32B0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffff80) >> 7
}

// CT32B0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *CT32B0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *CT32B0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// CT32B0.TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *CT32B0_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *CT32B0_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// CT32B0.PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
func (o *CT32B0_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *CT32B0_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// CT32B0.PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *CT32B0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *CT32B0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// CT32B0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *CT32B0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CT32B0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CT32B0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CT32B0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CT32B0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *CT32B0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *CT32B0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *CT32B0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *CT32B0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *CT32B0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *CT32B0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *CT32B0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *CT32B0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT32B0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// CT32B0.MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT32B0_Type) SetMR0(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, value)
}
func (o *CT32B0_Type) GetMR0() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg)
}

// CT32B0.MR1: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT32B0_Type) SetMR1(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, value)
}
func (o *CT32B0_Type) GetMR1() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg)
}

// CT32B0.MR2: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT32B0_Type) SetMR2(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, value)
}
func (o *CT32B0_Type) GetMR2() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg)
}

// CT32B0.MR3: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *CT32B0_Type) SetMR3(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, value)
}
func (o *CT32B0_Type) GetMR3() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg)
}

// CT32B0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *CT32B0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetCCR_CAP1RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetCCR_CAP1RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetCCR_CAP1FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetCCR_CAP1FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetCCR_CAP1I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetCCR_CAP1I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetCCR_CAP2RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40)|value<<6)
}
func (o *CT32B0_Type) GetCCR_CAP2RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40) >> 6
}
func (o *CT32B0_Type) SetCCR_CAP2FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80)|value<<7)
}
func (o *CT32B0_Type) GetCCR_CAP2FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80) >> 7
}
func (o *CT32B0_Type) SetCCR_CAP2I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *CT32B0_Type) GetCCR_CAP2I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *CT32B0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *CT32B0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xfffffe00) >> 9
}

// CT32B0.CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT32B0_Type) SetCR0(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, value)
}
func (o *CT32B0_Type) GetCR0() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg)
}

// CT32B0.CR1: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT32B0_Type) SetCR1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, value)
}
func (o *CT32B0_Type) GetCR1() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg)
}

// CT32B0.CR2: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
func (o *CT32B0_Type) SetCR2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, value)
}
func (o *CT32B0_Type) GetCR2() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg)
}

// CT32B0.EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
func (o *CT32B0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *CT32B0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *CT32B0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *CT32B0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *CT32B0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *CT32B0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *CT32B0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *CT32B0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *CT32B0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *CT32B0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT32B0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// CT32B0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *CT32B0_Type) SetCTCR_CTM(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *CT32B0_Type) GetCTCR_CTM() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *CT32B0_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *CT32B0_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *CT32B0_Type) SetCTCR_ENCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetCTCR_ENCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetCTCR_SELCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xe0)|value<<5)
}
func (o *CT32B0_Type) GetCTCR_SELCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xe0) >> 5
}
func (o *CT32B0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT32B0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xffffff00) >> 8
}

// CT32B0.PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
func (o *CT32B0_Type) SetPWMC_PWMEN0(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetPWMC_PWMEN0() uint32 {
	return volatile.LoadUint32(&o.PWMC.Reg) & 0x1
}
func (o *CT32B0_Type) SetPWMC_PWMEN1(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetPWMC_PWMEN1() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetPWMC_PWMEN2(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetPWMC_PWMEN2() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetPWMC_PWMEN3(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetPWMC_PWMEN3() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetPWMC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *CT32B0_Type) GetPWMC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0xfffffff0) >> 4
}

// 12-bit Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CTRL        volatile.Register32 // 0x0
	_           [4]byte
	SEQA_CTRL   volatile.Register32 // 0x8
	SEQB_CTRL   volatile.Register32 // 0xC
	SEQA_GDAT   volatile.Register32 // 0x10
	SEQB_GDAT   volatile.Register32 // 0x14
	_           [8]byte
	DAT         [12]volatile.Register32 // 0x20
	THR0_LOW    volatile.Register32     // 0x50
	THR1_LOW    volatile.Register32     // 0x54
	THR0_HIGH   volatile.Register32     // 0x58
	THR1_HIGH   volatile.Register32     // 0x5C
	CHAN_THRSEL volatile.Register32     // 0x60
	INTEN       volatile.Register32     // 0x64
	FLAGS       volatile.Register32     // 0x68
	TRM         volatile.Register32     // 0x6C
}

// ADC.CTRL: A/D Control Register. Contains the clock divide value, enable bits for each sequence and the A/D power-down bit.
func (o *ADC_Type) SetCTRL_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCTRL_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xff
}
func (o *ADC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCTRL_LPWRMODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCTRL_LPWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCTRL_CAL_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCTRL_CAL_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// ADC.SEQA_CTRL: A/D Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
func (o *ADC_Type) SetSEQA_CTRL_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetSEQA_CTRL_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0xfff
}
func (o *ADC_Type) SetSEQA_CTRL_TRIGGER(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSEQA_CTRL_TRIGGER() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSEQA_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSEQA_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSEQA_CTRL_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSEQA_CTRL_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSEQA_CTRL_SYNCBYPASS(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSEQA_CTRL_SYNCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetSEQA_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQA_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQA_CTRL_START(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetSEQA_CTRL_START() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetSEQA_CTRL_BURST(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetSEQA_CTRL_BURST() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetSEQA_CTRL_SINGLESTEP(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetSEQA_CTRL_SINGLESTEP() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetSEQA_CTRL_LOWPRIO(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetSEQA_CTRL_LOWPRIO() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetSEQA_CTRL_MODE(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQA_CTRL_MODE() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQA_CTRL_SEQA_ENA(value uint32) {
	volatile.StoreUint32(&o.SEQA_CTRL.Reg, volatile.LoadUint32(&o.SEQA_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQA_CTRL_SEQA_ENA() uint32 {
	return (volatile.LoadUint32(&o.SEQA_CTRL.Reg) & 0x80000000) >> 31
}

// ADC.SEQB_CTRL: A/D Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
func (o *ADC_Type) SetSEQB_CTRL_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetSEQB_CTRL_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0xfff
}
func (o *ADC_Type) SetSEQB_CTRL_TRIGGER(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSEQB_CTRL_TRIGGER() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSEQB_CTRL_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSEQB_CTRL_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSEQB_CTRL_SYNCBYPASS(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSEQB_CTRL_SYNCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQB_CTRL_START(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetSEQB_CTRL_START() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetSEQB_CTRL_BURST(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetSEQB_CTRL_BURST() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetSEQB_CTRL_SINGLESTEP(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetSEQB_CTRL_SINGLESTEP() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetSEQB_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetSEQB_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetSEQB_CTRL_MODE(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQB_CTRL_MODE() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQB_CTRL_SEQB_ENA(value uint32) {
	volatile.StoreUint32(&o.SEQB_CTRL.Reg, volatile.LoadUint32(&o.SEQB_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQB_CTRL_SEQB_ENA() uint32 {
	return (volatile.LoadUint32(&o.SEQB_CTRL.Reg) & 0x80000000) >> 31
}

// ADC.SEQA_GDAT: A/D Sequence-A Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-A
func (o *ADC_Type) SetSEQA_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQA_GDAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xf
}
func (o *ADC_Type) SetSEQA_GDAT_RESULT(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetSEQA_GDAT_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetSEQA_GDAT_THCMPRANGE(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQA_GDAT_THCMPRANGE() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQA_GDAT_THCMPCROSS(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetSEQA_GDAT_THCMPCROSS() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetSEQA_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQA_GDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQA_GDAT_CHN(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetSEQA_GDAT_CHN() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetSEQA_GDAT_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQA_GDAT_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQA_GDAT_DATAVALID(value uint32) {
	volatile.StoreUint32(&o.SEQA_GDAT.Reg, volatile.LoadUint32(&o.SEQA_GDAT.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQA_GDAT_DATAVALID() uint32 {
	return (volatile.LoadUint32(&o.SEQA_GDAT.Reg) & 0x80000000) >> 31
}

// ADC.SEQB_GDAT: A/D Sequence-B Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-B
func (o *ADC_Type) SetSEQB_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQB_GDAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xf
}
func (o *ADC_Type) SetSEQB_GDAT_RESULT(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetSEQB_GDAT_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetSEQB_GDAT_THCMPRANGE(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetSEQB_GDAT_THCMPRANGE() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetSEQB_GDAT_THCMPCROSS(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetSEQB_GDAT_THCMPCROSS() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetSEQB_GDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetSEQB_GDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetSEQB_GDAT_CHN(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetSEQB_GDAT_CHN() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetSEQB_GDAT_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetSEQB_GDAT_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetSEQB_GDAT_DATAVALID(value uint32) {
	volatile.StoreUint32(&o.SEQB_GDAT.Reg, volatile.LoadUint32(&o.SEQB_GDAT.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSEQB_GDAT_DATAVALID() uint32 {
	return (volatile.LoadUint32(&o.SEQB_GDAT.Reg) & 0x80000000) >> 31
}

// ADC.DAT: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
func (o *ADC_Type) SetDAT_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetDAT_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.DAT[idx].Reg) & 0xf
}
func (o *ADC_Type) SetDAT_RESULT(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetDAT_RESULT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetDAT_THCMPRANGE(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetDAT_THCMPRANGE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetDAT_THCMPCROSS(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetDAT_THCMPCROSS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetDAT_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x3f00000)|value<<20)
}
func (o *ADC_Type) GetDAT_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x3f00000) >> 20
}
func (o *ADC_Type) SetDAT_CHANNEL(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x3c000000)|value<<26)
}
func (o *ADC_Type) GetDAT_CHANNEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x3c000000) >> 26
}
func (o *ADC_Type) SetDAT_OVERRUN(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDAT_OVERRUN(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDAT_DATAVALID(idx int, value uint32) {
	volatile.StoreUint32(&o.DAT[idx].Reg, volatile.LoadUint32(&o.DAT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDAT_DATAVALID(idx int) uint32 {
	return (volatile.LoadUint32(&o.DAT[idx].Reg) & 0x80000000) >> 31
}

// ADC.THR0_LOW: A/D Low Compare Threshold Register 0 : Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
func (o *ADC_Type) SetTHR0_LOW_THRLOW(value uint32) {
	volatile.StoreUint32(&o.THR0_LOW.Reg, volatile.LoadUint32(&o.THR0_LOW.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR0_LOW_THRLOW() uint32 {
	return (volatile.LoadUint32(&o.THR0_LOW.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR0_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_LOW.Reg, volatile.LoadUint32(&o.THR0_LOW.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR0_LOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR0_LOW.Reg) & 0xffff0000) >> 16
}

// ADC.THR1_LOW: A/D Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
func (o *ADC_Type) SetTHR1_LOW_THRLOW(value uint32) {
	volatile.StoreUint32(&o.THR1_LOW.Reg, volatile.LoadUint32(&o.THR1_LOW.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR1_LOW_THRLOW() uint32 {
	return (volatile.LoadUint32(&o.THR1_LOW.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR1_LOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_LOW.Reg, volatile.LoadUint32(&o.THR1_LOW.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR1_LOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR1_LOW.Reg) & 0xffff0000) >> 16
}

// ADC.THR0_HIGH: A/D High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
func (o *ADC_Type) SetTHR0_HIGH_THRHIGH(value uint32) {
	volatile.StoreUint32(&o.THR0_HIGH.Reg, volatile.LoadUint32(&o.THR0_HIGH.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR0_HIGH_THRHIGH() uint32 {
	return (volatile.LoadUint32(&o.THR0_HIGH.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR0_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR0_HIGH.Reg, volatile.LoadUint32(&o.THR0_HIGH.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR0_HIGH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR0_HIGH.Reg) & 0xffff0000) >> 16
}

// ADC.THR1_HIGH: A/D High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
func (o *ADC_Type) SetTHR1_HIGH_THRHIGH(value uint32) {
	volatile.StoreUint32(&o.THR1_HIGH.Reg, volatile.LoadUint32(&o.THR1_HIGH.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetTHR1_HIGH_THRHIGH() uint32 {
	return (volatile.LoadUint32(&o.THR1_HIGH.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetTHR1_HIGH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.THR1_HIGH.Reg, volatile.LoadUint32(&o.THR1_HIGH.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTHR1_HIGH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.THR1_HIGH.Reg) & 0xffff0000) >> 16
}

// ADC.CHAN_THRSEL: A/D Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
func (o *ADC_Type) SetCHAN_THRSEL_CH0_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH0_THRSEL() uint32 {
	return volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x1
}
func (o *ADC_Type) SetCHAN_THRSEL_CH1_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH1_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHAN_THRSEL_CH2_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH2_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHAN_THRSEL_CH3_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH3_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHAN_THRSEL_CH4_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH4_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHAN_THRSEL_CH5_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH5_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHAN_THRSEL_CH6_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH6_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHAN_THRSEL_CH7_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH7_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHAN_THRSEL_CH8_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH8_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHAN_THRSEL_CH9_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH9_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHAN_THRSEL_CH10_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH10_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHAN_THRSEL_CH11_THRSEL(value uint32) {
	volatile.StoreUint32(&o.CHAN_THRSEL.Reg, volatile.LoadUint32(&o.CHAN_THRSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHAN_THRSEL_CH11_THRSEL() uint32 {
	return (volatile.LoadUint32(&o.CHAN_THRSEL.Reg) & 0x800) >> 11
}

// ADC.INTEN: A/D Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
func (o *ADC_Type) SetINTEN_SEQA_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTEN_SEQA_INTEN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *ADC_Type) SetINTEN_SEQB_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTEN_SEQB_INTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTEN_OVR_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTEN_OVR_INTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x60)|value<<5)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x60) >> 5
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x180)|value<<7)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x180) >> 7
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x600)|value<<9)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x600) >> 9
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1800)|value<<11)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1800) >> 11
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x6000)|value<<13)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x6000) >> 13
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x18000)|value<<15)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x18000) >> 15
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x60000)|value<<17)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x60000) >> 17
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x180000)|value<<19)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x180000) >> 19
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x600000)|value<<21)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x600000) >> 21
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1800000)|value<<23)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1800000) >> 23
}
func (o *ADC_Type) SetINTEN_ADCMPINTEN11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x6000000)|value<<25)
}
func (o *ADC_Type) GetINTEN_ADCMPINTEN11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x6000000) >> 25
}
func (o *ADC_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xf8000000)|value<<27)
}
func (o *ADC_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xf8000000) >> 27
}

// ADC.FLAGS: A/D Flags Register. Contains the four interrupt request flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
func (o *ADC_Type) SetFLAGS_THCMP0(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetFLAGS_THCMP0() uint32 {
	return volatile.LoadUint32(&o.FLAGS.Reg) & 0x1
}
func (o *ADC_Type) SetFLAGS_THCMP1(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetFLAGS_THCMP1() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetFLAGS_THCMP2(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetFLAGS_THCMP2() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetFLAGS_THCMP3(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetFLAGS_THCMP3() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetFLAGS_THCMP4(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetFLAGS_THCMP4() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetFLAGS_THCMP5(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetFLAGS_THCMP5() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetFLAGS_THCMP6(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetFLAGS_THCMP6() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetFLAGS_THCMP7(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetFLAGS_THCMP7() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetFLAGS_THCMP8(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetFLAGS_THCMP8() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetFLAGS_THCMP9(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetFLAGS_THCMP9() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetFLAGS_THCMP10(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetFLAGS_THCMP10() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetFLAGS_THCMP11(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetFLAGS_THCMP11() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetFLAGS_OVERRUN0(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetFLAGS_OVERRUN0() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetFLAGS_OVERRUN1(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetFLAGS_OVERRUN1() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetFLAGS_OVERRUN2(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetFLAGS_OVERRUN2() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetFLAGS_OVERRUN3(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetFLAGS_OVERRUN3() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetFLAGS_OVERRUN4(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetFLAGS_OVERRUN4() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetFLAGS_OVERRUN5(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetFLAGS_OVERRUN5() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetFLAGS_OVERRUN6(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetFLAGS_OVERRUN6() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetFLAGS_OVERRUN7(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetFLAGS_OVERRUN7() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetFLAGS_OVERRUN8(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetFLAGS_OVERRUN8() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetFLAGS_OVERRUN9(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetFLAGS_OVERRUN9() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetFLAGS_OVERRUN10(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetFLAGS_OVERRUN10() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetFLAGS_OVERRUN11(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetFLAGS_OVERRUN11() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetFLAGS_SEQA_OVR(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetFLAGS_SEQA_OVR() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetFLAGS_SEQB_OVR(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetFLAGS_SEQB_OVR() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetFLAGS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0xc000000)|value<<26)
}
func (o *ADC_Type) GetFLAGS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0xc000000) >> 26
}
func (o *ADC_Type) SetFLAGS_SEQA_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetFLAGS_SEQA_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetFLAGS_SEQB_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetFLAGS_SEQB_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetFLAGS_THCMP_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetFLAGS_THCMP_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetFLAGS_OVR_INT(value uint32) {
	volatile.StoreUint32(&o.FLAGS.Reg, volatile.LoadUint32(&o.FLAGS.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetFLAGS_OVR_INT() uint32 {
	return (volatile.LoadUint32(&o.FLAGS.Reg) & 0x80000000) >> 31
}

// ADC.TRM: ADC trim register.
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TRM.Reg) & 0x1f
}
func (o *ADC_Type) SetTRM_VRANGE(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetTRM_VRANGE() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xffffffc0)|value<<6)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0xffffffc0) >> 6
}

// Real-Time Clock (RTC)
type RTC_Type struct {
	CTRL  volatile.Register32 // 0x0
	MATCH volatile.Register32 // 0x4
	COUNT volatile.Register32 // 0x8
	WAKE  volatile.Register32 // 0xC
}

// RTC.CTRL: RTC control register
func (o *RTC_Type) SetCTRL_SWRESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCTRL_SWRESET() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *RTC_Type) SetCTRL_OFD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCTRL_OFD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCTRL_ALARM1HZ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCTRL_ALARM1HZ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCTRL_WAKE1KHZ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCTRL_WAKE1KHZ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCTRL_ALARMDPD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCTRL_ALARMDPD_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCTRL_WAKEDPD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCTRL_WAKEDPD_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCTRL_RTC1KHZ_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCTRL_RTC1KHZ_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCTRL_RTC_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCTRL_RTC_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffffff00) >> 8
}

// RTC.MATCH: RTC match register
func (o *RTC_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, value)
}
func (o *RTC_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg)
}

// RTC.COUNT: RTC counter register
func (o *RTC_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *RTC_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// RTC.WAKE: RTC high-resolution/wake-up timer control register
func (o *RTC_Type) SetWAKE_VAL(value uint32) {
	volatile.StoreUint32(&o.WAKE.Reg, volatile.LoadUint32(&o.WAKE.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWAKE_VAL() uint32 {
	return volatile.LoadUint32(&o.WAKE.Reg) & 0xffff
}
func (o *RTC_Type) SetWAKE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WAKE.Reg, volatile.LoadUint32(&o.WAKE.Reg)&^(0xffff0000)|value<<16)
}
func (o *RTC_Type) GetWAKE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WAKE.Reg) & 0xffff0000) >> 16
}

// DMA controller
type DMATRIGMUX_Type struct {
	DMA_ITRIG_PINMUX [16]volatile.Register32 // 0x0
}

// DMATRIGMUX.DMA_ITRIG_PINMUX: Trigger input select register for DMA channel 0.
func (o *DMATRIGMUX_Type) SetDMA_ITRIG_PINMUX_INP_N(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_ITRIG_PINMUX[idx].Reg, volatile.LoadUint32(&o.DMA_ITRIG_PINMUX[idx].Reg)&^(0x1f)|value)
}
func (o *DMATRIGMUX_Type) GetDMA_ITRIG_PINMUX_INP_N(idx int) uint32 {
	return volatile.LoadUint32(&o.DMA_ITRIG_PINMUX[idx].Reg) & 0x1f
}
func (o *DMATRIGMUX_Type) SetDMA_ITRIG_PINMUX_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DMA_ITRIG_PINMUX[idx].Reg, volatile.LoadUint32(&o.DMA_ITRIG_PINMUX[idx].Reg)&^(0xffffffe0)|value<<5)
}
func (o *DMATRIGMUX_Type) GetDMA_ITRIG_PINMUX_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DMA_ITRIG_PINMUX[idx].Reg) & 0xffffffe0) >> 5
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON   volatile.Register32 // 0x0
	GPREG0 volatile.Register32 // 0x4
	GPREG1 volatile.Register32 // 0x8
	GPREG2 volatile.Register32 // 0xC
	GPREG3 volatile.Register32 // 0x10
	GPREG4 volatile.Register32 // 0x14
}

// PMU.PCON: Power control register
func (o *PMU_Type) SetPCON_PM(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x7)|value)
}
func (o *PMU_Type) GetPCON_PM() uint32 {
	return volatile.LoadUint32(&o.PCON.Reg) & 0x7
}
func (o *PMU_Type) SetPCON_NODPD(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetPCON_NODPD() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xf0)|value<<4)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xf0) >> 4
}
func (o *PMU_Type) SetPCON_SLEEPFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x100)|value<<8)
}
func (o *PMU_Type) GetPCON_SLEEPFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x100) >> 8
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x600)|value<<9)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x600) >> 9
}
func (o *PMU_Type) SetPCON_DPDFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x800)|value<<11)
}
func (o *PMU_Type) GetPCON_DPDFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x800) >> 11
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xfffff000)|value<<12)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xfffff000) >> 12
}

// PMU.GPREG0: General purpose register 0
func (o *PMU_Type) SetGPREG0(value uint32) {
	volatile.StoreUint32(&o.GPREG0.Reg, value)
}
func (o *PMU_Type) GetGPREG0() uint32 {
	return volatile.LoadUint32(&o.GPREG0.Reg)
}

// PMU.GPREG1: General purpose register 0
func (o *PMU_Type) SetGPREG1(value uint32) {
	volatile.StoreUint32(&o.GPREG1.Reg, value)
}
func (o *PMU_Type) GetGPREG1() uint32 {
	return volatile.LoadUint32(&o.GPREG1.Reg)
}

// PMU.GPREG2: General purpose register 0
func (o *PMU_Type) SetGPREG2(value uint32) {
	volatile.StoreUint32(&o.GPREG2.Reg, value)
}
func (o *PMU_Type) GetGPREG2() uint32 {
	return volatile.LoadUint32(&o.GPREG2.Reg)
}

// PMU.GPREG3: General purpose register 0
func (o *PMU_Type) SetGPREG3(value uint32) {
	volatile.StoreUint32(&o.GPREG3.Reg, value)
}
func (o *PMU_Type) GetGPREG3() uint32 {
	return volatile.LoadUint32(&o.GPREG3.Reg)
}

// PMU.GPREG4: Deep power down control register
func (o *PMU_Type) SetGPREG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, volatile.LoadUint32(&o.GPREG4.Reg)&^(0x3ff)|value)
}
func (o *PMU_Type) GetGPREG4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.GPREG4.Reg) & 0x3ff
}
func (o *PMU_Type) SetGPREG4_WAKEUPHYS(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, volatile.LoadUint32(&o.GPREG4.Reg)&^(0x400)|value<<10)
}
func (o *PMU_Type) GetGPREG4_WAKEUPHYS() uint32 {
	return (volatile.LoadUint32(&o.GPREG4.Reg) & 0x400) >> 10
}
func (o *PMU_Type) SetGPREG4_WAKEPAD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, volatile.LoadUint32(&o.GPREG4.Reg)&^(0x800)|value<<11)
}
func (o *PMU_Type) GetGPREG4_WAKEPAD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.GPREG4.Reg) & 0x800) >> 11
}
func (o *PMU_Type) SetGPREG4_GPDATA(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, volatile.LoadUint32(&o.GPREG4.Reg)&^(0xfffff000)|value<<12)
}
func (o *PMU_Type) GetGPREG4_GPDATA() uint32 {
	return (volatile.LoadUint32(&o.GPREG4.Reg) & 0xfffff000) >> 12
}

// Flash controller
type FLASHCTRL_Type struct {
	_        [16]byte
	FLASHCFG volatile.Register32 // 0x10
	_        [12]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
}

// FLASHCTRL.FLASHCFG: Flash configuration register
func (o *FLASHCTRL_Type) SetFLASHCFG_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_FLASHTIM() uint32 {
	return volatile.LoadUint32(&o.FLASHCFG.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetFLASHCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xfffffffc) >> 2
}

// FLASHCTRL.FMSSTART: Signature start address register
func (o *FLASHCTRL_Type) SetFMSSTART_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTART_START() uint32 {
	return volatile.LoadUint32(&o.FMSSTART.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0xfffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTART.Reg) & 0xfffe0000) >> 17
}

// FLASHCTRL.FMSSTOP: Signature stop-address register
func (o *FLASHCTRL_Type) SetFMSSTOP_STOPA(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STOPA() uint32 {
	return volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTOP_STRTBIST(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x20000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STRTBIST() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x20000) >> 17
}
func (o *FLASHCTRL_Type) SetFMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0xfffc0000)|value<<18)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0xfffc0000) >> 18
}

// FLASHCTRL.FMSW0: Signature Word
func (o *FLASHCTRL_Type) SetFMSW0(value uint32) {
	volatile.StoreUint32(&o.FMSW0.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW0() uint32 {
	return volatile.LoadUint32(&o.FMSW0.Reg)
}

// SSP/SPI
type SSP0_Type struct {
	CR0  volatile.Register32 // 0x0
	CR1  volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	CPSR volatile.Register32 // 0x10
	IMSC volatile.Register32 // 0x14
	RIS  volatile.Register32 // 0x18
	MIS  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
}

// SSP0.CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
func (o *SSP0_Type) SetCR0_DSS(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xf)|value)
}
func (o *SSP0_Type) GetCR0_DSS() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg) & 0xf
}
func (o *SSP0_Type) SetCR0_FRF(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x30)|value<<4)
}
func (o *SSP0_Type) GetCR0_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x30) >> 4
}
func (o *SSP0_Type) SetCR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x40)|value<<6)
}
func (o *SSP0_Type) GetCR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x40) >> 6
}
func (o *SSP0_Type) SetCR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x80)|value<<7)
}
func (o *SSP0_Type) GetCR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x80) >> 7
}
func (o *SSP0_Type) SetCR0_SCR(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xff00)|value<<8)
}
func (o *SSP0_Type) GetCR0_SCR() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xff00) >> 8
}
func (o *SSP0_Type) SetCR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP0_Type) GetCR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xffff0000) >> 16
}

// SSP0.CR1: Control Register 1. Selects master/slave and other modes.
func (o *SSP0_Type) SetCR1_LBM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetCR1_LBM() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *SSP0_Type) SetCR1_SSE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetCR1_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetCR1_MS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetCR1_MS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetCR1_SOD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetCR1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetCR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetCR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xfffffff0) >> 4
}

// SSP0.DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
func (o *SSP0_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SSP0_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}
func (o *SSP0_Type) SetDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP0_Type) GetDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xffff0000) >> 16
}

// SSP0.SR: Status Register
func (o *SSP0_Type) SetSR_TFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetSR_TFE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSP0_Type) SetSR_TNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetSR_TNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetSR_RNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetSR_RNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetSR_RFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetSR_RFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSP0_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSP0_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SSP0_Type) GetSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xffffffe0) >> 5
}

// SSP0.CPSR: Clock Prescale Register
func (o *SSP0_Type) SetCPSR_CPSDVSR(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xff)|value)
}
func (o *SSP0_Type) GetCPSR_CPSDVSR() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xff
}
func (o *SSP0_Type) SetCPSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSP0_Type) GetCPSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffffff00) >> 8
}

// SSP0.IMSC: Interrupt Mask Set and Clear Register
func (o *SSP0_Type) SetIMSC_RORIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetIMSC_RORIM() uint32 {
	return volatile.LoadUint32(&o.IMSC.Reg) & 0x1
}
func (o *SSP0_Type) SetIMSC_RTIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetIMSC_RTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetIMSC_RXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetIMSC_RXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetIMSC_TXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetIMSC_TXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetIMSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetIMSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0xfffffff0) >> 4
}

// SSP0.RIS: Raw Interrupt Status Register
func (o *SSP0_Type) SetRIS_RORRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetRIS_RORRIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}
func (o *SSP0_Type) SetRIS_RTRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetRIS_RTRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetRIS_RXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetRIS_RXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetRIS_TXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetRIS_TXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetRIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetRIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0xfffffff0) >> 4
}

// SSP0.MIS: Masked Interrupt Status Register
func (o *SSP0_Type) SetMIS_RORMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetMIS_RORMIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}
func (o *SSP0_Type) SetMIS_RTMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetMIS_RTMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetMIS_RXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetMIS_RXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetMIS_TXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetMIS_TXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetMIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetMIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0xfffffff0) >> 4
}

// SSP0.ICR: SSPICR Interrupt Clear Register
func (o *SSP0_Type) SetICR_RORIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetICR_RORIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *SSP0_Type) SetICR_RTIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetICR_RTIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SSP0_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xfffffffc) >> 2
}

// I/O control (IOCON)
type IOCON_Type struct {
	PIO0_0  volatile.Register32 // 0x0
	PIO0_1  volatile.Register32 // 0x4
	PIO0_2  volatile.Register32 // 0x8
	PIO0_3  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_5  volatile.Register32 // 0x14
	PIO0_6  volatile.Register32 // 0x18
	PIO0_7  volatile.Register32 // 0x1C
	PIO0_8  volatile.Register32 // 0x20
	PIO0_9  volatile.Register32 // 0x24
	PIO0_10 volatile.Register32 // 0x28
	PIO0_11 volatile.Register32 // 0x2C
	PIO0_12 volatile.Register32 // 0x30
	PIO0_13 volatile.Register32 // 0x34
	PIO0_14 volatile.Register32 // 0x38
	PIO0_15 volatile.Register32 // 0x3C
	PIO0_16 volatile.Register32 // 0x40
	PIO0_17 volatile.Register32 // 0x44
	PIO0_18 volatile.Register32 // 0x48
	PIO0_19 volatile.Register32 // 0x4C
	PIO0_20 volatile.Register32 // 0x50
	PIO0_21 volatile.Register32 // 0x54
	PIO0_22 volatile.Register32 // 0x58
	PIO0_23 volatile.Register32 // 0x5C
	PIO1_0  volatile.Register32 // 0x60
	PIO1_1  volatile.Register32 // 0x64
	PIO1_2  volatile.Register32 // 0x68
	PIO1_3  volatile.Register32 // 0x6C
	PIO1_4  volatile.Register32 // 0x70
	PIO1_5  volatile.Register32 // 0x74
	PIO1_6  volatile.Register32 // 0x78
	PIO1_7  volatile.Register32 // 0x7C
	PIO1_8  volatile.Register32 // 0x80
	PIO1_9  volatile.Register32 // 0x84
	PIO1_10 volatile.Register32 // 0x88
	PIO1_11 volatile.Register32 // 0x8C
	PIO1_12 volatile.Register32 // 0x90
	PIO1_13 volatile.Register32 // 0x94
	PIO1_14 volatile.Register32 // 0x98
	PIO1_15 volatile.Register32 // 0x9C
	PIO1_16 volatile.Register32 // 0xA0
	PIO1_17 volatile.Register32 // 0xA4
	PIO1_18 volatile.Register32 // 0xA8
	PIO1_19 volatile.Register32 // 0xAC
	PIO1_20 volatile.Register32 // 0xB0
	PIO1_21 volatile.Register32 // 0xB4
	PIO1_22 volatile.Register32 // 0xB8
	PIO1_23 volatile.Register32 // 0xBC
	PIO1_24 volatile.Register32 // 0xC0
	PIO1_25 volatile.Register32 // 0xC4
	PIO1_26 volatile.Register32 // 0xC8
	PIO1_27 volatile.Register32 // 0xCC
	PIO1_28 volatile.Register32 // 0xD0
	PIO1_29 volatile.Register32 // 0xD4
	PIO1_30 volatile.Register32 // 0xD8
	PIO1_31 volatile.Register32 // 0xDC
	_       [16]byte
	PIO2_0  volatile.Register32 // 0xF0
	PIO2_1  volatile.Register32 // 0xF4
	_       [4]byte
	PIO2_2  volatile.Register32 // 0xFC
	PIO2_3  volatile.Register32 // 0x100
	PIO2_4  volatile.Register32 // 0x104
	PIO2_5  volatile.Register32 // 0x108
	PIO2_6  volatile.Register32 // 0x10C
	PIO2_7  volatile.Register32 // 0x110
	PIO2_8  volatile.Register32 // 0x114
	PIO2_9  volatile.Register32 // 0x118
	PIO2_10 volatile.Register32 // 0x11C
	PIO2_11 volatile.Register32 // 0x120
	PIO2_12 volatile.Register32 // 0x124
	PIO2_13 volatile.Register32 // 0x128
	PIO2_14 volatile.Register32 // 0x12C
	PIO2_15 volatile.Register32 // 0x130
	PIO2_16 volatile.Register32 // 0x134
	PIO2_17 volatile.Register32 // 0x138
	PIO2_18 volatile.Register32 // 0x13C
	PIO2_19 volatile.Register32 // 0x140
	PIO2_20 volatile.Register32 // 0x144
	PIO2_21 volatile.Register32 // 0x148
	PIO2_22 volatile.Register32 // 0x14C
	PIO2_23 volatile.Register32 // 0x150
}

// IOCON.PIO0_0: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_0_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_1: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_1_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_2: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_2_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_3: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_3_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_4: I/O configuration for open-drain pin PIO0_4
func (o *IOCON_Type) SetPIO0_4_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_4_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xf8)|value<<3)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xf8) >> 3
}
func (o *IOCON_Type) SetPIO0_4_I2CMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x300)|value<<8)
}
func (o *IOCON_Type) GetPIO0_4_I2CMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x300) >> 8
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xfffffc00)|value<<10)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xfffffc00) >> 10
}

// IOCON.PIO0_5: I/O configuration for open-drain pin PIO0_5
func (o *IOCON_Type) SetPIO0_5_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_5_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0xf8)|value<<3)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0xf8) >> 3
}
func (o *IOCON_Type) SetPIO0_5_I2CMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x300)|value<<8)
}
func (o *IOCON_Type) GetPIO0_5_I2CMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x300) >> 8
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0xfffffc00)|value<<10)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0xfffffc00) >> 10
}

// IOCON.PIO0_6: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_6_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_6_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_6.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_6_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_6_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_6_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_6_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_6_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_6_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_6_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_6_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_6_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_6_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_7: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_7_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_7_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_7.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_7_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_7_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_7_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_7_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_7_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_7_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_7_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_7_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_7_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_7_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_8: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_8_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_8_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_8.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_8_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_8_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_8_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_8_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_8_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_8_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_8_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_8_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_8_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_8_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_9: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_9_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_9_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_9.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_9_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_9_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_9_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_9_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_9_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_9_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_9_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_9_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_9_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_9_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_10: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_10_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_10_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_10.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_10_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_10_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_10_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_10_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_10_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_10_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_10_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_10_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_10_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_10_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_10_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_10_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_11: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_11_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_11_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_11.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_11_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_11_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_11_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_11_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_11_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_11_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_11_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_11_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_11_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_11_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_11_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_11_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_12: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_12_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_12_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_12.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_12_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_12_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_12_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_12_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_12_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_12_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_12_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_12_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_12_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_12_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_12_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_12_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_13: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_13_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_13_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_13.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_13_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_13_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_13_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_13_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_13_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_13_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_13_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_13_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_13_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_13_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_13_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_13_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_14: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_14_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_14_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_14.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_14_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_14_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_14_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_14_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_14_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_14_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_14_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_14_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_14_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_14_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_14_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_14_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_15: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_15_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_15_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_15.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_15_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_15_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_15_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_15_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_15_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_15_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_15_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_15_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_15_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_15_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_15_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_15_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_16: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_16_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_16_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_16.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_16_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_16_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_16_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_16_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_16_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_16_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_16_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_16_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_16_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_16_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_16_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_16_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_17: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_17_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_17_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_17.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_17_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_17_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_17_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_17_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_17_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_17_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_17_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_17_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_17_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_17_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_17_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_17_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_18: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_18_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_18_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_18.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_18_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_18_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_18_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_18_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_18_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_18_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_18_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_18_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_18_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_18_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_18_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_18_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_19: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_19_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_19_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_19.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_19_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_19_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_19_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_19_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_19_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_19_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_19_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_19_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_19_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_19_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_19_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_19_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_20: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_20_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_20_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_20.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_20_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_20_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_20_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_20_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_20_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_20_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_20_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_20_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_20_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_20_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_20_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_20_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_21: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_21_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_21_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_21.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_21_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_21_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_21_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_21_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_21_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_21_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_21_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_21_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_21_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_21_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_21_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_21_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_22: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_22_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_22_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_22.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_22_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_22_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_22_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_22_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_22_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_22_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_22_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_22_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_22_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_22_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_22_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_22_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_23: I/O configuration for port PIO0
func (o *IOCON_Type) SetPIO0_23_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_23_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_23.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_23_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_23_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_23_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_23_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_23_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_23_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_23_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_23_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_23_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_23_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_23_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_23_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_0: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_0_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_1: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_1_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_2: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_2_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_3: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_3_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_4: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_4_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_4_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_4_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_4_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_5: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_5_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_5_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_5_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_5_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_5_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_5_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_5_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_5_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_5_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_5_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_5_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_5_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_6: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_6_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_6_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_6.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_6_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_6_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_6_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_6_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_6_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_6_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_6_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_6_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_6_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_6_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_7: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_7_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_7_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_7.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_7_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_7_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_7_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_7_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_7_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_7_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_7_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_7_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_7_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_7_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_8: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_8_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_8_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_8.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_8_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_8_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_8_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_8_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_8_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_8_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_8_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_8_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_8_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_8_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_9: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_9_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_9_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_9.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_9_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_9_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_9_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_9_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_9_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_9_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_9_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_9_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_9_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_9_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_10: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_10_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_10_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_10.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_10_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_10_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_10_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_10_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_10_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_10_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_10_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_10_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_10_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_10_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_10_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_10_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_10.Reg, volatile.LoadUint32(&o.PIO1_10.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_10.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_11: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_11_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_11_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_11.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_11_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_11_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_11_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_11_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_11_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_11_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_11_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_11_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_11_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_11_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_11_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_11_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_11.Reg, volatile.LoadUint32(&o.PIO1_11.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_11.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_12: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_12_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_12_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_12.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_12_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_12_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_12_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_12_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_12_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_12_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_12_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_12_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_12_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_12_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_12_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_12_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_12.Reg, volatile.LoadUint32(&o.PIO1_12.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_12.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_13: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_13_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_13_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_13.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_13_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_13_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_13_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_13_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_13_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_13_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_13_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_13_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_13_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_13_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_13_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_13_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_13.Reg, volatile.LoadUint32(&o.PIO1_13.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_13.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_14: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_14_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_14_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_14.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_14_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_14_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_14_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_14_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_14_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_14_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_14_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_14_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_14_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_14_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_14_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_14_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_14.Reg, volatile.LoadUint32(&o.PIO1_14.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_14.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_15: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_15_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_15_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_15.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_15_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_15_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_15_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_15_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_15_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_15_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_15_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_15_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_15_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_15_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_15_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_15_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_15.Reg, volatile.LoadUint32(&o.PIO1_15.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_15.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_16: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_16_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_16_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_16.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_16_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_16_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_16_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_16_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_16_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_16_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_16_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_16_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_16_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_16_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_16_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_16_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_16.Reg, volatile.LoadUint32(&o.PIO1_16.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_16.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_17: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_17_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_17_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_17.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_17_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_17_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_17_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_17_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_17_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_17_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_17_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_17_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_17_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_17_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_17_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_17_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_17.Reg, volatile.LoadUint32(&o.PIO1_17.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_17.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_18: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_18_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_18_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_18.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_18_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_18_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_18_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_18_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_18_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_18_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_18_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_18_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_18_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_18_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_18_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_18_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_18.Reg, volatile.LoadUint32(&o.PIO1_18.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_18.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_19: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_19_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_19_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_19.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_19_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_19_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_19_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_19_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_19_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_19_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_19_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_19_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_19_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_19_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_19_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_19_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_19.Reg, volatile.LoadUint32(&o.PIO1_19.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_19.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_20: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_20_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_20_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_20.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_20_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_20_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_20_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_20_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_20_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_20_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_20_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_20_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_20_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_20_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_20_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_20_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_20.Reg, volatile.LoadUint32(&o.PIO1_20.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_20.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_21: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_21_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_21_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_21.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_21_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_21_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_21_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_21_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_21_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_21_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_21_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_21_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_21_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_21_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_21_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_21_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_21.Reg, volatile.LoadUint32(&o.PIO1_21.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_21.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_22: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_22_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_22_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_22.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_22_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_22_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_22_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_22_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_22_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_22_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_22_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_22_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_22_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_22_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_22_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_22_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_22.Reg, volatile.LoadUint32(&o.PIO1_22.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_22.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_23: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_23_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_23_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_23.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_23_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_23_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_23_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_23_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_23_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_23_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_23_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_23_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_23_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_23_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_23_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_23_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_23.Reg, volatile.LoadUint32(&o.PIO1_23.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_23.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_24: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_24_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_24_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_24.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_24_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_24_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_24_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_24_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_24_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_24_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_24_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_24_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_24_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_24_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_24_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_24_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_24_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_24_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_24_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_24.Reg, volatile.LoadUint32(&o.PIO1_24.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_24_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_24.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_25: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_25_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_25_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_25.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_25_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_25_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_25_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_25_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_25_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_25_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_25_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_25_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_25_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_25_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_25_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_25_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_25_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_25_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_25_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_25.Reg, volatile.LoadUint32(&o.PIO1_25.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_25_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_25.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_26: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_26_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_26_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_26.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_26_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_26_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_26_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_26_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_26_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_26_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_26_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_26_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_26_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_26_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_26_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_26_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_26_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_26_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_26_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_26.Reg, volatile.LoadUint32(&o.PIO1_26.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_26_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_26.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_27: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_27_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_27_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_27.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_27_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_27_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_27_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_27_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_27_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_27_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_27_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_27_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_27_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_27_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_27_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_27_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_27_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_27_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_27_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_27.Reg, volatile.LoadUint32(&o.PIO1_27.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_27_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_27.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_28: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_28_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_28_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_28.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_28_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_28_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_28_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_28_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_28_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_28_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_28_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_28_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_28_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_28_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_28_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_28_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_28_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_28_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_28_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_28.Reg, volatile.LoadUint32(&o.PIO1_28.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_28_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_28.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_29: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_29_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_29_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_29.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_29_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_29_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_29_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_29_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_29_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_29_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_29_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_29_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_29_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_29_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_29_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_29_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_29_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_29_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_29_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_29.Reg, volatile.LoadUint32(&o.PIO1_29.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_29_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_29.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_30: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_30_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_30_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_30.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_30_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_30_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_30_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_30_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_30_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_30_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_30_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_30_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_30_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_30_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_30_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_30_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_30_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_30_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_30_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_30.Reg, volatile.LoadUint32(&o.PIO1_30.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_30_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_30.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO1_31: I/O configuration for port PIO1
func (o *IOCON_Type) SetPIO1_31_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_31_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_31.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_31_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_31_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_31_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_31_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_31_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_31_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_31_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO1_31_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO1_31_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_31_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_31_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_31_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO1_31_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO1_31_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO1_31_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_31.Reg, volatile.LoadUint32(&o.PIO1_31.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO1_31_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_31.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_0: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_0_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_0.Reg, volatile.LoadUint32(&o.PIO2_0.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_0.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_1: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_1_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_1.Reg, volatile.LoadUint32(&o.PIO2_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_1.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_2: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_2_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_2.Reg, volatile.LoadUint32(&o.PIO2_2.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_2.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_3: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_3_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_3.Reg, volatile.LoadUint32(&o.PIO2_3.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_3.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_4: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_4_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_4_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_4_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_4_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_4.Reg, volatile.LoadUint32(&o.PIO2_4.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_4.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_5: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_5_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_5_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_5_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_5_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_5_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_5_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_5_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_5_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_5_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_5_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_5_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_5_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_5.Reg, volatile.LoadUint32(&o.PIO2_5.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_5.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_6: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_6_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_6_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_6.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_6_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_6_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_6_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_6_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_6_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_6_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_6_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_6_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_6_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_6_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_6.Reg, volatile.LoadUint32(&o.PIO2_6.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_6.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_7: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_7_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_7_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_7.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_7_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_7_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_7_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_7_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_7_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_7_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_7_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_7_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_7_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_7_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_7.Reg, volatile.LoadUint32(&o.PIO2_7.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_7.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_8: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_8_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_8_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_8.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_8_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_8_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_8_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_8_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_8_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_8_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_8_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_8_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_8_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_8_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_8.Reg, volatile.LoadUint32(&o.PIO2_8.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_8.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_9: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_9_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_9_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_9.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_9_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_9_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_9_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_9_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_9_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_9_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_9_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_9_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_9_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_9_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_9.Reg, volatile.LoadUint32(&o.PIO2_9.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_9.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_10: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_10_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_10_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_10.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_10_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_10_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_10_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_10_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_10_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_10_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_10_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_10_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_10_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_10_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_10_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_10_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_10.Reg, volatile.LoadUint32(&o.PIO2_10.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_10.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_11: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_11_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_11_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_11.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_11_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_11_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_11_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_11_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_11_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_11_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_11_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_11_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_11_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_11_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_11_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_11_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_11.Reg, volatile.LoadUint32(&o.PIO2_11.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_11.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_12: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_12_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_12_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_12.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_12_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_12_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_12_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_12_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_12_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_12_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_12_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_12_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_12_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_12_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_12_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_12_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_12.Reg, volatile.LoadUint32(&o.PIO2_12.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_12.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_13: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_13_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_13_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_13.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_13_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_13_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_13_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_13_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_13_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_13_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_13_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_13_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_13_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_13_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_13_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_13_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_13.Reg, volatile.LoadUint32(&o.PIO2_13.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_13.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_14: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_14_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_14_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_14.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_14_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_14_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_14_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_14_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_14_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_14_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_14_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_14_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_14_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_14_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_14_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_14_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_14.Reg, volatile.LoadUint32(&o.PIO2_14.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_14.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_15: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_15_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_15_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_15.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_15_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_15_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_15_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_15_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_15_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_15_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_15_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_15_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_15_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_15_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_15_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_15_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_15.Reg, volatile.LoadUint32(&o.PIO2_15.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_15.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_16: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_16_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_16_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_16.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_16_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_16_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_16_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_16_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_16_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_16_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_16_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_16_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_16_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_16_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_16_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_16_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_16.Reg, volatile.LoadUint32(&o.PIO2_16.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_16.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_17: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_17_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_17_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_17.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_17_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_17_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_17_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_17_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_17_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_17_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_17_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_17_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_17_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_17_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_17_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_17_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_17.Reg, volatile.LoadUint32(&o.PIO2_17.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_17.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_18: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_18_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_18_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_18.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_18_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_18_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_18_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_18_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_18_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_18_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_18_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_18_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_18_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_18_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_18_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_18_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_18.Reg, volatile.LoadUint32(&o.PIO2_18.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_18.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_19: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_19_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_19_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_19.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_19_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_19_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_19_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_19_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_19_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_19_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_19_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_19_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_19_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_19_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_19_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_19_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_19.Reg, volatile.LoadUint32(&o.PIO2_19.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_19.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_20: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_20_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_20_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_20.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_20_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_20_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_20_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_20_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_20_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_20_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_20_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_20_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_20_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_20_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_20_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_20_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_20.Reg, volatile.LoadUint32(&o.PIO2_20.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_20.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_21: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_21_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_21_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_21.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_21_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_21_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_21_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_21_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_21_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_21_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_21_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_21_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_21_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_21_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_21_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_21_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_21.Reg, volatile.LoadUint32(&o.PIO2_21.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_21.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_22: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_22_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_22_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_22.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_22_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_22_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_22_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_22_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_22_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_22_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_22_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_22_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_22_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_22_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_22_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_22_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_22.Reg, volatile.LoadUint32(&o.PIO2_22.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_22.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO2_23: I/O configuration for port PIO2
func (o *IOCON_Type) SetPIO2_23_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO2_23_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO2_23.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO2_23_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO2_23_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO2_23_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO2_23_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO2_23_INV(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO2_23_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO2_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO2_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO2_23_OD(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO2_23_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO2_23_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO2_23_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO2_23_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO2_23_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO2_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO2_23.Reg, volatile.LoadUint32(&o.PIO2_23.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO2_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO2_23.Reg) & 0xffff0000) >> 16
}

// System configuration (SYSCON)
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	_             [12]byte
	RTCOSCCTRL    volatile.Register32 // 0x1C
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	IRCCTRL       volatile.Register32 // 0x28
	_             [4]byte
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	_             [40]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	SSP0CLKDIV    volatile.Register32 // 0x94
	USART0CLKDIV  volatile.Register32 // 0x98
	SSP1CLKDIV    volatile.Register32 // 0x9C
	FRGCLKDIV     volatile.Register32 // 0xA0
	_             [60]byte
	CLKOUTSEL     volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTDIV     volatile.Register32 // 0xE8
	_             [4]byte
	UARTFRGDIV    volatile.Register32 // 0xF0
	UARTFRGMULT   volatile.Register32 // 0xF4
	_             [4]byte
	EXTTRACECMD   volatile.Register32 // 0xFC
	PIOPORCAP0    volatile.Register32 // 0x100
	PIOPORCAP1    volatile.Register32 // 0x104
	PIOPORCAP2    volatile.Register32 // 0x108
	_             [40]byte
	IOCONCLKDIV6  volatile.Register32 // 0x134
	IOCONCLKDIV5  volatile.Register32 // 0x138
	IOCONCLKDIV4  volatile.Register32 // 0x13C
	IOCONCLKDIV3  volatile.Register32 // 0x140
	IOCONCLKDIV2  volatile.Register32 // 0x144
	IOCONCLKDIV1  volatile.Register32 // 0x148
	IOCONCLKDIV0  volatile.Register32 // 0x14C
	BODCTRL       volatile.Register32 // 0x150
	SYSTCKCAL     volatile.Register32 // 0x154
	_             [24]byte
	IRQLATENCY    volatile.Register32 // 0x170
	NMISRC        volatile.Register32 // 0x174
	PINTSEL0      volatile.Register32 // 0x178
	PINTSEL1      volatile.Register32 // 0x17C
	PINTSEL2      volatile.Register32 // 0x180
	PINTSEL3      volatile.Register32 // 0x184
	PINTSEL4      volatile.Register32 // 0x188
	PINTSEL5      volatile.Register32 // 0x18C
	PINTSEL6      volatile.Register32 // 0x190
	PINTSEL7      volatile.Register32 // 0x194
	_             [108]byte
	STARTERP0     volatile.Register32 // 0x204
	_             [12]byte
	STARTERP1     volatile.Register32 // 0x214
	_             [24]byte
	PDSLEEPCFG    volatile.Register32 // 0x230
	PDAWAKECFG    volatile.Register32 // 0x234
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// SYSCON.SYSMEMREMAP: System memory remap
func (o *SYSCON_Type) SetSYSMEMREMAP_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSMEMREMAP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PRESETCTRL: Peripheral reset control
func (o *SYSCON_Type) SetPRESETCTRL_SSP0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPRESETCTRL_SSP0_RST_N() uint32 {
	return volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetPRESETCTRL_I2C0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPRESETCTRL_I2C0_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPRESETCTRL_SSP1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPRESETCTRL_SSP1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPRESETCTRL_I2C1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPRESETCTRL_I2C1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPRESETCTRL_FRG_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPRESETCTRL_FRG_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPRESETCTRL_USART1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPRESETCTRL_USART1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPRESETCTRL_USART2_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPRESETCTRL_USART2_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPRESETCTRL_USART3_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPRESETCTRL_USART3_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPRESETCTRL_USART4_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPRESETCTRL_USART4_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPRESETCTRL_SCT0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPRESETCTRL_SCT0_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPRESETCTRL_SCT1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPRESETCTRL_SCT1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPRESETCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0xfffff800)|value<<11)
}
func (o *SYSCON_Type) GetPRESETCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0xfffff800) >> 11
}

// SYSCON.SYSPLLCTRL: System PLL control
func (o *SYSCON_Type) SetSYSPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetSYSPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetSYSPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0xffffff80) >> 7
}

// SYSCON.SYSPLLSTAT: System PLL status
func (o *SYSCON_Type) SetSYSPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.RTCOSCCTRL: RTC oscillator 32 kHz output control
func (o *SYSCON_Type) SetRTCOSCCTRL_RTCOSCEN(value uint32) {
	volatile.StoreUint32(&o.RTCOSCCTRL.Reg, volatile.LoadUint32(&o.RTCOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetRTCOSCCTRL_RTCOSCEN() uint32 {
	return volatile.LoadUint32(&o.RTCOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetRTCOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTCOSCCTRL.Reg, volatile.LoadUint32(&o.RTCOSCCTRL.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetRTCOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTCOSCCTRL.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSOSCCTRL: System oscillator control
func (o *SYSCON_Type) SetSYSOSCCTRL_BYPASS(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_BYPASS() uint32 {
	return volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_FREQRANGE(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_FREQRANGE() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.WDTOSCCTRL: Watchdog oscillator control
func (o *SYSCON_Type) SetWDTOSCCTRL_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_DIVSEL() uint32 {
	return volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetWDTOSCCTRL_FREQSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_FREQSEL() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1e0) >> 5
}
func (o *SYSCON_Type) SetWDTOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0xfffffe00) >> 9
}

// SYSCON.IRCCTRL: IRC control
func (o *SYSCON_Type) SetIRCCTRL_TRIM(value uint32) {
	volatile.StoreUint32(&o.IRCCTRL.Reg, volatile.LoadUint32(&o.IRCCTRL.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIRCCTRL_TRIM() uint32 {
	return volatile.LoadUint32(&o.IRCCTRL.Reg) & 0xff
}
func (o *SYSCON_Type) SetIRCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRCCTRL.Reg, volatile.LoadUint32(&o.IRCCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIRCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRCCTRL.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSRSTSTAT: System reset status register
func (o *SYSCON_Type) SetSYSRSTSTAT_POR(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_POR() uint32 {
	return volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_EXTRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_WDT(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_WDT() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSRSTSTAT_BOD(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_BOD() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSRSTSTAT_SYSRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_SYSRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSRSTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSPLLCLKSEL: System PLL clock source select
func (o *SYSCON_Type) SetSYSPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSPLLCLKUEN: System PLL clock source update enable
func (o *SYSCON_Type) SetSYSPLLCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.MAINCLKSEL: Main clock source select
func (o *SYSCON_Type) SetMAINCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetMAINCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetMAINCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetMAINCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.MAINCLKUEN: Main clock source update enable
func (o *SYSCON_Type) SetMAINCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetMAINCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetMAINCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetMAINCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSAHBCLKDIV: System clock divider
func (o *SYSCON_Type) SetSYSAHBCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSYSAHBCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSAHBCLKCTRL: System clock control
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SYS(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SYS() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ROM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ROM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RAM0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RAM0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASHREG(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASHREG() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASHARRAY(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASHARRAY() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_I2C0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_GPIO(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_GPIO() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT16B0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT16B0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT16B1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT16B1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT32B0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT32B0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT32B1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT32B1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SSP0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SSP0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_USART0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_USART0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ADC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ADC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_WWDT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_WWDT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_IOCON(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_IOCON() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SSP1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SSP1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_PINT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_PINT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_USART1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_USART1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_USART2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_USART2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_USART3_4(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_USART3_4() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_GROUP0INT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_GROUP0INT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_GROUP1INT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_GROUP1INT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_I2C1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2000000) >> 25
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RAM1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RAM1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4000000) >> 26
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_USBSRAM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_USBSRAM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8000000) >> 27
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CRC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CRC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10000000) >> 28
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_DMA(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_DMA() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20000000) >> 29
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RTC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RTC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40000000) >> 30
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SCT0_1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SCT0_1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80000000) >> 31
}

// SYSCON.SSP0CLKDIV: SSP0 clock divider
func (o *SYSCON_Type) SetSSP0CLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SSP0CLKDIV.Reg, volatile.LoadUint32(&o.SSP0CLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSSP0CLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SSP0CLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSSP0CLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SSP0CLKDIV.Reg, volatile.LoadUint32(&o.SSP0CLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSSP0CLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SSP0CLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.USART0CLKDIV: USART0 clock divider
func (o *SYSCON_Type) SetUSART0CLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.USART0CLKDIV.Reg, volatile.LoadUint32(&o.USART0CLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUSART0CLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.USART0CLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUSART0CLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USART0CLKDIV.Reg, volatile.LoadUint32(&o.USART0CLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUSART0CLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USART0CLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SSP1CLKDIV: SSP1 clock divider
func (o *SYSCON_Type) SetSSP1CLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SSP1CLKDIV.Reg, volatile.LoadUint32(&o.SSP1CLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSSP1CLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SSP1CLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSSP1CLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SSP1CLKDIV.Reg, volatile.LoadUint32(&o.SSP1CLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSSP1CLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SSP1CLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.FRGCLKDIV: Clock divider for the common fractional baud rate generator of USART1, USART2, USART3, USART4
func (o *SYSCON_Type) SetFRGCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.FRGCLKDIV.Reg, volatile.LoadUint32(&o.FRGCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetFRGCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.FRGCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetFRGCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FRGCLKDIV.Reg, volatile.LoadUint32(&o.FRGCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetFRGCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FRGCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.CLKOUTSEL: CLKOUT clock source select
func (o *SYSCON_Type) SetCLKOUTSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKOUTSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKOUTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKOUTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CLKOUTUEN: CLKOUT clock source update enable
func (o *SYSCON_Type) SetCLKOUTUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetCLKOUTUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetCLKOUTUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetCLKOUTUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.CLKOUTDIV: CLKOUT clock divider
func (o *SYSCON_Type) SetCLKOUTDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetCLKOUTDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetCLKOUTDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetCLKOUTDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTFRGDIV: USART fractional generator divider value
func (o *SYSCON_Type) SetUARTFRGDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.UARTFRGDIV.Reg, volatile.LoadUint32(&o.UARTFRGDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTFRGDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.UARTFRGDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTFRGDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTFRGDIV.Reg, volatile.LoadUint32(&o.UARTFRGDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTFRGDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTFRGDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTFRGMULT: USART fractional generator multiplier value
func (o *SYSCON_Type) SetUARTFRGMULT_MULT(value uint32) {
	volatile.StoreUint32(&o.UARTFRGMULT.Reg, volatile.LoadUint32(&o.UARTFRGMULT.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTFRGMULT_MULT() uint32 {
	return volatile.LoadUint32(&o.UARTFRGMULT.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTFRGMULT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTFRGMULT.Reg, volatile.LoadUint32(&o.UARTFRGMULT.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTFRGMULT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTFRGMULT.Reg) & 0xffffff00) >> 8
}

// SYSCON.EXTTRACECMD: External trace buffer command register
func (o *SYSCON_Type) SetEXTTRACECMD_START(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetEXTTRACECMD_START() uint32 {
	return volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0x1
}
func (o *SYSCON_Type) SetEXTTRACECMD_STOP(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetEXTTRACECMD_STOP() uint32 {
	return (volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetEXTTRACECMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetEXTTRACECMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PIOPORCAP0: POR captured PIO status 0
func (o *SYSCON_Type) SetPIOPORCAP0_PIOSTAT(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, volatile.LoadUint32(&o.PIOPORCAP0.Reg)&^(0xffffff)|value)
}
func (o *SYSCON_Type) GetPIOPORCAP0_PIOSTAT() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP0.Reg) & 0xffffff
}
func (o *SYSCON_Type) SetPIOPORCAP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, volatile.LoadUint32(&o.PIOPORCAP0.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCON_Type) GetPIOPORCAP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIOPORCAP0.Reg) & 0xff000000) >> 24
}

// SYSCON.PIOPORCAP1: POR captured PIO status 1
func (o *SYSCON_Type) SetPIOPORCAP1(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP1.Reg, value)
}
func (o *SYSCON_Type) GetPIOPORCAP1() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP1.Reg)
}

// SYSCON.PIOPORCAP2: POR captured PIO status 1
func (o *SYSCON_Type) SetPIOPORCAP2_PIOSTAT(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP2.Reg, volatile.LoadUint32(&o.PIOPORCAP2.Reg)&^(0xffffff)|value)
}
func (o *SYSCON_Type) GetPIOPORCAP2_PIOSTAT() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP2.Reg) & 0xffffff
}

// SYSCON.IOCONCLKDIV6: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV6_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV6.Reg, volatile.LoadUint32(&o.IOCONCLKDIV6.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV6_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV6.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV6.Reg, volatile.LoadUint32(&o.IOCONCLKDIV6.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV6.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV5: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV5_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV5.Reg, volatile.LoadUint32(&o.IOCONCLKDIV5.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV5_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV5.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV5.Reg, volatile.LoadUint32(&o.IOCONCLKDIV5.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV5.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV4: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV4_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV4.Reg, volatile.LoadUint32(&o.IOCONCLKDIV4.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV4_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV4.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV4.Reg, volatile.LoadUint32(&o.IOCONCLKDIV4.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV4.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV3: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV3_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV3.Reg, volatile.LoadUint32(&o.IOCONCLKDIV3.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV3_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV3.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV3.Reg, volatile.LoadUint32(&o.IOCONCLKDIV3.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV3.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV2: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV2_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV2.Reg, volatile.LoadUint32(&o.IOCONCLKDIV2.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV2_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV2.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV2.Reg, volatile.LoadUint32(&o.IOCONCLKDIV2.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV2.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV1: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV1_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV1.Reg, volatile.LoadUint32(&o.IOCONCLKDIV1.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV1_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV1.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV1.Reg, volatile.LoadUint32(&o.IOCONCLKDIV1.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV1.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV0: Peripheral clock to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV0_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV0.Reg, volatile.LoadUint32(&o.IOCONCLKDIV0.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV0_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV0.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV0.Reg, volatile.LoadUint32(&o.IOCONCLKDIV0.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV0.Reg) & 0xffffff00) >> 8
}

// SYSCON.BODCTRL: Brown-Out Detect
func (o *SYSCON_Type) SetBODCTRL_BODRSTLEV(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTLEV() uint32 {
	return volatile.LoadUint32(&o.BODCTRL.Reg) & 0x3
}
func (o *SYSCON_Type) SetBODCTRL_BODINTVAL(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetBODCTRL_BODINTVAL() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetBODCTRL_BODRSTENA(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTENA() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetBODCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetBODCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSTCKCAL: System tick counter calibration
func (o *SYSCON_Type) SetSYSTCKCAL_CAL(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0x3ffffff)|value)
}
func (o *SYSCON_Type) GetSYSTCKCAL_CAL() uint32 {
	return volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0x3ffffff
}
func (o *SYSCON_Type) SetSYSTCKCAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCON_Type) GetSYSTCKCAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0xfc000000) >> 26
}

// SYSCON.IRQLATENCY: IRQ delay. Allows trade-off between interrupt latency and determinism.
func (o *SYSCON_Type) SetIRQLATENCY_LATENCY(value uint32) {
	volatile.StoreUint32(&o.IRQLATENCY.Reg, volatile.LoadUint32(&o.IRQLATENCY.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIRQLATENCY_LATENCY() uint32 {
	return volatile.LoadUint32(&o.IRQLATENCY.Reg) & 0xff
}
func (o *SYSCON_Type) SetIRQLATENCY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQLATENCY.Reg, volatile.LoadUint32(&o.IRQLATENCY.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIRQLATENCY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQLATENCY.Reg) & 0xffffff00) >> 8
}

// SYSCON.NMISRC: NMI Source Control
func (o *SYSCON_Type) SetNMISRC_IRQN(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetNMISRC_IRQN() uint32 {
	return volatile.LoadUint32(&o.NMISRC.Reg) & 0x1f
}
func (o *SYSCON_Type) SetNMISRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x7fffffe0)|value<<5)
}
func (o *SYSCON_Type) GetNMISRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x7fffffe0) >> 5
}
func (o *SYSCON_Type) SetNMISRC_NMIEN(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetNMISRC_NMIEN() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x80000000) >> 31
}

// SYSCON.PINTSEL0: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL0_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL0_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL0.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL0.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL1: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL1_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL1_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL1.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL1.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL2: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL2_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL2_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL2.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL2.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL3: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL3_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL3_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL3.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL3.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL4: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL4_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL4_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL4.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL4.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL5: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL5_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL5_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL5.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL5.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL6: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL6_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL6_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL6.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL6.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL7: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL7_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL7_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL7.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL7.Reg) & 0xffffffc0) >> 6
}

// SYSCON.STARTERP0: Start logic 0 interrupt wake-up enable register 0
func (o *SYSCON_Type) SetSTARTERP0_PINT0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT0() uint32 {
	return volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1
}
func (o *SYSCON_Type) SetSTARTERP0_PINT1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSTARTERP0_PINT2(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT2() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSTARTERP0_PINT3(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT3() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSTARTERP0_PINT4(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT4() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSTARTERP0_PINT5(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT5() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSTARTERP0_PINT6(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT6() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSTARTERP0_PINT7(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT7() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0xffffff00) >> 8
}

// SYSCON.STARTERP1: Start logic 1 interrupt wake-up enable register 1
func (o *SYSCON_Type) SetSTARTERP1_RTCINT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSTARTERP1_RTCINT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSTARTERP1_WWDT_BODINT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSTARTERP1_WWDT_BODINT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x7c000)|value<<14)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x7c000) >> 14
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSTARTERP1_GROUP0INT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetSTARTERP1_GROUP0INT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetSTARTERP1_GROUP1INT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSTARTERP1_GROUP1INT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSTARTERP1_USART1_4(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSTARTERP1_USART1_4() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSTARTERP1_USART2_3(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetSTARTERP1_USART2_3() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x1000000) >> 24
}

// SYSCON.PDSLEEPCFG: Power-down states in deep-sleep mode
func (o *SYSCON_Type) SetPDSLEEPCFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDSLEEPCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0x30)|value<<4)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0x30) >> 4
}
func (o *SYSCON_Type) SetPDSLEEPCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDSLEEPCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0xffffff80) >> 7
}

// SYSCON.PDAWAKECFG: Power-down states for wake-up from deep-sleep
func (o *SYSCON_Type) SetPDAWAKECFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRCOUT_PD() uint32 {
	return volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x1
}
func (o *SYSCON_Type) SetPDAWAKECFG_IRC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPDAWAKECFG_FLASH_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPDAWAKECFG_FLASH_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPDAWAKECFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDAWAKECFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDAWAKECFG_ADC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ADC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDAWAKECFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDAWAKECFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPDAWAKECFG_TEMPSENSE_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPDAWAKECFG_TEMPSENSE_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0xffffc000)|value<<14)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0xffffc000) >> 14
}

// SYSCON.PDRUNCFG: Power configuration register
func (o *SYSCON_Type) SetPDRUNCFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRCOUT_PD() uint32 {
	return volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1
}
func (o *SYSCON_Type) SetPDRUNCFG_IRC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPDRUNCFG_FLASH_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPDRUNCFG_FLASH_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPDRUNCFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDRUNCFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDRUNCFG_ADC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDRUNCFG_ADC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDRUNCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDRUNCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPDRUNCFG_TEMPSENSE_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPDRUNCFG_TEMPSENSE_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xc000)|value<<14)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xc000) >> 14
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xffff0000) >> 16
}

// SYSCON.DEVICE_ID: Device ID
func (o *SYSCON_Type) SetDEVICE_ID(value uint32) {
	volatile.StoreUint32(&o.DEVICE_ID.Reg, value)
}
func (o *SYSCON_Type) GetDEVICE_ID() uint32 {
	return volatile.LoadUint32(&o.DEVICE_ID.Reg)
}

// USART4
type USART4_Type struct {
	CFG       volatile.Register32 // 0x0
	CTL       volatile.Register32 // 0x4
	STAT      volatile.Register32 // 0x8
	INTENSET  volatile.Register32 // 0xC
	INTENCLR  volatile.Register32 // 0x10
	RXDAT     volatile.Register32 // 0x14
	RXDATSTAT volatile.Register32 // 0x18
	TXDAT     volatile.Register32 // 0x1C
	BRG       volatile.Register32 // 0x20
	INTSTAT   volatile.Register32 // 0x24
	OSR       volatile.Register32 // 0x28
	ADDR      volatile.Register32 // 0x2C
}

// USART4.CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
func (o *USART4_Type) SetCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetCFG_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetCFG_DATALEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xc)|value<<2)
}
func (o *USART4_Type) GetCFG_DATALEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xc) >> 2
}
func (o *USART4_Type) SetCFG_PARITYSEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x30)|value<<4)
}
func (o *USART4_Type) GetCFG_PARITYSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x30) >> 4
}
func (o *USART4_Type) SetCFG_STOPLEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetCFG_STOPLEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetCFG_MODE32K(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetCFG_MODE32K() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetCFG_CTSEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *USART4_Type) GetCFG_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400)|value<<10)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400) >> 10
}
func (o *USART4_Type) SetCFG_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800)|value<<11)
}
func (o *USART4_Type) GetCFG_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800) >> 11
}
func (o *USART4_Type) SetCFG_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *USART4_Type) GetCFG_CLKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetCFG_SYNCMST(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetCFG_SYNCMST() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetCFG_LOOP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetCFG_LOOP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x30000)|value<<16)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x30000) >> 16
}
func (o *USART4_Type) SetCFG_OETA(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40000)|value<<18)
}
func (o *USART4_Type) GetCFG_OETA() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40000) >> 18
}
func (o *USART4_Type) SetCFG_AUTOADDR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80000)|value<<19)
}
func (o *USART4_Type) GetCFG_AUTOADDR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80000) >> 19
}
func (o *USART4_Type) SetCFG_OESEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100000)|value<<20)
}
func (o *USART4_Type) GetCFG_OESEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100000) >> 20
}
func (o *USART4_Type) SetCFG_OEPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200000)|value<<21)
}
func (o *USART4_Type) GetCFG_OEPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200000) >> 21
}
func (o *USART4_Type) SetCFG_RXPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400000)|value<<22)
}
func (o *USART4_Type) GetCFG_RXPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400000) >> 22
}
func (o *USART4_Type) SetCFG_TXPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800000)|value<<23)
}
func (o *USART4_Type) GetCFG_TXPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800000) >> 23
}
func (o *USART4_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xff000000)|value<<24)
}
func (o *USART4_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xff000000) >> 24
}

// USART4.CTL: USART Control register. USART control settings that are more likely to change during operation.
func (o *USART4_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetCTL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x1
}
func (o *USART4_Type) SetCTL_TXBRKEN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetCTL_TXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetCTL_ADDRDET(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x4)|value<<2)
}
func (o *USART4_Type) GetCTL_ADDRDET() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x4) >> 2
}
func (o *USART4_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x38)|value<<3)
}
func (o *USART4_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x38) >> 3
}
func (o *USART4_Type) SetCTL_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetCTL_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetCTL_CC(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetCTL_CC() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetCTL_CLRCCONRX(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200)|value<<9)
}
func (o *USART4_Type) GetCTL_CLRCCONRX() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200) >> 9
}
func (o *USART4_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xfc00)|value<<10)
}
func (o *USART4_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xfc00) >> 10
}
func (o *USART4_Type) SetCTL_AUTOBAUD(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x10000)|value<<16)
}
func (o *USART4_Type) GetCTL_AUTOBAUD() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x10000) >> 16
}
func (o *USART4_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART4_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xfffe0000) >> 17
}

// USART4.STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
func (o *USART4_Type) SetSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *USART4_Type) SetSTAT_RXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetSTAT_RXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *USART4_Type) GetSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *USART4_Type) SetSTAT_TXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *USART4_Type) GetSTAT_TXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *USART4_Type) SetSTAT_CTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *USART4_Type) GetSTAT_CTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *USART4_Type) SetSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *USART4_Type) GetSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *USART4_Type) SetSTAT_TXDISSTAT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetSTAT_TXDISSTAT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200)|value<<9)
}
func (o *USART4_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200) >> 9
}
func (o *USART4_Type) SetSTAT_RXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400)|value<<10)
}
func (o *USART4_Type) GetSTAT_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400) >> 10
}
func (o *USART4_Type) SetSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *USART4_Type) GetSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *USART4_Type) SetSTAT_START(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART4_Type) GetSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000) >> 12
}
func (o *USART4_Type) SetSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetSTAT_ABERR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *USART4_Type) GetSTAT_ABERR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *USART4_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART4_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffe0000) >> 17
}

// USART4.INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
func (o *USART4_Type) SetINTENSET_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetINTENSET_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USART4_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetINTENSET_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USART4_Type) GetINTENSET_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USART4_Type) SetINTENSET_TXIDLEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USART4_Type) GetINTENSET_TXIDLEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USART4_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USART4_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USART4_Type) SetINTENSET_DELTACTSEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USART4_Type) GetINTENSET_DELTACTSEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USART4_Type) SetINTENSET_TXDISEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetINTENSET_TXDISEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetINTENSET_OVERRUNEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetINTENSET_OVERRUNEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x600)|value<<9)
}
func (o *USART4_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x600) >> 9
}
func (o *USART4_Type) SetINTENSET_DELTARXBRKEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *USART4_Type) GetINTENSET_DELTARXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *USART4_Type) SetINTENSET_STARTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *USART4_Type) GetINTENSET_STARTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *USART4_Type) SetINTENSET_FRAMERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetINTENSET_FRAMERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetINTENSET_PARITYERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetINTENSET_PARITYERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetINTENSET_RXNOISEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetINTENSET_RXNOISEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetINTENSET_ABERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *USART4_Type) GetINTENSET_ABERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *USART4_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART4_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xfffe0000) >> 17
}

// USART4.INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
func (o *USART4_Type) SetINTENCLR_RXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetINTENCLR_RXRDYCLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USART4_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetINTENCLR_TXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USART4_Type) GetINTENCLR_TXRDYCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USART4_Type) SetINTENCLR_TXIDLECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USART4_Type) GetINTENCLR_TXIDLECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USART4_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USART4_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USART4_Type) SetINTENCLR_DELTACTSCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USART4_Type) GetINTENCLR_DELTACTSCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USART4_Type) SetINTENCLR_TXDISINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetINTENCLR_TXDISINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetINTENCLR_OVERRUNCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetINTENCLR_OVERRUNCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x600)|value<<9)
}
func (o *USART4_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x600) >> 9
}
func (o *USART4_Type) SetINTENCLR_DELTARXBRKCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *USART4_Type) GetINTENCLR_DELTARXBRKCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *USART4_Type) SetINTENCLR_STARTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USART4_Type) GetINTENCLR_STARTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *USART4_Type) SetINTENCLR_FRAMERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetINTENCLR_FRAMERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetINTENCLR_PARITYERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetINTENCLR_PARITYERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetINTENCLR_RXNOISECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetINTENCLR_RXNOISECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetINTENCLR_ABERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USART4_Type) GetINTENCLR_ABERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *USART4_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART4_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xfffe0000) >> 17
}

// USART4.RXDAT: Receiver Data register. Contains the last character received.
func (o *USART4_Type) SetRXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x1ff)|value)
}
func (o *USART4_Type) GetRXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDAT.Reg) & 0x1ff
}
func (o *USART4_Type) SetRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART4_Type) GetRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0xfffffe00) >> 9
}

// USART4.RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
func (o *USART4_Type) SetRXDATSTAT_RXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x1ff)|value)
}
func (o *USART4_Type) GetRXDATSTAT_RXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x1ff
}
func (o *USART4_Type) SetRXDATSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x1e00)|value<<9)
}
func (o *USART4_Type) GetRXDATSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x1e00) >> 9
}
func (o *USART4_Type) SetRXDATSTAT_FRAMERR(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetRXDATSTAT_FRAMERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetRXDATSTAT_PARITYERR(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetRXDATSTAT_PARITYERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetRXDATSTAT_RXNOISE(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetRXDATSTAT_RXNOISE() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetRXDATSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATSTAT.Reg, volatile.LoadUint32(&o.RXDATSTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART4_Type) GetRXDATSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATSTAT.Reg) & 0xffff0000) >> 16
}

// USART4.TXDAT: Transmit Data register. Data to be transmitted is written here.
func (o *USART4_Type) SetTXDAT(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0x1ff)|value)
}
func (o *USART4_Type) GetTXDAT() uint32 {
	return volatile.LoadUint32(&o.TXDAT.Reg) & 0x1ff
}
func (o *USART4_Type) SetTXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART4_Type) GetTXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDAT.Reg) & 0xfffffe00) >> 9
}

// USART4.BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
func (o *USART4_Type) SetBRG_BRGVAL(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff)|value)
}
func (o *USART4_Type) GetBRG_BRGVAL() uint32 {
	return volatile.LoadUint32(&o.BRG.Reg) & 0xffff
}
func (o *USART4_Type) SetBRG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART4_Type) GetBRG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BRG.Reg) & 0xffff0000) >> 16
}

// USART4.INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
func (o *USART4_Type) SetINTSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *USART4_Type) GetINTSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *USART4_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USART4_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *USART4_Type) SetINTSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USART4_Type) GetINTSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *USART4_Type) SetINTSTAT_TXIDLE(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USART4_Type) GetINTSTAT_TXIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *USART4_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USART4_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *USART4_Type) SetINTSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USART4_Type) GetINTSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *USART4_Type) SetINTSTAT_TXDISINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USART4_Type) GetINTSTAT_TXDISINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *USART4_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USART4_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *USART4_Type) SetINTSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *USART4_Type) GetINTSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *USART4_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x600)|value<<9)
}
func (o *USART4_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x600) >> 9
}
func (o *USART4_Type) SetINTSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *USART4_Type) GetINTSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *USART4_Type) SetINTSTAT_START(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART4_Type) GetINTSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000) >> 12
}
func (o *USART4_Type) SetINTSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART4_Type) GetINTSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000) >> 13
}
func (o *USART4_Type) SetINTSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART4_Type) GetINTSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4000) >> 14
}
func (o *USART4_Type) SetINTSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART4_Type) GetINTSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *USART4_Type) SetINTSTAT_ABERR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *USART4_Type) GetINTSTAT_ABERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10000) >> 16
}
func (o *USART4_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *USART4_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfffe0000) >> 17
}

// USART4.OSR: Oversample selection register for asynchronous communication.
func (o *USART4_Type) SetOSR_OSRVAL(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xf)|value)
}
func (o *USART4_Type) GetOSR_OSRVAL() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0xf
}
func (o *USART4_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USART4_Type) GetOSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xfffffff0) >> 4
}

// USART4.ADDR: Address register for automatic address matching.
func (o *USART4_Type) SetADDR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *USART4_Type) GetADDR_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}
func (o *USART4_Type) SetADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART4_Type) GetADDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xffffff00) >> 8
}

// GPIO group interrupt 0
type GINT0_Type struct {
	CTRL     volatile.Register32 // 0x0
	_        [28]byte
	PORT_POL [3]volatile.Register32 // 0x20
	_        [20]byte
	PORT_ENA [3]volatile.Register32 // 0x40
}

// GINT0.CTRL: GPIO grouped interrupt control register
func (o *GINT0_Type) SetCTRL_INT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *GINT0_Type) GetCTRL_INT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *GINT0_Type) SetCTRL_COMB(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *GINT0_Type) GetCTRL_COMB() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *GINT0_Type) SetCTRL_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *GINT0_Type) GetCTRL_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *GINT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *GINT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff8) >> 3
}

// GINT0.PORT_POL: GPIO grouped interrupt port 0 polarity register
func (o *GINT0_Type) SetPORT_POL_POL0(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1)|value)
}
func (o *GINT0_Type) GetPORT_POL_POL0(idx int) uint32 {
	return volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1
}
func (o *GINT0_Type) SetPORT_POL_POL1(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2)|value<<1)
}
func (o *GINT0_Type) GetPORT_POL_POL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2) >> 1
}
func (o *GINT0_Type) SetPORT_POL_POL2(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4)|value<<2)
}
func (o *GINT0_Type) GetPORT_POL_POL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4) >> 2
}
func (o *GINT0_Type) SetPORT_POL_POL3(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8)|value<<3)
}
func (o *GINT0_Type) GetPORT_POL_POL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8) >> 3
}
func (o *GINT0_Type) SetPORT_POL_POL4(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10)|value<<4)
}
func (o *GINT0_Type) GetPORT_POL_POL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10) >> 4
}
func (o *GINT0_Type) SetPORT_POL_POL5(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20)|value<<5)
}
func (o *GINT0_Type) GetPORT_POL_POL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20) >> 5
}
func (o *GINT0_Type) SetPORT_POL_POL6(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40)|value<<6)
}
func (o *GINT0_Type) GetPORT_POL_POL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40) >> 6
}
func (o *GINT0_Type) SetPORT_POL_POL7(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80)|value<<7)
}
func (o *GINT0_Type) GetPORT_POL_POL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80) >> 7
}
func (o *GINT0_Type) SetPORT_POL_POL8(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x100)|value<<8)
}
func (o *GINT0_Type) GetPORT_POL_POL8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x100) >> 8
}
func (o *GINT0_Type) SetPORT_POL_POL9(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x200)|value<<9)
}
func (o *GINT0_Type) GetPORT_POL_POL9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x200) >> 9
}
func (o *GINT0_Type) SetPORT_POL_POL10(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x400)|value<<10)
}
func (o *GINT0_Type) GetPORT_POL_POL10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x400) >> 10
}
func (o *GINT0_Type) SetPORT_POL_POL11(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x800)|value<<11)
}
func (o *GINT0_Type) GetPORT_POL_POL11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x800) >> 11
}
func (o *GINT0_Type) SetPORT_POL_POL12(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GINT0_Type) GetPORT_POL_POL12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1000) >> 12
}
func (o *GINT0_Type) SetPORT_POL_POL13(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GINT0_Type) GetPORT_POL_POL13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2000) >> 13
}
func (o *GINT0_Type) SetPORT_POL_POL14(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GINT0_Type) GetPORT_POL_POL14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4000) >> 14
}
func (o *GINT0_Type) SetPORT_POL_POL15(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GINT0_Type) GetPORT_POL_POL15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8000) >> 15
}
func (o *GINT0_Type) SetPORT_POL_POL16(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GINT0_Type) GetPORT_POL_POL16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10000) >> 16
}
func (o *GINT0_Type) SetPORT_POL_POL17(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GINT0_Type) GetPORT_POL_POL17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20000) >> 17
}
func (o *GINT0_Type) SetPORT_POL_POL18(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GINT0_Type) GetPORT_POL_POL18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40000) >> 18
}
func (o *GINT0_Type) SetPORT_POL_POL19(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GINT0_Type) GetPORT_POL_POL19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80000) >> 19
}
func (o *GINT0_Type) SetPORT_POL_POL20(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GINT0_Type) GetPORT_POL_POL20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x100000) >> 20
}
func (o *GINT0_Type) SetPORT_POL_POL21(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GINT0_Type) GetPORT_POL_POL21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x200000) >> 21
}
func (o *GINT0_Type) SetPORT_POL_POL22(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GINT0_Type) GetPORT_POL_POL22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x400000) >> 22
}
func (o *GINT0_Type) SetPORT_POL_POL23(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GINT0_Type) GetPORT_POL_POL23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x800000) >> 23
}
func (o *GINT0_Type) SetPORT_POL_POL24(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GINT0_Type) GetPORT_POL_POL24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x1000000) >> 24
}
func (o *GINT0_Type) SetPORT_POL_POL25(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GINT0_Type) GetPORT_POL_POL25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x2000000) >> 25
}
func (o *GINT0_Type) SetPORT_POL_POL26(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GINT0_Type) GetPORT_POL_POL26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x4000000) >> 26
}
func (o *GINT0_Type) SetPORT_POL_POL27(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GINT0_Type) GetPORT_POL_POL27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x8000000) >> 27
}
func (o *GINT0_Type) SetPORT_POL_POL28(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GINT0_Type) GetPORT_POL_POL28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x10000000) >> 28
}
func (o *GINT0_Type) SetPORT_POL_POL29(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GINT0_Type) GetPORT_POL_POL29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x20000000) >> 29
}
func (o *GINT0_Type) SetPORT_POL_POL30(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GINT0_Type) GetPORT_POL_POL30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x40000000) >> 30
}
func (o *GINT0_Type) SetPORT_POL_POL31(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_POL[idx].Reg, volatile.LoadUint32(&o.PORT_POL[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GINT0_Type) GetPORT_POL_POL31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_POL[idx].Reg) & 0x80000000) >> 31
}

// GINT0.PORT_ENA: GPIO grouped interrupt port enable register
func (o *GINT0_Type) SetPORT_ENA_ENA0(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1)|value)
}
func (o *GINT0_Type) GetPORT_ENA_ENA0(idx int) uint32 {
	return volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1
}
func (o *GINT0_Type) SetPORT_ENA_ENA1(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2)|value<<1)
}
func (o *GINT0_Type) GetPORT_ENA_ENA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2) >> 1
}
func (o *GINT0_Type) SetPORT_ENA_ENA2(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4)|value<<2)
}
func (o *GINT0_Type) GetPORT_ENA_ENA2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4) >> 2
}
func (o *GINT0_Type) SetPORT_ENA_ENA3(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8)|value<<3)
}
func (o *GINT0_Type) GetPORT_ENA_ENA3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8) >> 3
}
func (o *GINT0_Type) SetPORT_ENA_ENA4(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10)|value<<4)
}
func (o *GINT0_Type) GetPORT_ENA_ENA4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10) >> 4
}
func (o *GINT0_Type) SetPORT_ENA_ENA5(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20)|value<<5)
}
func (o *GINT0_Type) GetPORT_ENA_ENA5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20) >> 5
}
func (o *GINT0_Type) SetPORT_ENA_ENA6(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40)|value<<6)
}
func (o *GINT0_Type) GetPORT_ENA_ENA6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40) >> 6
}
func (o *GINT0_Type) SetPORT_ENA_ENA7(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80)|value<<7)
}
func (o *GINT0_Type) GetPORT_ENA_ENA7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80) >> 7
}
func (o *GINT0_Type) SetPORT_ENA_ENA8(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x100)|value<<8)
}
func (o *GINT0_Type) GetPORT_ENA_ENA8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x100) >> 8
}
func (o *GINT0_Type) SetPORT_ENA_ENA9(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x200)|value<<9)
}
func (o *GINT0_Type) GetPORT_ENA_ENA9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x200) >> 9
}
func (o *GINT0_Type) SetPORT_ENA_ENA10(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x400)|value<<10)
}
func (o *GINT0_Type) GetPORT_ENA_ENA10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x400) >> 10
}
func (o *GINT0_Type) SetPORT_ENA_ENA11(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x800)|value<<11)
}
func (o *GINT0_Type) GetPORT_ENA_ENA11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x800) >> 11
}
func (o *GINT0_Type) SetPORT_ENA_ENA12(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GINT0_Type) GetPORT_ENA_ENA12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1000) >> 12
}
func (o *GINT0_Type) SetPORT_ENA_ENA13(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GINT0_Type) GetPORT_ENA_ENA13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2000) >> 13
}
func (o *GINT0_Type) SetPORT_ENA_ENA14(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GINT0_Type) GetPORT_ENA_ENA14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4000) >> 14
}
func (o *GINT0_Type) SetPORT_ENA_ENA15(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GINT0_Type) GetPORT_ENA_ENA15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8000) >> 15
}
func (o *GINT0_Type) SetPORT_ENA_ENA16(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GINT0_Type) GetPORT_ENA_ENA16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10000) >> 16
}
func (o *GINT0_Type) SetPORT_ENA_ENA17(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GINT0_Type) GetPORT_ENA_ENA17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20000) >> 17
}
func (o *GINT0_Type) SetPORT_ENA_ENA18(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GINT0_Type) GetPORT_ENA_ENA18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40000) >> 18
}
func (o *GINT0_Type) SetPORT_ENA_ENA19(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GINT0_Type) GetPORT_ENA_ENA19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80000) >> 19
}
func (o *GINT0_Type) SetPORT_ENA_ENA20(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GINT0_Type) GetPORT_ENA_ENA20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x100000) >> 20
}
func (o *GINT0_Type) SetPORT_ENA_ENA21(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GINT0_Type) GetPORT_ENA_ENA21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x200000) >> 21
}
func (o *GINT0_Type) SetPORT_ENA_ENA22(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GINT0_Type) GetPORT_ENA_ENA22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x400000) >> 22
}
func (o *GINT0_Type) SetPORT_ENA_ENA23(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GINT0_Type) GetPORT_ENA_ENA23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x800000) >> 23
}
func (o *GINT0_Type) SetPORT_ENA_ENA24(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GINT0_Type) GetPORT_ENA_ENA24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x1000000) >> 24
}
func (o *GINT0_Type) SetPORT_ENA_ENA25(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GINT0_Type) GetPORT_ENA_ENA25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x2000000) >> 25
}
func (o *GINT0_Type) SetPORT_ENA_ENA26(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GINT0_Type) GetPORT_ENA_ENA26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x4000000) >> 26
}
func (o *GINT0_Type) SetPORT_ENA_ENA27(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GINT0_Type) GetPORT_ENA_ENA27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x8000000) >> 27
}
func (o *GINT0_Type) SetPORT_ENA_ENA28(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GINT0_Type) GetPORT_ENA_ENA28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x10000000) >> 28
}
func (o *GINT0_Type) SetPORT_ENA_ENA29(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GINT0_Type) GetPORT_ENA_ENA29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x20000000) >> 29
}
func (o *GINT0_Type) SetPORT_ENA_ENA30(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GINT0_Type) GetPORT_ENA_ENA30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x40000000) >> 30
}
func (o *GINT0_Type) SetPORT_ENA_ENA31(idx int, value uint32) {
	volatile.StoreUint32(&o.PORT_ENA[idx].Reg, volatile.LoadUint32(&o.PORT_ENA[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GINT0_Type) GetPORT_ENA_ENA31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA[idx].Reg) & 0x80000000) >> 31
}

// Cyclic Redundancy Check (CRC) engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// CRC.MODE: CRC mode register
func (o *CRC_Type) SetMODE_CRC_POLY(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *CRC_Type) GetMODE_CRC_POLY() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *CRC_Type) SetMODE_BIT_RVS_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *CRC_Type) GetMODE_BIT_RVS_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *CRC_Type) SetMODE_CMPL_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *CRC_Type) GetMODE_CMPL_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *CRC_Type) SetMODE_BIT_RVS_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *CRC_Type) GetMODE_BIT_RVS_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *CRC_Type) SetMODE_CMPL_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x20)|value<<5)
}
func (o *CRC_Type) GetMODE_CMPL_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x20) >> 5
}
func (o *CRC_Type) SetMODE_Reserved(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CRC_Type) GetMODE_Reserved() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0xffffffc0) >> 6
}

// CRC.SEED: CRC seed register
func (o *CRC_Type) SetSEED(value uint32) {
	volatile.StoreUint32(&o.SEED.Reg, value)
}
func (o *CRC_Type) GetSEED() uint32 {
	return volatile.LoadUint32(&o.SEED.Reg)
}

// CRC.SUM: CRC checksum register
func (o *CRC_Type) SetSUM(value uint32) {
	volatile.StoreUint32(&o.SUM.Reg, value)
}
func (o *CRC_Type) GetSUM() uint32 {
	return volatile.LoadUint32(&o.SUM.Reg)
}

// DMA controller
type DMA_Type struct {
	CTRL       volatile.Register32 // 0x0
	INTSTAT    volatile.Register32 // 0x4
	SRAMBASE   volatile.Register32 // 0x8
	_          [20]byte
	ENABLESET0 volatile.Register32 // 0x20
	_          [4]byte
	ENABLECLR0 volatile.Register32 // 0x28
	_          [4]byte
	ACTIVE0    volatile.Register32 // 0x30
	_          [4]byte
	BUSY0      volatile.Register32 // 0x38
	_          [4]byte
	ERRINT0    volatile.Register32 // 0x40
	_          [4]byte
	INTENSET0  volatile.Register32 // 0x48
	_          [4]byte
	INTENCLR0  volatile.Register32 // 0x50
	_          [4]byte
	INTA0      volatile.Register32 // 0x58
	_          [4]byte
	INTB0      volatile.Register32 // 0x60
	_          [4]byte
	SETVALID0  volatile.Register32 // 0x68
	_          [4]byte
	SETTRIG0   volatile.Register32 // 0x70
	_          [4]byte
	ABORT0     volatile.Register32 // 0x78
	_          [900]byte
	CFG0       volatile.Register32 // 0x400
	CTLSTAT0   volatile.Register32 // 0x404
	XFERCFG0   volatile.Register32 // 0x408
	_          [4]byte
	CFG1       volatile.Register32 // 0x410
	CTLSTAT1   volatile.Register32 // 0x414
	XFERCFG1   volatile.Register32 // 0x418
	_          [4]byte
	CFG2       volatile.Register32 // 0x420
	CTLSTAT2   volatile.Register32 // 0x424
	XFERCFG2   volatile.Register32 // 0x428
	_          [4]byte
	CFG3       volatile.Register32 // 0x430
	CTLSTAT3   volatile.Register32 // 0x434
	XFERCFG3   volatile.Register32 // 0x438
	_          [4]byte
	CFG4       volatile.Register32 // 0x440
	CTLSTAT4   volatile.Register32 // 0x444
	XFERCFG4   volatile.Register32 // 0x448
	_          [4]byte
	CFG5       volatile.Register32 // 0x450
	CTLSTAT5   volatile.Register32 // 0x454
	XFERCFG5   volatile.Register32 // 0x458
	_          [4]byte
	CFG6       volatile.Register32 // 0x460
	CTLSTAT6   volatile.Register32 // 0x464
	XFERCFG6   volatile.Register32 // 0x468
	_          [4]byte
	CFG7       volatile.Register32 // 0x470
	CTLSTAT7   volatile.Register32 // 0x474
	XFERCFG7   volatile.Register32 // 0x478
	_          [4]byte
	CFG8       volatile.Register32 // 0x480
	CTLSTAT8   volatile.Register32 // 0x484
	XFERCFG8   volatile.Register32 // 0x488
	_          [4]byte
	CFG9       volatile.Register32 // 0x490
	CTLSTAT9   volatile.Register32 // 0x494
	XFERCFG9   volatile.Register32 // 0x498
	_          [4]byte
	CFG10      volatile.Register32 // 0x4A0
	CTLSTAT10  volatile.Register32 // 0x4A4
	XFERCFG10  volatile.Register32 // 0x4A8
	_          [4]byte
	CFG11      volatile.Register32 // 0x4B0
	CTLSTAT11  volatile.Register32 // 0x4B4
	XFERCFG11  volatile.Register32 // 0x4B8
	_          [4]byte
	CFG12      volatile.Register32 // 0x4C0
	CTLSTAT12  volatile.Register32 // 0x4C4
	XFERCFG12  volatile.Register32 // 0x4C8
	_          [4]byte
	CFG13      volatile.Register32 // 0x4D0
	CTLSTAT13  volatile.Register32 // 0x4D4
	XFERCFG13  volatile.Register32 // 0x4D8
	_          [4]byte
	CFG14      volatile.Register32 // 0x4E0
	CTLSTAT14  volatile.Register32 // 0x4E4
	XFERCFG14  volatile.Register32 // 0x4E8
	_          [4]byte
	CFG15      volatile.Register32 // 0x4F0
	CTLSTAT15  volatile.Register32 // 0x4F4
	XFERCFG15  volatile.Register32 // 0x4F8
}

// DMA.CTRL: DMA control.
func (o *DMA_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *DMA_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffffe)|value<<1)
}
func (o *DMA_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffffe) >> 1
}

// DMA.INTSTAT: Interrupt status.
func (o *DMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINTSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *DMA_Type) SetINTSTAT_ACTIVEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINTSTAT_ACTIVEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINTSTAT_ACTIVEERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINTSTAT_ACTIVEERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfffffff8) >> 3
}

// DMA.SRAMBASE: SRAM address of the channel configuration table.
func (o *DMA_Type) SetSRAMBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SRAMBASE.Reg, volatile.LoadUint32(&o.SRAMBASE.Reg)&^(0x3ff)|value)
}
func (o *DMA_Type) GetSRAMBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SRAMBASE.Reg) & 0x3ff
}
func (o *DMA_Type) SetSRAMBASE_OFFSET(value uint32) {
	volatile.StoreUint32(&o.SRAMBASE.Reg, volatile.LoadUint32(&o.SRAMBASE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *DMA_Type) GetSRAMBASE_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.SRAMBASE.Reg) & 0xfffffc00) >> 10
}

// DMA.ENABLESET0: Channel Enable read and Set for all DMA channels.
func (o *DMA_Type) SetENABLESET0_ENA(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetENABLESET0_ENA() uint32 {
	return volatile.LoadUint32(&o.ENABLESET0.Reg) & 0xffff
}
func (o *DMA_Type) SetENABLESET0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENABLESET0.Reg, volatile.LoadUint32(&o.ENABLESET0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetENABLESET0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENABLESET0.Reg) & 0xffff0000) >> 16
}

// DMA.ENABLECLR0: Channel Enable Clear for all DMA channels.
func (o *DMA_Type) SetENABLECLR0_CLR(value uint32) {
	volatile.StoreUint32(&o.ENABLECLR0.Reg, volatile.LoadUint32(&o.ENABLECLR0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetENABLECLR0_CLR() uint32 {
	return volatile.LoadUint32(&o.ENABLECLR0.Reg) & 0xffff
}

// DMA.ACTIVE0: Channel Active status for all DMA channels.
func (o *DMA_Type) SetACTIVE0_ACT(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetACTIVE0_ACT() uint32 {
	return volatile.LoadUint32(&o.ACTIVE0.Reg) & 0xffff
}
func (o *DMA_Type) SetACTIVE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACTIVE0.Reg, volatile.LoadUint32(&o.ACTIVE0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetACTIVE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE0.Reg) & 0xffff0000) >> 16
}

// DMA.BUSY0: Channel Busy status for all DMA channels.
func (o *DMA_Type) SetBUSY0_BSY(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetBUSY0_BSY() uint32 {
	return volatile.LoadUint32(&o.BUSY0.Reg) & 0xffff
}
func (o *DMA_Type) SetBUSY0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BUSY0.Reg, volatile.LoadUint32(&o.BUSY0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetBUSY0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BUSY0.Reg) & 0xffff0000) >> 16
}

// DMA.ERRINT0: Error Interrupt status for all DMA channels.
func (o *DMA_Type) SetERRINT0_ERR(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetERRINT0_ERR() uint32 {
	return volatile.LoadUint32(&o.ERRINT0.Reg) & 0xffff
}
func (o *DMA_Type) SetERRINT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERRINT0.Reg, volatile.LoadUint32(&o.ERRINT0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetERRINT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERRINT0.Reg) & 0xfffc0000) >> 18
}

// DMA.INTENSET0: Interrupt Enable read and Set for all DMA channels.
func (o *DMA_Type) SetINTENSET0_INTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetINTENSET0_INTEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET0.Reg) & 0xffff
}
func (o *DMA_Type) SetINTENSET0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET0.Reg, volatile.LoadUint32(&o.INTENSET0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetINTENSET0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET0.Reg) & 0xffff0000) >> 16
}

// DMA.INTENCLR0: Interrupt Enable Clear for all DMA channels.
func (o *DMA_Type) SetINTENCLR0_CLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetINTENCLR0_CLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR0.Reg) & 0xffff
}
func (o *DMA_Type) SetINTENCLR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR0.Reg, volatile.LoadUint32(&o.INTENCLR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetINTENCLR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR0.Reg) & 0xffff0000) >> 16
}

// DMA.INTA0: Interrupt A status for all DMA channels.
func (o *DMA_Type) SetINTA0_IA(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetINTA0_IA() uint32 {
	return volatile.LoadUint32(&o.INTA0.Reg) & 0xffff
}
func (o *DMA_Type) SetINTA0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTA0.Reg, volatile.LoadUint32(&o.INTA0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetINTA0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTA0.Reg) & 0xffff0000) >> 16
}

// DMA.INTB0: Interrupt B status for all DMA channels.
func (o *DMA_Type) SetINTB0_IB(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetINTB0_IB() uint32 {
	return volatile.LoadUint32(&o.INTB0.Reg) & 0xffff
}
func (o *DMA_Type) SetINTB0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTB0.Reg, volatile.LoadUint32(&o.INTB0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetINTB0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTB0.Reg) & 0xffff0000) >> 16
}

// DMA.SETVALID0: Set ValidPending control bits for all DMA channels.
func (o *DMA_Type) SetSETVALID0_SV(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetSETVALID0_SV() uint32 {
	return volatile.LoadUint32(&o.SETVALID0.Reg) & 0xffff
}
func (o *DMA_Type) SetSETVALID0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SETVALID0.Reg, volatile.LoadUint32(&o.SETVALID0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetSETVALID0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SETVALID0.Reg) & 0xffff0000) >> 16
}

// DMA.SETTRIG0: Set Trigger control bits for all DMA channels.
func (o *DMA_Type) SetSETTRIG0_TRIG(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetSETTRIG0_TRIG() uint32 {
	return volatile.LoadUint32(&o.SETTRIG0.Reg) & 0xffff
}
func (o *DMA_Type) SetSETTRIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SETTRIG0.Reg, volatile.LoadUint32(&o.SETTRIG0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetSETTRIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SETTRIG0.Reg) & 0xffff0000) >> 16
}

// DMA.ABORT0: Channel Abort control for all DMA channels.
func (o *DMA_Type) SetABORT0_AORTCTRL(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetABORT0_AORTCTRL() uint32 {
	return volatile.LoadUint32(&o.ABORT0.Reg) & 0xffff
}
func (o *DMA_Type) SetABORT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ABORT0.Reg, volatile.LoadUint32(&o.ABORT0.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMA_Type) GetABORT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ABORT0.Reg) & 0xffff0000) >> 16
}

// DMA.CFG0: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG0_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG0_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0x1
}
func (o *DMA_Type) SetCFG0_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG0_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG0_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG0_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG0_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG0_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG0_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG0_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG0_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG0_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG0_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG0_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG0_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG0_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG0_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG0_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT0: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT0_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT0_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT0_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT0_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT0.Reg, volatile.LoadUint32(&o.CTLSTAT0.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT0.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG0: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG0_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG0_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG0_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG0_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG0_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG0_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG0_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG0_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG0_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG0_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG0_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG0_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG0_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG0_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG0_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG0_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG0_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG0_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG0_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG0_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG0.Reg, volatile.LoadUint32(&o.XFERCFG0.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG0.Reg) & 0xfc000000) >> 26
}

// DMA.CFG1: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG1_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG1_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x1
}
func (o *DMA_Type) SetCFG1_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG1_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG1_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG1_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG1_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG1_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG1_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG1_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG1_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG1_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG1_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG1_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG1_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG1_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG1_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG1_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT1: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT1_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT1_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT1_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT1_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT1.Reg, volatile.LoadUint32(&o.CTLSTAT1.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT1.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG1: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG1_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG1_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG1_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG1_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG1_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG1_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG1_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG1_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG1_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG1_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG1_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG1_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG1_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG1_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG1_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG1_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG1_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG1_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG1_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG1_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG1.Reg, volatile.LoadUint32(&o.XFERCFG1.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG1.Reg) & 0xfc000000) >> 26
}

// DMA.CFG2: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG2_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG2_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x1
}
func (o *DMA_Type) SetCFG2_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG2_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG2_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG2_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG2_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG2_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG2_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG2_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG2_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG2_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG2_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG2_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG2_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG2_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG2_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG2_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT2: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT2_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT2_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT2_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT2_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT2.Reg, volatile.LoadUint32(&o.CTLSTAT2.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT2.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG2: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG2_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG2_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG2_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG2_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG2_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG2_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG2_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG2_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG2_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG2_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG2_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG2_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG2_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG2_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG2_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG2_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG2_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG2_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG2.Reg, volatile.LoadUint32(&o.XFERCFG2.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG2.Reg) & 0xfc000000) >> 26
}

// DMA.CFG3: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG3_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG3_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0x1
}
func (o *DMA_Type) SetCFG3_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG3_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG3_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG3_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG3_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG3_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG3_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG3_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG3_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG3_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG3_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG3_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG3_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG3_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG3_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG3_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT3: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT3_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT3_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT3_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT3_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT3.Reg, volatile.LoadUint32(&o.CTLSTAT3.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT3.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG3: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG3_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG3_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG3_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG3_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG3_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG3_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG3_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG3_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG3_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG3_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG3_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG3_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG3_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG3_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG3_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG3_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG3_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG3_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG3_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG3_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG3.Reg, volatile.LoadUint32(&o.XFERCFG3.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG3.Reg) & 0xfc000000) >> 26
}

// DMA.CFG4: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG4_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG4_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0x1
}
func (o *DMA_Type) SetCFG4_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG4_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG4_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG4_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG4_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG4_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG4_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG4_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG4_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG4_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG4_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG4_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG4_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG4_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG4_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG4_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT4: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT4_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT4_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT4_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT4_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT4.Reg, volatile.LoadUint32(&o.CTLSTAT4.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT4.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG4: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG4_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG4_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG4_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG4_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG4_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG4_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG4_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG4_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG4_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG4_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG4_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG4_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG4_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG4_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG4_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG4_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG4_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG4_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG4_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG4_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG4.Reg, volatile.LoadUint32(&o.XFERCFG4.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG4.Reg) & 0xfc000000) >> 26
}

// DMA.CFG5: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG5_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG5_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0x1
}
func (o *DMA_Type) SetCFG5_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG5_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG5_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG5_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG5_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG5_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG5_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG5_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG5_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG5_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG5_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG5_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG5_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG5_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG5_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG5_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT5: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT5_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT5_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT5_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT5_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT5.Reg, volatile.LoadUint32(&o.CTLSTAT5.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT5.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG5: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG5_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG5_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG5_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG5_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG5_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG5_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG5_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG5_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG5_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG5_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG5_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG5_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG5_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG5_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG5_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG5_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG5_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG5_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG5_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG5_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG5.Reg, volatile.LoadUint32(&o.XFERCFG5.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG5.Reg) & 0xfc000000) >> 26
}

// DMA.CFG6: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG6_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG6_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG6.Reg) & 0x1
}
func (o *DMA_Type) SetCFG6_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG6_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG6_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG6_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG6_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG6_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG6_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG6_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG6_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG6_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG6_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG6_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG6_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG6_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG6_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG6_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT6: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT6_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT6_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT6_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT6_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT6.Reg, volatile.LoadUint32(&o.CTLSTAT6.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT6.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG6: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG6_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG6_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG6_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG6_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG6_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG6_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG6_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG6_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG6_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG6_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG6_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG6_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG6_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG6_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG6_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG6_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG6_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG6_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG6_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG6_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG6.Reg, volatile.LoadUint32(&o.XFERCFG6.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG6.Reg) & 0xfc000000) >> 26
}

// DMA.CFG7: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG7_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG7_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG7.Reg) & 0x1
}
func (o *DMA_Type) SetCFG7_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG7_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG7_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG7_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG7_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG7_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG7_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG7_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG7_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG7_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG7_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG7_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG7_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG7_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG7_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG7_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT7: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT7_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT7_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT7_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT7_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT7.Reg, volatile.LoadUint32(&o.CTLSTAT7.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT7.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG7: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG7_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG7_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG7_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG7_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG7_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG7_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG7_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG7_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG7_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG7_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG7_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG7_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG7_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG7_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG7_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG7_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG7_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG7_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG7_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG7_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG7.Reg, volatile.LoadUint32(&o.XFERCFG7.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG7.Reg) & 0xfc000000) >> 26
}

// DMA.CFG8: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG8_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG8_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG8.Reg) & 0x1
}
func (o *DMA_Type) SetCFG8_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG8_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG8_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG8_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG8_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG8_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG8_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG8_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG8_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG8_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG8_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG8_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG8_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG8_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG8_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG8_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG8.Reg, volatile.LoadUint32(&o.CFG8.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG8.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT8: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT8_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT8_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT8_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT8_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT8.Reg, volatile.LoadUint32(&o.CTLSTAT8.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT8.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG8: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG8_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG8_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG8_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG8_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG8_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG8_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG8_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG8_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG8_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG8_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG8_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG8_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG8_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG8_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG8_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG8_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG8_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG8_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG8_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG8_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG8.Reg, volatile.LoadUint32(&o.XFERCFG8.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG8.Reg) & 0xfc000000) >> 26
}

// DMA.CFG9: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG9_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG9_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG9.Reg) & 0x1
}
func (o *DMA_Type) SetCFG9_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG9_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG9_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG9_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG9_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG9_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG9_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG9_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG9_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG9_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG9_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG9_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG9_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG9_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG9_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG9_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG9.Reg, volatile.LoadUint32(&o.CFG9.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG9.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT9: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT9_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT9_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT9_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT9_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT9.Reg, volatile.LoadUint32(&o.CTLSTAT9.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT9.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG9: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG9_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG9_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG9_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG9_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG9_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG9_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG9_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG9_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG9_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG9_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG9_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG9_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG9_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG9_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG9_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG9_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG9_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG9_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG9_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG9_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG9.Reg, volatile.LoadUint32(&o.XFERCFG9.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG9.Reg) & 0xfc000000) >> 26
}

// DMA.CFG10: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG10_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG10_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG10.Reg) & 0x1
}
func (o *DMA_Type) SetCFG10_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG10_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG10_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG10_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG10_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG10_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG10_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG10_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG10_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG10_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG10_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG10_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG10_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG10_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG10_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG10_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG10.Reg, volatile.LoadUint32(&o.CFG10.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG10.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT10: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT10_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT10_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT10_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT10_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT10.Reg, volatile.LoadUint32(&o.CTLSTAT10.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT10.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG10: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG10_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG10_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG10_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG10_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG10_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG10_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG10_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG10_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG10_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG10_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG10_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG10_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG10_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG10_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG10_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG10_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG10_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG10_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG10_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG10_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG10.Reg, volatile.LoadUint32(&o.XFERCFG10.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG10.Reg) & 0xfc000000) >> 26
}

// DMA.CFG11: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG11_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG11_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG11.Reg) & 0x1
}
func (o *DMA_Type) SetCFG11_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG11_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG11_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG11_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG11_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG11_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG11_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG11_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG11_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG11_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG11_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG11_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG11_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG11_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG11_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG11_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG11.Reg, volatile.LoadUint32(&o.CFG11.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG11.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT11: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT11_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT11_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT11_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT11_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT11.Reg, volatile.LoadUint32(&o.CTLSTAT11.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT11.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG11: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG11_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG11_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG11_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG11_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG11_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG11_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG11_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG11_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG11_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG11_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG11_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG11_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG11_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG11_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG11_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG11_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG11_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG11_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG11_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG11_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG11.Reg, volatile.LoadUint32(&o.XFERCFG11.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG11.Reg) & 0xfc000000) >> 26
}

// DMA.CFG12: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG12_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG12_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG12.Reg) & 0x1
}
func (o *DMA_Type) SetCFG12_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG12_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG12_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG12_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG12_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG12_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG12_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG12_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG12_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG12_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG12_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG12_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG12_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG12_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG12_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG12_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG12.Reg, volatile.LoadUint32(&o.CFG12.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG12.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT12: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT12_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT12_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT12_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT12_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT12.Reg, volatile.LoadUint32(&o.CTLSTAT12.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT12.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG12: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG12_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG12_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG12_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG12_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG12_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG12_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG12_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG12_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG12_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG12_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG12_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG12_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG12_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG12_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG12_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG12_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG12_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG12_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG12_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG12_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG12.Reg, volatile.LoadUint32(&o.XFERCFG12.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG12.Reg) & 0xfc000000) >> 26
}

// DMA.CFG13: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG13_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG13_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG13.Reg) & 0x1
}
func (o *DMA_Type) SetCFG13_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG13_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG13_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG13_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG13_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG13_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG13_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG13_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG13_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG13_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG13_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG13_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG13_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG13_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG13_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG13_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG13.Reg, volatile.LoadUint32(&o.CFG13.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG13.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT13: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT13_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT13_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT13_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT13_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT13.Reg, volatile.LoadUint32(&o.CTLSTAT13.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT13.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG13: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG13_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG13_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG13_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG13_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG13_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG13_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG13_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG13_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG13_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG13_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG13_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG13_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG13_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG13_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG13_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG13_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG13_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG13_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG13_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG13_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG13.Reg, volatile.LoadUint32(&o.XFERCFG13.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG13.Reg) & 0xfc000000) >> 26
}

// DMA.CFG14: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG14_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG14_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG14.Reg) & 0x1
}
func (o *DMA_Type) SetCFG14_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG14_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG14_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG14_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG14_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG14_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG14_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG14_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG14_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG14_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG14_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG14_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG14_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG14_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG14_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG14_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG14.Reg, volatile.LoadUint32(&o.CFG14.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG14.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT14: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT14_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT14_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT14_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT14_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT14.Reg, volatile.LoadUint32(&o.CTLSTAT14.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT14.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG14: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG14_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG14_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG14_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG14_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG14_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG14_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG14_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG14_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG14_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG14_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG14_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG14_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG14_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG14_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG14_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG14_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG14_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG14_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG14_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG14_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG14.Reg, volatile.LoadUint32(&o.XFERCFG14.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG14.Reg) & 0xfc000000) >> 26
}

// DMA.CFG15: Configuration register for DMA channel 0.
func (o *DMA_Type) SetCFG15_PERIPHREQEN(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCFG15_PERIPHREQEN() uint32 {
	return volatile.LoadUint32(&o.CFG15.Reg) & 0x1
}
func (o *DMA_Type) SetCFG15_HWTRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCFG15_HWTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetCFG15_TRIGPOL(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCFG15_TRIGPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCFG15_TRIGTYPE(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCFG15_TRIGTYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCFG15_TRIGBURST(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCFG15_TRIGBURST() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCFG15_BURSTPOWER(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCFG15_BURSTPOWER() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCFG15_SRCBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCFG15_SRCBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCFG15_DSTBURSTWRAP(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetCFG15_DSTBURSTWRAP() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetCFG15_CHPRIORITY(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetCFG15_CHPRIORITY() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG15.Reg, volatile.LoadUint32(&o.CFG15.Reg)&^(0xfffc0000)|value<<18)
}
func (o *DMA_Type) GetCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG15.Reg) & 0xfffc0000) >> 18
}

// DMA.CTLSTAT15: Control and status register for DMA channel 0.
func (o *DMA_Type) SetCTLSTAT15_VALIDPENDING(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCTLSTAT15_VALIDPENDING() uint32 {
	return volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x1
}
func (o *DMA_Type) SetCTLSTAT15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCTLSTAT15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCTLSTAT15_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCTLSTAT15_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCTLSTAT15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTLSTAT15.Reg, volatile.LoadUint32(&o.CTLSTAT15.Reg)&^(0xfffffff8)|value<<3)
}
func (o *DMA_Type) GetCTLSTAT15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTLSTAT15.Reg) & 0xfffffff8) >> 3
}

// DMA.XFERCFG15: Transfer configuration register for DMA channel 0.
func (o *DMA_Type) SetXFERCFG15_CFGVALID(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetXFERCFG15_CFGVALID() uint32 {
	return volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x1
}
func (o *DMA_Type) SetXFERCFG15_RELOAD(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetXFERCFG15_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetXFERCFG15_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetXFERCFG15_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetXFERCFG15_CLRTRIG(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetXFERCFG15_CLRTRIG() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetXFERCFG15_SETINTA(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetXFERCFG15_SETINTA() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetXFERCFG15_SETINTB(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetXFERCFG15_SETINTB() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetXFERCFG15_WIDTH(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetXFERCFG15_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetXFERCFG15_SRCINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetXFERCFG15_SRCINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetXFERCFG15_DSTINC(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetXFERCFG15_DSTINC() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xc000) >> 14
}
func (o *DMA_Type) SetXFERCFG15_XFERCOUNT(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMA_Type) GetXFERCFG15_XFERCOUNT() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0x3ff0000) >> 16
}
func (o *DMA_Type) SetXFERCFG15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.XFERCFG15.Reg, volatile.LoadUint32(&o.XFERCFG15.Reg)&^(0xfc000000)|value<<26)
}
func (o *DMA_Type) GetXFERCFG15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.XFERCFG15.Reg) & 0xfc000000) >> 26
}

// State Configurable Timers (SCTimer/PWM)
type SCT0_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	_             [236]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	_             [236]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	_             [464]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
}

// SCT0.CONFIG: SCT configuration register
func (o *SCT0_Type) SetCONFIG_UNIFY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetCONFIG_UNIFY() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SCT0_Type) SetCONFIG_CLKMODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *SCT0_Type) GetCONFIG_CLKMODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x6) >> 1
}
func (o *SCT0_Type) SetCONFIG_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x78)|value<<3)
}
func (o *SCT0_Type) GetCONFIG_CKSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x78) >> 3
}
func (o *SCT0_Type) SetCONFIG_NORELAOD_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *SCT0_Type) GetCONFIG_NORELAOD_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x80) >> 7
}
func (o *SCT0_Type) SetCONFIG_NORELOAD_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SCT0_Type) GetCONFIG_NORELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *SCT0_Type) SetCONFIG_INSYNC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1fe00)|value<<9)
}
func (o *SCT0_Type) GetCONFIG_INSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1fe00) >> 9
}
func (o *SCT0_Type) SetCONFIG_AUTOLIMIT_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetCONFIG_AUTOLIMIT_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetCONFIG_AUTOLIMIT_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetCONFIG_AUTOLIMIT_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *SCT0_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfff80000) >> 19
}

// SCT0.CTRL: SCT control register
func (o *SCT0_Type) SetCTRL_DOWN_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetCTRL_DOWN_L() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SCT0_Type) SetCTRL_STOP_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCT0_Type) GetCTRL_STOP_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SCT0_Type) SetCTRL_HALT_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCT0_Type) GetCTRL_HALT_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SCT0_Type) SetCTRL_CLRCTR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCT0_Type) GetCTRL_CLRCTR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SCT0_Type) SetCTRL_BIDIR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetCTRL_BIDIR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetCTRL_PRE_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe0)|value<<5)
}
func (o *SCT0_Type) GetCTRL_PRE_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe0) >> 5
}
func (o *SCT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe000)|value<<13)
}
func (o *SCT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe000) >> 13
}
func (o *SCT0_Type) SetCTRL_DOWN_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SCT0_Type) GetCTRL_DOWN_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SCT0_Type) SetCTRL_STOP_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetCTRL_STOP_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetCTRL_HALT_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetCTRL_HALT_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetCTRL_CLRCTR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SCT0_Type) GetCTRL_CLRCTR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SCT0_Type) SetCTRL_BIDIR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetCTRL_BIDIR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetCTRL_PRE_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *SCT0_Type) GetCTRL_PRE_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *SCT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe0000000) >> 29
}

// SCT0.LIMIT: SCT limit register
func (o *SCT0_Type) SetLIMIT_LIMMSK_L(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetLIMIT_LIMMSK_L() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0x3f
}
func (o *SCT0_Type) SetLIMIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT0_Type) GetLIMIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffc0) >> 6
}
func (o *SCT0_Type) SetLIMIT_LIMMSK_H(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0x3f0000)|value<<16)
}
func (o *SCT0_Type) GetLIMIT_LIMMSK_H() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0x3f0000) >> 16
}
func (o *SCT0_Type) SetLIMIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffc00000)|value<<22)
}
func (o *SCT0_Type) GetLIMIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffc00000) >> 22
}

// SCT0.HALT: SCT halt condition register
func (o *SCT0_Type) SetHALT_HALTMSK_L(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetHALT_HALTMSK_L() uint32 {
	return volatile.LoadUint32(&o.HALT.Reg) & 0x3f
}
func (o *SCT0_Type) SetHALT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT0_Type) GetHALT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffc0) >> 6
}
func (o *SCT0_Type) SetHALT_HALTMSK_H(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0x3f0000)|value<<16)
}
func (o *SCT0_Type) GetHALT_HALTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0x3f0000) >> 16
}
func (o *SCT0_Type) SetHALT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffc00000)|value<<22)
}
func (o *SCT0_Type) GetHALT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffc00000) >> 22
}

// SCT0.STOP: SCT stop condition register
func (o *SCT0_Type) SetSTOP_STOPMSK_L(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetSTOP_STOPMSK_L() uint32 {
	return volatile.LoadUint32(&o.STOP.Reg) & 0x3f
}
func (o *SCT0_Type) SetSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT0_Type) GetSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffc0) >> 6
}
func (o *SCT0_Type) SetSTOP_STOPMSK_H(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0x3f0000)|value<<16)
}
func (o *SCT0_Type) GetSTOP_STOPMSK_H() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0x3f0000) >> 16
}
func (o *SCT0_Type) SetSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffc00000)|value<<22)
}
func (o *SCT0_Type) GetSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffc00000) >> 22
}

// SCT0.START: SCT start condition register
func (o *SCT0_Type) SetSTART_STARTMSK_L(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetSTART_STARTMSK_L() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0x3f
}
func (o *SCT0_Type) SetSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT0_Type) GetSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffc0) >> 6
}
func (o *SCT0_Type) SetSTART_STARTMSK_H(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0x3f0000)|value<<16)
}
func (o *SCT0_Type) GetSTART_STARTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0x3f0000) >> 16
}
func (o *SCT0_Type) SetSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffc00000)|value<<22)
}
func (o *SCT0_Type) GetSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffc00000) >> 22
}

// SCT0.COUNT: SCT counter register
func (o *SCT0_Type) SetCOUNT_CTR_L(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetCOUNT_CTR_L() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffff
}
func (o *SCT0_Type) SetCOUNT_CTR_H(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetCOUNT_CTR_H() uint32 {
	return (volatile.LoadUint32(&o.COUNT.Reg) & 0xffff0000) >> 16
}

// SCT0.STATE: SCT state register
func (o *SCT0_Type) SetSTATE_STATE_L(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f)|value)
}
func (o *SCT0_Type) GetSTATE_STATE_L() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1f
}
func (o *SCT0_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT0_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe0) >> 5
}
func (o *SCT0_Type) SetSTATE_STATE_H(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT0_Type) GetSTATE_STATE_H() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x1f0000) >> 16
}
func (o *SCT0_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT0_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe00000) >> 21
}

// SCT0.INPUT: SCT input register
func (o *SCT0_Type) SetINPUT_AIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x1)|value)
}
func (o *SCT0_Type) GetINPUT_AIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT.Reg) & 0x1
}
func (o *SCT0_Type) SetINPUT_AIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x2)|value<<1)
}
func (o *SCT0_Type) GetINPUT_AIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x2) >> 1
}
func (o *SCT0_Type) SetINPUT_AIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x4)|value<<2)
}
func (o *SCT0_Type) GetINPUT_AIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x4) >> 2
}
func (o *SCT0_Type) SetINPUT_AIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x8)|value<<3)
}
func (o *SCT0_Type) GetINPUT_AIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x8) >> 3
}
func (o *SCT0_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT0_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff0) >> 4
}
func (o *SCT0_Type) SetINPUT_SIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10000)|value<<16)
}
func (o *SCT0_Type) GetINPUT_SIN0() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10000) >> 16
}
func (o *SCT0_Type) SetINPUT_SIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20000)|value<<17)
}
func (o *SCT0_Type) GetINPUT_SIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20000) >> 17
}
func (o *SCT0_Type) SetINPUT_SIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40000)|value<<18)
}
func (o *SCT0_Type) GetINPUT_SIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40000) >> 18
}
func (o *SCT0_Type) SetINPUT_SIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80000)|value<<19)
}
func (o *SCT0_Type) GetINPUT_SIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80000) >> 19
}
func (o *SCT0_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT0_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff00000) >> 20
}

// SCT0.REGMODE: SCT match/capture registers mode register
func (o *SCT0_Type) SetREGMODE_REGMOD_L(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0x1f)|value)
}
func (o *SCT0_Type) GetREGMODE_REGMOD_L() uint32 {
	return volatile.LoadUint32(&o.REGMODE.Reg) & 0x1f
}
func (o *SCT0_Type) SetREGMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT0_Type) GetREGMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffe0) >> 5
}
func (o *SCT0_Type) SetREGMODE_REGMOD_H(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT0_Type) GetREGMODE_REGMOD_H() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0x1f0000) >> 16
}
func (o *SCT0_Type) SetREGMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT0_Type) GetREGMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffe00000) >> 21
}

// SCT0.OUTPUT: SCT output register
func (o *SCT0_Type) SetOUTPUT_OUT(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetOUTPUT_OUT() uint32 {
	return volatile.LoadUint32(&o.OUTPUT.Reg) & 0xf
}
func (o *SCT0_Type) SetOUTPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SCT0_Type) GetOUTPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT.Reg) & 0xfffffff0) >> 4
}

// SCT0.OUTPUTDIRCTRL: SCT output counter direction control register
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3)|value)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR1(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc) >> 2
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR2(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30) >> 4
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_SETCLR3(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_SETCLR3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0) >> 6
}
func (o *SCT0_Type) SetOUTPUTDIRCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetOUTPUTDIRCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xffffff00) >> 8
}

// SCT0.RES: SCT conflict resolution register
func (o *SCT0_Type) SetRES_O0RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3)|value)
}
func (o *SCT0_Type) GetRES_O0RES() uint32 {
	return volatile.LoadUint32(&o.RES.Reg) & 0x3
}
func (o *SCT0_Type) SetRES_O1RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc)|value<<2)
}
func (o *SCT0_Type) GetRES_O1RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc) >> 2
}
func (o *SCT0_Type) SetRES_O2RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30)|value<<4)
}
func (o *SCT0_Type) GetRES_O2RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30) >> 4
}
func (o *SCT0_Type) SetRES_O3RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0)|value<<6)
}
func (o *SCT0_Type) GetRES_O3RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0) >> 6
}
func (o *SCT0_Type) SetRES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetRES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xffffff00) >> 8
}

// SCT0.DMAREQ0: SCT DMA request 0 register
func (o *SCT0_Type) SetDMAREQ0_DEV_0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetDMAREQ0_DEV_0() uint32 {
	return volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x3f
}
func (o *SCT0_Type) SetDMAREQ0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x3fffffc0)|value<<6)
}
func (o *SCT0_Type) GetDMAREQ0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x3fffffc0) >> 6
}
func (o *SCT0_Type) SetDMAREQ0_DRL0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetDMAREQ0_DRL0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetDMAREQ0_DRQ0(value uint32) {
	volatile.StoreUint32(&o.DMAREQ0.Reg, volatile.LoadUint32(&o.DMAREQ0.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetDMAREQ0_DRQ0() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ0.Reg) & 0x80000000) >> 31
}

// SCT0.DMAREQ1: SCT DMA request 1 register
func (o *SCT0_Type) SetDMAREQ1_DEV_1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetDMAREQ1_DEV_1() uint32 {
	return volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x3f
}
func (o *SCT0_Type) SetDMAREQ1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x3fffffc0)|value<<6)
}
func (o *SCT0_Type) GetDMAREQ1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x3fffffc0) >> 6
}
func (o *SCT0_Type) SetDMAREQ1_DRL1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetDMAREQ1_DRL1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetDMAREQ1_DRQ1(value uint32) {
	volatile.StoreUint32(&o.DMAREQ1.Reg, volatile.LoadUint32(&o.DMAREQ1.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetDMAREQ1_DRQ1() uint32 {
	return (volatile.LoadUint32(&o.DMAREQ1.Reg) & 0x80000000) >> 31
}

// SCT0.EVEN: SCT event enable register
func (o *SCT0_Type) SetEVEN_IEN(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetEVEN_IEN() uint32 {
	return volatile.LoadUint32(&o.EVEN.Reg) & 0x3f
}
func (o *SCT0_Type) SetEVEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetEVEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0xffffffc0) >> 6
}

// SCT0.EVFLAG: SCT event flag register
func (o *SCT0_Type) SetEVFLAG_FLAG(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetEVFLAG_FLAG() uint32 {
	return volatile.LoadUint32(&o.EVFLAG.Reg) & 0x3f
}
func (o *SCT0_Type) SetEVFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetEVFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffffffc0) >> 6
}

// SCT0.CONEN: SCT conflict enable register
func (o *SCT0_Type) SetCONEN_NCEN(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetCONEN_NCEN() uint32 {
	return volatile.LoadUint32(&o.CONEN.Reg) & 0xf
}
func (o *SCT0_Type) SetCONEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SCT0_Type) GetCONEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0xfffffff0) >> 4
}

// SCT0.CONFLAG: SCT conflict flag register
func (o *SCT0_Type) SetCONFLAG_NCFLAG(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetCONFLAG_NCFLAG() uint32 {
	return volatile.LoadUint32(&o.CONFLAG.Reg) & 0xf
}
func (o *SCT0_Type) SetCONFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3ffffff0)|value<<4)
}
func (o *SCT0_Type) GetCONFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3ffffff0) >> 4
}
func (o *SCT0_Type) SetCONFLAG_BUSERRL(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT0_Type) GetCONFLAG_BUSERRL() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40000000) >> 30
}
func (o *SCT0_Type) SetCONFLAG_BUSERRH(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT0_Type) GetCONFLAG_BUSERRH() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80000000) >> 31
}

// SCT0.MATCH0: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCH0_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH0_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH0_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH0_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH1: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCH1_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH1_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH1_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH1_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH2: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCH2_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH2_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH2_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH2_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH3: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCH3_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH3_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH3_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH3_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCH4: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCH4_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCH4_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCH4_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCH4_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL0: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCHREL0_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL0_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL0_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL0_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL1: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCHREL1_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL1_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL1_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL1_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL2: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCHREL2_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL2_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL2_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL2_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL3: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCHREL3_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL3_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL3_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL3_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff0000) >> 16
}

// SCT0.MATCHREL4: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT0_Type) SetMATCHREL4_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff)|value)
}
func (o *SCT0_Type) GetMATCHREL4_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff
}
func (o *SCT0_Type) SetMATCHREL4_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT0_Type) GetMATCHREL4_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff0000) >> 16
}

// SCT0.EV0_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV0_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV0_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV0_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV0_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV0_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV0_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV0_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV0_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV0_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV0_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV0_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV0_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV0_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV0_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV0_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV0_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV0_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV0_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV0_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV0_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV0_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV0_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV0_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV0_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV0_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV0_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV0_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV0_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV1_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV1_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV1_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV1_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV1_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV1_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV1_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV1_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV1_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV1_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV1_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV1_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV1_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV1_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV1_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV1_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV1_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV1_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV1_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV1_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV1_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV1_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV1_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV1_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV1_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV1_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV1_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV1_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV1_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV2_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV2_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV2_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV2_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV2_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV2_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV2_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV2_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV2_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV2_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV2_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV2_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV2_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV2_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV2_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV2_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV2_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV2_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV2_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV2_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV2_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV2_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV2_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV2_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV2_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV2_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV2_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV2_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV2_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV3_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV3_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV3_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV3_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV3_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV3_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV3_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV3_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV3_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV3_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV3_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV3_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV3_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV3_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV3_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV3_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV3_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV3_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV3_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV3_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV3_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV3_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV3_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV3_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV3_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV3_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV3_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV3_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV3_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV4_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV4_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV4_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV4_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV4_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV4_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV4_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV4_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV4_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV4_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV4_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV4_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV4_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV4_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV4_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV4_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV4_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV4_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV4_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV4_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV4_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV4_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV4_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV4_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV4_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV4_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV4_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV4_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV4_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.EV5_STATE: SCT event state register 0
func (o *SCT0_Type) SetEV5_STATE_STATEMSKn(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0xff)|value)
}
func (o *SCT0_Type) GetEV5_STATE_STATEMSKn() uint32 {
	return volatile.LoadUint32(&o.EV5_STATE.Reg) & 0xff
}
func (o *SCT0_Type) SetEV5_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT0_Type) GetEV5_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0xffffff00) >> 8
}

// SCT0.EV5_CTRL: SCT event control register 0
func (o *SCT0_Type) SetEV5_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT0_Type) GetEV5_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf
}
func (o *SCT0_Type) SetEV5_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT0_Type) GetEV5_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT0_Type) SetEV5_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT0_Type) GetEV5_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT0_Type) SetEV5_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT0_Type) GetEV5_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT0_Type) SetEV5_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT0_Type) GetEV5_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT0_Type) SetEV5_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT0_Type) GetEV5_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT0_Type) SetEV5_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT0_Type) GetEV5_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT0_Type) SetEV5_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT0_Type) GetEV5_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT0_Type) SetEV5_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT0_Type) GetEV5_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT0_Type) SetEV5_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT0_Type) GetEV5_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT0_Type) SetEV5_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT0_Type) GetEV5_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xff800000) >> 23
}

// SCT0.OUT0_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT0_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT0_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT0_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT0_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT0_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT0_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT0_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT0_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT0_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT1_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT1_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT1_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT1_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT1_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT1_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT1_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT1_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT1_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT1_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT2_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT2_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT2_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT2_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT2_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT2_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT2_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT2_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT2_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT2_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT3_SET: SCT output 0 set register
func (o *SCT0_Type) SetOUT3_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT3_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT3_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT3_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xffffffc0) >> 6
}

// SCT0.OUT3_CLR: SCT output 0 clear register
func (o *SCT0_Type) SetOUT3_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT0_Type) GetOUT3_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x3f
}
func (o *SCT0_Type) SetOUT3_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT0_Type) GetOUT3_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xffffffc0) >> 6
}

// General Purpose I/O (GPIO)
type GPIO_Type struct {
	B    [88]volatile.Register8 // 0x0
	_    [4008]byte
	W    [88]volatile.Register32 // 0x1000
	_    [3744]byte
	DIR  [3]volatile.Register32 // 0x2000
	_    [116]byte
	MASK [3]volatile.Register32 // 0x2080
	_    [116]byte
	PIN  [3]volatile.Register32 // 0x2100
	_    [116]byte
	MPIN [3]volatile.Register32 // 0x2180
	_    [116]byte
	SET  [3]volatile.Register32 // 0x2200
	_    [116]byte
	CLR  [3]volatile.Register32 // 0x2280
	_    [116]byte
	NOT  [3]volatile.Register32 // 0x2300
}

// GPIO.B: Byte pin registers
func (o *GPIO_Type) SetB_PBYTE(idx int, value uint8) {
	volatile.StoreUint8(&o.B[idx].Reg, volatile.LoadUint8(&o.B[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetB_PBYTE(idx int) uint8 {
	return volatile.LoadUint8(&o.B[idx].Reg) & 0x1
}

// GPIO.W: Word pin registers
func (o *GPIO_Type) SetW(idx int, value uint32) {
	volatile.StoreUint32(&o.W[idx].Reg, value)
}
func (o *GPIO_Type) GetW(idx int) uint32 {
	return volatile.LoadUint32(&o.W[idx].Reg)
}

// GPIO.DIR: Port Direction registers
func (o *GPIO_Type) SetDIR_DIRP0(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_DIRP0(idx int) uint32 {
	return volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_DIRP1(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_DIRP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_DIRP2(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_DIRP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_DIRP3(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_DIRP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_DIRP4(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_DIRP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_DIRP5(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_DIRP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_DIRP6(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_DIRP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_DIRP7(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_DIRP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_DIRP8(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_DIRP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_DIRP9(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_DIRP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_DIRP10(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_DIRP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_DIRP11(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_DIRP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_DIRP12(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_DIRP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_DIRP13(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_DIRP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_DIRP14(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_DIRP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_DIRP15(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_DIRP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_DIRP16(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_DIRP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_DIRP17(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_DIRP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_DIRP18(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_DIRP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_DIRP19(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_DIRP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_DIRP20(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_DIRP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_DIRP21(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_DIRP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_DIRP22(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_DIRP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_DIRP23(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_DIRP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_DIRP24(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_DIRP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_DIRP25(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_DIRP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_DIRP26(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_DIRP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_DIRP27(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_DIRP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_DIRP28(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_DIRP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_DIRP29(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_DIRP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_DIRP30(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_DIRP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_DIRP31(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR[idx].Reg, volatile.LoadUint32(&o.DIR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_DIRP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.DIR[idx].Reg) & 0x80000000) >> 31
}

// GPIO.MASK: Port Mask register
func (o *GPIO_Type) SetMASK_MASKP0(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK_MASKP0(idx int) uint32 {
	return volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetMASK_MASKP1(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK_MASKP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK_MASKP2(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK_MASKP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK_MASKP3(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK_MASKP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK_MASKP4(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK_MASKP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK_MASKP5(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK_MASKP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK_MASKP6(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK_MASKP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK_MASKP7(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK_MASKP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK_MASKP8(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK_MASKP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK_MASKP9(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK_MASKP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK_MASKP10(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK_MASKP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK_MASKP11(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK_MASKP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK_MASKP12(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK_MASKP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK_MASKP13(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK_MASKP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK_MASKP14(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK_MASKP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK_MASKP15(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK_MASKP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK_MASKP16(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK_MASKP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK_MASKP17(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK_MASKP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK_MASKP18(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK_MASKP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK_MASKP19(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK_MASKP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK_MASKP20(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK_MASKP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK_MASKP21(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK_MASKP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK_MASKP22(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK_MASKP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK_MASKP23(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK_MASKP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK_MASKP24(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK_MASKP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK_MASKP25(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK_MASKP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK_MASKP26(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK_MASKP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK_MASKP27(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK_MASKP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK_MASKP28(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK_MASKP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK_MASKP29(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK_MASKP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK_MASKP30(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK_MASKP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK_MASKP31(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK_MASKP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0x80000000) >> 31
}

// GPIO.PIN: Port pin register
func (o *GPIO_Type) SetPIN_PORT0(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_PORT0(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_PORT1(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_PORT1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_PORT2(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN_PORT2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN_PORT3(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN_PORT3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN_PORT4(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN_PORT4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN_PORT5(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN_PORT5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN_PORT6(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN_PORT6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN_PORT7(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN_PORT7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN_PORT8(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN_PORT8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN_PORT9(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN_PORT9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN_PORT10(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN_PORT10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN_PORT11(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN_PORT11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN_PORT12(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN_PORT12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN_PORT13(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN_PORT13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN_PORT14(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN_PORT14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN_PORT15(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN_PORT15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN_PORT16(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN_PORT16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN_PORT17(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN_PORT17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN_PORT18(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN_PORT18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN_PORT19(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN_PORT19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN_PORT20(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN_PORT20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN_PORT21(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN_PORT21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN_PORT22(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN_PORT22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN_PORT23(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN_PORT23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN_PORT24(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN_PORT24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN_PORT25(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN_PORT25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN_PORT26(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN_PORT26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN_PORT27(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN_PORT27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN_PORT28(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN_PORT28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN_PORT29(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN_PORT29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN_PORT30(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN_PORT30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN_PORT31(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN[idx].Reg, volatile.LoadUint32(&o.PIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN_PORT31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN[idx].Reg) & 0x80000000) >> 31
}

// GPIO.MPIN: Masked port register
func (o *GPIO_Type) SetMPIN_MPORTP0(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMPIN_MPORTP0(idx int) uint32 {
	return volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetMPIN_MPORTP1(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMPIN_MPORTP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMPIN_MPORTP2(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMPIN_MPORTP2(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMPIN_MPORTP3(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMPIN_MPORTP3(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMPIN_MPORTP4(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMPIN_MPORTP4(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMPIN_MPORTP5(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMPIN_MPORTP5(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMPIN_MPORTP6(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMPIN_MPORTP6(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMPIN_MPORTP7(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMPIN_MPORTP7(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMPIN_MPORTP8(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMPIN_MPORTP8(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMPIN_MPORTP9(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMPIN_MPORTP9(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMPIN_MPORTP10(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMPIN_MPORTP10(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMPIN_MPORTP11(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMPIN_MPORTP11(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMPIN_MPORTP12(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMPIN_MPORTP12(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMPIN_MPORTP13(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMPIN_MPORTP13(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMPIN_MPORTP14(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMPIN_MPORTP14(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMPIN_MPORTP15(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMPIN_MPORTP15(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMPIN_MPORTP16(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMPIN_MPORTP16(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMPIN_MPORTP17(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMPIN_MPORTP17(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMPIN_MPORTP18(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMPIN_MPORTP18(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMPIN_MPORTP19(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMPIN_MPORTP19(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMPIN_MPORTP20(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMPIN_MPORTP20(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMPIN_MPORTP21(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMPIN_MPORTP21(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMPIN_MPORTP22(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMPIN_MPORTP22(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMPIN_MPORTP23(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMPIN_MPORTP23(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMPIN_MPORTP24(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMPIN_MPORTP24(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMPIN_MPORTP25(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMPIN_MPORTP25(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMPIN_MPORTP26(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMPIN_MPORTP26(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMPIN_MPORTP27(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMPIN_MPORTP27(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMPIN_MPORTP28(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMPIN_MPORTP28(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMPIN_MPORTP29(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMPIN_MPORTP29(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMPIN_MPORTP30(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMPIN_MPORTP30(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMPIN_MPORTP31(idx int, value uint32) {
	volatile.StoreUint32(&o.MPIN[idx].Reg, volatile.LoadUint32(&o.MPIN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMPIN_MPORTP31(idx int) uint32 {
	return (volatile.LoadUint32(&o.MPIN[idx].Reg) & 0x80000000) >> 31
}

// GPIO.SET: Write: Set port register Read: port output bits
func (o *GPIO_Type) SetSET_SETP00(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET_SETP00(idx int) uint32 {
	return volatile.LoadUint32(&o.SET[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetSET_SETP01(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET_SETP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET_SETP02(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET_SETP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET_SETP03(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET_SETP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET_SETP04(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET_SETP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET_SETP05(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET_SETP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET_SETP06(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET_SETP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET_SETP07(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET_SETP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET_SETP08(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET_SETP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET_SETP09(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET_SETP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET_SETP010(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET_SETP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET_SETP011(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET_SETP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET_SETP012(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET_SETP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET_SETP013(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET_SETP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET_SETP014(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET_SETP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET_SETP015(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET_SETP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET_SETP016(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET_SETP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET_SETP017(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET_SETP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET_SETP018(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET_SETP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET_SETP019(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET_SETP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET_SETP020(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET_SETP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET_SETP021(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET_SETP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET_SETP022(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET_SETP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET_SETP023(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET_SETP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET_SETP024(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET_SETP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET_SETP025(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET_SETP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET_SETP026(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET_SETP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET_SETP027(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET_SETP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET_SETP028(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET_SETP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET_SETP029(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET_SETP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET_SETP030(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET_SETP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET_SETP031(idx int, value uint32) {
	volatile.StoreUint32(&o.SET[idx].Reg, volatile.LoadUint32(&o.SET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET_SETP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.SET[idx].Reg) & 0x80000000) >> 31
}

// GPIO.CLR: Clear port
func (o *GPIO_Type) SetCLR_CLRP00(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR_CLRP00(idx int) uint32 {
	return volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetCLR_CLRP01(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR_CLRP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR_CLRP02(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR_CLRP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR_CLRP03(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR_CLRP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR_CLRP04(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR_CLRP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR_CLRP05(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR_CLRP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR_CLRP06(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR_CLRP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR_CLRP07(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR_CLRP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR_CLRP08(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR_CLRP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR_CLRP09(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR_CLRP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR_CLRP010(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR_CLRP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR_CLRP011(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR_CLRP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR_CLRP012(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR_CLRP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR_CLRP013(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR_CLRP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR_CLRP014(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR_CLRP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR_CLRP015(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR_CLRP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR_CLRP016(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR_CLRP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR_CLRP017(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR_CLRP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR_CLRP018(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR_CLRP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR_CLRP019(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR_CLRP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR_CLRP020(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR_CLRP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR_CLRP021(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR_CLRP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR_CLRP022(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR_CLRP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR_CLRP023(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR_CLRP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR_CLRP024(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR_CLRP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR_CLRP025(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR_CLRP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR_CLRP026(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR_CLRP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR_CLRP027(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR_CLRP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR_CLRP028(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR_CLRP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR_CLRP029(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR_CLRP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR_CLRP030(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR_CLRP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR_CLRP031(idx int, value uint32) {
	volatile.StoreUint32(&o.CLR[idx].Reg, volatile.LoadUint32(&o.CLR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR_CLRP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.CLR[idx].Reg) & 0x80000000) >> 31
}

// GPIO.NOT: Toggle port
func (o *GPIO_Type) SetNOT_NOTP00(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetNOT_NOTP00(idx int) uint32 {
	return volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetNOT_NOTP01(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetNOT_NOTP01(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetNOT_NOTP02(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetNOT_NOTP02(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetNOT_NOTP03(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetNOT_NOTP03(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetNOT_NOTP04(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetNOT_NOTP04(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetNOT_NOTP05(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetNOT_NOTP05(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetNOT_NOTP06(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetNOT_NOTP06(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetNOT_NOTP07(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetNOT_NOTP07(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetNOT_NOTP08(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetNOT_NOTP08(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetNOT_NOTP09(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetNOT_NOTP09(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetNOT_NOTP010(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetNOT_NOTP010(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetNOT_NOTP011(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetNOT_NOTP011(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetNOT_NOTP012(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetNOT_NOTP012(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetNOT_NOTP013(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetNOT_NOTP013(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetNOT_NOTP014(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetNOT_NOTP014(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetNOT_NOTP015(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetNOT_NOTP015(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetNOT_NOTP016(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetNOT_NOTP016(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetNOT_NOTP017(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetNOT_NOTP017(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetNOT_NOTP018(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetNOT_NOTP018(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetNOT_NOTP019(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetNOT_NOTP019(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetNOT_NOTP020(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetNOT_NOTP020(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetNOT_NOTP021(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetNOT_NOTP021(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetNOT_NOTP022(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetNOT_NOTP022(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetNOT_NOTP023(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetNOT_NOTP023(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetNOT_NOTP024(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetNOT_NOTP024(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetNOT_NOTP025(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetNOT_NOTP025(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetNOT_NOTP026(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetNOT_NOTP026(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetNOT_NOTP027(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetNOT_NOTP027(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetNOT_NOTP028(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetNOT_NOTP028(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetNOT_NOTP029(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetNOT_NOTP029(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetNOT_NOTP030(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetNOT_NOTP030(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetNOT_NOTP031(idx int, value uint32) {
	volatile.StoreUint32(&o.NOT[idx].Reg, volatile.LoadUint32(&o.NOT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetNOT_NOTP031(idx int) uint32 {
	return (volatile.LoadUint32(&o.NOT[idx].Reg) & 0x80000000) >> 31
}

// Pin interrupt and pattern match (PINT)
type PINT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// PINT.ISEL: Pin Interrupt Mode register
func (o *PINT_Type) SetISEL_PMODE0(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetISEL_PMODE0() uint32 {
	return volatile.LoadUint32(&o.ISEL.Reg) & 0x1
}
func (o *PINT_Type) SetISEL_PMODE1(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetISEL_PMODE1() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetISEL_PMODE2(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetISEL_PMODE2() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetISEL_PMODE3(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetISEL_PMODE3() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetISEL_PMODE4(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetISEL_PMODE4() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetISEL_PMODE5(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetISEL_PMODE5() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetISEL_PMODE6(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetISEL_PMODE6() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetISEL_PMODE7(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetISEL_PMODE7() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetISEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetISEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0xffffff00) >> 8
}

// PINT.IENR: Pin interrupt level or rising edge interrupt enable register
func (o *PINT_Type) SetIENR_ENRL0(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIENR_ENRL0() uint32 {
	return volatile.LoadUint32(&o.IENR.Reg) & 0x1
}
func (o *PINT_Type) SetIENR_ENRL1(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIENR_ENRL1() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIENR_ENRL2(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIENR_ENRL2() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIENR_ENRL3(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIENR_ENRL3() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIENR_ENRL4(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIENR_ENRL4() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIENR_ENRL5(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIENR_ENRL5() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIENR_ENRL6(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIENR_ENRL6() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIENR_ENRL7(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIENR_ENRL7() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0xffffff00) >> 8
}

// PINT.SIENR: Pin interrupt level or rising edge interrupt set register
func (o *PINT_Type) SetSIENR_SETENRL0(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetSIENR_SETENRL0() uint32 {
	return volatile.LoadUint32(&o.SIENR.Reg) & 0x1
}
func (o *PINT_Type) SetSIENR_SETENRL1(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetSIENR_SETENRL1() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetSIENR_SETENRL2(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetSIENR_SETENRL2() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetSIENR_SETENRL3(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetSIENR_SETENRL3() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetSIENR_SETENRL4(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetSIENR_SETENRL4() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetSIENR_SETENRL5(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetSIENR_SETENRL5() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetSIENR_SETENRL6(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetSIENR_SETENRL6() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetSIENR_SETENRL7(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetSIENR_SETENRL7() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetSIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetSIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0xffffff00) >> 8
}

// PINT.CIENR: Pin interrupt level (rising edge interrupt) clear register
func (o *PINT_Type) SetCIENR_CENRL0(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetCIENR_CENRL0() uint32 {
	return volatile.LoadUint32(&o.CIENR.Reg) & 0x1
}
func (o *PINT_Type) SetCIENR_CENRL1(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetCIENR_CENRL1() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetCIENR_CENRL2(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetCIENR_CENRL2() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetCIENR_CENRL3(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetCIENR_CENRL3() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetCIENR_CENRL4(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetCIENR_CENRL4() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetCIENR_CENRL5(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetCIENR_CENRL5() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetCIENR_CENRL6(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetCIENR_CENRL6() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetCIENR_CENRL7(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetCIENR_CENRL7() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetCIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetCIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0xffffff00) >> 8
}

// PINT.IENF: Pin interrupt active level or falling edge interrupt enable register
func (o *PINT_Type) SetIENF_ENAF0(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIENF_ENAF0() uint32 {
	return volatile.LoadUint32(&o.IENF.Reg) & 0x1
}
func (o *PINT_Type) SetIENF_ENAF1(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIENF_ENAF1() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIENF_ENAF2(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIENF_ENAF2() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIENF_ENAF3(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIENF_ENAF3() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIENF_ENAF4(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIENF_ENAF4() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIENF_ENAF5(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIENF_ENAF5() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIENF_ENAF6(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIENF_ENAF6() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIENF_ENAF7(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIENF_ENAF7() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0xffffff00) >> 8
}

// PINT.SIENF: Pin interrupt active level or falling edge interrupt set register
func (o *PINT_Type) SetSIENF_SETENAF0(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetSIENF_SETENAF0() uint32 {
	return volatile.LoadUint32(&o.SIENF.Reg) & 0x1
}
func (o *PINT_Type) SetSIENF_SETENAF1(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetSIENF_SETENAF1() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetSIENF_SETENAF2(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetSIENF_SETENAF2() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetSIENF_SETENAF3(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetSIENF_SETENAF3() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetSIENF_SETENAF4(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetSIENF_SETENAF4() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetSIENF_SETENAF5(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetSIENF_SETENAF5() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetSIENF_SETENAF6(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetSIENF_SETENAF6() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetSIENF_SETENAF7(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetSIENF_SETENAF7() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetSIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetSIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0xffffff00) >> 8
}

// PINT.CIENF: Pin interrupt active level or falling edge interrupt clear register
func (o *PINT_Type) SetCIENF_CENAF0(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetCIENF_CENAF0() uint32 {
	return volatile.LoadUint32(&o.CIENF.Reg) & 0x1
}
func (o *PINT_Type) SetCIENF_CENAF1(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetCIENF_CENAF1() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetCIENF_CENAF2(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetCIENF_CENAF2() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetCIENF_CENAF3(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetCIENF_CENAF3() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetCIENF_CENAF4(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetCIENF_CENAF4() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetCIENF_CENAF5(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetCIENF_CENAF5() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetCIENF_CENAF6(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetCIENF_CENAF6() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetCIENF_CENAF7(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetCIENF_CENAF7() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetCIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetCIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0xffffff00) >> 8
}

// PINT.RISE: Pin interrupt rising edge register
func (o *PINT_Type) SetRISE_RDET0(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetRISE_RDET0() uint32 {
	return volatile.LoadUint32(&o.RISE.Reg) & 0x1
}
func (o *PINT_Type) SetRISE_RDET1(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetRISE_RDET1() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetRISE_RDET2(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetRISE_RDET2() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetRISE_RDET3(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetRISE_RDET3() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetRISE_RDET4(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetRISE_RDET4() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetRISE_RDET5(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetRISE_RDET5() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetRISE_RDET6(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetRISE_RDET6() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetRISE_RDET7(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetRISE_RDET7() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetRISE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetRISE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0xffffff00) >> 8
}

// PINT.FALL: Pin interrupt falling edge register
func (o *PINT_Type) SetFALL_FDET0(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetFALL_FDET0() uint32 {
	return volatile.LoadUint32(&o.FALL.Reg) & 0x1
}
func (o *PINT_Type) SetFALL_FDET1(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetFALL_FDET1() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetFALL_FDET2(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetFALL_FDET2() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetFALL_FDET3(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetFALL_FDET3() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetFALL_FDET4(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetFALL_FDET4() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetFALL_FDET5(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetFALL_FDET5() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetFALL_FDET6(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetFALL_FDET6() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetFALL_FDET7(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetFALL_FDET7() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetFALL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetFALL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0xffffff00) >> 8
}

// PINT.IST: Pin interrupt status register
func (o *PINT_Type) SetIST_PSTAT0(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetIST_PSTAT0() uint32 {
	return volatile.LoadUint32(&o.IST.Reg) & 0x1
}
func (o *PINT_Type) SetIST_PSTAT1(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetIST_PSTAT1() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetIST_PSTAT2(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x4)|value<<2)
}
func (o *PINT_Type) GetIST_PSTAT2() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x4) >> 2
}
func (o *PINT_Type) SetIST_PSTAT3(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x8)|value<<3)
}
func (o *PINT_Type) GetIST_PSTAT3() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x8) >> 3
}
func (o *PINT_Type) SetIST_PSTAT4(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x10)|value<<4)
}
func (o *PINT_Type) GetIST_PSTAT4() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x10) >> 4
}
func (o *PINT_Type) SetIST_PSTAT5(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x20)|value<<5)
}
func (o *PINT_Type) GetIST_PSTAT5() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x20) >> 5
}
func (o *PINT_Type) SetIST_PSTAT6(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x40)|value<<6)
}
func (o *PINT_Type) GetIST_PSTAT6() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x40) >> 6
}
func (o *PINT_Type) SetIST_PSTAT7(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetIST_PSTAT7() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetIST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0xffffff00)|value<<8)
}
func (o *PINT_Type) GetIST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0xffffff00) >> 8
}

// PINT.PMCTRL: Pattern match interrupt control register
func (o *PINT_Type) SetPMCTRL_SEL_PMATCH(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x1)|value)
}
func (o *PINT_Type) GetPMCTRL_SEL_PMATCH() uint32 {
	return volatile.LoadUint32(&o.PMCTRL.Reg) & 0x1
}
func (o *PINT_Type) SetPMCTRL_ENA_RXEV(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *PINT_Type) GetPMCTRL_ENA_RXEV() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0x2) >> 1
}
func (o *PINT_Type) SetPMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xfffffc)|value<<2)
}
func (o *PINT_Type) GetPMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xfffffc) >> 2
}
func (o *PINT_Type) SetPMCTRL_PMAT(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *PINT_Type) GetPMCTRL_PMAT() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xff000000) >> 24
}

// PINT.PMSRC: Pattern match interrupt bit-slice source register
func (o *PINT_Type) SetPMSRC_Reserved(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xff)|value)
}
func (o *PINT_Type) GetPMSRC_Reserved() uint32 {
	return volatile.LoadUint32(&o.PMSRC.Reg) & 0xff
}
func (o *PINT_Type) SetPMSRC_SRC0(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700)|value<<8)
}
func (o *PINT_Type) GetPMSRC_SRC0() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700) >> 8
}
func (o *PINT_Type) SetPMSRC_SRC1(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800)|value<<11)
}
func (o *PINT_Type) GetPMSRC_SRC1() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800) >> 11
}
func (o *PINT_Type) SetPMSRC_SRC2(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000)|value<<14)
}
func (o *PINT_Type) GetPMSRC_SRC2() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000) >> 14
}
func (o *PINT_Type) SetPMSRC_SRC3(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000)|value<<17)
}
func (o *PINT_Type) GetPMSRC_SRC3() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000) >> 17
}
func (o *PINT_Type) SetPMSRC_SRC4(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700000)|value<<20)
}
func (o *PINT_Type) GetPMSRC_SRC4() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700000) >> 20
}
func (o *PINT_Type) SetPMSRC_SRC5(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800000)|value<<23)
}
func (o *PINT_Type) GetPMSRC_SRC5() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800000) >> 23
}
func (o *PINT_Type) SetPMSRC_SRC6(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000000)|value<<26)
}
func (o *PINT_Type) GetPMSRC_SRC6() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000000) >> 26
}
func (o *PINT_Type) SetPMSRC_SRC7(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000000)|value<<29)
}
func (o *PINT_Type) GetPMSRC_SRC7() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000000) >> 29
}

// PINT.PMCFG: Pattern match interrupt bit slice configuration register
func (o *PINT_Type) SetPMCFG_PROD_ENDPTS(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x7f)|value)
}
func (o *PINT_Type) GetPMCFG_PROD_ENDPTS() uint32 {
	return volatile.LoadUint32(&o.PMCFG.Reg) & 0x7f
}
func (o *PINT_Type) SetPMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x80)|value<<7)
}
func (o *PINT_Type) GetPMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x80) >> 7
}
func (o *PINT_Type) SetPMCFG_CFG0(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700)|value<<8)
}
func (o *PINT_Type) GetPMCFG_CFG0() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700) >> 8
}
func (o *PINT_Type) SetPMCFG_CFG1(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800)|value<<11)
}
func (o *PINT_Type) GetPMCFG_CFG1() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800) >> 11
}
func (o *PINT_Type) SetPMCFG_CFG2(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000)|value<<14)
}
func (o *PINT_Type) GetPMCFG_CFG2() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000) >> 14
}
func (o *PINT_Type) SetPMCFG_CFG3(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000)|value<<17)
}
func (o *PINT_Type) GetPMCFG_CFG3() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000) >> 17
}
func (o *PINT_Type) SetPMCFG_CFG4(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700000)|value<<20)
}
func (o *PINT_Type) GetPMCFG_CFG4() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700000) >> 20
}
func (o *PINT_Type) SetPMCFG_CFG5(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800000)|value<<23)
}
func (o *PINT_Type) GetPMCFG_CFG5() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800000) >> 23
}
func (o *PINT_Type) SetPMCFG_CFG6(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000000)|value<<26)
}
func (o *PINT_Type) GetPMCFG_CFG6() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000000) >> 26
}
func (o *PINT_Type) SetPMCFG_CFG7(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000000)|value<<29)
}
func (o *PINT_Type) GetPMCFG_CFG7() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000000) >> 29
}

// Constants for I2C0: I2C-bus controller
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C0_CONSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_CONSET_RESERVED_Msk = 0x3
	// Position of AA field.
	I2C0_CONSET_AA_Pos = 0x2
	// Bit mask of AA field.
	I2C0_CONSET_AA_Msk = 0x4
	// Bit AA.
	I2C0_CONSET_AA = 0x4
	// Position of SI field.
	I2C0_CONSET_SI_Pos = 0x3
	// Bit mask of SI field.
	I2C0_CONSET_SI_Msk = 0x8
	// Bit SI.
	I2C0_CONSET_SI = 0x8
	// Position of STO field.
	I2C0_CONSET_STO_Pos = 0x4
	// Bit mask of STO field.
	I2C0_CONSET_STO_Msk = 0x10
	// Bit STO.
	I2C0_CONSET_STO = 0x10
	// Position of STA field.
	I2C0_CONSET_STA_Pos = 0x5
	// Bit mask of STA field.
	I2C0_CONSET_STA_Msk = 0x20
	// Bit STA.
	I2C0_CONSET_STA = 0x20
	// Position of I2EN field.
	I2C0_CONSET_I2EN_Pos = 0x6
	// Bit mask of I2EN field.
	I2C0_CONSET_I2EN_Msk = 0x40
	// Bit I2EN.
	I2C0_CONSET_I2EN = 0x40
	// Position of RESERVED field.
	I2C0_CONSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_CONSET_RESERVED_Msk = 0xffffff80

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x7
	// Position of Status field.
	I2C0_STAT_Status_Pos = 0x3
	// Bit mask of Status field.
	I2C0_STAT_Status_Msk = 0xf8
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xffffff00

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	// Position of Data field.
	I2C0_DAT_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C0_DAT_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C0_DAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_DAT_RESERVED_Msk = 0xffffff00

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C0_ADR0_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C0_ADR0_GC_Msk = 0x1
	// Bit GC.
	I2C0_ADR0_GC = 0x1
	// Position of Address field.
	I2C0_ADR0_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C0_ADR0_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_ADR0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_ADR0_RESERVED_Msk = 0xffffff00

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	// Position of SCLH field.
	I2C0_SCLH_SCLH_Pos = 0x0
	// Bit mask of SCLH field.
	I2C0_SCLH_SCLH_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_SCLH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_SCLH_RESERVED_Msk = 0xffff0000

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	// Position of SCLL field.
	I2C0_SCLL_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C0_SCLL_SCLL_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_SCLL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_SCLL_RESERVED_Msk = 0xffff0000

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x3
	// Position of AAC field.
	I2C0_CONCLR_AAC_Pos = 0x2
	// Bit mask of AAC field.
	I2C0_CONCLR_AAC_Msk = 0x4
	// Bit AAC.
	I2C0_CONCLR_AAC = 0x4
	// Position of SIC field.
	I2C0_CONCLR_SIC_Pos = 0x3
	// Bit mask of SIC field.
	I2C0_CONCLR_SIC_Msk = 0x8
	// Bit SIC.
	I2C0_CONCLR_SIC = 0x8
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	I2C0_CONCLR_RESERVED = 0x10
	// Position of STAC field.
	I2C0_CONCLR_STAC_Pos = 0x5
	// Bit mask of STAC field.
	I2C0_CONCLR_STAC_Msk = 0x20
	// Bit STAC.
	I2C0_CONCLR_STAC = 0x20
	// Position of I2ENC field.
	I2C0_CONCLR_I2ENC_Pos = 0x6
	// Bit mask of I2ENC field.
	I2C0_CONCLR_I2ENC_Msk = 0x40
	// Bit I2ENC.
	I2C0_CONCLR_I2ENC = 0x40
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_CONCLR_RESERVED = 0x80
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0xffffff00

	// MMCTRL: Monitor mode control register.
	// Position of MM_ENA field.
	I2C0_MMCTRL_MM_ENA_Pos = 0x0
	// Bit mask of MM_ENA field.
	I2C0_MMCTRL_MM_ENA_Msk = 0x1
	// Bit MM_ENA.
	I2C0_MMCTRL_MM_ENA = 0x1
	// Monitor mode disabled.
	I2C0_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE = 0x0
	// The I2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I 2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C0_MMCTRL_MM_ENA_THE_I2C_MODULE_WILL_ = 0x1
	// Position of ENA_SCL field.
	I2C0_MMCTRL_ENA_SCL_Pos = 0x1
	// Bit mask of ENA_SCL field.
	I2C0_MMCTRL_ENA_SCL_Msk = 0x2
	// Bit ENA_SCL.
	I2C0_MMCTRL_ENA_SCL = 0x2
	// When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C0_MMCTRL_ENA_SCL_HIGH = 0x0
	// When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C0_MMCTRL_ENA_SCL_NORMAL = 0x1
	// Position of MATCH_ALL field.
	I2C0_MMCTRL_MATCH_ALL_Pos = 0x2
	// Bit mask of MATCH_ALL field.
	I2C0_MMCTRL_MATCH_ALL_Msk = 0x4
	// Bit MATCH_ALL.
	I2C0_MMCTRL_MATCH_ALL = 0x4
	// When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above. That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C0_MMCTRL_MATCH_ALL_MATCH = 0x0
	// When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C0_MMCTRL_MATCH_ALL_ANYADDRESS = 0x1
	// Position of RESERVED field.
	I2C0_MMCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C0_MMCTRL_RESERVED_Msk = 0xfffffff8

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C0_ADR_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C0_ADR_GC_Msk = 0x1
	// Bit GC.
	I2C0_ADR_GC = 0x1
	// Position of Address field.
	I2C0_ADR_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C0_ADR_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_ADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_ADR_RESERVED_Msk = 0xffffff00

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	// Position of Data field.
	I2C0_DATA_BUFFER_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C0_DATA_BUFFER_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C0_DATA_BUFFER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_DATA_BUFFER_RESERVED_Msk = 0xffffff00

	// MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
	// Position of RESERVED field.
	I2C0_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_MASK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	I2C0_MASK_RESERVED = 0x1
	// Position of MASK field.
	I2C0_MASK_MASK_Pos = 0x1
	// Bit mask of MASK field.
	I2C0_MASK_MASK_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_MASK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_MASK_RESERVED_Msk = 0xffffff00
)

// Constants for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUNNING = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_NOT_LOCKED = 0x0
	// The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_LOCKED = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// CLKSEL: Watchdog clock select register.
	// Position of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Pos = 0x0
	// Bit mask of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Msk = 0x1
	// Bit CLKSEL.
	WWDT_CLKSEL_CLKSEL = 0x1
	// IRC
	WWDT_CLKSEL_CLKSEL_IRC = 0x0
	// Watchdog oscillator (WDOSC)
	WWDT_CLKSEL_CLKSEL_WATCHDOG_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	WWDT_CLKSEL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	WWDT_CLKSEL_RESERVED_Msk = 0x7ffffffe
	// Position of LOCK field.
	WWDT_CLKSEL_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	WWDT_CLKSEL_LOCK_Msk = 0x80000000
	// Bit LOCK.
	WWDT_CLKSEL_LOCK = 0x80000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Constants for USART0: USART0
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	USART0_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	USART0_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	USART0_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	USART0_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	USART0_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	USART0_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	USART0_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	USART0_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	USART0_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLMSB field.
	USART0_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	USART0_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	USART0_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential USART interrupts. (DLAB=0)
	// Position of RBRINTEN field.
	USART0_IER_RBRINTEN_Pos = 0x0
	// Bit mask of RBRINTEN field.
	USART0_IER_RBRINTEN_Msk = 0x1
	// Bit RBRINTEN.
	USART0_IER_RBRINTEN = 0x1
	// Disable the RDA interrupt.
	USART0_IER_RBRINTEN_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupt.
	USART0_IER_RBRINTEN_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREINTEN field.
	USART0_IER_THREINTEN_Pos = 0x1
	// Bit mask of THREINTEN field.
	USART0_IER_THREINTEN_Msk = 0x2
	// Bit THREINTEN.
	USART0_IER_THREINTEN = 0x2
	// Disable the THRE interrupt.
	USART0_IER_THREINTEN_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupt.
	USART0_IER_THREINTEN_ENABLE_THE_THRE_INTE = 0x1
	// Position of RLSINTEN field.
	USART0_IER_RLSINTEN_Pos = 0x2
	// Bit mask of RLSINTEN field.
	USART0_IER_RLSINTEN_Msk = 0x4
	// Bit RLSINTEN.
	USART0_IER_RLSINTEN = 0x4
	// Disable the RLS interrupt.
	USART0_IER_RLSINTEN_DISABLE_THE_RLS_INTE = 0x0
	// Enable the RLS interrupt.
	USART0_IER_RLSINTEN_ENABLE_THE_RLS_INTER = 0x1
	// Position of MSINTEN field.
	USART0_IER_MSINTEN_Pos = 0x3
	// Bit mask of MSINTEN field.
	USART0_IER_MSINTEN_Msk = 0x8
	// Bit MSINTEN.
	USART0_IER_MSINTEN = 0x8
	// Disable the MS interrupt.
	USART0_IER_MSINTEN_DISABLE_THE_MS_INTER = 0x0
	// Enable the MS interrupt.
	USART0_IER_MSINTEN_ENABLE_THE_MS_INTERR = 0x1
	// Position of RESERVED field.
	USART0_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_IER_RESERVED_Msk = 0xf0
	// Position of ABEOINTEN field.
	USART0_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	USART0_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	USART0_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	USART0_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	USART0_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	USART0_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	USART0_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	USART0_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	USART0_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	USART0_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	USART0_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	USART0_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	USART0_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	USART0_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	USART0_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	USART0_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	USART0_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	USART0_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	USART0_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	USART0_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	USART0_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt.
	USART0_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// 4 - Modem status
	USART0_IIR_INTID_4_MODEM_STATUS = 0x0
	// Position of RESERVED field.
	USART0_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_IIR_RESERVED_Msk = 0x30
	// Position of FIFOEN field.
	USART0_IIR_FIFOEN_Pos = 0x6
	// Bit mask of FIFOEN field.
	USART0_IIR_FIFOEN_Msk = 0xc0
	// Position of ABEOINT field.
	USART0_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	USART0_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	USART0_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	USART0_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	USART0_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	USART0_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	USART0_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls USART FIFO usage and modes.
	// Position of FIFOEN field.
	USART0_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	USART0_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	USART0_FCR_FIFOEN = 0x1
	// USART FIFOs are disabled. Must not be used in the application.
	USART0_FCR_FIFOEN_DISABLED = 0x0
	// Active high enable for both USART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper USART operation. Any transition on this bit will automatically clear the USART FIFOs.
	USART0_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	USART0_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	USART0_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	USART0_FCR_RXFIFORES = 0x2
	// No impact on either of USART FIFOs.
	USART0_FCR_RXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in USART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	USART0_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	USART0_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	USART0_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	USART0_FCR_TXFIFORES = 0x4
	// No impact on either of USART FIFOs.
	USART0_FCR_TXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in USART TX FIFO, reset the pointer logic. This bit is self-clearing.
	USART0_FCR_TXFIFORES_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART0_FCR_RESERVED = 0x8
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0x30
	// Position of RXTL field.
	USART0_FCR_RXTL_Pos = 0x6
	// Bit mask of RXTL field.
	USART0_FCR_RXTL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	USART0_FCR_RXTL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	USART0_FCR_RXTL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	USART0_FCR_RXTL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	USART0_FCR_RXTL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	USART0_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	USART0_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	USART0_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	USART0_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	USART0_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	USART0_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	USART0_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	USART0_LCR_SBS_Msk = 0x4
	// Bit SBS.
	USART0_LCR_SBS = 0x4
	// 1 stop bit.
	USART0_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	USART0_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	USART0_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	USART0_LCR_PE_Msk = 0x8
	// Bit PE.
	USART0_LCR_PE = 0x8
	// Disable parity generation and checking.
	USART0_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	USART0_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	USART0_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	USART0_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	USART0_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	USART0_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	USART0_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	USART0_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	USART0_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	USART0_LCR_BC_Msk = 0x40
	// Bit BC.
	USART0_LCR_BC = 0x40
	// Disable break transmission.
	USART0_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin USART TXD is forced to logic 0 when LCR[6] is active high.
	USART0_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	USART0_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	USART0_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	USART0_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	USART0_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	USART0_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	USART0_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register.
	// Position of DTRCTRL field.
	USART0_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	USART0_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	USART0_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	USART0_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	USART0_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	USART0_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	USART0_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	USART0_MCR_LMS_Msk = 0x10
	// Bit LMS.
	USART0_MCR_LMS = 0x10
	// Disable modem loopback mode.
	USART0_MCR_LMS_DISABLE_MODEM_LOOPBA = 0x0
	// Enable modem loopback mode.
	USART0_MCR_LMS_ENABLE_MODEM_LOOPBAC = 0x1
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USART0_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	USART0_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	USART0_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	USART0_MCR_RTSEN = 0x40
	// Disable auto-rts flow control.
	USART0_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0
	// Enable auto-rts flow control.
	USART0_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1
	// Position of CTSEN field.
	USART0_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	USART0_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	USART0_MCR_CTSEN = 0x80
	// Disable auto-cts flow control.
	USART0_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0
	// Enable auto-cts flow control.
	USART0_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	USART0_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART0_LSR_RDR_Msk = 0x1
	// Bit RDR.
	USART0_LSR_RDR = 0x1
	// RBR is empty.
	USART0_LSR_RDR_RBR_IS_EMPTY_ = 0x0
	// RBR contains valid data.
	USART0_LSR_RDR_RBR_CONTAINS_VALID_D = 0x1
	// Position of OE field.
	USART0_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	USART0_LSR_OE_Msk = 0x2
	// Bit OE.
	USART0_LSR_OE = 0x2
	// Overrun error status is inactive.
	USART0_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	USART0_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	USART0_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	USART0_LSR_PE_Msk = 0x4
	// Bit PE.
	USART0_LSR_PE = 0x4
	// Parity error status is inactive.
	USART0_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	USART0_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	USART0_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	USART0_LSR_FE_Msk = 0x8
	// Bit FE.
	USART0_LSR_FE = 0x8
	// Framing error status is inactive.
	USART0_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	USART0_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	USART0_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	USART0_LSR_BI_Msk = 0x10
	// Bit BI.
	USART0_LSR_BI = 0x10
	// Break interrupt status is inactive.
	USART0_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	USART0_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	USART0_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	USART0_LSR_THRE_Msk = 0x20
	// Bit THRE.
	USART0_LSR_THRE = 0x20
	// THR contains valid data.
	USART0_LSR_THRE_THR_CONTAINS_VALID_D = 0x0
	// THR is empty.
	USART0_LSR_THRE_THR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	USART0_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	USART0_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	USART0_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	USART0_LSR_TEMT_VALID_D = 0x0
	// THR and the TSR are empty.
	USART0_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	USART0_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	USART0_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	USART0_LSR_RXFE = 0x80
	// RBR contains no USART RX errors or FCR[0]=0.
	USART0_LSR_RXFE_NO_ERROR = 0x0
	// USART RBR contains at least one USART RX error.
	USART0_LSR_RXFE_ERRO = 0x1
	// Position of TXERR field.
	USART0_LSR_TXERR_Pos = 0x8
	// Bit mask of TXERR field.
	USART0_LSR_TXERR_Msk = 0x100
	// Bit TXERR.
	USART0_LSR_TXERR = 0x100
	// Position of RESERVED field.
	USART0_LSR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_LSR_RESERVED_Msk = 0xfffffe00

	// MSR: Modem Status Register.
	// Position of DCTS field.
	USART0_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	USART0_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	USART0_MSR_DCTS = 0x1
	// No change detected on modem input, CTS.
	USART0_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, CTS.
	USART0_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1
	// Position of DDSR field.
	USART0_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	USART0_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	USART0_MSR_DDSR = 0x2
	// No change detected on modem input, DSR.
	USART0_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DSR.
	USART0_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1
	// Position of TERI field.
	USART0_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	USART0_MSR_TERI_Msk = 0x4
	// Bit TERI.
	USART0_MSR_TERI = 0x4
	// No change detected on modem input, RI.
	USART0_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0
	// Low-to-high transition detected on RI.
	USART0_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1
	// Position of DDCD field.
	USART0_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	USART0_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	USART0_MSR_DDCD = 0x8
	// No change detected on modem input, DCD.
	USART0_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DCD.
	USART0_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1
	// Position of CTS field.
	USART0_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART0_MSR_CTS_Msk = 0x10
	// Bit CTS.
	USART0_MSR_CTS = 0x10
	// Position of DSR field.
	USART0_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	USART0_MSR_DSR_Msk = 0x20
	// Bit DSR.
	USART0_MSR_DSR = 0x20
	// Position of RI field.
	USART0_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	USART0_MSR_RI_Msk = 0x40
	// Bit RI.
	USART0_MSR_RI = 0x40
	// Position of DCD field.
	USART0_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	USART0_MSR_DCD_Msk = 0x80
	// Bit DCD.
	USART0_MSR_DCD = 0x80
	// Position of RESERVED field.
	USART0_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	USART0_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	USART0_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	USART0_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	USART0_ACR_START_Pos = 0x0
	// Bit mask of START field.
	USART0_ACR_START_Msk = 0x1
	// Bit START.
	USART0_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	USART0_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	USART0_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	USART0_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	USART0_ACR_MODE_Msk = 0x2
	// Bit MODE.
	USART0_ACR_MODE = 0x2
	// Mode 0.
	USART0_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	USART0_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	USART0_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	USART0_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	USART0_ACR_AUTORESTART = 0x4
	// No restart
	USART0_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next USART Rx falling edge)
	USART0_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	USART0_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	USART0_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	USART0_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	USART0_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	USART0_ACR_ABEOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART0_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	USART0_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	USART0_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	USART0_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	USART0_ACR_ABTOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART0_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
	// Position of IRDAEN field.
	USART0_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	USART0_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	USART0_ICR_IRDAEN = 0x1
	// IrDA mode is disabled, USARTn acts as a standard USART.
	USART0_ICR_IRDAEN_IRDA_MODE_IS_DISABLE = 0x0
	// IrDA mode is enabled.
	USART0_ICR_IRDAEN_IRDA_MODE_IS_ENABLED = 0x1
	// Position of IRDAINV field.
	USART0_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	USART0_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	USART0_ICR_IRDAINV = 0x2
	// The serial input is not inverted.
	USART0_ICR_IRDAINV_INVERTED = 0x0
	// The serial input is inverted. This has no effect on the serial output.
	USART0_ICR_IRDAINV_NOT_INVERTED = 0x1
	// Position of FIXPULSEEN field.
	USART0_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	USART0_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	USART0_ICR_FIXPULSEEN = 0x4
	// IrDA fixed pulse width mode disabled.
	USART0_ICR_FIXPULSEEN_DISABLED = 0x0
	// IrDA fixed pulse width mode enabled.
	USART0_ICR_FIXPULSEEN_ENABLED = 0x1
	// Position of PULSEDIV field.
	USART0_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	USART0_ICR_PULSEDIV_Msk = 0x38
	// 3 / (16 x baud rate)
	USART0_ICR_PULSEDIV_3_DIV_16_X_BAUD_RATE = 0x0
	// 2 x TPCLK
	USART0_ICR_PULSEDIV_2_X_TPCLK = 0x1
	// 4 x TPCLK
	USART0_ICR_PULSEDIV_4_X_TPCLK = 0x2
	// 8 x TPCLK
	USART0_ICR_PULSEDIV_8_X_TPCLK = 0x3
	// 16 x TPCLK
	USART0_ICR_PULSEDIV_16_X_TPCLK = 0x4
	// 32 x TPCLK
	USART0_ICR_PULSEDIV_32_X_TPCLK = 0x5
	// 64 x TPCLK
	USART0_ICR_PULSEDIV_64_X_TPCLK = 0x6
	// 128 x TPCLK
	USART0_ICR_PULSEDIV_128_X_TPCLK = 0x7
	// Position of RESERVED field.
	USART0_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART0_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	USART0_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	USART0_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	USART0_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	USART0_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	USART0_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART0_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	USART0_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	USART0_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	USART0_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	USART0_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	USART0_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	USART0_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0xffff8000

	// TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
	// Position of RESERVED field.
	USART0_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	USART0_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	USART0_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	USART0_TER_TXEN = 0x80
	// Position of RESERVED field.
	USART0_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_TER_RESERVED_Msk = 0xffffff00

	// HDEN: Half duplex enable register.
	// Position of HDEN field.
	USART0_HDEN_HDEN_Pos = 0x0
	// Bit mask of HDEN field.
	USART0_HDEN_HDEN_Msk = 0x1
	// Bit HDEN.
	USART0_HDEN_HDEN = 0x1
	// Disable half-duplex mode.
	USART0_HDEN_HDEN_DISABLE_HALF_DUPLEX_ = 0x0
	// Enable half-duplex mode.
	USART0_HDEN_HDEN_ENABLE_HALF_DUPLEX_M = 0x1
	// Position of RESERVED field.
	USART0_HDEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_HDEN_RESERVED_Msk = 0xfffffffe

	// SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
	// Position of SCIEN field.
	USART0_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	USART0_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	USART0_SCICTRL_SCIEN = 0x1
	// Smart card interface disabled.
	USART0_SCICTRL_SCIEN_SMART_CARD_INTERFACE = 0x0
	// Asynchronous half duplex smart card interface is enabled.
	USART0_SCICTRL_SCIEN_ASYNCHRONOUS_HALF_DU = 0x1
	// Position of NACKDIS field.
	USART0_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	USART0_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	USART0_SCICTRL_NACKDIS = 0x2
	// A NACK response is enabled.
	USART0_SCICTRL_NACKDIS_ENABLED = 0x0
	// A NACK response is inhibited.
	USART0_SCICTRL_NACKDIS_DISABLED = 0x1
	// Position of PROTSEL field.
	USART0_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	USART0_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	USART0_SCICTRL_PROTSEL = 0x4
	// T = 0
	USART0_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	USART0_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of RESERVED field.
	USART0_SCICTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_SCICTRL_RESERVED_Msk = 0x18
	// Position of TXRETRY field.
	USART0_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	USART0_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of XTRAGUARD field.
	USART0_SCICTRL_XTRAGUARD_Pos = 0x8
	// Bit mask of XTRAGUARD field.
	USART0_SCICTRL_XTRAGUARD_Msk = 0xff00
	// Position of RESERVED field.
	USART0_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	USART0_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	USART0_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	USART0_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	USART0_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	USART0_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	USART0_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	USART0_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	USART0_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	USART0_RS485CTRL_RXDIS_THE_RECEIVER_IS_ENAB = 0x0
	// The receiver is disabled.
	USART0_RS485CTRL_RXDIS_THE_RECEIVER_IS_DISA = 0x1
	// Position of AADEN field.
	USART0_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	USART0_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	USART0_RS485CTRL_AADEN = 0x4
	// Position of SEL field.
	USART0_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	USART0_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	USART0_RS485CTRL_SEL = 0x8
	// If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	USART0_RS485CTRL_SEL_RTS = 0x0
	// If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	USART0_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	USART0_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	USART0_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	USART0_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	USART0_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	USART0_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	USART0_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	USART0_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	USART0_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	USART0_RS485CTRL_OINV_LOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	USART0_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	USART0_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART0_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	USART0_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	USART0_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	USART0_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	USART0_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	USART0_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	USART0_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RS485DLY_RESERVED_Msk = 0xffffff00

	// SYNCCTRL: Synchronous mode control register.
	// Position of SYNC field.
	USART0_SYNCCTRL_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	USART0_SYNCCTRL_SYNC_Msk = 0x1
	// Bit SYNC.
	USART0_SYNCCTRL_SYNC = 0x1
	// Disabled
	USART0_SYNCCTRL_SYNC_DISABLED = 0x0
	// Enabled
	USART0_SYNCCTRL_SYNC_ENABLED = 0x1
	// Position of CSRC field.
	USART0_SYNCCTRL_CSRC_Pos = 0x1
	// Bit mask of CSRC field.
	USART0_SYNCCTRL_CSRC_Msk = 0x2
	// Bit CSRC.
	USART0_SYNCCTRL_CSRC = 0x2
	// Synchronous slave mode (SCLK in)
	USART0_SYNCCTRL_CSRC_SYNCHRONOUS_SLAVE_MO = 0x0
	// Synchronous master mode (SCLK out)
	USART0_SYNCCTRL_CSRC_SYNCHRONOUS_MASTER_M = 0x1
	// Position of FES field.
	USART0_SYNCCTRL_FES_Pos = 0x2
	// Bit mask of FES field.
	USART0_SYNCCTRL_FES_Msk = 0x4
	// Bit FES.
	USART0_SYNCCTRL_FES = 0x4
	// RxD is sampled on the rising edge of SCLK
	USART0_SYNCCTRL_FES_RISING = 0x0
	// RxD is sampled on the falling edge of SCLK
	USART0_SYNCCTRL_FES_FALLING = 0x1
	// Position of TSBYPASS field.
	USART0_SYNCCTRL_TSBYPASS_Pos = 0x3
	// Bit mask of TSBYPASS field.
	USART0_SYNCCTRL_TSBYPASS_Msk = 0x8
	// Bit TSBYPASS.
	USART0_SYNCCTRL_TSBYPASS = 0x8
	// The input clock is synchronized prior to being used in clock edge detection logic
	USART0_SYNCCTRL_TSBYPASS_SYNC = 0x0
	// The input clock is not synchronized prior to being used in clock edge detection logic. This allows for a high er input clock rate at the expense of potential metastability.
	USART0_SYNCCTRL_TSBYPASS_NOSYNC = 0x1
	// Position of CSCEN field.
	USART0_SYNCCTRL_CSCEN_Pos = 0x4
	// Bit mask of CSCEN field.
	USART0_SYNCCTRL_CSCEN_Msk = 0x10
	// Bit CSCEN.
	USART0_SYNCCTRL_CSCEN = 0x10
	// SCLK cycles only when characters are being sent on TxD
	USART0_SYNCCTRL_CSCEN_SCLK_CYCLES_ONLY_WHE = 0x0
	// SCLK runs continuously (characters can be received on RxD independently from transmission on TxD)
	USART0_SYNCCTRL_CSCEN_SCLK_RUNS_CONTINUOUS = 0x1
	// Position of SSDIS field.
	USART0_SYNCCTRL_SSDIS_Pos = 0x5
	// Bit mask of SSDIS field.
	USART0_SYNCCTRL_SSDIS_Msk = 0x20
	// Bit SSDIS.
	USART0_SYNCCTRL_SSDIS = 0x20
	// Send start and stop bits as in other modes.
	USART0_SYNCCTRL_SSDIS_SEND_START_AND_STOP_ = 0x0
	// Do not send start/stop bits.
	USART0_SYNCCTRL_SSDIS_DO_NOT_SEND_STARTSTOP = 0x1
	// Position of CCCLR field.
	USART0_SYNCCTRL_CCCLR_Pos = 0x6
	// Bit mask of CCCLR field.
	USART0_SYNCCTRL_CCCLR_Msk = 0x40
	// Bit CCCLR.
	USART0_SYNCCTRL_CCCLR = 0x40
	// CSCEN is under software control.
	USART0_SYNCCTRL_CCCLR_CSCEN_IS_UNDER_SOFTW = 0x0
	// Hardware clears CSCEN after each character is received.
	USART0_SYNCCTRL_CCCLR_HARDWARE_CLEARS_CSCE = 0x1
	// Position of RESERVED field.
	USART0_SYNCCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_SYNCCTRL_RESERVED_Msk = 0xffffff80
)

// Constants for CT16B0: 16-bit counter/timers CT16B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT16B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT16B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT16B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT16B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT16B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT16B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT16B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT16B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT16B0_IR_CR2INT = 0x40
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT16B0_TCR_CEN_DISABLED = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT16B0_TCR_CEN_ENABLED = 0x1
	// Position of CRST field.
	CT16B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B0_TCR_CRST = 0x2
	// Do nothing.
	CT16B0_TCR_CRST_NOP = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT16B0_TCR_CRST_RESET = 0x1
	// Position of RESERVED field.
	CT16B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TCVAL field.
	CT16B0_TC_TCVAL_Pos = 0x0
	// Bit mask of TCVAL field.
	CT16B0_TC_TCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT16B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT16B0_PR_PCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B0_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B0_MCR_MR0I = 0x1
	// Enabled
	CT16B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT16B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B0_MCR_MR0R = 0x2
	// Enabled
	CT16B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT16B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B0_MCR_MR0S = 0x4
	// Enabled
	CT16B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT16B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B0_MCR_MR1I = 0x8
	// Enabled
	CT16B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT16B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B0_MCR_MR1R = 0x10
	// Enabled
	CT16B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT16B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B0_MCR_MR1S = 0x20
	// Enabled
	CT16B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT16B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B0_MCR_MR2I = 0x40
	// Enabled
	CT16B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT16B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B0_MCR_MR2R = 0x80
	// Enabled
	CT16B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT16B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B0_MCR_MR2S = 0x100
	// Enabled
	CT16B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT16B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B0_MCR_MR3I = 0x200
	// Enabled
	CT16B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT16B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B0_MCR_MR3R = 0x400
	// Enabled
	CT16B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT16B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B0_MCR_MR3S = 0x800
	// Enabled
	CT16B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT16B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B0_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_MR_RESERVED_Msk = 0xffff0000

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT16B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT16B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT16B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT16B0_CCR_CAP0RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0RE_DISABLED = 0x0
	// Position of CAP0FE field.
	CT16B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT16B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT16B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT16B0_CCR_CAP0FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0FE_DISABLED = 0x0
	// Position of CAP0I field.
	CT16B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT16B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT16B0_CCR_CAP0I = 0x4
	// Enabled.
	CT16B0_CCR_CAP0I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0I_DISABLED = 0x0
	// Position of CAP1RE field.
	CT16B0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT16B0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT16B0_CCR_CAP1RE = 0x8
	// Enabled.
	CT16B0_CCR_CAP1RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1RE_DISABLED = 0x0
	// Position of CAP1FE field.
	CT16B0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT16B0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT16B0_CCR_CAP1FE = 0x10
	// Enabled.
	CT16B0_CCR_CAP1FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1FE_DISABLED = 0x0
	// Position of CAP1I field.
	CT16B0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT16B0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT16B0_CCR_CAP1I = 0x20
	// Enabled.
	CT16B0_CCR_CAP1I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1I_DISABLED = 0x0
	// Position of CAP2RE field.
	CT16B0_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	CT16B0_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	CT16B0_CCR_CAP2RE = 0x40
	// Enabled.
	CT16B0_CCR_CAP2RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2RE_DISABLED = 0x0
	// Position of CAP2FE field.
	CT16B0_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	CT16B0_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	CT16B0_CCR_CAP2FE = 0x80
	// Enabled.
	CT16B0_CCR_CAP2FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2FE_DISABLED = 0x0
	// Position of CAP2I field.
	CT16B0_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	CT16B0_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	CT16B0_CCR_CAP2I = 0x100
	// Enabled.
	CT16B0_CCR_CAP2I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2I_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
	// Position of CAP field.
	CT16B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B0_CR_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_CR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_CR_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of EM0 field.
	CT16B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B0_EMR_EMC0_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC0_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC0_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT16B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B0_EMR_EMC1_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC1_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC1_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT16B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B0_EMR_EMC2_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC2_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC2_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT16B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B0_EMR_EMC3_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC3_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC3_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT16B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT16B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT16B0_CTCR_CTM_Msk = 0x3
	// Timer Mode. Increments every rising PCLK edge
	CT16B0_CTCR_CTM_TIMER_MODE = 0x0
	// Counter Moderising edge. . TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_RISING = 0x1
	// Counter Mode falling edge: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_FALLING = 0x2
	// Counter Mode dual edge: TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_DUAL = 0x3
	// Position of CIS field.
	CT16B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT16B0_CTCR_CIS_Msk = 0xc
	// Capture channel 0.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_0 = 0x0
	// Capture channel 1.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_1 = 0x1
	// Capture channel 2.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_2 = 0x2
	// Position of ENCC field.
	CT16B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT16B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT16B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT16B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT16B0_CTCR_SELCC_Msk = 0xe0
	// Rising Edge of thesignal on capture channel 0 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP0RISING = 0x0
	// Falling Edge of thesignal on capture channel 0 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP0FALLING = 0x1
	// Rising Edge of thesignal on capture channel 1 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP1RISING = 0x2
	// Rising Edge of thesignal on capture channel 2 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP2RISING = 0x4
	// Position of RESERVED field.
	CT16B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B0_PWMC_PWMEN0 = 0x1
	// CT16Bn_MAT0 is controlled by EM0.
	CT16B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT16Bn_MAT0.
	CT16B0_PWMC_PWMEN0_PWM = 0x1
	// Position of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B0_PWMC_PWMEN1 = 0x2
	// CT16Bn_MAT01 is controlled by EM1.
	CT16B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT16Bn_MAT1.
	CT16B0_PWMC_PWMEN1_PWM = 0x1
	// Position of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B0_PWMC_PWMEN2 = 0x4
	// CT16Bn_MAT2 is controlled by EM2.
	CT16B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT16Bn_MAT2.
	CT16B0_PWMC_PWMEN2_PWM = 0x1
	// Position of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B0_PWMC_PWMEN3 = 0x8
	// CT16Bn_MAT3 is controlled by EM3.
	CT16B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT16Bn_MAT3.
	CT16B0_PWMC_PWMEN3_PWM = 0x1
	// Position of RESERVED field.
	CT16B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Constants for CT32B0: 32-bit counter/timers CT32B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT32B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT32B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT32B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT32B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT32B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT32B0_IR_CR2INT = 0x40
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT32B0_TCR_CEN_DISABLED = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT32B0_TCR_CEN_ENABLED = 0x1
	// Position of CRST field.
	CT32B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B0_TCR_CRST = 0x2
	// Do nothing.
	CT32B0_TCR_CRST_NOP = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B0_TCR_CRST_RESET = 0x1
	// Position of RESERVED field.
	CT32B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TCVAL field.
	CT32B0_TC_TCVAL_Pos = 0x0
	// Bit mask of TCVAL field.
	CT32B0_TC_TCVAL_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT32B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B0_PR_PCVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B0_MCR_MR0I = 0x1
	// Enabled
	CT32B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT32B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B0_MCR_MR0R = 0x2
	// Enabled
	CT32B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT32B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B0_MCR_MR0S = 0x4
	// Enabled
	CT32B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT32B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B0_MCR_MR1I = 0x8
	// Enabled
	CT32B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT32B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B0_MCR_MR1R = 0x10
	// Enabled
	CT32B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT32B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B0_MCR_MR1S = 0x20
	// Enabled
	CT32B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT32B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B0_MCR_MR2I = 0x40
	// Enabled
	CT32B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT32B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B0_MCR_MR2R = 0x80
	// Enabled
	CT32B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT32B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B0_MCR_MR2S = 0x100
	// Enabled
	CT32B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT32B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B0_MCR_MR3I = 0x200
	// Enabled
	CT32B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT32B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B0_MCR_MR3R = 0x400
	// Enabled
	CT32B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT32B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B0_MCR_MR3S = 0x800
	// Enabled
	CT32B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT32B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B0_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT32B0_CCR_CAP0RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0RE_DISABLED = 0x0
	// Position of CAP0FE field.
	CT32B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT32B0_CCR_CAP0FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0FE_DISABLED = 0x0
	// Position of CAP0I field.
	CT32B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B0_CCR_CAP0I = 0x4
	// Enabled.
	CT32B0_CCR_CAP0I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0I_DISABLED = 0x0
	// Position of CAP1RE field.
	CT32B0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT32B0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT32B0_CCR_CAP1RE = 0x8
	// Enabled.
	CT32B0_CCR_CAP1RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1RE_DISABLED = 0x0
	// Position of CAP1FE field.
	CT32B0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT32B0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT32B0_CCR_CAP1FE = 0x10
	// Enabled.
	CT32B0_CCR_CAP1FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1FE_DISABLED = 0x0
	// Position of CAP1I field.
	CT32B0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT32B0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT32B0_CCR_CAP1I = 0x20
	// Enabled.
	CT32B0_CCR_CAP1I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1I_DISABLED = 0x0
	// Position of CAP2RE field.
	CT32B0_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	CT32B0_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	CT32B0_CCR_CAP2RE = 0x40
	// Enabled.
	CT32B0_CCR_CAP2RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2RE_DISABLED = 0x0
	// Position of CAP2FE field.
	CT32B0_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	CT32B0_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	CT32B0_CCR_CAP2FE = 0x80
	// Enabled.
	CT32B0_CCR_CAP2FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2FE_DISABLED = 0x0
	// Position of CAP2I field.
	CT32B0_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	CT32B0_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	CT32B0_CCR_CAP2I = 0x100
	// Enabled.
	CT32B0_CCR_CAP2I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2I_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT32B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
	// Position of CAP field.
	CT32B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B0_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
	// Position of EM0 field.
	CT32B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B0_EMR_EMC0_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC0_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC0_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT32B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B0_EMR_EMC1_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC1_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC1_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT32B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B0_EMR_EMC2_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC2_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC2_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT32B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B0_EMR_EMC3_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC3_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC3_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT32B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B0_CTCR_CTM_Msk = 0x3
	// Timer Mode. Increments every rising PCLK edge
	CT32B0_CTCR_CTM_TIMER_MODE = 0x0
	// Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_RISING = 0x1
	// Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_FALLING = 0x2
	// Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_DUAL_ED = 0x3
	// Position of CIS field.
	CT32B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B0_CTCR_CIS_Msk = 0xc
	// Capture channel 0.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_0 = 0x0
	// Capture channel 1.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_1 = 0x1
	// Capture channel 2.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_2 = 0x2
	// Position of ENCC field.
	CT32B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT32B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT32B0_CTCR_SELCC_Msk = 0xe0
	// Rising Edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP0RISING = 0x0
	// Falling Edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP0FALLING = 0x1
	// Rising Edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP1RISING = 0x2
	// Falling Edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP1FALLING = 0x3
	// Rising Edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP2RISING = 0x4
	// Falling Edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP2FALLING = 0x5
	// Position of RESERVED field.
	CT32B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B0_PWMC_PWMEN0 = 0x1
	// CT32Bn_MAT0 is controlled by EM0.
	CT32B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT32Bn_MAT0.
	CT32B0_PWMC_PWMEN0_PWM = 0x1
	// Position of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B0_PWMC_PWMEN1 = 0x2
	// CT32Bn_MAT01 is controlled by EM1.
	CT32B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT32Bn_MAT1.
	CT32B0_PWMC_PWMEN1_PWM = 0x1
	// Position of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B0_PWMC_PWMEN2 = 0x4
	// CT32Bn_MAT2 is controlled by EM2.
	CT32B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT32Bn_MAT2.
	CT32B0_PWMC_PWMEN2_PWM = 0x1
	// Position of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B0_PWMC_PWMEN3 = 0x8
	// CT32Bn_MAT3 is controlled by EM3.
	CT32B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT132Bn_MAT3.
	CT32B0_PWMC_PWMEN3_PWM = 0x1
	// Position of RESERVED field.
	CT32B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Constants for ADC: 12-bit Analog-to-Digital Converter (ADC)
const (
	// CTRL: A/D Control Register. Contains the clock divide value, enable bits for each sequence and the A/D power-down bit.
	// Position of CLKDIV field.
	ADC_CTRL_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	ADC_CTRL_CLKDIV_Msk = 0xff
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x300
	// Position of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Pos = 0xa
	// Bit mask of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Msk = 0x400
	// Bit LPWRMODE.
	ADC_CTRL_LPWRMODE = 0x400
	// Disabled. The low-power ADC mode is disabled. The analog circuitry remains activated even when no conversions are requested.
	ADC_CTRL_LPWRMODE_DISABLED = 0x0
	// Enabled. The low-power ADC mode is enabled.
	ADC_CTRL_LPWRMODE_ENABLED = 0x1
	// Position of CAL_MODE field.
	ADC_CTRL_CAL_MODE_Pos = 0x1e
	// Bit mask of CAL_MODE field.
	ADC_CTRL_CAL_MODE_Msk = 0x40000000
	// Bit CAL_MODE.
	ADC_CTRL_CAL_MODE = 0x40000000
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ADC_CTRL_RESERVED = 0x80000000

	// SEQA_CTRL: A/D Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
	// Position of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Msk = 0x7000
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x38000
	// Position of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQA_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQA_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQA_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQA_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQA_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQA_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQA_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQA_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQA_CTRL_SINGLESTEP = 0x10000000
	// Position of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Pos = 0x1d
	// Bit mask of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Msk = 0x20000000
	// Bit LOWPRIO.
	ADC_SEQA_CTRL_LOWPRIO = 0x20000000
	// Low priority. Any B trigger which occurs while an A conversion sequence is active will be ignored and lost.
	ADC_SEQA_CTRL_LOWPRIO_LOW_PRIORITY = 0x0
	// High priority. Setting this bit to a 1 will permit any enabled B sequence trigger (including a B sequence software start) to immediately interrupt this sequence and launch a B sequence in it's place. The conversion currently in progress will be terminated. The A sequence that was interrupted will automatically resume after the B sequence completes. The channel whose conversion was terminated will be re-sampled and the conversion sequence will resume from that point.
	ADC_SEQA_CTRL_LOWPRIO_HIGH_PRIORITY = 0x1
	// Position of MODE field.
	ADC_SEQA_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQA_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQA_CTRL_MODE = 0x40000000
	// End of conversion. The sequence A interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence A. This flag will mirror the DATAVALID bit in the SEQA_GDAT register. The OVERRUN bit in the SEQA_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQA_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence A interrupt/DMA flag will be set when the entire set of sequence-A conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQA_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register may not be utilized in this mode.
	ADC_SEQA_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Pos = 0x1f
	// Bit mask of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Msk = 0x80000000
	// Bit SEQA_ENA.
	ADC_SEQA_CTRL_SEQA_ENA = 0x80000000
	// Disabled. Sequence A is disabled. Sequence A triggers are ignored. If this bit is cleared while sequence A is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQA_CTRL_SEQA_ENA_DISABLED = 0x0
	// Enabled. Sequence A is enabled.
	ADC_SEQA_CTRL_SEQA_ENA_ENABLED = 0x1

	// SEQB_CTRL: A/D Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
	// Position of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Msk = 0x7000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x38000
	// Position of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQB_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQB_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQB_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQB_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQB_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQB_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQB_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQB_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQB_CTRL_SINGLESTEP = 0x10000000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	ADC_SEQB_CTRL_RESERVED = 0x20000000
	// Position of MODE field.
	ADC_SEQB_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQB_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQB_CTRL_MODE = 0x40000000
	// End of conversion. The sequence B interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence B. This flag will mirror the DATAVALID bit in the SEQB_GDAT register. The OVERRUN bit in the SEQB_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQB_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence B interrupt/DMA flag will be set when the entire set of sequence B conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQB_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register will not be utilized in this mode.
	ADC_SEQB_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Pos = 0x1f
	// Bit mask of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Msk = 0x80000000
	// Bit SEQB_ENA.
	ADC_SEQB_CTRL_SEQB_ENA = 0x80000000
	// Disabled. Sequence B is disabled. Sequence B triggers are ignored. If this bit is cleared while sequence B is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQB_CTRL_SEQB_ENA_DISABLED = 0x0
	// Enabled. Sequence B is enabled.
	ADC_SEQB_CTRL_SEQB_ENA_ENABLED = 0x1

	// SEQA_GDAT: A/D Sequence-A Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-A
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQA_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQA_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQA_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQA_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQA_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQA_GDAT_DATAVALID = 0x80000000

	// SEQB_GDAT: A/D Sequence-B Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-B
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQB_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQB_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQB_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQB_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQB_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQB_GDAT_DATAVALID = 0x80000000

	// DAT: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_DAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_DAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0x3f00000
	// Position of CHANNEL field.
	ADC_DAT_CHANNEL_Pos = 0x1a
	// Bit mask of CHANNEL field.
	ADC_DAT_CHANNEL_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_DAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_DAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_DAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_DAT_DATAVALID = 0x80000000

	// THR0_LOW: A/D Low Compare Threshold Register 0 : Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of THRLOW field.
	ADC_THR0_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR0_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_LOW_RESERVED_Msk = 0xffff0000

	// THR1_LOW: A/D Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of THRLOW field.
	ADC_THR1_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR1_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_LOW_RESERVED_Msk = 0xffff0000

	// THR0_HIGH: A/D High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Msk = 0xffff0000

	// THR1_HIGH: A/D High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Msk = 0xffff0000

	// CHAN_THRSEL: A/D Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
	// Position of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Pos = 0x0
	// Bit mask of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Msk = 0x1
	// Bit CH0_THRSEL.
	ADC_CHAN_THRSEL_CH0_THRSEL = 0x1
	// Threshold 0. Channel 0 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 0 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Pos = 0x1
	// Bit mask of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Msk = 0x2
	// Bit CH1_THRSEL.
	ADC_CHAN_THRSEL_CH1_THRSEL = 0x2
	// Threshold 0. Channel 1 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 1 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Pos = 0x2
	// Bit mask of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Msk = 0x4
	// Bit CH2_THRSEL.
	ADC_CHAN_THRSEL_CH2_THRSEL = 0x4
	// Threshold 0. Channel 2 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 2 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Pos = 0x3
	// Bit mask of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Msk = 0x8
	// Bit CH3_THRSEL.
	ADC_CHAN_THRSEL_CH3_THRSEL = 0x8
	// Threshold 0. Channel 3 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 3 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Pos = 0x4
	// Bit mask of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Msk = 0x10
	// Bit CH4_THRSEL.
	ADC_CHAN_THRSEL_CH4_THRSEL = 0x10
	// Threshold 0. Channel 4 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 4 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Pos = 0x5
	// Bit mask of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Msk = 0x20
	// Bit CH5_THRSEL.
	ADC_CHAN_THRSEL_CH5_THRSEL = 0x20
	// Threshold 0. Channel 5 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 5 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Pos = 0x6
	// Bit mask of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Msk = 0x40
	// Bit CH6_THRSEL.
	ADC_CHAN_THRSEL_CH6_THRSEL = 0x40
	// Threshold 0. Channel 6 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 6 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Pos = 0x7
	// Bit mask of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Msk = 0x80
	// Bit CH7_THRSEL.
	ADC_CHAN_THRSEL_CH7_THRSEL = 0x80
	// Threshold 0. Channel 7 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 7 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Pos = 0x8
	// Bit mask of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Msk = 0x100
	// Bit CH8_THRSEL.
	ADC_CHAN_THRSEL_CH8_THRSEL = 0x100
	// Threshold 0. Channel 8 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 8 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Pos = 0x9
	// Bit mask of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Msk = 0x200
	// Bit CH9_THRSEL.
	ADC_CHAN_THRSEL_CH9_THRSEL = 0x200
	// Threshold 0. Channel 9 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 9 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Pos = 0xa
	// Bit mask of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Msk = 0x400
	// Bit CH10_THRSEL.
	ADC_CHAN_THRSEL_CH10_THRSEL = 0x400
	// Threshold 0. Channel 10 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 10 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Pos = 0xb
	// Bit mask of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Msk = 0x800
	// Bit CH11_THRSEL.
	ADC_CHAN_THRSEL_CH11_THRSEL = 0x800
	// Threshold 0. Channel 11 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 11 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_1 = 0x1

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
	// Position of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Pos = 0x0
	// Bit mask of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Msk = 0x1
	// Bit SEQA_INTEN.
	ADC_INTEN_SEQA_INTEN = 0x1
	// Disabled. The sequence A interrupt/DMA request is disabled.
	ADC_INTEN_SEQA_INTEN_DISABLED = 0x0
	// Enabled. The sequence A interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence A, or upon completion of the entire A sequence of conversions, depending on the MODE bit in the SEQA_CTRL register.
	ADC_INTEN_SEQA_INTEN_ENABLED = 0x1
	// Position of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Pos = 0x1
	// Bit mask of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Msk = 0x2
	// Bit SEQB_INTEN.
	ADC_INTEN_SEQB_INTEN = 0x2
	// Disabled. The sequence B interrupt/DMA request is disabled.
	ADC_INTEN_SEQB_INTEN_DISABLED = 0x0
	// Enabled. The sequence B interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence B, or upon completion of the entire B sequence of conversions, depending on the MODE bit in the SEQB_CTRL register.
	ADC_INTEN_SEQB_INTEN_ENABLED = 0x1
	// Position of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Pos = 0x2
	// Bit mask of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Msk = 0x4
	// Bit OVR_INTEN.
	ADC_INTEN_OVR_INTEN = 0x4
	// Disabled. The overrun interrupt is disabled.
	ADC_INTEN_OVR_INTEN_DISABLED = 0x0
	// Enabled. The overrun interrupt is enabled. Detection of an overrun condition on any of the 12 channel data registers will cause an overrun interrupt request. In addition, if the MODE bit for a particular sequence is 0, then an overrun in the global data register for that sequence will also cause this interrupt request to be asserted.
	ADC_INTEN_OVR_INTEN_ENABLED = 0x1
	// Position of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Pos = 0x3
	// Bit mask of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Msk = 0x18
	// Disabled.
	ADC_INTEN_ADCMPINTEN0_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN0_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN0_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Pos = 0x5
	// Bit mask of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Msk = 0x60
	// Disabled.
	ADC_INTEN_ADCMPINTEN1_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN1_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN1_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Pos = 0x7
	// Bit mask of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Msk = 0x180
	// Disabled.
	ADC_INTEN_ADCMPINTEN2_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN2_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN2_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Pos = 0x9
	// Bit mask of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Msk = 0x600
	// Disabled.
	ADC_INTEN_ADCMPINTEN3_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN3_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN3_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Pos = 0xb
	// Bit mask of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Msk = 0x1800
	// Disabled.
	ADC_INTEN_ADCMPINTEN4_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN4_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN4_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Pos = 0xd
	// Bit mask of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Msk = 0x6000
	// Disabled.
	ADC_INTEN_ADCMPINTEN5_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN5_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN5_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Pos = 0xf
	// Bit mask of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Msk = 0x18000
	// Disabled.
	ADC_INTEN_ADCMPINTEN6_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN6_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN6_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Pos = 0x11
	// Bit mask of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Msk = 0x60000
	// Disabled.
	ADC_INTEN_ADCMPINTEN7_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN7_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN7_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Pos = 0x13
	// Bit mask of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Msk = 0x180000
	// Disabled.
	ADC_INTEN_ADCMPINTEN8_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN8_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN8_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Pos = 0x15
	// Bit mask of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Msk = 0x600000
	// Disabled.
	ADC_INTEN_ADCMPINTEN9_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN9_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN9_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Pos = 0x17
	// Bit mask of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Msk = 0x1800000
	// Disabled.
	ADC_INTEN_ADCMPINTEN10_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN10_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN10_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Pos = 0x19
	// Bit mask of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Msk = 0x6000000
	// Disabled.
	ADC_INTEN_ADCMPINTEN11_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN11_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN11_CROSSING_THRESHOLD = 0x2
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xf8000000

	// FLAGS: A/D Flags Register. Contains the four interrupt request flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
	// Position of THCMP0 field.
	ADC_FLAGS_THCMP0_Pos = 0x0
	// Bit mask of THCMP0 field.
	ADC_FLAGS_THCMP0_Msk = 0x1
	// Bit THCMP0.
	ADC_FLAGS_THCMP0 = 0x1
	// Position of THCMP1 field.
	ADC_FLAGS_THCMP1_Pos = 0x1
	// Bit mask of THCMP1 field.
	ADC_FLAGS_THCMP1_Msk = 0x2
	// Bit THCMP1.
	ADC_FLAGS_THCMP1 = 0x2
	// Position of THCMP2 field.
	ADC_FLAGS_THCMP2_Pos = 0x2
	// Bit mask of THCMP2 field.
	ADC_FLAGS_THCMP2_Msk = 0x4
	// Bit THCMP2.
	ADC_FLAGS_THCMP2 = 0x4
	// Position of THCMP3 field.
	ADC_FLAGS_THCMP3_Pos = 0x3
	// Bit mask of THCMP3 field.
	ADC_FLAGS_THCMP3_Msk = 0x8
	// Bit THCMP3.
	ADC_FLAGS_THCMP3 = 0x8
	// Position of THCMP4 field.
	ADC_FLAGS_THCMP4_Pos = 0x4
	// Bit mask of THCMP4 field.
	ADC_FLAGS_THCMP4_Msk = 0x10
	// Bit THCMP4.
	ADC_FLAGS_THCMP4 = 0x10
	// Position of THCMP5 field.
	ADC_FLAGS_THCMP5_Pos = 0x5
	// Bit mask of THCMP5 field.
	ADC_FLAGS_THCMP5_Msk = 0x20
	// Bit THCMP5.
	ADC_FLAGS_THCMP5 = 0x20
	// Position of THCMP6 field.
	ADC_FLAGS_THCMP6_Pos = 0x6
	// Bit mask of THCMP6 field.
	ADC_FLAGS_THCMP6_Msk = 0x40
	// Bit THCMP6.
	ADC_FLAGS_THCMP6 = 0x40
	// Position of THCMP7 field.
	ADC_FLAGS_THCMP7_Pos = 0x7
	// Bit mask of THCMP7 field.
	ADC_FLAGS_THCMP7_Msk = 0x80
	// Bit THCMP7.
	ADC_FLAGS_THCMP7 = 0x80
	// Position of THCMP8 field.
	ADC_FLAGS_THCMP8_Pos = 0x8
	// Bit mask of THCMP8 field.
	ADC_FLAGS_THCMP8_Msk = 0x100
	// Bit THCMP8.
	ADC_FLAGS_THCMP8 = 0x100
	// Position of THCMP9 field.
	ADC_FLAGS_THCMP9_Pos = 0x9
	// Bit mask of THCMP9 field.
	ADC_FLAGS_THCMP9_Msk = 0x200
	// Bit THCMP9.
	ADC_FLAGS_THCMP9 = 0x200
	// Position of THCMP10 field.
	ADC_FLAGS_THCMP10_Pos = 0xa
	// Bit mask of THCMP10 field.
	ADC_FLAGS_THCMP10_Msk = 0x400
	// Bit THCMP10.
	ADC_FLAGS_THCMP10 = 0x400
	// Position of THCMP11 field.
	ADC_FLAGS_THCMP11_Pos = 0xb
	// Bit mask of THCMP11 field.
	ADC_FLAGS_THCMP11_Msk = 0x800
	// Bit THCMP11.
	ADC_FLAGS_THCMP11 = 0x800
	// Position of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Pos = 0xc
	// Bit mask of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Msk = 0x1000
	// Bit OVERRUN0.
	ADC_FLAGS_OVERRUN0 = 0x1000
	// Position of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Pos = 0xd
	// Bit mask of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Msk = 0x2000
	// Bit OVERRUN1.
	ADC_FLAGS_OVERRUN1 = 0x2000
	// Position of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Pos = 0xe
	// Bit mask of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Msk = 0x4000
	// Bit OVERRUN2.
	ADC_FLAGS_OVERRUN2 = 0x4000
	// Position of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Pos = 0xf
	// Bit mask of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Msk = 0x8000
	// Bit OVERRUN3.
	ADC_FLAGS_OVERRUN3 = 0x8000
	// Position of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Pos = 0x10
	// Bit mask of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Msk = 0x10000
	// Bit OVERRUN4.
	ADC_FLAGS_OVERRUN4 = 0x10000
	// Position of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Pos = 0x11
	// Bit mask of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Msk = 0x20000
	// Bit OVERRUN5.
	ADC_FLAGS_OVERRUN5 = 0x20000
	// Position of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Pos = 0x12
	// Bit mask of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Msk = 0x40000
	// Bit OVERRUN6.
	ADC_FLAGS_OVERRUN6 = 0x40000
	// Position of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Pos = 0x13
	// Bit mask of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Msk = 0x80000
	// Bit OVERRUN7.
	ADC_FLAGS_OVERRUN7 = 0x80000
	// Position of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Pos = 0x14
	// Bit mask of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Msk = 0x100000
	// Bit OVERRUN8.
	ADC_FLAGS_OVERRUN8 = 0x100000
	// Position of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Pos = 0x15
	// Bit mask of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Msk = 0x200000
	// Bit OVERRUN9.
	ADC_FLAGS_OVERRUN9 = 0x200000
	// Position of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Pos = 0x16
	// Bit mask of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Msk = 0x400000
	// Bit OVERRUN10.
	ADC_FLAGS_OVERRUN10 = 0x400000
	// Position of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Pos = 0x17
	// Bit mask of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Msk = 0x800000
	// Bit OVERRUN11.
	ADC_FLAGS_OVERRUN11 = 0x800000
	// Position of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Pos = 0x18
	// Bit mask of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Msk = 0x1000000
	// Bit SEQA_OVR.
	ADC_FLAGS_SEQA_OVR = 0x1000000
	// Position of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Pos = 0x19
	// Bit mask of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Msk = 0x2000000
	// Bit SEQB_OVR.
	ADC_FLAGS_SEQB_OVR = 0x2000000
	// Position of RESERVED field.
	ADC_FLAGS_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ADC_FLAGS_RESERVED_Msk = 0xc000000
	// Position of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Pos = 0x1c
	// Bit mask of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Msk = 0x10000000
	// Bit SEQA_INT.
	ADC_FLAGS_SEQA_INT = 0x10000000
	// Position of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Pos = 0x1d
	// Bit mask of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Msk = 0x20000000
	// Bit SEQB_INT.
	ADC_FLAGS_SEQB_INT = 0x20000000
	// Position of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Pos = 0x1e
	// Bit mask of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Msk = 0x40000000
	// Bit THCMP_INT.
	ADC_FLAGS_THCMP_INT = 0x40000000
	// Position of OVR_INT field.
	ADC_FLAGS_OVR_INT_Pos = 0x1f
	// Bit mask of OVR_INT field.
	ADC_FLAGS_OVR_INT_Msk = 0x80000000
	// Bit OVR_INT.
	ADC_FLAGS_OVR_INT = 0x80000000

	// TRM: ADC trim register.
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0x1f
	// Position of VRANGE field.
	ADC_TRM_VRANGE_Pos = 0x5
	// Bit mask of VRANGE field.
	ADC_TRM_VRANGE_Msk = 0x20
	// Bit VRANGE.
	ADC_TRM_VRANGE = 0x20
	// High voltage. VDDA = 2.7 V to 3.6 V.
	ADC_TRM_VRANGE_HIGH_VOLTAGE = 0x0
	// Low voltage. VDDA = 1.8 V to 2.7 V.
	ADC_TRM_VRANGE_LOW_VOLTAGE = 0x1
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xffffffc0
)

// Constants for RTC: Real-Time Clock (RTC)
const (
	// CTRL: RTC control register
	// Position of SWRESET field.
	RTC_CTRL_SWRESET_Pos = 0x0
	// Bit mask of SWRESET field.
	RTC_CTRL_SWRESET_Msk = 0x1
	// Bit SWRESET.
	RTC_CTRL_SWRESET = 0x1
	// Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any operation of the RTC.
	RTC_CTRL_SWRESET_NOT_IN_RESET = 0x0
	// In reset. The RTC is held in reset. All register bits within the RTC will be forced to their reset value except the OFD bit. This bit must be cleared before writing to any register in the RTC - including writes to set any of the other bits within this register. Do not attempt to write to any bits of this register at the same time that the reset bit is being cleared. This bit may also serve as a Power Fail Detect flag for the always-on voltage domain.
	RTC_CTRL_SWRESET_IN_RESET = 0x1
	// Position of OFD field.
	RTC_CTRL_OFD_Pos = 0x1
	// Bit mask of OFD field.
	RTC_CTRL_OFD_Msk = 0x2
	// Bit OFD.
	RTC_CTRL_OFD = 0x2
	// Run. The RTC oscillator is running properly. Writing a 0 has no effect.
	RTC_CTRL_OFD_RUN = 0x0
	// Fail. RTC oscillator fail detected. Clear this flag after the following power-up. Writing a 1 clears this bit.
	RTC_CTRL_OFD_FAIL = 0x1
	// Position of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Pos = 0x2
	// Bit mask of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Msk = 0x4
	// Bit ALARM1HZ.
	RTC_CTRL_ALARM1HZ = 0x4
	// No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
	RTC_CTRL_ALARM1HZ_NO_MATCH = 0x0
	// Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_ALARM1HZ_MATCH = 0x1
	// Position of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Pos = 0x3
	// Bit mask of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Msk = 0x8
	// Bit WAKE1KHZ.
	RTC_CTRL_WAKE1KHZ = 0x8
	// Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
	RTC_CTRL_WAKE1KHZ_RUN = 0x0
	// Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_WAKE1KHZ_TIME_OUT = 0x1
	// Position of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Pos = 0x4
	// Bit mask of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Msk = 0x10
	// Bit ALARMDPD_EN.
	RTC_CTRL_ALARMDPD_EN = 0x10
	// Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_ENABLE = 0x1
	// Position of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Pos = 0x5
	// Bit mask of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Msk = 0x20
	// Bit WAKEDPD_EN.
	RTC_CTRL_WAKEDPD_EN = 0x20
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_ENABLE = 0x1
	// Position of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Pos = 0x6
	// Bit mask of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Msk = 0x40
	// Bit RTC1KHZ_EN.
	RTC_CTRL_RTC1KHZ_EN = 0x40
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_RTC1KHZ_EN_DISABLE = 0x0
	// Enable. The 1 kHz RTC timer is enabled.
	RTC_CTRL_RTC1KHZ_EN_ENABLE = 0x1
	// Position of RTC_EN field.
	RTC_CTRL_RTC_EN_Pos = 0x7
	// Bit mask of RTC_EN field.
	RTC_CTRL_RTC_EN_Msk = 0x80
	// Bit RTC_EN.
	RTC_CTRL_RTC_EN = 0x80
	// Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should be 0 when writing to load a value in the RTC counter register.
	RTC_CTRL_RTC_EN_DISABLE = 0x0
	// Enable. The 1 Hz RTC clock is running and RTC operation is enabled. You must set this bit to initiate operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the high-resolution, 1 kHz clock, set bit 6 in this register.
	RTC_CTRL_RTC_EN_ENABLE = 0x1
	// Position of RESERVED field.
	RTC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CTRL_RESERVED_Msk = 0xffffff00

	// MATCH: RTC match register
	// Position of MATVAL field.
	RTC_MATCH_MATVAL_Pos = 0x0
	// Bit mask of MATVAL field.
	RTC_MATCH_MATVAL_Msk = 0xffffffff

	// COUNT: RTC counter register
	// Position of VAL field.
	RTC_COUNT_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_COUNT_VAL_Msk = 0xffffffff

	// WAKE: RTC high-resolution/wake-up timer control register
	// Position of VAL field.
	RTC_WAKE_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_WAKE_VAL_Msk = 0xffff
	// Position of RESERVED field.
	RTC_WAKE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RTC_WAKE_RESERVED_Msk = 0xffff0000
)

// Constants for DMATRIGMUX: DMA controller
const (
	// DMA_ITRIG_PINMUX: Trigger input select register for DMA channel 0.
	// Position of INP_N field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_RESERVED_Msk = 0xffffffe0
)

// Constants for PMU: Power Management Unit (PMU)
const (
	// PCON: Power control register
	// Position of PM field.
	PMU_PCON_PM_Pos = 0x0
	// Bit mask of PM field.
	PMU_PCON_PM_Msk = 0x7
	// Default. The part is in active or sleep mode.
	PMU_PCON_PM_DEFAULT = 0x0
	// Deep-sleep. ARM WFI will enter Deep-sleep mode.
	PMU_PCON_PM_DEEP_SLEEP = 0x1
	// Power-down. ARM WFI will enter Power-down mode.
	PMU_PCON_PM_POWER_DOWN = 0x2
	// Deep power-down. ARM WFI will enter Deep-power down mode (ARM Cortex-M0+ core powered-down).
	PMU_PCON_PM_DEEP_POWER_DOWN = 0x3
	// Position of NODPD field.
	PMU_PCON_NODPD_Pos = 0x3
	// Bit mask of NODPD field.
	PMU_PCON_NODPD_Msk = 0x8
	// Bit NODPD.
	PMU_PCON_NODPD = 0x8
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xf0
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Active mode. Read: No power-down mode entered. Part is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_ACTIVE_MODE = 0x0
	// Low power mode. Read: Sleep/Deep-sleep or Deep power-down mode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_LOW_POWER_MODE = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of DPDFLAG field.
	PMU_PCON_DPDFLAG_Pos = 0xb
	// Bit mask of DPDFLAG field.
	PMU_PCON_DPDFLAG_Msk = 0x800
	// Bit DPDFLAG.
	PMU_PCON_DPDFLAG = 0x800
	// Not Deep power-down. Read: Deep power-down mode not entered. Write: No effect.
	PMU_PCON_DPDFLAG_NOT_DEEP_POWER_DOWN = 0x0
	// Deep power-down. Read: Deep power-down mode entered. Write: Clear the Deep power-down flag.
	PMU_PCON_DPDFLAG_DEEP_POWER_DOWN = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000

	// GPREG0: General purpose register 0
	// Position of GPDATA field.
	PMU_GPREG_GPDATA_Pos = 0x0
	// Bit mask of GPDATA field.
	PMU_GPREG_GPDATA_Msk = 0xffffffff

	// GPREG4: Deep power down control register
	// Position of RESERVED field.
	PMU_GPREG4_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PMU_GPREG4_RESERVED_Msk = 0x3ff
	// Position of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Pos = 0xa
	// Bit mask of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Msk = 0x400
	// Bit WAKEUPHYS.
	PMU_GPREG4_WAKEUPHYS = 0x400
	// Disable Hysteresis for WAKUP pin disabled.
	PMU_GPREG4_WAKEUPHYS_DISABLE_HYSTERESIS_F = 0x0
	// Enable. Hysteresis for WAKEUP pin enabled.
	PMU_GPREG4_WAKEUPHYS_ENABLE = 0x1
	// Position of WAKEPAD_DISABLE field.
	PMU_GPREG4_WAKEPAD_DISABLE_Pos = 0xb
	// Bit mask of WAKEPAD_DISABLE field.
	PMU_GPREG4_WAKEPAD_DISABLE_Msk = 0x800
	// Bit WAKEPAD_DISABLE.
	PMU_GPREG4_WAKEPAD_DISABLE = 0x800
	// Enable. The wake-up function is enabled on pin PIO0_16.
	PMU_GPREG4_WAKEPAD_DISABLE_ENABLE = 0x0
	// Disable. Setting this bit disables the wake-up function on pin PIO0_16.
	PMU_GPREG4_WAKEPAD_DISABLE_DISABLE = 0x1
	// Position of GPDATA field.
	PMU_GPREG4_GPDATA_Pos = 0xc
	// Bit mask of GPDATA field.
	PMU_GPREG4_GPDATA_Msk = 0xfffff000
)

// Constants for FLASHCTRL: Flash controller
const (
	// FLASHCFG: Flash configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x0
	// 2 system clocks flash access time (for system clock frequencies of up to 30 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Msk = 0x1ffff
	// Position of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Pos = 0x11
	// Bit mask of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Msk = 0x20000
	// Bit STRTBIST.
	FLASHCTRL_FMSSTOP_STRTBIST = 0x20000
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: Signature Word
	// Position of SIG field.
	FLASHCTRL_FMSW0_SIG_Pos = 0x0
	// Bit mask of SIG field.
	FLASHCTRL_FMSW0_SIG_Msk = 0xffffffff
)

// Constants for SSP0: SSP/SPI
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP0_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP0_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP0_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP0_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP0_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP0_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP0_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP0_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP0_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP0_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP0_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP0_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP0_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP0_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP0_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP0_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP0_CR0_FRF_Msk = 0x30
	// SPI
	SSP0_CR0_FRF_SPI = 0x0
	// TI
	SSP0_CR0_FRF_TI = 0x1
	// Microwire
	SSP0_CR0_FRF_MICROWIRE = 0x2
	// Position of CPOL field.
	SSP0_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP0_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP0_CR0_CPOL = 0x40
	// SPI controller maintains the bus clock low between frames.
	SSP0_CR0_CPOL_LOW = 0x0
	// SPI controller maintains the bus clock high between frames.
	SSP0_CR0_CPOL_HIGH = 0x1
	// Position of CPHA field.
	SSP0_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP0_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP0_CR0_CPHA = 0x80
	// SPI controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP0_CR0_CPHA_FIRSTCLOCK = 0x0
	// SPI controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP0_CR0_CPHA_SECONDCLOCK = 0x1
	// Position of SCR field.
	SSP0_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP0_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP0_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP0_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP0_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP0_CR1_LBM = 0x1
	// During normal operation.
	SSP0_CR1_LBM_DURING_NORMAL_OPERAT = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP0_CR1_LBM_SERIAL_INPUT_IS_TAKE = 0x1
	// Position of SSE field.
	SSP0_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP0_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP0_CR1_SSE = 0x2
	// The SPI controller is disabled.
	SSP0_CR1_SSE_DISABLED = 0x0
	// The SPI controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP/SPI registers and interrupt controller registers, before setting this bit.
	SSP0_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP0_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP0_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP0_CR1_MS = 0x4
	// The SPI controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP0_CR1_MS_MASTER = 0x0
	// The SPI controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP0_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP0_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP0_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP0_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP0_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP0_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP0_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP0_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP0_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP0_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP0_SR_TFE = 0x1
	// Position of TNF field.
	SSP0_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP0_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP0_SR_TNF = 0x2
	// Position of RNE field.
	SSP0_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP0_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP0_SR_RNE = 0x4
	// Position of RFF field.
	SSP0_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP0_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP0_SR_RFF = 0x8
	// Position of BSY field.
	SSP0_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP0_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP0_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP0_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP0_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP0_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP0_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP0_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP0_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP0_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP0_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP0_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP0_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP0_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP0_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP0_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP0_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP0_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP0_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP0_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP0_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP0_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP0_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP0_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP0_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP0_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP0_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP0_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP0_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP0_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP0_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP0_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP0_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP0_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP0_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP0_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP0_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP0_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP0_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP0_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP0_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP0_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP0_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP0_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP0_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP0_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP0_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP0_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP0_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP0_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP0_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP0_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP0_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP0_ICR_RESERVED_Msk = 0xfffffffc
)

// Constants for IOCON: I/O control (IOCON)
const (
	// PIO0_0: I/O configuration for port PIO0
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Enable. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_ENABLE = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_4: I/O configuration for open-drain pin PIO0_4
	// Position of FUNC field.
	IOCON_PIO0_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_4_FUNC_Msk = 0x7
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_4_I2CMODE_STANDARD_MODE_FAST = 0x0
	// Standard I/O functionality
	IOCON_PIO0_4_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_4_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xfffffc00

	// PIO0_5: I/O configuration for open-drain pin PIO0_5
	// Position of FUNC field.
	IOCON_PIO0_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_5_FUNC_Msk = 0x7
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_5_I2CMODE_STANDARD_MODE_FAST = 0x0
	// Standard I/O functionality
	IOCON_PIO0_5_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_5_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xfffffc00

	// PIO0_6: I/O configuration for port PIO0
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Enable. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_ENABLE = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO1_0: I/O configuration for port PIO1
	// Position of FUNC field.
	IOCON_PIO1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_HYS = 0x20
	// Disable.
	IOCON_PIO1_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO1_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO1_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Disable.
	IOCON_PIO1_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO1_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO1_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO1_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO1_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO1_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO1_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO1_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO1_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xffff0000

	// PIO2_0: I/O configuration for port PIO2
	// Position of FUNC field.
	IOCON_PIO2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO2_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO2_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO2_HYS = 0x20
	// Disable.
	IOCON_PIO2_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO2_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO2_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO2_OD = 0x400
	// Disable.
	IOCON_PIO2_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO2_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO2_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO2_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO2_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO2_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO2_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO2_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0xffff0000

	// PIO2_2: I/O configuration for port PIO2
	// Position of FUNC field.
	IOCON_PIO2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO2_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO2_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO2_HYS = 0x20
	// Disable.
	IOCON_PIO2_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO2_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO2_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO2_OD = 0x400
	// Disable.
	IOCON_PIO2_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO2_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO2_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO2_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO2_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO2_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO2_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO2_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0xffff0000
)

// Constants for SYSCON: System configuration (SYSCON)
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Pos = 0x0
	// Bit mask of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Msk = 0x1
	// Bit SSP0_RST_N.
	SYSCON_PRESETCTRL_SSP0_RST_N = 0x1
	// Reset. Resets the SSP0 peripheral.
	SYSCON_PRESETCTRL_SSP0_RST_N_RESET = 0x0
	// Clear reset. SSP0 reset de-asserted.
	SYSCON_PRESETCTRL_SSP0_RST_N_CLEAR_RESET = 0x1
	// Position of I2C0_RST_N field.
	SYSCON_PRESETCTRL_I2C0_RST_N_Pos = 0x1
	// Bit mask of I2C0_RST_N field.
	SYSCON_PRESETCTRL_I2C0_RST_N_Msk = 0x2
	// Bit I2C0_RST_N.
	SYSCON_PRESETCTRL_I2C0_RST_N = 0x2
	// Reset. Resets the I2C0 peripheral.
	SYSCON_PRESETCTRL_I2C0_RST_N_RESET = 0x0
	// Clear reset. I2C0 reset de-asserted.
	SYSCON_PRESETCTRL_I2C0_RST_N_CLEAR_RESET = 0x1
	// Position of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Pos = 0x2
	// Bit mask of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Msk = 0x4
	// Bit SSP1_RST_N.
	SYSCON_PRESETCTRL_SSP1_RST_N = 0x4
	// Reset. Resets the SSP1 peripheral.
	SYSCON_PRESETCTRL_SSP1_RST_N_RESET = 0x0
	// Clear reset. SSP1 reset de-asserted.
	SYSCON_PRESETCTRL_SSP1_RST_N_CLEAR_RESET = 0x1
	// Position of I2C1_RST_N field.
	SYSCON_PRESETCTRL_I2C1_RST_N_Pos = 0x3
	// Bit mask of I2C1_RST_N field.
	SYSCON_PRESETCTRL_I2C1_RST_N_Msk = 0x8
	// Bit I2C1_RST_N.
	SYSCON_PRESETCTRL_I2C1_RST_N = 0x8
	// Reset. Resets the I2C1 peripheral.
	SYSCON_PRESETCTRL_I2C1_RST_N_RESET = 0x0
	// Clear reset. I2C1 reset de-asserted.
	SYSCON_PRESETCTRL_I2C1_RST_N_CLEAR_RESET = 0x1
	// Position of FRG_RST_N field.
	SYSCON_PRESETCTRL_FRG_RST_N_Pos = 0x4
	// Bit mask of FRG_RST_N field.
	SYSCON_PRESETCTRL_FRG_RST_N_Msk = 0x10
	// Bit FRG_RST_N.
	SYSCON_PRESETCTRL_FRG_RST_N = 0x10
	// Reset. Resets the FRG peripheral.
	SYSCON_PRESETCTRL_FRG_RST_N_RESET = 0x0
	// Clear reset. FRG reset de-asserted.
	SYSCON_PRESETCTRL_FRG_RST_N_CLEAR_RESET = 0x1
	// Position of USART1_RST_N field.
	SYSCON_PRESETCTRL_USART1_RST_N_Pos = 0x5
	// Bit mask of USART1_RST_N field.
	SYSCON_PRESETCTRL_USART1_RST_N_Msk = 0x20
	// Bit USART1_RST_N.
	SYSCON_PRESETCTRL_USART1_RST_N = 0x20
	// Reset. Resets the USART1 peripheral.
	SYSCON_PRESETCTRL_USART1_RST_N_RESET = 0x0
	// Clear reset. USART1 reset de-asserted.
	SYSCON_PRESETCTRL_USART1_RST_N_CLEAR_RESET = 0x1
	// Position of USART2_RST_N field.
	SYSCON_PRESETCTRL_USART2_RST_N_Pos = 0x6
	// Bit mask of USART2_RST_N field.
	SYSCON_PRESETCTRL_USART2_RST_N_Msk = 0x40
	// Bit USART2_RST_N.
	SYSCON_PRESETCTRL_USART2_RST_N = 0x40
	// Reset. Resets the USART2 peripheral.
	SYSCON_PRESETCTRL_USART2_RST_N_RESET = 0x0
	// Clear reset. USART2 reset de-asserted.
	SYSCON_PRESETCTRL_USART2_RST_N_CLEAR_RESET = 0x1
	// Position of USART3_RST_N field.
	SYSCON_PRESETCTRL_USART3_RST_N_Pos = 0x7
	// Bit mask of USART3_RST_N field.
	SYSCON_PRESETCTRL_USART3_RST_N_Msk = 0x80
	// Bit USART3_RST_N.
	SYSCON_PRESETCTRL_USART3_RST_N = 0x80
	// Reset. Resets the USART3 peripheral.
	SYSCON_PRESETCTRL_USART3_RST_N_RESET = 0x0
	// Clear reset. USART3 reset de-asserted.
	SYSCON_PRESETCTRL_USART3_RST_N_CLEAR_RESET = 0x1
	// Position of USART4_RST_N field.
	SYSCON_PRESETCTRL_USART4_RST_N_Pos = 0x8
	// Bit mask of USART4_RST_N field.
	SYSCON_PRESETCTRL_USART4_RST_N_Msk = 0x100
	// Bit USART4_RST_N.
	SYSCON_PRESETCTRL_USART4_RST_N = 0x100
	// Reset. Resets the USART4 peripheral.
	SYSCON_PRESETCTRL_USART4_RST_N_RESET = 0x0
	// Clear reset. USART4 reset de-asserted.
	SYSCON_PRESETCTRL_USART4_RST_N_CLEAR_RESET = 0x1
	// Position of SCT0_RST_N field.
	SYSCON_PRESETCTRL_SCT0_RST_N_Pos = 0x9
	// Bit mask of SCT0_RST_N field.
	SYSCON_PRESETCTRL_SCT0_RST_N_Msk = 0x200
	// Bit SCT0_RST_N.
	SYSCON_PRESETCTRL_SCT0_RST_N = 0x200
	// Reset. Resets the SCT0 peripheral.
	SYSCON_PRESETCTRL_SCT0_RST_N_RESET = 0x0
	// Clear reset. SCT0 reset de-asserted.
	SYSCON_PRESETCTRL_SCT0_RST_N_CLEAR_RESET = 0x1
	// Position of SCT1_RST_N field.
	SYSCON_PRESETCTRL_SCT1_RST_N_Pos = 0xa
	// Bit mask of SCT1_RST_N field.
	SYSCON_PRESETCTRL_SCT1_RST_N_Msk = 0x400
	// Bit SCT1_RST_N.
	SYSCON_PRESETCTRL_SCT1_RST_N = 0x400
	// Reset. Resets the SCT1 peripheral.
	SYSCON_PRESETCTRL_SCT1_RST_N_RESET = 0x0
	// Clear reset. SCT1 reset de-asserted.
	SYSCON_PRESETCTRL_SCT1_RST_N_CLEAR_RESET = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffff800

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// No lock. PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_NO_LOCK = 0x0
	// Lock. PLL locked
	SYSCON_SYSPLLSTAT_LOCK_LOCK = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// RTCOSCCTRL: RTC oscillator 32 kHz output control
	// Position of RTCOSCEN field.
	SYSCON_RTCOSCCTRL_RTCOSCEN_Pos = 0x0
	// Bit mask of RTCOSCEN field.
	SYSCON_RTCOSCCTRL_RTCOSCEN_Msk = 0x1
	// Bit RTCOSCEN.
	SYSCON_RTCOSCCTRL_RTCOSCEN = 0x1
	// Disabled. 32 kHz output disabled.
	SYSCON_RTCOSCCTRL_RTCOSCEN_DISABLED = 0x0
	// Enabled. 32 kHz output enabled.
	SYSCON_RTCOSCCTRL_RTCOSCEN_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_OSCILLATOR_IS_NOT_BY = 0x0
	// Bypass enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_BYPASS_ENABLED = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// Low. 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_LOW = 0x0
	// High. 15 - 25 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_HIGH = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0 = 0x1
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// IRCCTRL: IRC control
	// Position of TRIM field.
	SYSCON_IRCCTRL_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	SYSCON_IRCCTRL_TRIM_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Msk = 0xffffff00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// System oscillator. Crystal Oscillator (SYSOSC)
	SYSCON_SYSPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// 32 kHz clock.Select this option when the 32 kHz clock is the clock source for the main clock and select the pll input in the MAINCLKSEL register. Do not use the 32 kHz clock with the PLL.
	SYSCON_SYSPLLCLKSEL_SEL_32_KHZ_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// PLL input
	SYSCON_MAINCLKSEL_SEL_PLL_INPUT = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// PLL output
	SYSCON_MAINCLKSEL_SEL_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Pos = 0x2
	// Bit mask of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Msk = 0x4
	// Bit RAM0.
	SYSCON_SYSAHBCLKCTRL_RAM0 = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM0_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLED = 0x1
	// Position of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Pos = 0x4
	// Bit mask of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Msk = 0x10
	// Bit FLASHARRAY.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY = 0x10
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_ENABLED = 0x1
	// Position of I2C0 field.
	SYSCON_SYSAHBCLKCTRL_I2C0_Pos = 0x5
	// Bit mask of I2C0 field.
	SYSCON_SYSAHBCLKCTRL_I2C0_Msk = 0x20
	// Bit I2C0.
	SYSCON_SYSAHBCLKCTRL_I2C0 = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C0_ENABLE = 0x1
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Pos = 0x7
	// Bit mask of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Msk = 0x80
	// Bit CT16B0.
	SYSCON_SYSAHBCLKCTRL_CT16B0 = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B0_ENABLE = 0x1
	// Position of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Pos = 0x8
	// Bit mask of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Msk = 0x100
	// Bit CT16B1.
	SYSCON_SYSAHBCLKCTRL_CT16B1 = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B1_ENABLE = 0x1
	// Position of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Pos = 0x9
	// Bit mask of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Msk = 0x200
	// Bit CT32B0.
	SYSCON_SYSAHBCLKCTRL_CT32B0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B0_ENABLE = 0x1
	// Position of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Pos = 0xa
	// Bit mask of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Msk = 0x400
	// Bit CT32B1.
	SYSCON_SYSAHBCLKCTRL_CT32B1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B1_ENABLE = 0x1
	// Position of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Pos = 0xb
	// Bit mask of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Msk = 0x800
	// Bit SSP0.
	SYSCON_SYSAHBCLKCTRL_SSP0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP0_ENABLE = 0x1
	// Position of USART0 field.
	SYSCON_SYSAHBCLKCTRL_USART0_Pos = 0xc
	// Bit mask of USART0 field.
	SYSCON_SYSAHBCLKCTRL_USART0_Msk = 0x1000
	// Bit USART0.
	SYSCON_SYSAHBCLKCTRL_USART0 = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART0_ENABLE = 0x1
	// Position of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Pos = 0xd
	// Bit mask of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Msk = 0x2000
	// Bit ADC.
	SYSCON_SYSAHBCLKCTRL_ADC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ADC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ADC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x4000
	// Position of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Pos = 0xf
	// Bit mask of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Msk = 0x8000
	// Bit WWDT.
	SYSCON_SYSAHBCLKCTRL_WWDT = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WWDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WWDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x10
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x10000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x20000
	// Position of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Pos = 0x12
	// Bit mask of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Msk = 0x40000
	// Bit SSP1.
	SYSCON_SYSAHBCLKCTRL_SSP1 = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP1_ENABLE = 0x1
	// Position of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Pos = 0x13
	// Bit mask of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Msk = 0x80000
	// Bit PINT.
	SYSCON_SYSAHBCLKCTRL_PINT = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL_PINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_PINT_ENABLE = 0x1
	// Position of USART1 field.
	SYSCON_SYSAHBCLKCTRL_USART1_Pos = 0x14
	// Bit mask of USART1 field.
	SYSCON_SYSAHBCLKCTRL_USART1_Msk = 0x100000
	// Bit USART1.
	SYSCON_SYSAHBCLKCTRL_USART1 = 0x100000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART1_ENABLE = 0x1
	// Position of USART2 field.
	SYSCON_SYSAHBCLKCTRL_USART2_Pos = 0x15
	// Bit mask of USART2 field.
	SYSCON_SYSAHBCLKCTRL_USART2_Msk = 0x200000
	// Bit USART2.
	SYSCON_SYSAHBCLKCTRL_USART2 = 0x200000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART2_ENABLE = 0x1
	// Position of USART3_4 field.
	SYSCON_SYSAHBCLKCTRL_USART3_4_Pos = 0x16
	// Bit mask of USART3_4 field.
	SYSCON_SYSAHBCLKCTRL_USART3_4_Msk = 0x400000
	// Bit USART3_4.
	SYSCON_SYSAHBCLKCTRL_USART3_4 = 0x400000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART3_4_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART3_4_ENABLE = 0x1
	// Position of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Pos = 0x17
	// Bit mask of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Msk = 0x800000
	// Bit GROUP0INT.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_ENABLE = 0x1
	// Position of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Pos = 0x18
	// Bit mask of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Msk = 0x1000000
	// Bit GROUP1INT.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT = 0x1000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_ENABLE = 0x1
	// Position of I2C1 field.
	SYSCON_SYSAHBCLKCTRL_I2C1_Pos = 0x19
	// Bit mask of I2C1 field.
	SYSCON_SYSAHBCLKCTRL_I2C1_Msk = 0x2000000
	// Bit I2C1.
	SYSCON_SYSAHBCLKCTRL_I2C1 = 0x2000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C1_ENABLE = 0x1
	// Position of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Pos = 0x1a
	// Bit mask of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Msk = 0x4000000
	// Bit RAM1.
	SYSCON_SYSAHBCLKCTRL_RAM1 = 0x4000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM1_ENABLE = 0x1
	// Position of USBSRAM field.
	SYSCON_SYSAHBCLKCTRL_USBSRAM_Pos = 0x1b
	// Bit mask of USBSRAM field.
	SYSCON_SYSAHBCLKCTRL_USBSRAM_Msk = 0x8000000
	// Bit USBSRAM.
	SYSCON_SYSAHBCLKCTRL_USBSRAM = 0x8000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USBSRAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USBSRAM_ENABLE = 0x1
	// Position of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Pos = 0x1c
	// Bit mask of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Msk = 0x10000000
	// Bit CRC.
	SYSCON_SYSAHBCLKCTRL_CRC = 0x10000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_CRC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CRC_ENABLE = 0x1
	// Position of DMA field.
	SYSCON_SYSAHBCLKCTRL_DMA_Pos = 0x1d
	// Bit mask of DMA field.
	SYSCON_SYSAHBCLKCTRL_DMA_Msk = 0x20000000
	// Bit DMA.
	SYSCON_SYSAHBCLKCTRL_DMA = 0x20000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_DMA_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_DMA_ENABLE = 0x1
	// Position of RTC field.
	SYSCON_SYSAHBCLKCTRL_RTC_Pos = 0x1e
	// Bit mask of RTC field.
	SYSCON_SYSAHBCLKCTRL_RTC_Msk = 0x40000000
	// Bit RTC.
	SYSCON_SYSAHBCLKCTRL_RTC = 0x40000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_RTC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RTC_ENABLE = 0x1
	// Position of SCT0_1 field.
	SYSCON_SYSAHBCLKCTRL_SCT0_1_Pos = 0x1f
	// Bit mask of SCT0_1 field.
	SYSCON_SYSAHBCLKCTRL_SCT0_1_Msk = 0x80000000
	// Bit SCT0_1.
	SYSCON_SYSAHBCLKCTRL_SCT0_1 = 0x80000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SCT0_1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SCT0_1_ENABLE = 0x1

	// SSP0CLKDIV: SSP0 clock divider
	// Position of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Msk = 0xffffff00

	// USART0CLKDIV: USART0 clock divider
	// Position of DIV field.
	SYSCON_USART0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_USART0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_USART0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_USART0CLKDIV_RESERVED_Msk = 0xffffff00

	// SSP1CLKDIV: SSP1 clock divider
	// Position of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Msk = 0xffffff00

	// FRGCLKDIV: Clock divider for the common fractional baud rate generator of USART1, USART2, USART3, USART4
	// Position of DIV field.
	SYSCON_FRGCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_FRGCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_FRGCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_FRGCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSEL_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (SYSOSC)
	SYSCON_CLKOUTSEL_SEL_CRYSTAL_OSCILLATOR = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGDIV: USART fractional generator divider value
	// Position of DIV field.
	SYSCON_UARTFRGDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTFRGDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGMULT: USART fractional generator multiplier value
	// Position of MULT field.
	SYSCON_UARTFRGMULT_MULT_Pos = 0x0
	// Bit mask of MULT field.
	SYSCON_UARTFRGMULT_MULT_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Msk = 0xffffff00

	// EXTTRACECMD: External trace buffer command register
	// Position of START field.
	SYSCON_EXTTRACECMD_START_Pos = 0x0
	// Bit mask of START field.
	SYSCON_EXTTRACECMD_START_Msk = 0x1
	// Bit START.
	SYSCON_EXTTRACECMD_START = 0x1
	// Position of STOP field.
	SYSCON_EXTTRACECMD_STOP_Pos = 0x1
	// Bit mask of STOP field.
	SYSCON_EXTTRACECMD_STOP_Msk = 0x2
	// Bit STOP.
	SYSCON_EXTTRACECMD_STOP = 0x2
	// Position of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Msk = 0xfffffffc

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0xffffff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xff000000

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Msk = 0xffffffff

	// PIOPORCAP2: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Msk = 0xffffff

	// IOCONCLKDIV6: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV5: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV4: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV3: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV2: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV1: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV0: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Msk = 0xffffff00

	// BODCTRL: Brown-Out Detect
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0 = 0x0
	// Level 1.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1 = 0x1
	// Level 2.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2 = 0x2
	// Level 3.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3 = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 2.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2 = 0x2
	// Level 3.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3 = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// IRQLATENCY: IRQ delay. Allows trade-off between interrupt latency and determinism.
	// Position of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Msk = 0xffffff00

	// NMISRC: NMI Source Control
	// Position of IRQN field.
	SYSCON_NMISRC_IRQN_Pos = 0x0
	// Bit mask of IRQN field.
	SYSCON_NMISRC_IRQN_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// PINTSEL0: GPIO Pin Interrupt Select register 0
	// Position of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Msk = 0x3f
	// Position of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Msk = 0xffffffc0

	// STARTERP0: Start logic 0 interrupt wake-up enable register 0
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x0
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x1
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x1
	// Disabled
	SYSCON_STARTERP0_PINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT0_ENABLED = 0x1
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x1
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x2
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x2
	// Disabled
	SYSCON_STARTERP0_PINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT1_ENABLED = 0x1
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x2
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x4
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x4
	// Disabled
	SYSCON_STARTERP0_PINT2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT2_ENABLED = 0x1
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0x3
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x8
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x8
	// Disabled
	SYSCON_STARTERP0_PINT3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT3_ENABLED = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP0_PINT4_Pos = 0x4
	// Bit mask of PINT4 field.
	SYSCON_STARTERP0_PINT4_Msk = 0x10
	// Bit PINT4.
	SYSCON_STARTERP0_PINT4 = 0x10
	// Disabled
	SYSCON_STARTERP0_PINT4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT4_ENABLED = 0x1
	// Position of PINT5 field.
	SYSCON_STARTERP0_PINT5_Pos = 0x5
	// Bit mask of PINT5 field.
	SYSCON_STARTERP0_PINT5_Msk = 0x20
	// Bit PINT5.
	SYSCON_STARTERP0_PINT5 = 0x20
	// Disabled
	SYSCON_STARTERP0_PINT5_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT5_ENABLED = 0x1
	// Position of PINT6 field.
	SYSCON_STARTERP0_PINT6_Pos = 0x6
	// Bit mask of PINT6 field.
	SYSCON_STARTERP0_PINT6_Msk = 0x40
	// Bit PINT6.
	SYSCON_STARTERP0_PINT6 = 0x40
	// Disabled
	SYSCON_STARTERP0_PINT6_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT6_ENABLED = 0x1
	// Position of PINT7 field.
	SYSCON_STARTERP0_PINT7_Pos = 0x7
	// Bit mask of PINT7 field.
	SYSCON_STARTERP0_PINT7_Msk = 0x80
	// Bit PINT7.
	SYSCON_STARTERP0_PINT7 = 0x80
	// Disabled
	SYSCON_STARTERP0_PINT7_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT7_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xffffff00

	// STARTERP1: Start logic 1 interrupt wake-up enable register 1
	// Position of RTCINT field.
	SYSCON_STARTERP1_RTCINT_Pos = 0xc
	// Bit mask of RTCINT field.
	SYSCON_STARTERP1_RTCINT_Msk = 0x1000
	// Bit RTCINT.
	SYSCON_STARTERP1_RTCINT = 0x1000
	// Disabled
	SYSCON_STARTERP1_RTCINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_RTCINT_ENABLED = 0x1
	// Position of WWDT_BODINT field.
	SYSCON_STARTERP1_WWDT_BODINT_Pos = 0xd
	// Bit mask of WWDT_BODINT field.
	SYSCON_STARTERP1_WWDT_BODINT_Msk = 0x2000
	// Bit WWDT_BODINT.
	SYSCON_STARTERP1_WWDT_BODINT = 0x2000
	// Disabled
	SYSCON_STARTERP1_WWDT_BODINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_WWDT_BODINT_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x7c000
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x80000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x80000
	// Position of GROUP0INT field.
	SYSCON_STARTERP1_GROUP0INT_Pos = 0x14
	// Bit mask of GROUP0INT field.
	SYSCON_STARTERP1_GROUP0INT_Msk = 0x100000
	// Bit GROUP0INT.
	SYSCON_STARTERP1_GROUP0INT = 0x100000
	// Disabled
	SYSCON_STARTERP1_GROUP0INT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GROUP0INT_ENABLED = 0x1
	// Position of GROUP1INT field.
	SYSCON_STARTERP1_GROUP1INT_Pos = 0x15
	// Bit mask of GROUP1INT field.
	SYSCON_STARTERP1_GROUP1INT_Msk = 0x200000
	// Bit GROUP1INT.
	SYSCON_STARTERP1_GROUP1INT = 0x200000
	// Disabled
	SYSCON_STARTERP1_GROUP1INT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GROUP1INT_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x400000
	// Position of USART1_4 field.
	SYSCON_STARTERP1_USART1_4_Pos = 0x17
	// Bit mask of USART1_4 field.
	SYSCON_STARTERP1_USART1_4_Msk = 0x800000
	// Bit USART1_4.
	SYSCON_STARTERP1_USART1_4 = 0x800000
	// Disabled
	SYSCON_STARTERP1_USART1_4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_USART1_4_ENABLED = 0x1
	// Position of USART2_3 field.
	SYSCON_STARTERP1_USART2_3_Pos = 0x18
	// Bit mask of USART2_3 field.
	SYSCON_STARTERP1_USART2_3_Msk = 0x1000000
	// Bit USART2_3.
	SYSCON_STARTERP1_USART2_3 = 0x1000000
	// Disabled
	SYSCON_STARTERP1_USART2_3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_USART2_3_ENABLED = 0x1

	// PDSLEEPCFG: Power-down states in deep-sleep mode
	// Position of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDSLEEPCFG_BOD_PD = 0x8
	// Powered down
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x30
	// Position of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDSLEEPCFG_WDTOSC_PD = 0x40
	// Powered down
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xffffff80

	// PDAWAKECFG: Power-down states for wake-up from deep-sleep
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x1
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Position of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDAWAKECFG_IRC_PD = 0x2
	// Powered down
	SYSCON_PDAWAKECFG_IRC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRC_PD_POWERED = 0x0
	// Position of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDAWAKECFG_FLASH_PD = 0x4
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED = 0x0
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x8
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Position of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDAWAKECFG_ADC_PD = 0x10
	// Powered down
	SYSCON_PDAWAKECFG_ADC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_ADC_PD_POWERED = 0x0
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x20
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x40
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x80
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x1000
	// Position of TEMPSENSE_PD field.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_Pos = 0xd
	// Bit mask of TEMPSENSE_PD field.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_Msk = 0x2000
	// Bit TEMPSENSE_PD.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD = 0x2000
	// Powered
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xffffc000

	// PDRUNCFG: Power configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDRUNCFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDRUNCFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x1000
	// Position of TEMPSENSE_PD field.
	SYSCON_PDRUNCFG_TEMPSENSE_PD_Pos = 0xd
	// Bit mask of TEMPSENSE_PD field.
	SYSCON_PDRUNCFG_TEMPSENSE_PD_Msk = 0x2000
	// Bit TEMPSENSE_PD.
	SYSCON_PDRUNCFG_TEMPSENSE_PD = 0x2000
	// Powered
	SYSCON_PDRUNCFG_TEMPSENSE_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_TEMPSENSE_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xc000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xffff0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Constants for USART4: USART4
const (
	// CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
	// Position of ENABLE field.
	USART4_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USART4_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USART4_CFG_ENABLE = 0x1
	// Disabled. The USART is disabled and the internal state machine and counters are reset. While Enable = 0, all USART interrupts and DMA transfers are disabled. When Enable is set again, CFG and most other control bits remain unchanged. For instance, when re-enabled, the USART will immediately generate a TxRdy interrupt (if enabled in the INTENSET register) or a DMA transfer request because the transmitter has been reset and is therefore available.
	USART4_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The USART is enabled for operation.
	USART4_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x2
	// Position of DATALEN field.
	USART4_CFG_DATALEN_Pos = 0x2
	// Bit mask of DATALEN field.
	USART4_CFG_DATALEN_Msk = 0xc
	// 7 bit Data length.
	USART4_CFG_DATALEN_7_BIT_DATA_LENGTH = 0x0
	// 8 bit Data length.
	USART4_CFG_DATALEN_8_BIT_DATA_LENGTH = 0x1
	// 9 bit data length. The 9th bit is commonly used for addressing in multidrop mode. See the ADDRDET bit in the CTL register.
	USART4_CFG_DATALEN_9_BIT_DATA_LENGTH = 0x2
	// Position of PARITYSEL field.
	USART4_CFG_PARITYSEL_Pos = 0x4
	// Bit mask of PARITYSEL field.
	USART4_CFG_PARITYSEL_Msk = 0x30
	// No parity.
	USART4_CFG_PARITYSEL_NO_PARITY = 0x0
	// Even parity. Adds a bit to each character such that the number of 1s in a transmitted character is even, and the number of 1s in a received character is expected to be even.
	USART4_CFG_PARITYSEL_EVEN_PARITY = 0x2
	// Odd parity. Adds a bit to each character such that the number of 1s in a transmitted character is odd, and the number of 1s in a received character is expected to be odd.
	USART4_CFG_PARITYSEL_ODD_PARITY = 0x3
	// Position of STOPLEN field.
	USART4_CFG_STOPLEN_Pos = 0x6
	// Bit mask of STOPLEN field.
	USART4_CFG_STOPLEN_Msk = 0x40
	// Bit STOPLEN.
	USART4_CFG_STOPLEN = 0x40
	// 1 stop bit.
	USART4_CFG_STOPLEN_1_STOP_BIT = 0x0
	// 2 stop bits. This setting should only be used for asynchronous communication.
	USART4_CFG_STOPLEN_2_STOP_BITS = 0x1
	// Position of MODE32K field.
	USART4_CFG_MODE32K_Pos = 0x7
	// Bit mask of MODE32K field.
	USART4_CFG_MODE32K_Msk = 0x80
	// Bit MODE32K.
	USART4_CFG_MODE32K = 0x80
	// UART uses standard clocking.
	USART4_CFG_MODE32K_STANDARD = 0x0
	// UART uses the 32 kHz clock from the RTC oscillator as the clock source to the BRG, and uses a special bit clocking scheme.
	USART4_CFG_MODE32K_32KHZ = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x100
	// Position of CTSEN field.
	USART4_CFG_CTSEN_Pos = 0x9
	// Bit mask of CTSEN field.
	USART4_CFG_CTSEN_Msk = 0x200
	// Bit CTSEN.
	USART4_CFG_CTSEN = 0x200
	// No flow control. The transmitter does not receive any automatic flow control signal.
	USART4_CFG_CTSEN_NO_FLOW_CONTROL = 0x0
	// Flow control enabled. The transmitter uses the CTS input (or RTS output in loopback mode) for flow control purposes.
	USART4_CFG_CTSEN_FLOW_CONTROL_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x400
	// Position of SYNCEN field.
	USART4_CFG_SYNCEN_Pos = 0xb
	// Bit mask of SYNCEN field.
	USART4_CFG_SYNCEN_Msk = 0x800
	// Bit SYNCEN.
	USART4_CFG_SYNCEN = 0x800
	// Asynchronous mode is selected.
	USART4_CFG_SYNCEN_ASYNCHRONOUS = 0x0
	// Synchronous mode is selected.
	USART4_CFG_SYNCEN_SYNCHRONOUS = 0x1
	// Position of CLKPOL field.
	USART4_CFG_CLKPOL_Pos = 0xc
	// Bit mask of CLKPOL field.
	USART4_CFG_CLKPOL_Msk = 0x1000
	// Bit CLKPOL.
	USART4_CFG_CLKPOL = 0x1000
	// Falling edge. Un_RXD is sampled on the falling edge of SCLK.
	USART4_CFG_CLKPOL_FALLING_EDGE = 0x0
	// Rising edge. Un_RXD is sampled on the rising edge of SCLK.
	USART4_CFG_CLKPOL_RISING_EDGE = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x2000
	// Position of SYNCMST field.
	USART4_CFG_SYNCMST_Pos = 0xe
	// Bit mask of SYNCMST field.
	USART4_CFG_SYNCMST_Msk = 0x4000
	// Bit SYNCMST.
	USART4_CFG_SYNCMST = 0x4000
	// Slave. When synchronous mode is enabled, the USART is a slave.
	USART4_CFG_SYNCMST_SLAVE = 0x0
	// Master. When synchronous mode is enabled, the USART is a master.
	USART4_CFG_SYNCMST_MASTER = 0x1
	// Position of LOOP field.
	USART4_CFG_LOOP_Pos = 0xf
	// Bit mask of LOOP field.
	USART4_CFG_LOOP_Msk = 0x8000
	// Bit LOOP.
	USART4_CFG_LOOP = 0x8000
	// Normal operation.
	USART4_CFG_LOOP_NORMAL_OPERATION = 0x0
	// Loopback mode. This provides a mechanism to perform diagnostic loopback testing for USART data. Serial data from the transmitter (Un_TXD) is connected internally to serial input of the receive (Un_RXD). Un_TXD and Un_RTS activity will also appear on external pins if these functions are configured to appear on device pins. The receiver RTS signal is also looped back to CTS and performs flow control if enabled by CTSEN.
	USART4_CFG_LOOP_LOOPBACK_MODE = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x30000
	// Position of OETA field.
	USART4_CFG_OETA_Pos = 0x12
	// Bit mask of OETA field.
	USART4_CFG_OETA_Msk = 0x40000
	// Bit OETA.
	USART4_CFG_OETA = 0x40000
	// Deasserted. If selected by OESEL, the Output Enable signal deasserted at the end of the last stop bit of a transmission.
	USART4_CFG_OETA_DEASSERTED = 0x0
	// Asserted. If selected by OESEL, the Output Enable signal remains asserted for 1 character time after then end the last stop bit of a transmission. OE will also remain asserted if another transmit begins before it is deasserted.
	USART4_CFG_OETA_ASSERTED = 0x1
	// Position of AUTOADDR field.
	USART4_CFG_AUTOADDR_Pos = 0x13
	// Bit mask of AUTOADDR field.
	USART4_CFG_AUTOADDR_Msk = 0x80000
	// Bit AUTOADDR.
	USART4_CFG_AUTOADDR = 0x80000
	// Disabled. When addressing is enabled by ADDRDET, address matching is done by software. This provides the possibility of versatile addressing (e.g. respond to more than one address).
	USART4_CFG_AUTOADDR_DISABLED = 0x0
	// Enabled. When addressing is enabled by ADDRDET, address matching is done by hardware, using the value in the ADDR register as the address to match.
	USART4_CFG_AUTOADDR_ENABLED = 0x1
	// Position of OESEL field.
	USART4_CFG_OESEL_Pos = 0x14
	// Bit mask of OESEL field.
	USART4_CFG_OESEL_Msk = 0x100000
	// Bit OESEL.
	USART4_CFG_OESEL = 0x100000
	// Flow control. The RTS signal is used as the standard flow control function.
	USART4_CFG_OESEL_FLOW_CONTROL = 0x0
	// Output enable. The RTS signal is taken over in order to provide an output enable signal to control an RS-485 transceiver.
	USART4_CFG_OESEL_OUTPUT_ENABLE = 0x1
	// Position of OEPOL field.
	USART4_CFG_OEPOL_Pos = 0x15
	// Bit mask of OEPOL field.
	USART4_CFG_OEPOL_Msk = 0x200000
	// Bit OEPOL.
	USART4_CFG_OEPOL = 0x200000
	// Low. If selected by OESEL, the output enable is active low.
	USART4_CFG_OEPOL_LOW = 0x0
	// High. If selected by OESEL, the output enable is active high.
	USART4_CFG_OEPOL_HIGH = 0x1
	// Position of RXPOL field.
	USART4_CFG_RXPOL_Pos = 0x16
	// Bit mask of RXPOL field.
	USART4_CFG_RXPOL_Msk = 0x400000
	// Bit RXPOL.
	USART4_CFG_RXPOL = 0x400000
	// Not changed. The RX signal is used as it arrives from the pin. This means that the RX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART4_CFG_RXPOL_NOT_CHANGED = 0x0
	// Inverted. The RX signal is inverted before being used by the UART. This means that the RX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART4_CFG_RXPOL_INVERTED = 0x1
	// Position of TXPOL field.
	USART4_CFG_TXPOL_Pos = 0x17
	// Bit mask of TXPOL field.
	USART4_CFG_TXPOL_Msk = 0x800000
	// Bit TXPOL.
	USART4_CFG_TXPOL = 0x800000
	// Not changed. The TX signal is sent out without change. This means that the TX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART4_CFG_TXPOL_NOT_CHANGED = 0x0
	// Inverted. The TX signal is inverted by the UART before being sent out. This means that the TX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART4_CFG_TXPOL_INVERTED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0xff000000

	// CTL: USART Control register. USART control settings that are more likely to change during operation.
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART4_CTL_RESERVED = 0x1
	// Position of TXBRKEN field.
	USART4_CTL_TXBRKEN_Pos = 0x1
	// Bit mask of TXBRKEN field.
	USART4_CTL_TXBRKEN_Msk = 0x2
	// Bit TXBRKEN.
	USART4_CTL_TXBRKEN = 0x2
	// Normal operation.
	USART4_CTL_TXBRKEN_NORMAL_OPERATION = 0x0
	// Continuous break is sent immediately when this bit is set, and remains until this bit is cleared. A break may be sent without danger of corrupting any currently transmitting character if the transmitter is first disabled (TXDIS in CTL is set) and then waiting for the transmitter to be disabled (TXDISINT in STAT = 1) before writing 1 to TXBRKEN.
	USART4_CTL_TXBRKEN_CONTINUOUS_BREAK_IS = 0x1
	// Position of ADDRDET field.
	USART4_CTL_ADDRDET_Pos = 0x2
	// Bit mask of ADDRDET field.
	USART4_CTL_ADDRDET_Msk = 0x4
	// Bit ADDRDET.
	USART4_CTL_ADDRDET = 0x4
	// Disabled. The USART presents all incoming data.
	USART4_CTL_ADDRDET_DISABLED = 0x0
	// Enabled. The USART receiver ignores incoming data that does not have the most significant bit of the data (typically the 9th bit) = 1. When the data MSB bit = 1, the receiver treats the incoming data normally, generating a received data interrupt. Software can then check the data to see if this is an address that should be handled. If it is, the ADDRDET bit is cleared by software and further incoming data is handled normally.
	USART4_CTL_ADDRDET_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x38
	// Position of TXDIS field.
	USART4_CTL_TXDIS_Pos = 0x6
	// Bit mask of TXDIS field.
	USART4_CTL_TXDIS_Msk = 0x40
	// Bit TXDIS.
	USART4_CTL_TXDIS = 0x40
	// Not disabled. USART transmitter is not disabled.
	USART4_CTL_TXDIS_NOT_DISABLED = 0x0
	// Disabled. USART transmitter is disabled after any character currently being transmitted is complete. This feature can be used to facilitate software flow control.
	USART4_CTL_TXDIS_DISABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_CTL_RESERVED = 0x80
	// Position of CC field.
	USART4_CTL_CC_Pos = 0x8
	// Bit mask of CC field.
	USART4_CTL_CC_Msk = 0x100
	// Bit CC.
	USART4_CTL_CC = 0x100
	// Clock on character. In synchronous mode, SCLK cycles only when characters are being sent on Un_TXD or to complete a character that is being received.
	USART4_CTL_CC_CLOCK_ON_CHARACTER = 0x0
	// Continuous clock. SCLK runs continuously in synchronous mode, allowing characters to be received on Un_RxD independently from transmission on Un_TXD).
	USART4_CTL_CC_CONTINUOUS_CLOCK = 0x1
	// Position of CLRCCONRX field.
	USART4_CTL_CLRCCONRX_Pos = 0x9
	// Bit mask of CLRCCONRX field.
	USART4_CTL_CLRCCONRX_Msk = 0x200
	// Bit CLRCCONRX.
	USART4_CTL_CLRCCONRX = 0x200
	// No effect on the CC bit.
	USART4_CTL_CLRCCONRX_NO_EFFECT = 0x0
	// Auto-clear. The CC bit is automatically cleared when a complete character has been received. This bit is cleared at the same time.
	USART4_CTL_CLRCCONRX_AUTO_CLEAR = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0xfc00
	// Position of AUTOBAUD field.
	USART4_CTL_AUTOBAUD_Pos = 0x10
	// Bit mask of AUTOBAUD field.
	USART4_CTL_AUTOBAUD_Msk = 0x10000
	// Bit AUTOBAUD.
	USART4_CTL_AUTOBAUD = 0x10000
	// Disabled. UART is in normal operating mode.
	USART4_CTL_AUTOBAUD_DISABLED = 0x0
	// Enabled. UART is in autobaud mode. This bit should only be set when the UART receiver is idle. The first start bit of RX is measured and used the update the BRG register to match the received data rate. AUTOBAUD is cleared once this process is complete, or if there is an AERR. This bit can be cleared by software when set, but only when the UART receiver is idle.
	USART4_CTL_AUTOBAUD_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0xfffe0000

	// STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
	// Position of RXRDY field.
	USART4_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART4_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART4_STAT_RXRDY = 0x1
	// Position of RXIDLE field.
	USART4_STAT_RXIDLE_Pos = 0x1
	// Bit mask of RXIDLE field.
	USART4_STAT_RXIDLE_Msk = 0x2
	// Bit RXIDLE.
	USART4_STAT_RXIDLE = 0x2
	// Position of TXRDY field.
	USART4_STAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART4_STAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART4_STAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART4_STAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART4_STAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART4_STAT_TXIDLE = 0x8
	// Position of CTS field.
	USART4_STAT_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART4_STAT_CTS_Msk = 0x10
	// Bit CTS.
	USART4_STAT_CTS = 0x10
	// Position of DELTACTS field.
	USART4_STAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART4_STAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART4_STAT_DELTACTS = 0x20
	// Position of TXDISSTAT field.
	USART4_STAT_TXDISSTAT_Pos = 0x6
	// Bit mask of TXDISSTAT field.
	USART4_STAT_TXDISSTAT_Msk = 0x40
	// Bit TXDISSTAT.
	USART4_STAT_TXDISSTAT = 0x40
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_STAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART4_STAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART4_STAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART4_STAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0x200
	// Bit RESERVED.
	USART4_STAT_RESERVED = 0x200
	// Position of RXBRK field.
	USART4_STAT_RXBRK_Pos = 0xa
	// Bit mask of RXBRK field.
	USART4_STAT_RXBRK_Msk = 0x400
	// Bit RXBRK.
	USART4_STAT_RXBRK = 0x400
	// Position of DELTARXBRK field.
	USART4_STAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART4_STAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART4_STAT_DELTARXBRK = 0x800
	// Position of START field.
	USART4_STAT_START_Pos = 0xc
	// Bit mask of START field.
	USART4_STAT_START_Msk = 0x1000
	// Bit START.
	USART4_STAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART4_STAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART4_STAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART4_STAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART4_STAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART4_STAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART4_STAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART4_STAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART4_STAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART4_STAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART4_STAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART4_STAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART4_STAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0xfffe0000

	// INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	USART4_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	USART4_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	USART4_INTENSET_RXRDYEN = 0x1
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x2
	// Position of TXRDYEN field.
	USART4_INTENSET_TXRDYEN_Pos = 0x2
	// Bit mask of TXRDYEN field.
	USART4_INTENSET_TXRDYEN_Msk = 0x4
	// Bit TXRDYEN.
	USART4_INTENSET_TXRDYEN = 0x4
	// Position of TXIDLEEN field.
	USART4_INTENSET_TXIDLEEN_Pos = 0x3
	// Bit mask of TXIDLEEN field.
	USART4_INTENSET_TXIDLEEN_Msk = 0x8
	// Bit TXIDLEEN.
	USART4_INTENSET_TXIDLEEN = 0x8
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x10
	// Position of DELTACTSEN field.
	USART4_INTENSET_DELTACTSEN_Pos = 0x5
	// Bit mask of DELTACTSEN field.
	USART4_INTENSET_DELTACTSEN_Msk = 0x20
	// Bit DELTACTSEN.
	USART4_INTENSET_DELTACTSEN = 0x20
	// Position of TXDISEN field.
	USART4_INTENSET_TXDISEN_Pos = 0x6
	// Bit mask of TXDISEN field.
	USART4_INTENSET_TXDISEN_Msk = 0x40
	// Bit TXDISEN.
	USART4_INTENSET_TXDISEN = 0x40
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x80
	// Position of OVERRUNEN field.
	USART4_INTENSET_OVERRUNEN_Pos = 0x8
	// Bit mask of OVERRUNEN field.
	USART4_INTENSET_OVERRUNEN_Msk = 0x100
	// Bit OVERRUNEN.
	USART4_INTENSET_OVERRUNEN = 0x100
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x600
	// Position of DELTARXBRKEN field.
	USART4_INTENSET_DELTARXBRKEN_Pos = 0xb
	// Bit mask of DELTARXBRKEN field.
	USART4_INTENSET_DELTARXBRKEN_Msk = 0x800
	// Bit DELTARXBRKEN.
	USART4_INTENSET_DELTARXBRKEN = 0x800
	// Position of STARTEN field.
	USART4_INTENSET_STARTEN_Pos = 0xc
	// Bit mask of STARTEN field.
	USART4_INTENSET_STARTEN_Msk = 0x1000
	// Bit STARTEN.
	USART4_INTENSET_STARTEN = 0x1000
	// Position of FRAMERREN field.
	USART4_INTENSET_FRAMERREN_Pos = 0xd
	// Bit mask of FRAMERREN field.
	USART4_INTENSET_FRAMERREN_Msk = 0x2000
	// Bit FRAMERREN.
	USART4_INTENSET_FRAMERREN = 0x2000
	// Position of PARITYERREN field.
	USART4_INTENSET_PARITYERREN_Pos = 0xe
	// Bit mask of PARITYERREN field.
	USART4_INTENSET_PARITYERREN_Msk = 0x4000
	// Bit PARITYERREN.
	USART4_INTENSET_PARITYERREN = 0x4000
	// Position of RXNOISEEN field.
	USART4_INTENSET_RXNOISEEN_Pos = 0xf
	// Bit mask of RXNOISEEN field.
	USART4_INTENSET_RXNOISEEN_Msk = 0x8000
	// Bit RXNOISEEN.
	USART4_INTENSET_RXNOISEEN = 0x8000
	// Position of ABERREN field.
	USART4_INTENSET_ABERREN_Pos = 0x10
	// Bit mask of ABERREN field.
	USART4_INTENSET_ABERREN_Msk = 0x10000
	// Bit ABERREN.
	USART4_INTENSET_ABERREN = 0x10000
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0xfffe0000

	// INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
	// Position of RXRDYCLR field.
	USART4_INTENCLR_RXRDYCLR_Pos = 0x0
	// Bit mask of RXRDYCLR field.
	USART4_INTENCLR_RXRDYCLR_Msk = 0x1
	// Bit RXRDYCLR.
	USART4_INTENCLR_RXRDYCLR = 0x1
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x2
	// Position of TXRDYCLR field.
	USART4_INTENCLR_TXRDYCLR_Pos = 0x2
	// Bit mask of TXRDYCLR field.
	USART4_INTENCLR_TXRDYCLR_Msk = 0x4
	// Bit TXRDYCLR.
	USART4_INTENCLR_TXRDYCLR = 0x4
	// Position of TXIDLECLR field.
	USART4_INTENCLR_TXIDLECLR_Pos = 0x3
	// Bit mask of TXIDLECLR field.
	USART4_INTENCLR_TXIDLECLR_Msk = 0x8
	// Bit TXIDLECLR.
	USART4_INTENCLR_TXIDLECLR = 0x8
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x10
	// Position of DELTACTSCLR field.
	USART4_INTENCLR_DELTACTSCLR_Pos = 0x5
	// Bit mask of DELTACTSCLR field.
	USART4_INTENCLR_DELTACTSCLR_Msk = 0x20
	// Bit DELTACTSCLR.
	USART4_INTENCLR_DELTACTSCLR = 0x20
	// Position of TXDISINTCLR field.
	USART4_INTENCLR_TXDISINTCLR_Pos = 0x6
	// Bit mask of TXDISINTCLR field.
	USART4_INTENCLR_TXDISINTCLR_Msk = 0x40
	// Bit TXDISINTCLR.
	USART4_INTENCLR_TXDISINTCLR = 0x40
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x80
	// Position of OVERRUNCLR field.
	USART4_INTENCLR_OVERRUNCLR_Pos = 0x8
	// Bit mask of OVERRUNCLR field.
	USART4_INTENCLR_OVERRUNCLR_Msk = 0x100
	// Bit OVERRUNCLR.
	USART4_INTENCLR_OVERRUNCLR = 0x100
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x600
	// Position of DELTARXBRKCLR field.
	USART4_INTENCLR_DELTARXBRKCLR_Pos = 0xb
	// Bit mask of DELTARXBRKCLR field.
	USART4_INTENCLR_DELTARXBRKCLR_Msk = 0x800
	// Bit DELTARXBRKCLR.
	USART4_INTENCLR_DELTARXBRKCLR = 0x800
	// Position of STARTCLR field.
	USART4_INTENCLR_STARTCLR_Pos = 0xc
	// Bit mask of STARTCLR field.
	USART4_INTENCLR_STARTCLR_Msk = 0x1000
	// Bit STARTCLR.
	USART4_INTENCLR_STARTCLR = 0x1000
	// Position of FRAMERRCLR field.
	USART4_INTENCLR_FRAMERRCLR_Pos = 0xd
	// Bit mask of FRAMERRCLR field.
	USART4_INTENCLR_FRAMERRCLR_Msk = 0x2000
	// Bit FRAMERRCLR.
	USART4_INTENCLR_FRAMERRCLR = 0x2000
	// Position of PARITYERRCLR field.
	USART4_INTENCLR_PARITYERRCLR_Pos = 0xe
	// Bit mask of PARITYERRCLR field.
	USART4_INTENCLR_PARITYERRCLR_Msk = 0x4000
	// Bit PARITYERRCLR.
	USART4_INTENCLR_PARITYERRCLR = 0x4000
	// Position of RXNOISECLR field.
	USART4_INTENCLR_RXNOISECLR_Pos = 0xf
	// Bit mask of RXNOISECLR field.
	USART4_INTENCLR_RXNOISECLR_Msk = 0x8000
	// Bit RXNOISECLR.
	USART4_INTENCLR_RXNOISECLR = 0x8000
	// Position of ABERRCLR field.
	USART4_INTENCLR_ABERRCLR_Pos = 0x10
	// Bit mask of ABERRCLR field.
	USART4_INTENCLR_ABERRCLR_Msk = 0x10000
	// Bit ABERRCLR.
	USART4_INTENCLR_ABERRCLR = 0x10000
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0xfffe0000

	// RXDAT: Receiver Data register. Contains the last character received.
	// Position of RXDAT field.
	USART4_RXDAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART4_RXDAT_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_RXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_RXDAT_RESERVED_Msk = 0xfffffe00

	// RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
	// Position of RXDAT field.
	USART4_RXDATSTAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART4_RXDATSTAT_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	USART4_RXDATSTAT_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	USART4_RXDATSTAT_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	USART4_RXDATSTAT_FRAMERR = 0x2000
	// Position of PARITYERR field.
	USART4_RXDATSTAT_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	USART4_RXDATSTAT_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	USART4_RXDATSTAT_PARITYERR = 0x4000
	// Position of RXNOISE field.
	USART4_RXDATSTAT_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	USART4_RXDATSTAT_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	USART4_RXDATSTAT_RXNOISE = 0x8000
	// Position of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Msk = 0xffff0000

	// TXDAT: Transmit Data register. Data to be transmitted is written here.
	// Position of TXDAT field.
	USART4_TXDAT_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	USART4_TXDAT_TXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_TXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_TXDAT_RESERVED_Msk = 0xfffffe00

	// BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
	// Position of BRGVAL field.
	USART4_BRG_BRGVAL_Pos = 0x0
	// Bit mask of BRGVAL field.
	USART4_BRG_BRGVAL_Msk = 0xffff
	// Position of RESERVED field.
	USART4_BRG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_BRG_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
	// Position of RXRDY field.
	USART4_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART4_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART4_INTSTAT_RXRDY = 0x1
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x2
	// Position of TXRDY field.
	USART4_INTSTAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART4_INTSTAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART4_INTSTAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART4_INTSTAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART4_INTSTAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART4_INTSTAT_TXIDLE = 0x8
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x10
	// Position of DELTACTS field.
	USART4_INTSTAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART4_INTSTAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART4_INTSTAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART4_INTSTAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART4_INTSTAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART4_INTSTAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART4_INTSTAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART4_INTSTAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART4_INTSTAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x600
	// Position of DELTARXBRK field.
	USART4_INTSTAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART4_INTSTAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART4_INTSTAT_DELTARXBRK = 0x800
	// Position of START field.
	USART4_INTSTAT_START_Pos = 0xc
	// Bit mask of START field.
	USART4_INTSTAT_START_Msk = 0x1000
	// Bit START.
	USART4_INTSTAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART4_INTSTAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART4_INTSTAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART4_INTSTAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART4_INTSTAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART4_INTSTAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART4_INTSTAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART4_INTSTAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART4_INTSTAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART4_INTSTAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART4_INTSTAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART4_INTSTAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART4_INTSTAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0xfffe0000

	// OSR: Oversample selection register for asynchronous communication.
	// Position of OSRVAL field.
	USART4_OSR_OSRVAL_Pos = 0x0
	// Bit mask of OSRVAL field.
	USART4_OSR_OSRVAL_Msk = 0xf
	// Position of RESERVED field.
	USART4_OSR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_OSR_RESERVED_Msk = 0xfffffff0

	// ADDR: Address register for automatic address matching.
	// Position of ADDRESS field.
	USART4_ADDR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USART4_ADDR_ADDRESS_Msk = 0xff
	// Position of RESERVED field.
	USART4_ADDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART4_ADDR_RESERVED_Msk = 0xffffff00
)

// Constants for GINT0: GPIO group interrupt 0
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GINT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GINT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GINT0_CTRL_INT = 0x1
	// No interrupt request is pending.
	GINT0_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GINT0_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GINT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GINT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GINT0_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GINT0_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GINT0_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GINT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GINT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GINT0_CTRL_TRIG = 0x4
	// Edge-triggered
	GINT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GINT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GINT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GINT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL: GPIO grouped interrupt port 0 polarity register
	// Position of POL0 field.
	GINT0_PORT_POL_POL0_Pos = 0x0
	// Bit mask of POL0 field.
	GINT0_PORT_POL_POL0_Msk = 0x1
	// Bit POL0.
	GINT0_PORT_POL_POL0 = 0x1
	// Position of POL1 field.
	GINT0_PORT_POL_POL1_Pos = 0x1
	// Bit mask of POL1 field.
	GINT0_PORT_POL_POL1_Msk = 0x2
	// Bit POL1.
	GINT0_PORT_POL_POL1 = 0x2
	// Position of POL2 field.
	GINT0_PORT_POL_POL2_Pos = 0x2
	// Bit mask of POL2 field.
	GINT0_PORT_POL_POL2_Msk = 0x4
	// Bit POL2.
	GINT0_PORT_POL_POL2 = 0x4
	// Position of POL3 field.
	GINT0_PORT_POL_POL3_Pos = 0x3
	// Bit mask of POL3 field.
	GINT0_PORT_POL_POL3_Msk = 0x8
	// Bit POL3.
	GINT0_PORT_POL_POL3 = 0x8
	// Position of POL4 field.
	GINT0_PORT_POL_POL4_Pos = 0x4
	// Bit mask of POL4 field.
	GINT0_PORT_POL_POL4_Msk = 0x10
	// Bit POL4.
	GINT0_PORT_POL_POL4 = 0x10
	// Position of POL5 field.
	GINT0_PORT_POL_POL5_Pos = 0x5
	// Bit mask of POL5 field.
	GINT0_PORT_POL_POL5_Msk = 0x20
	// Bit POL5.
	GINT0_PORT_POL_POL5 = 0x20
	// Position of POL6 field.
	GINT0_PORT_POL_POL6_Pos = 0x6
	// Bit mask of POL6 field.
	GINT0_PORT_POL_POL6_Msk = 0x40
	// Bit POL6.
	GINT0_PORT_POL_POL6 = 0x40
	// Position of POL7 field.
	GINT0_PORT_POL_POL7_Pos = 0x7
	// Bit mask of POL7 field.
	GINT0_PORT_POL_POL7_Msk = 0x80
	// Bit POL7.
	GINT0_PORT_POL_POL7 = 0x80
	// Position of POL8 field.
	GINT0_PORT_POL_POL8_Pos = 0x8
	// Bit mask of POL8 field.
	GINT0_PORT_POL_POL8_Msk = 0x100
	// Bit POL8.
	GINT0_PORT_POL_POL8 = 0x100
	// Position of POL9 field.
	GINT0_PORT_POL_POL9_Pos = 0x9
	// Bit mask of POL9 field.
	GINT0_PORT_POL_POL9_Msk = 0x200
	// Bit POL9.
	GINT0_PORT_POL_POL9 = 0x200
	// Position of POL10 field.
	GINT0_PORT_POL_POL10_Pos = 0xa
	// Bit mask of POL10 field.
	GINT0_PORT_POL_POL10_Msk = 0x400
	// Bit POL10.
	GINT0_PORT_POL_POL10 = 0x400
	// Position of POL11 field.
	GINT0_PORT_POL_POL11_Pos = 0xb
	// Bit mask of POL11 field.
	GINT0_PORT_POL_POL11_Msk = 0x800
	// Bit POL11.
	GINT0_PORT_POL_POL11 = 0x800
	// Position of POL12 field.
	GINT0_PORT_POL_POL12_Pos = 0xc
	// Bit mask of POL12 field.
	GINT0_PORT_POL_POL12_Msk = 0x1000
	// Bit POL12.
	GINT0_PORT_POL_POL12 = 0x1000
	// Position of POL13 field.
	GINT0_PORT_POL_POL13_Pos = 0xd
	// Bit mask of POL13 field.
	GINT0_PORT_POL_POL13_Msk = 0x2000
	// Bit POL13.
	GINT0_PORT_POL_POL13 = 0x2000
	// Position of POL14 field.
	GINT0_PORT_POL_POL14_Pos = 0xe
	// Bit mask of POL14 field.
	GINT0_PORT_POL_POL14_Msk = 0x4000
	// Bit POL14.
	GINT0_PORT_POL_POL14 = 0x4000
	// Position of POL15 field.
	GINT0_PORT_POL_POL15_Pos = 0xf
	// Bit mask of POL15 field.
	GINT0_PORT_POL_POL15_Msk = 0x8000
	// Bit POL15.
	GINT0_PORT_POL_POL15 = 0x8000
	// Position of POL16 field.
	GINT0_PORT_POL_POL16_Pos = 0x10
	// Bit mask of POL16 field.
	GINT0_PORT_POL_POL16_Msk = 0x10000
	// Bit POL16.
	GINT0_PORT_POL_POL16 = 0x10000
	// Position of POL17 field.
	GINT0_PORT_POL_POL17_Pos = 0x11
	// Bit mask of POL17 field.
	GINT0_PORT_POL_POL17_Msk = 0x20000
	// Bit POL17.
	GINT0_PORT_POL_POL17 = 0x20000
	// Position of POL18 field.
	GINT0_PORT_POL_POL18_Pos = 0x12
	// Bit mask of POL18 field.
	GINT0_PORT_POL_POL18_Msk = 0x40000
	// Bit POL18.
	GINT0_PORT_POL_POL18 = 0x40000
	// Position of POL19 field.
	GINT0_PORT_POL_POL19_Pos = 0x13
	// Bit mask of POL19 field.
	GINT0_PORT_POL_POL19_Msk = 0x80000
	// Bit POL19.
	GINT0_PORT_POL_POL19 = 0x80000
	// Position of POL20 field.
	GINT0_PORT_POL_POL20_Pos = 0x14
	// Bit mask of POL20 field.
	GINT0_PORT_POL_POL20_Msk = 0x100000
	// Bit POL20.
	GINT0_PORT_POL_POL20 = 0x100000
	// Position of POL21 field.
	GINT0_PORT_POL_POL21_Pos = 0x15
	// Bit mask of POL21 field.
	GINT0_PORT_POL_POL21_Msk = 0x200000
	// Bit POL21.
	GINT0_PORT_POL_POL21 = 0x200000
	// Position of POL22 field.
	GINT0_PORT_POL_POL22_Pos = 0x16
	// Bit mask of POL22 field.
	GINT0_PORT_POL_POL22_Msk = 0x400000
	// Bit POL22.
	GINT0_PORT_POL_POL22 = 0x400000
	// Position of POL23 field.
	GINT0_PORT_POL_POL23_Pos = 0x17
	// Bit mask of POL23 field.
	GINT0_PORT_POL_POL23_Msk = 0x800000
	// Bit POL23.
	GINT0_PORT_POL_POL23 = 0x800000
	// Position of POL24 field.
	GINT0_PORT_POL_POL24_Pos = 0x18
	// Bit mask of POL24 field.
	GINT0_PORT_POL_POL24_Msk = 0x1000000
	// Bit POL24.
	GINT0_PORT_POL_POL24 = 0x1000000
	// Position of POL25 field.
	GINT0_PORT_POL_POL25_Pos = 0x19
	// Bit mask of POL25 field.
	GINT0_PORT_POL_POL25_Msk = 0x2000000
	// Bit POL25.
	GINT0_PORT_POL_POL25 = 0x2000000
	// Position of POL26 field.
	GINT0_PORT_POL_POL26_Pos = 0x1a
	// Bit mask of POL26 field.
	GINT0_PORT_POL_POL26_Msk = 0x4000000
	// Bit POL26.
	GINT0_PORT_POL_POL26 = 0x4000000
	// Position of POL27 field.
	GINT0_PORT_POL_POL27_Pos = 0x1b
	// Bit mask of POL27 field.
	GINT0_PORT_POL_POL27_Msk = 0x8000000
	// Bit POL27.
	GINT0_PORT_POL_POL27 = 0x8000000
	// Position of POL28 field.
	GINT0_PORT_POL_POL28_Pos = 0x1c
	// Bit mask of POL28 field.
	GINT0_PORT_POL_POL28_Msk = 0x10000000
	// Bit POL28.
	GINT0_PORT_POL_POL28 = 0x10000000
	// Position of POL29 field.
	GINT0_PORT_POL_POL29_Pos = 0x1d
	// Bit mask of POL29 field.
	GINT0_PORT_POL_POL29_Msk = 0x20000000
	// Bit POL29.
	GINT0_PORT_POL_POL29 = 0x20000000
	// Position of POL30 field.
	GINT0_PORT_POL_POL30_Pos = 0x1e
	// Bit mask of POL30 field.
	GINT0_PORT_POL_POL30_Msk = 0x40000000
	// Bit POL30.
	GINT0_PORT_POL_POL30 = 0x40000000
	// Position of POL31 field.
	GINT0_PORT_POL_POL31_Pos = 0x1f
	// Bit mask of POL31 field.
	GINT0_PORT_POL_POL31_Msk = 0x80000000
	// Bit POL31.
	GINT0_PORT_POL_POL31 = 0x80000000

	// PORT_ENA: GPIO grouped interrupt port enable register
	// Position of ENA0 field.
	GINT0_PORT_ENA_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	GINT0_PORT_ENA_ENA0_Msk = 0x1
	// Bit ENA0.
	GINT0_PORT_ENA_ENA0 = 0x1
	// Position of ENA1 field.
	GINT0_PORT_ENA_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	GINT0_PORT_ENA_ENA1_Msk = 0x2
	// Bit ENA1.
	GINT0_PORT_ENA_ENA1 = 0x2
	// Position of ENA2 field.
	GINT0_PORT_ENA_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	GINT0_PORT_ENA_ENA2_Msk = 0x4
	// Bit ENA2.
	GINT0_PORT_ENA_ENA2 = 0x4
	// Position of ENA3 field.
	GINT0_PORT_ENA_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	GINT0_PORT_ENA_ENA3_Msk = 0x8
	// Bit ENA3.
	GINT0_PORT_ENA_ENA3 = 0x8
	// Position of ENA4 field.
	GINT0_PORT_ENA_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	GINT0_PORT_ENA_ENA4_Msk = 0x10
	// Bit ENA4.
	GINT0_PORT_ENA_ENA4 = 0x10
	// Position of ENA5 field.
	GINT0_PORT_ENA_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	GINT0_PORT_ENA_ENA5_Msk = 0x20
	// Bit ENA5.
	GINT0_PORT_ENA_ENA5 = 0x20
	// Position of ENA6 field.
	GINT0_PORT_ENA_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	GINT0_PORT_ENA_ENA6_Msk = 0x40
	// Bit ENA6.
	GINT0_PORT_ENA_ENA6 = 0x40
	// Position of ENA7 field.
	GINT0_PORT_ENA_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	GINT0_PORT_ENA_ENA7_Msk = 0x80
	// Bit ENA7.
	GINT0_PORT_ENA_ENA7 = 0x80
	// Position of ENA8 field.
	GINT0_PORT_ENA_ENA8_Pos = 0x8
	// Bit mask of ENA8 field.
	GINT0_PORT_ENA_ENA8_Msk = 0x100
	// Bit ENA8.
	GINT0_PORT_ENA_ENA8 = 0x100
	// Position of ENA9 field.
	GINT0_PORT_ENA_ENA9_Pos = 0x9
	// Bit mask of ENA9 field.
	GINT0_PORT_ENA_ENA9_Msk = 0x200
	// Bit ENA9.
	GINT0_PORT_ENA_ENA9 = 0x200
	// Position of ENA10 field.
	GINT0_PORT_ENA_ENA10_Pos = 0xa
	// Bit mask of ENA10 field.
	GINT0_PORT_ENA_ENA10_Msk = 0x400
	// Bit ENA10.
	GINT0_PORT_ENA_ENA10 = 0x400
	// Position of ENA11 field.
	GINT0_PORT_ENA_ENA11_Pos = 0xb
	// Bit mask of ENA11 field.
	GINT0_PORT_ENA_ENA11_Msk = 0x800
	// Bit ENA11.
	GINT0_PORT_ENA_ENA11 = 0x800
	// Position of ENA12 field.
	GINT0_PORT_ENA_ENA12_Pos = 0xc
	// Bit mask of ENA12 field.
	GINT0_PORT_ENA_ENA12_Msk = 0x1000
	// Bit ENA12.
	GINT0_PORT_ENA_ENA12 = 0x1000
	// Position of ENA13 field.
	GINT0_PORT_ENA_ENA13_Pos = 0xd
	// Bit mask of ENA13 field.
	GINT0_PORT_ENA_ENA13_Msk = 0x2000
	// Bit ENA13.
	GINT0_PORT_ENA_ENA13 = 0x2000
	// Position of ENA14 field.
	GINT0_PORT_ENA_ENA14_Pos = 0xe
	// Bit mask of ENA14 field.
	GINT0_PORT_ENA_ENA14_Msk = 0x4000
	// Bit ENA14.
	GINT0_PORT_ENA_ENA14 = 0x4000
	// Position of ENA15 field.
	GINT0_PORT_ENA_ENA15_Pos = 0xf
	// Bit mask of ENA15 field.
	GINT0_PORT_ENA_ENA15_Msk = 0x8000
	// Bit ENA15.
	GINT0_PORT_ENA_ENA15 = 0x8000
	// Position of ENA16 field.
	GINT0_PORT_ENA_ENA16_Pos = 0x10
	// Bit mask of ENA16 field.
	GINT0_PORT_ENA_ENA16_Msk = 0x10000
	// Bit ENA16.
	GINT0_PORT_ENA_ENA16 = 0x10000
	// Position of ENA17 field.
	GINT0_PORT_ENA_ENA17_Pos = 0x11
	// Bit mask of ENA17 field.
	GINT0_PORT_ENA_ENA17_Msk = 0x20000
	// Bit ENA17.
	GINT0_PORT_ENA_ENA17 = 0x20000
	// Position of ENA18 field.
	GINT0_PORT_ENA_ENA18_Pos = 0x12
	// Bit mask of ENA18 field.
	GINT0_PORT_ENA_ENA18_Msk = 0x40000
	// Bit ENA18.
	GINT0_PORT_ENA_ENA18 = 0x40000
	// Position of ENA19 field.
	GINT0_PORT_ENA_ENA19_Pos = 0x13
	// Bit mask of ENA19 field.
	GINT0_PORT_ENA_ENA19_Msk = 0x80000
	// Bit ENA19.
	GINT0_PORT_ENA_ENA19 = 0x80000
	// Position of ENA20 field.
	GINT0_PORT_ENA_ENA20_Pos = 0x14
	// Bit mask of ENA20 field.
	GINT0_PORT_ENA_ENA20_Msk = 0x100000
	// Bit ENA20.
	GINT0_PORT_ENA_ENA20 = 0x100000
	// Position of ENA21 field.
	GINT0_PORT_ENA_ENA21_Pos = 0x15
	// Bit mask of ENA21 field.
	GINT0_PORT_ENA_ENA21_Msk = 0x200000
	// Bit ENA21.
	GINT0_PORT_ENA_ENA21 = 0x200000
	// Position of ENA22 field.
	GINT0_PORT_ENA_ENA22_Pos = 0x16
	// Bit mask of ENA22 field.
	GINT0_PORT_ENA_ENA22_Msk = 0x400000
	// Bit ENA22.
	GINT0_PORT_ENA_ENA22 = 0x400000
	// Position of ENA23 field.
	GINT0_PORT_ENA_ENA23_Pos = 0x17
	// Bit mask of ENA23 field.
	GINT0_PORT_ENA_ENA23_Msk = 0x800000
	// Bit ENA23.
	GINT0_PORT_ENA_ENA23 = 0x800000
	// Position of ENA24 field.
	GINT0_PORT_ENA_ENA24_Pos = 0x18
	// Bit mask of ENA24 field.
	GINT0_PORT_ENA_ENA24_Msk = 0x1000000
	// Bit ENA24.
	GINT0_PORT_ENA_ENA24 = 0x1000000
	// Position of ENA25 field.
	GINT0_PORT_ENA_ENA25_Pos = 0x19
	// Bit mask of ENA25 field.
	GINT0_PORT_ENA_ENA25_Msk = 0x2000000
	// Bit ENA25.
	GINT0_PORT_ENA_ENA25 = 0x2000000
	// Position of ENA26 field.
	GINT0_PORT_ENA_ENA26_Pos = 0x1a
	// Bit mask of ENA26 field.
	GINT0_PORT_ENA_ENA26_Msk = 0x4000000
	// Bit ENA26.
	GINT0_PORT_ENA_ENA26 = 0x4000000
	// Position of ENA27 field.
	GINT0_PORT_ENA_ENA27_Pos = 0x1b
	// Bit mask of ENA27 field.
	GINT0_PORT_ENA_ENA27_Msk = 0x8000000
	// Bit ENA27.
	GINT0_PORT_ENA_ENA27 = 0x8000000
	// Position of ENA28 field.
	GINT0_PORT_ENA_ENA28_Pos = 0x1c
	// Bit mask of ENA28 field.
	GINT0_PORT_ENA_ENA28_Msk = 0x10000000
	// Bit ENA28.
	GINT0_PORT_ENA_ENA28 = 0x10000000
	// Position of ENA29 field.
	GINT0_PORT_ENA_ENA29_Pos = 0x1d
	// Bit mask of ENA29 field.
	GINT0_PORT_ENA_ENA29_Msk = 0x20000000
	// Bit ENA29.
	GINT0_PORT_ENA_ENA29 = 0x20000000
	// Position of ENA30 field.
	GINT0_PORT_ENA_ENA30_Pos = 0x1e
	// Bit mask of ENA30 field.
	GINT0_PORT_ENA_ENA30_Msk = 0x40000000
	// Bit ENA30.
	GINT0_PORT_ENA_ENA30 = 0x40000000
	// Position of ENA31 field.
	GINT0_PORT_ENA_ENA31_Pos = 0x1f
	// Bit mask of ENA31 field.
	GINT0_PORT_ENA_ENA31_Msk = 0x80000000
	// Bit ENA31.
	GINT0_PORT_ENA_ENA31 = 0x80000000
)

// Constants for CRC: Cyclic Redundancy Check (CRC) engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// WR_DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Constants for DMA: DMA controller
const (
	// CTRL: DMA control.
	// Position of ENABLE field.
	DMA_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMA_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMA_CTRL_ENABLE = 0x1
	// Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
	DMA_CTRL_ENABLE_DISABLED = 0x0
	// Enabled. The DMA controller is enabled.
	DMA_CTRL_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTRL_RESERVED_Msk = 0xfffffffe

	// INTSTAT: Interrupt status.
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	DMA_INTSTAT_RESERVED = 0x1
	// Position of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Pos = 0x1
	// Bit mask of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Msk = 0x2
	// Bit ACTIVEINT.
	DMA_INTSTAT_ACTIVEINT = 0x2
	// Not pending. No enabled interrupts are pending.
	DMA_INTSTAT_ACTIVEINT_NOT_PENDING = 0x0
	// Pending. At least one enabled interrupt is pending.
	DMA_INTSTAT_ACTIVEINT_PENDING = 0x1
	// Position of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Pos = 0x2
	// Bit mask of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Msk = 0x4
	// Bit ACTIVEERRINT.
	DMA_INTSTAT_ACTIVEERRINT = 0x4
	// Not pending. No error interrupts are pending.
	DMA_INTSTAT_ACTIVEERRINT_NOT_PENDING = 0x0
	// Pending. At least one error interrupt is pending.
	DMA_INTSTAT_ACTIVEERRINT_PENDING = 0x1
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0xfffffff8

	// SRAMBASE: SRAM address of the channel configuration table.
	// Position of RESERVED field.
	DMA_SRAMBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_SRAMBASE_RESERVED_Msk = 0x3ff
	// Position of OFFSET field.
	DMA_SRAMBASE_OFFSET_Pos = 0xa
	// Bit mask of OFFSET field.
	DMA_SRAMBASE_OFFSET_Msk = 0xfffffc00

	// ENABLESET0: Channel Enable read and Set for all DMA channels.
	// Position of ENA field.
	DMA_ENABLESET0_ENA_Pos = 0x0
	// Bit mask of ENA field.
	DMA_ENABLESET0_ENA_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ENABLESET0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ENABLESET0_RESERVED_Msk = 0xffff0000

	// ENABLECLR0: Channel Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_ENABLECLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_ENABLECLR0_CLR_Msk = 0xffff

	// ACTIVE0: Channel Active status for all DMA channels.
	// Position of ACT field.
	DMA_ACTIVE0_ACT_Pos = 0x0
	// Bit mask of ACT field.
	DMA_ACTIVE0_ACT_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ACTIVE0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ACTIVE0_RESERVED_Msk = 0xffff0000

	// BUSY0: Channel Busy status for all DMA channels.
	// Position of BSY field.
	DMA_BUSY0_BSY_Pos = 0x0
	// Bit mask of BSY field.
	DMA_BUSY0_BSY_Msk = 0xffff
	// Position of RESERVED field.
	DMA_BUSY0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_BUSY0_RESERVED_Msk = 0xffff0000

	// ERRINT0: Error Interrupt status for all DMA channels.
	// Position of ERR field.
	DMA_ERRINT0_ERR_Pos = 0x0
	// Bit mask of ERR field.
	DMA_ERRINT0_ERR_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ERRINT0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ERRINT0_RESERVED_Msk = 0xfffc0000

	// INTENSET0: Interrupt Enable read and Set for all DMA channels.
	// Position of INTEN field.
	DMA_INTENSET0_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	DMA_INTENSET0_INTEN_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTENSET0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTENSET0_RESERVED_Msk = 0xffff0000

	// INTENCLR0: Interrupt Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_INTENCLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_INTENCLR0_CLR_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTENCLR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTENCLR0_RESERVED_Msk = 0xffff0000

	// INTA0: Interrupt A status for all DMA channels.
	// Position of IA field.
	DMA_INTA0_IA_Pos = 0x0
	// Bit mask of IA field.
	DMA_INTA0_IA_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTA0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTA0_RESERVED_Msk = 0xffff0000

	// INTB0: Interrupt B status for all DMA channels.
	// Position of IB field.
	DMA_INTB0_IB_Pos = 0x0
	// Bit mask of IB field.
	DMA_INTB0_IB_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTB0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTB0_RESERVED_Msk = 0xffff0000

	// SETVALID0: Set ValidPending control bits for all DMA channels.
	// Position of SV field.
	DMA_SETVALID0_SV_Pos = 0x0
	// Bit mask of SV field.
	DMA_SETVALID0_SV_Msk = 0xffff
	// Position of RESERVED field.
	DMA_SETVALID0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_SETVALID0_RESERVED_Msk = 0xffff0000

	// SETTRIG0: Set Trigger control bits for all DMA channels.
	// Position of TRIG field.
	DMA_SETTRIG0_TRIG_Pos = 0x0
	// Bit mask of TRIG field.
	DMA_SETTRIG0_TRIG_Msk = 0xffff
	// Position of RESERVED field.
	DMA_SETTRIG0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_SETTRIG0_RESERVED_Msk = 0xffff0000

	// ABORT0: Channel Abort control for all DMA channels.
	// Position of AORTCTRL field.
	DMA_ABORT0_AORTCTRL_Pos = 0x0
	// Bit mask of AORTCTRL field.
	DMA_ABORT0_AORTCTRL_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ABORT0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ABORT0_RESERVED_Msk = 0xffff0000

	// CFG0: Configuration register for DMA channel 0.
	// Position of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Pos = 0x0
	// Bit mask of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Msk = 0x1
	// Bit PERIPHREQEN.
	DMA_CFG_PERIPHREQEN = 0x1
	// Disabled. Peripheral DMA requests are disabled.
	DMA_CFG_PERIPHREQEN_DISABLED = 0x0
	// Enabled. Peripheral DMA requests are enabled.
	DMA_CFG_PERIPHREQEN_ENABLED = 0x1
	// Position of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Pos = 0x1
	// Bit mask of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Msk = 0x2
	// Bit HWTRIGEN.
	DMA_CFG_HWTRIGEN = 0x2
	// Disabled. Hardware triggering is not used.
	DMA_CFG_HWTRIGEN_DISABLED = 0x0
	// Enabled. Use hardware triggering.
	DMA_CFG_HWTRIGEN_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xc
	// Position of TRIGPOL field.
	DMA_CFG_TRIGPOL_Pos = 0x4
	// Bit mask of TRIGPOL field.
	DMA_CFG_TRIGPOL_Msk = 0x10
	// Bit TRIGPOL.
	DMA_CFG_TRIGPOL = 0x10
	// Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_LOW__FALLING = 0x0
	// Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_HIGH__RISING = 0x1
	// Position of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Pos = 0x5
	// Bit mask of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Msk = 0x20
	// Bit TRIGTYPE.
	DMA_CFG_TRIGTYPE = 0x20
	// Edge. Hardware trigger is edge triggered.
	DMA_CFG_TRIGTYPE_EDGE = 0x0
	// Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER = 0) is selected, only hardware triggers should be used on that channel.
	DMA_CFG_TRIGTYPE_LEVEL = 0x1
	// Position of TRIGBURST field.
	DMA_CFG_TRIGBURST_Pos = 0x6
	// Bit mask of TRIGBURST field.
	DMA_CFG_TRIGBURST_Msk = 0x40
	// Bit TRIGBURST.
	DMA_CFG_TRIGBURST = 0x40
	// Single transfer. Hardware trigger causes a single transfer.
	DMA_CFG_TRIGBURST_SINGLE_TRANSFER = 0x0
	// Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is complete.
	DMA_CFG_TRIGBURST_BURST_TRANSFER = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	DMA_CFG_RESERVED = 0x80
	// Position of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Pos = 0x8
	// Bit mask of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Msk = 0xf00
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x3000
	// Position of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Pos = 0xe
	// Bit mask of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Msk = 0x4000
	// Bit SRCBURSTWRAP.
	DMA_CFG_SRCBURSTWRAP = 0x4000
	// Disabled. Source burst wrapping is not enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_DISABLED = 0x0
	// Enabled. Source burst wrapping is enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_ENABLED = 0x1
	// Position of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Pos = 0xf
	// Bit mask of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Msk = 0x8000
	// Bit DSTBURSTWRAP.
	DMA_CFG_DSTBURSTWRAP = 0x8000
	// Disabled. Destination burst wrapping is not enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_DISABLED = 0x0
	// Enabled. Destination burst wrapping is enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_ENABLED = 0x1
	// Position of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Pos = 0x10
	// Bit mask of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Msk = 0x30000
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xfffc0000

	// CTLSTAT0: Control and status register for DMA channel 0.
	// Position of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Pos = 0x0
	// Bit mask of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Msk = 0x1
	// Bit VALIDPENDING.
	DMA_CTLSTAT_VALIDPENDING = 0x1
	// No effect on DMA operation.
	DMA_CTLSTAT_VALIDPENDING_NO_EFFECT_ON_DMA_OPE = 0x0
	// Valid pending.
	DMA_CTLSTAT_VALIDPENDING_VALID_PENDING = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	DMA_CTLSTAT_RESERVED = 0x2
	// Position of TRIG field.
	DMA_CTLSTAT_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	DMA_CTLSTAT_TRIG_Msk = 0x4
	// Bit TRIG.
	DMA_CTLSTAT_TRIG = 0x4
	// Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
	DMA_CTLSTAT_TRIG_NOT_TRIGGERED = 0x0
	// Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
	DMA_CTLSTAT_TRIG_TRIGGERED = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0xfffffff8

	// XFERCFG0: Transfer configuration register for DMA channel 0.
	// Position of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Pos = 0x0
	// Bit mask of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Msk = 0x1
	// Bit CFGVALID.
	DMA_XFERCFG_CFGVALID = 0x1
	// Not valid. The current channel descriptor is not considered valid.
	DMA_XFERCFG_CFGVALID_NOT_VALID = 0x0
	// Valid. The current channel descriptor is considered valid.
	DMA_XFERCFG_CFGVALID_VALID = 0x1
	// Position of RELOAD field.
	DMA_XFERCFG_RELOAD_Pos = 0x1
	// Bit mask of RELOAD field.
	DMA_XFERCFG_RELOAD_Msk = 0x2
	// Bit RELOAD.
	DMA_XFERCFG_RELOAD = 0x2
	// Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_DISABLED = 0x0
	// Enabled. Reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_ENABLED = 0x1
	// Position of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Pos = 0x2
	// Bit mask of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Msk = 0x4
	// Bit SWTRIG.
	DMA_XFERCFG_SWTRIG = 0x4
	// Position of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Pos = 0x3
	// Bit mask of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Msk = 0x8
	// Bit CLRTRIG.
	DMA_XFERCFG_CLRTRIG = 0x8
	// Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
	DMA_XFERCFG_CLRTRIG_NOT_CLEARED = 0x0
	// Cleared. The trigger is cleared when this descriptor is exhausted.
	DMA_XFERCFG_CLRTRIG_CLEARED = 0x1
	// Position of SETINTA field.
	DMA_XFERCFG_SETINTA_Pos = 0x4
	// Bit mask of SETINTA field.
	DMA_XFERCFG_SETINTA_Msk = 0x10
	// Bit SETINTA.
	DMA_XFERCFG_SETINTA = 0x10
	// No effect.
	DMA_XFERCFG_SETINTA_NO_EFFECT = 0x0
	// Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTA_SET = 0x1
	// Position of SETINTB field.
	DMA_XFERCFG_SETINTB_Pos = 0x5
	// Bit mask of SETINTB field.
	DMA_XFERCFG_SETINTB_Msk = 0x20
	// Bit SETINTB.
	DMA_XFERCFG_SETINTB = 0x20
	// No effect.
	DMA_XFERCFG_SETINTB_NO_EFFECT = 0x0
	// Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTB_SET = 0x1
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc0
	// Position of WIDTH field.
	DMA_XFERCFG_WIDTH_Pos = 0x8
	// Bit mask of WIDTH field.
	DMA_XFERCFG_WIDTH_Msk = 0x300
	// 8-bit transfers are performed (8-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_8_BIT_TRANSFERS = 0x0
	// 16-bit transfers are performed (16-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_16_BIT_TRANSFERS = 0x1
	// 32-bit transfers are performed (32-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_32_BIT_TRANSFERS = 0x2
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc00
	// Position of SRCINC field.
	DMA_XFERCFG_SRCINC_Pos = 0xc
	// Bit mask of SRCINC field.
	DMA_XFERCFG_SRCINC_Msk = 0x3000
	// No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
	DMA_XFERCFG_SRCINC_NO_INCREMENT = 0x0
	// 1 x width. The source address is incremented by the amount specified by Width for each transfer. This is the usual case when the source is memory.
	DMA_XFERCFG_SRCINC_1_X_WIDTH = 0x1
	// 2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_2_X_WIDTH = 0x2
	// 4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_4_X_WIDTH = 0x3
	// Position of DSTINC field.
	DMA_XFERCFG_DSTINC_Pos = 0xe
	// Bit mask of DSTINC field.
	DMA_XFERCFG_DSTINC_Msk = 0xc000
	// No increment. The destination address is not incremented for each transfer. This is the usual case when the destination is a peripheral device.
	DMA_XFERCFG_DSTINC_NO_INCREMENT = 0x0
	// 1 x width. The destination address is incremented by the amount specified by Width for each transfer. This is the usual case when the destination is memory.
	DMA_XFERCFG_DSTINC_1_X_WIDTH = 0x1
	// 2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_2_X_WIDTH = 0x2
	// 4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_4_X_WIDTH = 0x3
	// Position of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Pos = 0x10
	// Bit mask of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Msk = 0x3ff0000
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xfc000000
)

// Constants for SCT0: State Configurable Timers (SCTimer/PWM)
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT0_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT0_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT0_CONFIG_UNIFY = 0x1
	// Position of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Msk = 0x6
	// The bus clock clocks the SCT and prescalers.
	SCT0_CONFIG_CLKMODE_THE_BUS_CLOCK_CLOCKS = 0x0
	// The SCT clock is the bus clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT0_CONFIG_CLKMODE_THE_SCT_CLOCK_IS_THE = 0x1
	// The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT0_CONFIG_CLKMODE_THE_INPUT_SELECTED_B = 0x2
	// Prescaled SCT input. The SCT and prescalers are clocked by the input edge selected by the CKSEL field. In this mode, most of the SCT is clocked by the (selected polarity of the) input. The outputs are switched synchronously to the input clock. The input clock rate must be at least half the system clock rate and can the same or faster than the system clock.
	SCT0_CONFIG_CLKMODE_PRESCALED_SCT_INPUT = 0x3
	// Position of CKSEL field.
	SCT0_CONFIG_CKSEL_Pos = 0x3
	// Bit mask of CKSEL field.
	SCT0_CONFIG_CKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT0_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT0_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT0_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT0_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT0_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of 