/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.reactions;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.reactions.UnicodeEmojiIcon;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0010J!\u0010\u0019\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001c\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000e\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/CodeReviewReactionsUIUtil;", "", "<init>", "()V", "PREFERRED_EMOJI_FONTS", "", "", "EMOJI_FONT", "Ljava/awt/Font;", "getEMOJI_FONT$intellij_platform_collaborationTools", "()Ljava/awt/Font;", "EMOJI_FONT$delegate", "Lkotlin/Lazy;", "findEmojiFont", "VARIATION_SELECTOR", "BUTTON_HEIGHT", "", "HORIZONTAL_GAP", "ICON_SIZE", "COUNTER_FONT_SIZE", "", "createUnicodeEmojiIcon", "Ljavax/swing/Icon;", "text", "size", "createTooltipText", "Lorg/jetbrains/annotations/Nls;", "users", "reactionName", "Picker", "intellij.platform.collaborationTools"})
public final class CodeReviewReactionsUIUtil {
    @NotNull
    public static final CodeReviewReactionsUIUtil INSTANCE = new CodeReviewReactionsUIUtil();
    @NotNull
    private static final List<String> PREFERRED_EMOJI_FONTS;
    @NotNull
    private static final Lazy EMOJI_FONT$delegate;
    @NotNull
    public static final String VARIATION_SELECTOR = "\ufe0f";
    public static final int BUTTON_HEIGHT = 24;
    public static final int HORIZONTAL_GAP = 8;
    public static final int ICON_SIZE = 20;
    public static final float COUNTER_FONT_SIZE = 11.0f;

    private CodeReviewReactionsUIUtil() {
    }

    @Nullable
    public final Font getEMOJI_FONT$intellij_platform_collaborationTools() {
        Lazy lazy = EMOJI_FONT$delegate;
        return (Font)lazy.getValue();
    }

    private final Font findEmojiFont() {
        Pair found = null;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts());
        while (iterator.hasNext()) {
            Font font = (Font)iterator.next();
            String name = font.getName();
            int priority = PREFERRED_EMOJI_FONTS.indexOf(name);
            if (priority < 0) {
                Intrinsics.checkNotNull((Object)name);
                if (StringsKt.contains((CharSequence)name, (CharSequence)"emoji", (boolean)true)) {
                    priority = Integer.MAX_VALUE;
                }
            }
            if (priority < 0 || found != null && priority >= ((Number)found.getFirst()).intValue()) continue;
            found = TuplesKt.to((Object)priority, (Object)font);
        }
        Pair pair = found;
        return pair != null ? (Font)pair.getSecond() : null;
    }

    @NotNull
    public final Icon createUnicodeEmojiIcon(@NotNull String text, int size) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new UnicodeEmojiIcon(text, size);
    }

    @NotNull
    public final String createTooltipText(@NotNull List<String> users, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Iterable iterable = CollectionsKt.chunked((Iterable)users, (int)3);
        String string = HtmlChunk.br().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String reactors = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, CodeReviewReactionsUIUtil::createTooltipText$lambda$1, (int)30, null) + HtmlChunk.br();
        Object[] objectArray = new Object[]{reactors, reactionName};
        String string2 = new HtmlBuilder().appendRaw(CollaborationToolsBundle.message("review.comments.reaction.tooltip", objectArray)).wrapWith(HtmlChunk.div((String)"text-align: center")).wrapWith(HtmlChunk.body()).wrapWith(HtmlChunk.html()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final CharSequence createTooltipText$lambda$1$lambda$0(String reactorName) {
        Intrinsics.checkNotNullParameter((Object)reactorName, (String)"reactorName");
        String string = HtmlChunk.text((String)reactorName).bold().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence createTooltipText$lambda$1(List chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        return CollectionsKt.joinToString$default((Iterable)chunk, (CharSequence)", ", null, null, (int)0, null, CodeReviewReactionsUIUtil::createTooltipText$lambda$1$lambda$0, (int)30, null);
    }

    public static final /* synthetic */ Font access$findEmojiFont(CodeReviewReactionsUIUtil $this) {
        return $this.findEmojiFont();
    }

    static {
        Object[] objectArray = new String[]{"Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"};
        PREFERRED_EMOJI_FONTS = CollectionsKt.listOf((Object[])objectArray);
        EMOJI_FONT$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Font>((Object)INSTANCE){

            public final Font invoke() {
                return CodeReviewReactionsUIUtil.access$findEmojiFont((CodeReviewReactionsUIUtil)this.receiver);
            }
        }));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/CodeReviewReactionsUIUtil$Picker;", "", "<init>", "()V", "WIDTH", "", "HEIGHT", "BLOCK_PADDING", "intellij.platform.collaborationTools"})
    public static final class Picker {
        @NotNull
        public static final Picker INSTANCE = new Picker();
        public static final int WIDTH = 358;
        public static final int HEIGHT = 415;
        public static final int BLOCK_PADDING = 5;

        private Picker() {
        }
    }
}

