/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.UtilBundle;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltraining/project/FileUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyJarResourcesRecursively", "", "destDir", "Ljava/io/File;", "jarPath", "", "destinationFilter", "Ljava/io/FileFilter;", "copyResourcesRecursively", "originUrl", "Ljava/net/URL;", "destination", "copyDirWithDestFilter", "", "fromDir", "toDir", "copyStream", "inputStream", "Ljava/io/InputStream;", "f", "os", "Ljava/io/OutputStream;", "ensureDirectoryExists", "splitJarPath", "Lkotlin/Pair;", "path", "intellij.featuresTrainer"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final Logger LOG;

    private FileUtils() {
    }

    public final boolean copyJarResourcesRecursively(@NotNull File destDir, @NotNull String jarPath, @Nullable FileFilter destinationFilter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Pair<String, String> splitJarPath = this.splitJarPath(jarPath);
        String mayBeEscapedFile = new URL((String)splitJarPath.getFirst()).getFile();
        String string = URLUtil.unescapePercentSequences((String)mayBeEscapedFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapePercentSequences(...)");
        String file = string;
        JarFile jarFile = new JarFile(file);
        String prefix = (String)splitJarPath.getSecond();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String filename;
            JarEntry entry = entries.nextElement();
            String string2 = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)entry.getName(), (String)prefix), (String)"trimStart(...)");
            File f = new File(destDir, filename);
            if (destinationFilter != null && !destinationFilter.accept(f) || entry.isDirectory()) continue;
            File file2 = f.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            if (!this.ensureDirectoryExists(file2)) {
                LOG.error("Cannot create directory: " + f.getParentFile());
            }
            InputStream entryInputStream = jarFile.getInputStream(entry);
            Intrinsics.checkNotNull((Object)entryInputStream);
            if (!this.copyStream(entryInputStream, f)) {
                return false;
            }
            entryInputStream.close();
        }
        return true;
    }

    public static /* synthetic */ boolean copyJarResourcesRecursively$default(FileUtils fileUtils, File file, String string, FileFilter fileFilter, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyJarResourcesRecursively(file, string, fileFilter);
    }

    public final boolean copyResourcesRecursively(@NotNull URL originUrl, @NotNull File destination, @Nullable FileFilter destinationFilter) {
        Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            if (Intrinsics.areEqual((Object)originUrl.getProtocol(), (Object)"jar")) {
                String string = originUrl.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
                this.copyJarResourcesRecursively(destination, string, destinationFilter);
            } else if (Intrinsics.areEqual((Object)originUrl.getProtocol(), (Object)"file")) {
                this.copyDirWithDestFilter(new File(originUrl.getPath()), destination, destinationFilter);
            }
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean copyResourcesRecursively$default(FileUtils fileUtils, URL uRL, File file, FileFilter fileFilter, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyResourcesRecursively(uRL, file, fileFilter);
    }

    private final void copyDirWithDestFilter(File fromDir, File toDir, FileFilter destinationFilter) {
        FileUtil.ensureExists((File)toDir);
        if (FileUtil.isAncestor((File)fromDir, (File)toDir, (boolean)true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] fileArray = fromDir.listFiles();
        if (fileArray == null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)fromDir.getPath(), (String)"getPath(...)");
            throw new IOException(UtilBundle.message((String)"exception.directory.is.invalid", (Object[])objectArray));
        }
        File[] files = fileArray;
        if (!fromDir.canRead()) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)fromDir.getPath(), (String)"getPath(...)");
            throw new IOException(UtilBundle.message((String)"exception.directory.is.not.readable", (Object[])objectArray));
        }
        for (File file : files) {
            File destinationFile = new File(toDir, file.getName());
            if (file.isDirectory()) {
                Intrinsics.checkNotNull((Object)file);
                this.copyDirWithDestFilter(file, destinationFile, destinationFilter);
                continue;
            }
            if (destinationFilter != null && !destinationFilter.accept(destinationFile)) continue;
            FileUtil.copy((File)file, (File)destinationFile);
        }
    }

    private final boolean copyStream(InputStream inputStream, File f) {
        try {
            return this.copyStream(inputStream, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private final boolean copyStream(InputStream inputStream, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            int len = inputStream.read(buf);
            while (len > 0) {
                os.write(buf, 0, len);
                len = inputStream.read(buf);
            }
            inputStream.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private final boolean ensureDirectoryExists(File f) {
        return f.exists() || f.mkdirs();
    }

    private final Pair<String, String> splitJarPath(String path) {
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)path, (String)".jar!/", (int)0, (boolean)false, (int)6, null);
        if (lastIndexOf == -1) {
            throw new IOException("Invalid Jar path format");
        }
        int splitIdx = lastIndexOf + 4;
        String string = path.substring(0, splitIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String filePath = string;
        String string2 = path.substring(splitIdx + 2, path.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String pathInsideJar = string2;
        return new Pair((Object)filePath, (Object)pathInsideJar);
    }

    static {
        Logger logger = Logger.getInstance(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

