/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections;

import com.strobel.collections.Cache;
import java.util.concurrent.ConcurrentHashMap;

final class TopLevelCache<K, V>
extends Cache<K, V> {
    private final ConcurrentHashMap<K, V> _cache = new ConcurrentHashMap();

    TopLevelCache() {
    }

    @Override
    public V cache(K key, V value) {
        V cachedValue = this._cache.putIfAbsent(key, value);
        return cachedValue != null ? cachedValue : value;
    }

    @Override
    public Cache<K, V> getSatelliteCache() {
        return TopLevelCache.createSatelliteCache(this);
    }

    @Override
    public boolean replace(K key, V expectedValue, V updatedValue) {
        if (expectedValue == null) {
            return this._cache.putIfAbsent(key, updatedValue) == null;
        }
        return this._cache.replace(key, expectedValue, updatedValue);
    }

    @Override
    public V get(K key) {
        return this._cache.get(key);
    }
}

