/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.unzipping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeSplitter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class AlternatingLayerUnzipper
implements ILayoutProcessor<LGraph> {
    /*
     * WARNING - void declaration
     */
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        void var5_6;
        this.processLayerSplitProperty(graph);
        int insertionLayerOffset = 1;
        ArrayList<Pair<Layer, Integer>> newLayers = new ArrayList<Pair<Layer, Integer>>();
        boolean bl = false;
        while (var5_6 < graph.getLayers().size()) {
            int N = this.getLayerSplitProperty(graph.getLayers().get((int)var5_6));
            boolean resetOnLongEdges = this.getResetOnLongEdgesProperty(graph.getLayers().get((int)var5_6));
            if (graph.getLayers().get((int)var5_6).getNodes().size() > N) {
                ArrayList<Layer> subLayers = new ArrayList<Layer>();
                subLayers.add(graph.getLayers().get((int)var5_6));
                int j = 0;
                while (j < N - 1) {
                    Layer newLayer = new Layer(graph);
                    newLayers.add(new Pair<Layer, Integer>(newLayer, (int)(var5_6 + j + insertionLayerOffset)));
                    subLayers.add(newLayer);
                    ++j;
                }
                insertionLayerOffset += N - 1;
                int nodesInLayer = ((Layer)subLayers.get(0)).getNodes().size();
                int j2 = 0;
                int nodeIndex = 0;
                int targetLayer = 0;
                while (j2 < nodesInLayer) {
                    LNode node = ((Layer)subLayers.get(0)).getNodes().get(nodeIndex);
                    if (node.getType() != LNode.NodeType.NONSHIFTING_PLACEHOLDER) {
                        nodeIndex += this.shiftNode(graph, subLayers, targetLayer % N, nodeIndex);
                    } else {
                        --j2;
                        --targetLayer;
                    }
                    if (resetOnLongEdges && node.getType() == LNode.NodeType.LONG_EDGE) {
                        targetLayer = -1;
                    }
                    ++j2;
                    ++nodeIndex;
                    ++targetLayer;
                }
            }
            ++var5_6;
        }
        for (Pair pair : newLayers) {
            graph.getLayers().add((Integer)pair.getSecond(), (Layer)pair.getFirst());
        }
        for (Layer layer : graph.getLayers()) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.PLACEHOLDER && node.getType() != LNode.NodeType.NONSHIFTING_PLACEHOLDER) continue;
                nodeIterator.remove();
            }
        }
    }

    private int getLayerSplitProperty(Layer layer) {
        int layerSplit = Integer.MAX_VALUE;
        boolean propertyUnset = true;
        int i = 0;
        while (i < layer.getNodes().size()) {
            if (layer.getNodes().get(i).hasProperty(LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT)) {
                propertyUnset = false;
                int nodeValue = layer.getNodes().get(i).getProperty(LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT);
                layerSplit = layerSplit < nodeValue ? layerSplit : nodeValue;
            }
            ++i;
        }
        if (propertyUnset) {
            layerSplit = LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT.getDefault();
        }
        return layerSplit;
    }

    private boolean getResetOnLongEdgesProperty(Layer layer) {
        int i = 0;
        while (i < layer.getNodes().size()) {
            if (layer.getNodes().get(i).hasProperty(LayeredOptions.LAYER_UNZIPPING_RESET_ON_LONG_EDGES) && !layer.getNodes().get(i).getProperty(LayeredOptions.LAYER_UNZIPPING_RESET_ON_LONG_EDGES).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void processLayerSplitProperty(LGraph graph) {
        for (Layer layer : graph.getLayers()) {
            boolean setLayerSplit = false;
            boolean setResetOnLongEdges = false;
            for (LNode node : layer.getNodes()) {
                if (!setLayerSplit && node.hasProperty(LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT)) {
                    layer.setProperty(LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT, node.getProperty(LayeredOptions.LAYER_UNZIPPING_LAYER_SPLIT));
                    setLayerSplit = true;
                }
                if (!setResetOnLongEdges && node.hasProperty(LayeredOptions.LAYER_UNZIPPING_RESET_ON_LONG_EDGES)) {
                    layer.setProperty(LayeredOptions.LAYER_UNZIPPING_RESET_ON_LONG_EDGES, node.getProperty(LayeredOptions.LAYER_UNZIPPING_RESET_ON_LONG_EDGES));
                    setResetOnLongEdges = true;
                }
                if (!setLayerSplit || !setResetOnLongEdges) continue;
                return;
            }
        }
    }

    private int shiftNode(LGraph graph, List<Layer> subLayers, int targetLayer, int nodeIndex) {
        LNode node = subLayers.get(0).getNodes().get(nodeIndex);
        if (targetLayer > 0) {
            node.setLayer(subLayers.get(targetLayer));
        }
        int edgeCount = 0;
        boolean noIncomingEdges = true;
        List<LEdge> reversedIncomingEdges = Lists.reverse(Lists.newArrayList(node.getIncomingEdges()));
        for (LEdge incomingEdge : reversedIncomingEdges) {
            noIncomingEdges = false;
            LEdge nextEdgeToSplit = incomingEdge;
            int layerIndex = 0;
            while (layerIndex < targetLayer) {
                LNode dummyNode = this.createDummyNode(graph, nextEdgeToSplit);
                if (nodeIndex + edgeCount > subLayers.get(layerIndex).getNodes().size()) {
                    dummyNode.setLayer(subLayers.get(layerIndex));
                } else {
                    dummyNode.setLayer(nodeIndex + edgeCount, subLayers.get(layerIndex));
                }
                nextEdgeToSplit = LongEdgeSplitter.splitEdge(nextEdgeToSplit, dummyNode);
                ++layerIndex;
            }
            if (targetLayer <= 0) continue;
            ++edgeCount;
        }
        if (noIncomingEdges) {
            int layerIndex = 0;
            while (layerIndex < targetLayer) {
                LNode dummyNode = new LNode(graph);
                dummyNode.setType(LNode.NodeType.PLACEHOLDER);
                if (nodeIndex + edgeCount > subLayers.get(layerIndex).getNodes().size()) {
                    dummyNode.setLayer(subLayers.get(layerIndex));
                } else {
                    dummyNode.setLayer(nodeIndex + edgeCount, subLayers.get(layerIndex));
                }
                ++layerIndex;
            }
            if (targetLayer > 0) {
                ++edgeCount;
            }
        }
        boolean extraEdge = false;
        Iterator<LEdge> iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            LEdge outgoingEdge;
            LEdge nextEdgeToSplit = outgoingEdge = iterator.next();
            int layerIndex = targetLayer + 1;
            while (layerIndex < subLayers.size()) {
                LNode dummyNode = this.createDummyNode(graph, nextEdgeToSplit);
                dummyNode.setLayer(subLayers.get(layerIndex));
                nextEdgeToSplit = LongEdgeSplitter.splitEdge(nextEdgeToSplit, dummyNode);
                ++layerIndex;
            }
            layerIndex = 0;
            while (layerIndex <= targetLayer) {
                if (extraEdge) {
                    LNode placeholder = new LNode(graph);
                    placeholder.setType(LNode.NodeType.NONSHIFTING_PLACEHOLDER);
                    if (nodeIndex + 1 > subLayers.get(layerIndex).getNodes().size()) {
                        placeholder.setLayer(subLayers.get(layerIndex));
                    } else {
                        placeholder.setLayer(nodeIndex + 1, subLayers.get(layerIndex));
                    }
                }
                ++layerIndex;
            }
            if (extraEdge) {
                ++edgeCount;
            }
            extraEdge = true;
        }
        if (edgeCount > 0) {
            return edgeCount - 1;
        }
        return 0;
    }

    private LNode createDummyNode(LGraph graph, LEdge nextEdgeToSplit) {
        LNode dummyNode = new LNode(graph);
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, nextEdgeToSplit);
        dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        return dummyNode;
    }
}

