/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.SearchService;
import org.opensearch.search.query.QueryRewriter;
import org.opensearch.search.query.rewriters.BooleanFlatteningRewriter;
import org.opensearch.search.query.rewriters.MatchAllRemovalRewriter;
import org.opensearch.search.query.rewriters.MustNotToShouldRewriter;
import org.opensearch.search.query.rewriters.MustToFilterRewriter;
import org.opensearch.search.query.rewriters.TermsMergingRewriter;

public final class QueryRewriterRegistry {
    private static final Logger logger = LogManager.getLogger(QueryRewriterRegistry.class);
    public static final QueryRewriterRegistry INSTANCE = new QueryRewriterRegistry();
    private final CopyOnWriteArrayList<QueryRewriter> rewriters = new CopyOnWriteArrayList();
    private volatile boolean enabled;

    private QueryRewriterRegistry() {
        this.registerRewriter(BooleanFlatteningRewriter.INSTANCE);
        this.registerRewriter(MustToFilterRewriter.INSTANCE);
        this.registerRewriter(MustNotToShouldRewriter.INSTANCE);
        this.registerRewriter(MatchAllRemovalRewriter.INSTANCE);
        this.registerRewriter(TermsMergingRewriter.INSTANCE);
    }

    public void registerRewriter(QueryRewriter rewriter) {
        if (rewriter != null) {
            this.rewriters.add(rewriter);
            logger.debug("Registered query rewriter: {}", (Object)rewriter.name());
        }
    }

    public void initialize(Settings settings, ClusterSettings clusterSettings) {
        TermsMergingRewriter.INSTANCE.initialize(settings, clusterSettings);
        this.enabled = SearchService.QUERY_REWRITING_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SearchService.QUERY_REWRITING_ENABLED_SETTING, enabled -> {
            this.enabled = enabled;
        });
    }

    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        if (!this.enabled || query == null) {
            return query;
        }
        ArrayList<QueryRewriter> sortedRewriters = new ArrayList<QueryRewriter>(this.rewriters);
        sortedRewriters.sort(Comparator.comparingInt(QueryRewriter::priority));
        QueryBuilder current = query;
        for (QueryRewriter rewriter : sortedRewriters) {
            try {
                QueryBuilder rewritten = rewriter.rewrite(current, context);
                if (rewritten == current) continue;
                current = rewritten;
            }
            catch (Exception e) {
                logger.warn("Query rewriter {} failed: {}", (Object)rewriter.name(), (Object)e.getMessage());
            }
        }
        return current;
    }
}

