/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.remember;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.MatchingALACAttributePanel;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.UnsignedAppletTrustWarningPanel;
import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.security.dialogs.remember.SavedRememberAction;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletSecurityActions
implements Iterable<SavedRememberAction> {
    private final Map<String, SavedRememberAction> actions = new HashMap<String, SavedRememberAction>();

    public static AppletSecurityActions fromAction(Class<? extends RememberableDialog> id, SavedRememberAction s) {
        AppletSecurityActions asas = new AppletSecurityActions();
        asas.setAction(id, s);
        return asas;
    }

    public static AppletSecurityActions fromString(String s) {
        if (s == null) {
            s = "";
        }
        s = s.trim();
        AppletSecurityActions asas = new AppletSecurityActions();
        if (s.isEmpty()) {
            return asas;
        }
        if (s.contains(";") || s.contains(":") || s.contains("{") || s.contains("}")) {
            String[] ss;
            for (String string : ss = s.split("};")) {
                if ((string = string.trim()).isEmpty()) continue;
                int nameIndex = string.indexOf(":");
                int valueIndex = string.indexOf("{");
                if (nameIndex < 0 || valueIndex < 0) continue;
                String name = string.substring(0, nameIndex);
                String action = string.substring(nameIndex + 1, valueIndex);
                String value = string.substring(valueIndex + 1);
                if (value.isEmpty()) {
                    value = null;
                }
                asas.actions.put(name, new SavedRememberAction(ExecuteAppletAction.fromChar(action.charAt(0)), value));
            }
            return asas;
        }
        return AppletSecurityActions.readLegacySave(s);
    }

    private static AppletSecurityActions readLegacySave(String s) {
        if (s == null) {
            s = "";
        }
        s = s.trim();
        AppletSecurityActions asas = new AppletSecurityActions();
        int i = 0;
        for (char x : s.toCharArray()) {
            SavedRememberAction sa;
            if (Character.isWhitespace(x) || x == '\u0002') break;
            if (x == 'X') {
                ++i;
                continue;
            }
            if (x == 's' || x == 'S') continue;
            char nwX = x;
            if (x == 's') {
                nwX = 'y';
            }
            if (x == 'S') {
                nwX = 'A';
            }
            ExecuteAppletAction q = ExecuteAppletAction.fromChar(nwX);
            if (i == 0) {
                sa = new SavedRememberAction(q, AppletSecurityActions.legacyToCurrent(x));
                asas.actions.put(AppletSecurityActions.classToKey(UnsignedAppletTrustWarningPanel.class), sa);
            } else if (i == 1) {
                sa = new SavedRememberAction(q, AppletSecurityActions.legacyToCurrent(x));
                asas.actions.put(AppletSecurityActions.classToKey(MatchingALACAttributePanel.class), sa);
            } else {
                OutputController.getLogger().log("Unknown saved legacy item on position " + i + " of char: " + x);
            }
            ++i;
        }
        return asas;
    }

    private static String legacyToCurrent(char q) {
        switch (q) {
            case 'A': 
            case 'y': {
                return "YES";
            }
            case 'N': 
            case 'n': {
                return "NO";
            }
            case 'S': 
            case 's': {
                return "SANDBOX";
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ExecuteAppletAction getAction(Class clazz) {
        return this.getAction(AppletSecurityActions.classToKey(clazz));
    }

    public ExecuteAppletAction getAction(String clazz) {
        SavedRememberAction o = this.getActionEntry(clazz);
        if (o == null) {
            return null;
        }
        return o.getAction();
    }

    public SavedRememberAction getActionEntry(Class clazz) {
        return this.getActionEntry(AppletSecurityActions.classToKey(clazz));
    }

    public SavedRememberAction getActionEntry(String clazz) {
        return this.actions.get(clazz);
    }

    public void setAction(Class clazz, SavedRememberAction a) {
        this.setAction(AppletSecurityActions.classToKey(clazz), a);
    }

    public void setAction(String i, SavedRememberAction a) {
        this.actions.put(i, a);
    }

    public void removeAction(Class clazz) {
        this.removeAction(AppletSecurityActions.classToKey(clazz));
    }

    public void removeAction(String i) {
        this.actions.remove(i);
    }

    public String toString() {
        return this.toShortString();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        Collection<Map.Entry<String, SavedRememberAction>> l = this.getEntries();
        for (Map.Entry<String, SavedRememberAction> a : l) {
            sb.append(a.getKey()).append(":").append(a.getValue().toLongString());
        }
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        Collection<Map.Entry<String, SavedRememberAction>> l = this.getEntries();
        for (Map.Entry<String, SavedRememberAction> a : l) {
            sb.append(a.getKey()).append(":").append(a.getValue().toShortString()).append(";");
        }
        return sb.toString();
    }

    public int getRealCount() {
        return this.actions.size();
    }

    public Collection<ExecuteAppletAction> getActions() {
        Collection<SavedRememberAction> col = this.actions.values();
        ArrayList<ExecuteAppletAction> l = new ArrayList<ExecuteAppletAction>(col.size());
        for (SavedRememberAction savedRememberAction : col) {
            l.add(savedRememberAction.getAction());
        }
        return l;
    }

    public Collection<Map.Entry<String, SavedRememberAction>> getEntries() {
        return this.actions.entrySet();
    }

    @Override
    public Iterator<SavedRememberAction> iterator() {
        return this.actions.values().iterator();
    }

    private static String classToKey(Class clazz) {
        return clazz.getSimpleName();
    }

    public void refresh(String aValue) {
        AppletSecurityActions nev = AppletSecurityActions.fromString(aValue);
        this.actions.clear();
        this.actions.putAll(nev.actions);
    }
}

