/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.map;

import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import ghidra.util.map.ValueMap;
import ghidra.util.map.ValueStoragePage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class IntValueMap
extends ValueMap<Integer> {
    private static final long serialVersionUID = 1L;

    public IntValueMap(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 4;
    }

    public void putInt(long index, int value) {
        ValueStoragePage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addInt(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public int getInt(long index) throws NoValueException {
        ValueStoragePage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getInt(this.getPageOffset(index));
        }
        throw noValueException;
    }

    @Override
    protected void moveIndex(long from, long to) {
        try {
            int value = this.getInt(from);
            this.remove(from);
            this.putInt(to, value);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        try {
            oos.writeInt(this.getInt(index));
        }
        catch (NoValueException e) {
            throw new AssertException(e.getMessage());
        }
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException {
        this.putInt(index, ois.readInt());
    }
}

