/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class InstallMetadataRequest
extends BSimQuery<ResponseInfo> {
    public String dbname;
    public String owner;
    public String description;
    public ResponseInfo installresponse;

    public InstallMetadataRequest() {
        super("installmetadata");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.installresponse = new ResponseInfo();
            this.response = this.installresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        if (this.dbname != null && this.dbname.length() != 0) {
            fwrite.append("<name>").append(XmlUtilities.escapeElementEntities((String)this.dbname)).append("</name>\n");
        }
        if (this.owner != null && this.owner.length() != 0) {
            fwrite.append("<owner>").append(XmlUtilities.escapeElementEntities((String)this.owner)).append("</owner>\n");
        }
        if (this.description != null && this.description.length() != 0) {
            fwrite.append("<description>").append(XmlUtilities.escapeElementEntities((String)this.description)).append("</description>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.dbname = null;
        this.owner = null;
        this.description = null;
        parser.start(new String[]{this.name});
        while (parser.peek().isStart()) {
            XmlElement start = parser.start(new String[0]);
            String elname = start.getName();
            String val = parser.end().getText();
            if (elname.equals("name")) {
                this.dbname = val;
                continue;
            }
            if (elname.equals("owner")) {
                this.owner = val;
                continue;
            }
            if (!elname.equals("description")) continue;
            this.description = val;
        }
        parser.end();
    }
}

