/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.formatt.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationContext;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class AARCH64_CoffRelocationHandler
implements CoffRelocationHandler {
    public static final short IMAGE_REL_ARM64_ABSOLUTE = 0;
    public static final short IMAGE_REL_ARM64_ADDR32 = 1;
    public static final short IMAGE_REL_ARM64_ADDR32NB = 2;
    public static final short IMAGE_REL_ARM64_BRANCH26 = 3;
    public static final short IMAGE_REL_ARM64_PAGEBASE_REL21 = 4;
    public static final short IMAGE_REL_ARM64_REL21 = 5;
    public static final short IMAGE_REL_ARM64_PAGEOFFSET_12A = 6;
    public static final short IMAGE_REL_ARM64_PAGEOFFSET_12L = 7;
    public static final short IMAGE_REL_ARM64_SECREL = 8;
    public static final short IMAGE_REL_ARM64_SECREL_LOW12A = 9;
    public static final short IMAGE_REL_ARM64_SECREL_HIGH12A = 10;
    public static final short IMAGE_REL_ARM64_SECREL_LOW12L = 11;
    public static final short IMAGE_REL_ARM64_TOKEN = 12;
    public static final short IMAGE_REL_ARM64_SECTION = 13;
    public static final short IMAGE_REL_ARM64_ADDR64 = 14;
    public static final short IMAGE_REL_ARM64_BRANCH19 = 15;
    public static final short IMAGE_REL_ARM64_BRANCH14 = 16;
    public static final short IMAGE_REL_ARM64_REL32 = 17;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == -21916;
    }

    public RelocationResult relocate(Address address, CoffRelocation relocation, CoffRelocationContext relocationContext) throws MemoryAccessException, RelocationException {
        Program program = relocationContext.getProgram();
        Memory mem = program.getMemory();
        int byteLength = 4;
        int bytesToAdjust = mem.getInt(address);
        Address symbolAddr = relocationContext.getSymbolAddress(relocation);
        switch (relocation.getType()) {
            case 0: {
                return RelocationResult.SKIPPED;
            }
            case 2: {
                mem.setInt(address, (int)symbolAddr.getOffset());
                break;
            }
            case 3: {
                int instMask = -67108864;
                bytesToAdjust &= instMask;
                int displacement = (int)symbolAddr.subtract(address);
                displacement >>= 2;
                mem.setInt(address, bytesToAdjust |= (displacement &= ~instMask));
                break;
            }
            case 4: {
                long base = address.getOffset() & 0xFFFFFFFFFFFFF000L;
                long offset = symbolAddr.getOffset() - base;
                int immlo = (int)(offset >>= 12) & 3;
                int immhi = (int)(offset >>= 2) & 0x7FFFF;
                int instMask = -1627389921;
                bytesToAdjust &= instMask;
                bytesToAdjust = bytesToAdjust | immhi << 5 | immlo << 29;
                mem.setInt(address, bytesToAdjust);
                break;
            }
            case 6: {
                long offset = symbolAddr.getOffset() & 0xFFFL;
                int instMask = -4193281;
                bytesToAdjust &= instMask;
                bytesToAdjust = (int)((long)bytesToAdjust | offset << 10);
                mem.setInt(address, bytesToAdjust);
                break;
            }
            case 7: {
                int size = bytesToAdjust >>> 30;
                long offset = symbolAddr.getOffset() & 0xFFFL;
                int instMask = -4193281;
                bytesToAdjust &= instMask;
                bytesToAdjust = (int)((long)bytesToAdjust | (offset >>= size) << 10);
                mem.setInt(address, bytesToAdjust);
                break;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

