/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.hash.FidHasher;
import ghidra.feature.fid.plugin.HashLookupListMode;
import ghidra.feature.fid.service.FIDFixedSizeMRUCachingFactory;
import ghidra.feature.fid.service.FidHasherFactory;
import ghidra.feature.fid.service.FidMatch;
import ghidra.feature.fid.service.FidMatchImpl;
import ghidra.feature.fid.service.FidMatchScore;
import ghidra.feature.fid.service.FidSearchResult;
import ghidra.feature.fid.service.HashFamily;
import ghidra.feature.fid.service.HashMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class FidProgramSeeker {
    private static final Comparator<HashMatch> MOST_SIGNIFICANT = new Comparator<HashMatch>(){

        @Override
        public int compare(HashMatch o1, HashMatch o2) {
            return o1.getOverallScore() < o2.getOverallScore() ? 1 : (o1.getOverallScore() > o2.getOverallScore() ? -1 : 0);
        }
    };
    public final int MAX_NUM_PARENTS_FOR_SCORE = 500;
    private final int MAX_CACHE_SIZE = 2000000;
    private final float scoreThreshold;
    private final int mediumHashCodeUnitLengthLimit;
    private final FidQueryService fidQueryService;
    private final Program program;
    private final FIDFixedSizeMRUCachingFactory cacheFactory;

    public FidProgramSeeker(FidQueryService fidQueryService, Program program, FidHasher hasher, byte shortHashCodeUnitLength, byte mediumHashCodeUnitLengthLimit, float scoreThreshold) {
        this.fidQueryService = fidQueryService;
        this.program = program;
        this.scoreThreshold = scoreThreshold;
        this.mediumHashCodeUnitLengthLimit = mediumHashCodeUnitLengthLimit;
        FidHasherFactory factory = new FidHasherFactory(hasher);
        int cacheSize = program.getFunctionManager().getFunctionCount();
        cacheSize = cacheSize < 100 ? 100 : cacheSize;
        cacheSize = cacheSize > 2000000 ? 2000000 : cacheSize;
        this.cacheFactory = new FIDFixedSizeMRUCachingFactory(factory, cacheSize);
    }

    public static ArrayList<Function> getChildren(Function function, boolean followThunks) {
        Program program = function.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        HashSet<Address> alreadyDone = new HashSet<Address>();
        ArrayList<Function> funcList = new ArrayList<Function>();
        AddressIterator referenceIterator = referenceManager.getReferenceSourceIterator(function.getBody(), true);
        for (Address address : referenceIterator) {
            Reference[] referencesFrom;
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                Function child;
                Address toAddress = reference.getToAddress();
                if (!reference.getReferenceType().isCall() || alreadyDone.contains(toAddress) || (child = functionManager.getFunctionContaining(toAddress)) == null) continue;
                if (followThunks && child.isThunk()) {
                    child = child.getThunkedFunction(true);
                }
                funcList.add(child);
                alreadyDone.add(toAddress);
            }
        }
        return funcList;
    }

    private void addChildren(HashFamily family, Function function, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        ArrayList<Function> children = FidProgramSeeker.getChildren(function, true);
        for (Function relation : children) {
            monitor.checkCancelled();
            FidHashQuad hash = this.cacheFactory.get(relation);
            if (hash == null) continue;
            family.addChild(hash);
        }
    }

    public static ArrayList<Function> getParents(Function function, boolean followThunks) {
        Program program = function.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        HashSet<Address> alreadyDone = new HashSet<Address>();
        ArrayList<Function> funcList = new ArrayList<Function>();
        int size = 0;
        Address curAddr = function.getEntryPoint();
        Address[] thunkAddresses = null;
        if (followThunks && (thunkAddresses = function.getFunctionThunkAddresses()) != null) {
            size = thunkAddresses.length;
        }
        int pos = -1;
        while (true) {
            ReferenceIterator referenceIterator = referenceManager.getReferencesTo(curAddr);
            for (Reference reference : referenceIterator) {
                Address entryPoint;
                Function par;
                Address fromAddress = reference.getFromAddress();
                if (!reference.getReferenceType().isCall() || (par = functionManager.getFunctionContaining(fromAddress)) == null || alreadyDone.contains(entryPoint = par.getEntryPoint())) continue;
                funcList.add(par);
                alreadyDone.add(entryPoint);
            }
            if (++pos >= size) break;
            curAddr = thunkAddresses[pos];
        }
        return funcList;
    }

    private void addParents(HashFamily family, Function function, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        ArrayList<Function> parents = FidProgramSeeker.getParents(function, true);
        for (Function relation : parents) {
            monitor.checkCancelled();
            FidHashQuad hash = this.cacheFactory.get(relation);
            if (hash == null) continue;
            family.addParent(hash);
        }
    }

    private FidSearchResult processMatches(Function function, HashFamily family, TaskMonitor monitor) throws CancelledException {
        List<HashMatch> hashMatches = this.lookupFamily(family, monitor);
        FidSearchResult searchResult = null;
        if (!hashMatches.isEmpty()) {
            if (hashMatches.size() == 1) {
                FidMatchScore hashMatch = hashMatches.get(0);
                searchResult = this.makeSingletonMatch(function, family, hashMatch);
            } else {
                ArrayList<HashMatch> culledHashMatches = new ArrayList<HashMatch>();
                culledHashMatches.add(hashMatches.get(0));
                float maxOverall = hashMatches.get(0).getOverallScore();
                for (int ii = 1; ii < hashMatches.size(); ++ii) {
                    monitor.checkCancelled();
                    HashMatch hashMatch = hashMatches.get(ii);
                    if (hashMatch.getOverallScore() < maxOverall) break;
                    culledHashMatches.add(hashMatch);
                }
                if (culledHashMatches.size() == 1) {
                    FidMatchScore hashMatch = (FidMatchScore)culledHashMatches.get(0);
                    searchResult = this.makeSingletonMatch(function, family, hashMatch);
                } else {
                    searchResult = this.makeAllMatches(function, family, culledHashMatches, monitor);
                }
            }
        }
        return searchResult;
    }

    private FidSearchResult makeAllMatches(Function function, HashFamily family, ArrayList<HashMatch> culledHashMatches, TaskMonitor monitor) throws CancelledException {
        ArrayList<FidMatch> fidMatches = new ArrayList<FidMatch>();
        for (FidMatchScore fidMatchScore : culledHashMatches) {
            monitor.checkCancelled();
            FidMatchImpl match = new FidMatchImpl(this.fidQueryService.getLibraryForFunction(fidMatchScore.getFunctionRecord()), function.getEntryPoint(), fidMatchScore);
            fidMatches.add(match);
        }
        return new FidSearchResult(function, family.getHash(), fidMatches);
    }

    private FidSearchResult makeSingletonMatch(Function function, HashFamily family, FidMatchScore hashMatch) {
        LibraryRecord library = this.fidQueryService.getLibraryForFunction(hashMatch.getFunctionRecord());
        FidMatchImpl match = new FidMatchImpl(library, function.getEntryPoint(), hashMatch);
        return new FidSearchResult(function, family.getHash(), Collections.singletonList(match));
    }

    private HashFamily getFamily(Function function, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Address address = function.getEntryPoint();
        FidHashQuad hash = this.cacheFactory.get(function);
        if (hash == null) {
            return null;
        }
        HashFamily family = new HashFamily(address, hash);
        this.addChildren(family, function, monitor);
        this.addParents(family, function, monitor);
        return family;
    }

    private HashMatch scoreMatch(FunctionRecord functionRecord, HashFamily family, TaskMonitor monitor) throws CancelledException {
        if (functionRecord.autoFail()) {
            return null;
        }
        int functionCodeUnits = functionRecord.getCodeUnitSize();
        byte specificCodeUnits = 0;
        HashLookupListMode mode = HashLookupListMode.FULL;
        if (functionRecord.getSpecificHash() == family.getHash().getSpecificHash()) {
            specificCodeUnits = functionRecord.getSpecificHashAdditionalSize();
            mode = HashLookupListMode.SPECIFIC;
        }
        if (functionRecord.isForceSpecific() && mode != HashLookupListMode.SPECIFIC) {
            return null;
        }
        if (functionRecord.autoPass() && functionCodeUnits < this.mediumHashCodeUnitLengthLimit) {
            functionCodeUnits = this.mediumHashCodeUnitLengthLimit;
        }
        int childCodeUnits = 0;
        for (FidHashQuad fidHashQuad : family.getChildren()) {
            monitor.checkCancelled();
            if (!this.fidQueryService.getSuperiorFullRelation(functionRecord, fidHashQuad)) continue;
            childCodeUnits += fidHashQuad.getCodeUnitSize();
        }
        if (functionRecord.isForceRelation() && childCodeUnits == 0) {
            return null;
        }
        int parentCodeUnits = 0;
        if (family.getParents().size() < 500) {
            for (FidHashQuad fidHashQuad : family.getParents()) {
                monitor.checkCancelled();
                if (!this.fidQueryService.getInferiorFullRelation(fidHashQuad, functionRecord)) continue;
                parentCodeUnits += fidHashQuad.getCodeUnitSize();
            }
        }
        float f = functionCodeUnits;
        float childScore = childCodeUnits;
        float parentScore = parentCodeUnits;
        if ((f = (float)((double)f + 0.67 * (double)specificCodeUnits)) + childScore + parentScore < this.scoreThreshold) {
            return null;
        }
        HashMatch result = new HashMatch(functionRecord, f, mode, childScore, parentScore);
        return result;
    }

    private List<HashMatch> lookupFamily(HashFamily family, TaskMonitor monitor) throws CancelledException {
        ArrayList<HashMatch> result = new ArrayList<HashMatch>();
        List<FunctionRecord> functionsByFullHash = this.fidQueryService.findFunctionsByFullHash(family.getHash().getFullHash());
        for (FunctionRecord functionRecord : functionsByFullHash) {
            monitor.checkCancelled();
            HashMatch match = this.scoreMatch(functionRecord, family, monitor);
            if (match == null) continue;
            result.add(match);
        }
        Collections.sort(result, MOST_SIGNIFICANT);
        return result;
    }

    public FidSearchResult searchFunction(Function function, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        HashFamily family = this.getFamily(function, monitor);
        FidSearchResult fidResult = null;
        if (family != null && (fidResult = this.processMatches(function, family, monitor)) == null) {
            fidResult = new FidSearchResult(function, family.getHash(), null);
        }
        return fidResult;
    }

    public List<FidSearchResult> search(TaskMonitor monitor) throws CancelledException {
        LinkedList<FidSearchResult> result = new LinkedList<FidSearchResult>();
        FunctionManager functionManager = this.program.getFunctionManager();
        monitor.initialize((long)functionManager.getFunctionCount());
        FunctionIterator functions = functionManager.getFunctions(true);
        for (Function function : functions) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            try {
                FidSearchResult searchResult;
                HashFamily family = this.getFamily(function, monitor);
                if (family == null || (searchResult = this.processMatches(function, family, monitor)) == null) continue;
                result.add(searchResult);
            }
            catch (MemoryAccessException e) {
                Msg.showError((Object)this, null, (String)"Memory Access Exception", (Object)"Internal error, degenerate unhashable function");
            }
        }
        return result;
    }
}

