/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.target;

import docking.ActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractTarget
implements Target {
    protected final PluginTool tool;

    public AbstractTarget(PluginTool tool) {
        this.tool = tool;
    }

    public PluginTool getTool() {
        return this.tool;
    }

    private Address staticToDynamicAddress(ProgramLocation location) {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return null;
        }
        ProgramLocation dynLoc = mappingService.getDynamicLocationFromStatic((TraceProgramView)this.getTrace().getProgramView(), location);
        if (dynLoc == null) {
            return null;
        }
        return dynLoc.getByteAddress();
    }

    protected Address findAddress(Navigatable nav) {
        ProgramLocation location = nav.getLocation();
        if (location == null) {
            return null;
        }
        if (nav.isDynamic()) {
            return location.getAddress();
        }
        return this.staticToDynamicAddress(location);
    }

    protected Address findAddress(MarkerLocation location) {
        if (location.getProgram() instanceof TraceProgramView) {
            return location.getAddr();
        }
        return this.staticToDynamicAddress(new ProgramLocation(location.getProgram(), location.getAddr()));
    }

    protected Address findAddress(ActionContext context) {
        Address address;
        MarkerLocation ml;
        NavigatableActionContext ctx;
        Object address2;
        if (context instanceof NavigatableActionContext && (address2 = this.findAddress((ctx = (NavigatableActionContext)context).getNavigatable())) != null) {
            return address2;
        }
        if (context != null && (address2 = context.getContextObject()) instanceof MarkerLocation && (address2 = this.findAddress(ml = (MarkerLocation)address2)) != null) {
            return address2;
        }
        DebuggerListingService listingService = (DebuggerListingService)this.tool.getService(DebuggerListingService.class);
        if (listingService != null && (address2 = this.findAddress(listingService.getNavigatable())) != null) {
            return address2;
        }
        CodeViewerService codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        if (codeViewerService != null && (address = this.findAddress(codeViewerService.getNavigatable())) != null) {
            return address;
        }
        return null;
    }

    protected AddressRange singleRange(AddressSetView set) {
        if (set == null || set.getNumAddressRanges() != 1) {
            return null;
        }
        return set.getFirstRange();
    }

    protected AddressRange findRange(Navigatable nav) {
        if (nav.isDynamic()) {
            return this.singleRange((AddressSetView)nav.getSelection());
        }
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return null;
        }
        long snap = this.getSnap();
        AddressSet result = new AddressSet();
        Map mapped = mappingService.getOpenMappedViews(nav.getProgram(), (AddressSetView)nav.getSelection());
        for (Map.Entry ent : mapped.entrySet()) {
            TraceSpan span = (TraceSpan)ent.getKey();
            if (span.getTrace() != this.getTrace() || span.getSpan().contains(snap)) continue;
            for (DebuggerStaticMappingService.MappedAddressRange mar : (Collection)ent.getValue()) {
                result.add(mar.getDestinationAddressRange());
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return this.singleRange((AddressSetView)result);
    }

    protected AddressRange findRange(ActionContext context) {
        AddressRange range;
        NavigatableActionContext ctx;
        AddressRange range2;
        if (context instanceof NavigatableActionContext && (range2 = this.findRange((ctx = (NavigatableActionContext)context).getNavigatable())) != null) {
            return range2;
        }
        DebuggerListingService listingService = (DebuggerListingService)this.tool.getService(DebuggerListingService.class);
        if (listingService != null && (range2 = this.findRange(listingService.getNavigatable())) != null) {
            return range2;
        }
        CodeViewerService codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        if (codeViewerService != null && (range = this.findRange(codeViewerService.getNavigatable())) != null) {
            return range;
        }
        return null;
    }

    protected static <T> T doSync(String name, Supplier<CompletableFuture<T>> supplier) throws InterruptedException, ExecutionException {
        if (Swing.isSwingThread()) {
            throw new AssertionError((Object)("Cannot " + name + " using Swing thread. Use a Task."));
        }
        CompletableFuture<T> future = supplier.get();
        return future.orTimeout(10000L, TimeUnit.MILLISECONDS).get();
    }

    protected static <T> T getSync(String name, Supplier<CompletableFuture<T>> supplier) {
        try {
            return AbstractTarget.doSync(name, supplier);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void runSync(String name, Supplier<CompletableFuture<Void>> supplier) {
        AbstractTarget.getSync(name, supplier);
    }

    protected static <T> T doSyncMonitored(TaskMonitor monitor, String name, Supplier<CompletableFuture<T>> supplier) throws CancelledException, InterruptedException, ExecutionException {
        monitor.checkCancelled();
        try {
            return AbstractTarget.doSync(name, supplier);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CancelledException) {
                CancelledException ce = (CancelledException)throwable;
                throw ce;
            }
            throw e;
        }
    }

    protected static <T> T getSyncMonitored(TaskMonitor monitor, String name, Supplier<CompletableFuture<T>> supplier) throws CancelledException {
        try {
            return AbstractTarget.doSyncMonitored(monitor, name, supplier);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void runSyncMonitored(TaskMonitor monitor, String name, Supplier<CompletableFuture<Void>> supplier) throws CancelledException {
        AbstractTarget.getSyncMonitored(monitor, name, supplier);
    }

    public String execute(String command, boolean toString) {
        return (String)AbstractTarget.getSync("execute", () -> this.executeAsync(command, toString));
    }

    public void activate(DebuggerCoordinates prev, DebuggerCoordinates coords) {
        AbstractTarget.runSync("activate", () -> this.activateAsync(prev, coords));
    }

    public void invalidateMemoryCaches() {
        AbstractTarget.runSync("invalidate memory caches", () -> this.invalidateMemoryCachesAsync());
    }

    public void readMemory(AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AbstractTarget.runSyncMonitored(monitor, "read memory", () -> this.readMemoryAsync(set, monitor));
    }

    public void writeMemory(Address address, byte[] data) {
        AbstractTarget.runSync("write memory", () -> this.writeMemoryAsync(address, data));
    }

    public void readRegisters(TracePlatform platform, TraceThread thread, int frame, Set<Register> registers) {
        AbstractTarget.runSync("read registers", () -> this.readRegistersAsync(platform, thread, frame, registers));
    }

    public CompletableFuture<Void> readRegistersAsync(TracePlatform platform, TraceThread thread, int frame, AddressSetView guestSet) {
        if (guestSet.isEmpty()) {
            return AsyncUtils.nil();
        }
        Set registers = TraceRegisterUtils.registersIntersecting((Language)platform.getLanguage(), (AddressSetView)guestSet);
        return this.readRegistersAsync(platform, thread, frame, registers);
    }

    public void readRegisters(TracePlatform platform, TraceThread thread, int frame, AddressSetView guestSet) {
        AbstractTarget.runSync("read registers", () -> this.readRegistersAsync(platform, thread, frame, guestSet));
    }

    public void writeRegister(TracePlatform platform, TraceThread thread, int frame, RegisterValue value) {
        AbstractTarget.runSync("write register", () -> this.writeRegisterAsync(platform, thread, frame, value));
    }

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        Register register = platform.getLanguage().getRegister(address, data.length);
        if (register == null) {
            throw new IllegalArgumentException("Cannot identify the (single) register to write: " + String.valueOf(address));
        }
        RegisterValue value = new RegisterValue(register, Utils.bytesToBigInteger((byte[])data, (int)data.length, (boolean)register.isBigEndian(), (boolean)false));
        return this.writeRegisterAsync(platform, thread, frame, value);
    }

    public void writeRegister(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        AbstractTarget.runSync("write register", () -> this.writeRegisterAsync(platform, thread, frame, address, data));
    }

    public void writeVariable(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        AbstractTarget.runSync("write variable", () -> this.writeVariableAsync(platform, thread, frame, address, data));
    }

    public void placeBreakpoint(AddressRange range, Set<TraceBreakpointKind> kinds, String condition, String commands) {
        AbstractTarget.runSync("place breakpoint", () -> this.placeBreakpointAsync(range, kinds, condition, commands));
    }

    public void deleteBreakpoint(TraceBreakpoint breakpoint) {
        AbstractTarget.runSync("delete breakpoint", () -> this.deleteBreakpointAsync(breakpoint));
    }

    public void toggleBreakpoint(TraceBreakpoint breakpoint, boolean enabled) {
        String msg = enabled ? "enable breakpoint" : "disable breakpoint";
        AbstractTarget.runSync(msg, () -> this.toggleBreakpointAsync(breakpoint, enabled));
    }

    public void forceTerminate() {
        AbstractTarget.runSync("force terminate", () -> this.forceTerminateAsync());
    }

    public void disconnect() {
        AbstractTarget.runSync("disconnect", () -> ((AbstractTarget)this).disconnectAsync());
    }
}

