/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.cart.CartInvalidARC4KeyException;
import ghidra.file.formats.cart.CartInvalidCartException;
import ghidra.file.formats.cart.CartV1Constants;
import ghidra.file.formats.cart.CartV1Decryptor;
import ghidra.file.formats.cart.CartV1File;
import ghidra.file.formats.cart.CartV1StreamDecompressor;
import ghidra.file.formats.cart.CartV1StreamDecryptor;
import ghidra.file.formats.cart.CartV1StreamHasher;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class CartV1PayloadExtractor {
    private BinaryReader reader;
    private OutputStream tempFos;
    private CartV1File cartFile;

    public CartV1PayloadExtractor(ByteProvider byteProvider, OutputStream os, CartV1File cartFile) throws IOException {
        this(new BinaryReader(byteProvider, true), os, cartFile);
    }

    public CartV1PayloadExtractor(BinaryReader reader, OutputStream os, CartV1File cartFile) throws IOException {
        if (!reader.isLittleEndian()) {
            throw new IOException("CaRT BinaryReader must be Little-Endian.");
        }
        this.reader = reader;
        this.tempFos = os;
        this.cartFile = cartFile;
    }

    public void extract(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.setMessage("Reading CaRT data");
        ByteProviderWrapper subProvider = new ByteProviderWrapper(this.reader.getByteProvider(), this.cartFile.getDataOffset(), this.cartFile.getPackedSize());
        InputStream is = subProvider.getInputStream(0L);
        CartV1StreamHasher hashedInputStream = null;
        try {
            is = new CartV1StreamDecryptor(is, this.cartFile.getDecryptor().getARC4Key());
            is = new CartV1StreamDecompressor(is);
            hashedInputStream = new CartV1StreamHasher(is, this.cartFile);
        }
        catch (CartInvalidCartException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        FSUtilities.streamCopy((InputStream)hashedInputStream, (OutputStream)this.tempFos, (TaskMonitor)monitor);
        monitor.setMessage("Checking hashes...");
        try {
            hashedInputStream.checkHashes();
        }
        catch (CartInvalidCartException e) {
            throw new IOException("Invalid CaRT ARC4 hashes: " + e.getMessage());
        }
    }

    public static boolean testExtraction(BinaryReader reader, CartV1File cartFile, byte[] arc4Key) throws IOException, CartInvalidCartException, CartInvalidARC4KeyException, CancelledException {
        byte[] encryptedAndCompressedData;
        byte[] compressedData;
        if (cartFile.getDataOffset() <= 0L) {
            throw new CartInvalidCartException("Bad CaRT payload data offset");
        }
        int length = (int)cartFile.getPackedSize();
        if (length > 64) {
            length = 64;
        }
        if ((compressedData = CartV1Decryptor.decrypt(arc4Key, encryptedAndCompressedData = reader.readByteArray(cartFile.getDataOffset(), length))) != null) {
            compressedData = Arrays.copyOfRange(compressedData, 0, 2);
            for (byte[] zlibBytes : CartV1Constants.ZLIB_HEADER_BYTES) {
                if (!Arrays.equals(compressedData, zlibBytes)) continue;
                return true;
            }
        }
        return false;
    }
}

