/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.ValidatableLine;
import ghidra.program.model.data.DataType;
import ghidra.util.UniversalID;
import java.awt.Color;
import java.util.Objects;

public class VariableTextLine
implements ValidatableLine {
    private String variableType;
    private String variableName;
    private DataType dataType;
    private Color variableTypeColor;
    private Color variableNameColor;
    private ValidatableLine validationLine;

    public VariableTextLine(String variableType, String variableName, DataType dataType) {
        if (variableName == null) {
            variableName = "";
        }
        this.variableType = Objects.requireNonNull(variableType, "Variable type cannot be null");
        this.variableName = variableName;
        this.dataType = dataType;
    }

    @Override
    public ValidatableLine copy() {
        return new VariableTextLine(this.variableType, this.variableName, this.dataType);
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean hasUniversalId() {
        if (this.dataType == null) {
            return false;
        }
        UniversalID id = this.dataType.getUniversalID();
        return id != null && id.getValue() != 0L;
    }

    @Override
    public boolean isDiffColored() {
        return this.getVariableTypeColor() != null || this.getVariableNameColor() != null;
    }

    public Color getVariableTypeColor() {
        return this.variableTypeColor;
    }

    public Color getVariableNameColor() {
        return this.variableNameColor;
    }

    boolean matchesName(String otherName) {
        return this.variableName.equals(otherName);
    }

    boolean matchesType(String otherType) {
        return this.variableType.equals(otherType);
    }

    @Override
    public boolean isValidated() {
        return this.validationLine != null;
    }

    @Override
    public String getText() {
        return this.variableType + " " + this.variableName;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public boolean matches(ValidatableLine otherValidatableLine) {
        if (otherValidatableLine == null) {
            return false;
        }
        if (!(otherValidatableLine instanceof VariableTextLine)) {
            return false;
        }
        VariableTextLine otherLine = (VariableTextLine)otherValidatableLine;
        if (!otherLine.matchesType(this.variableType)) {
            return false;
        }
        if (!otherLine.matchesName(this.variableName)) {
            return false;
        }
        return otherLine.matchesType(this.variableType) && otherLine.matchesName(this.variableName);
    }

    @Override
    public void updateColor(ValidatableLine otherValidatableLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherValidatableLine == null) {
            this.variableTypeColor = invalidColor;
            this.variableNameColor = invalidColor;
            return;
        }
        if (!(otherValidatableLine instanceof VariableTextLine)) {
            otherValidatableLine.setTextColor(invalidColor);
            return;
        }
        VariableTextLine otherLine = (VariableTextLine)otherValidatableLine;
        if (!otherLine.matchesType(this.variableType)) {
            this.variableTypeColor = invalidColor;
            otherLine.variableTypeColor = invalidColor;
        }
        if (!otherLine.matchesName(this.variableName)) {
            this.variableNameColor = invalidColor;
            otherLine.variableNameColor = invalidColor;
        }
    }

    @Override
    public void setTextColor(Color color) {
        this.setAllColors(color);
    }

    void setAllColors(Color color) {
        this.variableTypeColor = color;
        this.variableNameColor = color;
    }

    @Override
    public void setValidationLine(ValidatableLine line) {
        if (this.validationLine == line) {
            return;
        }
        this.validationLine = line;
        line.setValidationLine(this);
        this.updateColor(line, INVALID_COLOR);
    }
}

