/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LinkerOptionCommand
extends LoadCommand {
    private long count;
    private List<String> linkerOptions;

    LinkerOptionCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.count = this.checkCount(reader.readNextUnsignedInt());
        this.linkerOptions = new ArrayList<String>();
        BinaryReader stringReader = reader.clone();
        int i = 0;
        while ((long)i < this.count) {
            String str = stringReader.readNextAsciiString();
            this.linkerOptions.add(str);
            ++i;
        }
    }

    public List<String> getLinkerOptions() {
        return this.linkerOptions;
    }

    @Override
    public String getCommandName() {
        return "linker_option_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "count", null);
        return struct;
    }
}

