/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.misc;

import generic.theme.GThemeDefaults;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class RegisterField
extends JTextField {
    private int bitSize;
    private Long currentValue;
    private long maxValue;
    private PlainDocument doc;
    private boolean inFocus;
    private boolean skipFilter;
    private ChangeListener listener;
    private Color noValueColor = GThemeDefaults.Colors.FOREGROUND_DISABLED;
    private Color valueColor = GThemeDefaults.Colors.FOREGROUND;
    private boolean useNoValue;

    public RegisterField(int bitSize, Long initialValue) {
        this(bitSize, initialValue, true);
    }

    public RegisterField(int bitSize, Long initialValue, boolean useNoValue) {
        this.useNoValue = useNoValue;
        this.setBitSize(bitSize);
        this.doc = new PlainDocument();
        this.doc.setDocumentFilter(new MyDocFilter());
        this.setDocument(this.doc);
        this.doSetValue(initialValue);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent ev) {
                RegisterField.this.inFocus = true;
                RegisterField.this.doSetValue(RegisterField.this.currentValue);
            }

            @Override
            public void focusLost(FocusEvent ev) {
                RegisterField.this.inFocus = false;
                RegisterField.this.doSetValue(RegisterField.this.currentValue);
            }
        });
    }

    public Long getValue() {
        return this.currentValue;
    }

    public void setNoValueColor(Color c) {
        this.noValueColor = c;
        this.updateColor();
    }

    public void setValueColor(Color c) {
        this.valueColor = c;
        this.updateColor();
    }

    private void updateColor() {
        if (this.inFocus || this.currentValue != null) {
            this.setForeground(this.valueColor);
            this.setHorizontalAlignment(2);
        } else {
            this.setForeground(this.noValueColor);
            this.setHorizontalAlignment(0);
        }
    }

    public void setBitSize(int bitSize) {
        this.bitSize = bitSize;
        boolean isValid = bitSize >= 1 && bitSize < 64;
        this.setEditable(isValid);
        this.setEnabled(isValid);
        this.useNoValue = true;
        if (isValid) {
            this.maxValue = (1L << bitSize) - 1L;
        } else {
            this.skipFilter = true;
            this.maxValue = 1L;
        }
        if (!this.isValidValue(this.getValue())) {
            this.doSetValue(null);
        }
    }

    public void setValue(Long value) {
        if (this.isEqual(value, this.currentValue)) {
            return;
        }
        this.doSetValue(value);
    }

    private void doSetValue(Long value) {
        if (value == null) {
            if (this.inFocus) {
                this.setTextField("");
            } else if (this.useNoValue) {
                this.setTextField("-- No Value --");
            } else {
                this.setTextField("");
            }
        } else {
            this.setTextField("0x" + Long.toHexString(value));
        }
        this.currentValue = value;
        this.updateColor();
    }

    private boolean isEqual(Long l1, Long l2) {
        if (l1 != null) {
            return l1.equals(l2);
        }
        return l2 == null;
    }

    private void setTextField(String text) {
        if (this.doc == null) {
            return;
        }
        this.skipFilter = true;
        try {
            this.doc.replace(0, this.doc.getLength(), text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.skipFilter = false;
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    private boolean processText() {
        String text = this.getText();
        if (text.length() == 0) {
            if (this.currentValue != null) {
                this.currentValue = null;
                this.notifyListeners();
            }
            return true;
        }
        if (text.equals("0x") || text.equals("0X")) {
            if (this.currentValue == null || this.currentValue != 0L) {
                this.currentValue = 0L;
                this.notifyListeners();
            }
            return true;
        }
        try {
            Long newValue;
            if (!text.startsWith("0x") && !text.startsWith("0X")) {
                while (text.length() > 1 && text.charAt(0) == '0') {
                    text = text.substring(1);
                }
            }
            if (this.isValidValue(newValue = Long.decode(text))) {
                if (!newValue.equals(this.currentValue)) {
                    this.currentValue = newValue;
                    this.notifyListeners();
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Toolkit.getDefaultToolkit().beep();
        return false;
    }

    private boolean isValidValue(Long value) {
        if (value == null) {
            return false;
        }
        long l = value;
        return l >= 0L && l <= this.maxValue;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JTextField("123"), "South");
        RegisterField rf = new RegisterField(1, 1L);
        panel.add((Component)rf, "Center");
        f.getContentPane().add(panel);
        f.pack();
        f.setVisible(true);
    }

    private void notifyListeners() {
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    class MyDocFilter
    extends DocumentFilter {
        MyDocFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (RegisterField.this.skipFilter) {
                super.insertString(fb, offset, string, attr);
                return;
            }
            String oldText = RegisterField.this.getText();
            fb.insertString(offset, string, attr);
            if (!RegisterField.this.processText()) {
                fb.replace(0, RegisterField.this.doc.getLength(), oldText, attr);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (RegisterField.this.skipFilter) {
                super.remove(fb, offset, length);
                return;
            }
            String oldText = RegisterField.this.getText();
            fb.remove(offset, length);
            if (!RegisterField.this.processText()) {
                fb.replace(0, RegisterField.this.doc.getLength(), oldText, null);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (RegisterField.this.skipFilter) {
                super.replace(fb, offset, length, text, attrs);
                return;
            }
            String oldText = RegisterField.this.getText();
            fb.replace(offset, length, text, attrs);
            if (!RegisterField.this.processText()) {
                fb.replace(0, RegisterField.this.doc.getLength(), oldText, attrs);
            }
        }
    }
}

