/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.ActionContext;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.ByModuleAutoMapSpec;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.LaunchFailureDialog;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLaunchDialog;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.app.plugin.core.debug.service.tracermi.DefaultTraceRmiAcceptor;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.terminal.TerminalListener;
import ghidra.app.services.DebuggerAutoMappingService;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.InternalTraceRmiService;
import ghidra.app.services.Terminal;
import ghidra.app.services.TerminalService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.action.AutoMapSpec;
import ghidra.debug.api.modules.DebuggerMissingProgramActionContext;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.tracermi.LaunchParameter;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.pty.Pty;
import ghidra.pty.PtyChild;
import ghidra.pty.PtyFactory;
import ghidra.pty.PtyParent;
import ghidra.pty.PtySession;
import ghidra.pty.ShellUtils;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;

public abstract class AbstractTraceRmiLaunchOffer
implements TraceRmiLaunchOffer {
    public static final String PREFIX_PARAM_EXTTOOL = "env:GHIDRA_LANG_EXTTOOL_";
    public static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    protected final TraceRmiLauncherServicePlugin plugin;
    protected final Program program;
    protected final PluginTool tool;
    protected final TerminalService terminalService;

    public AbstractTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program) {
        this.plugin = Objects.requireNonNull(plugin);
        this.program = program;
        this.tool = plugin.getTool();
        this.terminalService = Objects.requireNonNull((TerminalService)this.tool.getService(TerminalService.class));
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTraceRmiLaunchOffer other = (AbstractTraceRmiLaunchOffer)obj;
        return this.getConfigName().equals(other.getConfigName());
    }

    protected int getTimeoutMillis() {
        return 10000;
    }

    protected int getConnectionTimeoutMillis() {
        return this.getTimeoutMillis();
    }

    public Icon getIcon() {
        return DebuggerResources.ICON_DEBUGGER;
    }

    protected Address getMappingProbeAddress() {
        return DebuggerMissingProgramActionContext.getMappingProbeAddress((Program)this.program);
    }

    protected CompletableFuture<Void> listenForMapping(final DebuggerStaticMappingService mappingService, final TraceRmiConnection connection, final Trace trace) {
        Address probeAddress = this.getMappingProbeAddress();
        if (probeAddress == null) {
            return AsyncUtils.nil();
        }
        final ProgramLocation probe = new ProgramLocation(this.program, probeAddress);
        var result = new CompletableFuture<Void>(){
            DebuggerStaticMappingChangeListener listener = (affectedTraces, affectedPrograms) -> {
                if (!affectedPrograms.contains(AbstractTraceRmiLaunchOffer.this.program) && !affectedTraces.contains(trace)) {
                    return;
                }
                this.check();
            };

            protected void check() {
                long snap = connection.getLastSnapshot(trace);
                TraceLocation result = mappingService.getOpenMappedLocation(trace, probe, snap);
                if (result == null) {
                    return;
                }
                this.complete(null);
                mappingService.removeChangeListener(this.listener);
            }
        };
        mappingService.addChangeListener(result.listener);
        result.check();
        result.exceptionally(ex -> {
            mappingService.removeChangeListener(result.listener);
            return null;
        });
        return result;
    }

    protected boolean invokeMapper(TaskMonitor monitor, DebuggerStaticMappingService mappingService, TraceRmiConnection connection, Trace trace, AutoMapSpec spec) throws CancelledException {
        if (this.program == null) {
            return false;
        }
        long snap = connection.getLastSnapshot(trace);
        if (spec.performMapping(mappingService, trace, snap, List.of(this.program), monitor)) {
            return true;
        }
        try {
            mappingService.changesSettled().get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        Address probeAddress = this.getMappingProbeAddress();
        if (probeAddress == null) {
            return true;
        }
        ProgramLocation probe = new ProgramLocation(this.program, probeAddress);
        return mappingService.getOpenMappedLocation(trace, probe, snap) != null;
    }

    protected SaveState saveLauncherArgsToState(Map<String, ValStr<?>> args, Map<String, LaunchParameter<?>> params) {
        SaveState state = new SaveState();
        for (LaunchParameter<?> param : params.values()) {
            ValStr<?> val = args.get(param.name());
            if (val == null) continue;
            state.putString("param_" + param.name(), val.str());
        }
        return state;
    }

    protected void saveState(SaveState state) {
        this.plugin.writeToolLaunchConfig(this.getConfigName(), state);
        if (this.program == null) {
            return;
        }
        this.plugin.writeProgramLaunchConfig(this.program, this.getConfigName(), state);
    }

    protected void saveLauncherArgs(Map<String, ValStr<?>> args, Map<String, LaunchParameter<?>> params) {
        this.saveState(this.saveLauncherArgsToState(args, params));
    }

    protected Map<String, ValStr<?>> generateDefaultLauncherArgs(Map<String, LaunchParameter<?>> params) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry<String, LaunchParameter<?>> entry : params.entrySet()) {
            LaunchParameter<?> param = entry.getValue();
            map.put(entry.getKey(), ValStr.cast(Object.class, (ValStr)param.defaultValue()));
            if (!param.name().startsWith(PREFIX_PARAM_EXTTOOL)) continue;
            String tool = param.name().substring(PREFIX_PARAM_EXTTOOL.length());
            List names = this.program.getLanguage().getLanguageDescription().getExternalNames(tool);
            if (names == null || names.isEmpty()) continue;
            String toolName = (String)names.get(0);
            if (param.type() == String.class) {
                LaunchParameter<?> paramStr = param;
                paramStr.set(map, ValStr.str((String)toolName));
                continue;
            }
            if (param.type() == AutoConfigState.PathIsFile.class) {
                LaunchParameter<?> paramPIF = param;
                paramPIF.set(map, new ValStr((Object)AutoConfigState.PathIsFile.fromString((String)toolName), toolName));
                continue;
            }
            if (param.type() != AutoConfigState.PathIsDir.class) continue;
            LaunchParameter<?> paramPID = param;
            paramPID.set(map, new ValStr((Object)AutoConfigState.PathIsDir.fromString((String)toolName), toolName));
        }
        if (this.supportsImage() && this.program != null) {
            ImageParamSetter imageSetter = ImageParamSetter.get(this.imageParameter());
            imageSetter.setImage(map, this.program);
        }
        return map;
    }

    protected Map<String, ValStr<?>> promptLauncherArgs(TraceRmiLaunchOffer.LaunchConfigurator configurator, Throwable lastExc) {
        Map params = this.getParameters();
        TraceRmiLaunchDialog dialog = new TraceRmiLaunchDialog(this.tool, this.getTitle(), "Launch", this.getIcon());
        dialog.setDescription(this.getDescription());
        dialog.setHelpLocation(this.getHelpLocation());
        if (lastExc != null) {
            dialog.setStatusText(lastExc.toString(), MessageType.ERROR);
        } else {
            dialog.setStatusText("");
        }
        Map<String, ValStr<?>> defaultArgs = this.generateDefaultLauncherArgs(params);
        Map lastArgs = configurator.configureLauncher((TraceRmiLaunchOffer)this, this.loadLastLauncherArgs(true), TraceRmiLaunchOffer.RelPrompt.BEFORE);
        Map args = dialog.promptArguments(params, lastArgs, defaultArgs);
        if (args != null) {
            this.saveLauncherArgs(args, params);
        }
        return args;
    }

    protected Map<String, ValStr<?>> loadLastLauncherArgs(boolean forPrompt) {
        Map params = this.getParameters();
        Map<String, ValStr<?>> args = this.loadLauncherArgsFromState(this.loadState(forPrompt), params);
        this.saveLauncherArgs(args, params);
        return args;
    }

    protected Map<String, ValStr<?>> loadLauncherArgsFromState(SaveState state, Map<String, LaunchParameter<?>> params) {
        Map<String, ValStr<?>> defaultArgs = this.generateDefaultLauncherArgs(params);
        if (state == null) {
            return defaultArgs;
        }
        LinkedHashMap args = new LinkedHashMap();
        Set<String> names = Set.of(state.getNames());
        for (LaunchParameter<?> param : params.values()) {
            String key = "param_" + param.name();
            if (!names.contains(key)) {
                args.put(param.name(), defaultArgs.get(param.name()));
                continue;
            }
            String str = state.getString(key, null);
            if (str != null) {
                args.put(param.name(), param.decode(str));
                continue;
            }
            try {
                Object fallback = AutoConfigState.ConfigStateField.getState((SaveState)state, (Class)param.type(), (String)param.name());
                if (fallback != null) {
                    args.put(param.name(), ValStr.from((Object)fallback));
                    continue;
                }
                Msg.warn((Object)this, (Object)"Could not load saved launcher arg '%s' (%s)".formatted(param.name(), param.display()));
            }
            catch (Exception e) {
                Msg.warn((Object)this, (Object)"Could not load saved launcher arg '%s' (%s) - %s".formatted(param.name(), param.display(), e.getMessage()));
            }
        }
        return args;
    }

    protected SaveState loadState(boolean forPrompt) {
        SaveState state = this.plugin.readToolLaunchConfig(this.getConfigName());
        if (this.program == null) {
            return state;
        }
        return this.plugin.readProgramLaunchConfig(this.program, this.getConfigName(), forPrompt);
    }

    public Map<String, ValStr<?>> getLauncherArgs(boolean prompt, TraceRmiLaunchOffer.LaunchConfigurator configurator, Throwable lastExc) {
        return prompt ? configurator.configureLauncher((TraceRmiLaunchOffer)this, this.promptLauncherArgs(configurator, lastExc), TraceRmiLaunchOffer.RelPrompt.AFTER) : configurator.configureLauncher((TraceRmiLaunchOffer)this, this.loadLastLauncherArgs(false), TraceRmiLaunchOffer.RelPrompt.NONE);
    }

    public Map<String, ?> getLauncherArgs(boolean prompt) {
        return this.getLauncherArgs(prompt, TraceRmiLaunchOffer.LaunchConfigurator.NOP, null);
    }

    protected PtyFactory getPtyFactory() {
        return PtyFactory.local();
    }

    protected PtyTerminalSession runInTerminal(List<String> commandLine, Map<String, String> env, File workingDirectory, Collection<TerminalSession> subordinates) throws IOException {
        PtyFactory factory = this.getPtyFactory();
        Pty pty = factory.openpty();
        PtyParent parent = pty.getParent();
        final PtyChild child = pty.getChild();
        Terminal terminal = this.terminalService.createWithStreams((Plugin)this.plugin, Charset.forName("UTF-8"), parent.getInputStream(), parent.getOutputStream());
        List withoutPath = ShellUtils.removePath(commandLine);
        terminal.setSubTitle(ShellUtils.generateLine((List)withoutPath));
        TerminalListener resizeListener = new TerminalListener(){

            public void resized(short cols, short rows) {
                try {
                    child.setWindowSize(cols, rows);
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Could not resize pty: " + String.valueOf(e)));
                }
            }
        };
        terminal.addTerminalListener(resizeListener);
        env.put("TERM", "xterm-256color");
        PtySession session = pty.getChild().session((String[])commandLine.toArray(String[]::new), env, workingDirectory, new PtyChild.TermMode[0]);
        Thread waiter = new Thread(() -> {
            try {
                session.waitExited();
                terminal.terminated();
                pty.close();
                for (TerminalSession ss : subordinates) {
                    ss.terminate();
                }
            }
            catch (IOException | InterruptedException e) {
                Msg.error((Object)this, (Object)e);
            }
        }, "Waiter: " + this.getConfigName());
        waiter.start();
        PtyTerminalSession terminalSession = new PtyTerminalSession(terminal, pty, session, waiter);
        terminal.setTerminateAction(() -> this.tool.execute((Task)new TerminateSessionTask(terminalSession)));
        return terminalSession;
    }

    protected NullPtyTerminalSession nullPtyTerminal() throws IOException {
        PtyFactory factory = this.getPtyFactory();
        Pty pty = factory.openpty();
        PtyParent parent = pty.getParent();
        final PtyChild child = pty.getChild();
        Terminal terminal = this.terminalService.createWithStreams((Plugin)this.plugin, Charset.forName("UTF-8"), parent.getInputStream(), parent.getOutputStream());
        TerminalListener resizeListener = new TerminalListener(){

            public void resized(short cols, short rows) {
                child.setWindowSize(cols, rows);
            }
        };
        terminal.addTerminalListener(resizeListener);
        String name = pty.getChild().nullSession(new PtyChild.TermMode[0]);
        terminal.setSubTitle(name);
        NullPtyTerminalSession terminalSession = new NullPtyTerminalSession(terminal, pty, name);
        terminal.setTerminateAction(() -> this.tool.execute((Task)new TerminateSessionTask(terminalSession)));
        return terminalSession;
    }

    protected abstract void launchBackEnd(TaskMonitor var1, Map<String, TerminalSession> var2, Map<String, ValStr<?>> var3, SocketAddress var4) throws Exception;

    protected AutoMapSpec getAutoMapSpec() {
        DebuggerAutoMappingService auto = (DebuggerAutoMappingService)this.tool.getService(DebuggerAutoMappingService.class);
        return auto == null ? ByModuleAutoMapSpec.instance() : auto.getAutoMapSpec();
    }

    protected AutoMapSpec getAutoMapSpec(Trace trace) {
        DebuggerAutoMappingService auto = (DebuggerAutoMappingService)this.tool.getService(DebuggerAutoMappingService.class);
        return auto == null ? ByModuleAutoMapSpec.instance() : auto.getAutoMapSpec(trace);
    }

    protected boolean providesImage(Map<String, ValStr<?>> args) {
        LaunchParameter param = this.imageParameter();
        if (param == null) {
            return false;
        }
        return !"".equals(param.get(args).str());
    }

    protected void updateMonitorMax(TaskMonitor monitor, Map<String, ValStr<?>> args) {
        boolean image;
        AutoMapSpec spec = this.getAutoMapSpec();
        boolean bl = image = args == null ? this.supportsImage() : this.providesImage(args);
        if (image && spec.hasTask()) {
            monitor.setMaximum(6L);
        } else {
            monitor.setMaximum(5L);
        }
    }

    protected void waitForModuleMapping(TaskMonitor monitor, TraceRmiHandler connection, Trace trace) throws CancelledException, InterruptedException, ExecutionException, NoStaticMappingException {
        block6: {
            if (!this.requiresImage()) {
                return;
            }
            AutoMapSpec spec = this.getAutoMapSpec(trace);
            if (!spec.hasTask()) {
                return;
            }
            DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
            monitor.setMessage("Waiting for module mapping");
            try {
                this.listenForMapping(mappingService, connection, trace).get(this.getTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                boolean mapped;
                monitor.setMessage("Timed out waiting for module mapping. Invoking the mapper.");
                try {
                    mapped = this.invokeMapper(monitor, mappingService, connection, trace, spec);
                }
                catch (CancelledException ce) {
                    throw new CancellationException(e.getMessage());
                }
                if (mapped) break block6;
                throw new NoStaticMappingException("The resulting target process has no mapping to the static image.");
            }
        }
        monitor.increment();
    }

    public TraceRmiLaunchOffer.LaunchResult launchProgram(TaskMonitor monitor, TraceRmiLaunchOffer.LaunchConfigurator configurator) {
        if (this.requiresImage() && this.program == null) {
            throw new IllegalStateException("Offer requires image, but no program given.");
        }
        InternalTraceRmiService service = (InternalTraceRmiService)this.tool.getService(InternalTraceRmiService.class);
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        TraceRmiLaunchOffer.PromptMode mode = configurator.getPromptMode();
        boolean prompt = mode == TraceRmiLaunchOffer.PromptMode.ALWAYS;
        DefaultTraceRmiAcceptor acceptor = null;
        LinkedHashMap<String, TerminalSession> sessions = new LinkedHashMap<String, TerminalSession>();
        TraceRmiHandler connection = null;
        Trace trace = null;
        Throwable lastExc = null;
        this.updateMonitorMax(monitor, null);
        block15: while (true) {
            DebuggerConsoleService consoleService;
            try {
                monitor.setMessage("Gathering arguments");
                Map<String, ValStr<?>> args = this.getLauncherArgs(prompt, configurator, lastExc);
                if (args == null) {
                    if (lastExc == null) {
                        lastExc = new CancelledException();
                    }
                    return new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, acceptor, connection, trace, lastExc);
                }
                this.updateMonitorMax(monitor, args);
                monitor.increment();
                acceptor = null;
                sessions.clear();
                connection = null;
                trace = null;
                lastExc = null;
                monitor.setMessage("Listening for connection");
                acceptor = service.acceptOne(new InetSocketAddress("127.0.0.1", 0));
                monitor.increment();
                monitor.setMessage("Launching back-end");
                this.launchBackEnd(monitor, sessions, args, acceptor.getAddress());
                monitor.increment();
                monitor.setMessage("Waiting for connection");
                acceptor.setTimeout(this.getConnectionTimeoutMillis());
                connection = acceptor.accept();
                connection.registerTerminals(sessions.values());
                monitor.increment();
                monitor.setMessage("Waiting for trace");
                trace = connection.waitForTrace(this.getTimeoutMillis());
                traceManager.openTrace(trace);
                traceManager.activate(traceManager.resolveTrace(trace), DebuggerTraceManagerService.ActivationCause.TARGET_UPDATED);
                monitor.increment();
                this.waitForModuleMapping(monitor, connection, trace);
            }
            catch (CancelledException e) {
                lastExc = e;
                TraceRmiLaunchOffer.LaunchResult result = new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, acceptor, connection, trace, lastExc);
                try {
                    result.close();
                }
                catch (Exception e1) {
                    Msg.error((Object)this, (Object)"Could not close", (Throwable)e1);
                }
                return new TraceRmiLaunchOffer.LaunchResult(this.program, Map.of(), null, null, null, lastExc);
            }
            catch (NoStaticMappingException e) {
                consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
                if (consoleService == null) {
                    Msg.error((Object)this, (Object)e.getMessage());
                } else {
                    consoleService.log(DebuggerResources.ICON_MODULES, "<html>The trace <b>%s</b> has no mapping to its program <b>%s</b></html>".formatted(HTMLUtilities.escapeHTML((String)trace.getDomainFile().getName()), HTMLUtilities.escapeHTML((String)this.program.getDomainFile().getName())), (ActionContext)new DebuggerMissingProgramActionContext(trace, this.program));
                }
                return new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, acceptor, connection, trace, (Throwable)e);
            }
            catch (Exception e) {
                consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
                if (consoleService != null) {
                    consoleService.log(DebuggerResources.ICON_LOG_ERROR, "Launch %s Failed".formatted(this.getTitle()), (Throwable)e);
                }
                lastExc = e;
                prompt = mode != TraceRmiLaunchOffer.PromptMode.NEVER;
                TraceRmiLaunchOffer.LaunchResult result = new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, acceptor, connection, trace, lastExc);
                if (prompt) {
                    switch (this.promptError(result)) {
                        case KEEP: {
                            result.showTerminals();
                            return result;
                        }
                        case RETRY: {
                            try {
                                result.close();
                            }
                            catch (Exception e1) {
                                Msg.error((Object)this, (Object)"Could not close", (Throwable)e1);
                            }
                            continue block15;
                        }
                        case TERMINATE: {
                            try {
                                result.close();
                            }
                            catch (Exception e1) {
                                Msg.error((Object)this, (Object)"Could not close", (Throwable)e1);
                            }
                            return new TraceRmiLaunchOffer.LaunchResult(this.program, Map.of(), null, null, null, lastExc);
                        }
                    }
                    continue;
                }
                return result;
            }
            break;
        }
        return new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, (TraceRmiAcceptor)acceptor, (TraceRmiConnection)connection, trace, null);
    }

    protected LaunchFailureDialog.ErrPromptResponse promptError(TraceRmiLaunchOffer.LaunchResult result) {
        return LaunchFailureDialog.show(result, this.getHelpLocation());
    }

    static interface ImageParamSetter {
        public static ImageParamSetter get(LaunchParameter<?> param) {
            if (param.type() == String.class) {
                return new StringImageParamSetter(param);
            }
            if (param.type() == AutoConfigState.PathIsFile.class) {
                return new FileImageParamSetter(param);
            }
            Msg.warn(ImageParamSetter.class, (Object)("'Image' parameter has unsupported type: " + String.valueOf(param.type())));
            return null;
        }

        public void setImage(Map<String, ValStr<?>> var1, Program var2);
    }

    protected record PtyTerminalSession(Terminal terminal, Pty pty, PtySession session, Thread waiter) implements TerminalSession
    {
        public void terminate() throws IOException {
            this.terminal.terminated();
            this.session.destroyForcibly();
            this.pty.close();
            this.waiter.interrupt();
        }

        public String description() {
            return this.session.description();
        }
    }

    protected record NullPtyTerminalSession(Terminal terminal, Pty pty, String name) implements TerminalSession
    {
        public void terminate() throws IOException {
            this.terminal.terminated();
            this.pty.close();
        }

        public String description() {
            return this.name;
        }
    }

    public static class NoStaticMappingException
    extends Exception {
        public NoStaticMappingException(String message) {
            super(message);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    static class TerminateSessionTask
    extends Task {
        private final TerminalSession session;

        public TerminateSessionTask(TerminalSession session) {
            super("Terminate Session", false, false, false);
            this.session = session;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.session.close();
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Could not terminate: " + String.valueOf(e)), (Throwable)e);
            }
        }
    }

    static class FileImageParamSetter
    implements ImageParamSetter {
        private final LaunchParameter<AutoConfigState.PathIsFile> param;

        public FileImageParamSetter(LaunchParameter<AutoConfigState.PathIsFile> param) {
            this.param = param;
        }

        @Override
        public void setImage(Map<String, ValStr<?>> map, Program program) {
            String str = TraceRmiLauncherServicePlugin.getProgramPath(program, true);
            AutoConfigState.PathIsFile value = str == null ? null : new AutoConfigState.PathIsFile(Paths.get(str, new String[0]));
            this.param.set(map, new ValStr((Object)value, str));
        }
    }

    static class StringImageParamSetter
    implements ImageParamSetter {
        private final LaunchParameter<String> param;

        public StringImageParamSetter(LaunchParameter<String> param) {
            this.param = param;
        }

        @Override
        public void setImage(Map<String, ValStr<?>> map, Program program) {
            String value = TraceRmiLauncherServicePlugin.getProgramPath(program, false);
            this.param.set(map, ValStr.str((String)value));
        }
    }
}

